/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Line2D;
import javax.swing.JLabel;
import javax.swing.Timer;
import javax.swing.UIManager;

public class Clock
extends JLabel
implements ActionListener {
    public static final int ROUNDTIMEINMILIS = 1000;
    public static final int STEP = 5;
    private int secs = 0;
    private int endingSecs;
    private int turns;
    private Timer moveTimer = new Timer(83, this);

    public Clock() {
        this.moveTimer.setInitialDelay(83);
    }

    public void reset() {
        this.secs = 0;
        this.turns = 0;
        this.repaint();
    }

    public void start() {
        this.moveTimer.restart();
    }

    public void stop() {
        this.moveTimer.stop();
    }

    public int getNumOfTurns() {
        return this.turns;
    }

    public void setEndingSecs(int n) {
        this.endingSecs = n;
    }

    public int getEndingSecs() {
        return this.endingSecs;
    }

    public int getSecs() {
        return this.secs;
    }

    public void setSecs(int n) {
        int n2;
        this.secs = n;
        for (n2 = n; n2 > 60; n2 -= 60) {
        }
        if (n2 == 60) {
            ++this.turns;
            this.firePropertyChange("turn", null, null);
        }
        this.repaint();
        if (n == this.endingSecs) {
            this.firePropertyChange("secs", null, null);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        new Thread(){

            public void run() {
                Clock.this.setSecs(Clock.this.getSecs() + 5);
            }
        }.start();
    }

    public int drawingW() {
        return this.getWidth() - 1;
    }

    public int drawingH() {
        return this.getHeight() - 1;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n = this.drawingW();
        int n2 = this.drawingH();
        graphics2D.setColor((Color)UIManager.getDefaults().get("Button.focus"));
        graphics2D.fillOval(0, 0, n, n2);
        graphics2D.setColor(Color.black);
        graphics2D.drawOval(0, 0, n, n2);
        graphics2D.drawLine(n / 2 + 1, 1, n / 2 + 1, n2);
        graphics2D.drawLine(1, n2 / 2 + 1, n, n2 / 2 + 1);
        double d = -6 * this.secs + 90;
        double d2 = Math.PI * d / 180.0;
        double d3 = (double)n / 2.0;
        double d4 = d3 * Math.cos(d2);
        double d5 = d3 * Math.sin(d2);
        int n3 = (int)Math.rint(d4 + d3);
        int n4 = (int)Math.rint(-d5 + d3);
        this.drawArrow(n / 2 + 2, n / 2 + 2, n3, n4, 0, graphics2D, true);
        graphics2D.setColor(Color.gray);
        graphics2D.fillOval(n / 2 - 6, n2 / 2 - 6, 16, 16);
        graphics2D.setColor(Color.black);
        graphics2D.drawOval(n / 2 - 6, n2 / 2 - 6, 16, 16);
    }

    private void drawArrow(int n, int n2, int n3, int n4, int n5, Graphics2D graphics2D, boolean bl) {
        Point point = Utils2D.offset2D(n, n2, n3, n4, n5, 0);
        Point point2 = Utils2D.offset2D(n, n2, n3, n4, n5 + 10, 4);
        Point point3 = Utils2D.offset2D(n, n2, n3, n4, n5 + 10, -4);
        graphics2D.draw(new Line2D.Double(n, n2, point.x, point.y));
        graphics2D.draw(new Line2D.Double(point.x, point.y, point2.x, point2.y));
        graphics2D.draw(new Line2D.Double(point.x, point.y, point3.x, point3.y));
        if (bl) {
            int[] nArray = new int[]{point.x, point2.x, point3.x};
            int[] nArray2 = new int[]{point.y, point2.y, point3.y};
            graphics2D.fillPolygon(nArray, nArray2, 3);
        }
    }
}

