/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;

public class BasicPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    private int numOfDigits;
    private Column[] cols;
    private int mode;
    private boolean paintHolds;
    private static final String[] tooltips = new String[]{"\u03bc\u03bf\u03bd\u03ac\u03b4\u03b5\u03c2", "\u03b4\u03b5\u03ba\u03ac\u03b4\u03b5\u03c2", "\u03b5\u03ba\u03b1\u03c4\u03bf\u03bd\u03c4\u03ac\u03b4\u03b5\u03c2", "\u03c7\u03b9\u03bb\u03b9\u03ac\u03b4\u03b5\u03c2", "\u03b4\u03b5\u03ba\u03ac\u03b4\u03b5\u03c2 \u03c7\u03b9\u03bb\u03b9\u03ac\u03b4\u03b5\u03c2", "\u03b5\u03ba\u03b1\u03c4\u03bf\u03bd\u03c4\u03ac\u03b4\u03b5\u03c2 \u03c7\u03b9\u03bb\u03b9\u03ac\u03b4\u03b5\u03c2", "\u03b5\u03ba\u03b1\u03c4\u03bf\u03bc\u03bc\u03cd\u03c1\u03b9\u03b1", "\u03b4\u03b5\u03ba\u03ac\u03b4\u03b5\u03c2 \u03b5\u03ba\u03ba\u03b1\u03c4\u03bf\u03bc\u03bc\u03cd\u03c1\u03b9\u03b1", "\u03b5\u03ba\u03b1\u03c4\u03bf\u03bd\u03c4\u03ac\u03b4\u03b5\u03c2 \u03b5\u03ba\u03b1\u03c4\u03bf\u03bc\u03bc\u03cd\u03c1\u03b9\u03b1"};
    private static final Font basicFont = new Font("Tahoma", 0, 12);
    private static final int MARGIN = 5;
    private static final int SPACE = 10;
    private static final int BOXHEIGHT = 20;
    private static final int BOXWIDTH = 60;
    private static final int R = 16;
    private static final Image blueImg = Toolkit.getDefaultToolkit().createImage((class$BasicPanel == null ? (class$BasicPanel = BasicPanel.class$("BasicPanel")) : class$BasicPanel).getResource("/icons/blue.gif"));
    private static final Image redImg = Toolkit.getDefaultToolkit().createImage((class$BasicPanel == null ? (class$BasicPanel = BasicPanel.class$("BasicPanel")) : class$BasicPanel).getResource("/icons/red.gif"));
    private static final Image yellowImg = Toolkit.getDefaultToolkit().createImage((class$BasicPanel == null ? (class$BasicPanel = BasicPanel.class$("BasicPanel")) : class$BasicPanel).getResource("/icons/yellow.gif"));
    private static final Image greenImg = Toolkit.getDefaultToolkit().createImage((class$BasicPanel == null ? (class$BasicPanel = BasicPanel.class$("BasicPanel")) : class$BasicPanel).getResource("/icons/green.gif"));
    private static int MIDDLE1;
    private static int MIDDLE2;
    public static final int DESIGN = 1;
    public static final int ADD1 = 2;
    public static final int ADD2 = 3;
    public static final int MANUAL = 4;
    static /* synthetic */ Class class$BasicPanel;

    public BasicPanel() {
        this.setBackground(Color.gray);
        this.mode = 1;
        this.numOfDigits = 2;
        this.paintHolds = false;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public int getNumOfDigits() {
        return this.numOfDigits;
    }

    public void setNumOfDigits(int n) {
        this.numOfDigits = n;
        this.createColumns();
    }

    public int getFirstNumber() {
        int n = 0;
        for (int i = 0; i < this.numOfDigits; ++i) {
            int n2 = this.getDigit(i, true);
            n = (int)((double)n + (double)n2 * Math.pow(10.0, this.numOfDigits - i - 1));
        }
        return n;
    }

    public void setFirstNumber(int n) {
        for (int i = 0; i < this.cols.length; ++i) {
            this.cols[i].setTop(0);
        }
        String string = String.valueOf(n);
        for (int i = 0; i < string.length(); ++i) {
            int n2 = this.cols.length - (string.length() - i);
            this.cols[n2].setTop(Character.getNumericValue(string.charAt(i)));
        }
        this.repaint();
        this.firePropertyChange("number", null, null);
    }

    public int getSecondNumber() {
        int n = 0;
        for (int i = 0; i < this.numOfDigits; ++i) {
            int n2 = this.getDigit(i, false);
            n = (int)((double)n + (double)n2 * Math.pow(10.0, this.numOfDigits - i - 1));
        }
        return n;
    }

    public void setSecondNumber(int n) {
        for (int i = 0; i < this.cols.length; ++i) {
            this.cols[i].setMiddle(0);
        }
        String string = String.valueOf(n);
        for (int i = 0; i < string.length(); ++i) {
            int n2 = this.cols.length - (string.length() - i);
            this.cols[n2].setMiddle(Character.getNumericValue(string.charAt(i)));
        }
        this.repaint();
        this.firePropertyChange("number", null, null);
    }

    private int getDigit(int n, boolean bl) {
        return bl ? this.cols[n].getTop() : this.cols[n].getMiddle();
    }

    private int getDigitIndex(int n) {
        return n;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int n) {
        this.mode = n;
        if (n == 4) {
            this.prepareManual();
        } else if (n != 3) {
            this.createColumns();
        }
    }

    private void prepareManual() {
        for (int i = 0; i < this.cols.length; ++i) {
            int n = this.cols[i].getTop() + this.cols[i].getMiddle();
            this.cols[i].setSumInTop(n);
            this.cols[i].setShouldStayBehind(Math.max(0, n - 10));
            this.cols[i].setTop(n);
            this.cols[i].setMiddle(0);
        }
    }

    public void reInitManual() {
        for (int i = 0; i < this.cols.length; ++i) {
            this.cols[i].setTop(this.cols[i].getSumInTop());
            this.cols[i].setMiddle(0);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n;
        Point point = mouseEvent.getPoint();
        int n2 = -1;
        for (n = 0; n < this.cols.length; ++n) {
            if (Math.abs(point.x - this.cols[n].getX()) > 8) continue;
            n2 = n;
            break;
        }
        this.setToolTipText(null);
        if (n2 != -1) {
            n = this.numOfDigits - n2 - 1;
            this.setToolTipText(tooltips[n]);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n;
        if (this.mode == 4) {
            this.mousePressedInManualMode(mouseEvent);
            return;
        }
        Point point = mouseEvent.getPoint();
        if (point.y < 25 || point.y > this.getHeight() - 5) {
            return;
        }
        int n2 = -1;
        for (n = 0; n < this.cols.length; ++n) {
            if (Math.abs(point.x - this.cols[n].getX()) > 8) continue;
            n2 = n;
            break;
        }
        if (point.y > 25 && point.y < MIDDLE1) {
            if (n2 == -1) {
                return;
            }
            if (point.y - 20 - 5 < 16 * this.cols[n2].getTop()) {
                n = (point.y - 20 - 5) / 16;
                this.cols[n2].setTop(n);
            }
        } else if (point.y > MIDDLE1 && point.y < MIDDLE2) {
            if (n2 == -1) {
                return;
            }
            if (point.y > MIDDLE1 && point.y - MIDDLE1 < 16 * this.cols[n2].getMiddle()) {
                n = (point.y - MIDDLE1) / 16;
                this.cols[n2].setMiddle(n);
            }
        } else if (point.y > MIDDLE2 && point.y < this.getHeight() - 5) {
            if (this.mode == 1) {
                if (n2 == -1) {
                    return;
                }
                if (point.y > this.getHeight() - 5 - 16 * (10 - this.cols[n2].getTop())) {
                    n = (this.getHeight() - 5 - point.y) / 16;
                    if (n == 0) {
                        this.firePropertyChange("ERROR1", null, null);
                    } else {
                        this.cols[n2].setTop(10 - n);
                    }
                }
            } else {
                n2 = -1;
                for (n = 0; n < this.cols.length; ++n) {
                    if (Math.abs(point.x - this.cols[n].getX()) > 21) continue;
                    n2 = n;
                    break;
                }
                if (n2 == -1) {
                    return;
                }
                n = 0;
                int n3 = 1;
                int n4 = -1;
                if (Math.abs(point.x - (this.cols[n2].getX() - 13)) <= 8) {
                    n4 = n;
                } else if (Math.abs(point.x - (this.cols[n2].getX() + 13)) <= 8) {
                    n4 = n3;
                }
                if (n4 == -1) {
                    return;
                }
                int n5 = this.getBottomTwins(n2)[n4];
                if (this.mode == 2) {
                    if (point.y > this.getHeight() - 5 - 16 * n5) {
                        int n6 = (this.getHeight() - 5 - point.y) / 16;
                        int n7 = n5 - n6;
                        if (n7 + this.cols[n2].getTop() > 9) {
                            this.firePropertyChange("ERROR1", null, null);
                            return;
                        }
                        this.cols[n2].setTop(this.cols[n2].getTop() + n7);
                    }
                } else if (this.mode == 3 && point.y > this.getHeight() - 5 - 16 * n5) {
                    int n8 = (this.getHeight() - 5 - point.y) / 16;
                    int n9 = n5 - n8;
                    if (n9 + this.cols[n2].getMiddle() > 9) {
                        this.firePropertyChange("ERROR1", null, null);
                        return;
                    }
                    this.cols[n2].setMiddle(this.cols[n2].getMiddle() + n9);
                }
            }
        }
        this.firePropertyChange("number", null, null);
        this.repaint();
    }

    private void mousePressedInManualMode(MouseEvent mouseEvent) {
        int n;
        Point point = mouseEvent.getPoint();
        if (point.y < 25 || point.y > this.getHeight() - 5) {
            return;
        }
        int n2 = -1;
        for (n = 0; n < this.cols.length; ++n) {
            if (Math.abs(point.x - this.cols[n].getX()) > 8) continue;
            n2 = n;
            break;
        }
        if (point.y > 25 && point.y < MIDDLE2) {
            if (n2 == -1) {
                return;
            }
            if (point.y - 20 - 5 < 16 * this.cols[n2].getTop()) {
                n = (point.y - 20 - 5) / 16;
                if (this.cols[n2].getSumInTop() - n < 10) {
                    this.firePropertyChange("ERROR6", null, null);
                    return;
                }
                if (n < this.cols[n2].getShouldStayBehind()) {
                    this.firePropertyChange("ERROR2", null, null);
                    return;
                }
                if (this.cols[n2].getSumInTop() - n == 10) {
                    if (n2 == 0) {
                        this.addDigitLeft();
                        ++n2;
                    }
                    this.cols[n2 - 1].setTop(this.cols[n2 - 1].getTop() + 1);
                    this.cols[n2 - 1].setSumInTop(this.cols[n2 - 1].getSumInTop() + 1);
                    this.cols[n2 - 1].setShouldStayBehind(Math.max(0, this.cols[n2 - 1].getSumInTop() - 10));
                }
                this.cols[n2].setTop(n);
            }
        } else if (point.y > MIDDLE2 && point.y < this.getHeight() - 5) {
            n2 = -1;
            for (n = 0; n < this.cols.length; ++n) {
                if (Math.abs(point.x - this.cols[n].getX()) > 21) continue;
                n2 = n;
                break;
            }
            if (n2 == -1) {
                return;
            }
            n = 0;
            int n3 = 1;
            int n4 = -1;
            if (Math.abs(point.x - (this.cols[n2].getX() - 13)) <= 8) {
                n4 = n;
            } else if (Math.abs(point.x - (this.cols[n2].getX() + 13)) <= 8) {
                n4 = n3;
            }
            if (n4 == -1) {
                return;
            }
            int n5 = this.getBottomTwins(n2)[n4];
            if (point.y > this.getHeight() - 5 - 16 * n5) {
                int n6 = (this.getHeight() - 5 - point.y) / 16;
                int n7 = n5 - n6;
                if (n7 > 1) {
                    this.firePropertyChange("ERROR3", null, null);
                    return;
                }
                if (n2 == this.cols.length - 1 && this.cols[n2].getTop() == this.cols[n2].getSumInTop()) {
                    this.firePropertyChange("ERROR4", null, null);
                    return;
                }
                if (this.cols[n2 + 1].getSumInTop() - this.cols[n2 + 1].getTop() != 10) {
                    this.firePropertyChange("ERROR4", null, null);
                    return;
                }
                if (n7 + this.cols[n2].getTop() > 19) {
                    this.firePropertyChange("ERROR5", null, null);
                    return;
                }
                this.cols[n2].setTop(this.cols[n2].getTop() + n7);
                this.cols[n2].setSumInTop(this.cols[n2].getSumInTop() + 1);
                this.cols[n2].setShouldStayBehind(Math.max(0, this.cols[n2].getSumInTop() - 10));
            }
        }
        this.firePropertyChange("number", null, null);
        this.repaint();
    }

    private void createColumns() {
        int n = (int)Math.rint((float)this.getWidth() / (float)this.numOfDigits);
        if (n <= 0) {
            return;
        }
        this.cols = new Column[this.numOfDigits];
        for (int i = 0; i < this.numOfDigits; ++i) {
            int n2 = (2 * i + 1) * n / 2 + 5;
            this.cols[i] = new Column(n2, 0, 0);
        }
        this.repaint();
    }

    public void addDigitLeft() {
        ++this.numOfDigits;
        Column[] columnArray = new Column[this.numOfDigits];
        columnArray[0] = new Column(0, 0, 0);
        for (int i = 1; i < columnArray.length; ++i) {
            columnArray[i] = this.cols[i - 1];
        }
        this.cols = columnArray;
        this.rearrangeColumns();
        this.repaint();
    }

    private void rearrangeColumns() {
        int n = (int)Math.rint((float)this.getWidth() / (float)this.numOfDigits);
        if (n <= 0) {
            return;
        }
        for (int i = 0; i < this.numOfDigits; ++i) {
            int n2 = (2 * i + 1) * n / 2 + 5;
            this.cols[i].setX(n2);
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.createColumns();
        }
        super.setVisible(bl);
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setFont(basicFont);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(basicFont);
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(5, 25, this.getWidth() - 10, this.getHeight() - 20 - 10);
        graphics2D.setColor(Color.black);
        graphics2D.drawRect(5, 25, this.getWidth() - 10, this.getHeight() - 20 - 10);
        if (this.cols == null || this.cols.length == 0) {
            return;
        }
        this.rearrangeColumns();
        MIDDLE2 = this.getHeight() - 5 - (int)Math.rint(168.0);
        MIDDLE1 = (MIDDLE2 + 20 + 5) / 2;
        for (int i = 0; i < this.numOfDigits; ++i) {
            int n = this.cols[i].getX();
            graphics2D.setColor(Color.gray);
            if (this.mode == 1) {
                graphics2D.drawLine(n, MIDDLE2, n, this.getHeight() - 5);
            } else {
                graphics2D.setColor(Color.lightGray);
                graphics2D.fillRect(n - 13, 26, 26, this.getHeight() - 10 - 20 - 2);
                graphics2D.setColor(Color.gray);
                graphics2D.drawLine(n - 13, MIDDLE2, n - 13, this.getHeight() - 5);
                graphics2D.drawLine(n + 13, MIDDLE2, n + 13, this.getHeight() - 5);
            }
            graphics2D.drawLine(n, 25, n, MIDDLE2);
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(n - 30, 5, 60, 19);
            graphics2D.setColor(Color.black);
            graphics2D.drawRect(n - 30, 5, 60, 19);
            graphics2D.setColor(Color.black);
            String string = "1";
            for (int j = 1; j <= this.numOfDigits - i - 1; ++j) {
                string = string + "0";
            }
            string = string + "\u03b4\u03b5\u03c2";
            graphics2D.drawString(string, n - 30 + (60 - fontMetrics.stringWidth(string)) / 2, 5 + (20 + fontMetrics.getHeight()) / 2 - 2);
        }
        graphics2D.setColor(Color.gray);
        if (this.mode == 2 || this.mode == 4) {
            graphics2D.drawLine(5, MIDDLE2, this.getWidth() - 10, MIDDLE2);
        } else if (this.mode == 3) {
            graphics2D.drawLine(5, MIDDLE2, this.getWidth() - 10, MIDDLE2);
            graphics2D.drawLine(5, MIDDLE1, this.getWidth() - 10, MIDDLE1);
        }
        this.paintFirstNumber(graphics2D);
        if (this.mode == 3) {
            this.paintSecondNumber(graphics2D);
        }
        this.paintBottom(graphics2D);
    }

    private void paintFirstNumber(Graphics2D graphics2D) {
        for (int i = 0; i < this.cols.length; ++i) {
            int n = this.cols[i].getTop();
            for (int j = 1; j <= n; ++j) {
                Image image = null;
                image = this.mode == 1 ? (j > 5 ? redImg : greenImg) : (this.paintHolds && n > 10 && n - j < 10 ? blueImg : (j > 9 ? redImg : greenImg));
                graphics2D.drawImage(image, this.cols[i].getX() - 8, 25 + (j - 1) * 16, 16, 16, this);
            }
        }
    }

    private void paintSecondNumber(Graphics2D graphics2D) {
        for (int i = 0; i < this.cols.length; ++i) {
            int n = this.cols[i].getTop();
            int n2 = this.cols[i].getMiddle();
            for (int j = 1; j <= n2; ++j) {
                Image image = n + j > 10 ? redImg : greenImg;
                graphics2D.drawImage(image, this.cols[i].getX() - 8, MIDDLE1 + (j - 1) * 16, 16, 16, this);
            }
        }
    }

    private void paintBottom(Graphics2D graphics2D) {
        if (this.mode == 1) {
            for (int i = 0; i < this.cols.length; ++i) {
                int n = 10 - this.cols[i].getTop() - this.cols[i].getMiddle();
                for (int j = 1; j <= n; ++j) {
                    Image image = j <= 5 ? redImg : greenImg;
                    graphics2D.drawImage(image, this.cols[i].getX() - 8, this.getHeight() - 5 - j * 16, 16, 16, this);
                }
            }
        } else {
            for (int i = 0; i < this.cols.length; ++i) {
                Image image;
                int n;
                int[] nArray = this.getBottomTwins(i);
                for (n = 1; n <= nArray[0]; ++n) {
                    image = n <= 5 ? redImg : greenImg;
                    graphics2D.drawImage(image, this.cols[i].getX() - 5 - 16, this.getHeight() - 5 - n * 16, 16, 16, this);
                }
                for (n = 1; n <= nArray[1]; ++n) {
                    image = n <= 5 ? redImg : greenImg;
                    graphics2D.drawImage(image, this.cols[i].getX() + 5, this.getHeight() - 5 - n * 16, 16, 16, this);
                }
            }
        }
    }

    private int[] getBottomTwins(int n) {
        int n2 = 20 - this.cols[n].getTop() - this.cols[n].getMiddle();
        int n3 = (int)Math.ceil((float)n2 / 2.0f);
        int n4 = (int)Math.floor((float)n2 / 2.0f);
        return new int[]{n3, n4};
    }

    public Column[] getColumns() {
        return this.cols;
    }

    public void setPaintHolds(boolean bl) {
        this.paintHolds = bl;
    }

    public boolean getPaintHolds() {
        return this.paintHolds;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

