/*
 * Decompiled with CFR 0.152.
 */
import com.sun.j3d.utils.behaviors.mouse.MouseRotate;
import com.sun.j3d.utils.geometry.Cone;
import com.sun.j3d.utils.geometry.Cylinder;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.text.DecimalFormat;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PointLight;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.SpotLight;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class StereoExplorer
extends JApplet {
    SimpleUniverse simpleU;
    BranchGroup objRoot;
    TransformGroup cctg;
    Transform3D cc3d;
    Transform3D someRotation;
    Canvas3D c;
    BranchGroup scene;
    Cube c0 = null;
    Rect3D c1 = null;
    Sphere c2 = null;
    Cone c3 = null;
    Cylinder c4 = null;
    Color3f eColor = new Color3f(0.0f, 0.0f, 0.0f);
    Color3f sColor = new Color3f(1.0f, 1.0f, 1.0f);
    Color3f objColor = new Color3f(0.6f, 0.6f, 0.6f);
    Color3f lColor1 = new Color3f(1.0f, 0.0f, 0.0f);
    Color3f lColor2 = new Color3f(0.0f, 1.0f, 0.0f);
    Color3f alColor = new Color3f(0.6f, 0.4f, 0.2f);
    Color3f bgColor = new Color3f(0.05f, 0.05f, 0.2f);
    BoundingSphere boundingSphere = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
    private JLabel volume;
    private JSlider hSlider;
    private JToggleButton rectangle;
    private JLabel cLabel1;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel cLabel3;
    private JPanel jPanel3;
    private JLabel jLabel2;
    private JSlider wSlider;
    private JToggleButton cylinder;
    private JPanel mainPanel;
    private JLabel slider3;
    private JSlider lSlider;
    private JLabel cLabel2;
    private JCheckBox fillObject;
    private ButtonGroup buttonGroup1;
    private JSeparator jSeparator1;
    private JToggleButton cone;
    private JLabel slider1;
    private JPanel jPanel1;
    private JLabel area2;
    private JToggleButton cube;
    private JToggleButton sphere;
    private JLabel slider2;
    private JSeparator jSeparator3;
    private JLabel area;
    private JButton calculator;

    public StereoExplorer() {
        this.initComponents();
        this.mainPanel.setLayout(new BorderLayout());
        Canvas3D c = new Canvas3D(SimpleUniverse.getPreferredConfiguration());
        this.mainPanel.add("Center", (Component)c);
        this.simpleU = new SimpleUniverse(c);
        this.createScene();
        this.cubeActionPerformed(null);
        this.makeCalculations();
    }

    public void createScene() {
        this.c = new Canvas3D(SimpleUniverse.getPreferredConfiguration());
        this.mainPanel.add("Center", (Component)this.c);
        this.simpleU = new SimpleUniverse(this.c);
    }

    public void setScene() {
        int sel = 0;
        if (this.cube.isSelected()) {
            sel = 0;
        }
        if (this.rectangle.isSelected()) {
            sel = 1;
        }
        if (this.sphere.isSelected()) {
            sel = 2;
        }
        if (this.cone.isSelected()) {
            sel = 3;
        }
        if (this.cylinder.isSelected()) {
            sel = 4;
        }
        Appearance appearance = new Appearance();
        LineAttributes lineAt = new LineAttributes(1.0f, 0, true);
        appearance.setLineAttributes(lineAt);
        PolygonAttributes polyAt = this.fillObject.isSelected() ? new PolygonAttributes(2, 0, 0.5f) : new PolygonAttributes(1, 0, 0.5f);
        appearance.setPolygonAttributes(polyAt);
        ColoringAttributes ca = new ColoringAttributes();
        ca.setColor(1.0f, 1.0f, 0.0f);
        ca.setShadeModel(3);
        appearance.setColoringAttributes(ca);
        Material m = new Material(this.objColor, this.eColor, this.objColor, this.sColor, 100.0f);
        appearance.setMaterial(m);
        if (this.scene != null) {
            this.scene.detach();
        }
        this.scene = this.createSceneGraph();
        this.createLights();
        switch (sel) {
            case 0: {
                this.c0 = new Cube((float)((double)this.lSlider.getValue() / 100.0), appearance);
                if (this.c1 != null) {
                    this.cctg.removeChild((Node)this.c1.getChild());
                }
                if (this.c2 != null) {
                    this.cctg.removeChild((Node)this.c2);
                }
                if (this.c3 != null) {
                    this.cctg.removeChild((Node)this.c3);
                }
                if (this.c4 != null) {
                    this.cctg.removeChild((Node)this.c4);
                }
                this.cctg.addChild((Node)this.c0.getChild());
                break;
            }
            case 1: {
                this.c1 = new Rect3D((float)((double)this.lSlider.getValue() / 100.0), (float)((double)this.hSlider.getValue() / 100.0), (float)((double)this.wSlider.getValue() / 100.0), appearance);
                if (this.c0 != null) {
                    this.cctg.removeChild((Node)this.c0.getChild());
                }
                if (this.c2 != null) {
                    this.cctg.removeChild((Node)this.c2);
                }
                if (this.c3 != null) {
                    this.cctg.removeChild((Node)this.c3);
                }
                if (this.c4 != null) {
                    this.cctg.removeChild((Node)this.c4);
                }
                this.cctg.addChild((Node)this.c1.getChild());
                break;
            }
            case 2: {
                this.c2 = new Sphere((float)((double)this.lSlider.getValue() / 100.0), 1, 40, appearance);
                if (this.c1 != null) {
                    this.cctg.removeChild((Node)this.c1.getChild());
                }
                if (this.c0 != null) {
                    this.cctg.removeChild((Node)this.c0.getChild());
                }
                if (this.c3 != null) {
                    this.cctg.removeChild((Node)this.c3);
                }
                if (this.c4 != null) {
                    this.cctg.removeChild((Node)this.c4);
                }
                this.cctg.addChild((Node)this.c2);
                break;
            }
            case 3: {
                this.c3 = new Cone((float)((double)this.lSlider.getValue() / 100.0), (float)((double)this.wSlider.getValue() / 100.0), 1, 40, 1, appearance);
                if (this.c1 != null) {
                    this.cctg.removeChild((Node)this.c1.getChild());
                }
                if (this.c2 != null) {
                    this.cctg.removeChild((Node)this.c2);
                }
                if (this.c0 != null) {
                    this.cctg.removeChild((Node)this.c0.getChild());
                }
                if (this.c4 != null) {
                    this.cctg.removeChild((Node)this.c4);
                }
                this.cctg.addChild((Node)this.c3);
                break;
            }
            case 4: {
                this.c4 = new Cylinder((float)((double)this.lSlider.getValue() / 100.0), (float)((double)this.wSlider.getValue() / 100.0), 1, 40, 1, appearance);
                if (this.c1 != null) {
                    this.cctg.removeChild((Node)this.c1.getChild());
                }
                if (this.c2 != null) {
                    this.cctg.removeChild((Node)this.c2);
                }
                if (this.c3 != null) {
                    this.cctg.removeChild((Node)this.c3);
                }
                if (this.c0 != null) {
                    this.cctg.removeChild((Node)this.c0.getChild());
                }
                this.cctg.addChild((Node)this.c4);
            }
        }
        this.scene.compile();
        this.simpleU.addBranchGraph(this.scene);
    }

    public BranchGroup createSceneGraph() {
        this.objRoot = new BranchGroup();
        this.objRoot.setCapability(17);
        Background background = new Background(this.bgColor);
        background.setApplicationBounds((Bounds)this.boundingSphere);
        this.objRoot.addChild((Node)background);
        this.cctg = new TransformGroup();
        this.cctg.setCapability(18);
        this.cctg.setCapability(17);
        this.objRoot.addChild((Node)this.cctg);
        MouseRotate myMouseRotate = new MouseRotate();
        myMouseRotate.setTransformGroup(this.cctg);
        myMouseRotate.setSchedulingBounds((Bounds)new BoundingSphere());
        this.objRoot.addChild((Node)myMouseRotate);
        this.cc3d = new Transform3D();
        this.someRotation = new Transform3D();
        this.someRotation.rotY(0.7853981633974483);
        this.cc3d.mul(this.someRotation);
        float scaleFactor = -2.5f;
        this.cc3d.setTranslation(new Vector3f(0.0f, 0.0f, scaleFactor));
        this.cctg.setTransform(this.cc3d);
        ViewingPlatform vp = this.simpleU.getViewingPlatform();
        TransformGroup View_TransformGroup = vp.getMultiTransformGroup().getTransformGroup(0);
        Transform3D View_Transform3D = new Transform3D();
        View_TransformGroup.getTransform(View_Transform3D);
        View_Transform3D.setTranslation(new Vector3f(0.0f, 0.0f, 0.0f));
        View_TransformGroup.setTransform(View_Transform3D);
        return this.objRoot;
    }

    public void createLights() {
        TransformGroup l1RotTrans = new TransformGroup();
        l1RotTrans.setCapability(18);
        this.objRoot.addChild((Node)l1RotTrans);
        TransformGroup l2RotTrans = new TransformGroup();
        l2RotTrans.setCapability(18);
        this.objRoot.addChild((Node)l2RotTrans);
        Transform3D t = new Transform3D();
        Vector3d lPos1 = new Vector3d(0.0, 0.0, 2.0);
        t.set(lPos1);
        TransformGroup l1Trans = new TransformGroup(t);
        l1RotTrans.addChild((Node)l1Trans);
        t = new Transform3D();
        Vector3d lPos2 = new Vector3d(0.5, 0.8, 2.0);
        t.set(lPos2);
        TransformGroup l2Trans = new TransformGroup(t);
        l2RotTrans.addChild((Node)l2Trans);
        ColoringAttributes caL1 = new ColoringAttributes();
        ColoringAttributes caL2 = new ColoringAttributes();
        caL1.setColor(this.lColor1);
        caL2.setColor(this.lColor2);
        Appearance appL1 = new Appearance();
        Appearance appL2 = new Appearance();
        appL1.setColoringAttributes(caL1);
        appL2.setColoringAttributes(caL2);
        l1Trans.addChild((Node)new Sphere(0.05f, appL1));
        l2Trans.addChild((Node)new Sphere(0.05f, appL2));
        AmbientLight aLgt = new AmbientLight(this.alColor);
        DirectionalLight lgt1 = null;
        DirectionalLight lgt2 = null;
        Point3f lPoint = new Point3f(0.0f, 0.0f, 0.0f);
        Point3f atten = new Point3f(1.0f, 0.0f, 0.0f);
        Vector3f lDirect1 = new Vector3f(lPos1);
        Vector3f lDirect2 = new Vector3f(lPos2);
        lDirect1.negate();
        lDirect2.negate();
        boolean DIRECTIONAL_LIGHT = false;
        boolean POINT_LIGHT = true;
        int SPOT_LIGHT = 2;
        int lightType = 2;
        switch (lightType) {
            case 0: {
                lgt1 = new DirectionalLight(this.lColor1, lDirect1);
                lgt2 = new DirectionalLight(this.lColor2, lDirect2);
                break;
            }
            case 1: {
                lgt1 = new PointLight(this.lColor1, lPoint, atten);
                lgt2 = new PointLight(this.lColor2, lPoint, atten);
                break;
            }
            case 2: {
                lgt1 = new SpotLight(this.lColor1, lPoint, atten, lDirect1, 0.43633232f, 10.0f);
                lgt2 = new SpotLight(this.lColor2, lPoint, atten, lDirect2, 0.43633232f, 10.0f);
            }
        }
        aLgt.setInfluencingBounds((Bounds)this.boundingSphere);
        lgt1.setInfluencingBounds((Bounds)this.boundingSphere);
        lgt2.setInfluencingBounds((Bounds)this.boundingSphere);
        this.objRoot.addChild((Node)aLgt);
        l1Trans.addChild((Node)lgt1);
        l2Trans.addChild((Node)lgt2);
    }

    public void destroy() {
        this.simpleU.removeAllLocales();
    }

    public void makeCalculations() {
        int sel = 0;
        if (this.cube.isSelected()) {
            sel = 0;
        }
        if (this.rectangle.isSelected()) {
            sel = 1;
        }
        if (this.sphere.isSelected()) {
            sel = 2;
        }
        if (this.cone.isSelected()) {
            sel = 3;
        }
        if (this.cylinder.isSelected()) {
            sel = 4;
        }
        float a = 0.0f;
        float v = 0.0f;
        float a2 = 0.0f;
        float l = (float)this.lSlider.getValue() / 10.0f;
        float w = (float)this.wSlider.getValue() / 10.0f;
        float h = (float)this.hSlider.getValue() / 10.0f;
        switch (sel) {
            case 0: {
                a = (float)Math.pow(l, 2.0) * 6.0f;
                v = (float)Math.pow(l, 3.0);
                a2 = 0.0f;
                break;
            }
            case 1: {
                a = 2.0f * l * w + 2.0f * l * h + 2.0f * w * h;
                v = l * w * h;
                a2 = 2.0f * l * h + 2.0f * w * h;
                break;
            }
            case 2: {
                a = (float)(Math.PI * 4 * Math.pow(l, 2.0));
                v = (float)(4.1887903296220665 * Math.pow(l, 3.0));
                a2 = 0.0f;
                break;
            }
            case 3: {
                a = (float)(Math.PI * (double)l * ((double)l + Math.sqrt(w * w + l * l)));
                v = (float)(1.0471975824055166 * (double)l * (double)l * (double)w);
                a2 = (float)(Math.PI * (double)l * Math.sqrt(w * w + l * l));
                break;
            }
            case 4: {
                a = (float)(Math.PI * 2 * (double)l * (double)(l + w));
                v = (float)(Math.PI * (double)l * (double)l * (double)w);
                a2 = (float)(Math.PI * 2 * (double)(l * w));
            }
        }
        DecimalFormat format = new DecimalFormat("#.##");
        this.area.setText(format.format(a));
        this.volume.setText(format.format(v));
        this.area2.setText(format.format(a2));
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jPanel3 = new JPanel();
        this.cube = new JToggleButton();
        this.rectangle = new JToggleButton();
        this.sphere = new JToggleButton();
        this.cone = new JToggleButton();
        this.cylinder = new JToggleButton();
        this.fillObject = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.cLabel1 = new JLabel();
        this.lSlider = new JSlider();
        this.slider1 = new JLabel();
        this.cLabel2 = new JLabel();
        this.wSlider = new JSlider();
        this.slider2 = new JLabel();
        this.cLabel3 = new JLabel();
        this.hSlider = new JSlider();
        this.slider3 = new JLabel();
        this.jSeparator3 = new JSeparator();
        this.jLabel2 = new JLabel();
        this.area = new JLabel();
        this.jLabel1 = new JLabel();
        this.volume = new JLabel();
        this.jLabel3 = new JLabel();
        this.area2 = new JLabel();
        this.calculator = new JButton();
        this.mainPanel = new JPanel();
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 1));
        this.jPanel1.setMaximumSize(new Dimension(110, 26));
        this.jPanel1.setMinimumSize(new Dimension(110, 26));
        this.jPanel1.setPreferredSize(new Dimension(110, 26));
        this.jPanel3.setLayout(new BoxLayout(this.jPanel3, 1));
        this.cube.setSelected(true);
        this.cube.setText("\u039a\u03cd\u03b2\u03bf\u03c2");
        this.buttonGroup1.add(this.cube);
        this.cube.setMaximumSize(new Dimension(110, 26));
        this.cube.setMinimumSize(new Dimension(110, 26));
        this.cube.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StereoExplorer.this.cubeActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.cube);
        this.rectangle.setText("\u03a0\u03b1\u03c1\u03b1\u03bb\u03bb/\u03c0\u03b5\u03b4\u03bf");
        this.buttonGroup1.add(this.rectangle);
        this.rectangle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StereoExplorer.this.rectangleActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.rectangle);
        this.sphere.setText("\u03a3\u03c6\u03b1\u03af\u03c1\u03b1");
        this.buttonGroup1.add(this.sphere);
        this.sphere.setMaximumSize(new Dimension(110, 26));
        this.sphere.setMinimumSize(new Dimension(110, 26));
        this.sphere.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StereoExplorer.this.sphereActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.sphere);
        this.cone.setText("\u039a\u03ce\u03bd\u03bf\u03c2");
        this.buttonGroup1.add(this.cone);
        this.cone.setMaximumSize(new Dimension(110, 26));
        this.cone.setMinimumSize(new Dimension(110, 26));
        this.cone.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StereoExplorer.this.coneActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.cone);
        this.cylinder.setText("\u039a\u03cd\u03bb\u03b9\u03bd\u03b4\u03c1\u03bf\u03c2");
        this.buttonGroup1.add(this.cylinder);
        this.cylinder.setMaximumSize(new Dimension(110, 26));
        this.cylinder.setMinimumSize(new Dimension(110, 26));
        this.cylinder.setPreferredSize(new Dimension(110, 26));
        this.cylinder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StereoExplorer.this.cylinderActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.cylinder);
        this.fillObject.setSelected(true);
        this.fillObject.setText("\u0393\u03ad\u03bc\u03b9\u03c3\u03bc\u03b1");
        this.fillObject.setHorizontalTextPosition(10);
        this.fillObject.setMaximumSize(new Dimension(110, 26));
        this.fillObject.setMinimumSize(new Dimension(110, 26));
        this.fillObject.setPreferredSize(new Dimension(110, 26));
        this.fillObject.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                StereoExplorer.this.fillObjectItemStateChanged(evt);
            }
        });
        this.jPanel3.add(this.fillObject);
        this.jSeparator1.setAlignmentX(0.0f);
        this.jSeparator1.setMaximumSize(new Dimension(200, 24));
        this.jSeparator1.setMinimumSize(new Dimension(200, 24));
        this.jSeparator1.setPreferredSize(new Dimension(200, 24));
        this.jPanel3.add(this.jSeparator1);
        this.cLabel1.setText("\u039c\u03ae\u03ba\u03bf\u03c2:");
        this.jPanel3.add(this.cLabel1);
        this.lSlider.setValue(70);
        this.lSlider.setAlignmentX(0.0f);
        this.lSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                StereoExplorer.this.lSliderStateChanged(evt);
            }
        });
        this.jPanel3.add(this.lSlider);
        this.slider1.setHorizontalAlignment(0);
        this.slider1.setText("0.5");
        this.slider1.setMaximumSize(new Dimension(200, 16));
        this.slider1.setMinimumSize(new Dimension(200, 16));
        this.slider1.setPreferredSize(new Dimension(200, 16));
        this.jPanel3.add(this.slider1);
        this.cLabel2.setText("\u03a0\u03bb\u03ac\u03c4\u03bf\u03c2:");
        this.jPanel3.add(this.cLabel2);
        this.wSlider.setAlignmentX(0.0f);
        this.wSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                StereoExplorer.this.wSliderStateChanged(evt);
            }
        });
        this.jPanel3.add(this.wSlider);
        this.slider2.setHorizontalAlignment(0);
        this.slider2.setText("0.5");
        this.slider2.setMaximumSize(new Dimension(200, 16));
        this.slider2.setMinimumSize(new Dimension(200, 16));
        this.slider2.setPreferredSize(new Dimension(200, 16));
        this.jPanel3.add(this.slider2);
        this.cLabel3.setText("\u038e\u03c8\u03bf\u03c2:");
        this.jPanel3.add(this.cLabel3);
        this.hSlider.setAlignmentX(0.0f);
        this.hSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                StereoExplorer.this.hSliderStateChanged(evt);
            }
        });
        this.jPanel3.add(this.hSlider);
        this.slider3.setHorizontalAlignment(0);
        this.slider3.setText("0.5");
        this.slider3.setMaximumSize(new Dimension(200, 16));
        this.slider3.setMinimumSize(new Dimension(200, 16));
        this.slider3.setPreferredSize(new Dimension(200, 16));
        this.jPanel3.add(this.slider3);
        this.jPanel3.add(this.jSeparator3);
        this.jLabel2.setText("\u039f\u03bb\u03b9\u03ba\u03ae \u0395\u03c0\u03b9\u03c6\u03ac\u03bd\u03b5\u03b9\u03b1:");
        this.jPanel3.add(this.jLabel2);
        this.area.setHorizontalAlignment(0);
        this.area.setText("0.0");
        this.area.setMaximumSize(new Dimension(200, 16));
        this.area.setMinimumSize(new Dimension(200, 16));
        this.area.setPreferredSize(new Dimension(200, 16));
        this.jPanel3.add(this.area);
        this.jLabel1.setText("\u038c\u03b3\u03ba\u03bf\u03c2:");
        this.jPanel3.add(this.jLabel1);
        this.volume.setHorizontalAlignment(0);
        this.volume.setText("0.0");
        this.volume.setMaximumSize(new Dimension(200, 16));
        this.volume.setMinimumSize(new Dimension(200, 16));
        this.volume.setPreferredSize(new Dimension(200, 16));
        this.jPanel3.add(this.volume);
        this.jLabel3.setText("\u03a0\u03b1\u03c1\u03ac\u03c0\u03bb\u03b5\u03c5\u03c1\u03b7 \u0395\u03c0.:");
        this.jPanel3.add(this.jLabel3);
        this.area2.setHorizontalAlignment(0);
        this.area2.setText("0.0");
        this.area2.setMaximumSize(new Dimension(200, 16));
        this.area2.setMinimumSize(new Dimension(200, 16));
        this.area2.setPreferredSize(new Dimension(200, 16));
        this.jPanel3.add(this.area2);
        this.calculator.setText("\u03a5\u03c0\u03bf\u03bb\u03bf\u03b3\u03b9\u03c3\u03c4\u03ae\u03c2");
        this.calculator.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StereoExplorer.this.calculatorActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.calculator);
        this.jPanel1.add(this.jPanel3);
        this.getContentPane().add((Component)this.jPanel1, "West");
        this.getContentPane().add((Component)this.mainPanel, "Center");
    }

    private void calculatorActionPerformed(ActionEvent evt) {
        try {
            Runtime.getRuntime().exec("calc.exe");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void lSliderStateChanged(ChangeEvent evt) {
        this.setScene();
        DecimalFormat format = new DecimalFormat("#.##");
        this.slider1.setText(format.format((float)this.lSlider.getValue() / 10.0f));
        this.makeCalculations();
    }

    private void hSliderStateChanged(ChangeEvent evt) {
        this.setScene();
        DecimalFormat format = new DecimalFormat("#.##");
        this.slider3.setText(format.format((float)this.hSlider.getValue() / 10.0f));
        this.makeCalculations();
    }

    private void wSliderStateChanged(ChangeEvent evt) {
        this.setScene();
        DecimalFormat format = new DecimalFormat("#.##");
        this.slider2.setText(format.format((float)this.wSlider.getValue() / 10.0f));
        this.makeCalculations();
    }

    private void fillObjectItemStateChanged(ItemEvent evt) {
        this.setScene();
    }

    private void cylinderActionPerformed(ActionEvent evt) {
        this.cLabel1.setText("\u0391\u03ba\u03c4\u03af\u03bd\u03b1 \u0392\u03ac\u03c3\u03b7\u03c2");
        this.cLabel2.setText("\u038e\u03c8\u03bf\u03c2");
        this.cLabel1.setVisible(true);
        this.cLabel2.setVisible(true);
        this.cLabel3.setVisible(false);
        this.lSlider.setVisible(true);
        this.wSlider.setVisible(true);
        this.hSlider.setVisible(false);
        this.slider1.setVisible(true);
        this.slider2.setVisible(true);
        this.slider3.setVisible(false);
        this.jLabel3.setVisible(true);
        this.area2.setVisible(true);
        this.lSlider.setValue(50);
        DecimalFormat format = new DecimalFormat("#.##");
        this.slider1.setText(format.format((float)this.lSlider.getValue() / 10.0f));
        this.wSlider.setValue(70);
        this.slider2.setText(format.format((float)this.wSlider.getValue() / 10.0f));
        this.setScene();
        this.makeCalculations();
    }

    private void coneActionPerformed(ActionEvent evt) {
        this.cLabel1.setText("\u0391\u03ba\u03c4\u03af\u03bd\u03b1 \u0392\u03ac\u03c3\u03b7\u03c2");
        this.cLabel2.setText("\u038e\u03c8\u03bf\u03c2");
        this.cLabel1.setVisible(true);
        this.cLabel2.setVisible(true);
        this.cLabel3.setVisible(false);
        this.lSlider.setVisible(true);
        this.wSlider.setVisible(true);
        this.hSlider.setVisible(false);
        this.slider1.setVisible(true);
        this.slider2.setVisible(true);
        this.slider3.setVisible(false);
        this.jLabel3.setVisible(true);
        this.area2.setVisible(true);
        this.lSlider.setValue(50);
        DecimalFormat format = new DecimalFormat("#.##");
        this.slider1.setText(format.format((float)this.lSlider.getValue() / 10.0f));
        this.wSlider.setValue(70);
        this.slider2.setText(format.format((float)this.wSlider.getValue() / 10.0f));
        this.setScene();
        this.makeCalculations();
    }

    private void sphereActionPerformed(ActionEvent evt) {
        this.cLabel1.setText("\u0391\u03ba\u03c4\u03af\u03bd\u03b1");
        this.cLabel1.setVisible(true);
        this.cLabel2.setVisible(false);
        this.cLabel3.setVisible(false);
        this.lSlider.setVisible(true);
        this.wSlider.setVisible(false);
        this.hSlider.setVisible(false);
        this.slider1.setVisible(true);
        this.slider2.setVisible(false);
        this.slider3.setVisible(false);
        this.jLabel3.setVisible(false);
        this.area2.setVisible(false);
        this.lSlider.setValue(50);
        DecimalFormat format = new DecimalFormat("#.##");
        this.slider1.setText(format.format((float)this.lSlider.getValue() / 10.0f));
        this.setScene();
        this.makeCalculations();
    }

    private void rectangleActionPerformed(ActionEvent evt) {
        this.cLabel1.setText("\u039c\u03ae\u03ba\u03bf\u03c2");
        this.cLabel2.setText("\u03a0\u03bb\u03ac\u03c4\u03bf\u03c2");
        this.cLabel3.setText("\u038e\u03c8\u03bf\u03c2");
        this.cLabel1.setVisible(true);
        this.cLabel2.setVisible(true);
        this.cLabel3.setVisible(true);
        this.lSlider.setVisible(true);
        this.wSlider.setVisible(true);
        this.hSlider.setVisible(true);
        this.slider1.setVisible(true);
        this.slider2.setVisible(true);
        this.slider3.setVisible(true);
        this.jLabel3.setVisible(true);
        this.area2.setVisible(true);
        this.lSlider.setValue(80);
        DecimalFormat format = new DecimalFormat("#.##");
        this.slider1.setText(format.format((float)this.lSlider.getValue() / 10.0f));
        this.wSlider.setValue(50);
        this.slider2.setText(format.format((float)this.wSlider.getValue() / 10.0f));
        this.hSlider.setValue(50);
        this.slider3.setText(format.format((float)this.hSlider.getValue() / 10.0f));
        this.setScene();
        this.makeCalculations();
    }

    private void cubeActionPerformed(ActionEvent evt) {
        this.cLabel1.setText("\u03a0\u03bb\u03b5\u03c5\u03c1\u03ac");
        this.cLabel2.setVisible(false);
        this.cLabel3.setVisible(false);
        this.lSlider.setVisible(true);
        this.wSlider.setVisible(false);
        this.hSlider.setVisible(false);
        this.slider1.setVisible(true);
        this.slider2.setVisible(false);
        this.slider3.setVisible(false);
        this.jLabel3.setVisible(false);
        this.area2.setVisible(false);
        this.lSlider.setValue(50);
        DecimalFormat format = new DecimalFormat("#.##");
        this.slider1.setText(format.format((float)this.lSlider.getValue() / 10.0f));
        this.setScene();
        this.makeCalculations();
    }
}

