/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPCalculator;

import com.questmsm.FPCalculator.Calculator;
import com.questmsm.FPCalculator.MatrixView;
import com.questmsm.FunctionProbe.WindowMenuHandler;
import com.questmsm.Utilities.FPMenuItem;
import com.questmsm.Utilities.fp_resource;
import java.awt.BorderLayout;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Scrollbar;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class MatrixViewPanel
extends Frame
implements ItemListener {
    private Calculator fCalc;
    private Scrollbar fVert;
    private Scrollbar fHoriz;
    private MatrixView fField;
    private int fWidth;
    private int fHeight;
    private boolean fInitialized = false;
    private MenuBar fMenuBar;
    private Menu fCalcMenu;
    private MenuItem fInverseMenu;
    private MenuItem fRadMenu;
    private MenuItem fAddMenu;
    private MenuItem fCreateMatrixMenu;
    private MenuItem fCallMatrixMenu;
    private MenuItem fClearMatrixViewMenu;
    private MenuItem fAugmentMatrixMenu;
    private MenuItem fSolveSystemMenu;
    private MenuItem fRowOperationsMenu;
    private MenuItem fRenameMatrixMenu;
    private MenuItem fAddInverseMenu;
    private MenuItem fSelectMenu;
    private MenuItem fEditMatrixMenu;
    private MenuItem fEditMenu;
    private MenuItem fDeleteMenu;
    private MenuItem fCalcOptionsMenu;
    private MenuItem fSendToGraph;
    private MenuItem fSaveMenu;
    private MenuItem fRevertMenu;
    private MenuItem fInvertMatrixMenu;
    public CheckboxMenuItem fMatrixViewMenu;
    private WindowMenuHandler fWindowMenuHandler;

    public MatrixViewPanel(Calculator calculator, Color color) {
        this.setTitle(fp_resource.getString("str_matrix_view"));
        this.fCalc = calculator;
        ((Component)this).setBackground(color);
        this.fField = new MatrixView(this, calculator, color);
        this.setLayout(new BorderLayout());
        this.addNotify();
        this.validate();
        this.fVert = new Scrollbar(1);
        this.add("East", this.fVert);
        this.fHoriz = new Scrollbar(0);
        this.add("South", this.fHoriz);
        this.add("Center", this.fField);
        this.addComponentListener(new 1());
        this.addWindowListener(new 2());
        this.createMenus();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        WindowMenuHandler.synchHandlers();
    }

    public boolean handleEvent(Event event) {
        if (event.id == 605 || event.id == 602 || event.id == 601 || event.id == 604 || event.id == 603) {
            this.fField.translate(this.fHoriz.getValue(), this.fVert.getValue());
            this.fField.repaint();
            return true;
        }
        if (event.id == 201) {
            this.fCalc.setMatrixMode(false);
            this.setVisible(false);
            return false;
        }
        return super.handleEvent(event);
    }

    public MatrixView field() {
        return this.fField;
    }

    public synchronized void paint(Graphics graphics) {
        if (!this.fInitialized) {
            this.myResize();
        }
    }

    public void setHScrollVal(int n) {
        this.fHoriz.setValue(n);
    }

    public void setVScrollVal(int n) {
        this.fVert.setValue(n);
    }

    public void scrollToBottom() {
        this.setVScrollVal(this.fVert.getMaximum());
        this.fField.translate(this.fHoriz.getValue(), this.fVert.getValue());
    }

    public void scrollToRight() {
        int n = this.fHoriz.getValue();
        n += 10;
        this.fField.translate(this.fHoriz.getValue(), this.fVert.getValue());
    }

    public void setScrollSettings() {
        int n = this.fField.getSize().height;
        int n2 = this.fField.getSize().width;
        int n3 = this.fField.pageHeight();
        int n4 = this.fField.pageWidth();
        this.fVert.setMinimum(0);
        this.fVert.setMaximum(n3);
        this.fVert.setVisibleAmount(n);
        this.fHoriz.setMinimum(0);
        this.fHoriz.setMaximum(n4);
        this.fHoriz.setVisibleAmount(n2);
        this.fVert.setBlockIncrement(n / 10);
        this.fHoriz.setBlockIncrement(n2 / 10);
        this.fVert.setUnitIncrement(n / 10);
        this.fHoriz.setUnitIncrement(n2 / 10);
    }

    public void myResize(int n, int n2, int n3, int n4) {
        this.fInitialized = true;
        this.setScrollSettings();
    }

    public void myResize() {
        this.myResize(this.getBounds().x, this.getBounds().y, this.getBounds().width, this.getBounds().height);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void createMenus() {
        this.fMenuBar = new MenuBar();
        this.fMenuBar.setFont(FPMenuItem.FNT);
        Menu menu = new Menu(fp_resource.getString("str_file"));
        menu.setFont(FPMenuItem.FNT);
        menu.add(this.fCalc.makeMenuItem(fp_resource.getString("str_new"), 78));
        menu.add(this.fCalc.makeMenuItem(fp_resource.getString("str_open"), 79));
        menu.addSeparator();
        menu.add(this.fCalc.makeMenuItem(fp_resource.getString("str_close")));
        this.fSaveMenu = this.fCalc.makeMenuItem(fp_resource.getString("str_save_window"), 83);
        menu.add(this.fSaveMenu);
        menu.add(this.fCalc.makeMenuItem(fp_resource.getString("str_save_window_as")));
        this.fRevertMenu = this.fCalc.makeMenuItem(fp_resource.getString("str_revert"));
        menu.add(this.fRevertMenu);
        menu.addSeparator();
        menu.add(this.fCalc.makeMenuItem(fp_resource.getString("str_new_workspace")));
        menu.add(this.fCalc.makeMenuItem(fp_resource.getString("str_load_workspace")));
        menu.add(this.fCalc.makeMenuItem(fp_resource.getString("str_save_workspace")));
        menu.addSeparator();
        menu.add(this.fCalc.makeMenuItem(fp_resource.getString("str_print_matrix_view"), 80));
        menu.addSeparator();
        menu.add(this.fCalc.makeMenuItem(fp_resource.getString("str_quit_function_probe"), 81));
        this.fMenuBar.add(menu);
        menu = new Menu(fp_resource.getString("str_edit"));
        menu.setFont(FPMenuItem.FNT);
        menu.add(this.fCalc.makeMenuItem(fp_resource.getString("str_cant_undo"), 90, false));
        menu.addSeparator();
        menu.add(this.fCalc.makeMenuItem(fp_resource.getString("str_cut"), 88));
        menu.add(this.fCalc.makeMenuItem(fp_resource.getString("str_copy"), 67));
        menu.add(this.fCalc.makeMenuItem(fp_resource.getString("str_paste"), 86));
        menu.add(this.fCalc.makeMenuItem(fp_resource.getString("str_clear"), 66));
        menu.addSeparator();
        menu.add(this.fCalc.makeMenuItem(fp_resource.getString("str_clear_history")));
        this.fMenuBar.add(menu);
        menu = new Menu(fp_resource.getString("str_send"));
        menu.setFont(FPMenuItem.FNT);
        menu.add(this.fCalc.makeMenuItem(fp_resource.getString("str_value_to_table")));
        menu.addSeparator();
        this.fSendToGraph = this.fCalc.makeMenuItem(fp_resource.getString("str_button_to_grapher"));
        menu.add(this.fSendToGraph);
        this.fMenuBar.add(menu);
        this.fWindowMenuHandler = new WindowMenuHandler(this);
        this.fMenuBar.add(this.fWindowMenuHandler.menu());
        this.fCalcMenu = new Menu(fp_resource.getString("str_matrix_commands"));
        this.fCalcMenu.setFont(FPMenuItem.FNT);
        this.fAddMenu = this.fCalc.makeMenuItem(String.valueOf(fp_resource.getString("str_make_button")) + "...");
        this.fCalcMenu.add(this.fAddMenu);
        this.fAddInverseMenu = this.fCalc.makeMenuItem(fp_resource.getString("str_define_inverse"));
        this.fCalcMenu.add(this.fAddInverseMenu);
        this.fSelectMenu = this.fCalc.makeMenuItem(fp_resource.getString("str_select_button"));
        this.fCalcMenu.add(this.fSelectMenu);
        this.fEditMenu = this.fCalc.makeMenuItem(fp_resource.getString("str_edit_button"));
        this.fCalcMenu.add(this.fEditMenu);
        this.fDeleteMenu = this.fCalc.makeMenuItem(fp_resource.getString("str_delete_button"));
        this.fCalcMenu.add(this.fDeleteMenu);
        this.fCalcMenu.addSeparator();
        this.fMatrixViewMenu = new CheckboxMenuItem(fp_resource.getString("str_matrix_view"));
        this.fMatrixViewMenu.setFont(FPMenuItem.FNT);
        this.fMatrixViewMenu.addItemListener(this);
        this.fCalcMenu.add(this.fMatrixViewMenu);
        this.fClearMatrixViewMenu = this.fCalc.makeMenuItem(fp_resource.getString("str_clear_matrix_view"));
        this.fCalcMenu.add(this.fClearMatrixViewMenu);
        this.fCreateMatrixMenu = this.fCalc.makeMenuItem(fp_resource.getString("str_create_matrix"));
        this.fCalcMenu.add(this.fCreateMatrixMenu);
        this.fCallMatrixMenu = this.fCalc.makeMenuItem(fp_resource.getString("str_call_matrix"));
        this.fCalcMenu.add(this.fCallMatrixMenu);
        this.fEditMatrixMenu = this.fCalc.makeMenuItem(fp_resource.getString("str_edit_matrix"));
        this.fCalcMenu.add(this.fEditMatrixMenu);
        this.fRenameMatrixMenu = this.fCalc.makeMenuItem(fp_resource.getString("str_rename_matrix"));
        this.fCalcMenu.add(this.fRenameMatrixMenu);
        this.fAugmentMatrixMenu = this.fCalc.makeMenuItem(fp_resource.getString("str_augment_matrix"));
        this.fCalcMenu.add(this.fAugmentMatrixMenu);
        this.fInvertMatrixMenu = this.fCalc.makeMenuItem(fp_resource.getString("str_invert_matrix"));
        this.fSolveSystemMenu = this.fCalc.makeMenuItem(fp_resource.getString("str_solve_system"));
        this.fRowOperationsMenu = this.fCalc.makeMenuItem(fp_resource.getString("str_row_operations"));
        this.fCalcMenu.add(this.fRowOperationsMenu);
        this.fCalcMenu.addSeparator();
        this.fInverseMenu = this.fCalc.makeMenuItem(fp_resource.getString("str_show_inverses"), 73);
        this.fCalcMenu.add(this.fInverseMenu);
        this.fRadMenu = this.fCalc.makeMenuItem(fp_resource.getString("str_use_degrees"));
        this.fCalcMenu.add(this.fRadMenu);
        this.fCalcOptionsMenu = this.fCalc.makeMenuItem(fp_resource.getString("str_calculator_options"));
        this.fCalcMenu.add(this.fCalcOptionsMenu);
        this.fMenuBar.add(this.fCalcMenu);
        this.setMenuBar(this.fMenuBar);
    }

    public void updateMenus() {
        this.fSaveMenu.setEnabled(this.fCalc.filename() != null);
        this.fRevertMenu.setEnabled(this.fCalc.filename() != null);
        this.fAddMenu.setEnabled(this.fCalc.matrixMode() ^ true);
        this.fAddInverseMenu.setEnabled(!this.fCalc.matrixMode() && this.fCalc.functions().selectedButton() != -1);
        this.fSelectMenu.setEnabled(this.fCalc.matrixMode() ^ true);
        this.fEditMenu.setEnabled(!this.fCalc.matrixMode() && this.fCalc.functions().selectedButton() != -1);
        this.fDeleteMenu.setEnabled(!this.fCalc.matrixMode() && this.fCalc.functions().selectedButton() != -1);
        this.fClearMatrixViewMenu.setEnabled(this.fCalc.matrixMode());
        this.fCreateMatrixMenu.setEnabled(this.fCalc.matrixMode() && this.fField.allowMatrix());
        this.fRenameMatrixMenu.setEnabled(this.fCalc.matrixMode() && this.fField.isCurrentAMatrix());
        this.fCallMatrixMenu.setEnabled(this.fCalc.matrixMode() && this.fField.allowMatrix());
        this.fAugmentMatrixMenu.setEnabled(this.fCalc.matrixMode() && this.fField.isCurrentAMatrix());
        this.fEditMatrixMenu.setEnabled(this.fCalc.matrixMode() && this.fField.isCurrentAMatrix());
        this.fInvertMatrixMenu.setEnabled(this.fCalc.matrixMode() && this.fField.isCurrentAMatrix() && this.fField.isCurrentSquare());
        if (this.fField.isCurrentMatrixAugmented()) {
            this.fAugmentMatrixMenu.setLabel(fp_resource.getString("str_split_matrix"));
            this.fAugmentMatrixMenu.setActionCommand(fp_resource.getString("str_split_matrix"));
        } else {
            this.fAugmentMatrixMenu.setLabel(fp_resource.getString("str_augment_matrix"));
            this.fAugmentMatrixMenu.setActionCommand(fp_resource.getString("str_augment_matrix"));
        }
        this.fSolveSystemMenu.setEnabled(this.fCalc.matrixMode() && this.fField.isCurrentAMatrix() && this.fField.system());
        this.fRowOperationsMenu.setEnabled(this.fCalc.matrixMode() && this.fField.isCurrentAMatrix());
        this.fInverseMenu.setEnabled(this.fCalc.matrixMode() ^ true);
        this.fRadMenu.setEnabled(this.fCalc.matrixMode() ^ true);
        this.fSendToGraph.setEnabled(!this.fCalc.matrixMode() && this.fCalc.functions().selectedButton() != -1);
        if (this.fCalc.functions().selectedButton() == -1) {
            this.fSelectMenu.setLabel(fp_resource.getString("str_select_button"));
            this.fSelectMenu.setActionCommand(fp_resource.getString("str_select_button"));
        } else {
            this.fSelectMenu.setLabel(fp_resource.getString("str_unselect_button"));
            this.fSelectMenu.setActionCommand(fp_resource.getString("str_unselect_button"));
        }
        this.fWindowMenuHandler.updateMenu();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        String string = (String)itemEvent.getItem();
        if (string.equals(fp_resource.getString("str_matrix_view"))) {
            this.fCalc.setMatrixMode(this.fCalc.matrixMode() ^ true);
            this.fMatrixViewMenu.setState(this.fCalc.matrixMode());
            this.fCalc.fMatrixViewMenu.setState(this.fCalc.matrixMode());
            return;
        }
    }

    public void allowSystemSolve(boolean bl) {
        int n = this.fCalcMenu.getItemCount() - 1;
        if (bl) {
            int n2 = n;
            while (n2 >= n - 3) {
                this.fCalcMenu.remove(n2);
                --n2;
            }
            this.fCalcMenu.add(this.fSolveSystemMenu);
            this.fCalcMenu.addSeparator();
            this.fCalcMenu.add(this.fInverseMenu);
            this.fCalcMenu.add(this.fRadMenu);
            this.fCalcMenu.add(this.fCalcOptionsMenu);
        } else {
            int n3 = n;
            while (n3 >= n - 4) {
                this.fCalcMenu.remove(n3);
                --n3;
            }
            this.fCalcMenu.addSeparator();
            this.fCalcMenu.add(this.fInverseMenu);
            this.fCalcMenu.add(this.fRadMenu);
            this.fCalcMenu.add(this.fCalcOptionsMenu);
        }
    }

    public void allowAutoInverse(boolean bl) {
        int n = this.fCalcMenu.getItemCount() - 1;
        int n2 = 3;
        if (this.fCalc.allowSystemSolve()) {
            ++n2;
        }
        if (bl) {
            int n3 = n;
            while (n3 >= n - n2) {
                this.fCalcMenu.remove(n3);
                --n3;
            }
            this.fCalcMenu.add(this.fInvertMatrixMenu);
            if (n2 == 4) {
                this.fCalcMenu.add(this.fSolveSystemMenu);
            }
            this.fCalcMenu.addSeparator();
            this.fCalcMenu.add(this.fInverseMenu);
            this.fCalcMenu.add(this.fRadMenu);
            this.fCalcMenu.add(this.fCalcOptionsMenu);
        } else {
            int n4 = n;
            while (n4 >= n - (n2 + 1)) {
                this.fCalcMenu.remove(n4);
                --n4;
            }
            if (n2 == 4) {
                this.fCalcMenu.add(this.fSolveSystemMenu);
            }
            this.fCalcMenu.addSeparator();
            this.fCalcMenu.add(this.fInverseMenu);
            this.fCalcMenu.add(this.fRadMenu);
            this.fCalcMenu.add(this.fCalcOptionsMenu);
        }
    }

    public boolean keyDown(Event event, int n) {
        return this.fField.keyDown(event, n);
    }

    public boolean keyUp(Event event, int n) {
        return this.fField.keyUp(event, n);
    }

    private final class 1
    extends ComponentAdapter {
        public void componentResized(ComponentEvent componentEvent) {
            MatrixViewPanel.this.myResize(MatrixViewPanel.this.getBounds().x, MatrixViewPanel.this.getBounds().y, MatrixViewPanel.this.getBounds().width, MatrixViewPanel.this.getBounds().height);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            MatrixViewPanel.this.fCalc.setMatrixMode(false);
            MatrixViewPanel.this.setVisible(false);
        }

        public void windowClosed(WindowEvent windowEvent) {
            MatrixViewPanel.this.fCalc.setMatrixMode(false);
        }

        /* synthetic */ 2() {
        }
    }
}

