/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPCalculator;

import com.questmsm.FPCalculator.CalcUtils;
import com.questmsm.FPCalculator.Calculator;
import com.questmsm.FPCalculator.EditDisplayField;
import com.questmsm.FPCalculator.Evaluator;
import com.questmsm.FPCalculator.Node;
import com.questmsm.FPCalculator.RowContainer;
import com.questmsm.FPCalculator.SpecialTextField;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.Serializable;

public class Row
implements Serializable {
    protected transient RowContainer fContainer;
    protected final int kMaxElements = 100;
    protected int fNumElements = 0;
    protected Node[] fElement = new Node[100];
    protected int[] fTestArray = new int[100];
    protected int fTestElements = 0;
    protected int fTop;
    protected int fHeight;
    protected int fSelectedStart;
    protected int fSelectedStop;
    protected boolean fEditable = false;
    protected boolean fPassive = false;
    protected boolean fInactive = false;
    protected boolean fCancelled = false;
    protected final int kSpacing = 3;
    public static final int kTestDigit = 1;
    public static final int kTestPeriod = 2;
    public static final int kTestOpenParen = 3;
    public static final int kTestCloseParen = 4;
    public static final int kTestOneOp = 5;
    public static final int kTestTwoOp = 6;
    public static final int kTestEquals = 7;
    public static final int kTestQuestion = 8;
    private boolean fDefineButtonRow = false;
    private int fUserButtonNumber = -1;
    private String fUserButtonName = "";
    private boolean fUserButtonCancelled = false;
    private static final Font fFont = new Font("Helvetica", 0, 14);
    private static final Font fButtonNameFont = new Font("Times", 1, 10);
    private static final Font fSmallNameFont = new Font("Times", 1, 9);
    private static final Font fItalicFont = new Font("Helvetica", 2, 14);
    protected static FontMetrics fMetric = null;

    public Row(RowContainer rowContainer, int n, int n2) {
        this.fContainer = rowContainer;
        this.fTop = n;
        this.fHeight = n2;
        this.fSelectedStart = -1;
        this.fSelectedStop = -1;
    }

    public void setRowContainer(RowContainer rowContainer) {
        this.fContainer = rowContainer;
    }

    public static void setMetric(Canvas canvas) {
        fMetric = canvas.getFontMetrics(fFont);
    }

    public void cancel(boolean bl) {
        this.fCancelled = bl;
    }

    public void passive(boolean bl) {
        this.fPassive = bl;
    }

    public boolean passive() {
        return this.fPassive;
    }

    public void editable(boolean bl) {
        this.fEditable = bl;
    }

    public boolean editable() {
        return this.fEditable;
    }

    public void inactive(boolean bl) {
        this.fInactive = bl;
    }

    public boolean inactive() {
        return this.fInactive;
    }

    public int top() {
        return this.fTop;
    }

    public void top(int n) {
        this.fTop = n;
    }

    public int userButtonNum() {
        return this.fUserButtonNumber;
    }

    public void userButtonNum(int n) {
        this.fUserButtonNumber = n;
    }

    public void userButtonName(String string) {
        this.fUserButtonName = string;
    }

    public String userButtonName() {
        return this.fUserButtonName;
    }

    public boolean isEmpty() {
        return this.fNumElements == 0;
    }

    public void userButtonCancel() {
        this.fUserButtonCancelled = true;
        this.fUserButtonNumber = -1;
    }

    public boolean userButtonCancelled() {
        return this.fUserButtonCancelled;
    }

    public boolean defineButtonRow() {
        return this.fDefineButtonRow;
    }

    public void defineButtonRow(boolean bl, int n, String string) {
        this.fDefineButtonRow = bl;
        this.fUserButtonNumber = n;
        this.fUserButtonName = String.valueOf(string) + ":  ";
    }

    public void clear() {
        this.fNumElements = 0;
        this.fSelectedStart = -1;
        this.fSelectedStop = -1;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private void copyToArray() {
        var1_1 = 0;
        while (var1_1 < this.fNumElements) {
            if (this.fElement[var1_1].kind() != 0) ** GOTO lbl23
            switch (this.fElement[var1_1].theChar()) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.fTestArray[var1_1] = 1;
                    break;
                }
                case '.': {
                    this.fTestArray[var1_1] = 2;
                    break;
                }
                case '(': {
                    this.fTestArray[var1_1] = 3;
                    break;
                }
                case ')': {
                    this.fTestArray[var1_1] = 4;
                    break;
                }
                case '=': {
                    this.fTestArray[var1_1] = 7;
                    break;
                }
                case '*': 
                case '+': 
                case '-': 
                case '/': {
                    this.fTestArray[var1_1] = 6;
                    break;
                }
lbl23:
                // 1 sources

                switch (this.fElement[var1_1].functionType()) {
                    case 21: {
                        this.fTestArray[var1_1] = 8;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 105: {
                        this.fTestArray[var1_1] = 5;
                        break;
                    }
                    case 207: 
                    case 208: 
                    case 209: 
                    case 210: {
                        this.fTestArray[var1_1] = 6;
                    }
                }
                break;
            }
            ++var1_1;
        }
        this.fTestElements = this.fNumElements;
    }

    public void deleteTestSelected() {
        int n;
        if (this.fSelectedStart > this.fSelectedStop) {
            n = this.fSelectedStart;
            this.fSelectedStart = this.fSelectedStop;
            this.fSelectedStop = n;
        }
        n = this.fSelectedStop - this.fSelectedStart + 1;
        int n2 = this.fSelectedStart;
        while (n2 < this.fTestElements - n) {
            this.fTestArray[n2] = this.fTestArray[n2 + n];
            ++n2;
        }
        this.fTestElements -= n;
    }

    private boolean insertTest(char c) {
        if (this.fNumElements == 100) {
            return false;
        }
        this.copyToArray();
        if (this.fSelectedStart == -1) {
            this.fSelectedStart = 0;
        }
        if (this.fSelectedStop != -1) {
            this.deleteTestSelected();
        }
        int n = this.fTestElements;
        while (n > this.fSelectedStart) {
            this.fTestArray[n] = this.fTestArray[n - 1];
            --n;
        }
        ++this.fTestElements;
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.fTestArray[this.fSelectedStart] = 1;
                break;
            }
            case '.': {
                this.fTestArray[this.fSelectedStart] = 2;
                break;
            }
            case '(': {
                this.fTestArray[this.fSelectedStart] = 3;
                break;
            }
            case ')': {
                this.fTestArray[this.fSelectedStart] = 4;
                break;
            }
            case '*': 
            case '+': 
            case '-': 
            case '/': {
                this.fTestArray[this.fSelectedStart] = 6;
                break;
            }
            case '=': {
                this.fTestArray[this.fSelectedStart] = 7;
                break;
            }
        }
        return this.testValid();
    }

    public boolean isValid() {
        this.copyToArray();
        return this.testValid() && this.fTestArray[this.fTestElements - 1] == 7;
    }

    private boolean testValid() {
        String string = "Nothing";
        int n = 0;
        if (this.fTestElements == 0) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.fTestElements) {
            switch (this.fTestArray[n2]) {
                case 1: {
                    if (string.equals("Equals")) {
                        return false;
                    }
                    if (string.equals("Close")) {
                        return false;
                    }
                    if (string.equals("OneOp")) {
                        return false;
                    }
                    if (string.equals("PostPeriod")) break;
                    string = "PrePeriod";
                    break;
                }
                case 8: {
                    if (string.equals("PrePeriod")) {
                        return false;
                    }
                }
                case 2: {
                    if (string.equals("Equals")) {
                        return false;
                    }
                    if (string.equals("Close")) {
                        return false;
                    }
                    if (string.equals("OneOp")) {
                        return false;
                    }
                    if (string.equals("PostPeriod")) {
                        return false;
                    }
                    string = "PostPeriod";
                    break;
                }
                case 4: {
                    if (string.equals("Nothing")) {
                        return false;
                    }
                    if (string.equals("Equals")) {
                        return false;
                    }
                    if (string.equals("Open")) {
                        return false;
                    }
                    if (string.equals("TwoOp")) {
                        return false;
                    }
                    if (n == 0) {
                        return false;
                    }
                    --n;
                    string = "Close";
                    break;
                }
                case 3: {
                    if (string.equals("PrePeriod")) {
                        return false;
                    }
                    if (string.equals("PostPeriod")) {
                        return false;
                    }
                    if (string.equals("Equals")) {
                        return false;
                    }
                    if (string.equals("Close")) {
                        return false;
                    }
                    if (string.equals("OneOp")) {
                        return false;
                    }
                    string = "Open";
                    ++n;
                    break;
                }
                case 5: {
                    if (string.equals("Nothing")) {
                        return false;
                    }
                    if (string.equals("Equals")) {
                        return false;
                    }
                    if (string.equals("Open")) {
                        return false;
                    }
                    if (string.equals("TwoOp")) {
                        return false;
                    }
                    string = "OneOp";
                    break;
                }
                case 6: {
                    if (string.equals("Nothing")) {
                        return false;
                    }
                    if (string.equals("Equals")) {
                        return false;
                    }
                    if (string.equals("Open")) {
                        return false;
                    }
                    if (string.equals("TwoOp")) {
                        return false;
                    }
                    string = "TwoOp";
                    break;
                }
                case 7: {
                    if (string.equals("Nothing")) {
                        return false;
                    }
                    if (string.equals("Equals")) {
                        return false;
                    }
                    if (string.equals("Open")) {
                        return false;
                    }
                    if (n > 0) {
                        return false;
                    }
                    if (string.equals("TwoOp")) {
                        return false;
                    }
                    string = "Equals";
                    break;
                }
            }
            ++n2;
        }
        return true;
    }

    public void recalculateFlushLeft() {
        int n = this.fContainer.resultLineLoc();
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.fNumElements) {
            switch (this.fElement[n3].kind()) {
                case 0: {
                    char c = this.fElement[n3].theChar();
                    int n4 = 0;
                    switch (c) {
                        case '.': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            n4 = 0;
                            break;
                        }
                        default: {
                            n4 = 3;
                        }
                    }
                    n2 = fMetric.charWidth(this.fElement[n3].theChar());
                    this.fElement[n3].setSpacing(n, n + 2 * n4 + n2, n4);
                    n += 2 * n4 + n2;
                    break;
                }
                case 2: {
                    if (this.fElement[n3].label().equals("?")) {
                        n2 = 12;
                        this.fElement[n3].setSpacing(n, n + 6 + n2, 3);
                        n += 6 + n2;
                        break;
                    }
                    n2 = this.fElement[n3].itemWidth();
                    this.fElement[n3].setSpacing(n, n + 6 + n2, 3);
                    n += 6 + n2;
                    break;
                }
            }
            ++n3;
        }
    }

    public void recalculatePositions() {
        int n = this.fContainer.resultLineLoc();
        int n2 = 0;
        if (this.fEditable) {
            this.recalculateFlushLeft();
            return;
        }
        int n3 = this.fNumElements - 1;
        while (n3 >= 0) {
            switch (this.fElement[n3].kind()) {
                case 0: {
                    char c = this.fElement[n3].theChar();
                    int n4 = 0;
                    switch (c) {
                        case '.': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            n4 = 0;
                            break;
                        }
                        default: {
                            n4 = 3;
                        }
                    }
                    if (this.fPassive) {
                        n4 = 0;
                    }
                    n2 = fMetric.charWidth(this.fElement[n3].theChar());
                    this.fElement[n3].setSpacing(n - 2 * n4 - n2, n, n4);
                    n = n - 2 * n4 - n2;
                    break;
                }
                case 2: {
                    if (this.fElement[n3].label().equals("?")) {
                        n2 = 12;
                        this.fElement[n3].setSpacing(n - 6 - n2, n, 3);
                        n = n - 6 - n2;
                        break;
                    }
                    n2 = this.fElement[n3].itemWidth();
                    this.fElement[n3].setSpacing(n - 6 - n2, n, 3);
                    n = n - 6 - n2;
                    break;
                }
            }
            --n3;
        }
    }

    public void deleteSelected() {
        int n;
        if (this.fSelectedStart > this.fSelectedStop) {
            n = this.fSelectedStart;
            this.fSelectedStart = this.fSelectedStop;
            this.fSelectedStop = n;
        }
        n = this.fSelectedStop - this.fSelectedStart + 1;
        int n2 = this.fSelectedStart;
        while (n2 < this.fNumElements - n) {
            this.fElement[n2] = this.fElement[n2 + n];
            ++n2;
        }
        this.fNumElements -= n;
        if (this.fNumElements < 0) {
            this.fNumElements = 0;
        }
    }

    public void printall() {
        int n = 0;
        while (n < this.fNumElements) {
            System.out.println(this.fElement[n].theChar());
            ++n;
        }
        System.out.println(" ");
    }

    public void insert(char c) {
        if (this.fNumElements == 100) {
            return;
        }
        if (this.fSelectedStart == -1) {
            this.fSelectedStart = 0;
        }
        if (this.fSelectedStop != -1) {
            this.deleteSelected();
        }
        if (this.fNumElements == 100) {
            return;
        }
        int n = this.fNumElements;
        while (n > this.fSelectedStart) {
            this.fElement[n] = this.fElement[n - 1];
            --n;
        }
        this.fElement[this.fSelectedStart] = new Node(c);
        ++this.fSelectedStart;
        ++this.fNumElements;
        this.fSelectedStop = -1;
        this.recalculatePositions();
    }

    public void backspace() {
        if (this.fNumElements == 0) {
            return;
        }
        if (this.fSelectedStart < 0) {
            return;
        }
        if (this.fSelectedStop == -1) {
            if (this.fSelectedStart == 0) {
                return;
            }
            --this.fSelectedStart;
            this.fSelectedStop = this.fSelectedStart;
            this.deleteSelected();
            this.fSelectedStop = -1;
            this.recalculatePositions();
            return;
        }
        this.deleteSelected();
        this.fSelectedStop = -1;
        this.recalculatePositions();
    }

    public void insert(String string, int n) {
        if (this.fNumElements == 100) {
            return;
        }
        if (this.fSelectedStart == -1) {
            this.fSelectedStart = 0;
        }
        if (this.fSelectedStop != -1) {
            this.deleteSelected();
        }
        if (this.fNumElements == 100) {
            return;
        }
        int n2 = this.fNumElements;
        while (n2 > this.fSelectedStart) {
            this.fElement[n2] = this.fElement[n2 - 1];
            --n2;
        }
        ++this.fNumElements;
        this.fElement[this.fSelectedStart] = new Node(string, n);
        ++this.fSelectedStart;
        this.fSelectedStop = -1;
        this.recalculatePositions();
    }

    public void add(char c) {
        if (this.fNumElements == 100) {
            return;
        }
        this.fElement[this.fNumElements] = new Node(c);
        ++this.fNumElements;
    }

    public void add(String string, int n) {
        if (this.fNumElements == 100) {
            return;
        }
        this.fElement[this.fNumElements] = new Node(string, n);
        ++this.fNumElements;
        this.recalculatePositions();
    }

    public int left() {
        int n = 0;
        if (this.fNumElements > 0) {
            n = this.fElement[0].left();
        }
        int n2 = 0;
        while (n2 < this.fNumElements) {
            if (this.fElement[n2].left() < n) {
                n = this.fElement[n2].left();
            }
            ++n2;
        }
        if (this.fDefineButtonRow && !this.fEditable) {
            n -= fMetric.stringWidth(this.fUserButtonName);
        }
        return n;
    }

    public int right() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.fNumElements) {
            if (this.fElement[n2].right() > n) {
                n = this.fElement[n2].right();
            }
            ++n2;
        }
        return n;
    }

    public void clearSelect() {
        this.fSelectedStart = -1;
        this.fSelectedStop = -1;
    }

    public void draw(Graphics graphics) {
        int n = 0;
        while (n < this.fNumElements) {
            if (this.fCancelled) {
                graphics.setFont(fItalicFont);
            } else {
                graphics.setFont(fFont);
            }
            this.fElement[n].draw(graphics, this.fTop, this.fHeight);
            ++n;
        }
        if (!this.fEditable && this.fDefineButtonRow) {
            int n2 = this.fElement[0].left() - graphics.getFontMetrics(fButtonNameFont).stringWidth(this.fUserButtonName);
            int n3 = this.fTop + this.fHeight / 2 + 3;
            CalcUtils.drawLeft(graphics, this.fUserButtonName, n2, n3, fButtonNameFont, fSmallNameFont);
            if (this.fUserButtonCancelled) {
                graphics.drawLine(n2, n3 - 8, this.fElement[0].left() - 8, n3 + 2);
                graphics.drawLine(n2, n3 + 2, this.fElement[0].left() - 8, n3 - 8);
            }
        }
    }

    private void drawCaret(Graphics graphics, int n) {
        if (!this.fEditable) {
            return;
        }
        graphics.setColor(Color.black);
        graphics.drawLine(n, this.fTop + this.fHeight - 2, n + 3, this.fTop + this.fHeight - 2 + 3);
        graphics.drawLine(n, this.fTop + this.fHeight - 2, n - 3, this.fTop + this.fHeight - 2 + 3);
    }

    public void drawSelected(Graphics graphics) {
        if (this.fPassive) {
            return;
        }
        if (this.fInactive) {
            return;
        }
        if (this.fSelectedStart == -1) {
            return;
        }
        graphics.setFont(fFont);
        if (this.fSelectedStop == -1) {
            if (this.fSelectedStart == this.fNumElements) {
                if (this.fSelectedStart == 0) {
                    this.drawCaret(graphics, this.fContainer.resultLineLoc());
                } else {
                    this.drawCaret(graphics, this.fElement[this.fSelectedStart - 1].right());
                }
                return;
            }
            this.drawCaret(graphics, this.fElement[this.fSelectedStart].left());
            return;
        }
        int n = 0;
        int n2 = 0;
        if (this.fSelectedStart > this.fSelectedStop) {
            n = this.fSelectedStop;
            n2 = this.fSelectedStart;
        } else {
            n = this.fSelectedStart;
            n2 = this.fSelectedStop;
        }
        int n3 = n;
        while (n3 <= n2) {
            if (n2 < this.fNumElements) {
                this.fElement[n3].drawInv(graphics, this.fTop, this.fHeight);
            }
            ++n3;
        }
    }

    public boolean handleDrag(int n, int n2) {
        if (this.fPassive) {
            return false;
        }
        if (this.fInactive) {
            return false;
        }
        if (this.fSelectedStart == -1) {
            return false;
        }
        this.fSelectedStop = -1;
        if (this.fNumElements == 0) {
            return false;
        }
        if (n < this.fElement[0].left()) {
            this.fSelectedStop = 0;
            return true;
        }
        int n3 = 0;
        while (n3 < this.fNumElements) {
            if (n > this.fElement[n3].left() && n < this.fElement[n3].right()) {
                this.fSelectedStop = n3;
                if (this.fSelectedStart >= this.fNumElements) {
                    this.fSelectedStart = this.fNumElements - 1;
                }
                return true;
            }
            ++n3;
        }
        this.fSelectedStop = this.fNumElements - 1;
        if (this.fSelectedStart >= this.fNumElements) {
            this.fSelectedStart = this.fNumElements - 1;
        }
        return false;
    }

    public boolean handleMouse(int n, int n2) {
        return this.handleMouse(n, n2, false);
    }

    public boolean handleMouse(int n, int n2, boolean bl) {
        if (this.fPassive) {
            return false;
        }
        if (this.fInactive) {
            return false;
        }
        this.fSelectedStart = -1;
        if (n2 < this.fTop - 5) {
            return false;
        }
        if (n2 > this.fTop + this.fHeight + 5) {
            return false;
        }
        if (this.fNumElements == 0) {
            this.fSelectedStart = 0;
            this.fSelectedStop = -1;
            return true;
        }
        if (n < this.fElement[0].left()) {
            this.fSelectedStop = -1;
            this.fSelectedStart = 0;
            if (!this.fEditable) {
                this.fSelectedStop = 0;
            }
            return true;
        }
        if (n > this.fElement[this.fNumElements - 1].right() && (bl || n < this.fElement[this.fNumElements - 1].right() + 5)) {
            this.fSelectedStart = this.fNumElements;
            this.fSelectedStop = -1;
            return true;
        }
        int n3 = 0;
        while (n3 < this.fNumElements) {
            if (n > this.fElement[n3].left() && n < this.fElement[n3].right()) {
                this.fSelectedStart = n3;
                this.fSelectedStop = -1;
                if (!this.fEditable) {
                    this.fSelectedStop = n3;
                } else if (n - this.fElement[n3].left() > this.fElement[n3].right() - n) {
                    this.fSelectedStart = n3 + 1;
                }
                return true;
            }
            ++n3;
        }
        return false;
    }

    public void selectAll() {
        this.fSelectedStart = 0;
        this.fSelectedStop = this.fNumElements - 1;
    }

    public int selectedRange() {
        if (this.fSelectedStop == -1) {
            return 0;
        }
        if (this.fSelectedStart > this.fSelectedStop) {
            int n = this.fSelectedStart;
            this.fSelectedStart = this.fSelectedStop;
            this.fSelectedStop = n;
        }
        return this.fSelectedStop - this.fSelectedStart + 1;
    }

    public void transferRow(SpecialTextField specialTextField, Calculator calculator) {
        if (!this.isValid()) {
            return;
        }
        specialTextField.clearRow();
        int n = 0;
        while (n < this.fNumElements) {
            if (this.fElement[n].kind() == 0) {
                calculator.calcCanvas().handleInput(this.fElement[n].theChar(), false);
            } else if (this.fElement[n].kind() == 2) {
                calculator.functionCanvas().process(this.fElement[n].functionType(), this.fElement[n].label(), false);
            }
            ++n;
        }
    }

    public void transferToEdit(EditDisplayField editDisplayField) {
        int n;
        if (this.fDefineButtonRow) {
            this.fSelectedStart = 0;
            this.fSelectedStop = this.fNumElements - 1;
        }
        if (this.fSelectedStop == -1) {
            return;
        }
        if (this.fSelectedStart > this.fSelectedStop) {
            n = this.fSelectedStart;
            this.fSelectedStart = this.fSelectedStop;
            this.fSelectedStop = n;
        }
        editDisplayField.clearRow();
        n = this.fSelectedStart;
        while (n <= this.fSelectedStop) {
            if (this.fElement[n].kind() == 0) {
                editDisplayField.pushToCurrentRow(this.fElement[n].theChar());
            } else if (this.fElement[n].kind() == 2) {
                editDisplayField.pushFunctionToCurrent(this.fElement[n].label(), this.fElement[n].functionType());
            }
            ++n;
        }
        editDisplayField.redraw();
        if (this.fDefineButtonRow) {
            this.fSelectedStart = -1;
            this.fSelectedStop = -1;
        }
    }

    public void transferToEvaluator(Evaluator evaluator) {
        if (!this.isValid()) {
            return;
        }
        int n = 0;
        while (n < this.fNumElements) {
            if (this.fElement[n].kind() == 0) {
                evaluator.add(this.fElement[n].theChar());
            } else if (this.fElement[n].kind() == 2) {
                evaluator.add(this.fElement[n].label(), this.fElement[n].functionType());
            }
            ++n;
        }
    }

    public String string() {
        String string = "";
        int n = 0;
        while (n < this.fNumElements) {
            if (this.fElement[n].kind() == 0) {
                string = String.valueOf(string) + this.fElement[n].theChar();
            }
            ++n;
        }
        return string;
    }

    public boolean functionUsed(int n) {
        if (this.defineButtonRow()) {
            return false;
        }
        if (this.passive()) {
            return false;
        }
        if (this.fInactive) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.fNumElements) {
            if (this.fElement[n2].kind() == 2 && this.fElement[n2].functionType() == -n - 1) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public int numElements() {
        return this.fNumElements;
    }

    public int elementKind(int n) {
        return this.fElement[n].kind();
    }

    public int elementFunction(int n) {
        return this.fElement[n].functionType();
    }

    public String elementFunctionName(int n) {
        return this.fElement[n].label();
    }

    public char elementChar(int n) {
        return this.fElement[n].theChar();
    }
}

