/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPGrapher;

import com.questmsm.FPGrapher.FPAxes;
import com.questmsm.FPGrapher.Grapher;
import com.questmsm.FunctionProbe.Master;
import com.questmsm.Utilities.DialogSuperClass;
import com.questmsm.Utilities.fp_resource;
import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;

public class CurvePalette
extends DialogSuperClass {
    private FPAxes fAxes;
    private static final int kNumIcons = 4;
    private Image[] fIcon = new Image[4];
    private Image fEq1 = null;
    private Image fEq2;
    private Image fEq3;
    private Image fEqR1;
    private Image fEqR2;
    private Image fEqR3;
    public static final int kCurve1 = 0;
    public static final int kCurve2 = 1;
    public static final int kCurve3 = 2;
    public static final int kCurve4 = 3;
    private int[] xloc = new int[4];
    private int[] yloc = new int[4];
    private int fSelected;
    private Grapher fFP;
    private static final int kDeltaY = 32;

    public CurvePalette(FPAxes fPAxes, Grapher grapher) {
        super(grapher);
        this.setModal(false);
        this.setTitle(fp_resource.getString("str_curve_shapes"));
        this.fAxes = fPAxes;
        this.fFP = grapher;
        int n = Master.gSmallTop;
        this.setBounds(0, 0, 144, 64 + n + 10);
        this.setUpPositions();
        this.fSelected = -1;
    }

    private Image subImage(Image image, int n, int n2) {
        Image image2 = this.createImage(32, 32);
        image2.getGraphics().drawImage(image, 0, 0, 32, 32, n * 32 - 1, n2 * 32, n * 32 + 31, n2 * 32 + 32, this);
        return image2;
    }

    private void loadImages() {
        if (Grapher.fGrapherIcons == null) {
            this.fFP.loadGrapherIcons();
        }
        Image image = Grapher.fGrapherIcons;
        this.fIcon[0] = this.subImage(image, 1, 1);
        this.fIcon[1] = this.subImage(image, 1, 2);
        this.fIcon[2] = this.subImage(image, 1, 3);
        this.fIcon[3] = this.subImage(image, 1, 4);
    }

    public void setUpPositions() {
        int n;
        int n2 = Master.gSmallTop;
        boolean bl = true;
        boolean bl2 = true;
        this.xloc[0] = n = 40;
        this.yloc[0] = n2;
        this.xloc[1] = 32 + n;
        this.yloc[1] = n2;
        this.xloc[2] = n;
        this.yloc[2] = 32 + n2;
        this.xloc[3] = 32 + n;
        this.yloc[3] = 32 + n2;
    }

    private void invert(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setXORMode(Color.white);
        graphics.setColor(Color.black);
        graphics.fillRect(n, n2, n3, n4);
        graphics.setPaintMode();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private void drawIcon(Graphics graphics, int n) {
        graphics.drawImage(this.fIcon[n], this.xloc[n], this.yloc[n], this);
        if (this.fSelected == n) {
            this.invert(graphics, this.xloc[n], this.yloc[n], 32, 32);
        }
        graphics.drawRect(this.xloc[n], this.yloc[n], 31, 31);
    }

    public void paint(Graphics graphics) {
        if (this.fIcon[0] == null) {
            this.loadImages();
        }
        graphics.setColor(Color.black);
        this.drawIcon(graphics, 0);
        this.drawIcon(graphics, 1);
        this.drawIcon(graphics, 2);
        this.drawIcon(graphics, 3);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        return this.mouseDrag(event, n, n2);
    }

    public boolean mouseUp(Event event, int n, int n2) {
        switch (this.fSelected) {
            case 0: {
                this.fAxes.drawObjectType(12);
                break;
            }
            case 1: {
                this.fAxes.drawObjectType(13);
                break;
            }
            case 2: {
                this.fAxes.drawObjectType(15);
                break;
            }
            case 3: {
                this.fAxes.drawObjectType(14);
                break;
            }
            default: {
                return true;
            }
        }
        this.fAxes.mode(12);
        this.fFP.toFront();
        this.fSelected = -1;
        this.repaint();
        return super.mouseUp(event, n, n2);
    }

    private boolean inIcon(int n, int n2, int n3) {
        if (n >= this.xloc[n3] && n <= this.xloc[n3] + 32 && n2 >= this.yloc[n3] && n2 <= this.yloc[n3] + 32) {
            if (this.fSelected == n3) {
                return true;
            }
            this.fSelected = n3;
            this.repaint();
            return true;
        }
        return false;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.inIcon(n, n2, 0)) {
            return true;
        }
        if (this.inIcon(n, n2, 1)) {
            return true;
        }
        if (this.inIcon(n, n2, 2)) {
            return true;
        }
        if (this.inIcon(n, n2, 3)) {
            return true;
        }
        this.fSelected = -1;
        return super.mouseDrag(event, n, n2);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.setBoundsWithoutCentering(n, n2, n3, n4);
    }
}

