/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPGrapher;

import com.questmsm.FPGrapher.FPAxes;
import com.questmsm.FPGrapher.FPEquation;
import com.questmsm.FPGrapher.FPFreeHand;
import com.questmsm.FPGrapher.FPGroup;
import com.questmsm.FPGrapher.FPObject;
import com.questmsm.FPGrapher.FPObjectList;
import java.awt.Color;
import java.awt.Graphics;

public class FPSelectionList {
    private static final int kMaxSelections = 200;
    private FPObject[] fObjectArray = new FPObject[200];
    private int fLastSelection = 0;
    private FPAxes fAxes;

    public FPSelectionList(FPAxes fPAxes) {
        this.fAxes = fPAxes;
    }

    public int numObjects() {
        return this.fLastSelection;
    }

    public FPObject objectNum(int n) {
        return this.fObjectArray[n];
    }

    public boolean isEmpty() {
        return this.fLastSelection == 0;
    }

    public boolean inList(FPObject fPObject) {
        int n = 0;
        while (n < this.fLastSelection) {
            if (fPObject == this.fObjectArray[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isCombEquationSelected() {
        int n = 0;
        while (n < this.fLastSelection) {
            if (this.fObjectArray[n].kind() == 13) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void stretchLR(double d, double d2, boolean bl) {
        int n = 0;
        while (n < this.fLastSelection) {
            this.fObjectArray[n].setXFormString(this.fObjectArray[n].getEqString());
            this.fObjectArray[n].stretchLR(d, d2, bl);
            this.fObjectArray[n].anchorY(false);
            this.fObjectArray[n].anchorX(true);
            this.fObjectArray[n].anchorVal(d);
            this.fObjectArray[n].isLast(true);
            this.fObjectArray[n].isXFormed(true);
            this.fAxes.history().addItem(null, this.fObjectArray[n].getXFormString(), "", "");
            this.fAxes.history().setStretchLR(d, d2);
            this.fAxes.addToListNoSelect(this.fObjectArray[n]);
            ++n;
        }
    }

    public void stretchUD(double d, double d2, boolean bl) {
        int n = 0;
        while (n < this.fLastSelection) {
            this.fObjectArray[n].setXFormString(this.fObjectArray[n].getEqString());
            this.fObjectArray[n].stretchUD(d, d2, bl);
            this.fObjectArray[n].anchorX(false);
            this.fObjectArray[n].anchorY(true);
            this.fObjectArray[n].anchorVal(d);
            this.fObjectArray[n].isLast(true);
            this.fObjectArray[n].isXFormed(true);
            this.fAxes.history().addItem(null, this.fObjectArray[n].getXFormString(), "", "");
            this.fAxes.history().setStretchUD(d, d2);
            this.fAxes.addToListNoSelect(this.fObjectArray[n]);
            ++n;
        }
    }

    public void fastStretchLR(int n, double d) {
        int n2 = 0;
        while (n2 < this.fLastSelection) {
            this.fObjectArray[n2].fastStretchLR(n, d);
            ++n2;
        }
    }

    public void fastStretchUD(int n, double d) {
        int n2 = 0;
        while (n2 < this.fLastSelection) {
            this.fObjectArray[n2].fastStretchUD(n, d);
            ++n2;
        }
    }

    public void mirrorx(double d, boolean bl) {
        int n = 0;
        while (n < this.fLastSelection) {
            this.fObjectArray[n].setXFormString(this.fObjectArray[n].getEqString());
            this.fObjectArray[n].mirrorx(d, bl);
            this.fObjectArray[n].anchorX(true);
            this.fObjectArray[n].anchorY(false);
            this.fObjectArray[n].anchorVal(d);
            this.fObjectArray[n].isLast(true);
            this.fObjectArray[n].isXFormed(true);
            this.fAxes.history().addItem(null, this.fObjectArray[n].getXFormString(), "", "");
            this.fAxes.history().setMirrorX(d);
            this.fAxes.addToListNoSelect(this.fObjectArray[n]);
            ++n;
        }
    }

    public void mirrory(double d, boolean bl) {
        int n = 0;
        while (n < this.fLastSelection) {
            this.fObjectArray[n].setXFormString(this.fObjectArray[n].getEqString());
            this.fObjectArray[n].mirrory(d, bl);
            this.fObjectArray[n].anchorX(false);
            this.fObjectArray[n].anchorY(true);
            this.fObjectArray[n].anchorVal(d);
            this.fObjectArray[n].isLast(true);
            this.fObjectArray[n].isXFormed(true);
            this.fAxes.history().addItem(null, this.fObjectArray[n].getXFormString(), "", "");
            this.fAxes.history().setMirrorY(d);
            this.fAxes.addToListNoSelect(this.fObjectArray[n]);
            ++n;
        }
    }

    public void mirrorxy(boolean bl, boolean bl2) {
        int n = 0;
        while (n < this.fLastSelection) {
            block4: {
                block3: {
                    if (this.fObjectArray[n].kind() != 0) break block3;
                    FPEquation fPEquation = (FPEquation)this.fObjectArray[n];
                    fPEquation.calculate(this.fAxes);
                    FPFreeHand fPFreeHand = fPEquation.convertToFreehand();
                    if (fPFreeHand == null) break block4;
                    fPFreeHand.setEqString("Inv(" + fPEquation.getEqString() + ")");
                    this.fObjectArray[n] = fPFreeHand;
                }
                this.fObjectArray[n].setXFormString(this.fObjectArray[n].getEqString());
                this.fObjectArray[n].mirrorxy(bl, bl2);
                this.fObjectArray[n].anchorX(false);
                this.fObjectArray[n].anchorY(false);
                this.fObjectArray[n].isLast(true);
                this.fObjectArray[n].isXFormed(true);
                this.fAxes.history().addItem(null, this.fObjectArray[n].getXFormString(), "", "");
                this.fAxes.history().setMirrorXY();
                this.fAxes.addToListNoSelect(this.fObjectArray[n]);
            }
            ++n;
        }
    }

    public void translate(double d, double d2, boolean bl, boolean bl2) {
        int n = 0;
        while (n < this.fLastSelection) {
            if (Math.abs(d2) < 0.001) {
                this.fObjectArray[n].setXFormString(this.fObjectArray[n].getEqString());
            } else {
                this.fObjectArray[n].setXFormString(this.fObjectArray[n].getEqString());
            }
            this.fObjectArray[n].translate(d, d2, bl, bl2);
            this.fObjectArray[n].anchorX(false);
            this.fObjectArray[n].anchorY(false);
            this.fObjectArray[n].isLast(true);
            this.fObjectArray[n].isXFormed(true);
            this.fAxes.history().addItem(null, this.fObjectArray[n].getXFormString(), "", "");
            if (Math.abs(d2) < 0.001) {
                this.fAxes.history().setTranslateLR(d);
            } else {
                this.fAxes.history().setTranslateUD(d2);
            }
            this.fAxes.addToListNoSelect(this.fObjectArray[n]);
            ++n;
        }
    }

    public void drawVerticalArrows(Graphics graphics, int n) {
        int n2 = 0;
        while (n2 < this.fLastSelection) {
            this.fObjectArray[n2].drawVerticalArrows(graphics, n);
            ++n2;
        }
    }

    public void drawHorizontalArrows(Graphics graphics, int n) {
        int n2 = 0;
        while (n2 < this.fLastSelection) {
            this.fObjectArray[n2].drawHorizontalArrows(graphics, n);
            ++n2;
        }
    }

    public void calculate(FPAxes fPAxes) {
        int n = 0;
        while (n < this.fLastSelection) {
            this.fObjectArray[n].calculate(fPAxes);
            this.fObjectArray[n].copyToOld();
            ++n;
        }
    }

    public void fastTranslate(int n, int n2) {
        int n3 = 0;
        while (n3 < this.fLastSelection) {
            this.fObjectArray[n3].fastTranslate(n, n2);
            ++n3;
        }
    }

    public FPObject first() {
        if (this.fLastSelection == 0) {
            return null;
        }
        return this.fObjectArray[0];
    }

    public FPObject last() {
        if (this.fLastSelection == 0) {
            return null;
        }
        return this.fObjectArray[this.fLastSelection - 1];
    }

    public void setColor(Color color) {
        int n = 0;
        while (n < this.fLastSelection) {
            this.fObjectArray[n].setColor(color);
            ++n;
        }
    }

    public void delete() {
        int n = 0;
        while (n < this.fLastSelection) {
            this.fObjectArray[n].deleted(true);
            ++n;
        }
        this.fAxes.parent().undoer().objectsDeleted(this.fObjectArray, this.fLastSelection);
        this.clear();
    }

    public void copy(FPObjectList fPObjectList, FPAxes fPAxes) {
        int n = 0;
        while (n < this.fLastSelection) {
            FPObject fPObject = this.fObjectArray[n].copy();
            this.fObjectArray[n].calculate(fPAxes);
            this.fObjectArray[n].isLast(false);
            fPObject.isXFormed(this.fObjectArray[n].isXFormed());
            fPObject.anchorX(this.fObjectArray[n].anchorX());
            fPObject.anchorY(this.fObjectArray[n].anchorY());
            fPObject.anchorVal(this.fObjectArray[n].anchorVal());
            this.fObjectArray[n] = fPObject;
            ++n;
        }
    }

    public void deleteOthers(FPObjectList fPObjectList) {
        int n = fPObjectList.numObjects();
        if (n <= this.fLastSelection) {
            return;
        }
        FPObject[] fPObjectArray = new FPObject[n];
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >= 0) {
            boolean bl = true;
            int n4 = 0;
            while (n4 < this.fLastSelection) {
                if (fPObjectList.objectNum(n3) == this.fObjectArray[n4]) {
                    bl = false;
                    break;
                }
                ++n4;
            }
            if (bl && !fPObjectList.objectNum(n3).deleted()) {
                fPObjectArray[n2] = fPObjectList.objectNum(n3);
                fPObjectArray[n2].deleted(true);
                ++n2;
            }
            --n3;
        }
        if (n2 > 0) {
            this.fAxes.parent().undoer().objectsDeleted(fPObjectArray, n2);
        }
    }

    private void deleteFromList(int n) {
        int n2 = n;
        while (n2 < this.fLastSelection - 1) {
            this.fObjectArray[n2] = this.fObjectArray[n2 + 1];
            ++n2;
        }
        this.fObjectArray[this.fLastSelection - 1] = null;
        --this.fLastSelection;
    }

    public void addToList(FPObject fPObject) {
        if (fPObject.deleted()) {
            return;
        }
        if (fPObject == null) {
            return;
        }
        int n = 0;
        while (n < this.fLastSelection) {
            if (this.fObjectArray[n] == fPObject) {
                this.deleteFromList(n);
                return;
            }
            ++n;
        }
        if (this.fLastSelection >= 200) {
            return;
        }
        this.fObjectArray[this.fLastSelection++] = fPObject;
        fPObject.copyToOld();
    }

    public void clear() {
        int n = 0;
        while (n < this.fLastSelection) {
            this.fObjectArray[n] = null;
            ++n;
        }
        this.fLastSelection = 0;
    }

    public void draw(Graphics graphics, FPAxes fPAxes) {
        boolean bl = false;
        int n = 0;
        while (n < this.fLastSelection) {
            if (!this.fObjectArray[n].deleted()) {
                if (this.fObjectArray[n].kind() == 0 && ((FPEquation)this.fObjectArray[n]).inequality()) {
                    bl = true;
                }
                this.fObjectArray[n].select(true);
                this.fObjectArray[n].draw(graphics);
                this.fObjectArray[n].select(false);
                if (fPAxes.fShowAnchors) {
                    if (this.fObjectArray[n].anchorX()) {
                        fPAxes.drawAnchorLineX(graphics, this.fObjectArray[n].anchorVal());
                    } else if (this.fObjectArray[n].anchorY()) {
                        fPAxes.drawAnchorLineY(graphics, this.fObjectArray[n].anchorVal());
                    } else if (this.fObjectArray[n].isMirrorXY()) {
                        fPAxes.drawAnchorLineXY(graphics, this.fObjectArray[n].anchorVal());
                    }
                }
            }
            ++n;
        }
        if (bl) {
            this.fAxes.drawGridLines(graphics);
            this.fAxes.drawTickLabels(graphics);
        }
    }

    public FPGroup groupToCut(FPAxes fPAxes) {
        FPGroup fPGroup = this.groupToCopy(fPAxes);
        this.delete();
        return fPGroup;
    }

    public FPGroup groupToCopy(FPAxes fPAxes) {
        FPGroup fPGroup = new FPGroup(fPAxes.parent().colorPalette().nextColor());
        int n = 0;
        while (n < this.fLastSelection) {
            fPGroup.add(this.fObjectArray[n], fPAxes, false);
            ++n;
        }
        return fPGroup;
    }

    public void group(FPAxes fPAxes) {
        FPGroup fPGroup = this.groupToCut(fPAxes);
        fPAxes.addToList(fPGroup);
    }

    public void ungroup(FPAxes fPAxes) {
        if (this.fObjectArray[0].kind() != 12) {
            return;
        }
        FPGroup fPGroup = (FPGroup)this.fObjectArray[0];
        this.delete();
        int n = 0;
        while (n < fPGroup.numObjects()) {
            FPObject fPObject = fPGroup.objectNum(n);
            fPAxes.addToListNoSelect(fPObject);
            fPAxes.selectObjectWithoutClearing(fPObject);
            ++n;
        }
    }

    public boolean mouseMove(int n, int n2, FPAxes fPAxes) {
        int n3 = 0;
        while (n3 < this.fLastSelection) {
            if (!this.fObjectArray[n3].deleted() && this.fObjectArray[n3].mouseDown(n, n2, fPAxes)) {
                return true;
            }
            ++n3;
        }
        return false;
    }
}

