/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPTable;

import com.questmsm.FPTable.TablePanel;
import com.questmsm.FPTable.TableRPNConverter;
import com.questmsm.FunctionProbe.Master;
import com.questmsm.Utilities.BadComputationException;
import com.questmsm.Utilities.FPNumberFormatException;
import com.questmsm.Utilities.fp_resource;
import com.questmsm.Utilities.utils;

public class TableEquation {
    protected double[] fInstructions = new double[50];
    protected int fLastInstruction;
    protected static double[] fStack = new double[50];
    public static final int kEnd = -1;
    public static final int kPushConst = 1;
    public static final int kAdd = 3;
    public static final int kSub = 4;
    public static final int kMult = 5;
    public static final int kDiv = 6;
    public static final int kPow = 7;
    public static final int kSqrt = 8;
    public static final int kSin = 9;
    public static final int kCos = 10;
    public static final int kTan = 11;
    public static final int kASin = 12;
    public static final int kACos = 13;
    public static final int kATan = 14;
    public static final int kE = 15;
    public static final int kLn = 16;
    public static final int kDiff = 17;
    public static final int kFloor = 21;
    public static final int kCalcButton = 22;
    public static final int kCeil = 23;
    public static final int kCsc = 24;
    public static final int kCot = 25;
    public static final int kSec = 26;
    public static final int kStep = 27;
    public static final int kRound = 28;
    public static final int kOtherEq = 30;
    public static final transient int kCosh = 31;
    public static final transient int kSinh = 32;
    public static final transient int kTanh = 33;
    public static final transient int kSech = 34;
    public static final transient int kCsch = 35;
    public static final transient int kCoth = 36;
    public static final transient int kASec = 37;
    public static final transient int kACsc = 38;
    public static final transient int kACot = 39;
    public static final transient int kSgn = 40;
    public static final transient int kFrac = 41;
    public static final transient int kInt = 42;
    public static final transient int kAbs = 43;
    public static final transient int kMod = 44;
    public static final transient int kIDiv = 45;
    protected static final double kBadResult = -1.23456123;
    public static final double kErrorResult = -0.7654321;
    private String fEquationString;
    private static TableRPNConverter fConverter = new TableRPNConverter();
    private static final double threshhold = 1.0E-12;

    public TableEquation(String string, TablePanel tablePanel) {
        this.fEquationString = string;
        fConverter.tablePanel(tablePanel);
        if (string.length() == 0) {
            this.fInstructions[0] = 0.0;
            this.fLastInstruction = 0;
        } else {
            this.stringToEquation(string);
        }
    }

    private void stringToEquation(String string) {
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = fConverter.convert(new StringBuffer(string));
        if (stringBuffer == null) {
            return;
        }
        String string2 = stringBuffer.toString();
        this.fLastInstruction = 0;
        block15: do {
            boolean bl;
            String string3;
            if ((n2 = utils.getNextSpace(string2, n)) == -1) {
                return;
            }
            try {
                string3 = string2.substring(n, n2);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                break;
            }
            n = n2 + 1;
            if (string3.length() == 1) {
                char c = string3.charAt(0);
                if (Character.isLetter(c)) {
                    this.fInstructions[this.fLastInstruction++] = c;
                    continue;
                }
                switch (c) {
                    case '+': {
                        this.fInstructions[this.fLastInstruction++] = 3.0;
                        break;
                    }
                    case '-': {
                        this.fInstructions[this.fLastInstruction++] = 4.0;
                        break;
                    }
                    case '/': {
                        this.fInstructions[this.fLastInstruction++] = 6.0;
                        break;
                    }
                    case '*': {
                        this.fInstructions[this.fLastInstruction++] = 5.0;
                        break;
                    }
                    case '^': {
                        this.fInstructions[this.fLastInstruction++] = 7.0;
                        break;
                    }
                    default: {
                        double d;
                        boolean bl2 = true;
                        try {
                            d = Double.valueOf(string3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            d = 0.0;
                            bl2 = false;
                        }
                        if (!bl2) continue block15;
                        this.fInstructions[this.fLastInstruction++] = 1.0;
                        this.fInstructions[this.fLastInstruction++] = d;
                        break;
                    }
                }
                continue;
            }
            if (string3.equals("sqrt")) {
                this.fInstructions[this.fLastInstruction++] = 8.0;
                continue;
            }
            if (string3.equals(fp_resource.sin) || string3.equals("sin")) {
                this.fInstructions[this.fLastInstruction++] = 9.0;
                continue;
            }
            if (string3.equals(fp_resource.cos) || string3.equals("cos")) {
                this.fInstructions[this.fLastInstruction++] = 10.0;
                continue;
            }
            if (string3.equals(fp_resource.tan) || string3.equals("tan")) {
                this.fInstructions[this.fLastInstruction++] = 11.0;
                continue;
            }
            if (string3.equals("asin")) {
                this.fInstructions[this.fLastInstruction++] = 12.0;
                continue;
            }
            if (string3.equals("acos")) {
                this.fInstructions[this.fLastInstruction++] = 13.0;
                continue;
            }
            if (string3.equals("atan")) {
                this.fInstructions[this.fLastInstruction++] = 14.0;
                continue;
            }
            if (string3.equals("log")) {
                this.fInstructions[this.fLastInstruction++] = 16.0;
                continue;
            }
            if (string3.equals("dif")) {
                this.fInstructions[this.fLastInstruction++] = 17.0;
                continue;
            }
            if (string3.equals("step")) {
                this.fInstructions[this.fLastInstruction++] = 27.0;
                continue;
            }
            if (string3.equals("round")) {
                this.fInstructions[this.fLastInstruction++] = 28.0;
                continue;
            }
            if (string3.equals("sec")) {
                this.fInstructions[this.fLastInstruction++] = 26.0;
                continue;
            }
            if (string3.equals("csc")) {
                this.fInstructions[this.fLastInstruction++] = 24.0;
                continue;
            }
            if (string3.equals("cot")) {
                this.fInstructions[this.fLastInstruction++] = 25.0;
                continue;
            }
            if (string3.equals("sinh")) {
                this.fInstructions[this.fLastInstruction++] = 32.0;
                continue;
            }
            if (string3.equals("cosh")) {
                this.fInstructions[this.fLastInstruction++] = 31.0;
                continue;
            }
            if (string3.equals("tanh")) {
                this.fInstructions[this.fLastInstruction++] = 33.0;
                continue;
            }
            if (string3.equals("csch")) {
                this.fInstructions[this.fLastInstruction++] = 35.0;
                continue;
            }
            if (string3.equals("coth")) {
                this.fInstructions[this.fLastInstruction++] = 36.0;
                continue;
            }
            if (string3.equals("sech")) {
                this.fInstructions[this.fLastInstruction++] = 34.0;
                continue;
            }
            if (string3.equals("asec")) {
                this.fInstructions[this.fLastInstruction++] = 37.0;
                continue;
            }
            if (string3.equals("acsc")) {
                this.fInstructions[this.fLastInstruction++] = 38.0;
                continue;
            }
            if (string3.equals("acot")) {
                this.fInstructions[this.fLastInstruction++] = 39.0;
                continue;
            }
            if (string3.equals("sgn")) {
                this.fInstructions[this.fLastInstruction++] = 40.0;
                continue;
            }
            if (string3.equals("frac")) {
                this.fInstructions[this.fLastInstruction++] = 41.0;
                continue;
            }
            if (string3.equals("int")) {
                this.fInstructions[this.fLastInstruction++] = 42.0;
                continue;
            }
            if (string3.equals("abs")) {
                this.fInstructions[this.fLastInstruction++] = 43.0;
                continue;
            }
            if (string3.equals("mod")) {
                this.fInstructions[this.fLastInstruction++] = 44.0;
                continue;
            }
            if (string3.equals("div")) {
                this.fInstructions[this.fLastInstruction++] = 45.0;
                continue;
            }
            if (string3.equals("floor")) {
                this.fInstructions[this.fLastInstruction++] = 21.0;
                continue;
            }
            if (string3.equals("ceil")) {
                this.fInstructions[this.fLastInstruction++] = 23.0;
                continue;
            }
            if (string3.charAt(0) == 'B') {
                this.fInstructions[this.fLastInstruction++] = 22.0;
                this.fInstructions[this.fLastInstruction++] = string3.charAt(1) - 48;
                continue;
            }
            if (string3.charAt(0) == 'G') {
                double d = 0.0;
                bl = true;
                try {
                    utils.str2num(string3.substring(1, string3.length()));
                }
                catch (FPNumberFormatException fPNumberFormatException) {
                    bl = false;
                }
                if (!bl) continue;
                this.fInstructions[this.fLastInstruction++] = 30.0;
                this.fInstructions[this.fLastInstruction++] = d;
                continue;
            }
            double d = 0.0;
            bl = true;
            try {
                d = Double.valueOf(string3);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
            if (!bl) continue;
            this.fInstructions[this.fLastInstruction++] = 1.0;
            this.fInstructions[this.fLastInstruction++] = d;
        } while (n < string2.length());
        this.fInstructions[this.fLastInstruction] = -1.0;
        ++this.fLastInstruction;
    }

    public double eval(TablePanel tablePanel, double d) throws BadComputationException {
        return this.eval(tablePanel, d, false);
    }

    public boolean hasDifference() {
        int n = 0;
        while (n < this.fLastInstruction) {
            if (this.fInstructions[n] == 17.0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public double eval(TablePanel tablePanel, double d, boolean bl) throws BadComputationException {
        int n = -1;
        int n2 = 0;
        while (n2 <= this.fLastInstruction) {
            int n3 = (int)this.fInstructions[n2];
            if (n3 == -1) {
                if (n != 0) {
                    this.showError();
                    throw new BadComputationException();
                }
                return fStack[n];
            }
            char c = (char)n3;
            if (Character.isLetter(c)) {
                if (bl) {
                    TableEquation.fStack[++n] = 0.5;
                } else {
                    double d2 = tablePanel.getVal(c, d);
                    if (d2 == -1.23456123) {
                        return -1.23456123;
                    }
                    if (d2 == -0.7654321) {
                        throw new BadComputationException();
                    }
                    TableEquation.fStack[++n] = d2;
                }
            } else {
                try {
                    switch (n3) {
                        case 1: {
                            if (n < -1) {
                                this.showError();
                                throw new BadComputationException();
                            }
                            TableEquation.fStack[++n] = this.fInstructions[++n2];
                            break;
                        }
                        case 3: {
                            if (n < 1) {
                                this.showError();
                                throw new BadComputationException();
                            }
                            TableEquation.fStack[n - 1] = fStack[n - 1] + fStack[n];
                            if (fStack[--n] == Double.MAX_VALUE) {
                                throw new BadComputationException();
                            }
                            break;
                        }
                        case 4: {
                            if (n < 1) {
                                this.showError();
                                throw new BadComputationException();
                            }
                            TableEquation.fStack[n - 1] = fStack[n - 1] - fStack[n];
                            --n;
                            break;
                        }
                        case 5: {
                            if (n < 1) {
                                this.showError();
                                throw new BadComputationException();
                            }
                            TableEquation.fStack[n - 1] = fStack[n - 1] * fStack[n];
                            if (fStack[--n] == Double.MAX_VALUE) {
                                throw new BadComputationException();
                            }
                            break;
                        }
                        case 6: {
                            if (n < 1) {
                                this.showError();
                                throw new BadComputationException();
                            }
                            if (fStack[n] == 0.0) {
                                throw new BadComputationException();
                            }
                            TableEquation.fStack[n - 1] = fStack[n - 1] / fStack[n];
                            --n;
                            break;
                        }
                        case 7: {
                            if (n < 1) {
                                this.showError();
                                throw new BadComputationException();
                            }
                            if (fStack[n] == 0.0) {
                                throw new BadComputationException();
                            }
                            try {
                                TableEquation.fStack[n - 1] = Math.pow(fStack[n - 1], fStack[n]);
                            }
                            catch (ArithmeticException arithmeticException) {
                                throw new BadComputationException();
                            }
                            if (fStack[--n] == Double.MAX_VALUE) {
                                throw new BadComputationException();
                            }
                            break;
                        }
                        case 8: {
                            if (n < 0) {
                                this.showError();
                                throw new BadComputationException();
                            }
                            TableEquation.fStack[n] = Math.sqrt(fStack[n]);
                            if (Double.isNaN(fStack[n])) {
                                throw new BadComputationException("Negative square root.");
                            }
                            break;
                        }
                        case 32: {
                            TableEquation.fStack[n] = (Math.exp(fStack[n]) - Math.exp(-fStack[n])) / 2.0;
                            break;
                        }
                        case 31: {
                            TableEquation.fStack[n] = (Math.exp(fStack[n]) + Math.exp(-fStack[n])) / 2.0;
                            break;
                        }
                        case 33: {
                            TableEquation.fStack[n] = (Math.exp(fStack[n]) - Math.exp(-fStack[n])) / (Math.exp(fStack[n]) + Math.exp(-fStack[n]));
                            break;
                        }
                        case 35: {
                            TableEquation.fStack[n] = 2.0 / (Math.exp(fStack[n]) - Math.exp(-fStack[n]));
                            break;
                        }
                        case 34: {
                            TableEquation.fStack[n] = 2.0 / (Math.exp(fStack[n]) + Math.exp(-fStack[n]));
                            break;
                        }
                        case 36: {
                            TableEquation.fStack[n] = (Math.exp(fStack[n]) + Math.exp(-fStack[n])) / (Math.exp(fStack[n]) - Math.exp(-fStack[n]));
                            break;
                        }
                        case 37: {
                            if (Math.abs(fStack[n]) < 1.0) {
                                throw new BadComputationException();
                            }
                            TableEquation.fStack[n] = Math.acos(1.0 / fStack[n]);
                            break;
                        }
                        case 38: {
                            if (Math.abs(fStack[n]) < 1.0) {
                                throw new BadComputationException();
                            }
                            TableEquation.fStack[n] = Math.asin(1.0 / fStack[n]);
                            break;
                        }
                        case 39: {
                            TableEquation.fStack[n] = Math.atan(1.0 / fStack[n]);
                            break;
                        }
                        case 40: {
                            TableEquation.fStack[n] = fStack[n] < 0.0 ? -1.0 : 1.0;
                            break;
                        }
                        case 41: {
                            TableEquation.fStack[n] = fStack[n] - (double)((int)fStack[n]);
                            break;
                        }
                        case 42: {
                            TableEquation.fStack[n] = (int)fStack[n];
                            break;
                        }
                        case 43: {
                            TableEquation.fStack[n] = Math.abs(fStack[n]);
                            break;
                        }
                        case 44: {
                            TableEquation.fStack[n - 1] = Math.IEEEremainder(fStack[n - 1], fStack[n]);
                            --n;
                            break;
                        }
                        case 45: {
                            TableEquation.fStack[n - 1] = (int)(fStack[n - 1] / fStack[n]);
                            --n;
                            break;
                        }
                        case 9: {
                            if (n < 0) {
                                this.showError();
                                throw new BadComputationException();
                            }
                            TableEquation.fStack[n] = Math.sin(fStack[n]);
                            break;
                        }
                        case 10: {
                            if (n < 0) {
                                this.showError();
                                throw new BadComputationException();
                            }
                            TableEquation.fStack[n] = Math.cos(fStack[n]);
                            break;
                        }
                        case 11: {
                            double d3;
                            if (n < 0) {
                                this.showError();
                                throw new BadComputationException();
                            }
                            double d4 = fStack[n];
                            if (Math.abs(Math.IEEEremainder(d4, Math.PI)) < 1.0E-12) {
                                d3 = 0.0;
                            } else {
                                if (Math.abs(Math.IEEEremainder(d4 - 1.5707963267948966, Math.PI)) < 1.0E-12) {
                                    throw new BadComputationException();
                                }
                                d3 = Math.tan(d4);
                            }
                            TableEquation.fStack[n] = d3;
                            break;
                        }
                        case 12: {
                            if (n < 0) {
                                this.showError();
                                throw new BadComputationException();
                            }
                            if (Math.abs(fStack[n]) > 1.0) {
                                throw new BadComputationException();
                            }
                            TableEquation.fStack[n] = Math.asin(fStack[n]);
                            break;
                        }
                        case 13: {
                            if (n < 0) {
                                this.showError();
                                throw new BadComputationException();
                            }
                            if (Math.abs(fStack[n]) > 1.0) {
                                throw new BadComputationException();
                            }
                            TableEquation.fStack[n] = Math.acos(fStack[n]);
                            break;
                        }
                        case 14: {
                            if (n < 0) {
                                this.showError();
                                throw new BadComputationException();
                            }
                            TableEquation.fStack[n] = Math.atan(fStack[n]);
                            break;
                        }
                        case 15: {
                            if (n < 0) {
                                this.showError();
                                throw new BadComputationException();
                            }
                            TableEquation.fStack[n] = Math.exp(fStack[n]);
                            if (fStack[n] == Double.MAX_VALUE) {
                                throw new BadComputationException();
                            }
                            break;
                        }
                        case 16: {
                            if (n < 0) {
                                this.showError();
                                throw new BadComputationException();
                            }
                            if (fStack[n] <= 0.0) {
                                throw new BadComputationException();
                            }
                            TableEquation.fStack[n] = Math.log(fStack[n]);
                            break;
                        }
                        case 17: {
                            if (n < 0) {
                                this.showError();
                                throw new BadComputationException();
                            }
                            if ((int)fStack[n] == -1) {
                                throw new BadComputationException();
                            }
                            TableEquation.fStack[n] = tablePanel.getDifference((int)fStack[n], d);
                            if (fStack[n] == -1.23456123) {
                                return fStack[n];
                            }
                            break;
                        }
                        case 30: {
                            int n4 = (int)this.fInstructions[++n2];
                            TableEquation.fStack[n] = Master.evaluate("G" + n4, fStack[n]);
                            if (fStack[n] == -1.23456123) {
                                throw new BadComputationException();
                            }
                            break;
                        }
                        case 22: {
                            int n4 = (int)this.fInstructions[++n2];
                            TableEquation.fStack[n] = Master.evaluate("B" + n4, fStack[n]);
                            if (fStack[n] == -1.23456123) {
                                throw new BadComputationException();
                            }
                            break;
                        }
                        case 24: {
                            if (Math.sin(fStack[n]) == 0.0) {
                                throw new BadComputationException();
                            }
                            TableEquation.fStack[n] = 1.0 / Math.sin(fStack[n]);
                            break;
                        }
                        case 25: {
                            if (Math.tan(fStack[n]) == 0.0) {
                                throw new BadComputationException();
                            }
                            TableEquation.fStack[n] = 1.0 / Math.tan(fStack[n]);
                            break;
                        }
                        case 26: {
                            if (Math.cos(fStack[n]) == 0.0) {
                                throw new BadComputationException();
                            }
                            TableEquation.fStack[n] = 1.0 / Math.cos(fStack[n]);
                            break;
                        }
                        case 27: {
                            TableEquation.fStack[n] = fStack[n] >= 0.0 ? 1.0 : 0.0;
                            break;
                        }
                        case 28: {
                            TableEquation.fStack[n] = Math.round(fStack[n]);
                            break;
                        }
                        case 21: {
                            TableEquation.fStack[n] = Math.floor(fStack[n]);
                            break;
                        }
                        case 23: {
                            TableEquation.fStack[n] = Math.ceil(fStack[n]);
                            break;
                        }
                        default: {
                            if (n < -1) {
                                this.showError();
                                throw new BadComputationException();
                            }
                            throw new BadComputationException();
                        }
                    }
                }
                catch (ArithmeticException arithmeticException) {
                    throw new BadComputationException();
                }
            }
            ++n2;
        }
        return fStack[n];
    }

    private void showError() {
    }
}

