/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPTable;

import com.questmsm.FPTable.Column;
import com.questmsm.FPTable.Interval;
import com.questmsm.FPTable.Table;
import com.questmsm.FPTable.TableHolder;
import com.questmsm.FPTable.TableRow;
import com.questmsm.FPTable.TableVariableTag;
import com.questmsm.Utilities.fp_resource;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;

public class TableShell
extends Panel {
    protected TableHolder fPanel;
    protected Table fTable;
    protected int fNumRows = 14;
    public static final int kDefaultColumnWidth = 64;
    protected static final int kDefaultColumns = 5;
    private Image fBackgroundImage = null;
    private Image fForegroundImage = null;
    private Graphics fBackgroundGraphics = null;
    private Graphics fForegroundGraphics = null;
    public int dx;
    public int dy;
    protected int fNumDecimalPlaces = 2;
    protected Column fFirstCol;
    protected Column fLastCol;
    protected Column[] fLinkedCols = new Column[30];
    protected int fNumLinkedCols = 0;
    protected boolean fGloballyLinked = false;
    protected boolean fActOnLinks = true;
    protected int fSelectedRow = -1;
    protected int fSelectedStopRow = -1;
    protected Column fSelectedCol = null;
    protected TableVariableTag fXTag;
    protected TableVariableTag fYTag;
    protected TableVariableTag fTTag;
    protected TableVariableTag fThTag;
    protected TableVariableTag fRTag;
    protected boolean fShowDependencies = false;
    protected boolean fAllowComplexFill = false;
    protected boolean fAllowIterateFill = false;
    protected boolean fSelectingColumns = false;
    protected boolean fMakingIntervals = false;
    protected boolean fDraggingInterval = false;
    protected boolean fSelectingIntervals = false;
    protected int fNumOldIntervals = 0;
    protected Interval[] fOldIntervals = new Interval[300];
    protected int fRunawayFill = 50;
    protected int fDragRow = -1;
    protected boolean fDisplayAsEquations = false;
    private static final int kEquationRow = -3;
    private static final int kLabelRow = -4;
    private boolean fRowValueChanged = false;
    public static final int kXYMode = 0;
    public static final int kXYTMode = 1;
    public static final int kRThMode = 2;
    public static final int kRThTMode = 3;
    private int fVarMode = 0;
    static Column[] cols = new Column[30];
    private boolean twoWereSelected = false;
    private int mousedownrow = -1;

    public TableShell(TableHolder tableHolder, Table table, Color color) {
        this.fTable = table;
        this.fPanel = tableHolder;
        this.setBackground(color);
        this.dx = 0;
        this.dy = 0;
        int n = 0;
        while (n < 300) {
            this.fOldIntervals[n] = new Interval();
            ++n;
        }
        this.addKeyListener(new 1());
        this.addMouseListener(new 2());
        this.addMouseMotionListener(new 3());
    }

    public synchronized void createImages(int n, int n2) {
        this.fBackgroundImage = this.createImage(n, n2);
        this.fBackgroundGraphics = this.fBackgroundImage.getGraphics();
        this.fForegroundImage = this.createImage(n, n2);
        this.fForegroundGraphics = this.fForegroundImage.getGraphics();
    }

    public int right() {
        return this.getSize().width + this.dx;
    }

    public int maxHeight() {
        return this.fFirstCol.bottom();
    }

    public int maxWidth() {
        return this.fLastCol.right();
    }

    public boolean equationRowSelected() {
        return this.fSelectedRow == -3;
    }

    public boolean labelRowSelected() {
        return this.fSelectedRow == -4;
    }

    public void updateVars() {
        Column column = this.fFirstCol;
        while (column != null) {
            column.updateVars();
            column = column.next;
        }
    }

    public void recalculate() {
        int n = 0;
        int n2 = this.getSize().height;
        Column column = this.fFirstCol;
        while (column != null) {
            if (column.left() + column.width() > this.dx) {
                if (column.left() > this.dx + this.getSize().width) break;
                column.recalculatePositions(this.dy, this.dy + this.getSize().height);
                n = column.bottom();
                if (n > n2) {
                    n2 = n;
                }
            }
            column = column.next;
        }
        this.fPanel.setScrollSettings();
    }

    public void setBounds(int n, int n2, int n3, int n4, boolean bl) {
        super.setBounds(n, n2, n3, n4);
        if (bl) {
            this.recalculate();
        }
        this.createImages(this.getSize().width, this.getSize().height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.setBounds(n, n2, n3, n4, true);
    }

    public void setBounds() {
        this.setBounds(this.getLocation().x, this.getLocation().y, this.getSize().width, this.getSize().height);
    }

    public TableHolder panel() {
        return this.fPanel;
    }

    public void cantUndo() {
        this.fTable.cantUndo();
    }

    public void copyToUndo(String string) {
        this.fTable.copyToUndo(string);
    }

    public void drawDataLine(int n) {
        this.repaint();
        Graphics graphics = this.getGraphics();
        graphics.setColor(Color.red);
        graphics.drawLine(0, n, this.getSize().width, n);
        graphics.setColor(Color.black);
    }

    public void makeSureXVisible(int n) {
        int n2;
        if (n > this.dx + this.getSize().width) {
            int n3 = n - this.getSize().width + 5;
            if (n3 < this.maxWidth() - this.getSize().width) {
                this.fPanel.setHScrollVal(n3);
                this.translate(n3, this.dy);
            }
        } else if (n < this.dx && (n2 = this.dx - 5) > 0) {
            this.fPanel.setHScrollVal(n2);
            this.translate(n2, this.dy);
        }
    }

    public void repositionTags() {
        switch (this.fVarMode) {
            case 0: {
                if (this.fXTag.column() == this.fYTag.column()) {
                    this.fXTag.setPos(1);
                    this.fYTag.setPos(2);
                    break;
                }
                this.fXTag.setPos(0);
                this.fYTag.setPos(0);
                break;
            }
            case 1: {
                if (this.fXTag.column() == this.fYTag.column() && this.fXTag.column() == this.fTTag.column()) {
                    this.fXTag.setPos(3);
                    this.fYTag.setPos(0);
                    this.fTTag.setPos(4);
                    break;
                }
                if (this.fXTag.column() == this.fYTag.column()) {
                    this.fXTag.setPos(1);
                    this.fYTag.setPos(2);
                    this.fTTag.setPos(0);
                    break;
                }
                if (this.fXTag.column() == this.fTTag.column()) {
                    this.fXTag.setPos(1);
                    this.fYTag.setPos(0);
                    this.fTTag.setPos(2);
                    break;
                }
                if (this.fYTag.column() == this.fTTag.column()) {
                    this.fXTag.setPos(0);
                    this.fYTag.setPos(1);
                    this.fTTag.setPos(2);
                    break;
                }
                this.fXTag.setPos(0);
                this.fYTag.setPos(0);
                this.fTTag.setPos(0);
                break;
            }
            case 2: {
                if (this.fRTag.column() == this.fThTag.column()) {
                    this.fRTag.setPos(1);
                    this.fThTag.setPos(2);
                    break;
                }
                this.fRTag.setPos(0);
                this.fThTag.setPos(0);
                break;
            }
            case 3: {
                if (this.fRTag.column() == this.fThTag.column() && this.fRTag.column() == this.fTTag.column()) {
                    this.fRTag.setPos(3);
                    this.fThTag.setPos(0);
                    this.fTTag.setPos(4);
                    break;
                }
                if (this.fRTag.column() == this.fThTag.column()) {
                    this.fRTag.setPos(1);
                    this.fThTag.setPos(2);
                    this.fTTag.setPos(0);
                    break;
                }
                if (this.fRTag.column() == this.fTTag.column()) {
                    this.fRTag.setPos(1);
                    this.fThTag.setPos(0);
                    this.fTTag.setPos(2);
                    break;
                }
                if (this.fThTag.column() == this.fTTag.column()) {
                    this.fRTag.setPos(0);
                    this.fThTag.setPos(1);
                    this.fTTag.setPos(2);
                    break;
                }
                this.fRTag.setPos(0);
                this.fThTag.setPos(0);
                this.fTTag.setPos(0);
                break;
            }
        }
    }

    private boolean handleTagMouseUp(TableVariableTag tableVariableTag, int n, int n2) {
        if (tableVariableTag.dragging()) {
            tableVariableTag.dragging(false);
            if (n < this.fFirstCol.left()) {
                tableVariableTag.column(this.fFirstCol);
            } else if (n > this.fLastCol.right()) {
                tableVariableTag.column(this.fLastCol);
            } else {
                Column column = this.fFirstCol;
                while (column != null) {
                    if (n >= column.left() && n <= column.right()) {
                        tableVariableTag.column(column);
                        break;
                    }
                    column = column.next;
                }
            }
            this.repositionTags();
            this.redraw(false);
            return true;
        }
        return false;
    }

    private boolean handleTagMouseDrag(TableVariableTag tableVariableTag, int n, int n2) {
        if (tableVariableTag.dragging()) {
            tableVariableTag.setDragCoords(n, n2);
            this.repaint();
            return true;
        }
        return false;
    }

    private boolean handleTagMouseDown(TableVariableTag tableVariableTag, int n, int n2) {
        if (tableVariableTag.inTag(n, n2)) {
            tableVariableTag.column(null);
            tableVariableTag.dragging(true);
            tableVariableTag.setDragCoords(n, n2);
            this.redraw(false);
            return true;
        }
        return false;
    }

    private void clearSelects(Column column, int n) {
        if (this.fSelectedCol == column && this.fSelectedRow == n) {
            return;
        }
        this.clearSelects();
    }

    protected void selectRow(int n) {
        this.selectRows(n, n);
    }

    protected void selectRows(int n, int n2) {
        this.fSelectedRow = n;
        this.fSelectedStopRow = n2;
        this.fRowValueChanged = false;
        this.fTable.updateMenus();
    }

    protected void clearSelects() {
        this.fTable.updateMenus();
        if (this.fSelectedCol == null) {
            this.selectRow(-1);
            return;
        }
        if (this.equationRowSelected()) {
            this.fSelectedCol.equationRow().clearSelects();
            this.fSelectedCol.updateVars();
            this.reevaluate();
            this.fSelectedCol = null;
            this.selectRow(-1);
            return;
        }
        if (this.labelRowSelected()) {
            this.fSelectedCol.labelRow().clearSelects();
            this.fSelectedCol = null;
            this.selectRow(-1);
            return;
        }
        this.fSelectedCol.clearSelects(this.fSelectedRow, this.fSelectedStopRow);
        this.selectRow(-1);
        this.fSelectedCol = null;
    }

    protected void addARowNoRedraw() {
        ++this.fNumRows;
        Column column = this.fFirstCol;
        while (column != null) {
            column.rows(this.fNumRows);
            column = column.next;
        }
        this.fPanel.setScrollSettings();
        this.dy = this.fPanel.scrollToBottom();
    }

    protected void addARow() {
        this.addARowNoRedraw();
        this.redraw(true);
    }

    public void setRows(int n) {
        this.fNumRows = n;
        Column column = this.fFirstCol;
        while (column != null) {
            column.rows(this.fNumRows);
            column = column.next;
        }
        this.fPanel.setScrollSettings();
    }

    public void updateCell(Column column, int n) {
        if (column == null) {
            return;
        }
        if (column.dependent()) {
            return;
        }
        if (n >= this.fNumRows) {
            return;
        }
        if (n < 0) {
            this.fBackgroundGraphics.translate(-this.dx, 0);
            column.row(n).draw(this.fBackgroundGraphics);
            this.fBackgroundGraphics.translate(this.dx, 0);
        } else {
            TableRow tableRow = column.row(n);
            if (tableRow.bottom() < this.dy + Column.dataTop()) {
                return;
            }
            if (tableRow.top() > this.dy + this.getSize().height) {
                return;
            }
            this.fBackgroundGraphics.translate(-this.dx, -this.dy);
            tableRow.draw(this.fBackgroundGraphics, Column.dataTop() + this.dy);
            Column column2 = this.fFirstCol;
            while (column2 != null) {
                if (column2.dependent()) {
                    if (column2.equationType() == 1 || column2.equationType() == 2 || column2.equationType() == 3 || column2.equationType() == 5 || column2.equationType() == 4) {
                        column2.reevaluate();
                        if (column2.right() >= this.dx && column2.left() <= this.dx + this.getSize().width) {
                            column2.draw(this.fBackgroundGraphics, this.dy, this.dy + this.getSize().height);
                            this.fBackgroundGraphics.translate(0, this.dy);
                            column2.drawTopRows(this.fBackgroundGraphics);
                            this.fBackgroundGraphics.translate(0, -this.dy);
                        }
                    } else {
                        column2.reevaluate(n + column.nudgeFactor() / 2);
                        if (column2.right() >= this.dx && column2.left() <= this.dx + this.getSize().width) {
                            double d = (double)(column.nudgeFactor() - column2.nudgeFactor()) / 2.0;
                            int n2 = 0;
                            n2 = d == (double)((int)d) ? n + (int)d : n + (int)d - 1;
                            if (n2 < this.fNumRows && n2 >= 0) {
                                column2.row(n2).draw(this.fBackgroundGraphics);
                            }
                        }
                    }
                }
                column2 = column2.next;
            }
            this.fBackgroundGraphics.translate(this.dx, this.dy);
        }
    }

    public Column prevColumn() {
        if (this.fSelectedCol == null) {
            return null;
        }
        Column column = this.fFirstCol;
        while (column.next != this.fSelectedCol) {
            column = column.next;
            if (column != null) continue;
            return null;
        }
        return column;
    }

    public void translate(int n, int n2) {
        this.dx = n;
        this.dy = n2;
        this.redraw(true);
    }

    public void reevaluate() {
        Column column = this.fFirstCol;
        while (column != null) {
            column.reevaluate();
            column = column.next;
        }
    }

    public void reevaluate(int n) {
        Column column = this.fFirstCol;
        while (column != null) {
            column.reevaluate(n);
            column = column.next;
        }
    }

    public boolean selectColumns() {
        return this.fSelectingColumns;
    }

    public void selectColumns(boolean bl) {
        this.fSelectingColumns = bl;
        Column column = this.fFirstCol;
        while (column != null) {
            column.selected(false);
            column = column.next;
        }
    }

    public void deleteCells() {
        if (this.fSelectedCol == null) {
            return;
        }
        if (this.fSelectedCol.linked() && this.fActOnLinks) {
            int n = 0;
            while (n < this.fNumLinkedCols) {
                this.fLinkedCols[n].deleteRows(this.fSelectedRow, this.fSelectedStopRow);
                ++n;
            }
        } else {
            this.fSelectedCol.deleteRows(this.fSelectedRow, this.fSelectedStopRow);
        }
        this.fSelectedCol.row(this.fSelectedRow).selectAll();
        this.selectRow(this.fSelectedRow);
    }

    public void insertCell() {
        if (this.fSelectedCol == null) {
            return;
        }
        if (this.fSelectedCol.linked() && this.fActOnLinks) {
            int n = 0;
            while (n < this.fNumLinkedCols) {
                this.fLinkedCols[n].insertRows(this.fSelectedRow - 1, 1);
                this.fLinkedCols[n].row(this.fSelectedRow).setVal("");
                ++n;
            }
        } else {
            this.fSelectedCol.insertRows(this.fSelectedRow - 1, 1);
            this.fSelectedCol.row(this.fSelectedRow).setVal("");
        }
        this.fSelectedCol.row(this.fSelectedRow).selectAll();
        this.selectRow(this.fSelectedRow);
    }

    public int varMode() {
        return this.fVarMode;
    }

    public void varMode(int n) {
        this.fVarMode = n;
    }

    public Table parent() {
        return this.fTable;
    }

    public boolean inDataRows() {
        return this.fSelectedRow >= 0;
    }

    public boolean columnSelected() {
        return this.fSelectedCol != null;
    }

    public int numRowsSelected() {
        if (this.fSelectedCol == null) {
            return 0;
        }
        if (this.fSelectedRow < 0) {
            return 0;
        }
        if (this.fSelectedStopRow < 0) {
            return 0;
        }
        return this.fSelectedStopRow - this.fSelectedRow + 1;
    }

    public int numColumns() {
        int n = 0;
        Column column = this.fFirstCol;
        while (column != null) {
            ++n;
            column = column.next;
        }
        return n;
    }

    public int numRows() {
        return this.fNumRows;
    }

    public void numRows(int n) {
        this.fNumRows = n;
    }

    public Column firstCol() {
        return this.fFirstCol;
    }

    public boolean displayAsEquations() {
        return this.fDisplayAsEquations;
    }

    public void displayAsEquations(boolean bl) {
        this.fDisplayAsEquations = bl;
    }

    public void clearSelectsNoUpdate() {
        this.fSelectedCol = null;
        this.selectRow(-1);
    }

    public void makeVPointVisible(int n) {
        if (n < this.dy + Column.dataTop()) {
            this.dy = n - Column.dataTop();
            this.translate(this.dx, this.dy);
            this.fPanel.setVScrollVal(this.dy);
            this.fPanel.repaint();
        } else if (n > this.dy + this.getSize().height) {
            this.dy = n - this.getSize().height;
            this.translate(this.dx, this.dy);
            this.fPanel.setVScrollVal(this.dy);
            this.fPanel.repaint();
        }
    }

    public void makeCurrentRowVisible() {
        if (this.fSelectedCol == null) {
            return;
        }
        if (this.fSelectedRow < 0) {
            return;
        }
        TableRow tableRow = this.fSelectedCol.row(this.fSelectedRow);
        if (tableRow == null) {
            return;
        }
        if (tableRow.top() < this.dy + Column.dataTop()) {
            this.dy = tableRow.top() - Column.dataTop();
            this.translate(this.dx, this.dy);
            this.fPanel.setVScrollVal(this.dy);
            this.fPanel.repaint();
            return;
        }
        if (tableRow.bottom() > this.dy + this.getSize().height) {
            this.dy = tableRow.bottom() - this.getSize().height;
            this.translate(this.dx, this.dy);
            this.fPanel.setVScrollVal(this.dy);
            this.fPanel.repaint();
            return;
        }
        if (this.fSelectedCol.right() > this.dx + this.getSize().width) {
            this.dx = this.fSelectedCol.right() - this.getSize().width;
            this.fPanel.setHScrollVal(this.dx);
            this.translate(this.dx, this.dy);
            this.fPanel.repaint();
        } else if (this.fSelectedCol.left() < this.dx) {
            this.dx = this.fSelectedCol.left();
            this.fPanel.setHScrollVal(this.dx);
            this.translate(this.dx, this.dy);
            this.fPanel.repaint();
        }
    }

    private boolean equationRowLostFocus() {
        this.fSelectedCol.updateVars();
        this.reevaluate();
        this.fSelectedCol.equationRow().clearSelects();
        this.redraw(false);
        return false;
    }

    private boolean labelRowLostFocus() {
        this.redraw(false);
        return false;
    }

    private boolean regularRowLostFocus() {
        this.fSelectedCol.row(this.fSelectedRow).clearSelects();
        this.updateCell(this.fSelectedCol, this.fSelectedRow);
        return false;
    }

    private boolean handleLostFocus() {
        if (this.fSelectedCol == null) {
            return false;
        }
        if (!this.fRowValueChanged) {
            return false;
        }
        if (this.fSelectedRow >= 0) {
            return this.regularRowLostFocus();
        }
        if (this.labelRowSelected()) {
            return this.labelRowLostFocus();
        }
        if (this.equationRowSelected()) {
            return this.equationRowLostFocus();
        }
        return false;
    }

    private void handleUpKey() {
        if (this.fSelectedCol == null) {
            return;
        }
        if (!this.handleLostFocus()) {
            if (this.fSelectedRow > 0) {
                --this.fSelectedRow;
            } else if (this.fSelectedRow == 0) {
                this.fSelectedRow = -4;
            } else if (this.labelRowSelected()) {
                this.fSelectedRow = -3;
            }
        }
        this.selectRow(this.fSelectedRow);
        this.fSelectedCol.row(this.fSelectedRow).selectAll();
        this.makeCurrentRowVisible();
        this.repaint();
    }

    private void handleDownKey() {
        if (this.fSelectedCol == null) {
            return;
        }
        if (!this.handleLostFocus()) {
            if (this.fSelectedRow >= 0) {
                ++this.fSelectedRow;
            } else if (this.equationRowSelected()) {
                this.fSelectedRow = -4;
            } else if (this.labelRowSelected()) {
                this.fSelectedRow = 0;
            }
            if (this.fSelectedRow == this.fNumRows) {
                --this.fSelectedRow;
            }
        }
        this.selectRow(this.fSelectedRow);
        this.fSelectedCol.row(this.fSelectedRow).selectAll();
        this.makeCurrentRowVisible();
        this.repaint();
    }

    private void handleLeftKey() {
        if (this.fSelectedCol == null) {
            return;
        }
        if (this.fSelectedCol.tryToMoveLeft(this.fSelectedRow)) {
            this.repaint();
            return;
        }
        if (this.fSelectedCol == this.fFirstCol) {
            return;
        }
        if (!this.handleLostFocus()) {
            this.fSelectedCol = this.prevColumn();
        }
        this.fSelectedCol.row(this.fSelectedRow).selectAll();
        this.makeCurrentRowVisible();
        this.repaint();
    }

    private void handleRightKey() {
        if (this.fSelectedCol == null) {
            return;
        }
        if (this.fSelectedCol.tryToMoveRight(this.fSelectedRow)) {
            this.repaint();
            return;
        }
        if (this.fSelectedCol == this.fLastCol) {
            return;
        }
        if (!this.handleLostFocus()) {
            this.fSelectedCol = this.fSelectedCol.next;
        }
        this.selectRow(this.fSelectedRow);
        this.fSelectedCol.row(this.fSelectedRow).selectAll();
        this.makeCurrentRowVisible();
        this.repaint();
    }

    private void handleTabKey() {
        if (this.handleLostFocus()) {
            return;
        }
        if (this.fSelectedCol == null) {
            this.fSelectedCol = this.fFirstCol;
        } else {
            this.fSelectedCol = this.fSelectedCol.next;
            if (this.fSelectedCol == null) {
                this.fSelectedCol = this.fFirstCol;
            }
        }
        if (this.fSelectedRow == -1) {
            this.selectRow(0);
        } else {
            this.selectRow(this.fSelectedRow);
        }
        this.fSelectedCol.row(this.fSelectedRow).selectAll();
        this.makeCurrentRowVisible();
        this.repaint();
    }

    private boolean handleBackspaceKey() {
        if (this.fSelectedRow != this.fSelectedStopRow) {
            if (this.fSelectedCol.dependent()) {
                return true;
            }
            this.copyToUndo(fp_resource.getString("str_undo_delete_cells"));
            this.deleteCells();
            this.reevaluate();
            this.redraw(true);
            return true;
        }
        return false;
    }

    private void handleReturnKey() {
        if (this.fSelectedCol == null) {
            this.fSelectedCol = this.fFirstCol;
            this.selectRow(0);
        } else if (!this.handleLostFocus()) {
            if (this.equationRowSelected()) {
                this.selectRow(-4);
                this.fSelectedCol.labelRow().selectAll();
            } else {
                if (this.fSelectedRow == -4) {
                    this.fSelectedCol.labelRow().insert('\n');
                    this.fSelectedCol.labelRow().recalculateFlushCenter(this.fSelectedCol.left(), this.fSelectedCol.width(), 30, this.fSelectedCol.top() - 30);
                    this.updateCell(this.fSelectedCol, this.fSelectedRow);
                    this.fRowValueChanged = true;
                    this.cantUndo();
                    this.fTable.updateMenus();
                    this.repaint();
                    return;
                }
                ++this.fSelectedRow;
                this.selectRow(this.fSelectedRow);
            }
        }
        this.selectRow(this.fSelectedRow);
        if (this.fSelectedRow >= this.fNumRows) {
            if (this.fSelectedCol.dependent()) {
                --this.fSelectedRow;
            } else {
                this.addARow();
            }
        }
        this.fSelectedCol.row(this.fSelectedRow).selectAll();
        this.makeCurrentRowVisible();
        this.repaint();
    }

    public boolean selectIntervals() {
        return this.fSelectingIntervals;
    }

    public void selectIntervals(boolean bl) {
        this.fSelectingIntervals = bl;
        if (this.fSelectedCol == null) {
            return;
        }
        this.fSelectedCol.deselectIntervals();
    }

    public void draggingInterval(boolean bl) {
        this.fDraggingInterval = bl;
    }

    public void makingIntervals(boolean bl) {
        this.fMakingIntervals = bl;
        this.draggingInterval(false);
        this.fDragRow = -1;
    }

    public void setOldIntervals(int n, Interval[] intervalArray) {
        this.fNumOldIntervals = n;
        int n2 = 0;
        while (n2 < n) {
            this.fOldIntervals[n2].set(intervalArray[n2]);
            ++n2;
        }
    }

    public int numOldIntervals() {
        return this.fNumOldIntervals;
    }

    public void selectAllIntervals() {
        if (this.fSelectedCol == null) {
            return;
        }
        this.selectIntervals(true);
        this.fSelectedCol.selectAllIntervals();
    }

    public int numLinkedCols() {
        return this.fNumLinkedCols;
    }

    public boolean globallyLinked() {
        return this.fGloballyLinked;
    }

    public void globallyLinked(boolean bl) {
        this.fGloballyLinked = bl;
        if (bl) {
            this.fNumLinkedCols = 0;
            Column column = this.fFirstCol;
            while (column != null) {
                this.linkColumn(column);
                column = column.next;
            }
            this.fPanel.repaint();
        }
    }

    public void linkColumns() {
        this.fNumLinkedCols = 0;
        Column column = this.fFirstCol;
        while (column != null) {
            if (column.selected()) {
                this.fLinkedCols[this.fNumLinkedCols] = column;
                column.linked(true);
                ++this.fNumLinkedCols;
            } else {
                column.linked(false);
            }
            column = column.next;
        }
        this.fPanel.repaint();
    }

    public void linkColumn(Column column) {
        this.fLinkedCols[this.fNumLinkedCols] = column;
        column.linked(true);
        ++this.fNumLinkedCols;
    }

    public void unlinkColumns() {
        int n = 0;
        while (n < this.fNumLinkedCols) {
            this.fLinkedCols[n].linked(false);
            ++n;
        }
        this.fNumLinkedCols = 0;
        this.globallyLinked(false);
        this.fPanel.repaint();
    }

    public boolean actOnLinks() {
        return true;
    }

    public void actOnLinks(boolean bl) {
    }

    public void redraw(boolean bl, long l) {
        if (bl) {
            this.recalculate();
        }
        this.drawBackground();
        this.repaint(l);
    }

    public void redraw(boolean bl) {
        this.redraw(bl, 0L);
    }

    protected void drawBackground(Graphics graphics) {
        this.drawBackground(graphics, false);
    }

    protected void printBackground(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        Rectangle rectangle = graphics.getClip().getBounds();
        this.drawBackground(graphics, true);
        Dimension dimension = this.getSize();
        graphics.setColor(Color.white);
        graphics.fillRect(rectangle.width, 0, 10000, 10000);
        graphics.fillRect(0, rectangle.height, 10000, 10000);
    }

    protected void drawBackground(Graphics graphics, boolean bl) {
        if (graphics == null) {
            return;
        }
        int n = this.dx;
        int n2 = this.dy;
        if (bl) {
            n = 0;
            n2 = 0;
        }
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        graphics.setColor(Color.black);
        graphics.translate(-n, -n2);
        Column column = this.fFirstCol;
        while (column != null) {
            if (column.right() >= n && column.left() <= n + this.getSize().width || bl) {
                if (column.selected()) {
                    column.backgroundColor(Color.pink);
                } else {
                    column.backgroundColor(Color.white);
                }
                if (bl) {
                    column.draw(graphics, 0, this.fLastCol.bottom());
                } else {
                    column.draw(graphics, n2, n2 + this.getSize().height);
                }
            }
            column = column.next;
        }
        graphics.translate(0, n2);
        graphics.setColor(Color.black);
        column = this.fFirstCol;
        while (column != null) {
            if (column.right() >= n && column.left() <= n + this.getSize().width || bl) {
                column.drawTopRows(graphics);
            }
            column = column.next;
        }
        if (this.fVarMode == 0 || this.fVarMode == 1) {
            if (!this.fXTag.dragging()) {
                this.fXTag.draw(graphics);
            }
            if (!this.fYTag.dragging()) {
                this.fYTag.draw(graphics);
            }
        } else {
            if (!this.fRTag.dragging()) {
                this.fRTag.draw(graphics);
            }
            if (!this.fThTag.dragging()) {
                this.fThTag.draw(graphics);
            }
        }
        if (!(this.fVarMode != 1 && this.fVarMode != 3 || this.fTTag.dragging())) {
            this.fTTag.draw(graphics);
        }
        graphics.translate(n, 0);
        graphics.setColor(Color.black);
        if (this.fLastCol != null) {
            graphics.drawRect(0, 0, this.fLastCol.right(), this.fLastCol.bottom());
        }
    }

    public synchronized void drawBackground() {
        this.drawBackground(this.fBackgroundGraphics);
    }

    private synchronized void drawForeground(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        graphics.translate(-this.dx, 0);
        if (this.fVarMode == 0 || this.fVarMode == 1) {
            this.fXTag.draw(graphics);
            this.fYTag.draw(graphics);
        } else {
            this.fRTag.draw(graphics);
            this.fThTag.draw(graphics);
        }
        if (this.fVarMode == 1 || this.fVarMode == 3) {
            this.fTTag.draw(graphics);
        }
        if (this.fSelectedCol == null) {
            graphics.translate(this.dx, 0);
            return;
        }
        if (this.equationRowSelected()) {
            this.fSelectedCol.drawRow(graphics, this.fSelectedRow, 0);
            this.fSelectedCol.equationRow().drawSelected(graphics, 0);
            graphics.translate(this.dx, 0);
            return;
        }
        if (this.labelRowSelected()) {
            this.fSelectedCol.drawRow(graphics, this.fSelectedRow, 0);
            this.fSelectedCol.labelRow().drawSelected(graphics, 0);
            graphics.translate(this.dx, 0);
            return;
        }
        graphics.translate(0, -this.dy);
        Column column = this.fFirstCol;
        while (column != null) {
            column.drawIntervals(graphics, this.dy + Column.dataTop(), this.dy + this.getSize().height);
            column = column.next;
        }
        if (this.fDraggingInterval) {
            if (this.fDragRow >= 0) {
                graphics.setColor(Color.red);
                this.fSelectedCol.drawIntSep(graphics, this.fSelectedCol.row(this.fDragRow).bottom());
                graphics.setColor(Color.black);
            }
            graphics.translate(this.dx, this.dy);
            return;
        }
        if (this.fSelectedCol.draggingTag()) {
            this.fSelectedCol.drawTagLine(graphics);
            graphics.translate(this.dx, this.dy);
            return;
        }
        if (this.fSelectedRow == -1 || this.fSelectedCol == null) {
            graphics.translate(this.dx, this.dy);
            return;
        }
        if (this.fSelectedRow == this.fSelectedStopRow) {
            TableRow tableRow = this.fSelectedCol.row(this.fSelectedRow);
            if (tableRow.bottom() < this.dy + Column.dataTop()) {
                graphics.translate(this.dx, this.dy);
                return;
            }
            if (tableRow.top() > this.dy + this.getSize().height) {
                graphics.translate(this.dx, this.dy);
                return;
            }
            this.fSelectedCol.drawRow(graphics, this.fSelectedRow, this.dy + Column.dataTop());
            this.fSelectedCol.drawSelectedRows(graphics, this.dy + Column.dataTop(), this.dy + this.getSize().height, this.fSelectedRow, this.fSelectedStopRow);
            graphics.translate(this.dx, this.dy);
            return;
        }
        int n = 0;
        int n2 = 0;
        if (this.fSelectedRow > this.fSelectedStopRow) {
            n = this.fSelectedStopRow;
            n2 = this.fSelectedRow;
        } else {
            n = this.fSelectedRow;
            n2 = this.fSelectedStopRow;
        }
        if (!this.fSelectedCol.linked() || !this.fActOnLinks) {
            int n3 = n;
            while (n3 <= n2) {
                this.fSelectedCol.row(n3).selectAll();
                ++n3;
            }
            this.fSelectedCol.drawSelectedRows(graphics, this.dy + Column.dataTop(), this.dy + this.getSize().height, n, n2);
        } else {
            int n4 = 0;
            while (n4 < this.fNumLinkedCols) {
                int n5 = n;
                while (n5 <= n2) {
                    this.fLinkedCols[n4].row(n5).selectAll();
                    ++n5;
                }
                this.fLinkedCols[n4].drawSelectedRows(graphics, this.dy + Column.dataTop(), this.dy + this.getSize().height, n, n2);
                ++n4;
            }
        }
        graphics.translate(this.dx, this.dy);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void drawDependencies(Graphics graphics, Column column) {
        if (column == null) {
            return;
        }
        Column[] columnArray = new Column[30];
        int n = column.getDependencies(columnArray);
        if (column != this.fSelectedCol) {
            column.drawHighlightBorder(graphics, this.dy, this.dy + this.getSize().height);
        }
        int n2 = 0;
        while (n2 < n) {
            this.drawDependencies(graphics, columnArray[n2]);
            ++n2;
        }
    }

    public void drawDependencies(Graphics graphics) {
        if (this.fSelectedCol == null) {
            return;
        }
        graphics.translate(-this.dx, -this.dy);
        this.drawDependencies(graphics, this.fSelectedCol);
        graphics.translate(this.dx, this.dy);
    }

    public void paint(Graphics graphics) {
        if (this.fMakingIntervals || this.fDraggingInterval) {
            this.setCursor(Cursor.getPredefinedCursor(8));
        } else if (this.fSelectingColumns || this.fSelectingIntervals) {
            this.setCursor(Cursor.getPredefinedCursor(1));
        } else if (this.fSelectedCol != null) {
            if (this.fSelectedCol.draggingTag()) {
                this.setCursor(Cursor.getPredefinedCursor(11));
            }
        } else if (this.fPanel.growing()) {
            this.setCursor(Cursor.getPredefinedCursor(8));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
        if (this.fBackgroundImage == null) {
            return;
        }
        if (this.fForegroundImage == null) {
            return;
        }
        this.fForegroundGraphics.drawImage(this.fBackgroundImage, 0, 0, this);
        if (!this.fSelectingColumns) {
            if (!this.fSelectingIntervals) {
                this.drawForeground(this.fForegroundGraphics);
            }
            if (this.fSelectedCol != null) {
                this.fForegroundGraphics.translate(-this.dx, 0);
                this.fSelectedCol.drawHighlight(this.fForegroundGraphics);
                this.fForegroundGraphics.translate(0, -this.dy);
                this.fSelectedCol.drawSelectedIntervals(this.fForegroundGraphics);
                this.fForegroundGraphics.translate(this.dx, this.dy);
            }
        }
        if (this.fShowDependencies) {
            this.drawDependencies(this.fForegroundGraphics);
        }
        graphics.drawImage(this.fForegroundImage, 0, 0, this);
    }

    public void handleKeyTyped(int n) {
        if (this.fSelectedCol == null) {
            return;
        }
        if (this.fSelectedRow == -1) {
            return;
        }
        this.fRowValueChanged = true;
        this.cantUndo();
        this.fTable.updateMenus();
        if (this.equationRowSelected()) {
            this.fSelectedCol.equationRow().insert((char)n);
            this.fSelectedCol.equationRow().recalculateFlushCenter(this.fSelectedCol.left(), this.fSelectedCol.width(), 15, 15);
            this.repaint();
            return;
        }
        if (this.labelRowSelected()) {
            this.fSelectedCol.labelRow().insert((char)n);
            this.fSelectedCol.labelRow().recalculateFlushCenter(this.fSelectedCol.left(), this.fSelectedCol.width(), 30, this.fSelectedCol.top() - 30);
            this.repaint();
            return;
        }
        if (this.fSelectedCol.dependent()) {
            return;
        }
        if (this.fSelectedRow != this.fSelectedStopRow) {
            if (this.fSelectedCol.linked() && this.fActOnLinks) {
                int n2 = 0;
                while (n2 < this.fNumLinkedCols) {
                    this.fLinkedCols[n2].deleteRows(this.fSelectedRow + 1, this.fSelectedStopRow);
                    ++n2;
                }
            } else {
                this.fSelectedCol.deleteRows(this.fSelectedRow + 1, this.fSelectedStopRow);
            }
            this.fSelectedCol.row(this.fSelectedRow).set("");
            this.fSelectedCol.row(this.fSelectedRow).insert((char)n);
            this.selectRow(this.fSelectedRow);
            this.reevaluate();
            this.redraw(true);
            return;
        }
        this.fSelectedCol.row(this.fSelectedRow).insert((char)n);
        this.repaint();
    }

    public synchronized boolean handleMousePressed(int n, int n2) {
        boolean bl = this.twoWereSelected = this.numRowsSelected() == 2;
        if (this.fSelectingColumns) {
            return false;
        }
        if (this.fSelectingIntervals) {
            return false;
        }
        if (this.fMakingIntervals) {
            this.draggingInterval(true);
            this.mousedownrow = this.fDragRow = this.fSelectedCol.inWhatRow(n + this.dx, n2 + this.dy);
            this.repaint();
            return false;
        }
        if (n2 < Column.dataTop()) {
            n += this.dx;
            if (this.fVarMode == 0 || this.fVarMode == 1) {
                if (this.handleTagMouseDown(this.fXTag, n, n2)) {
                    return false;
                }
                if (this.handleTagMouseDown(this.fYTag, n, n2)) {
                    return false;
                }
            } else {
                if (this.handleTagMouseDown(this.fRTag, n, n2)) {
                    return false;
                }
                if (this.handleTagMouseDown(this.fThTag, n, n2)) {
                    return false;
                }
            }
            if ((this.fVarMode == 1 || this.fVarMode == 3) && this.handleTagMouseDown(this.fTTag, n, n2)) {
                return false;
            }
            Column column = this.fFirstCol;
            while (column != null) {
                int n3 = column.handleMouse(n, n2);
                if (n3 != -1) {
                    if (n3 == -2) {
                        this.fSelectedCol = column;
                        this.selectRow(-1);
                        this.repaint();
                        return true;
                    }
                    if (n3 == -3) {
                        if (!(this.fSelectedCol == column && this.fSelectedRow == -3 || this.handleLostFocus())) {
                            this.fSelectedCol = column;
                            this.selectRow(-3);
                        }
                        this.repaint();
                        return true;
                    }
                    if (n3 == -4) {
                        if (!this.handleLostFocus()) {
                            this.fSelectedCol = column;
                            this.selectRow(-4);
                        }
                        this.repaint();
                        return true;
                    }
                }
                column = column.next;
            }
        } else {
            int n4;
            if (this.fSelectedCol != null && (n4 = this.fSelectedCol.inIntervalSep(n += this.dx, n2 += this.dy)) >= 0) {
                this.updateCell(this.fSelectedCol, this.fSelectedRow);
                if (this.fActOnLinks && this.fSelectedCol.linked()) {
                    int n5 = 0;
                    while (n5 < this.fNumLinkedCols) {
                        if (this.fLinkedCols[n5] != this.fSelectedCol) {
                            this.fLinkedCols[n5].deleteInterval(n4);
                        }
                        ++n5;
                    }
                }
                this.fDragRow = n4;
                this.draggingInterval(true);
                this.repaint();
                return false;
            }
            Column column = this.fFirstCol;
            while (column != null) {
                int n6 = column.handleMouse(n, n2);
                if (n6 != -1) {
                    if (this.fSelectedCol == null) {
                        this.fSelectedCol = column;
                        this.selectRows(n6, n6);
                    } else {
                        if (!(this.fSelectedRow == n6 && this.fSelectedCol == column || this.handleLostFocus())) {
                            this.fSelectedCol = column;
                            this.selectRows(n6, n6);
                        }
                        if (this.fSelectedCol.dependent() || !this.fSelectedCol.active()) {
                            this.fSelectedCol.row(this.fSelectedRow).selectAll();
                        }
                    }
                    this.repaint();
                    return true;
                }
                column = column.next;
            }
            this.repaint();
        }
        return false;
    }

    public synchronized boolean handleMouseDragged(int n, int n2) {
        if (this.fSelectingColumns) {
            return false;
        }
        if (this.fSelectingIntervals) {
            return false;
        }
        if (this.fDraggingInterval) {
            this.fDragRow = this.fSelectedCol.inWhatRow(n + this.dx, n2 + this.dy);
            this.repaint();
            return false;
        }
        if (this.fMakingIntervals) {
            return false;
        }
        if (this.fVarMode == 0 || this.fVarMode == 1) {
            if (this.handleTagMouseDrag(this.fXTag, n + this.dx, n2)) {
                this.makeSureXVisible(n + this.dx + 15);
                this.makeSureXVisible(n + this.dx - 15);
                return false;
            }
            if (this.handleTagMouseDrag(this.fYTag, n + this.dx, n2)) {
                this.makeSureXVisible(n + this.dx + 15);
                this.makeSureXVisible(n + this.dx - 15);
                return false;
            }
        } else {
            if (this.handleTagMouseDrag(this.fRTag, n + this.dx, n2)) {
                this.makeSureXVisible(n + this.dx + 15);
                this.makeSureXVisible(n + this.dx - 15);
                return false;
            }
            if (this.handleTagMouseDrag(this.fThTag, n + this.dx, n2)) {
                this.makeSureXVisible(n + this.dx + 15);
                this.makeSureXVisible(n + this.dx - 15);
                return false;
            }
        }
        if (this.fSelectedCol == null) {
            return false;
        }
        if (n2 < Column.dataTop()) {
            if (this.fSelectedCol.draggingTag()) {
                if (this.fSelectedCol.handleDrag(n + this.dx, n2)) {
                    this.repaint();
                }
                return true;
            }
            if (this.equationRowSelected()) {
                if (this.fSelectedCol.handleDrag(n + this.dx, n2)) {
                    this.repaint();
                }
                return true;
            }
            if (this.labelRowSelected()) {
                if (this.fSelectedCol.handleDrag(n + this.dx, n2)) {
                    this.repaint();
                }
                return true;
            }
        }
        if (this.fSelectedRow < 0) {
            return false;
        }
        this.selectRow(this.fSelectedRow);
        TableRow tableRow = this.fSelectedCol.row(this.fSelectedRow);
        if (tableRow.inside(n += this.dx, n2 += this.dy)) {
            if (this.fSelectedCol.dependent()) {
                tableRow.selectAll();
                this.repaint();
                return true;
            }
            if (tableRow.handleDrag(n, n2)) {
                this.repaint();
                return true;
            }
        }
        int n3 = 0;
        while (n3 < this.fSelectedCol.rows()) {
            tableRow = this.fSelectedCol.row(n3);
            if (tableRow.inside(n, n2)) {
                this.fSelectedStopRow = n3;
                this.makeVPointVisible(n2);
                this.repaint();
                return true;
            }
            ++n3;
        }
        if (n2 < this.fSelectedCol.top()) {
            this.fSelectedStopRow = 0;
        } else if (n2 > this.fSelectedCol.bottom()) {
            this.fSelectedStopRow = this.fSelectedCol.rows() - 1;
        }
        if (n2 >= Column.dataTop() && n2 <= this.fSelectedCol.bottom()) {
            this.makeVPointVisible(n2);
        }
        this.repaint();
        return false;
    }

    public synchronized boolean handleMouseReleased(int n, int n2) {
        boolean bl;
        n += this.dx;
        n2 += this.dy;
        boolean bl2 = bl = this.numRowsSelected() == 2;
        if (bl != this.twoWereSelected) {
            this.twoWereSelected = bl;
            this.fTable.updateMenus();
        }
        if (this.fSelectingColumns) {
            Column column = this.fFirstCol;
            while (column != null) {
                if (n >= column.left() && n <= column.left() + column.width()) {
                    column.selected(column.selected() ^ true);
                    this.redraw(false);
                    return true;
                }
                column = column.next;
            }
            return false;
        }
        if (this.fSelectingIntervals) {
            if (this.fSelectedCol == null) {
                this.selectIntervals(false);
                this.repaint();
                return false;
            }
            if (n < this.fSelectedCol.left() || n > this.fSelectedCol.right()) {
                this.selectIntervals(false);
                this.repaint();
                return false;
            }
            this.fSelectedCol.handleClickInInterval(n, n2);
            this.repaint();
        }
        if (this.fDraggingInterval) {
            this.draggingInterval(false);
            this.fDragRow = -1;
            if (this.fSelectedCol == null) {
                this.makingIntervals(false);
                this.repaint();
                return false;
            }
            int n3 = this.fSelectedCol.inWhatRow(n, n2);
            if (n3 < 0) {
                this.makingIntervals(false);
                this.fSelectedCol.setOldIntervals();
                this.redraw(false);
                return false;
            }
            if (!this.fActOnLinks || this.fNumLinkedCols == 0 || !this.fSelectedCol.linked()) {
                if (n3 == this.mousedownrow && this.fSelectedCol.hasIntervalAt(n3)) {
                    this.fSelectedCol.deleteInterval(n3);
                } else {
                    this.fSelectedCol.deleteInterval(this.mousedownrow);
                    this.fSelectedCol.addInterval(n3);
                }
            }
            if (this.fActOnLinks && this.fSelectedCol.linked()) {
                int n4 = 0;
                while (n4 < this.fNumLinkedCols) {
                    if (n3 == this.mousedownrow && this.fSelectedCol.hasIntervalAt(n3)) {
                        this.fLinkedCols[n4].deleteInterval(n3);
                    } else {
                        this.fLinkedCols[n4].addInterval(this.mousedownrow);
                        this.fLinkedCols[n4].addInterval(n3);
                    }
                    ++n4;
                }
            }
            this.redraw(false);
            return false;
        }
        if (this.fMakingIntervals) {
            this.redraw(false);
            return false;
        }
        if (this.fVarMode == 0 || this.fVarMode == 1) {
            if (this.handleTagMouseUp(this.fXTag, n, n2)) {
                return false;
            }
            if (this.handleTagMouseUp(this.fYTag, n, n2)) {
                return false;
            }
        } else {
            if (this.handleTagMouseUp(this.fRTag, n, n2)) {
                return false;
            }
            if (this.handleTagMouseUp(this.fThTag, n, n2)) {
                return false;
            }
        }
        if ((this.fVarMode == 1 || this.fVarMode == 3) && this.handleTagMouseUp(this.fTTag, n, n2)) {
            return false;
        }
        Column column = this.fFirstCol;
        while (column != null) {
            if (column.handleMouseUp(n, n2)) {
                Column column2 = column;
                while (column2.next != null) {
                    column2.next.left(column2.left() + column2.width());
                    column2 = column2.next;
                }
                this.fSelectedCol = null;
                this.redraw(true);
                return false;
            }
            column = column.next;
        }
        return false;
    }

    public boolean handleMouseMoved(int n, int n2) {
        if (n2 < Column.dataTop()) {
            n += this.dx;
            Column column = this.fFirstCol;
            while (column != null) {
                if (column.inGrowTag(n, n2)) {
                    this.setCursor(Cursor.getPredefinedCursor(11));
                    return true;
                }
                column = column.next;
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
        return true;
    }

    private final class 1
    extends KeyAdapter {
        boolean handled = false;

        public synchronized void keyPressed(KeyEvent keyEvent) {
            this.handled = false;
            if ((keyEvent.getModifiers() & 2) != 0 || (keyEvent.getModifiers() & 4) != 0 || (keyEvent.getModifiers() & 8) != 0) {
                this.handled = true;
                return;
            }
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    TableShell.this.handleUpKey();
                    return;
                }
                case 40: {
                    TableShell.this.handleDownKey();
                    return;
                }
                case 37: {
                    TableShell.this.handleLeftKey();
                    return;
                }
                case 39: {
                    TableShell.this.handleRightKey();
                    return;
                }
                case 9: {
                    TableShell.this.handleTabKey();
                    break;
                }
                case 8: 
                case 127: {
                    if (TableShell.this.handleBackspaceKey()) break;
                    return;
                }
                case 10: 
                case 13: {
                    TableShell.this.handleReturnKey();
                    break;
                }
                default: {
                    return;
                }
            }
            this.handled = true;
        }

        public synchronized void keyTyped(KeyEvent keyEvent) {
            if (!this.handled) {
                TableShell.this.handleKeyTyped(keyEvent.getKeyChar());
            }
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            TableShell.this.handleMousePressed(mouseEvent.getX(), mouseEvent.getY());
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            TableShell.this.handleMouseReleased(mouseEvent.getX(), mouseEvent.getY());
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements MouseMotionListener {
        public void mouseDragged(MouseEvent mouseEvent) {
            TableShell.this.handleMouseDragged(mouseEvent.getX(), mouseEvent.getY());
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            TableShell.this.handleMouseMoved(mouseEvent.getX(), mouseEvent.getY());
        }

        /* synthetic */ 3() {
        }
    }
}

