/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPCalculator;

import com.questmsm.FPCalculator.Calculator;
import com.questmsm.FPCalculator.Matrix;
import com.questmsm.FPCalculator.NewMatrixFrame;
import com.questmsm.Utilities.DialogField;
import com.questmsm.Utilities.DialogSuperClass;
import com.questmsm.Utilities.FPNumberFormatException;
import com.questmsm.Utilities.fp_resource;
import com.questmsm.Utilities.utils;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class CreateMatrixFrame
extends DialogSuperClass {
    private Calculator fCalc;
    private DialogField fNameField;
    private DialogField fRowsField;
    private DialogField fColsField;
    private Checkbox fIdentity;
    static int oldRows = 2;
    static int oldCols = 2;

    public CreateMatrixFrame(Calculator calculator, String string) {
        super(calculator);
        this.setTitle(fp_resource.getString("str_new_matrix"));
        this.fCalc = calculator;
        this.setBounds(130, 100, 150, 125);
        Panel panel = new Panel(new BorderLayout(0, 5));
        Panel panel2 = new Panel(new GridLayout(1, 2, 10, 10));
        panel2.add(new Label(String.valueOf(fp_resource.getString("str_name")) + ":", 2));
        this.fNameField = new DialogField(string, 6);
        panel2.add(this.fNameField);
        this.setTextFieldColors(this.fNameField);
        this.fNameField.selectAll();
        panel.add((Component)panel2, "North");
        Panel panel3 = new Panel(new GridLayout(2, 1, 0, 4));
        panel3.add(new Label(String.valueOf(fp_resource.getString("str_rows")) + ":", 1));
        panel3.add(new Label(String.valueOf(fp_resource.getString("str_cols")) + ":", 1));
        Panel panel4 = new Panel(new GridLayout(2, 1, 0, 4));
        this.fRowsField = new DialogField(String.valueOf(oldRows));
        panel4.add(this.fRowsField);
        this.fColsField = new DialogField(String.valueOf(oldCols));
        panel4.add(this.fColsField);
        panel2 = new Panel();
        panel2.add(panel3);
        panel2.add(panel4);
        panel.add((Component)panel2, "Center");
        this.setTextFieldColors(this.fRowsField);
        this.setTextFieldColors(this.fColsField);
        this.fIdentity = new Checkbox(fp_resource.getString("str_identity_matrix"), null, false);
        panel.add((Component)this.fIdentity, "South");
        Panel panel5 = new Panel(new FlowLayout(1, 20, 10));
        panel5.add(this.fOK);
        panel5.add(this.fCancel);
        this.setLayout(new BorderLayout());
        panel2 = new Panel();
        panel2.add(panel);
        this.add((Component)panel2, "Center");
        this.add((Component)panel5, "South");
        this.pack();
        this.addWindowListener(new 1());
    }

    public void setRows(int n) {
        ((TextComponent)this.fRowsField).setText(String.valueOf(n));
        oldRows = n;
    }

    public void setCols(int n) {
        ((TextComponent)this.fColsField).setText(String.valueOf(n));
        oldCols = n;
    }

    public void doYes() {
        try {
            oldRows = (int)utils.getDouble(this.fRowsField);
        }
        catch (FPNumberFormatException fPNumberFormatException) {
            String string = fp_resource.getString("str_error__cant_convert_into_a_number");
            if (this.fRowsField.getText().trim().length() > 0) {
                string = String.valueOf(string) + ": " + this.fRowsField.getText();
            }
            utils.showErrorDialog(this.fCalc, string);
            return;
        }
        try {
            oldCols = (int)utils.getDouble(this.fColsField);
        }
        catch (FPNumberFormatException fPNumberFormatException) {
            String string = fp_resource.getString("str_error__cant_convert_into_a_number");
            if (this.fColsField.getText().trim().length() > 0) {
                string = String.valueOf(string) + ": " + this.fColsField.getText();
            }
            utils.showErrorDialog(this.fCalc, string);
            return;
        }
        if (this.fIdentity.isVisible() && this.fIdentity.getState()) {
            Matrix matrix = new Matrix(oldRows, oldRows, this.fNameField.getText());
            int n = 0;
            while (n < oldRows) {
                matrix.setVal(n, n, 1.0);
                ++n;
            }
            matrix.adjustColWidths();
            this.fCalc.matrixCanvas().handleNewMatrix(matrix);
            ((Component)this).setVisible(false);
            return;
        }
        NewMatrixFrame newMatrixFrame = new NewMatrixFrame(this.fCalc, this.fNameField.getText(), oldRows, oldCols);
        ((Component)newMatrixFrame).setVisible(true);
        ((Component)this).setVisible(false);
    }

    public boolean action(Event event, Object object) {
        block2: {
            if (!(event.target instanceof TextField)) break block2;
            try {
                int n = (int)utils.getDouble(this.fRowsField);
                int n2 = (int)utils.getDouble(this.fColsField);
                this.fIdentity.setVisible(n == n2);
            }
            catch (FPNumberFormatException fPNumberFormatException) {}
        }
        return super.action(event, object);
    }

    private final class 1
    extends WindowAdapter {
        public void windowActivated(WindowEvent windowEvent) {
            CreateMatrixFrame.this.fNameField.requestFocus();
        }

        public void windowClosing(WindowEvent windowEvent) {
            CreateMatrixFrame.this.doNo();
        }

        /* synthetic */ 1() {
        }
    }
}

