/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPCalculator;

import com.questmsm.FPCalculator.Node;
import com.questmsm.FunctionProbe.Evaluatable;
import com.questmsm.Utilities.fp_resource;
import com.questmsm.Utilities.utils;
import java.awt.Frame;
import java.io.Serializable;

public class Evaluator
implements Evaluatable,
Serializable {
    protected final int kMaxElements = 30;
    protected int fNumElements;
    protected Node[] fElement = new Node[30];
    public static final int kNothing = 0;
    public static final int kNumber = 1;
    public static final int kResult = 2;
    public static final int kEndRow = 3;
    private final int kPreDecimal = 0;
    private final int kPostDecimal = 1;
    private static final char kPi = '\u0001';
    private static final char kE = '\u0002';
    private static final char kClear = '\u0003';
    private static final char kClearAll = '\u0004';
    private static final char kChangeSign = 'i';
    public static final char kXToA = '\u00cf';
    public static final char kAToX = '\u00d0';
    public static final char kLogAX = '\u00d1';
    public static final char kX1OA = '\u00d2';
    public static final int ksind = 1;
    public static final int kcosd = 2;
    public static final int ktand = 3;
    public static final int ksinr = 4;
    public static final int kcosr = 5;
    public static final int ktanr = 6;
    public static final int ketox = 7;
    public static final int katox = 208;
    public static final int kxtoa = 207;
    public static final int koox = 10;
    public static final int kabsx = 11;
    public static final int ksindinv = 12;
    public static final int kcosdinv = 13;
    public static final int ktandinv = 14;
    public static final int ksinrinv = 15;
    public static final int kcosrinv = 16;
    public static final int ktanrinv = 17;
    public static final int ketoxinv = 18;
    public static final int katoxinv = 209;
    public static final int kxtoainv = 210;
    public static final int kquestion = 21;
    public static final int kchangesign = 105;
    private int fCurrent = 3;
    private int fDecimal = 0;
    private int fDecimalPlace = 0;
    private int fNumOpenParens = 0;
    private double fNumber = 0.0;
    private final int kMaxStack = 20;
    private double[] fStack = new double[20];
    private int fStackIndex = 0;
    private double fInputNum = 0.0;
    private static transient Frame fParentFrame;

    public Evaluator copy() {
        Evaluator evaluator = new Evaluator();
        int n = 0;
        while (n < this.fNumElements) {
            evaluator.fElement[n] = this.fElement[n].copy();
            ++n;
        }
        return evaluator;
    }

    public static void setParentFrame(Frame frame) {
        fParentFrame = frame;
    }

    private boolean stackEmpty() {
        return this.fStackIndex == 0;
    }

    private void push(double d) {
        if (this.fStackIndex == 20) {
            return;
        }
        this.fStack[this.fStackIndex] = d;
        ++this.fStackIndex;
    }

    private double peek() {
        if (this.stackEmpty()) {
            return 0.0;
        }
        return this.fStack[this.fStackIndex - 1];
    }

    private double pop() {
        if (this.stackEmpty()) {
            return 0.0;
        }
        --this.fStackIndex;
        return this.fStack[this.fStackIndex];
    }

    private void clearStack() {
        this.fStackIndex = 0;
    }

    private void doOperationMult() {
        block14: while (!this.stackEmpty()) {
            int n = (int)this.peek();
            if (n == 40 || n == 43 || n == 45) break;
            n = (int)this.pop();
            double d = this.pop();
            switch (n) {
                case 207: {
                    if (d == 0.0 && this.fNumber <= 0.0) {
                        this.fNumber = Double.NaN;
                        break;
                    }
                    try {
                        this.fNumber = Math.pow(d, this.fNumber);
                    }
                    catch (ArithmeticException arithmeticException) {
                        this.fNumber = Double.NaN;
                    }
                    continue block14;
                }
                case 208: {
                    if (this.fNumber == 0.0 && d <= 0.0) {
                        this.fNumber = Double.NaN;
                        break;
                    }
                    try {
                        this.fNumber = Math.pow(this.fNumber, d);
                    }
                    catch (ArithmeticException arithmeticException) {
                        this.fNumber = Double.NaN;
                    }
                    continue block14;
                }
                case 209: {
                    if (this.fNumber == 1.0 || !(this.fNumber > 0.0) || !(d > 0.0)) continue block14;
                    this.fNumber = Math.log(d) / Math.log(this.fNumber);
                    break;
                }
                case 210: {
                    if (d == 0.0) break;
                    this.fNumber = Math.pow(this.fNumber, 1.0 / d);
                    break;
                }
                case 42: {
                    this.fNumber *= d;
                    break;
                }
                case 47: {
                    this.fNumber = d / this.fNumber;
                    break;
                }
                case 45: {
                    this.fNumber = d - this.fNumber;
                    break;
                }
                case 43: {
                    this.fNumber += d;
                    break;
                }
            }
        }
    }

    private void doOperationPlus() {
        block10: while (!this.stackEmpty()) {
            int n = (int)this.peek();
            if (n == 40) break;
            n = (int)this.pop();
            double d = this.pop();
            switch (n) {
                case 207: {
                    if (d == 0.0 && this.fNumber < 0.0) {
                        this.fNumber = Double.NaN;
                        break;
                    }
                    this.fNumber = Math.pow(d, this.fNumber);
                    break;
                }
                case 208: {
                    if (this.fNumber == 0.0 && d < 0.0) {
                        this.fNumber = Double.NaN;
                        break;
                    }
                    this.fNumber = Math.pow(this.fNumber, d);
                    break;
                }
                case 209: {
                    if (this.fNumber == 1.0 || !(this.fNumber > 0.0) || !(d > 0.0)) continue block10;
                    this.fNumber = Math.log(d) / Math.log(this.fNumber);
                    break;
                }
                case 210: {
                    if (d == 0.0) break;
                    this.fNumber = Math.pow(this.fNumber, 1.0 / d);
                    break;
                }
                case 42: {
                    this.fNumber *= d;
                    break;
                }
                case 47: {
                    this.fNumber = d / this.fNumber;
                    break;
                }
                case 45: {
                    this.fNumber = d - this.fNumber;
                    break;
                }
                case 43: {
                    this.fNumber += d;
                    break;
                }
            }
        }
    }

    public void handleInput(char c) {
        switch (c) {
            case 'i': {
                this.fCurrent = 2;
                this.fNumber = -this.fNumber;
                break;
            }
            case '(': {
                this.fCurrent = 2;
                this.push(c);
                ++this.fNumOpenParens;
                break;
            }
            case ')': {
                this.fCurrent = 2;
                --this.fNumOpenParens;
                this.doOperationPlus();
                this.pop();
                break;
            }
            case '=': {
                this.fCurrent = 2;
                this.doOperationPlus();
                break;
            }
            case '\u00cf': 
            case '\u00d0': 
            case '\u00d1': 
            case '\u00d2': {
                this.fCurrent = 2;
                this.push(this.fNumber);
                this.push(c);
                break;
            }
            case '*': 
            case '/': {
                int n;
                if (!this.stackEmpty() && (n = (int)this.peek()) != 43 && n != 45) {
                    this.doOperationMult();
                }
                this.push(this.fNumber);
                this.push(c);
                this.fCurrent = 2;
                break;
            }
            case '+': 
            case '-': {
                if (!this.stackEmpty()) {
                    this.doOperationPlus();
                }
                this.push(this.fNumber);
                this.push(c);
                this.fCurrent = 2;
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                if (this.fCurrent == 1) {
                    if (this.fDecimal == 0) {
                        this.fNumber = this.fNumber * 10.0 + (double)c - 48.0;
                        break;
                    }
                    this.fNumber += (double)(c - 48) / Math.pow(10.0, this.fDecimalPlace);
                    ++this.fDecimalPlace;
                    break;
                }
                this.fNumber = c - 48;
                this.fDecimal = 0;
                this.fDecimalPlace = 0;
                this.fCurrent = 1;
                break;
            }
            case '.': {
                if (this.fCurrent == 1) {
                    if (this.fDecimal != 0) break;
                    this.fDecimalPlace = 1;
                    this.fDecimal = 1;
                    break;
                }
                this.fCurrent = 1;
                this.fDecimalPlace = 1;
                this.fNumber = 0.0;
                this.fDecimal = 1;
                break;
            }
            default: {
                this.fCurrent = 0;
                this.fNumber = 0.0;
                return;
            }
        }
    }

    public void process(int n) {
        switch (n) {
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                if (!(this.fNumber < -1.0) && !(this.fNumber > 1.0)) break;
                utils.showErrorDialog(fParentFrame, fp_resource.getString("str_error__the_inverse_trig_functions_require_an_argument_between__and_"));
                return;
            }
        }
        double d = this.fNumber * (Math.PI / 180);
        switch (n) {
            case 1: {
                if (this.fNumber % 180.0 == 0.0) {
                    this.fNumber = 0.0;
                    break;
                }
                this.fNumber = Math.sin(d);
                break;
            }
            case 2: {
                if ((this.fNumber - 90.0) % 180.0 == 0.0) {
                    this.fNumber = 0.0;
                    break;
                }
                this.fNumber = Math.cos(d);
                break;
            }
            case 3: {
                if (this.fNumber % 180.0 == 0.0) {
                    this.fNumber = 0.0;
                    break;
                }
                if ((this.fNumber - 90.0) % 180.0 == 0.0) {
                    this.fNumber = Double.NaN;
                    break;
                }
                this.fNumber = Math.tan(d);
                break;
            }
            case 4: {
                if (Math.IEEEremainder(this.fNumber, Math.PI) == 0.0) {
                    this.fNumber = 0.0;
                    break;
                }
                this.fNumber = Math.sin(this.fNumber);
                break;
            }
            case 5: {
                if (Math.IEEEremainder(this.fNumber - 1.5707963267948966, Math.PI) == 0.0) {
                    this.fNumber = 0.0;
                    break;
                }
                this.fNumber = Math.cos(this.fNumber);
                break;
            }
            case 6: {
                if (Math.IEEEremainder(this.fNumber, Math.PI) == 0.0) {
                    this.fNumber = 0.0;
                    break;
                }
                if (Math.IEEEremainder(this.fNumber - 1.5707963267948966, Math.PI) == 0.0) {
                    this.fNumber = Double.NaN;
                    break;
                }
                this.fNumber = Math.tan(this.fNumber);
                break;
            }
            case 12: {
                this.fNumber = 57.29577951308232 * Math.asin(this.fNumber);
                break;
            }
            case 13: {
                this.fNumber = 57.29577951308232 * Math.acos(this.fNumber);
                break;
            }
            case 14: {
                this.fNumber = 57.29577951308232 * Math.atan(this.fNumber);
                break;
            }
            case 15: {
                this.fNumber = Math.asin(this.fNumber);
                break;
            }
            case 16: {
                this.fNumber = Math.acos(this.fNumber);
                break;
            }
            case 17: {
                this.fNumber = Math.atan(this.fNumber);
                break;
            }
            case 105: {
                this.fNumber = -this.fNumber;
                break;
            }
            case 7: {
                this.fNumber = Math.exp(this.fNumber);
                break;
            }
            case 18: {
                this.fNumber = Math.log(this.fNumber);
                break;
            }
            case 208: {
                this.handleInput('\u00d0');
                return;
            }
            case 209: {
                this.handleInput('\u00d1');
                return;
            }
            case 10: {
                if (this.fNumber == 0.0) {
                    this.fNumber = Double.NaN;
                    break;
                }
                this.fNumber = 1.0 / this.fNumber;
                break;
            }
            case 11: {
                this.fNumber = Math.abs(this.fNumber);
                break;
            }
            case 207: {
                this.handleInput('\u00cf');
                return;
            }
            case 210: {
                this.handleInput('\u00d2');
                return;
            }
            case 21: {
                this.fNumber = this.fInputNum;
                break;
            }
        }
        this.fCurrent = 2;
    }

    public void clear() {
        this.fNumElements = 0;
    }

    public void add(char c) {
        if (this.fNumElements == 30) {
            return;
        }
        this.fElement[this.fNumElements] = new Node(c);
        ++this.fNumElements;
    }

    public void add(String string, int n) {
        if (this.fNumElements == 30) {
            return;
        }
        this.fElement[this.fNumElements] = new Node(string, n);
        ++this.fNumElements;
    }

    public double eval_(double d) {
        return this.eval(d);
    }

    public double eval(double d) {
        this.fInputNum = d;
        int n = 0;
        while (n < this.fNumElements) {
            if (this.fElement[n].kind() == 0) {
                this.handleInput(this.fElement[n].theChar());
            } else {
                this.process(this.fElement[n].functionType());
            }
            ++n;
        }
        return this.fNumber;
    }

    public int numElements() {
        return this.fNumElements;
    }

    public int elementKind(int n) {
        return this.fElement[n].kind();
    }

    public int elementFunction(int n) {
        return this.fElement[n].functionType();
    }

    public char elementChar(int n) {
        return this.fElement[n].theChar();
    }
}

