/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPGrapher;

import com.questmsm.FPGrapher.FPAxes;
import com.questmsm.FPGrapher.FPEquation;
import com.questmsm.FPGrapher.FPRPNConverter;
import com.questmsm.FPGrapher.Grapher;
import com.questmsm.FunctionProbe.Master;
import com.questmsm.Utilities.DialogSuperClass;
import com.questmsm.Utilities.Filler;
import com.questmsm.Utilities.fp_resource;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Panel;

public class AddOrdinatesFrame
extends DialogSuperClass {
    private FPAxes fAxes;
    private Grapher fFP;
    private FPEquation fEq1;
    private FPEquation fEq2;
    private Checkbox fAdd;
    private Checkbox fSub;
    private Checkbox fSection;
    private String fS1;
    private String fS2;

    public AddOrdinatesFrame(FPAxes fPAxes, Grapher grapher) {
        super(grapher);
        this.setModal(false);
        this.setTitle(fp_resource.getString("str_ordinates"));
        this.fAxes = fPAxes;
        this.fFP = grapher;
        this.fEq1 = null;
        this.fEq2 = null;
        this.setLayout(null);
        int n = 10;
        int n2 = 5 + Master.gSmallTop;
        int n3 = 15;
        int n4 = 5;
        int n5 = 155;
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        Panel panel = new Panel(new GridLayout(2, 1));
        this.fAdd = new Checkbox(fp_resource.getString("str_add_ordinates"), checkboxGroup, true);
        panel.add(this.fAdd);
        this.fSub = new Checkbox(fp_resource.getString("str_subtract_ordinates"), checkboxGroup, false);
        panel.add(this.fSub);
        Panel panel2 = new Panel(new BorderLayout());
        panel2.add((Component)panel, "North");
        panel2.add((Component)new Filler(20, 20), "Center");
        this.fSection = new Checkbox(fp_resource.getString("str_by_sweeping"), null, false);
        panel2.add((Component)this.fSection, "South");
        Panel panel3 = new Panel(new FlowLayout(1, 10, 0));
        panel3.add(this.fOK);
        panel3.add(this.fCancel);
        Panel panel4 = new Panel(new BorderLayout(0, 10));
        panel4.add((Component)panel2, "Center");
        panel4.add((Component)panel3, "South");
        this.setLayout(new FlowLayout(1, 5, 5));
        this.add(panel4);
        this.pack();
    }

    public void show(FPEquation fPEquation, FPEquation fPEquation2) {
        this.fSection.setState(false);
        this.fAdd.setState(true);
        this.fEq1 = fPEquation;
        this.fEq2 = fPEquation2;
        super.setVisible(true);
    }

    public void setVisible(boolean bl) {
        if (!bl) {
            this.fAxes.addingOrdinates(false);
            this.fAxes.drawBackground();
            this.fAxes.repaint();
        }
        super.setVisible(bl);
    }

    private String getEqString() {
        String string = "";
        StringBuffer stringBuffer = new StringBuffer(this.fEq2.getEqString());
        FPRPNConverter.stripSpaces(stringBuffer);
        if (this.fAdd.getState()) {
            string = String.valueOf(this.fEq1.getEqString()) + FPRPNConverter.replace(stringBuffer.toString(), "y=", "+");
        } else if (this.fSub.getState()) {
            string = String.valueOf(this.fEq1.getEqString()) + FPRPNConverter.replace(stringBuffer.toString(), "y=", "-(") + ")";
        } else {
            this.setVisible(false);
            this.fAxes.repaint();
        }
        return string;
    }

    public FPEquation eq1() {
        return this.fEq1;
    }

    public FPEquation eq2() {
        return this.fEq2;
    }

    public void doYes() {
        String string = "";
        string = this.getEqString();
        if (!string.equals("")) {
            this.fAxes.addToList(new FPEquation(string, this.fFP.colorPalette().nextColor(), this.fAxes));
            this.fAxes.drawBackground();
        }
        this.fAxes.addingOrdinates(false);
        this.setVisible(false);
    }

    public void doCancel() {
        this.fAxes.addingOrdinates(false);
        this.fAxes.selectLast();
        this.setVisible(false);
    }

    public boolean action(Event event, Object object) {
        Checkbox checkbox;
        String string = "";
        if (event.target instanceof Checkbox && (checkbox = (Checkbox)event.target) == this.fSection) {
            if (checkbox.getState()) {
                string = this.getEqString();
                if (!string.equals("")) {
                    this.fAxes.ordinateEquation(string);
                    this.fAxes.ordinatesInPieces(true);
                    this.fAxes.repaint();
                    return true;
                }
            } else {
                this.fAxes.ordinatesInPieces(false);
                this.fAxes.repaint();
                return true;
            }
        }
        return super.action(event, object);
    }
}

