/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPGrapher;

import com.questmsm.FPGrapher.FPAxes;
import com.questmsm.FPGrapher.FPFreeHand;
import com.questmsm.Utilities.utils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class DrawingObject {
    private Rectangle fRect;
    public static final int kSine = 12;
    public static final int kExp = 13;
    public static final int kQuad = 14;
    public static final int kLine = 15;
    private int fKind;
    private boolean fTranslating = false;
    private boolean fDragLineLeft = false;
    private boolean fDragLineRight = false;
    private boolean fStretching = false;
    private Color fColor;

    public DrawingObject(int n, int n2, int n3, int n4, int n5, Color color) {
        this.fRect = new Rectangle(n, n2, n3, n4);
        this.fKind = n5;
        this.fColor = color;
    }

    public void draw(Graphics graphics) {
        graphics.setColor(this.fColor);
        switch (this.fKind) {
            case 12: {
                this.drawSine(graphics, this.fRect);
                return;
            }
            case 13: {
                this.drawExp(graphics, this.fRect);
                return;
            }
            case 14: {
                this.drawQuad(graphics, this.fRect);
                return;
            }
            case 15: {
                this.drawLine(graphics, this.fRect);
                return;
            }
        }
    }

    public boolean mouseDrag(int n, int n2, int n3, int n4) {
        switch (this.fKind) {
            case 15: {
                if (this.fTranslating) {
                    this.fRect.x += n;
                    this.fRect.y += n2;
                    return true;
                }
                if (this.fDragLineLeft) {
                    this.fRect.width -= n3 - this.fRect.x;
                    this.fRect.height -= n4 - this.fRect.y;
                    this.fRect.x = n3;
                    this.fRect.y = n4;
                    return true;
                }
                if (this.fDragLineRight) {
                    this.fRect.width = n3 - this.fRect.x;
                    this.fRect.height = n4 - this.fRect.y;
                    return true;
                }
                return false;
            }
            case 12: 
            case 13: 
            case 14: {
                if (this.fTranslating) {
                    this.fRect.x += n;
                    this.fRect.y += n2;
                    return true;
                }
                if (this.fStretching) {
                    this.fRect.width = n3 - this.fRect.x;
                    this.fRect.height = n4 - this.fRect.y;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public boolean mouseDown(int n, int n2) {
        switch (this.fKind) {
            case 15: {
                if (utils.ptInRect(n, n2, this.fRect)) {
                    if (utils.ptInUpperLeft(n, n2, this.fRect)) {
                        this.fDragLineLeft = true;
                    } else if (utils.ptInLowerRight(n, n2, this.fRect)) {
                        this.fDragLineRight = true;
                    } else {
                        this.fTranslating = true;
                    }
                    return true;
                }
                return false;
            }
            case 12: 
            case 13: 
            case 14: {
                if (utils.ptInRect(n, n2, this.fRect)) {
                    if (utils.ptInStretch(n, n2, this.fRect)) {
                        this.fStretching = true;
                    } else {
                        this.fTranslating = true;
                    }
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public void mouseUp() {
        this.fDragLineLeft = false;
        this.fDragLineRight = false;
        this.fTranslating = false;
        this.fStretching = false;
    }

    public void appendToFreehand(FPAxes fPAxes, FPFreeHand fPFreeHand) {
        switch (this.fKind) {
            case 15: {
                this.appendLine(fPAxes, fPFreeHand, this.fRect);
                break;
            }
            case 14: {
                this.appendQuad(fPAxes, fPFreeHand, this.fRect);
                break;
            }
            case 13: {
                this.appendExp(fPAxes, fPFreeHand, this.fRect);
                break;
            }
            case 12: {
                this.appendSine(fPAxes, fPFreeHand, this.fRect);
                break;
            }
        }
    }

    public void drawRect(Graphics graphics, Rectangle rectangle) {
        int n = -5;
        int n2 = -5;
        int n3 = rectangle.x;
        int n4 = rectangle.x + rectangle.width;
        int n5 = rectangle.y;
        int n6 = rectangle.y + rectangle.height;
        int n7 = rectangle.width;
        int n8 = rectangle.height;
        graphics.setColor(Color.black);
        if (n4 < n3) {
            int n9 = n4;
            n4 = n3;
            n3 = n9;
            n7 = -n7;
            n = 0;
        }
        if (n6 < n5) {
            n8 = -n8;
            graphics.drawRect(n3, n6, n7, n8);
            n2 = 0;
        } else {
            graphics.drawRect(n3, n5, n7, n8);
        }
        graphics.fillRect(rectangle.x + rectangle.width + n, n5 + rectangle.height + n2, 5, 5);
    }

    public void drawSine(Graphics graphics, Rectangle rectangle) {
        int n;
        int n2 = rectangle.x;
        int n3 = rectangle.x + rectangle.width;
        int n4 = rectangle.y;
        int n5 = rectangle.y + rectangle.height;
        int n6 = (n5 - n4) / 2;
        double d = Math.PI * 2 / (double)(n3 - n2);
        this.drawRect(graphics, rectangle);
        if (n3 < n2) {
            n = n3;
            n3 = n2;
            n2 = n;
        }
        int n7 = n2;
        int n8 = n4 + n6;
        graphics.setColor(this.fColor);
        n = n2;
        while (n <= n3) {
            int n9 = n4 + n6 + (int)((double)(-n6) * Math.sin(d * (double)(n - n2)));
            graphics.drawLine(n7, n8, n, n9);
            n7 = n++;
            n8 = n9;
        }
    }

    public void appendSine(FPAxes fPAxes, FPFreeHand fPFreeHand, Rectangle rectangle) {
        int n;
        int n2 = rectangle.x;
        int n3 = rectangle.x + rectangle.width;
        int n4 = rectangle.y;
        int n5 = rectangle.y + rectangle.height;
        int n6 = (n5 - n4) / 2;
        double d = Math.PI * 2 / (double)(n3 - n2);
        if (n3 < n2) {
            n = n3;
            n3 = n2;
            n2 = n;
        }
        n = n2;
        while (n <= n3) {
            int n7 = n4 + n6 + (int)((double)(-n6) * Math.sin(d * (double)(n - n2)));
            fPFreeHand.addPoint(fPAxes.pxl2x(n), fPAxes.pxl2y(n7), n, n7);
            ++n;
        }
    }

    public void drawExp(Graphics graphics, Rectangle rectangle) {
        double d = 0.03;
        int n = rectangle.x;
        int n2 = rectangle.x + rectangle.width;
        int n3 = rectangle.y;
        int n4 = rectangle.y + rectangle.height;
        this.drawRect(graphics, rectangle);
        graphics.setColor(this.fColor);
        int n5 = n;
        int n6 = n4;
        if (n2 > n) {
            double d2 = (double)(n4 - n3) / (Math.exp(d * (double)(n2 - n)) - 1.0);
            int n7 = n;
            while (n7 <= n2) {
                int n8 = n4 - (int)(d2 * (Math.exp(d * (double)(n7 - rectangle.x)) - 1.0));
                graphics.drawLine(n5, n6, n7, n8);
                n5 = n7++;
                n6 = n8;
            }
            return;
        }
        double d3 = (double)(n4 - n3) / (Math.exp(d * (double)(n - n2)) - 1.0);
        int n9 = n;
        while (n9 >= n2) {
            int n10 = n4 - (int)(d3 * (Math.exp(d * (double)(rectangle.x - n9)) - 1.0));
            graphics.drawLine(n5, n6, n9, n10);
            n5 = n9--;
            n6 = n10;
        }
    }

    public void appendExp(FPAxes fPAxes, FPFreeHand fPFreeHand, Rectangle rectangle) {
        double d = 0.03;
        int n = rectangle.x;
        int n2 = rectangle.x + rectangle.width;
        int n3 = rectangle.y;
        int n4 = rectangle.y + rectangle.height;
        if (n2 > n) {
            double d2 = (double)(n4 - n3) / (Math.exp(d * (double)(n2 - n)) - 1.0);
            int n5 = n;
            while (n5 <= n2) {
                int n6 = n4 - (int)(d2 * (Math.exp(d * (double)(n5 - rectangle.x)) - 1.0));
                fPFreeHand.addPoint(fPAxes.pxl2x(n5), fPAxes.pxl2y(n6), n5, n6);
                ++n5;
            }
        } else {
            double d3 = (double)(n4 - n3) / (Math.exp(d * (double)(n - n2)) - 1.0);
            int n7 = n;
            while (n7 >= n2) {
                int n8 = n4 - (int)(d3 * (Math.exp(d * (double)(rectangle.x - n7)) - 1.0));
                fPFreeHand.addPoint(fPAxes.pxl2x(n7), fPAxes.pxl2y(n8), n7, n8);
                --n7;
            }
        }
    }

    public void drawQuad(Graphics graphics, Rectangle rectangle) {
        int n = rectangle.x;
        int n2 = rectangle.x + rectangle.width;
        int n3 = rectangle.y;
        int n4 = rectangle.y + rectangle.height;
        this.drawRect(graphics, rectangle);
        graphics.setColor(this.fColor);
        int n5 = n;
        int n6 = n3;
        double d = 4.0 * (double)rectangle.height / (double)(rectangle.width * rectangle.width);
        if (n2 > n) {
            int n7 = n;
            while (n7 <= n2) {
                double d2 = (double)n7 - (double)(n + n2) / 2.0;
                int n8 = n4 - (int)(d * (d2 * d2));
                graphics.drawLine(n5, n6, n7, n8);
                n5 = n7++;
                n6 = n8;
            }
            return;
        }
        int n9 = n;
        while (n9 >= n2) {
            double d3 = (double)n9 - (double)(n + n2) / 2.0;
            int n10 = n4 - (int)(d * (d3 * d3));
            graphics.drawLine(n5, n6, n9, n10);
            n5 = n9--;
            n6 = n10;
        }
    }

    public void appendQuad(FPAxes fPAxes, FPFreeHand fPFreeHand, Rectangle rectangle) {
        int n = rectangle.x;
        int n2 = rectangle.x + rectangle.width;
        int n3 = rectangle.y;
        int n4 = rectangle.y + rectangle.height;
        double d = 4.0 * (double)rectangle.height / (double)(rectangle.width * rectangle.width);
        if (n2 > n) {
            int n5 = n;
            while (n5 <= n2) {
                double d2 = (double)n5 - (double)(n + n2) / 2.0;
                int n6 = n4 - (int)(d * (d2 * d2));
                fPFreeHand.addPoint(fPAxes.pxl2x(n5), fPAxes.pxl2y(n6), n5, n6);
                ++n5;
            }
        } else {
            int n7 = n;
            while (n7 >= n2) {
                double d3 = (double)n7 - (double)(n + n2) / 2.0;
                int n8 = n4 - (int)(d * (d3 * d3));
                fPFreeHand.addPoint(fPAxes.pxl2x(n7), fPAxes.pxl2y(n8), n7, n8);
                --n7;
            }
        }
    }

    public void drawLine(Graphics graphics, Rectangle rectangle) {
        int n = rectangle.x;
        int n2 = rectangle.x + rectangle.width;
        int n3 = rectangle.y;
        int n4 = rectangle.y + rectangle.height;
        graphics.setColor(this.fColor);
        graphics.drawLine(n, n3, n2, n4);
        graphics.setColor(Color.black);
        if (n2 < n && n3 > n4) {
            graphics.fillRect(rectangle.x + rectangle.width, n3 + rectangle.height, 5, 5);
            graphics.fillRect(rectangle.x - 5, n3 - 5, 5, 5);
        }
        if (n2 < n && n3 < n4) {
            graphics.fillRect(rectangle.x + rectangle.width, n3 + rectangle.height - 5, 5, 5);
            graphics.fillRect(rectangle.x - 5, n3, 5, 5);
        }
        if (n2 > n && n3 < n4) {
            graphics.fillRect(rectangle.x, n3, 5, 5);
            graphics.fillRect(rectangle.x + rectangle.width - 5, n3 + rectangle.height - 5, 5, 5);
        }
        if (n2 > n && n3 > n4) {
            graphics.fillRect(rectangle.x, n3 - 5, 5, 5);
            graphics.fillRect(rectangle.x + rectangle.width - 5, n3 + rectangle.height, 5, 5);
        }
    }

    public void appendLine(FPAxes fPAxes, FPFreeHand fPFreeHand, Rectangle rectangle) {
        int n = rectangle.x;
        int n2 = rectangle.x + rectangle.width;
        int n3 = rectangle.y;
        int n4 = rectangle.y + rectangle.height;
        fPFreeHand.addPoint(fPAxes.pxl2x(n), fPAxes.pxl2y(n3), n, n3);
        fPFreeHand.addPoint(fPAxes.pxl2x(n2), fPAxes.pxl2y(n4), n2, n4);
    }
}

