/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPGrapher;

import com.questmsm.FPGrapher.FPAxes;
import com.questmsm.FPGrapher.FPBarSetData;
import com.questmsm.FPGrapher.FPObject;
import com.questmsm.FPGrapher.FPPointSet;
import com.questmsm.FunctionProbe.Evaluatable;
import com.questmsm.Utilities.utils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;

public class FPBarSet
extends FPPointSet
implements Serializable {
    public static final transient int kLeft = 0;
    public static final transient int kCenter = 1;
    public static final transient int kRight = 2;
    private int fPos = 2;
    private double[] fBarWidths = new double[400];
    private transient int[] fBarWidthInts;
    private transient int[] fOldBarWidthInts;
    boolean showArea = false;
    Color selectedColor;
    double[] areas;
    double totalArea;

    public FPBarSet(Color color, FPAxes fPAxes) {
        super(fPAxes);
        this.fEquationString = "";
        this.fColor = color;
        this.selectedColor = this.fColor.darker();
        this.fNumPoints = 0;
        this.fKind = 7;
        this.allocateTransients(fPAxes);
    }

    public FPBarSet(FPPointSet fPPointSet, FPBarSetData fPBarSetData, FPAxes fPAxes) {
        super(fPAxes);
        this.fColor = fPPointSet.getColor();
        this.fKind = 7;
        this.allocateTransients(fPAxes);
        double d = 0.0;
        double d2 = 0.0;
        this.fNumPoints = 0;
        int n = 0;
        while (n < fPPointSet.fNumPoints) {
            if (!fPPointSet.isDeleted(n)) {
                this.fXint[this.fNumPoints] = fPPointSet.fXint[n];
                this.fYint[this.fNumPoints] = fPPointSet.fYint[n];
                this.fXval[this.fNumPoints] = fPPointSet.fXval[n];
                this.fYval[this.fNumPoints] = fPPointSet.fYval[n];
                this.fOldX[this.fNumPoints] = fPPointSet.fOldX[n];
                this.fOldY[this.fNumPoints] = fPPointSet.fOldY[n];
                ++this.fNumPoints;
            }
            ++n;
        }
        this.fPos = fPBarSetData.alignment;
        if (this.fPos == 0 && !fPBarSetData.allBarsSameWidth) {
            int n2 = 1;
            while (n2 < this.fNumPoints) {
                this.fBarWidths[n2] = this.fXval[n2] - this.fXval[n2 - 1];
                this.fBarWidthInts[n2] = this.fXint[n2] - this.fXint[n2 - 1];
                ++n2;
            }
            if (!fPBarSetData.leftmostPointHasBar) {
                this.fBarWidths[0] = 0.0;
                this.fBarWidthInts[0] = 0;
            } else if (fPBarSetData.specifyWidth) {
                this.fBarWidths[0] = fPBarSetData.barWidth;
                this.fBarWidthInts[0] = this.fAxes.x2pxlDelta(this.fBarWidths[0]);
            }
        } else if (this.fPos == 0 && fPBarSetData.allBarsSameWidth) {
            int n3;
            if (fPBarSetData.useMinimumDistance) {
                d2 = 0.0;
                d = 10000.0;
                n3 = 0;
                while (n3 < this.fNumPoints - 1) {
                    d2 = this.fXval[n3 + 1] - this.fXval[n3];
                    if (d2 < d) {
                        d = d2;
                    }
                    ++n3;
                }
            } else if (fPBarSetData.specifyWidth) {
                d = fPBarSetData.barWidth;
            }
            n3 = 0;
            while (n3 < this.fNumPoints - 1) {
                this.fBarWidths[n3] = d;
                this.fBarWidthInts[n3] = this.fAxes.x2pxlDelta(d);
                this.fXint[n3] = this.fXint[n3 + 1];
                this.fYint[n3] = this.fYint[n3 + 1];
                this.fXval[n3] = this.fXval[n3 + 1];
                this.fYval[n3] = this.fYval[n3 + 1];
                this.fOldX[n3] = this.fOldX[n3 + 1];
                this.fOldY[n3] = this.fOldY[n3 + 1];
                ++n3;
            }
            --this.fNumPoints;
        } else if (this.fPos == 2 && !fPBarSetData.allBarsSameWidth) {
            int n4 = 1;
            while (n4 < this.fNumPoints) {
                this.fBarWidths[n4 - 1] = this.fXval[n4] - this.fXval[n4 - 1];
                this.fBarWidthInts[n4 - 1] = this.fXint[n4] - this.fXint[n4 - 1];
                ++n4;
            }
            if (!fPBarSetData.leftmostPointHasBar) {
                this.fBarWidths[this.fNumPoints - 1] = 0.0;
                this.fBarWidthInts[this.fNumPoints - 1] = 0;
            } else if (fPBarSetData.specifyWidth) {
                this.fBarWidths[this.fNumPoints - 1] = fPBarSetData.barWidth;
                this.fBarWidthInts[this.fNumPoints - 1] = this.fAxes.x2pxlDelta(this.fBarWidths[this.fNumPoints - 1]);
            }
        } else if (this.fPos == 2 && fPBarSetData.allBarsSameWidth) {
            int n5;
            if (fPBarSetData.useMinimumDistance) {
                d2 = 0.0;
                d = 10000.0;
                n5 = 0;
                while (n5 < this.fNumPoints - 1) {
                    d2 = this.fXval[n5 + 1] - this.fXval[n5];
                    if (d2 < d) {
                        d = d2;
                    }
                    ++n5;
                }
            } else if (fPBarSetData.specifyWidth) {
                d = fPBarSetData.barWidth;
            }
            n5 = 0;
            while (n5 < this.fNumPoints - 1) {
                this.fBarWidths[n5] = d;
                this.fBarWidthInts[n5] = this.fAxes.x2pxlDelta(d);
                ++n5;
            }
            --this.fNumPoints;
        } else if (this.fPos == 1 && !fPBarSetData.allBarsSameWidth) {
            if (this.fNumPoints == 1) {
                this.fBarWidths[0] = 1.0;
                this.fBarWidthInts[0] = this.fAxes.x2pxlDelta(1.0);
            } else {
                this.fBarWidths[0] = this.fXval[1] - this.fXval[0];
                this.fBarWidths[this.fNumPoints - 1] = this.fXval[this.fNumPoints - 1] - this.fXval[this.fNumPoints - 2];
                int n6 = 1;
                while (n6 < this.fNumPoints - 1) {
                    double d3 = this.fXval[n6] - this.fXval[n6 - 1];
                    double d4 = this.fXval[n6 + 1] - this.fXval[n6];
                    this.fBarWidths[n6] = d3 < d4 ? d3 : d4;
                    ++n6;
                }
                int n7 = 0;
                while (n7 < this.fNumPoints) {
                    this.fBarWidthInts[n7] = this.fAxes.x2pxlDelta(this.fBarWidths[n7]);
                    ++n7;
                }
            }
        } else if (this.fPos == 1 && fPBarSetData.allBarsSameWidth) {
            int n8;
            if (fPBarSetData.useMinimumDistance) {
                d2 = 0.0;
                d = 10000.0;
                n8 = 0;
                while (n8 < this.fNumPoints - 1) {
                    d2 = this.fXval[n8 + 1] - this.fXval[n8];
                    if (d2 < d) {
                        d = d2;
                    }
                    ++n8;
                }
            } else if (fPBarSetData.specifyWidth) {
                d = fPBarSetData.barWidth;
            }
            n8 = 0;
            while (n8 < this.fNumPoints) {
                this.fBarWidths[n8] = d;
                this.fBarWidthInts[n8] = this.fAxes.x2pxlDelta(d);
                ++n8;
            }
        }
        this.areas = new double[this.fBarWidths.length];
        this.totalArea = 0.0;
        int n9 = 0;
        while (n9 < this.fBarWidths.length) {
            this.areas[n9] = this.fBarWidths[n9] * this.fYval[n9];
            this.totalArea += this.areas[n9];
            ++n9;
        }
        this.createEqString();
    }

    public double getTotalArea() {
        return this.totalArea;
    }

    public void allocateTransients(FPAxes fPAxes) {
        this.fAxes = fPAxes;
        this.fBarWidthInts = new int[400];
        this.fOldBarWidthInts = new int[400];
        super.allocateTransients(fPAxes);
    }

    public void addBar(double d, double d2, double d3) {
        if (this.fNumPoints == 400) {
            return;
        }
        if (d == -1.23456123 || d2 == -1.23456123) {
            return;
        }
        this.fXint[this.fNumPoints] = this.fAxes.x2pxl(d);
        this.fYint[this.fNumPoints] = this.fAxes.y2pxl(d2);
        this.fXval[this.fNumPoints] = d;
        this.fYval[this.fNumPoints] = d2;
        this.fBarWidths[this.fNumPoints] = d3;
        this.fBarWidthInts[this.fNumPoints] = this.fAxes.x2pxlDelta(d3);
        this.fDeleted[this.fNumPoints] = false;
        ++this.fNumPoints;
        this.createEqString();
    }

    public void prependBar(double d, double d2, double d3) {
        if (this.fNumPoints == 400) {
            return;
        }
        if (d == -1.23456123 || d2 == -1.23456123) {
            return;
        }
        int n = this.fNumPoints;
        while (n > 0) {
            this.fXint[n] = this.fXint[n - 1];
            this.fYint[n] = this.fYint[n - 1];
            this.fXval[n] = this.fXval[n - 1];
            this.fYval[n] = this.fYval[n - 1];
            this.fBarWidths[n] = this.fBarWidths[n - 1];
            this.fBarWidthInts[n] = this.fBarWidthInts[n - 1];
            this.fDeleted[n] = this.fDeleted[n - 1];
            --n;
        }
        this.fXint[0] = this.fAxes.x2pxl(d);
        this.fYint[0] = this.fAxes.y2pxl(d2);
        this.fXval[0] = d;
        this.fYval[0] = d2;
        this.fBarWidths[0] = d3;
        this.fBarWidthInts[0] = this.fAxes.x2pxlDelta(d3);
        this.fDeleted[0] = false;
        ++this.fNumPoints;
        this.createEqString();
    }

    public void calculate(FPAxes fPAxes) {
        if (this.deleted()) {
            return;
        }
        int n = 0;
        while (n < this.fNumPoints) {
            this.fBarWidthInts[n] = fPAxes.x2pxlDelta(this.fBarWidths[n]);
            ++n;
        }
        super.calculate(fPAxes);
    }

    public void copyToOld() {
        int n = 0;
        while (n < this.fNumPoints) {
            this.fOldBarWidthInts[n] = this.fBarWidthInts[n];
            ++n;
        }
        super.copyToOld();
    }

    public FPObject copy() {
        FPBarSet fPBarSet = new FPBarSet(this.fColor, this.fAxes);
        fPBarSet.fPos = this.fPos;
        fPBarSet.fEquationString = this.fEquationString;
        fPBarSet.fColor = this.fColor;
        fPBarSet.fKind = this.fKind;
        int n = 0;
        while (n < this.fNumPoints) {
            fPBarSet.fXint[n] = this.fXint[n];
            fPBarSet.fYint[n] = this.fYint[n];
            fPBarSet.fXval[n] = this.fXval[n];
            fPBarSet.fYval[n] = this.fYval[n];
            fPBarSet.fOldX[n] = this.fOldX[n];
            fPBarSet.fOldY[n] = this.fOldY[n];
            fPBarSet.fDeleted[n] = this.fDeleted[n];
            fPBarSet.fBarWidths[n] = this.fBarWidths[n];
            ++n;
        }
        fPBarSet.fNumPoints = this.fNumPoints;
        return fPBarSet;
    }

    public void setPos(int n) {
        this.fPos = n;
    }

    public double minWidth() {
        if (this.fNumPoints <= 0) {
            return 1.0;
        }
        double d = this.fBarWidths[0];
        int n = 1;
        while (n < this.fNumPoints - 1) {
            if (this.fBarWidths[n] < d) {
                d = this.fBarWidths[n];
            }
            ++n;
        }
        return d;
    }

    public FPPointSet barsToPoints() {
        FPPointSet fPPointSet = new FPPointSet(this.fAxes);
        fPPointSet.fColor = this.fColor;
        fPPointSet.fKind = 6;
        fPPointSet.fNumPoints = 0;
        int n = 0;
        while (n < this.fNumPoints) {
            if (!this.isDeleted(n)) {
                fPPointSet.fXint[fPPointSet.fNumPoints] = this.fXint[n];
                fPPointSet.fYint[fPPointSet.fNumPoints] = this.fYint[n];
                fPPointSet.fXval[fPPointSet.fNumPoints] = this.fXval[n];
                fPPointSet.fYval[fPPointSet.fNumPoints] = this.fYval[n];
                fPPointSet.fOldX[fPPointSet.fNumPoints] = this.fOldX[n];
                fPPointSet.fOldY[fPPointSet.fNumPoints] = this.fOldY[n];
                ++fPPointSet.fNumPoints;
            }
            ++n;
        }
        fPPointSet.createEqString();
        return fPPointSet;
    }

    public boolean contiguous() {
        double d = this.fAxes.pxl2x(1) - this.fAxes.pxl2x(0);
        int n = 0;
        while (n < this.fNumPoints - 1) {
            if (Math.abs(this.fXval[n] + this.fBarWidths[n] - this.fXval[n + 1]) > 2.0 * d) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private double getLeftDouble(int n) {
        double d = this.fBarWidths[n];
        switch (this.fPos) {
            case 0: {
                return this.fXval[n] - d;
            }
            case 1: {
                return this.fXval[n] - d / 2.0;
            }
            case 2: {
                return this.fXval[n];
            }
        }
        return -1.0;
    }

    private int getLeft(int n) {
        int n2 = this.fBarWidthInts[n];
        switch (this.fPos) {
            case 0: {
                return this.fXint[n] - n2;
            }
            case 1: {
                return this.fXint[n] - n2 / 2;
            }
            case 2: {
                return this.fXint[n];
            }
        }
        return -1;
    }

    private Rectangle getRect(int n) {
        int n2;
        int n3;
        int n4 = this.fAxes.y2pxlSuppressLog(0.0);
        int n5 = this.fBarWidthInts[n];
        int n6 = this.getLeft(n);
        if (this.fYint[n] < n4) {
            n3 = this.fYint[n];
            n2 = n4 - n3;
        } else {
            n3 = n4;
            n2 = this.fYint[n] - n3;
        }
        if (n5 < 0) {
            n6 -= (n5 *= -1);
        }
        return new Rectangle(n6, n3, n5, n2);
    }

    public synchronized void draw(Graphics graphics) {
        boolean bl = this.select();
        int n = 0;
        while (n < this.fNumPoints) {
            if (!this.fDeleted[n]) {
                Rectangle rectangle = this.getRect(n);
                if (rectangle.width != 0) {
                    graphics.setColor(this.fColor);
                    graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    graphics.setColor(Color.black);
                    graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    if (bl) {
                        graphics.setColor(this.selectedColor);
                        graphics.drawRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
                        if (this.fSelectedPoint == n) {
                            graphics.drawRect(rectangle.x + 2, rectangle.y + 2, rectangle.width - 4, rectangle.height - 4);
                        }
                    }
                }
            }
            ++n;
        }
    }

    public boolean mouseDown(int n, int n2, FPAxes fPAxes) {
        if (this.deleted()) {
            return false;
        }
        int n3 = 0;
        while (n3 < this.fNumPoints) {
            if (this.getRect(n3).contains(n, n2)) {
                this.selectedPoint(n3);
                return true;
            }
            ++n3;
        }
        return false;
    }

    public synchronized void sortPoints() {
        boolean bl = true;
        int n = 0;
        while (n < this.fNumPoints - 1) {
            if (this.fXint[n + 1] < this.fXint[n]) {
                bl = false;
                break;
            }
            ++n;
        }
        if (bl) {
            return;
        }
        int n2 = 0;
        while (n2 < this.fNumPoints) {
            int n3 = this.fXint[n2];
            int n4 = n2;
            int n5 = n2 + 1;
            while (n5 < this.fNumPoints) {
                if (this.fXint[n5] < n3) {
                    n3 = this.fXint[n5];
                    n4 = n5;
                }
                ++n5;
            }
            if (n4 != n2) {
                this.fXint[n4] = this.fXint[n2];
                this.fXint[n2] = n3;
                int n6 = this.fYint[n4];
                this.fYint[n4] = this.fYint[n2];
                this.fYint[n2] = n6;
            }
            ++n2;
        }
    }

    protected String prefix() {
        String string = String.valueOf(this.fAxes.variables().depVar(this.fVarIndex));
        String string2 = String.valueOf(this.fAxes.variables().indepVar(this.fVarIndex));
        String string3 = "[(" + string2 + "1," + string2 + "2)," + string + "] = {";
        if (this.fSelectedPoint > 0) {
            string3 = String.valueOf(string3) + "...";
        }
        return string3;
    }

    protected String middle() {
        String string = String.valueOf(this.fAxes.variables().depVar(this.fVarIndex));
        String string2 = String.valueOf(this.fAxes.variables().indepVar(this.fVarIndex));
        if (this.fSelectedPoint == -1) {
            this.fSelectedPoint = 0;
        }
        double d = this.fXval[this.fSelectedPoint];
        double d2 = d + this.fBarWidths[this.fSelectedPoint];
        double d3 = this.fYval[this.fSelectedPoint];
        String string3 = "[" + utils.num2str(d) + "," + utils.num2str(d2) + "]," + utils.num2str(d3);
        return string3;
    }

    protected void createEqString() {
        this.fEquationString = "";
        if (this.fNumPoints == 0) {
            return;
        }
        if (this.fSelectedPoint == -1) {
            this.fSelectedPoint = 0;
        }
        double d = this.getLeftDouble(this.fSelectedPoint);
        double d2 = d + this.fBarWidths[this.fSelectedPoint];
        double d3 = this.fYval[this.fSelectedPoint];
        String string = String.valueOf(this.fAxes.variables().depVar(this.fVarIndex));
        String string2 = String.valueOf(this.fAxes.variables().indepVar(this.fVarIndex));
        String string3 = "[(" + string2 + "1," + string2 + "2)," + string + "] = ";
        String string4 = "[" + utils.num2str(d) + "," + utils.num2str(d2) + "]," + utils.num2str(d3);
        this.fEquationString = this.fNumPoints == 1 ? String.valueOf(string3) + "{" + string4 + "}" : (this.fSelectedPoint == 0 ? String.valueOf(string3) + "{" + string4 + "..." + "}" : (this.fSelectedPoint == this.fNumPoints - 1 ? String.valueOf(string3) + "{" + "..." + string4 + "}" : String.valueOf(string3) + "{" + "..." + string4 + "..." + "}"));
        if (this.showArea) {
            this.fEquationString = String.valueOf(this.fEquationString) + ", A= " + utils.num2str(this.areas[this.fSelectedPoint], 2) + ",\nArea sum =" + utils.num2str(this.totalArea, 2);
        }
    }

    public void fastStretchLR(int n, double d) {
        int n2 = 0;
        while (n2 < this.fNumPoints) {
            this.fBarWidthInts[n2] = (int)((double)this.fOldBarWidthInts[n2] * d);
            ++n2;
        }
        super.fastStretchLR(n, d);
    }

    public void stretchLR(double d, double d2, boolean bl) {
        if (bl) {
            int n = 0;
            while (n < this.fNumPoints) {
                this.fBarWidths[n] = Math.pow(this.fBarWidths[n], 1.0 / d2);
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.fNumPoints) {
                int n2 = n++;
                this.fBarWidths[n2] = this.fBarWidths[n2] * (1.0 / d2);
            }
        }
        super.stretchLR(d, d2, bl);
    }

    public void mirrorx(double d, boolean bl) {
        int n = 0;
        while (n < this.fNumPoints) {
            int n2 = n++;
            this.fBarWidths[n2] = this.fBarWidths[n2] * -1.0;
        }
        super.mirrorx(d, bl);
    }

    public void mirrorxy(boolean bl, boolean bl2) {
        int n = 0;
        while (n < this.fNumPoints) {
            int n2 = n++;
            this.fBarWidths[n2] = this.fBarWidths[n2] * -1.0;
        }
        super.mirrorxy(bl, bl2);
    }

    public double width(int n) {
        return this.fBarWidths[n];
    }

    public double[] widths() {
        return this.fBarWidths;
    }

    public double[] lefts() {
        double[] dArray = new double[this.fNumPoints];
        int n = 0;
        while (n < this.fNumPoints) {
            dArray[n] = this.getLeftDouble(n);
            ++n;
        }
        return dArray;
    }

    public static double getBarHeight(double d, double d2, Evaluatable evaluatable) {
        double d3 = evaluatable.eval_(d);
        double d4 = evaluatable.eval_(d2);
        if (Math.abs(d3) < Math.abs(d4)) {
            return d3;
        }
        return d4;
    }
}

