/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPGrapher;

import com.questmsm.FPGrapher.FPAxes;
import com.questmsm.FPGrapher.FPEquation;
import com.questmsm.FPGrapher.FPObject;
import com.questmsm.FPGrapher.FPRPNConverter;
import com.questmsm.FPGrapher.Samplable;
import com.questmsm.FunctionProbe.Evaluatable;
import com.questmsm.Utilities.FPNumberFormatException;
import com.questmsm.Utilities.utils;
import java.awt.Color;
import java.io.Serializable;

public class FPCondEquation
extends FPEquation
implements Serializable,
Evaluatable,
Samplable {
    private static final int kMaxConditions = 5;
    private int fNumConditions = 0;
    private double[] fConditionVals = new double[5];
    private int[] fConditions = new int[5];
    private static final int kEqual = 0;
    private static final int kLessThan = 1;
    private static final int kGreaterThan = 2;
    private static final int kGreaterOrEqual = 3;
    private static final int kLessOrEqual = 4;
    private static final int kErrorCond = 5;
    private FPEquation[] fEquations = new FPEquation[6];
    private String[] fEqStrings = new String[6];

    public FPCondEquation() {
        this.allocateTransients(null);
        this.fKind = 13;
        this.fWatchForDiscontinuities = true;
    }

    public FPCondEquation(String string, Color color, FPAxes fPAxes) {
        this.allocateTransients(fPAxes);
        char c = fPAxes.currentIndepVar();
        char c2 = fPAxes.currentDepVar();
        this.fConverter = new FPRPNConverter(String.valueOf(c2), String.valueOf(c));
        this.fEquationString = string;
        this.fColor = color;
        this.fKind = 0;
        this.fAxes = fPAxes;
        this.stringToEquation(string);
        this.fKind = 13;
        this.fWatchForDiscontinuities = true;
    }

    public void allocateTransients(FPAxes fPAxes) {
        if (this.fNumConditions > 0) {
            int n = 0;
            while (n <= this.fNumConditions) {
                if (this.fEquations[n] != null) {
                    this.fEquations[n].allocateTransients(fPAxes);
                }
                ++n;
            }
        }
        super.allocateTransients(fPAxes);
    }

    public static boolean isCondEquation(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        FPRPNConverter.stripSpaces(stringBuffer);
        String string2 = stringBuffer.toString();
        if (string2.length() < 6) {
            return false;
        }
        if (string2.charAt(1) != '=') {
            return false;
        }
        if (string2.charAt(2) != 'i') {
            return false;
        }
        return string2.charAt(3) == 'f';
    }

    public static int findStartOfWord(String string, int n, String string2) {
        int n2 = n;
        while (n2 < string.length() - string2.length()) {
            if (string.substring(n2, n2 + string2.length()).equals(string2)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    protected int getConditionType(String string) {
        int n = 0;
        while (n < string.length() - 1) {
            if (string.charAt(n) == '=') {
                return 0;
            }
            if (string.charAt(n) == '>' && string.charAt(n + 1) == '=') {
                return 3;
            }
            if (string.charAt(n) == '<' && string.charAt(n + 1) == '=') {
                return 4;
            }
            if (string.charAt(n) == '>') {
                return 2;
            }
            if (string.charAt(n) == '<') {
                return 1;
            }
            ++n;
        }
        return 5;
    }

    protected double getConditionVal(String string) throws FPNumberFormatException {
        int n = 0;
        while (n < string.length() - 1) {
            switch (string.charAt(n)) {
                case '=': {
                    return utils.str2num(string.substring(n + 1, string.length()));
                }
                case '<': 
                case '>': {
                    if (string.charAt(n + 1) == '=') {
                        return utils.str2num(string.substring(n + 2, string.length()));
                    }
                    return utils.str2num(string.substring(n + 1, string.length()));
                }
            }
            ++n;
        }
        return -1.23456123;
    }

    private boolean fitsCondition(double d, int n) {
        switch (this.fConditions[n]) {
            case 0: {
                return d == this.fConditionVals[n];
            }
            case 2: {
                return d > this.fConditionVals[n];
            }
            case 1: {
                return d < this.fConditionVals[n];
            }
            case 4: {
                return d <= this.fConditionVals[n];
            }
            case 3: {
                return d >= this.fConditionVals[n];
            }
        }
        return false;
    }

    public double eval(double d) {
        if (this.fNumConditions == 0) {
            return -1.23456123;
        }
        int n = 0;
        while (n < this.fNumConditions) {
            if (this.fitsCondition(d, n)) {
                if (this.fEquations[n] == null) {
                    return -1.23456123;
                }
                return this.fEquations[n].eval_(d);
            }
            ++n;
        }
        return this.fEquations[this.fNumConditions].eval_(d);
    }

    protected void stringToEquation(String string) {
        int n = 0;
        int n2 = 0;
        String string2 = utils.stripSpaces(string);
        this.fNumConditions = 0;
        n = FPCondEquation.findStartOfWord(string2, 0, "if");
        if (n == -1) {
            this.fBadEquation = true;
            return;
        }
        n2 = FPCondEquation.findStartOfWord(string2, n + 2, "then");
        if (n2 == -1) {
            this.fBadEquation = true;
            return;
        }
        String string3 = string2.substring(n + 2, n2);
        while (true) {
            this.fConditions[this.fNumConditions] = this.getConditionType(string3);
            try {
                this.fConditionVals[this.fNumConditions] = this.getConditionVal(string3);
            }
            catch (FPNumberFormatException fPNumberFormatException) {
                this.fBadEquation = true;
                return;
            }
            ++this.fNumConditions;
            n = FPCondEquation.findStartOfWord(string2, n2 + 4, "elseif");
            if (n == -1) break;
            this.fEqStrings[this.fNumConditions - 1] = string2.substring(n2 + 4, n);
            n2 = FPCondEquation.findStartOfWord(string2, n + 6, "then");
            if (n2 == -1) {
                this.fBadEquation = true;
                return;
            }
            string3 = string2.substring(n + 6, n2);
        }
        n = FPCondEquation.findStartOfWord(string2, n2 + 4, "else");
        if (n == -1) {
            this.fBadEquation = true;
            return;
        }
        this.fEqStrings[this.fNumConditions - 1] = string2.substring(n2 + 4, n);
        this.fEqStrings[this.fNumConditions] = string2.substring(n + 4, string2.length());
        int n3 = 0;
        while (n3 <= this.fNumConditions) {
            this.fEquations[n3] = new FPEquation("y=" + this.fEqStrings[n3], this.fColor, this.fAxes);
            ++n3;
        }
    }

    public void stretchLR(double d, double d2, boolean bl) {
    }

    public void stretchUD(double d, double d2, boolean bl) {
    }

    public void mirrorx(double d, boolean bl) {
    }

    public void mirrory(double d, boolean bl) {
    }

    public void mirrorxy(boolean bl, boolean bl2) {
        this.mirrorXY = true;
    }

    public void translate(double d, double d2, boolean bl, boolean bl2) {
    }

    public FPObject copy() {
        FPCondEquation fPCondEquation = new FPCondEquation(this.fEquationString, this.fColor, this.fAxes);
        int n = 0;
        while (n < this.fNumSteps) {
            fPCondEquation.fX[n] = this.fX[n];
            fPCondEquation.fY[n] = this.fY[n];
            ++n;
        }
        return fPCondEquation;
    }
}

