/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPGrapher;

import com.questmsm.FPGrapher.FPAxes;
import com.questmsm.FPGrapher.FPObject;
import com.questmsm.FPGrapher.FPPointSet;
import com.questmsm.FPGrapher.Samplable;
import com.questmsm.FunctionProbe.Evaluatable;
import com.questmsm.FunctionProbe.Master;
import com.questmsm.Utilities.fp_resource;
import com.questmsm.Utilities.utils;
import java.awt.Color;
import java.awt.Graphics;
import java.io.Serializable;

public class FPFreeHand
extends FPPointSet
implements Serializable,
Samplable,
Evaluatable {
    private int fNumBreaks = 0;
    private final int kMaxBreaks = 20;
    private int[] fBreaks = new int[20];

    public FPFreeHand(Color color, FPAxes fPAxes) {
        super(fPAxes);
        this.fEquationString = fp_resource.getString("str_freehand_drawing");
        this.fColor = color;
        this.fNumPoints = 0;
        this.fKind = 5;
        this.fAxes = fPAxes;
        this.fConnected = true;
    }

    public void addBreak() {
        if (this.fNumBreaks < 20) {
            this.fBreaks[this.fNumBreaks] = this.fNumPoints - 1;
            ++this.fNumBreaks;
        }
    }

    public void addPoint(double d, double d2, int n, int n2) {
        if (this.fNumPoints == 400) {
            return;
        }
        this.fXint[this.fNumPoints] = n;
        this.fYint[this.fNumPoints] = n2;
        this.fXval[this.fNumPoints] = d;
        this.fYval[this.fNumPoints] = d2;
        ++this.fNumPoints;
    }

    public void draw(Graphics graphics) {
        boolean bl = this.select();
        int n = 0;
        graphics.setColor(this.fColor);
        int n2 = 0;
        while (n2 < this.fNumPoints - 1) {
            if (n >= this.fNumBreaks) {
                graphics.drawLine(this.fXint[n2], this.fYint[n2], this.fXint[n2 + 1], this.fYint[n2 + 1]);
            } else if (this.fBreaks[n] == n2) {
                ++n;
            } else {
                graphics.drawLine(this.fXint[n2], this.fYint[n2], this.fXint[n2 + 1], this.fYint[n2 + 1]);
            }
            ++n2;
        }
        if (!bl) {
            return;
        }
        n = 0;
        int n3 = 1;
        while (n3 < this.fNumPoints) {
            if (n >= this.fNumBreaks) {
                graphics.drawLine(this.fXint[n3 - 1] + 1, this.fYint[n3 - 1], this.fXint[n3] + 1, this.fYint[n3]);
                graphics.drawLine(this.fXint[n3 - 1], this.fYint[n3 - 1] + 1, this.fXint[n3], this.fYint[n3] + 1);
            } else if (this.fBreaks[n] == n3 - 1) {
                ++n;
            } else {
                graphics.drawLine(this.fXint[n3 - 1] + 1, this.fYint[n3 - 1], this.fXint[n3] + 1, this.fYint[n3]);
                graphics.drawLine(this.fXint[n3 - 1], this.fYint[n3 - 1] + 1, this.fXint[n3], this.fYint[n3] + 1);
            }
            ++n3;
        }
    }

    public FPObject copy() {
        FPFreeHand fPFreeHand = new FPFreeHand(this.fColor, this.fAxes);
        fPFreeHand.fEquationString = this.fEquationString;
        fPFreeHand.fColor = this.fColor;
        fPFreeHand.fKind = this.fKind;
        fPFreeHand.fConnected = this.fConnected;
        int n = 0;
        while (n < this.fNumPoints) {
            fPFreeHand.fXint[n] = this.fXint[n];
            fPFreeHand.fYint[n] = this.fYint[n];
            fPFreeHand.fXval[n] = this.fXval[n];
            fPFreeHand.fYval[n] = this.fYval[n];
            fPFreeHand.fOldX[n] = this.fOldX[n];
            fPFreeHand.fOldY[n] = this.fOldY[n];
            ++n;
        }
        fPFreeHand.fNumPoints = this.fNumPoints;
        fPFreeHand.fNumBreaks = this.fNumBreaks;
        int n2 = 0;
        while (n2 < this.fNumBreaks) {
            fPFreeHand.fBreaks[n2] = this.fBreaks[n2];
            ++n2;
        }
        return fPFreeHand;
    }

    public void createEqString() {
    }

    public void drawHorizontalArrows(Graphics graphics, int n) {
        int n2 = 1;
        graphics.setColor(Color.gray);
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < this.fNumPoints - 1) {
                int n5;
                int n6 = utils.findIntercept(n3, this.fYint[n4], this.fXint[n4], this.fYint[n4 + 1], this.fXint[n4 + 1]);
                if (n6 != -1000 && Math.abs((n5 = utils.findIntercept(n3, this.fOldY[n4], this.fOldX[n4], this.fOldY[n4 + 1], this.fOldX[n4 + 1])) - n6) >= 4) {
                    graphics.drawLine(n6, n3, n5, n3);
                    if (n5 < n6) {
                        n2 = -1;
                    }
                    int n7 = 0;
                    while (n7 < 4) {
                        graphics.drawLine(n6 + n2 * n7, n3 - n7, n6 + n2 * n7, n3 + n7);
                        ++n7;
                    }
                }
                ++n4;
            }
            n3 += 20;
        }
    }

    public void drawVerticalArrows(Graphics graphics, int n) {
        int n2 = 1;
        graphics.setColor(Color.gray);
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < this.fNumPoints - 1) {
                int n5;
                int n6 = utils.findIntercept(n3, this.fXint[n4], this.fYint[n4], this.fXint[n4 + 1], this.fYint[n4 + 1]);
                if (n6 != -1000 && Math.abs((n5 = utils.findIntercept(n3, this.fOldX[n4], this.fOldY[n4], this.fOldX[n4 + 1], this.fOldY[n4 + 1])) - n6) >= 4) {
                    graphics.drawLine(n3, n6, n3, n5);
                    if (n5 < n6) {
                        n2 = -1;
                    }
                    int n7 = 0;
                    while (n7 < 4) {
                        graphics.drawLine(n3 - n7, n6 + n2 * n7, n3 + n7, n6 + n2 * n7);
                        ++n7;
                    }
                }
                ++n4;
            }
            n3 += 20;
        }
    }

    public double eval_(double d) {
        return this.eval(d);
    }

    public double eval(double d) {
        double d2 = d;
        int n = this.fAxes.x2pxl(d2);
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.fNumPoints - 1) {
            if (n2 < this.fNumBreaks && this.fBreaks[n2] == n3) {
                ++n2;
            } else if (!(this.fYval[n3] < this.fAxes.minY()) && !(this.fYval[n3] > this.fAxes.maxY()) && (d2 >= this.fXval[n3] && d2 <= this.fXval[n3 + 1] || d2 <= this.fXval[n3] && d2 >= this.fXval[n3 + 1])) {
                double d3 = utils.interp(this.fXval[n3], this.fYval[n3], this.fXval[n3 + 1], this.fYval[n3 + 1], d2);
                return d3;
            }
            ++n3;
        }
        return -1.23456123;
    }

    public FPPointSet sample(int n, double[] dArray, int n2) {
        FPPointSet fPPointSet = new FPPointSet(this.fAxes.parent().colorPalette().nextColor(), this.fAxes);
        if (n2 == 1) {
            int n3 = 0;
            while (n3 < n) {
                double d = dArray[n3];
                int n4 = this.fAxes.x2pxl(d);
                boolean bl = false;
                int n5 = 0;
                int n6 = 0;
                while (n6 < this.fNumPoints - 1) {
                    if (n5 < this.fNumBreaks && this.fBreaks[n5] == n6) {
                        ++n5;
                    } else if (!(this.fYval[n6] < this.fAxes.minY()) && !(this.fYval[n6] > this.fAxes.maxY()) && (d >= this.fXval[n6] && d <= this.fXval[n6 + 1] || d <= this.fXval[n6] && d >= this.fXval[n6 + 1])) {
                        if (bl) {
                            utils.showErrorDialog(Master.gFrame, String.valueOf(fp_resource.getString("str_computer_detects_drawing_is_multivalued_beginning_at")) + " x =" + utils.num2str(d));
                            return null;
                        }
                        double d2 = utils.interp(this.fXval[n6], this.fYval[n6], this.fXval[n6 + 1], this.fYval[n6 + 1], d);
                        int n7 = this.fAxes.y2pxl(d2);
                        fPPointSet.addPoint(d, d2);
                        bl = true;
                        while (this.fXval[n6] == this.fXval[n6 + 1]) {
                            if (++n6 == this.fNumPoints - 1) break;
                        }
                    }
                    ++n6;
                }
                ++n3;
            }
        } else if (n2 == 2) {
            int n8 = 0;
            while (n8 < n) {
                double d = dArray[n8];
                int n9 = this.fAxes.y2pxl(d);
                boolean bl = false;
                int n10 = 0;
                int n11 = 0;
                while (n11 < this.fNumPoints - 1) {
                    if (n10 < this.fNumBreaks && this.fBreaks[n10] == n11) {
                        ++n10;
                    } else if (!(this.fXval[n11] < this.fAxes.minX()) && !(this.fXval[n11] > this.fAxes.maxX()) && (d >= this.fYval[n11] && d <= this.fYval[n11 + 1] || d <= this.fYval[n11] && d >= this.fYval[n11 + 1])) {
                        if (bl) {
                            utils.showErrorDialog(Master.gFrame, String.valueOf(fp_resource.getString("str_computer_detects_drawing_is_multivalued_beginning_at")) + " y =" + utils.num2str(d));
                            return null;
                        }
                        double d3 = utils.interp(this.fYval[n11], this.fXval[n11], this.fYval[n11 + 1], this.fXval[n11 + 1], d);
                        int n12 = this.fAxes.y2pxl(d3);
                        fPPointSet.addPoint(d3, d);
                        bl = true;
                        while (this.fYval[n11] == this.fYval[n11 + 1]) {
                            if (++n11 == this.fNumPoints - 1) break;
                        }
                    }
                    ++n11;
                }
                ++n8;
            }
        } else {
            utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_drawings_may_not_be_sampled_along_length_fx"));
            return null;
        }
        return fPPointSet;
    }
}

