/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPGrapher;

import com.questmsm.FPGrapher.FPAxes;
import com.questmsm.FPGrapher.FPObject;
import com.questmsm.Utilities.fp_resource;
import java.awt.Color;
import java.awt.Graphics;
import java.io.Serializable;

public class FPGroup
extends FPObject
implements Serializable {
    private static final int kMaxObjects = 10;
    private FPObject[] fObjects = new FPObject[10];
    private int fNumObjects = 0;

    public FPGroup(Color color) {
        this.fEquationString = fp_resource.getString("str_group");
        this.fColor = color;
        this.fKind = 12;
    }

    public int numObjects() {
        return this.fNumObjects;
    }

    public FPObject objectNum(int n) {
        return this.fObjects[n];
    }

    public boolean isEmpty() {
        return this.fNumObjects == 0;
    }

    public void stretchLR(double d, double d2, boolean bl) {
        int n = 0;
        while (n < this.fNumObjects) {
            this.fObjects[n].stretchLR(d, d2, bl);
            ++n;
        }
    }

    public void stretchUD(double d, double d2, boolean bl) {
        int n = 0;
        while (n < this.fNumObjects) {
            this.fObjects[n].stretchUD(d, d2, bl);
            ++n;
        }
    }

    public void fastStretchLR(int n, double d) {
        int n2 = 0;
        while (n2 < this.fNumObjects) {
            this.fObjects[n2].fastStretchLR(n, d);
            ++n2;
        }
    }

    public void fastStretchUD(int n, double d) {
        int n2 = 0;
        while (n2 < this.fNumObjects) {
            this.fObjects[n2].fastStretchUD(n, d);
            ++n2;
        }
    }

    public void mirrorx(double d, boolean bl) {
        int n = 0;
        while (n < this.fNumObjects) {
            this.fObjects[n].mirrorx(d, bl);
            ++n;
        }
    }

    public void mirrory(double d, boolean bl) {
        int n = 0;
        while (n < this.fNumObjects) {
            this.fObjects[n].mirrory(d, bl);
            ++n;
        }
    }

    public void mirrorxy(boolean bl, boolean bl2) {
        int n = 0;
        while (n < this.fNumObjects) {
            this.fObjects[n].mirrorxy(bl, bl2);
            ++n;
        }
        this.mirrorXY = true;
    }

    public void translate(double d, double d2, boolean bl, boolean bl2) {
        int n = 0;
        while (n < this.fNumObjects) {
            this.fObjects[n].translate(d, d2, bl, bl2);
            ++n;
        }
    }

    public void calculate(FPAxes fPAxes) {
        if (this.deleted()) {
            return;
        }
        int n = 0;
        while (n < this.fNumObjects) {
            this.fObjects[n].calculate(fPAxes);
            this.fObjects[n].copyToOld();
            ++n;
        }
    }

    public void fastTranslate(int n, int n2) {
        int n3 = 0;
        while (n3 < this.fNumObjects) {
            this.fObjects[n3].fastTranslate(n, n2);
            ++n3;
        }
    }

    public FPObject copy() {
        FPGroup fPGroup = new FPGroup(this.fColor);
        fPGroup.fEquationString = this.fEquationString;
        fPGroup.fColor = this.fColor;
        fPGroup.fKind = this.fKind;
        fPGroup.fNumObjects = this.fNumObjects;
        int n = 0;
        while (n < this.fNumObjects) {
            fPGroup.fObjects[n] = this.fObjects[n].copy();
            ++n;
        }
        return fPGroup;
    }

    public void add(FPObject fPObject, FPAxes fPAxes) {
        this.add(fPObject, fPAxes, true);
    }

    public void add(FPObject fPObject, FPAxes fPAxes, boolean bl) {
        if (fPObject == null) {
            System.out.println(fp_resource.getString("str_error__attempted_to_group_null_object"));
            return;
        }
        if (fPObject.deleted()) {
            return;
        }
        if (this.fNumObjects >= 10) {
            return;
        }
        if (fPAxes.history().getName(fPObject) == null) {
            fPAxes.history().define(fPObject);
        }
        if (bl) {
            this.fEquationString = this.fNumObjects == 0 ? fPAxes.history().getName(fPObject) : String.valueOf(this.fEquationString) + " & " + fPAxes.history().getName(fPObject);
        }
        this.fObjects[this.fNumObjects] = fPObject.copy();
        ++this.fNumObjects;
    }

    public void clear() {
        int n = 0;
        while (n < this.fNumObjects) {
            this.fObjects[n] = null;
            ++n;
        }
        this.fNumObjects = 0;
    }

    public void draw(Graphics graphics) {
        int n = 0;
        while (n < this.fNumObjects) {
            Color color = this.fObjects[n].getColor();
            this.fObjects[n].setColor(this.fColor);
            if (this.select()) {
                this.fObjects[n].select(true);
            } else {
                this.fObjects[n].select(false);
            }
            this.fObjects[n].draw(graphics);
            this.fObjects[n].select(false);
            this.fObjects[n].setColor(color);
            ++n;
        }
    }

    public boolean mouseDown(int n, int n2, FPAxes fPAxes) {
        if (this.deleted()) {
            return false;
        }
        int n3 = 0;
        while (n3 < this.fNumObjects) {
            if (this.fObjects[n3].mouseDown(n, n2, fPAxes)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public void copyToOld() {
        int n = 0;
        while (n < this.fNumObjects) {
            this.fObjects[n].copyToOld();
            ++n;
        }
    }
}

