/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPGrapher;

import com.questmsm.FPGrapher.FPAxes;
import com.questmsm.FPGrapher.FPObject;
import com.questmsm.FunctionProbe.Master;
import com.questmsm.Utilities.MyDouble;
import com.questmsm.Utilities.fp_resource;
import com.questmsm.Utilities.utils;
import java.awt.Color;
import java.awt.Graphics;
import java.io.Serializable;

public class FPPointSet
extends FPObject
implements Serializable {
    protected static final transient int kMaxPoints = 400;
    protected transient int[] fXint;
    protected transient int[] fYint;
    protected transient int[] fOldX;
    protected transient int[] fOldY;
    protected transient FPAxes fAxes;
    protected boolean fConnected = false;
    protected double[] fXval = new double[400];
    protected double[] fYval = new double[400];
    protected boolean[] fDeleted = new boolean[400];
    public static final String kElipsis = "...";
    protected int fNumPoints;
    protected int fSelectedPoint = -1;

    public FPPointSet(Color color, FPAxes fPAxes) {
        this.fEquationString = "";
        this.fColor = color;
        this.fNumPoints = 0;
        this.fKind = 6;
        this.allocateTransients(fPAxes);
    }

    public FPPointSet(FPAxes fPAxes) {
        this.fEquationString = "";
        this.fColor = Color.red;
        this.fNumPoints = 0;
        this.fKind = 6;
        this.allocateTransients(fPAxes);
    }

    public void allocateTransients(FPAxes fPAxes) {
        this.fAxes = fPAxes;
        this.fXint = new int[400];
        this.fYint = new int[400];
        this.fOldX = new int[400];
        this.fOldY = new int[400];
    }

    public void addPoint(double d, double d2) {
        if (this.fNumPoints == 400) {
            return;
        }
        if (d == -1.23456123 || d2 == -1.23456123) {
            return;
        }
        this.fXint[this.fNumPoints] = this.fAxes.x2pxl(d);
        this.fYint[this.fNumPoints] = this.fAxes.y2pxl(d2);
        this.fXval[this.fNumPoints] = d;
        this.fYval[this.fNumPoints] = d2;
        this.fDeleted[this.fNumPoints] = false;
        ++this.fNumPoints;
        this.createEqString();
    }

    public void prependPoint(double d, double d2) {
        if (this.fNumPoints == 400) {
            return;
        }
        if (d == -1.23456123 || d2 == -1.23456123) {
            return;
        }
        int n = this.fNumPoints;
        while (n > 0) {
            this.fXint[n] = this.fXint[n - 1];
            this.fYint[n] = this.fYint[n - 1];
            this.fXval[n] = this.fXval[n - 1];
            this.fYval[n] = this.fYval[n - 1];
            this.fDeleted[n] = this.fDeleted[n - 1];
            --n;
        }
        this.fXint[0] = this.fAxes.x2pxl(d);
        this.fYint[0] = this.fAxes.y2pxl(d2);
        this.fXval[0] = d;
        this.fYval[0] = d2;
        this.fDeleted[0] = false;
        ++this.fNumPoints;
    }

    public boolean currentPointDeleted() {
        if (this.fSelectedPoint < 0) {
            return false;
        }
        return this.fDeleted[this.fSelectedPoint];
    }

    public void deleteSelectedPoint() {
        if (this.fSelectedPoint < 0) {
            return;
        }
        this.fDeleted[this.fSelectedPoint] = true;
    }

    public void togglePointDeleted() {
        if (this.fSelectedPoint < 0) {
            return;
        }
        this.fDeleted[this.fSelectedPoint] = this.fDeleted[this.fSelectedPoint] ^ true;
    }

    public int numPoints() {
        return this.fNumPoints;
    }

    public boolean connected() {
        return this.fConnected;
    }

    public void connected(boolean bl) {
        this.fConnected = bl;
    }

    public double getX(int n) {
        return this.fXval[n];
    }

    public double getY(int n) {
        return this.fYval[n];
    }

    public double[] xvals() {
        return this.fXval;
    }

    public double[] yvals() {
        return this.fYval;
    }

    protected String prefix() {
        String string = String.valueOf(this.fAxes.variables().depVar(this.fVarIndex));
        String string2 = String.valueOf(this.fAxes.variables().indepVar(this.fVarIndex));
        String string3 = "(" + string2 + "," + string + ") = {";
        if (this.fSelectedPoint > 0) {
            string3 = String.valueOf(string3) + kElipsis;
        }
        return string3;
    }

    protected String postfix() {
        String string = "";
        if (this.fSelectedPoint < this.fNumPoints - 1) {
            string = String.valueOf(string) + kElipsis;
        }
        string = String.valueOf(string) + "}";
        return string;
    }

    protected String middle() {
        String string = "(" + utils.num2str(this.fXval[this.fSelectedPoint]) + "," + utils.num2str(this.fYval[this.fSelectedPoint]) + ")";
        return string;
    }

    protected void createEqString() {
        this.fEquationString = "";
        if (this.fNumPoints == 0) {
            return;
        }
        if (this.fSelectedPoint == -1) {
            this.fSelectedPoint = 0;
        }
        if (this.fAxes == null) {
            return;
        }
        this.fEquationString = String.valueOf(this.prefix()) + this.middle() + this.postfix();
    }

    public void fastStretchLR(int n, double d) {
        int n2 = 0;
        while (n2 < this.fNumPoints) {
            this.fXint[n2] = n + (int)((double)(this.fOldX[n2] - n) * d);
            this.fYint[n2] = this.fOldY[n2];
            ++n2;
        }
    }

    public void fastStretchUD(int n, double d) {
        int n2 = 0;
        while (n2 < this.fNumPoints) {
            this.fYint[n2] = n + (int)((double)(this.fOldY[n2] - n) * d);
            ++n2;
        }
    }

    public void stretchLR(double d, double d2, boolean bl) {
        if (bl) {
            int n = 0;
            while (n < this.fNumPoints) {
                this.fXval[n] = Math.pow(this.fXval[n], 1.0 / d2) * Math.pow(this.fAxes.logXBase(), d * (1.0 - 1.0 / d2));
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.fNumPoints) {
                this.fXval[n] = d + (this.fXval[n] - d) / d2;
                ++n;
            }
        }
        this.createEqString();
    }

    public void stretchUD(double d, double d2, boolean bl) {
        if (bl) {
            int n = 0;
            while (n < this.fNumPoints) {
                this.fYval[n] = Math.pow(this.fYval[n], d2) * Math.pow(this.fAxes.logYBase(), d * (1.0 - d2));
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.fNumPoints) {
                this.fYval[n] = d + (this.fYval[n] - d) * d2;
                ++n;
            }
        }
        this.createEqString();
    }

    public void mirrorx(double d, boolean bl) {
        if (bl) {
            int n = 0;
            while (n < this.fNumPoints) {
                this.fXval[n] = 1.0 / this.fXval[n] * Math.pow(this.fAxes.logXBase(), d * 2.0);
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.fNumPoints) {
                this.fXval[n] = 2.0 * d - this.fXval[n];
                ++n;
            }
        }
        this.createEqString();
    }

    public void mirrory(double d, boolean bl) {
        if (bl) {
            int n = 0;
            while (n < this.fNumPoints) {
                this.fYval[n] = 1.0 / this.fYval[n] * Math.pow(this.fAxes.logYBase(), d * 2.0);
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.fNumPoints) {
                this.fYval[n] = 2.0 * d - this.fYval[n];
                ++n;
            }
        }
        this.createEqString();
    }

    public void mirrorxy(boolean bl, boolean bl2) {
        int n = 0;
        while (n < this.fNumPoints) {
            double d = this.fXval[n];
            this.fXval[n] = this.fYval[n];
            this.fYval[n] = d;
            ++n;
        }
        this.createEqString();
        this.mirrorXY = true;
    }

    public void translate(double d, double d2, boolean bl, boolean bl2) {
        int n = 0;
        while (n < this.fNumPoints) {
            if (bl) {
                int n2 = n;
                this.fXval[n2] = this.fXval[n2] * Math.pow(this.fAxes.logXBase(), d);
            } else {
                int n3 = n;
                this.fXval[n3] = this.fXval[n3] + d;
            }
            if (bl2) {
                int n4 = n;
                this.fYval[n4] = this.fYval[n4] * Math.pow(this.fAxes.logYBase(), d2);
            } else {
                int n5 = n;
                this.fYval[n5] = this.fYval[n5] + d2;
            }
            ++n;
        }
        this.createEqString();
    }

    public void copyToOld() {
        int n = 0;
        while (n < this.fNumPoints) {
            this.fOldX[n] = this.fXint[n];
            this.fOldY[n] = this.fYint[n];
            ++n;
        }
    }

    public void fastTranslate(int n, int n2) {
        int n3 = 0;
        while (n3 < this.fNumPoints) {
            this.fXint[n3] = this.fOldX[n3] + n;
            this.fYint[n3] = this.fOldY[n3] + n2;
            ++n3;
        }
    }

    public FPObject copy() {
        FPPointSet fPPointSet = new FPPointSet(this.fColor, this.fAxes);
        fPPointSet.fEquationString = this.fEquationString;
        fPPointSet.fColor = this.fColor;
        fPPointSet.fKind = this.fKind;
        fPPointSet.fConnected = this.fConnected;
        int n = 0;
        while (n < this.fNumPoints) {
            fPPointSet.fXint[n] = this.fXint[n];
            fPPointSet.fYint[n] = this.fYint[n];
            fPPointSet.fXval[n] = this.fXval[n];
            fPPointSet.fYval[n] = this.fYval[n];
            fPPointSet.fOldX[n] = this.fOldX[n];
            fPPointSet.fOldY[n] = this.fOldY[n];
            ++n;
        }
        fPPointSet.fNumPoints = this.fNumPoints;
        return fPPointSet;
    }

    public int selectedPoint() {
        return this.fSelectedPoint;
    }

    private int nextNotDeletedPoint(int n) {
        int n2 = n + 1;
        while (n2 <= this.fNumPoints - 1) {
            if (!this.fDeleted[n2]) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public void drawPoint(Graphics graphics, int n, int n2) {
        int n3 = 2;
        graphics.setColor(this.fColor);
        graphics.fillRect(n - n3, n2 - n3, 2 * n3 + 1, 2 * n3 + 1);
    }

    public void draw(Graphics graphics) {
        int n;
        int n2;
        boolean bl = this.select();
        graphics.setColor(this.fColor);
        if (this.fConnected) {
            int n3;
            n2 = 0;
            while (n2 < this.fNumPoints - 1) {
                if (!this.fDeleted[n2]) {
                    n3 = this.nextNotDeletedPoint(n2);
                    if (n3 == -1) break;
                    graphics.drawLine(this.fXint[n2], this.fYint[n2], this.fXint[n3], this.fYint[n3]);
                    n2 = n3 - 1;
                }
                ++n2;
            }
            if (bl) {
                n = 0;
                while (n < this.fNumPoints - 1) {
                    if (!this.fDeleted[n]) {
                        n3 = this.nextNotDeletedPoint(n);
                        graphics.drawLine(this.fXint[n] + 1, this.fYint[n], this.fXint[n3] + 1, this.fYint[n3]);
                        graphics.drawLine(this.fXint[n], this.fYint[n] + 1, this.fXint[n3], this.fYint[n3] + 1);
                        n = n3 - 1;
                    }
                    ++n;
                }
            }
        }
        n2 = 1;
        if (bl) {
            n2 = 2;
        }
        n = 0;
        while (n < this.fNumPoints) {
            if (!this.fDeleted[n]) {
                graphics.fillRect(this.fXint[n] - n2, this.fYint[n] - n2, 2 * n2 + 1, 2 * n2 + 1);
                if (n == this.fSelectedPoint && bl) {
                    graphics.fillRect(this.fXint[n] - n2 - 1, this.fYint[n] - n2 - 1, 2 * n2 + 3, 2 * n2 + 3);
                }
            }
            ++n;
        }
    }

    public void calculate(FPAxes fPAxes) {
        if (this.deleted()) {
            return;
        }
        int n = 0;
        while (n < this.fNumPoints) {
            this.fXint[n] = fPAxes.x2pxl(this.fXval[n]);
            this.fYint[n] = fPAxes.y2pxl(this.fYval[n]);
            ++n;
        }
    }

    public void selectedPoint(int n) {
        this.fSelectedPoint = n;
        if (this.fSelectedPoint < 0 || this.fSelectedPoint >= this.fNumPoints) {
            return;
        }
        this.createEqString();
    }

    public boolean isDeleted(int n) {
        if (n < 0) {
            return false;
        }
        if (n >= this.fNumPoints) {
            return false;
        }
        return this.fDeleted[n];
    }

    public boolean isDeleted() {
        if (this.fSelectedPoint < 0 || this.fSelectedPoint >= this.fNumPoints) {
            return false;
        }
        return this.fDeleted[this.fSelectedPoint];
    }

    public boolean mouseDown(int n, int n2, FPAxes fPAxes) {
        if (this.deleted()) {
            return false;
        }
        int n3 = 0;
        while (n3 < this.fNumPoints) {
            if (Math.abs(n - this.fXint[n3]) < 6 && Math.abs(n2 - this.fYint[n3]) < 6) {
                this.selectedPoint(n3);
                return true;
            }
            ++n3;
        }
        this.selectedPoint(-1);
        if (!this.fConnected) {
            return false;
        }
        int n4 = 0;
        while (n4 < this.fNumPoints - 1) {
            if (utils.distance(this.fXint[n4], this.fYint[n4], this.fXint[n4 + 1], this.fYint[n4 + 1], n, n2) < 6) {
                return true;
            }
            ++n4;
        }
        return false;
    }

    public void decrementSelectedPoint() {
        if (this.fSelectedPoint >= 0) {
            this.selectedPoint(this.fSelectedPoint - 1);
        }
    }

    public void incrementSelectedPoint() {
        if (this.fSelectedPoint < this.fNumPoints) {
            this.selectedPoint(this.fSelectedPoint + 1);
        }
    }

    public void drawHorizontalArrows(Graphics graphics, int n) {
        int n2 = 1;
        int n3 = 0;
        graphics.setColor(Color.gray);
        int n4 = 0;
        while (n4 < this.fNumPoints) {
            int n5 = this.fOldX[n4];
            int n6 = this.fXint[n4];
            if (Math.abs(n5 - n6) >= 4) {
                n3 = this.fYint[n4];
                graphics.drawLine(n6, n3, n5, n3);
                if (n5 < n6) {
                    n2 = -1;
                }
                int n7 = 0;
                while (n7 < 7) {
                    graphics.drawLine(n6 + n2 * n7, n3 - n7, n6 + n2 * n7, n3 + n7);
                    ++n7;
                }
            }
            ++n4;
        }
    }

    public void drawVerticalArrows(Graphics graphics, int n) {
        int n2 = 1;
        int n3 = 0;
        graphics.setColor(Color.gray);
        int n4 = 0;
        while (n4 < this.fNumPoints) {
            int n5 = this.fOldY[n4];
            int n6 = this.fYint[n4];
            if (Math.abs(n5 - n6) >= 4) {
                n3 = this.fXint[n4];
                graphics.drawLine(n3, n6, n3, n5);
                if (n5 < n6) {
                    n2 = -1;
                }
                int n7 = 0;
                while (n7 < 7) {
                    graphics.drawLine(n3 - n7, n6 + n2 * n7, n3 + n7, n6 + n2 * n7);
                    ++n7;
                }
            }
            ++n4;
        }
    }

    public void drawResiduals(Graphics graphics, double d, double d2, FPAxes fPAxes) {
        graphics.setColor(Color.darkGray);
        int n = 0;
        while (n < this.fNumPoints) {
            if (!this.isDeleted(n)) {
                int n2 = this.fXint[n];
                int n3 = this.fYint[n];
                int n4 = fPAxes.y2pxl(d * fPAxes.pxl2x(this.fXint[n]) + d2);
                graphics.drawLine(n2, n3, n2, n4);
                graphics.drawLine(n2 - 2, n3, n2 + 2, n3);
                graphics.drawLine(n2 - 2, n4, n2 + 2, n4);
            }
            ++n;
        }
    }

    public double aveError(double d, double d2, FPAxes fPAxes) {
        double d3 = 0.0;
        double d4 = 0.0;
        int n = 0;
        while (n < this.fNumPoints) {
            if (!this.isDeleted(n)) {
                d4 = fPAxes.pxl2y(this.fYint[n]) - (d * fPAxes.pxl2x(this.fXint[n]) + d2);
                d3 += d4 * d4;
            }
            ++n;
        }
        return d3 / (double)this.fNumPoints;
    }

    public double totalError(double d, double d2, FPAxes fPAxes) {
        double d3 = 0.0;
        double d4 = 0.0;
        int n = 0;
        while (n < this.fNumPoints) {
            if (!this.isDeleted(n)) {
                d4 = fPAxes.pxl2y(this.fYint[n]) - (d * fPAxes.pxl2x(this.fXint[n]) + d2);
                d3 += d4 * d4;
            }
            ++n;
        }
        return d3;
    }

    public double totalDev(double d, double d2, FPAxes fPAxes) {
        double d3 = 0.0;
        int n = 0;
        int n2 = 0;
        while (n2 < this.fNumPoints) {
            if (!this.isDeleted(n2)) {
                d3 += Math.abs(this.getY(n2) - (d * this.getX(n2) + d2));
                ++n;
            }
            ++n2;
        }
        return d3;
    }

    public void fitLineLeastSquares(MyDouble myDouble, MyDouble myDouble2, MyDouble myDouble3) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n = 0;
        while (n < this.fNumPoints) {
            if (!this.isDeleted(n)) {
                double d7 = this.getX(n);
                double d8 = this.getY(n);
                d6 += d7;
                d5 += d8;
                d3 += d7 * d7;
                d4 += d7 * d8;
                d2 += d8 * d8;
                d += 1.0;
            }
            ++n;
        }
        double d9 = d * d3 - d6 * d6;
        myDouble.set(1.0 / d9 * (d * d4 - d6 * d5));
        myDouble2.set(1.0 / d9 * (-d6 * d4 + d3 * d5));
        myDouble3.set(d2 - 2.0 * myDouble.get() * d4 - 2.0 * myDouble2.get() * d5 + myDouble.get() * myDouble.get() * d3 + 2.0 * myDouble.get() * myDouble2.get() * d6 + myDouble2.get() * myDouble2.get() * d);
    }

    private double bOfa(double d) {
        int n;
        if (this.fNumPoints == 0) {
            return 0.0;
        }
        double[] dArray = new double[this.fNumPoints];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.fNumPoints) {
            if (!this.isDeleted(n3)) {
                dArray[n2] = this.getY(n3) - d * this.getX(n3);
                ++n2;
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < n2) {
            double d2 = dArray[n4];
            int n5 = n4;
            n = n4 + 1;
            while (n < n2) {
                if (dArray[n] > d2) {
                    d2 = dArray[n];
                    n5 = n;
                }
                ++n;
            }
            if (n5 != n4) {
                dArray[n5] = dArray[n4];
                dArray[n4] = d2;
            }
            ++n4;
        }
        n = n2 / 2;
        return dArray[n];
    }

    private double sgn(double d) {
        if (d > 0.0) {
            return 1.0;
        }
        return 0.0;
    }

    private double func(double d) {
        double d2 = 0.0;
        int n = 0;
        while (n < this.fNumPoints) {
            if (!this.isDeleted(n)) {
                d2 += this.getX(n) * this.sgn(this.getY(n) - this.bOfa(d) - d * this.getX(n));
            }
            ++n;
        }
        return d2;
    }

    private boolean brac(MyDouble myDouble, MyDouble myDouble2) {
        int n = 50;
        double d = 1.6;
        double d2 = myDouble.get();
        double d3 = myDouble2.get();
        double d4 = this.func(d2);
        double d5 = this.func(d3);
        int n2 = 1;
        while (n2 < n) {
            if (d4 * d5 < 0.0) {
                myDouble.set(d2);
                myDouble2.set(d3);
                return true;
            }
            if (Math.abs(d4) < Math.abs(d5)) {
                d2 += d * (d2 - d3);
                d4 = this.func(d2);
            } else {
                d3 += d * (d3 - d2);
                d5 = this.func(d3);
            }
            ++n2;
        }
        return false;
    }

    private double root() {
        double d;
        double d2;
        double d3;
        int n = 40;
        double d4 = 0.001;
        MyDouble myDouble = new MyDouble(0.0);
        MyDouble myDouble2 = new MyDouble(0.0);
        MyDouble myDouble3 = new MyDouble(0.0);
        this.fitLineLeastSquares(myDouble, myDouble2, myDouble3);
        MyDouble myDouble4 = new MyDouble(myDouble.get() - 1.0);
        MyDouble myDouble5 = new MyDouble(myDouble.get() + 1.0);
        if (!this.brac(myDouble4, myDouble5)) {
            return 0.0;
        }
        double d5 = this.func(myDouble4.get());
        if (d5 * (d3 = this.func(myDouble5.get())) >= 0.0) {
            utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_error_in_finding_root"));
            return 0.0;
        }
        if (d5 < 0.0) {
            d2 = myDouble5.get() - myDouble4.get();
            d = myDouble4.get();
        } else {
            d2 = myDouble4.get() - myDouble5.get();
            d = myDouble5.get();
        }
        int n2 = 1;
        while (n2 <= n) {
            double d6 = d + (d2 *= 0.5);
            d3 = this.func(d6);
            if (d3 <= 0.0) {
                d = d6;
            }
            if (Math.abs(d2) < d4 || d3 == 0.0) {
                return d;
            }
            ++n2;
        }
        utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_error__too_many_iterations_in_root_finding"));
        return 0.0;
    }

    public void fitLineMinAbs(MyDouble myDouble, MyDouble myDouble2, MyDouble myDouble3) {
        double d = 0.0;
        myDouble.set(this.root());
        myDouble2.set(this.bOfa(myDouble.get()));
        double d2 = 0.0;
        int n = 0;
        while (n < this.fNumPoints) {
            if (!this.isDeleted(n)) {
                d2 += Math.abs(this.getY(n) - (myDouble.get() * this.getX(n) + myDouble2.get()));
                d += 1.0;
            }
            ++n;
        }
        myDouble3.set(d2);
    }
}

