/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPGrapher;

import com.questmsm.Utilities.fp_resource;
import com.questmsm.Utilities.utils;
import java.awt.Frame;
import java.io.Serializable;

public class GraphVariables
implements Serializable {
    private static final int kMaxVars = 20;
    private char[] cDepVar = new char[20];
    private char[] cIndepVar = new char[20];
    private String[] cIndepLabel = new String[20];
    private String[] cIndepUnits = new String[20];
    private String[] cDepLabel = new String[20];
    private String[] cDepUnits = new String[20];
    private int cNumVars = 1;

    public GraphVariables() {
        this.cDepVar[0] = 121;
        this.cIndepVar[0] = 120;
        this.cIndepLabel[0] = "";
        this.cIndepUnits[0] = "";
        this.cDepLabel[0] = "";
        this.cDepUnits[0] = "";
    }

    public void add(char c, char c2, String string, String string2, String string3, String string4, Frame frame) {
        if (this.cNumVars == 20) {
            utils.showErrorDialog(frame, fp_resource.getString("str_error__too_many_variables_already_defined"));
            return;
        }
        int n = 0;
        while (n < this.cNumVars) {
            if (this.cDepVar[n] == c && this.cIndepVar[n] == c2) {
                String string5 = fp_resource.getString("str_error__variable_pair_dd_already_defined");
                Object[] objectArray = new Object[]{String.valueOf(c), String.valueOf(c2)};
                string5 = utils.sprintf(string5, objectArray);
                utils.showErrorDialog(frame, string5);
                return;
            }
            ++n;
        }
        this.cDepVar[this.cNumVars] = c;
        this.cIndepVar[this.cNumVars] = c2;
        this.cIndepLabel[this.cNumVars] = string3;
        this.cIndepUnits[this.cNumVars] = string4;
        this.cDepLabel[this.cNumVars] = string;
        this.cDepUnits[this.cNumVars] = string2;
        ++this.cNumVars;
    }

    public void change(int n, String string, String string2, String string3, String string4) {
        this.cIndepLabel[n] = string3;
        this.cIndepUnits[n] = string4;
        this.cDepLabel[n] = string;
        this.cDepUnits[n] = string2;
    }

    public void delete(int n, Frame frame) {
        if (n <= 0) {
            utils.showErrorDialog(frame, fp_resource.getString("str_error__cant_delete_default_variables"));
            return;
        }
        if (n >= this.cNumVars) {
            utils.showErrorDialog(frame, fp_resource.getString("str_error__tried_to_delete_nonexistent_variables"));
            return;
        }
        int n2 = n;
        while (n2 < this.cNumVars - 1) {
            this.cDepVar[n2] = this.cDepVar[n2 + 1];
            this.cIndepVar[n2] = this.cIndepVar[n2 + 1];
            this.cIndepLabel[n2] = this.cIndepLabel[n2 + 1];
            this.cIndepUnits[n2] = this.cIndepUnits[n2 + 1];
            this.cDepLabel[n2] = this.cDepLabel[n2 + 1];
            this.cDepUnits[n2] = this.cDepUnits[n2 + 1];
            ++n2;
        }
        --this.cNumVars;
    }

    public boolean isDefined(char c, char c2) {
        int n = 0;
        while (n < this.cNumVars) {
            if (this.cDepVar[n] == c && this.cIndepVar[n] == c2) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public int whichIndex(char c, char c2) {
        int n = 0;
        while (n < this.cNumVars) {
            if (this.cDepVar[n] == c && this.cIndepVar[n] == c2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int numVars() {
        return this.cNumVars;
    }

    public char depVar(int n) {
        return this.cDepVar[n];
    }

    public char indepVar(int n) {
        return this.cIndepVar[n];
    }

    public String depLabel(int n) {
        return this.cDepLabel[n];
    }

    public String indepLabel(int n) {
        return this.cIndepLabel[n];
    }

    public String depUnits(int n) {
        return this.cDepUnits[n];
    }

    public String indepUnits(int n) {
        return this.cIndepUnits[n];
    }
}

