/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPGrapher;

import com.questmsm.FPGrapher.AddOrdinatesFrame;
import com.questmsm.FPGrapher.ColorPalette;
import com.questmsm.FPGrapher.FPAxes;
import com.questmsm.FPGrapher.FPBarSet;
import com.questmsm.FPGrapher.FPObject;
import com.questmsm.FPGrapher.FPObjectList;
import com.questmsm.FPGrapher.FPPointSet;
import com.questmsm.FPGrapher.FreeStandingFrame;
import com.questmsm.FPGrapher.GraphFileData;
import com.questmsm.FPGrapher.GraphOptionsFrame;
import com.questmsm.FPGrapher.GraphVariables;
import com.questmsm.FPGrapher.Grapher;
import com.questmsm.FPGrapher.GrapherClipboard;
import com.questmsm.FPGrapher.HistoryArea;
import com.questmsm.FPGrapher.RescaleFrame;
import com.questmsm.FPGrapher.Toolbar;
import com.questmsm.FPGrapher.UndoGrapher;
import com.questmsm.FPGrapher.VariablesDialog;
import com.questmsm.FunctionProbe.Evaluatable;
import com.questmsm.FunctionProbe.Master;
import com.questmsm.FunctionProbe.WindowMenuHandler;
import com.questmsm.Utilities.FPMenuItem;
import com.questmsm.Utilities.fp_resource;
import com.questmsm.Utilities.utils;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Grapher
extends Frame
implements FilenameFilter,
ItemListener {
    private Font fMainFont;
    private MenuBar fMenuBar;
    private final Color kBackground = Color.white;
    private int fWidth;
    private int fHeight;
    private FPAxes fAxes;
    private HistoryArea fHistory;
    private FPObjectList fList;
    private UndoGrapher fUndoer;
    private ColorPalette fColorPalette;
    private Dialog fCurvePalette;
    private Toolbar fToolbar;
    public static Image fGrapherIcons;
    public static Image fDisabledIcons;
    public static Image fSelectedIcons;
    public static Image kAnchorIcon;
    public static Image kStretchUDIcon;
    public static Image kUpArrowIcon;
    public static Image kDownArrowIcon;
    public static Image kLeftArrowIcon;
    public static Image kRightArrowIcon;
    public static Image kStretchLRIcon;
    public static Image kMirrorXIcon;
    public static Image kMirrorYIcon;
    public static Image kMirrorXYIcon;
    public static final int kIconSize = 16;
    private MenuItem fConnectPoints;
    private MenuItem fBarsFromPoints;
    private MenuItem fPointsFromBars;
    private MenuItem fAddOrdinates;
    private MenuItem fSlopesFromPoints;
    private MenuItem fPointsFromSlopes;
    private MenuItem fUndoMenu;
    private MenuItem fDeletePoint;
    private MenuItem fAddPoint;
    private MenuItem fGroup;
    private MenuItem fDefineObject;
    private MenuItem fSamplePoints;
    private MenuItem fSampleBars;
    private MenuItem fSampleSlopes;
    private MenuItem fFSPoints;
    private MenuItem fFSBars;
    private MenuItem fFSSlopes;
    private MenuItem fSendToCalc;
    private MenuItem fPointsToTable;
    private MenuItem fHistoryFrameMenu;
    private MenuItem fSampleAgain;
    private Menu fSampleMenu;
    private Menu fFreestandingMenu;
    private MenuItem fBarsToTableHeights;
    private MenuItem fBarsToTableAreas;
    private MenuItem fBarsToTableAccum;
    private MenuItem fSaveMenu;
    private MenuItem fRevertMenu;
    private MenuItem fClearBackdrop;
    private CheckboxMenuItem fShowAsymptotes;
    private static GrapherClipboard fGraphClip;
    private static final String fFileExtension = ".gph";
    private AddOrdinatesFrame fAddOrdFrame;
    private int fGrapherNum;
    private WindowMenuHandler fWindowMenuHandler;
    private String fFileName = null;
    private String fFilePath = null;
    private static boolean fActivating;

    static {
        fGraphClip = new GrapherClipboard();
        fActivating = false;
    }

    public Grapher(int n) {
        this.fGrapherNum = n;
        this.setLayout(null);
        this.addNotify();
        this.validate();
        this.fMainFont = new Font("Helvetica", 1, 12);
        ((Component)this).setBackground(this.kBackground);
        this.createMenus();
        this.fAxes = new FPAxes(-4.0, 4.0, -4.0, 4.0, 1.0, 0.2, this);
        this.fCurvePalette = this.fAxes.curvePalette();
        this.add(this.fAxes);
        this.fHistory = new HistoryArea(this, this.fAxes);
        this.add(this.fHistory);
        this.fColorPalette = new ColorPalette(Color.white, this.fAxes, this);
        int n2 = Master.gTop;
        int n3 = Master.gSmallTop;
        this.fToolbar = new Toolbar(Color.white, this.fAxes, this);
        this.fAddOrdFrame = new AddOrdinatesFrame(this.fAxes, this);
        this.fUndoer = new UndoGrapher(this, this.fAxes);
        this.setToDefaultValues();
        this.fToolbar.setBounds(this.getLocation().x, this.getLocation().y - 65, 0, 0);
        this.fToolbar.setUpPositions();
        ((Component)this.fColorPalette).setLocation(this.getLocation().x + this.getSize().width + 20, this.getLocation().y);
        ((Component)this.fCurvePalette).setLocation(this.getLocation().x + this.getSize().width + 20, this.getLocation().y + this.fColorPalette.getSize().height + 35);
        this.addComponentListener(new 1());
        this.addWindowListener(new 2());
    }

    public void doNew() {
        1.SureDialog sureDialog = new 1.SureDialog(this, this, fp_resource.getString("str_are_you_sure"), fp_resource.getString("str_are_you_sure__any_changes_will_be_lost"), fp_resource.getString("str_yes"), fp_resource.getString("str_cancel"), null);
        ((Component)sureDialog).setVisible(true);
    }

    public void setToDefaultValues() {
        this.setTitle(fp_resource.getString("str_graph"));
        ((Component)this.fHistory.frame()).setVisible(false);
        this.setVisible(false);
        int n = 0;
        int n2 = Master.gSmallTop;
        if (Master.isWindows()) {
            n = Master.gTop + 5;
        }
        this.fHeight = 300;
        FontMetrics fontMetrics = this.getGraphics().getFontMetrics(this.fMenuBar.getFont());
        this.fWidth = fontMetrics.stringWidth(fp_resource.getString("str_file")) + 20 + fontMetrics.stringWidth(fp_resource.getString("str_edit")) + 20 + fontMetrics.stringWidth(fp_resource.getString("str_send")) + 20 + fontMetrics.stringWidth(fp_resource.getString("str_windows")) + 20 + fontMetrics.stringWidth(fp_resource.getString("str_graph"));
        this.fWidth = Math.max(256, this.fWidth);
        Dimension dimension = this.getToolkit().getScreenSize();
        int n3 = dimension.width / 2 - this.fWidth - 15;
        int n4 = dimension.height / 2 - (this.fHeight + n) * 2 / 3;
        super.setBounds(n3, n4, this.fWidth, this.fHeight + n);
        this.mySetBounds(n3, n4, this.fWidth, this.fHeight + n);
        this.fAxes.minX(-4.0);
        this.fAxes.maxX(4.0);
        this.fAxes.minY(-4.0);
        this.fAxes.maxY(4.0);
        this.fAxes.xMajTick(1.0);
        this.fAxes.yMajTick(1.0);
        this.fAxes.logXBase(10.0);
        this.fAxes.logYBase(10.0);
        this.fAxes.setUpAxes();
        this.fAxes.logTickSpacing(true);
        this.fAxes.piXTickSpacing(false);
        this.fAxes.piYTickSpacing(false);
        this.fAxes.logX(false);
        this.fAxes.logY(false);
        this.fAxes.logMode(false);
        this.fAxes.quickRescale(false);
        this.fAxes.showGridLines(true);
        this.fAxes.fShowAnchors = false;
        this.fAxes.autoColor(true);
        this.fAxes.autoDefine(false);
        this.fAxes.showTransform(1);
        this.fAxes.polarMode(false);
        this.fAxes.allowPolars(true);
        this.fAxes.allowLogs(true);
        this.fToolbar.showBars(true);
        this.fToolbar.showParametric(true);
        this.fToolbar.setUpPositions();
        this.fAxes.leastSquaresMode(true);
        this.fAxes.variables(new GraphVariables());
        this.fAxes.currentVar(0);
        this.fHistory.fCount = 0;
        this.fHistory.setSelect(-1);
        this.fAxes.clearAll();
        this.fHistory.setNumItems(0);
        this.fAxes.drawBackground();
        this.fFileName = null;
        this.fFilePath = null;
        switch (this.fGrapherNum) {
            case 1: {
                this.setTitle(fp_resource.getString("str_graph"));
                break;
            }
            case 2: {
                this.setTitle(String.valueOf(fp_resource.getString("str_graph")) + " B");
                break;
            }
            case 3: {
                this.setTitle(String.valueOf(fp_resource.getString("str_graph")) + " C");
                break;
            }
        }
        this.handleMenus(false);
    }

    public void setVisible(boolean bl) {
        if (!bl) {
            if (this.fToolbar != null) {
                ((Component)this.fToolbar).setVisible(false);
            }
            if (this.fColorPalette != null) {
                ((Component)this.fColorPalette).setVisible(false);
            }
            if (this.fCurvePalette != null) {
                ((Component)this.fCurvePalette).setVisible(false);
            }
        }
        super.setVisible(bl);
        WindowMenuHandler.synchHandlers();
    }

    private void createMenus() {
        this.fMenuBar = new MenuBar();
        this.fMenuBar.setFont(FPMenuItem.FNT);
        Menu menu = new Menu(fp_resource.getString("str_file"));
        menu.setFont(FPMenuItem.FNT);
        FPMenuItem fPMenuItem = new FPMenuItem(fp_resource.getString("str_new"));
        menu.add(fPMenuItem);
        fPMenuItem.setShortcut(new MenuShortcut(78));
        fPMenuItem = new FPMenuItem(String.valueOf(fp_resource.getString("str_open")) + "...");
        menu.add(fPMenuItem);
        fPMenuItem.setShortcut(new MenuShortcut(79));
        menu.addSeparator();
        fPMenuItem = new FPMenuItem(fp_resource.getString("str_close"));
        menu.add(fPMenuItem);
        fPMenuItem.setShortcut(new MenuShortcut(87));
        this.fSaveMenu = new FPMenuItem(fp_resource.getString("str_save_window"));
        menu.add(this.fSaveMenu);
        this.fSaveMenu.setShortcut(new MenuShortcut(83));
        fPMenuItem = new FPMenuItem(String.valueOf(fp_resource.getString("str_save_window_as")) + "...");
        menu.add(fPMenuItem);
        this.fRevertMenu = new FPMenuItem(fp_resource.getString("str_revert"));
        menu.add(this.fRevertMenu);
        menu.addSeparator();
        fPMenuItem = new FPMenuItem(fp_resource.getString("str_new_workspace"));
        menu.add(fPMenuItem);
        fPMenuItem = new FPMenuItem(String.valueOf(fp_resource.getString("str_load_workspace")) + "...");
        menu.add(fPMenuItem);
        fPMenuItem = new FPMenuItem(String.valueOf(fp_resource.getString("str_save_workspace")) + "...");
        menu.add(fPMenuItem);
        menu.addSeparator();
        fPMenuItem = new FPMenuItem(String.valueOf(fp_resource.getString("str_print_graph")) + "...");
        menu.add(fPMenuItem);
        fPMenuItem.setShortcut(new MenuShortcut(80));
        menu.addSeparator();
        fPMenuItem = new FPMenuItem(fp_resource.getString("str_quit_function_probe"));
        menu.add(fPMenuItem);
        fPMenuItem.setShortcut(new MenuShortcut(81));
        this.fMenuBar.add(menu);
        menu = new Menu(fp_resource.getString("str_edit"));
        menu.setFont(FPMenuItem.FNT);
        this.fUndoMenu = new FPMenuItem(fp_resource.getString("str_cant_undo"));
        menu.add(this.fUndoMenu);
        this.fUndoMenu.setShortcut(new MenuShortcut(90));
        menu.addSeparator();
        fPMenuItem = new FPMenuItem(fp_resource.getString("str_cut"));
        menu.add(fPMenuItem);
        fPMenuItem.setShortcut(new MenuShortcut(88));
        fPMenuItem = new FPMenuItem(fp_resource.getString("str_copy"));
        menu.add(fPMenuItem);
        fPMenuItem.setShortcut(new MenuShortcut(67));
        fPMenuItem = new FPMenuItem(fp_resource.getString("str_paste"));
        menu.add(fPMenuItem);
        fPMenuItem.setShortcut(new MenuShortcut(86));
        fPMenuItem = new FPMenuItem(fp_resource.getString("str_clear_selections"));
        menu.add(fPMenuItem);
        fPMenuItem.setShortcut(new MenuShortcut(66));
        fPMenuItem = new FPMenuItem(fp_resource.getString("str_clear_others"));
        menu.add(fPMenuItem);
        fPMenuItem = new FPMenuItem(fp_resource.getString("str_select_all"));
        menu.add(fPMenuItem);
        fPMenuItem.setShortcut(new MenuShortcut(65));
        menu.addSeparator();
        this.fDeletePoint = new FPMenuItem(fp_resource.getString("str_delete_point"));
        menu.add(this.fDeletePoint);
        this.fAddPoint = new FPMenuItem(fp_resource.getString("str_add_points"));
        menu.add(this.fAddPoint);
        menu.addSeparator();
        fPMenuItem = new FPMenuItem(String.valueOf(fp_resource.getString("str_select_background")) + "...");
        menu.add(fPMenuItem);
        this.fClearBackdrop = new FPMenuItem(fp_resource.getString("str_clear_background"));
        menu.add(this.fClearBackdrop);
        this.fMenuBar.add(menu);
        menu = new Menu(fp_resource.getString("str_send"));
        menu.setFont(FPMenuItem.FNT);
        this.fPointsToTable = new FPMenuItem(fp_resource.getString("str_points_to_table"));
        menu.add(this.fPointsToTable);
        this.fBarsToTableHeights = new FPMenuItem(fp_resource.getString("str_bars_to_table_as_heights"));
        menu.add(this.fBarsToTableHeights);
        this.fBarsToTableAreas = new FPMenuItem(fp_resource.getString("str_bars_to_table_as_areas"));
        menu.add(this.fBarsToTableAreas);
        this.fBarsToTableAccum = new FPMenuItem(fp_resource.getString("str_accumulated_bar_areas_to_table"));
        menu.add(this.fBarsToTableAccum);
        menu.addSeparator();
        this.fSendToCalc = new FPMenuItem(fp_resource.getString("str_equation_to_calculator_as_button"));
        menu.add(this.fSendToCalc);
        this.fMenuBar.add(menu);
        this.fWindowMenuHandler = new WindowMenuHandler(this);
        this.fWindowMenuHandler.menu().addSeparator();
        this.fHistoryFrameMenu = new FPMenuItem(fp_resource.getString("str_hide_graph_history_window"));
        this.fWindowMenuHandler.menu().add(this.fHistoryFrameMenu);
        this.fMenuBar.add(this.fWindowMenuHandler.menu());
        menu = new Menu(fp_resource.getString("str_graph"));
        menu.setFont(FPMenuItem.FNT);
        fPMenuItem = new FPMenuItem(fp_resource.getString("str_new_equation"));
        menu.add(fPMenuItem);
        fPMenuItem.setShortcut(new MenuShortcut(69));
        this.fDefineObject = new FPMenuItem(fp_resource.getString("str_define_object"));
        menu.add(this.fDefineObject);
        menu.addSeparator();
        fPMenuItem = new FPMenuItem(String.valueOf(fp_resource.getString("str_rescale")) + "...");
        menu.add(fPMenuItem);
        fPMenuItem.setShortcut(new MenuShortcut(82));
        fPMenuItem = new FPMenuItem(String.valueOf(fp_resource.getString("str_variables")) + "...");
        menu.add(fPMenuItem);
        menu.addSeparator();
        this.fConnectPoints = new FPMenuItem(fp_resource.getString("str_connect_points"));
        menu.add(this.fConnectPoints);
        this.fConnectPoints.setShortcut(new MenuShortcut(76));
        this.fShowAsymptotes = new CheckboxMenuItem(fp_resource.getString("str_show_asymptotes"));
        menu.add(this.fShowAsymptotes);
        this.fShowAsymptotes.setFont(FPMenuItem.FNT);
        this.fShowAsymptotes.addItemListener(this);
        menu.addSeparator();
        this.fSampleMenu = new Menu(fp_resource.getString("str_sample_from_curve"));
        this.fSampleMenu.setFont(FPMenuItem.FNT);
        this.fSamplePoints = new FPMenuItem(String.valueOf(fp_resource.getString("str_point_set")) + "...");
        this.fSampleMenu.add(this.fSamplePoints);
        this.fSampleSlopes = new FPMenuItem(String.valueOf(fp_resource.getString("str_slope_set")) + "...");
        this.fSampleMenu.add(this.fSampleSlopes);
        this.fSampleBars = new FPMenuItem(String.valueOf(fp_resource.getString("str_bar_set")) + "...");
        this.fSampleMenu.add(this.fSampleBars);
        menu.add(this.fSampleMenu);
        this.fSampleAgain = new FPMenuItem(fp_resource.getString("str_sample_again"));
        menu.add(this.fSampleAgain);
        this.fFreestandingMenu = new Menu(fp_resource.getString("str_freestanding_sample"));
        this.fFreestandingMenu.setFont(FPMenuItem.FNT);
        this.fFSPoints = new FPMenuItem(String.valueOf(fp_resource.getString("str_point_set")) + "...");
        this.fFreestandingMenu.add(this.fFSPoints);
        this.fFSSlopes = new FPMenuItem(String.valueOf(fp_resource.getString("str_slope_set")) + "...");
        this.fFreestandingMenu.add(this.fFSSlopes);
        this.fFSBars = new FPMenuItem(String.valueOf(fp_resource.getString("str_bar_set")) + "...");
        this.fFreestandingMenu.add(this.fFSBars);
        menu.add(this.fFreestandingMenu);
        this.fBarsFromPoints = new FPMenuItem(fp_resource.getString("str_bars_from_points"));
        menu.add(this.fBarsFromPoints);
        this.fPointsFromBars = new FPMenuItem(fp_resource.getString("str_points_from_bars"));
        menu.add(this.fPointsFromBars);
        this.fSlopesFromPoints = new FPMenuItem(fp_resource.getString("str_slopes_from_points"));
        menu.add(this.fSlopesFromPoints);
        this.fPointsFromSlopes = new FPMenuItem(fp_resource.getString("str_points_from_slopes"));
        menu.add(this.fPointsFromSlopes);
        this.fGroup = new FPMenuItem(fp_resource.getString("str_group_selection"));
        menu.add(this.fGroup);
        this.fAddOrdinates = new FPMenuItem(fp_resource.getString("str_addsubtract_ordinates"));
        menu.add(this.fAddOrdinates);
        menu.addSeparator();
        fPMenuItem = new FPMenuItem(String.valueOf(fp_resource.getString("str_graph_options")) + "...");
        menu.add(fPMenuItem);
        this.fMenuBar.add(menu);
        this.setMenuBar(this.fMenuBar);
    }

    private Image getIcon(Image image, int n, int n2) {
        int n3 = 16;
        int n4 = 16;
        Image image2 = this.createImage(n3, n4);
        if (image != null) {
            image2.getGraphics().drawImage(image, 0, 0, n3, n4, n, n2, n + n3, n2 + n4, this);
        }
        return image2;
    }

    public void loadGrapherIcons() {
        Image image = utils.getImage("xformicons.gif", this);
        fGrapherIcons = utils.getImage("graphen.gif", this);
        fDisabledIcons = utils.getImage("graphdis.gif", this);
        fSelectedIcons = utils.getImage("graphsel.gif", this);
        if (fDisabledIcons == null || fGrapherIcons == null || fSelectedIcons == null || image == null) {
            utils.showErrorDialog(this, fp_resource.getString("str_couldnt_load_image_file"));
            System.exit(0);
        }
        int n = 1;
        int n2 = 0;
        int n3 = 17;
        kAnchorIcon = this.getIcon(image, n2, n);
        kStretchUDIcon = this.getIcon(image, n2 + n3, n);
        kUpArrowIcon = this.getIcon(image, n2, n + n3);
        kDownArrowIcon = this.getIcon(image, n2 + n3, n + n3);
        kLeftArrowIcon = this.getIcon(image, n2, n + n3 * 2);
        kRightArrowIcon = this.getIcon(image, n2 + n3, n + n3 * 2);
        kStretchLRIcon = this.getIcon(image, n2, n + n3 * 3);
        kMirrorYIcon = this.getIcon(image, n2 + n3, n + n3 * 3);
        kMirrorXIcon = this.getIcon(image, n2, n + n3 * 4);
        kMirrorXYIcon = this.getIcon(image, n2 + n3, n + n3 * 4);
    }

    public synchronized void update(Graphics graphics) {
    }

    public synchronized void mySetBounds(int n, int n2, int n3, int n4) {
        this.fWidth = this.getSize().width;
        this.fHeight = this.getSize().height;
        int n5 = Master.gTop;
        int n6 = 0;
        if (Master.isWindows()) {
            n6 = 3;
        }
        this.fHistory.setBounds(n6, n5, this.fWidth - n6 * 2, 44);
        this.fAxes.setBounds(n6 * 3, n5 + 44 + n6 * 3, this.fWidth - n6 * 2 * 3, this.fHeight - 44 - n5 - 2 * n6 * 3);
    }

    public void setToolbarMode(int n) {
        this.fToolbar.mode(n);
    }

    public boolean action(Event event, Object object) {
        if (event.target instanceof MenuItem) {
            if (event.target == this.fDefineObject) {
                this.fAxes.defineSelection();
                this.cantUndo();
                return true;
            }
            if (object.equals(fp_resource.getString("str_new_workspace"))) {
                Master.newWorkspace();
                return true;
            }
            if (object.equals(String.valueOf(fp_resource.getString("str_load_workspace")) + "...")) {
                Master.loadWorkspace();
                return true;
            }
            if (object.equals(String.valueOf(fp_resource.getString("str_save_workspace")) + "...")) {
                Master.saveWorkspace();
                return true;
            }
            if (object.equals(fp_resource.getString("str_close"))) {
                this.setVisible(false);
                return true;
            }
            if (object.equals(fp_resource.getString("str_save_window"))) {
                if (this.fFileName == null) {
                    return true;
                }
                this.save(String.valueOf(this.fFilePath) + this.fFileName + fFileExtension);
                return true;
            }
            if (object.equals(fp_resource.getString("str_revert"))) {
                if (this.fFileName == null) {
                    return true;
                }
                this.load(String.valueOf(this.fFilePath) + this.fFileName + fFileExtension);
                return true;
            }
            if (object.equals(String.valueOf(fp_resource.getString("str_save_window_as")) + "...")) {
                this.doSave();
                this.cantUndo();
                return true;
            }
            if (object.equals(fp_resource.getString("str_new"))) {
                this.doNew();
                this.cantUndo();
                return true;
            }
            if (object.equals(String.valueOf(fp_resource.getString("str_open")) + "...")) {
                this.doLoad();
                this.cantUndo();
                return true;
            }
            if (object.equals(String.valueOf(fp_resource.getString("str_print_graph")) + "...")) {
                this.fAxes.doPrint();
                this.cantUndo();
                return true;
            }
            if (object.equals(fp_resource.getString("str_quit_function_probe"))) {
                Master.sureToQuit();
                return true;
            }
            if (object.equals(fp_resource.getString("str_hide_graph_history_window"))) {
                ((Component)this.history().frame()).setVisible(false);
                this.cantUndo();
                this.handleMenus();
                return true;
            }
            if (object.equals(fp_resource.getString("str_show_graph_history_window"))) {
                ((Component)this.history().frame()).setVisible(true);
                this.cantUndo();
                this.handleMenus(false);
                return true;
            }
            if (object.equals(fp_resource.getString("str_points_to_table"))) {
                if (this.fAxes.kindOfObjectSelected() != 6) {
                    utils.showErrorDialog(this, fp_resource.getString("str_error__a_point_set_is_not_selected"));
                    return true;
                }
                FPPointSet fPPointSet = (FPPointSet)this.fAxes.selectedObject();
                Master.sendPointsToTable(fPPointSet.xvals(), fPPointSet.yvals(), fPPointSet.numPoints(), this.fAxes.gDepChar, this.fAxes.gIndepChar);
                this.cantUndo();
                return true;
            }
            if (object.equals(String.valueOf(fp_resource.getString("str_variables")) + "...")) {
                VariablesDialog variablesDialog = new VariablesDialog(this);
                ((Component)variablesDialog).setVisible(true);
                this.cantUndo();
                return true;
            }
            if (object.equals(fp_resource.getString("str_copy"))) {
                if (this.fHistory.inFocus()) {
                    this.fHistory.doCopy();
                } else {
                    this.fAxes.doCopy(fGraphClip);
                }
                this.cantUndo();
                return true;
            }
            if (object.equals(fp_resource.getString("str_paste"))) {
                if (this.fHistory.inFocus()) {
                    this.fHistory.doPaste();
                } else {
                    this.fAxes.doPaste(fGraphClip);
                }
                return true;
            }
            if (object.equals(fp_resource.getString("str_cut"))) {
                if (this.fHistory.inFocus()) {
                    this.fHistory.doCut();
                } else {
                    this.fAxes.doCut(fGraphClip);
                }
                this.cantUndo();
                return true;
            }
            if (object.equals(String.valueOf(fp_resource.getString("str_rescale")) + "...")) {
                this.fAxes.clearMode();
                RescaleFrame rescaleFrame = new RescaleFrame(this.fAxes, this);
                ((Component)rescaleFrame).setVisible(true);
                this.cantUndo();
                return true;
            }
            if ((MenuItem)event.target == this.fConnectPoints) {
                this.fAxes.connectPoints();
                this.cantUndo();
                return true;
            }
            if (object.equals(fp_resource.getString("str_sample_again"))) {
                this.fAxes.sampleAgain();
                return true;
            }
            if (object.equals(fp_resource.getString("str_new_equation"))) {
                this.fAxes.mode(23);
                this.setToolbarMode(4);
                this.cantUndo();
                return true;
            }
            if (object.equals(fp_resource.getString("str_select_all"))) {
                this.fAxes.selectAll();
                return true;
            }
            if (object.equals(String.valueOf(fp_resource.getString("str_select_background")) + "...")) {
                this.fAxes.loadBackdrop();
                this.fAxes.drawBackground();
                utils.pause(100);
                this.fAxes.repaint();
                this.cantUndo();
                this.handleMenus();
                return true;
            }
            if (object.equals(fp_resource.getString("str_equation_to_calculator_as_button"))) {
                this.fAxes.sendToCalculator();
                this.cantUndo();
                return true;
            }
            if (object.equals(fp_resource.getString("str_clear_background"))) {
                this.fAxes.clearBackdrop();
                this.fAxes.drawBackground();
                utils.pause(100);
                this.fAxes.repaint();
                this.cantUndo();
                this.handleMenus();
                return true;
            }
            if (event.target == this.fUndoMenu) {
                this.fUndoer.undo();
                this.cantUndo();
                this.handleMenus();
                return true;
            }
            if (event.target == this.fBarsToTableHeights) {
                if (this.fAxes.kindOfObjectSelected() != 7) {
                    utils.showErrorDialog(this, fp_resource.getString("str_error__a_bar_set_is_not_selected"));
                    return true;
                }
                FPBarSet fPBarSet = (FPBarSet)this.fAxes.selectedObject();
                if (!fPBarSet.contiguous()) {
                    utils.showErrorDialog(this, fp_resource.getString("str_error__a_bar_set_must_be_contiguous_to_be_sent_to_the_table"));
                    return true;
                }
                Master.sendBarsToTable(fPBarSet.lefts(), fPBarSet.yvals(), fPBarSet.widths(), fPBarSet.numPoints(), fp_resource.getString("str_heights"), this.fAxes.indepVar(fPBarSet.varIndex()));
                this.cantUndo();
                return true;
            }
            if (event.target == this.fBarsToTableAreas) {
                if (this.fAxes.kindOfObjectSelected() != 7) {
                    utils.showErrorDialog(this, fp_resource.getString("str_error__a_bar_set_is_not_selected"));
                    return true;
                }
                FPBarSet fPBarSet = (FPBarSet)this.fAxes.selectedObject();
                Master.sendBarsToTable(fPBarSet.lefts(), fPBarSet.yvals(), fPBarSet.widths(), fPBarSet.numPoints(), fp_resource.getString("str_areas"), this.fAxes.indepVar(fPBarSet.varIndex()));
                this.cantUndo();
                return true;
            }
            if (event.target == this.fBarsToTableAccum) {
                if (this.fAxes.kindOfObjectSelected() != 7) {
                    utils.showErrorDialog(this, fp_resource.getString("str_error__a_bar_set_is_not_selected"));
                    this.cantUndo();
                    return true;
                }
                FPBarSet fPBarSet = (FPBarSet)this.fAxes.selectedObject();
                Master.sendBarsToTable(fPBarSet.lefts(), fPBarSet.yvals(), fPBarSet.widths(), fPBarSet.numPoints(), fp_resource.getString("str_accum"), this.fAxes.indepVar(fPBarSet.varIndex()));
                this.cantUndo();
                return true;
            }
            if (event.target == this.fDeletePoint) {
                this.fAxes.deletePoint();
                this.fAxes.drawBackground();
                this.fAxes.repaint();
                this.cantUndo();
                this.handleMenus();
                return true;
            }
            if (event.target == this.fAddPoint) {
                this.fAxes.addPoints();
                this.fAxes.drawBackground();
                this.fAxes.repaint();
                this.cantUndo();
                return true;
            }
            if (object.equals(fp_resource.getString("str_group_selection"))) {
                this.fAxes.groupSelection();
                this.cantUndo();
                return true;
            }
            if (object.equals(fp_resource.getString("str_ungroup"))) {
                this.fAxes.ungroup();
                this.cantUndo();
                return true;
            }
            if (object.equals(fp_resource.getString("str_bars_from_points"))) {
                this.fAxes.barsFromPoints();
                return true;
            }
            if (object.equals(fp_resource.getString("str_slopes_from_points"))) {
                this.fAxes.slopesFromPoints();
                return true;
            }
            if (object.equals(fp_resource.getString("str_points_from_bars"))) {
                this.fAxes.pointsFromBars();
                return true;
            }
            if (object.equals(fp_resource.getString("str_points_from_slopes"))) {
                this.fAxes.pointsFromSlopes();
                return true;
            }
            if (event.target == this.fSamplePoints) {
                this.fAxes.sampleEquation(6);
                return true;
            }
            if (event.target == this.fSampleBars) {
                this.fAxes.sampleEquation(7);
                return true;
            }
            if (event.target == this.fSampleSlopes) {
                this.fAxes.sampleEquation(8);
                return true;
            }
            if (event.target == this.fFSPoints) {
                this.fAxes.clearMode();
                FreeStandingFrame freeStandingFrame = new FreeStandingFrame(this.fAxes, this, 6);
                ((Component)freeStandingFrame).setVisible(true);
                return true;
            }
            if (event.target == this.fFSBars) {
                this.fAxes.clearMode();
                FreeStandingFrame freeStandingFrame = new FreeStandingFrame(this.fAxes, this, 7);
                ((Component)freeStandingFrame).setVisible(true);
                return true;
            }
            if (event.target == this.fFSSlopes) {
                this.fAxes.clearMode();
                FreeStandingFrame freeStandingFrame = new FreeStandingFrame(this.fAxes, this, 8);
                ((Component)freeStandingFrame).setVisible(true);
                return true;
            }
            if (object.equals(fp_resource.getString("str_clear_selections"))) {
                this.fAxes.deleteSelection();
                return true;
            }
            if (object.equals(fp_resource.getString("str_clear_others"))) {
                this.fAxes.deleteOthers();
                return true;
            }
            if (object.equals(String.valueOf(fp_resource.getString("str_graph_options")) + "...")) {
                GraphOptionsFrame graphOptionsFrame = new GraphOptionsFrame(this.fAxes, this);
                ((Component)graphOptionsFrame).setVisible(true);
                this.cantUndo();
                return true;
            }
            if (object.equals(fp_resource.getString("str_hide_graph"))) {
                ((MenuItem)event.target).setLabel(fp_resource.getString("str_show_graph"));
                this.setVisible(false);
                this.cantUndo();
                return true;
            }
            if (object.equals(fp_resource.getString("str_show_graph"))) {
                ((MenuItem)event.target).setLabel(fp_resource.getString("str_hide_graph"));
                this.setVisible(true);
                this.cantUndo();
                return true;
            }
            if (object.equals(fp_resource.getString("str_addsubtract_ordinates"))) {
                this.fAxes.mode(0);
                this.fToolbar.setToArrowMode();
                this.fToolbar.repaint();
                this.fAxes.addingOrdinates(true);
                this.fAxes.clearSelect();
                this.fAxes.drawBackground();
                this.fAxes.repaint();
                this.cantUndo();
                this.fAddOrdFrame.setVisible(true);
                return true;
            }
            if (object.equals(fp_resource.getString("str_quit_function_probe"))) {
                Master.sureToQuit();
                return true;
            }
        }
        return super.action(event, object);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        String string = (String)itemEvent.getItem();
        if (string.equals(fp_resource.getString("str_show_asymptotes"))) {
            this.fAxes.showAsymptotes(this.fShowAsymptotes.getState());
            this.cantUndo();
        }
    }

    public void doNewEquation(String string) {
        this.fHistory.setText(string);
        this.fHistory.requestFocus();
        this.fAxes.clearSelect();
        this.fAxes.repaint();
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            this.setVisible(false);
            return false;
        }
        return super.handleEvent(event);
    }

    public void createPointSet(double[] dArray, double[] dArray2, int n, char c, char c2) {
        this.fAxes.createPointSet(dArray, dArray2, n, c, c2);
    }

    public void createPolarPointSet(double[] dArray, double[] dArray2, int n) {
        this.fAxes.createPolarPointSet(dArray, dArray2, n);
    }

    public void createBarSet(double[] dArray, double[] dArray2, int n) {
        this.fAxes.createBarSet(dArray, dArray2, n);
    }

    public void hideAuxWindows() {
        ((Component)this.fToolbar).setVisible(false);
        ((Component)this.fColorPalette).setVisible(false);
    }

    public boolean save(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(fileOutputStream);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(gZIPOutputStream);
            GraphFileData graphFileData = new GraphFileData(this.fAxes);
            objectOutputStream.writeObject(graphFileData);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            utils.showErrorDialog(this, String.valueOf(fp_resource.getString("str_error__in_io_during_save")) + ": " + iOException.getMessage());
            return false;
        }
        return true;
    }

    public void doSave() {
        FileDialog fileDialog = new FileDialog((Frame)this, fp_resource.getString("str_save_graph"), 1);
        fileDialog.setFile(String.valueOf(fp_resource.getString("str_untitled")) + fFileExtension);
        ((Component)fileDialog).setVisible(true);
        String string = fileDialog.getFile();
        String string2 = fileDialog.getDirectory();
        if (string != null) {
            if (!string.endsWith(fFileExtension)) {
                string = String.valueOf(string) + fFileExtension;
            }
            if (!this.save(String.valueOf(string2) + string)) {
                return;
            }
            this.fFileName = string.substring(0, string.length() - 4);
            this.fFilePath = string2;
            this.setTitle(this.fFileName);
            this.handleMenus();
        }
    }

    public void setFromFileData(GraphFileData graphFileData) {
        this.fAxes.clearAll();
        this.fHistory.clearAll();
        graphFileData.getGraphData(this.fAxes);
        this.fAxes.setUpAxes();
        this.fAxes.drawBackground();
        this.fAxes.repaint();
    }

    public void load(String string) {
        GraphFileData graphFileData;
        if (string == null) {
            return;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(fileInputStream);
            ObjectInputStream objectInputStream = new ObjectInputStream(gZIPInputStream);
            graphFileData = (GraphFileData)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (IOException iOException) {
            File file = new File(string);
            String string2 = utils.sprintf(fp_resource.getString("str_error__wrong_or_corrupt_file"), file.getName());
            utils.showErrorDialog(this, string2);
            return;
        }
        catch (Exception exception) {
            utils.showErrorDialog(this, String.valueOf(fp_resource.getString("str_error__in_io_during_load")) + ": " + exception.getMessage());
            return;
        }
        this.setFromFileData(graphFileData);
        Master.scanForEvaluators();
        this.setVisible(true);
    }

    public void doLoad() {
        FileDialog fileDialog = new FileDialog((Frame)this, fp_resource.getString("str_load_graph"), 0);
        fileDialog.setFilenameFilter(this);
        ((Component)fileDialog).setVisible(true);
        String string = fileDialog.getFile();
        if (string != null) {
            if (string.endsWith(fFileExtension)) {
                this.load(String.valueOf(fileDialog.getDirectory()) + string);
                this.fFileName = string.substring(0, string.length() - 4);
                this.fFilePath = fileDialog.getDirectory();
                this.setTitle(this.fFileName);
                this.handleMenus();
            } else {
                Master.loadWorkspace(String.valueOf(fileDialog.getDirectory()) + string);
            }
        }
    }

    public boolean accept(File file, String string) {
        return string.endsWith(fFileExtension) || string.endsWith(".prb");
    }

    public void handleMenus() {
        this.handleMenus(true);
    }

    public void handleMenus(boolean bl) {
        FPObject fPObject;
        int n = this.fAxes.numSelectedObjects();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = this.fAxes.polarMode();
        if (n == 1 && !(fPObject = this.fAxes.selectedObject()).deleted()) {
            bl6 = fPObject instanceof Evaluatable;
            bl3 = fPObject.kind() == 0;
            bl2 = fPObject.kind() == 1;
            bl4 = fPObject.kind() == 6;
            bl5 = fPObject.kind() == 7;
            bl8 = fPObject.kind() == 8;
            boolean bl11 = bl9 = fPObject.kind() == 5;
            if (bl4) {
                if (((FPPointSet)fPObject).connected()) {
                    this.fConnectPoints.setLabel(fp_resource.getString("str_disconnect_points"));
                } else {
                    this.fConnectPoints.setLabel(fp_resource.getString("str_connect_points"));
                }
            }
        }
        if (n == 2 && this.fAxes.selectedObject(0).kind() == 0 && this.fAxes.selectedObject(1).kind() == 0) {
            bl7 = true;
        }
        this.fSaveMenu.setEnabled(this.fFileName != null);
        this.fRevertMenu.setEnabled(this.fFileName != null);
        this.fUndoMenu.setEnabled(this.fUndoer.undoable());
        if (this.fUndoer.undoable()) {
            this.fUndoMenu.setLabel(this.fUndoer.undoString());
        } else {
            this.fUndoMenu.setLabel(fp_resource.getString("str_cant_undo"));
        }
        this.fClearBackdrop.setEnabled(this.fAxes.backdropImage() != null);
        this.fDefineObject.setEnabled(n == 1);
        this.fToolbar.enable(bl6, bl4);
        this.fConnectPoints.setEnabled(bl4);
        if (!bl4) {
            this.fConnectPoints.setLabel(fp_resource.getString("str_connect_points"));
        }
        this.fBarsFromPoints.setEnabled(bl4 && !bl10);
        this.fSlopesFromPoints.setEnabled(bl4 && !bl10);
        this.fPointsFromBars.setEnabled(bl5);
        this.fPointsFromSlopes.setEnabled(bl8);
        this.fBarsToTableAreas.setEnabled(bl5);
        this.fBarsToTableHeights.setEnabled(bl5);
        this.fBarsToTableAccum.setEnabled(bl5);
        this.fSampleMenu.setEnabled(bl3 || bl9 || bl2);
        this.fSampleAgain.setEnabled((bl3 || bl9 || bl2) && this.fAxes.sampleAgainEnabled());
        this.fAddOrdinates.setEnabled(bl7);
        this.fPointsToTable.setEnabled(bl4);
        this.fDeletePoint.setEnabled(bl4 || bl5 || bl8);
        this.fAddPoint.setEnabled(bl4 || bl5 || bl8);
        this.fFreestandingMenu.setEnabled(bl10 ^ true);
        String string = fp_resource.getString("str_delete");
        if (this.fAxes.isCurrentPointDeleted()) {
            string = fp_resource.getString("str_undelete");
        }
        if (this.fSendToCalc != null) {
            this.fSendToCalc.setEnabled(bl3);
        }
        if (bl5) {
            this.fDeletePoint.setLabel(String.valueOf(string) + " " + fp_resource.getString("str_bar"));
            this.fAddPoint.setLabel(fp_resource.getString("str_add_bars"));
        } else if (bl8) {
            this.fDeletePoint.setLabel(String.valueOf(string) + " " + fp_resource.getString("str_slope"));
            this.fAddPoint.setLabel(fp_resource.getString("str_add_slopes"));
        } else {
            this.fDeletePoint.setLabel(String.valueOf(string) + " " + fp_resource.getString("str_point"));
            this.fAddPoint.setLabel(fp_resource.getString("str_add_points"));
        }
        if (this.history().frame().isShowing()) {
            this.fHistoryFrameMenu.setLabel(fp_resource.getString("str_hide_graph_history_window"));
        } else {
            this.fHistoryFrameMenu.setLabel(fp_resource.getString("str_show_graph_history_window"));
        }
        if (n >= 2) {
            this.fGroup.setLabel(fp_resource.getString("str_group_selection"));
            this.fGroup.setEnabled(true);
        } else if (n == 1 && this.fAxes.selectedObject().kind() == 12) {
            this.fGroup.setLabel(fp_resource.getString("str_ungroup"));
            this.fGroup.setEnabled(true);
        } else {
            this.fGroup.setLabel(fp_resource.getString("str_group_selection"));
            this.fGroup.setEnabled(false);
        }
        if (this.fWindowMenuHandler != null) {
            this.fWindowMenuHandler.updateMenu();
        }
        if (bl) {
            Master.forceUpdate(this);
        }
    }

    public void cantUndo() {
        this.fUndoer.undoable(false);
        this.handleMenus(true);
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.black);
        int n = this.fAxes.getLocation().y + this.fAxes.getSize().height;
        graphics.drawLine(0, n, this.fAxes.getSize().width, n);
    }

    public Toolbar toolbar() {
        return this.fToolbar;
    }

    public HistoryArea history() {
        return this.fHistory;
    }

    public FPAxes axes() {
        return this.fAxes;
    }

    public ColorPalette colorPalette() {
        return this.fColorPalette;
    }

    public AddOrdinatesFrame addOrdFrame() {
        return this.fAddOrdFrame;
    }

    public UndoGrapher undoer() {
        return this.fUndoer;
    }

    private final class 1
    extends ComponentAdapter {
        public void componentResized(ComponentEvent componentEvent) {
            boolean bl = false;
            Grapher.this.fColorPalette.setBounds(Grapher.this.getLocation().x + Grapher.this.getSize().width + 20, Grapher.this.getLocation().y, ((Grapher)Grapher.this).fColorPalette.getSize().width, ((Grapher)Grapher.this).fColorPalette.getSize().height);
            ((Component)Grapher.this.fCurvePalette).setBounds(Grapher.this.getLocation().x + Grapher.this.getSize().width + 20, Grapher.this.getLocation().y + ((Grapher)Grapher.this).fColorPalette.getSize().height + 35, ((Grapher)Grapher.this).fCurvePalette.getSize().width, ((Grapher)Grapher.this).fCurvePalette.getSize().height);
            Grapher.this.mySetBounds(Grapher.this.getLocation().x, Grapher.this.getLocation().y, Grapher.this.getSize().width, Grapher.this.getSize().height);
        }

        public void componentMoved(ComponentEvent componentEvent) {
            int n = Master.gTop;
            int n2 = Master.gSmallTop;
            Grapher.this.fToolbar.setBounds(Grapher.this.getLocation().x, Grapher.this.getLocation().y - 65, ((Grapher)Grapher.this).fToolbar.getSize().width, ((Grapher)Grapher.this).fToolbar.getSize().height);
            Grapher.this.fColorPalette.setBounds(Grapher.this.getLocation().x + Grapher.this.getSize().width + 20, Grapher.this.getLocation().y, ((Grapher)Grapher.this).fColorPalette.getSize().width, ((Grapher)Grapher.this).fColorPalette.getSize().height);
            ((Component)Grapher.this.fCurvePalette).setBounds(Grapher.this.getLocation().x + Grapher.this.getSize().width + 20, Grapher.this.getLocation().y + ((Grapher)Grapher.this).fColorPalette.getSize().height + 35, ((Grapher)Grapher.this).fCurvePalette.getSize().width, ((Grapher)Grapher.this).fCurvePalette.getSize().height);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends WindowAdapter {
        public void windowActivated(WindowEvent windowEvent) {
            if (!Grapher.this.fToolbar.isShowing() && !fActivating) {
                fActivating = true;
                ((Component)Grapher.this.fToolbar).setVisible(true);
                ((Component)Grapher.this.fColorPalette).setVisible(true);
                Grapher.this.toFront();
            }
            fActivating = false;
            switch (Master.numGraphers()) {
                case 3: {
                    if (Grapher.this.fGrapherNum != 3) {
                        Master.hideGrapherCAuxWindows();
                    }
                }
                case 2: {
                    if (Grapher.this.fGrapherNum == 2) break;
                    Master.hideGrapherBAuxWindows();
                }
            }
            if (Grapher.this.fGrapherNum != 1) {
                Master.hideGrapherAuxWindows();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            if (Master.graphAVisible() && Grapher.this.fGrapherNum != 1 || Master.graphBVisible() && Grapher.this.fGrapherNum != 2 || Master.graphCVisible() && Grapher.this.fGrapherNum != 3 || Master.calcVisible() || Master.tableVisible()) {
                Grapher.this.setVisible(false);
                ((Component)Grapher.this.fColorPalette).setVisible(false);
                ((Component)Grapher.this.fToolbar).setVisible(false);
                ((Component)Grapher.this.fCurvePalette).setVisible(false);
                Grapher.this.handleMenus(false);
            } else {
                Master.sureToQuit();
            }
        }

        /* synthetic */ 2() {
        }
    }
}

