/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPGrapher;

import com.questmsm.FPGrapher.FPAxes;
import com.questmsm.FPGrapher.MiniAxes;
import com.questmsm.FPGrapher.Scale;
import com.questmsm.FPGrapher.ScaleNameDialog;
import com.questmsm.FPGrapher.Scales;
import com.questmsm.FPGrapher.SureToDeleteScale;
import com.questmsm.FunctionProbe.Master;
import com.questmsm.Utilities.DialogField;
import com.questmsm.Utilities.DialogSuperClass;
import com.questmsm.Utilities.fp_resource;
import com.questmsm.Utilities.utils;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class RescaleFrame
extends DialogSuperClass
implements FocusListener,
TextListener {
    private DialogField fMinX;
    private DialogField fMaxX;
    private DialogField fMinY;
    private DialogField fMaxY;
    private DialogField fXMajTick;
    private DialogField fYMajTick;
    private FPAxes fAxes;
    private Frame fParent;
    private Checkbox fCartesian;
    private Checkbox fPolar;
    private Checkbox fLog;
    private Checkbox fLogX;
    private Checkbox fLogY;
    private Checkbox fLogTick;
    private Checkbox fRegTick;
    private MiniAxes fMiniAxes;
    private Button fSaveScale;
    private Button fDeleteScale;
    private Scales fScales;
    private Scale fUntitledScale;
    private Choice fChoice;
    private Label fMaxYBase;
    private Label fMinYBase;
    private Label fMaxXBase;
    private Label fMinXBase;
    private Label fXTickBase;
    private Label fYTickBase;
    private DialogField fMaxYExp;
    private DialogField fMaxYVal;
    private DialogField fMinYExp;
    private DialogField fMinYVal;
    private DialogField fMaxXExp;
    private DialogField fMaxXVal;
    private DialogField fMinXExp;
    private DialogField fMinXVal;
    private DialogField fXTickExp;
    private DialogField fXTickVal;
    private DialogField fYTickExp;
    private DialogField fYTickVal;
    private DialogField fBaseX;
    private DialogField fBaseY;
    private boolean fValueChanged = false;
    private static final String kScalesFilename = "GraphScales.dat";
    ActionListener textFieldListener = new 1();
    ItemListener checkboxListener = new 2();
    Label fBaseXLabel;
    Label fBaseYLabel;

    public RescaleFrame(FPAxes fPAxes, Frame frame) {
        super(frame);
        int n;
        this.setTitle(fp_resource.getString("str_rescale"));
        this.fAxes = fPAxes;
        this.fParent = frame;
        int n2 = Master.gSmallTop;
        this.setBounds(0, 0, 600, 435 + n2);
        this.setLayout(null);
        this.fScales = this.loadScales();
        if (this.fScales == null) {
            this.fScales = new Scales();
            this.fScales.addScale(-4.0, 4.0, -4.0, 4.0, 1.0, 1.0, false, false, false, false, 10.0, 10.0, fp_resource.getString("str_default"));
        }
        this.fChoice = new Choice();
        this.add(this.fChoice);
        if (this.fScales != null) {
            n = 0;
            while (n < this.fScales.numScales) {
                this.fChoice.addItem(this.fScales.theScales[n].scalename);
                ++n;
            }
        }
        this.fChoice.setBounds(25, 22 + n2, 100, 20);
        this.fChoice.addItemListener(new 3());
        n = 5;
        int n3 = 73 + n2;
        int n4 = 18;
        int n5 = 3;
        int n6 = 138;
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.fCartesian = new Checkbox(fp_resource.getString("str_cartesian_plane"), checkboxGroup, true);
        this.add(this.fCartesian);
        this.fCartesian.setBounds(n, n3, n6, n4);
        this.fPolar = new Checkbox(fp_resource.getString("str_polar_coordinates"), checkboxGroup, false);
        this.add(this.fPolar);
        this.fPolar.setBounds(n, n3 += n4 + n5, n6, n4);
        this.fLog = new Checkbox(fp_resource.getString("str_log_scales"), checkboxGroup, false);
        this.add(this.fLog);
        this.fLog.setBounds(n, n3 += n4 + n5, n6, n4);
        n3 += 5;
        this.fLogX = new Checkbox("x", null, false);
        this.add(this.fLogX);
        this.fLogX.setBounds(n + 70, n3 += n4 + n5, 40, n4);
        this.fLogX.setVisible(false);
        this.fLogY = new Checkbox("y", null, false);
        this.add(this.fLogY);
        this.fLogY.setBounds(n + 70, n3 += n4 + n5, 40, n4);
        this.fLogY.setVisible(false);
        checkboxGroup = new CheckboxGroup();
        n3 += 18;
        this.fLogTick = new Checkbox("", checkboxGroup, true);
        this.add(this.fLogTick);
        this.fLogTick.setBounds(n, n3 += n4 + n5, 18, n4);
        n3 += 2;
        this.fRegTick = new Checkbox("", checkboxGroup, false);
        this.add(this.fRegTick);
        this.fRegTick.setBounds(n, n3 += n4 + n5, 18, n4);
        this.fPolar.addItemListener(this.checkboxListener);
        this.fCartesian.addItemListener(this.checkboxListener);
        this.fLog.addItemListener(this.checkboxListener);
        this.fLogX.addItemListener(this.checkboxListener);
        this.fLogY.addItemListener(this.checkboxListener);
        this.fRegTick.addItemListener(this.checkboxListener);
        this.fLogTick.addItemListener(this.checkboxListener);
        n4 = 18;
        this.fSaveScale = new Button(fp_resource.getString("str_save_scale"));
        this.add(this.fSaveScale);
        DialogSuperClass.setButtonColors(this.fSaveScale);
        this.fSaveScale.setBounds(5, 260 + n2, 135, n4);
        this.fSaveScale.addActionListener(new 4());
        this.fDeleteScale = new Button(fp_resource.getString("str_delete_scale"));
        this.add(this.fDeleteScale);
        DialogSuperClass.setButtonColors(this.fDeleteScale);
        this.fDeleteScale.setBounds(5, 285 + n2, 135, n4);
        this.fDeleteScale.addActionListener(new 5());
        this.add(this.fOK);
        this.fOK.setBounds(30, 330 + n2, 70, n4);
        this.add(this.fCancel);
        this.fCancel.setBounds(30, 360 + n2, 70, n4);
        n4 = 21;
        this.fMinX = new DialogField();
        this.fMinX.setBounds(160, 140 + n2, 100, n4);
        this.fMinX.addFocusListener(this);
        this.fMinX.addTextListener(this);
        this.fMinX.addActionListener(this.textFieldListener);
        this.setTextFieldColors(this.fMinX);
        this.fMaxX = new DialogField();
        this.setTextFieldColors(this.fMaxX);
        this.fMaxX.setBounds(480, 140 + n2, 100, n4);
        this.fMaxX.addFocusListener(this);
        this.fMaxX.addTextListener(this);
        this.fMaxX.addActionListener(this.textFieldListener);
        this.fXMajTick = new DialogField();
        this.setTextFieldColors(this.fXMajTick);
        this.fXMajTick.setBounds(220, 395 + n2, 100, n4);
        this.fXMajTick.addFocusListener(this);
        this.fXMajTick.addTextListener(this);
        this.fXMajTick.addActionListener(this.textFieldListener);
        this.fYMajTick = new DialogField();
        this.setTextFieldColors(this.fYMajTick);
        this.fYMajTick.setBounds(390, 395 + n2, 100, n4);
        this.fYMajTick.addFocusListener(this);
        this.fYMajTick.addTextListener(this);
        this.fYMajTick.addActionListener(this.textFieldListener);
        this.fMinY = new DialogField();
        this.setTextFieldColors(this.fMinY);
        this.fMinY.setBounds(305, 290 + n2, 100, n4);
        this.fMinY.addFocusListener(this);
        this.fMinY.addTextListener(this);
        this.fMinY.addActionListener(this.textFieldListener);
        this.fMaxY = new DialogField();
        this.setTextFieldColors(this.fMaxY);
        this.fMaxY.setBounds(305, 30 + n2, 100, n4);
        this.fMaxY.addFocusListener(this);
        this.fMaxY.addTextListener(this);
        this.fMaxY.addActionListener(this.textFieldListener);
        this.add(this.fMinX);
        this.add(this.fMaxX);
        this.add(this.fMinY);
        this.add(this.fMaxY);
        this.add(this.fXMajTick);
        this.add(this.fYMajTick);
        this.addLogStuff();
        this.fMiniAxes = new MiniAxes(0.0, 1.0, 0.0, 1.0, 1.0);
        this.add(this.fMiniAxes);
        this.fMiniAxes.setBounds(270, 70 + n2, 200, 200);
        this.addWindowListener(new 6());
        this.addMouseListener(new 7());
    }

    private void doDeleteScale() {
        int n = this.fChoice.getSelectedIndex();
        if (n == 0) {
            utils.showErrorDialog(this.fParent, fp_resource.getString("str_error__you_can_not_delete_the_default_scale"));
            return;
        }
        if (n == this.fChoice.getItemCount() - 1) {
            utils.showErrorDialog(this.fParent, fp_resource.getString("str_error__cant_delete_this_scale_because_it_hasnt_been_saved"));
            return;
        }
        SureToDeleteScale sureToDeleteScale = new SureToDeleteScale(this.fParent, fp_resource.getString("str_are_you_sure"), String.valueOf(fp_resource.getString("str_are_you_sure_you_want_to_delete_scale")) + " \"" + this.fScales.theScales[n].scalename + "\"?", fp_resource.getString("str_yes"), null, fp_resource.getString("str_no"), this);
        ((Component)sureToDeleteScale).setVisible(true);
    }

    private void handleMousePressed(MouseEvent mouseEvent) {
        if (!this.fLogTick.isShowing()) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = this.fLogTick.getBounds().y;
        int n4 = this.fLogTick.getBounds().x;
        int n5 = this.fLogTick.getBounds().width;
        int n6 = this.fLogTick.getBounds().height;
        if (n > n4 + n5 && n < n4 + n5 + 100 && n2 > n3 && n2 < n3 + n6) {
            this.fLogTick.setState(true);
            this.doLogX();
            this.doLogY();
            this.showLogs();
            this.setMiniAxesVals();
            this.fMiniAxes.setUpAxes();
            this.fMiniAxes.repaint();
            this.repaint();
        } else {
            n3 = this.fRegTick.getBounds().y;
            n4 = this.fRegTick.getBounds().x;
            n5 = this.fRegTick.getBounds().width;
            n6 = this.fRegTick.getBounds().height;
            if (n > n4 + n5 && n < n4 + n5 + 100 && n2 > n3 && n2 < n3 + n6) {
                this.fRegTick.setState(true);
                this.doLogX();
                this.doLogY();
                this.showLogs();
                this.setMiniAxesVals();
                this.fMiniAxes.setUpAxes();
                this.fMiniAxes.repaint();
                this.repaint();
            }
        }
    }

    public void addLogStuff() {
        int n = Master.gSmallTop;
        int n2 = 21;
        this.fMinXBase = new Label("10");
        this.fMinXBase.setBounds(198, 140 + n, 30, n2);
        this.fMinXExp = new DialogField();
        this.setTextFieldColors(this.fMinXExp);
        this.fMinXExp.setBounds(213, 121 + n, 50, n2);
        this.fMinXExp.addFocusListener(this);
        this.fMinXExp.addTextListener(this);
        this.fMinXExp.addActionListener(this.textFieldListener);
        this.fMinXVal = new DialogField();
        this.setTextFieldColors(this.fMinXVal);
        this.fMinXVal.setBounds(183, 164 + n, 85, n2);
        this.fMinXVal.addFocusListener(this);
        this.fMinXVal.addTextListener(this);
        this.fMinXVal.addActionListener(this.textFieldListener);
        this.fMaxXBase = new Label("10");
        this.fMaxXBase.setBounds(520, 140 + n, 30, n2);
        this.fMaxXExp = new DialogField();
        this.setTextFieldColors(this.fMaxXExp);
        this.fMaxXExp.setBounds(535, 121 + n, 50, n2);
        this.fMaxXExp.addFocusListener(this);
        this.fMaxXExp.addTextListener(this);
        this.fMaxXExp.addActionListener(this.textFieldListener);
        this.fMaxXVal = new DialogField();
        this.setTextFieldColors(this.fMaxXVal);
        this.fMaxXVal.setBounds(505, 164 + n, 85, n2);
        this.fMaxXVal.addFocusListener(this);
        this.fMaxXVal.addTextListener(this);
        this.fMaxXVal.addActionListener(this.textFieldListener);
        this.fMinYBase = new Label("10");
        this.fMinYBase.setBounds(315, 307 + n, 30, n2);
        this.fMinYExp = new DialogField();
        this.setTextFieldColors(this.fMinYExp);
        this.fMinYExp.setBounds(330, 288 + n, 50, n2);
        this.fMinYExp.addFocusListener(this);
        this.fMinYExp.addTextListener(this);
        this.fMinYExp.addActionListener(this.textFieldListener);
        this.fMinYVal = new DialogField();
        this.setTextFieldColors(this.fMinYVal);
        this.fMinYVal.setBounds(395, 305 + n, 85, n2);
        this.fMinYVal.addFocusListener(this);
        this.fMinYVal.addTextListener(this);
        this.fMinYVal.addActionListener(this.textFieldListener);
        this.fMaxYBase = new Label("10");
        this.fMaxYBase.setBounds(315, 30 + n, 30, n2);
        this.fMaxYExp = new DialogField();
        this.setTextFieldColors(this.fMaxYExp);
        this.fMaxYExp.setBounds(330, 11 + n, 50, n2);
        this.fMaxYExp.addFocusListener(this);
        this.fMaxYExp.addTextListener(this);
        this.fMaxYExp.addActionListener(this.textFieldListener);
        this.fMaxYVal = new DialogField();
        this.setTextFieldColors(this.fMaxYVal);
        this.fMaxYVal.setBounds(395, 28 + n, 85, n2);
        this.fMaxYVal.addFocusListener(this);
        this.fMaxYVal.addTextListener(this);
        this.fMaxYVal.addActionListener(this.textFieldListener);
        this.fXTickBase = new Label("10");
        this.fXTickBase.setBounds(200, 390 + n, 30, n2);
        this.fXTickExp = new DialogField();
        this.setTextFieldColors(this.fXTickExp);
        this.fXTickExp.setBounds(220, 372 + n, 50, n2);
        this.fXTickExp.addFocusListener(this);
        this.fXTickExp.addTextListener(this);
        this.fXTickExp.addActionListener(this.textFieldListener);
        this.fXTickVal = new DialogField();
        this.setTextFieldColors(this.fXTickVal);
        this.fXTickVal.setBounds(190, 408 + n, 100, n2);
        this.fXTickVal.addFocusListener(this);
        this.fXTickVal.addTextListener(this);
        this.fXTickVal.addActionListener(this.textFieldListener);
        this.fYTickBase = new Label("10");
        this.fYTickBase.setBounds(400, 390 + n, 30, n2);
        this.fYTickExp = new DialogField();
        this.setTextFieldColors(this.fYTickExp);
        this.fYTickExp.setBounds(420, 372 + n, 50, n2);
        this.fYTickExp.addFocusListener(this);
        this.fYTickExp.addTextListener(this);
        this.fYTickExp.addActionListener(this.textFieldListener);
        this.fYTickVal = new DialogField();
        this.setTextFieldColors(this.fYTickVal);
        this.fYTickVal.setBounds(390, 408 + n, 100, n2);
        this.fYTickVal.addFocusListener(this);
        this.fYTickVal.addTextListener(this);
        this.fYTickVal.addActionListener(this.textFieldListener);
        this.fBaseX = new DialogField("10");
        this.fBaseX.setBounds(210, 20 + n, 35, n2);
        this.fBaseX.addFocusListener(this);
        this.fBaseX.addTextListener(this);
        this.fBaseX.addActionListener(this.textFieldListener);
        this.setTextFieldColors(this.fBaseX);
        this.fBaseXLabel = this.label(this.fBaseX, String.valueOf(fp_resource.getString("str_x_base")) + ":");
        this.fBaseY = new DialogField("10");
        this.fBaseY.setBounds(210, 40 + n, 35, n2);
        this.fBaseY.addFocusListener(this);
        this.fBaseY.addTextListener(this);
        this.fBaseY.addActionListener(this.textFieldListener);
        this.setTextFieldColors(this.fBaseY);
        this.fBaseYLabel = this.label(this.fBaseY, String.valueOf(fp_resource.getString("str_y_base")) + ":");
        this.fBaseX.setVisible(false);
        this.fBaseXLabel.setVisible(false);
        this.fBaseY.setVisible(false);
        this.fBaseYLabel.setVisible(false);
        this.fMinXBase.setVisible(false);
        this.fMaxXBase.setVisible(false);
        this.fMinYBase.setVisible(false);
        this.fMaxYBase.setVisible(false);
        this.fMinXVal.setVisible(false);
        this.fMaxXVal.setVisible(false);
        this.fMinYVal.setVisible(false);
        this.fMaxYVal.setVisible(false);
        this.fMinXExp.setVisible(false);
        this.fMaxXExp.setVisible(false);
        this.fMinYExp.setVisible(false);
        this.fMaxYExp.setVisible(false);
        this.fXTickBase.setVisible(false);
        this.fXTickVal.setVisible(false);
        this.fXTickExp.setVisible(false);
        this.fYTickBase.setVisible(false);
        this.fYTickVal.setVisible(false);
        this.fYTickExp.setVisible(false);
        this.add(this.fMinXBase);
        this.add(this.fMaxXBase);
        this.add(this.fMinYBase);
        this.add(this.fMaxYBase);
        this.add(this.fMinXVal);
        this.add(this.fMinXExp);
        this.add(this.fMaxXVal);
        this.add(this.fMaxXExp);
        this.add(this.fMinYVal);
        this.add(this.fMinYExp);
        this.add(this.fMaxYVal);
        this.add(this.fMaxYExp);
        this.add(this.fXTickVal);
        this.add(this.fXTickExp);
        this.add(this.fYTickVal);
        this.add(this.fYTickExp);
        this.add(this.fBaseX);
        this.add(this.fBaseY);
        this.add(this.fBaseXLabel);
        this.add(this.fBaseYLabel);
        this.add(this.fXTickBase);
        this.add(this.fYTickBase);
    }

    private void showRegFields() {
        this.fMinX.setVisible(true);
        this.fMaxX.setVisible(true);
        this.fMinY.setVisible(true);
        this.fMaxY.setVisible(true);
        this.fYMajTick.setVisible(true);
        this.fXMajTick.setVisible(true);
    }

    private void showLogs() {
        this.fLogX.setVisible(true);
        this.fLogY.setVisible(true);
        this.fLogTick.setVisible(true);
        this.fRegTick.setVisible(true);
        boolean bl = this.fLogX.getState();
        this.fBaseX.setVisible(bl);
        this.fBaseXLabel.setVisible(bl);
        this.fMinXBase.setVisible(bl);
        this.fMinXExp.setVisible(bl);
        this.fMinXVal.setVisible(bl);
        this.fMaxXBase.setVisible(bl);
        this.fMaxXExp.setVisible(bl);
        this.fMaxXVal.setVisible(bl);
        this.fMinX.setVisible(bl ^ true);
        this.fMaxX.setVisible(bl ^ true);
        bl = this.fLogY.getState();
        this.fBaseY.setVisible(bl);
        this.fBaseYLabel.setVisible(bl);
        this.fMinYBase.setVisible(bl);
        this.fMinYExp.setVisible(bl);
        this.fMinYVal.setVisible(bl);
        this.fMaxYBase.setVisible(bl);
        this.fMaxYExp.setVisible(bl);
        this.fMaxYVal.setVisible(bl);
        this.fMinY.setVisible(bl ^ true);
        this.fMaxY.setVisible(bl ^ true);
        boolean bl2 = this.fRegTick.getState() && this.fLogY.getState();
        this.fYMajTick.setVisible(this.fLogY.getState() ^ true);
        this.fYTickExp.setVisible(bl2);
        this.fYTickVal.setVisible(bl2);
        this.fYTickBase.setVisible(bl2);
        bl2 = this.fRegTick.getState() && this.fLogX.getState();
        this.fXMajTick.setVisible(this.fLogX.getState() ^ true);
        this.fXTickExp.setVisible(bl2);
        this.fXTickVal.setVisible(bl2);
        this.fXTickBase.setVisible(bl2);
    }

    private void showPolar() {
        this.fMiniAxes.polarMode(true);
        this.fMaxX.setVisible(true);
        this.fMinX.setVisible(false);
        this.fMinY.setVisible(false);
        this.fMaxY.setVisible(false);
        this.fYMajTick.setVisible(false);
        this.fXMajTick.setVisible(true);
    }

    private void setMiniAxesValuesForPolar() {
        this.fMiniAxes.minX(-utils._getDouble(this.fMaxX));
        this.fMiniAxes.maxX(utils._getDouble(this.fMaxX));
        this.fMiniAxes.minY(-utils._getDouble(this.fMaxX));
        this.fMiniAxes.maxY(utils._getDouble(this.fMaxX));
        this.fMiniAxes.xMajTick(utils._getDouble(this.fXMajTick));
        this.fMiniAxes.yMajTick(utils._getDouble(this.fXMajTick));
        this.fMiniAxes.setUpAxes();
        this.fMiniAxes.repaint();
    }

    public void setVisible(boolean bl) {
        if (bl) {
            ((TextComponent)this.fMinX).setText(utils.num2str(this.fAxes.minX()));
            ((TextComponent)this.fMaxX).setText(utils.num2str(this.fAxes.maxX()));
            ((TextComponent)this.fMinY).setText(utils.num2str(this.fAxes.minY()));
            ((TextComponent)this.fMaxY).setText(utils.num2str(this.fAxes.maxY()));
            ((TextComponent)this.fXMajTick).setText(utils.num2str(this.fAxes.xMajTick()));
            ((TextComponent)this.fYMajTick).setText(utils.num2str(this.fAxes.yMajTick()));
            this.fPolar.setState(this.fAxes.polarMode());
            this.fCartesian.setState(!this.fAxes.polarMode() && !this.fAxes.logMode());
            this.fLog.setState(this.fAxes.logMode());
            this.fPolar.setEnabled(this.fAxes.allowPolars());
            this.fLog.setEnabled(this.fAxes.allowLogs());
            if (this.fLog.getState()) {
                this.fLogTick.setState(this.fAxes.logTickSpacing());
                this.fRegTick.setState(this.fAxes.logTickSpacing() ^ true);
                this.fLogX.setVisible(true);
                this.fLogY.setVisible(true);
                this.fLogTick.setVisible(true);
                this.fRegTick.setVisible(true);
                this.fLogX.setState(this.fAxes.logX());
                this.fLogY.setState(this.fAxes.logY());
                this.fMiniAxes.logXBase(this.fAxes.logXBase());
                this.fMiniAxes.logYBase(this.fAxes.logYBase());
                this.setXBase(this.fAxes.logXBase());
                this.setYBase(this.fAxes.logYBase());
                this.fMiniAxes.logX(this.fLogX.getState());
                this.fMiniAxes.logY(this.fLogY.getState());
            } else {
                this.hideLogs();
                this.fLogX.setState(this.fAxes.logX());
                this.fLogY.setState(this.fAxes.logY());
                this.fMiniAxes.logX(false);
                this.fMiniAxes.logY(false);
            }
            this.fMiniAxes.logTickSpacing(this.fAxes.logTickSpacing());
            this.fMiniAxes.minX(this.fAxes.minX());
            this.fMiniAxes.maxX(this.fAxes.maxX());
            this.fMiniAxes.minY(this.fAxes.minY());
            this.fMiniAxes.maxY(this.fAxes.maxY());
            this.fMiniAxes.xMajTick(this.fAxes.xMajTick());
            this.fMiniAxes.yMajTick(this.fAxes.yMajTick());
            if (this.fLogX.getState()) {
                if (!this.fAxes.logTickSpacing()) {
                    ((TextComponent)this.fXMajTick).setText(utils.num2str(Math.pow(this.fAxes.logXBase(), this.fAxes.xMajTick())));
                }
                this.doLogX();
            }
            if (this.fLogY.getState()) {
                if (!this.fAxes.logTickSpacing()) {
                    ((TextComponent)this.fYMajTick).setText(utils.num2str(Math.pow(this.fAxes.logXBase(), this.fAxes.yMajTick())));
                }
                this.doLogY();
            }
            if (this.fLog.getState()) {
                this.showLogs();
            }
            if (this.fPolar.getState()) {
                this.fMinX.setVisible(false);
                this.fMinY.setVisible(false);
                this.fMaxY.setVisible(false);
                this.fYMajTick.setVisible(false);
                this.fXMajTick.setVisible(true);
            }
            this.fMiniAxes.polarMode(this.fPolar.getState());
            this.fMiniAxes.setUpAxes();
            this.fUntitledScale = new Scale(this.fMiniAxes.minX(), this.fMiniAxes.maxX(), this.fMiniAxes.minY(), this.fMiniAxes.maxY(), this.fMiniAxes.xMajTick(), this.fMiniAxes.yMajTick(), this.fMiniAxes.logX(), this.fMiniAxes.logY(), this.fMiniAxes.polarMode(), this.fMiniAxes.logTickSpacing(), this.fMiniAxes.logXBase(), this.fMiniAxes.logYBase(), fp_resource.getString("str_untitled"));
            this.fChoice.addItem(fp_resource.getString("str_untitled"));
            this.fChoice.select(this.fChoice.getItemCount() - 1);
        }
        super.setVisible(bl);
    }

    private void setMiniAxesVals() {
        if (this.fLog.getState()) {
            double d;
            this.fMiniAxes.logTickSpacing(this.fLogTick.getState());
            this.fMiniAxes.logX(this.fLogX.getState());
            this.fMiniAxes.logY(this.fLogY.getState());
            if (this.fLogX.getState()) {
                d = utils._getDouble(this.fBaseX);
                if (d != -1.23456123) {
                    this.fMiniAxes.logXBase(d);
                }
                if (utils._getDouble(this.fMinXVal) <= 0.0) {
                    ((TextComponent)this.fMinXVal).setText("");
                    ((TextComponent)this.fMinXExp).setText("");
                    this.fMiniAxes.minX(-1.23456123);
                } else {
                    this.fMiniAxes.minX(utils._getDouble(this.fMinXVal));
                    ((TextComponent)this.fMinX).setText(this.fMinXVal.getText());
                }
                if (utils._getDouble(this.fMaxXVal) <= 0.0) {
                    ((TextComponent)this.fMaxXVal).setText("");
                    ((TextComponent)this.fMaxXExp).setText("");
                    this.fMiniAxes.maxX(-1.23456123);
                } else {
                    this.fMiniAxes.maxX(utils._getDouble(this.fMaxXVal));
                    ((TextComponent)this.fMaxX).setText(this.fMaxXVal.getText());
                }
                this.fMiniAxes.xMajTick(utils._getDouble(this.fXTickExp));
            } else {
                this.fMiniAxes.minX(utils._getDouble(this.fMinX));
                this.fMiniAxes.maxX(utils._getDouble(this.fMaxX));
                this.fMiniAxes.xMajTick(utils._getDouble(this.fXMajTick));
            }
            if (this.fLogY.getState()) {
                d = utils._getDouble(this.fBaseY);
                if (d != -1.23456123) {
                    this.fMiniAxes.logYBase(d);
                }
                if (utils._getDouble(this.fMinYVal) <= 0.0) {
                    ((TextComponent)this.fMinYVal).setText("");
                    ((TextComponent)this.fMinYExp).setText("");
                    this.fMiniAxes.minY(-1.23456123);
                } else {
                    this.fMiniAxes.minY(utils._getDouble(this.fMinYVal));
                    ((TextComponent)this.fMinY).setText(this.fMinYVal.getText());
                }
                if (utils._getDouble(this.fMaxYVal) <= 0.0) {
                    ((TextComponent)this.fMaxYVal).setText("");
                    ((TextComponent)this.fMaxYExp).setText("");
                    this.fMiniAxes.maxY(-1.23456123);
                } else {
                    this.fMiniAxes.maxY(utils._getDouble(this.fMaxYVal));
                    ((TextComponent)this.fMaxY).setText(this.fMaxYVal.getText());
                }
                this.fMiniAxes.yMajTick(utils._getDouble(this.fYTickExp));
            } else {
                this.fMiniAxes.minY(utils._getDouble(this.fMinY));
                this.fMiniAxes.maxY(utils._getDouble(this.fMaxY));
                this.fMiniAxes.yMajTick(utils._getDouble(this.fYMajTick));
            }
        } else if (this.fPolar.getState()) {
            double d = utils._getDouble(this.fMaxX);
            this.fMiniAxes.minX(-d);
            this.fMiniAxes.maxX(d);
            this.fMiniAxes.minY(-d);
            this.fMiniAxes.maxY(d);
            this.fMiniAxes.xMajTick(utils._getDouble(this.fXMajTick));
            this.fMiniAxes.yMajTick(utils._getDouble(this.fXMajTick));
        } else {
            this.fMiniAxes.minX(utils._getDouble(this.fMinX));
            this.fMiniAxes.maxX(utils._getDouble(this.fMaxX));
            this.fMiniAxes.xMajTick(utils._getDouble(this.fXMajTick));
            this.fMiniAxes.minY(utils._getDouble(this.fMinY));
            this.fMiniAxes.maxY(utils._getDouble(this.fMaxY));
            this.fMiniAxes.yMajTick(utils._getDouble(this.fYMajTick));
        }
    }

    public void doYes() {
        if (!this.fMiniAxes.checkValid()) {
            utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_error__these_axis_settings_are_invalid"));
            return;
        }
        this.fAxes.piXTickSpacing(false);
        this.fAxes.piYTickSpacing(false);
        if (this.fPolar.getState()) {
            if (!this.fAxes.polarMode()) {
                this.fAxes.deleteSelection();
                this.fAxes.deleteOthers();
            }
            this.fAxes.polarMode(true);
            this.fAxes.logMode(false);
            this.fAxes.logX(false);
            this.fAxes.logY(false);
            this.fAxes.minX(this.fMiniAxes.minX());
            this.fAxes.maxX(this.fMiniAxes.maxX());
            this.fAxes.minY(this.fMiniAxes.minY());
            this.fAxes.maxY(this.fMiniAxes.maxY());
            String string = this.fXMajTick.getText();
            if (string.charAt(string.length() - 1) == 'P') {
                this.fAxes.xMajTick(this.fMiniAxes.xMajTick() / Math.PI);
                this.fAxes.yMajTick(this.fMiniAxes.xMajTick() / Math.PI);
                this.fAxes.piXTickSpacing(true);
                this.fAxes.piYTickSpacing(true);
            } else {
                this.fAxes.xMajTick(this.fMiniAxes.xMajTick());
                this.fAxes.yMajTick(this.fMiniAxes.yMajTick());
            }
        } else if (this.fLog.getState() && (this.fLogX.getState() || this.fLogY.getState())) {
            if (this.fAxes.polarMode()) {
                this.fAxes.deleteSelection();
                this.fAxes.deleteOthers();
            }
            this.fAxes.polarMode(false);
            this.fAxes.logMode(true);
            if (this.fLogX.getState()) {
                this.fAxes.logX(true);
                this.fAxes.logXBase(utils._getDouble(this.fBaseX));
                this.fAxes.logTickSpacing(this.fLogTick.getState());
                this.fAxes.minX(utils._getDouble(this.fMinXVal));
                this.fAxes.maxX(utils._getDouble(this.fMaxXVal));
                this.fAxes.xMajTick(utils._getDouble(this.fXTickExp));
            } else {
                this.fAxes.logX(false);
                this.fAxes.minX(this.fMiniAxes.minX());
                this.fAxes.maxX(this.fMiniAxes.maxX());
                this.fAxes.xMajTick(this.fMiniAxes.xMajTick());
            }
            if (this.fLogY.getState()) {
                this.fAxes.logY(true);
                this.fAxes.logYBase(utils._getDouble(this.fBaseY));
                this.fAxes.logTickSpacing(this.fLogTick.getState());
                this.fAxes.minY(utils._getDouble(this.fMinYVal));
                this.fAxes.maxY(utils._getDouble(this.fMaxYVal));
                this.fAxes.yMajTick(utils._getDouble(this.fYTickExp));
            } else {
                this.fAxes.logY(false);
                this.fAxes.minY(this.fMiniAxes.minY());
                this.fAxes.maxY(this.fMiniAxes.maxY());
                this.fAxes.yMajTick(this.fMiniAxes.yMajTick());
            }
        } else {
            if (this.fAxes.polarMode()) {
                this.fAxes.deleteSelection();
                this.fAxes.deleteOthers();
            }
            this.fAxes.polarMode(false);
            this.fAxes.logMode(false);
            this.fAxes.logX(false);
            this.fAxes.logY(false);
            this.fAxes.minX(this.fMiniAxes.minX());
            this.fAxes.maxX(this.fMiniAxes.maxX());
            this.fAxes.minY(this.fMiniAxes.minY());
            this.fAxes.maxY(this.fMiniAxes.maxY());
            String string = this.fXMajTick.getText();
            if (string.charAt(string.length() - 1) == 'P') {
                this.fAxes.xMajTick(this.fMiniAxes.xMajTick() / Math.PI);
                this.fAxes.piXTickSpacing(true);
            } else {
                this.fAxes.xMajTick(this.fMiniAxes.xMajTick());
            }
            string = this.fYMajTick.getText();
            if (string.charAt(string.length() - 1) == 'P') {
                this.fAxes.yMajTick(this.fMiniAxes.yMajTick() / Math.PI);
                this.fAxes.piYTickSpacing(true);
            } else {
                this.fAxes.yMajTick(this.fMiniAxes.yMajTick());
            }
        }
        this.fAxes.setUpAxes();
        this.fAxes.recalculate();
        this.fAxes.drawBackground();
        this.fAxes.repaint();
        super.doYes();
    }

    private void hideLogs() {
        this.fLogX.setVisible(false);
        this.fLogY.setVisible(false);
        this.fLogTick.setVisible(false);
        this.fRegTick.setVisible(false);
        this.fMinXVal.setVisible(false);
        this.fMinXBase.setVisible(false);
        this.fMinXExp.setVisible(false);
        this.fMaxXVal.setVisible(false);
        this.fMaxXBase.setVisible(false);
        this.fMaxXExp.setVisible(false);
        this.fMinYExp.setVisible(false);
        this.fMinYVal.setVisible(false);
        this.fMinYBase.setVisible(false);
        this.fMaxYBase.setVisible(false);
        this.fMaxYVal.setVisible(false);
        this.fMaxYExp.setVisible(false);
        this.fXTickBase.setVisible(false);
        this.fXTickVal.setVisible(false);
        this.fXTickExp.setVisible(false);
        this.fYTickBase.setVisible(false);
        this.fYTickExp.setVisible(false);
        this.fYTickExp.setVisible(false);
        this.fLogX.setState(false);
        this.fLogY.setState(false);
        this.fMiniAxes.logX(false);
        this.fMiniAxes.logY(false);
        this.fBaseX.setVisible(false);
        this.fBaseY.setVisible(false);
        this.fBaseXLabel.setVisible(false);
        this.fBaseYLabel.setVisible(false);
    }

    private void setYBase(double d) {
        String string = utils.num2str(d);
        ((TextComponent)this.fBaseY).setText(string);
        this.fMinYBase.setText(string);
        this.fMaxYBase.setText(string);
        this.fYTickBase.setText(string);
    }

    private void setXBase(double d) {
        String string = utils.num2str(d);
        ((TextComponent)this.fBaseX).setText(string);
        this.fMinXBase.setText(string);
        this.fMaxXBase.setText(string);
        this.fXTickBase.setText(string);
    }

    private void doLogX() {
        boolean bl = this.fLogX.getState();
        if (bl) {
            double d = utils._getDouble(this.fMinX);
            double d2 = utils._getDouble(this.fBaseX);
            if (d2 != -1.23456123) {
                if (d > 0.0) {
                    ((TextComponent)this.fMinXExp).setText(utils.num2str(utils.getPower(d, d2)));
                    ((TextComponent)this.fMinXVal).setText(utils.num2str(d));
                    ((TextComponent)this.fMinX).setText(this.fMinXVal.getText());
                } else {
                    ((TextComponent)this.fMinXExp).setText("");
                    ((TextComponent)this.fMinXVal).setText("");
                }
                d = utils._getDouble(this.fMaxX);
                if (d > 0.0) {
                    ((TextComponent)this.fMaxXExp).setText(utils.num2str(utils.getPower(d, d2)));
                    ((TextComponent)this.fMaxXVal).setText(utils.num2str(d));
                    ((TextComponent)this.fMaxX).setText(this.fMaxXVal.getText());
                } else {
                    ((TextComponent)this.fMaxXExp).setText("");
                    ((TextComponent)this.fMaxXVal).setText("");
                }
                if (this.fRegTick.getState()) {
                    d = utils._getDouble(this.fXMajTick);
                    if (d > 0.0) {
                        ((TextComponent)this.fXTickExp).setText(utils.num2str(utils.getPower(d, d2)));
                        ((TextComponent)this.fXTickVal).setText(utils.num2str(d));
                        ((TextComponent)this.fXMajTick).setText(this.fXTickVal.getText());
                    } else {
                        ((TextComponent)this.fXTickExp).setText("");
                        ((TextComponent)this.fXTickVal).setText("");
                    }
                }
            }
        }
        this.fMiniAxes.logX(bl);
    }

    private void doLogY() {
        boolean bl = this.fLogY.getState();
        if (bl) {
            double d = utils._getDouble(this.fMinY);
            double d2 = utils._getDouble(this.fBaseY);
            if (d2 != -1.23456123) {
                if (d > 0.0) {
                    ((TextComponent)this.fMinYExp).setText(utils.num2str(utils.getPower(d, d2)));
                    ((TextComponent)this.fMinYVal).setText(utils.num2str(d));
                    ((TextComponent)this.fMinY).setText(this.fMinYVal.getText());
                } else {
                    ((TextComponent)this.fMinYExp).setText("");
                    ((TextComponent)this.fMinYVal).setText("");
                }
                d = utils._getDouble(this.fMaxY);
                if (d > 0.0) {
                    ((TextComponent)this.fMaxYExp).setText(utils.num2str(utils.getPower(d, d2)));
                    ((TextComponent)this.fMaxYVal).setText(utils.num2str(d));
                    ((TextComponent)this.fMaxY).setText(this.fMaxYVal.getText());
                } else {
                    ((TextComponent)this.fMaxYExp).setText("");
                    ((TextComponent)this.fMaxYVal).setText("");
                }
                if (this.fRegTick.getState()) {
                    d = utils._getDouble(this.fYMajTick);
                    if (d > 0.0) {
                        ((TextComponent)this.fYTickExp).setText(utils.num2str(utils.getPower(d, d2)));
                        ((TextComponent)this.fYTickVal).setText(utils.num2str(d));
                        ((TextComponent)this.fYMajTick).setText(this.fYTickVal.getText());
                    } else {
                        ((TextComponent)this.fYTickExp).setText("");
                        ((TextComponent)this.fYTickVal).setText("");
                    }
                }
            }
        }
        this.fMiniAxes.logY(bl);
    }

    void checkboxClicked(Checkbox checkbox) {
        if (checkbox == this.fPolar) {
            this.hideLogs();
            this.showPolar();
            this.setMiniAxesValuesForPolar();
            this.repaint();
        } else if (checkbox == this.fCartesian) {
            this.hideLogs();
            this.fMiniAxes.polarMode(false);
            this.showRegFields();
            this.setMiniAxesVals();
            this.fMiniAxes.setUpAxes();
            this.fMiniAxes.repaint();
            this.repaint();
        } else if (checkbox == this.fLog) {
            this.fMiniAxes.polarMode(false);
            this.showLogs();
            this.showRegFields();
            this.setMiniAxesVals();
            this.fMiniAxes.setUpAxes();
            this.fMiniAxes.repaint();
            this.repaint();
        } else if (checkbox == this.fLogX) {
            this.doLogX();
            this.showLogs();
            this.setMiniAxesVals();
            this.fMiniAxes.setUpAxes();
            this.fMiniAxes.repaint();
            this.repaint();
        } else if (checkbox == this.fLogY) {
            this.doLogY();
            this.showLogs();
            this.setMiniAxesVals();
            this.fMiniAxes.setUpAxes();
            this.fMiniAxes.repaint();
            this.repaint();
        } else if (checkbox == this.fRegTick || checkbox == this.fLogTick) {
            this.doLogX();
            this.doLogY();
            this.showLogs();
            this.setMiniAxesVals();
            this.fMiniAxes.setUpAxes();
            this.fMiniAxes.repaint();
            this.repaint();
        }
    }

    public void paintLogTicks(Graphics graphics) {
        int n = this.fLogTick.getLocation().x;
        int n2 = this.fLogTick.getLocation().y;
        graphics.drawLine(n += 20, n2 + 9, n + 100, n2 + 9);
        int n3 = 10;
        while (n3 <= 100) {
            double d = utils.log10(n3);
            int n4 = (int)((d - 1.0) * 50.0);
            if (n3 == 10 || n3 == 100) {
                graphics.drawLine(n + n4, n2 + 2, n + n4, n2 + 9);
                graphics.drawLine(n + 50 + n4, n2 + 2, n + 50 + n4, n2 + 9);
            } else {
                graphics.drawLine(n + n4, n2 + 5, n + n4, n2 + 9);
                graphics.drawLine(n + 50 + n4, n2 + 5, n + 50 + n4, n2 + 9);
            }
            n3 += 10;
        }
    }

    public void paintRegTicks(Graphics graphics) {
        int n = this.fRegTick.getLocation().x;
        int n2 = this.fRegTick.getLocation().y;
        graphics.drawLine(n += 20, (n2 += 3) + 9, n + 100, n2 + 9);
        int n3 = 0;
        while (n3 <= 100) {
            if (n3 == 0 || n3 == 50 || n3 == 100) {
                graphics.drawLine(n + n3, n2 + 2, n + n3, n2 + 9);
            } else {
                graphics.drawLine(n + n3, n2 + 5, n + n3, n2 + 9);
            }
            n3 += 5;
        }
    }

    public void paint(Graphics graphics) {
        int n = Master.gSmallTop;
        int n2 = 145;
        int n3 = 350 + n;
        graphics.setColor(Color.black);
        graphics.drawString(String.valueOf(fp_resource.getString("str_current_scale")) + ":", 15, 18 + n);
        graphics.drawLine(5, 45 + n, n2, 45 + n);
        graphics.drawString(String.valueOf(fp_resource.getString("str_planar_options")) + ":", 10, 63 + n);
        graphics.drawLine(n2, 5 + n, n2, this.getSize().height - 5 + n);
        graphics.drawLine(5, 245 + n, n2, 245 + n);
        graphics.drawLine(n2, n3, this.getSize().width - 5, n3);
        if (this.fPolar.getState()) {
            graphics.drawString(fp_resource.getString("str_max_r"), 10 + this.fMaxX.getLocation().x, this.fMaxX.getLocation().y - 4);
            graphics.drawString(String.valueOf(fp_resource.getString("str_r_grid_spacing")) + ":", 151, n3 + 30);
        } else if (this.fLog.getState()) {
            graphics.drawString(fp_resource.getString("str_on"), 50, 144 + n);
            graphics.drawString(String.valueOf(fp_resource.getString("str_tick_style")) + ":", 10, 192 + n);
            this.paintLogTicks(graphics);
            this.paintRegTicks(graphics);
            if (this.fLogX.getState()) {
                if (this.fRegTick.getState()) {
                    graphics.drawString(String.valueOf(fp_resource.getString("str_x_grid_spacing")) + ":", 151, n3 + 15);
                }
                graphics.drawString(String.valueOf(fp_resource.getString("str_min_x")) + "=", -45 + this.fMinXBase.getLocation().x, this.fMinXBase.getLocation().y + 12);
                graphics.drawString("=", -10 + this.fMinXVal.getLocation().x, this.fMinXVal.getLocation().y + 12);
                graphics.drawString(String.valueOf(fp_resource.getString("str_max_x")) + "=", -47 + this.fMaxXBase.getLocation().x, this.fMaxXBase.getLocation().y + 12);
                graphics.drawString("=", -10 + this.fMaxXVal.getLocation().x, this.fMaxXVal.getLocation().y + 12);
            } else {
                graphics.drawString(String.valueOf(fp_resource.getString("str_x_grid_spacing")) + ":", 165, n3 + 25);
                graphics.drawString(fp_resource.getString("str_min_x"), 30 + this.fMinX.getLocation().x, this.fMinX.getLocation().y - 4);
                graphics.drawString(fp_resource.getString("str_max_x"), 30 + this.fMaxX.getLocation().x, this.fMaxX.getLocation().y - 4);
            }
            if (this.fLogY.getState()) {
                if (this.fRegTick.getState()) {
                    graphics.drawString(String.valueOf(fp_resource.getString("str_y_grid_spacing")) + ":", 365, n3 + 15);
                }
                graphics.drawString(String.valueOf(fp_resource.getString("str_min_y")) + "=", this.fMinYBase.getLocation().x - 45, this.fMinYBase.getLocation().y + 12);
                graphics.drawString(String.valueOf(fp_resource.getString("str_max_y")) + "=", this.fMaxYBase.getLocation().x - 45, this.fMaxYBase.getLocation().y + 12);
                graphics.drawString("=", -10 + this.fMinYVal.getLocation().x, this.fMinYVal.getLocation().y + 12);
                graphics.drawString("=", -10 + this.fMaxYVal.getLocation().x, this.fMaxYVal.getLocation().y + 12);
            } else {
                graphics.drawString(String.valueOf(fp_resource.getString("str_y_grid_spacing")) + ":", 365, n3 + 25);
                graphics.drawString(fp_resource.getString("str_min_y"), 30 + this.fMinY.getLocation().x, this.fMinY.getLocation().y + this.fMinY.getSize().height + 11);
                graphics.drawString(fp_resource.getString("str_max_y"), 30 + this.fMaxY.getLocation().x, this.fMaxY.getLocation().y - 4);
            }
        } else {
            graphics.drawString(String.valueOf(fp_resource.getString("str_x_grid_spacing")) + ":", 165, n3 + 25);
            graphics.drawString(fp_resource.getString("str_min_x"), 30 + this.fMinX.getLocation().x, this.fMinX.getLocation().y - 4);
            graphics.drawString(fp_resource.getString("str_max_x"), 30 + this.fMaxX.getLocation().x, this.fMaxX.getLocation().y - 4);
            graphics.drawString(String.valueOf(fp_resource.getString("str_y_grid_spacing")) + ":", 365, n3 + 25);
            graphics.drawString(fp_resource.getString("str_min_y"), 30 + this.fMinY.getLocation().x, this.fMinY.getLocation().y + this.fMinY.getSize().height + 11);
            graphics.drawString(fp_resource.getString("str_max_y"), 30 + this.fMaxY.getLocation().x, this.fMaxY.getLocation().y - 4);
        }
        super.paint(graphics);
    }

    public void textValueChanged(TextEvent textEvent) {
        this.fValueChanged = true;
    }

    private void handleTextField(TextField textField) {
        double d = utils._getDouble(textField);
        double d2 = utils._getDouble(this.fBaseX);
        if (d2 != -1.23456123) {
            if (textField == this.fMinXExp) {
                ((TextComponent)this.fMinXVal).setText(utils.num2str(Math.pow(d2, d)));
            } else if (textField == this.fMinXVal) {
                ((TextComponent)this.fMinXExp).setText(utils.num2str(utils.log(d, d2)));
            } else if (textField == this.fMaxXExp) {
                ((TextComponent)this.fMaxXVal).setText(utils.num2str(Math.pow(d2, d)));
            } else if (textField == this.fMaxXVal) {
                ((TextComponent)this.fMaxXExp).setText(utils.num2str(utils.log(d, d2)));
            } else if (textField == this.fXTickExp) {
                ((TextComponent)this.fXTickVal).setText(utils.num2str(Math.pow(d2, d)));
            } else if (textField == this.fXTickVal) {
                ((TextComponent)this.fXTickExp).setText(utils.num2str(utils.log(d, d2)));
            }
        }
        if ((d2 = utils._getDouble(this.fBaseY)) != -1.23456123) {
            if (textField == this.fMinYVal) {
                ((TextComponent)this.fMinYExp).setText(utils.num2str(utils.log(d, d2)));
            } else if (textField == this.fMinYExp) {
                ((TextComponent)this.fMinYVal).setText(utils.num2str(Math.pow(d2, d)));
            } else if (textField == this.fMaxYExp) {
                ((TextComponent)this.fMaxYVal).setText(utils.num2str(Math.pow(d2, d)));
            } else if (textField == this.fMaxYVal) {
                ((TextComponent)this.fMaxYExp).setText(utils.num2str(utils.log(d, d2)));
            } else if (textField == this.fYTickExp) {
                ((TextComponent)this.fYTickVal).setText(utils.num2str(Math.pow(d2, d)));
            } else if (textField == this.fYTickVal) {
                ((TextComponent)this.fYTickExp).setText(utils.num2str(utils.log(d, d2)));
            }
        }
        if (textField == this.fBaseX) {
            if (d != -1.23456123) {
                String string = this.fBaseX.getText();
                this.fMinXBase.setText(string);
                this.fMaxXBase.setText(string);
                this.fXTickBase.setText(string);
                ((TextComponent)this.fMinXExp).setText(utils.num2str(utils.log(utils._getDouble(this.fMinXVal), d)));
                ((TextComponent)this.fMaxXExp).setText(utils.num2str(utils.log(utils._getDouble(this.fMaxXVal), d)));
                ((TextComponent)this.fXTickExp).setText(utils.num2str(utils.log(utils._getDouble(this.fXTickVal), d)));
            }
        } else if (textField == this.fBaseY && d != -1.23456123) {
            String string = this.fBaseY.getText();
            this.fMinYBase.setText(string);
            this.fMaxYBase.setText(string);
            this.fYTickBase.setText(string);
            ((TextComponent)this.fMinYExp).setText(utils.num2str(utils.log(utils._getDouble(this.fMinYVal), d)));
            ((TextComponent)this.fMaxYExp).setText(utils.num2str(utils.log(utils._getDouble(this.fMaxYVal), d)));
            ((TextComponent)this.fYTickExp).setText(utils.num2str(utils.log(utils._getDouble(this.fYTickVal), d)));
        }
        if (textField == this.fXMajTick && this.fPolar.getState()) {
            ((TextComponent)this.fYMajTick).setText(this.fXMajTick.getText());
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!(focusEvent.getComponent() instanceof TextField)) {
            return;
        }
        TextField textField = (TextField)focusEvent.getComponent();
        textField.select(0, 0);
        if (!this.fValueChanged) {
            return;
        }
        this.handleTextField(textField);
        this.setMiniAxesVals();
        this.fMiniAxes.setUpAxes();
        this.fMiniAxes.repaint();
        this.repaint();
        this.fValueChanged = false;
    }

    public void focusGained(FocusEvent focusEvent) {
        if (!(focusEvent.getComponent() instanceof TextField)) {
            return;
        }
        TextField textField = (TextField)focusEvent.getComponent();
        textField.selectAll();
    }

    public Scales loadScales() {
        try {
            FileInputStream fileInputStream = new FileInputStream(kScalesFilename);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(fileInputStream);
            ObjectInputStream objectInputStream = new ObjectInputStream(gZIPInputStream);
            Scales scales = (Scales)objectInputStream.readObject();
            objectInputStream.close();
            return scales;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setScale(int n) {
        if (n < 0 || n > this.fScales.numScales) {
            utils.showErrorDialog(this.fParent, fp_resource.getString("str_error__scale_not_valid"));
            return;
        }
        Scale scale = n == this.fScales.numScales ? this.fUntitledScale : this.fScales.getScale(n);
        if (scale.logx || scale.logy) {
            if (!this.fAxes.allowLogs()) {
                utils.showErrorDialog(this.fParent, fp_resource.getString("str_error__this_scale_requires_that_logs_be_enabled"));
                return;
            }
            this.fMiniAxes.logX(scale.logx);
            this.fMiniAxes.logY(scale.logy);
            this.fMiniAxes.logTickSpacing(scale.logtick);
            this.fMiniAxes.logXBase(scale.basex);
            this.fMiniAxes.logYBase(scale.basey);
            this.fMiniAxes.polarMode(false);
            this.fLog.setState(true);
            this.fLogX.setState(scale.logx);
            this.fLogY.setState(scale.logy);
            if (scale.logtick) {
                this.fLogTick.setState(true);
            } else {
                this.fRegTick.setState(true);
                boolean cfr_ignored_0 = scale.logx;
                boolean cfr_ignored_1 = scale.logy;
            }
            this.setXBase(scale.basex);
            this.setYBase(scale.basey);
            this.showLogs();
        } else {
            this.hideLogs();
            if (scale.polar) {
                if (!this.fAxes.allowPolars()) {
                    utils.showErrorDialog(this.fParent, fp_resource.getString("str_error__this_scale_requires_that_polar_eqns_be_enabled"));
                    return;
                }
                this.fLogX.setState(false);
                this.fLogY.setState(false);
                this.fPolar.setState(true);
                this.fMiniAxes.logX(false);
                this.fMiniAxes.logY(false);
                this.fMiniAxes.polarMode(true);
                this.showPolar();
            } else {
                this.fCartesian.setState(true);
                this.fLogX.setState(false);
                this.fLogY.setState(false);
                this.fMiniAxes.logX(false);
                this.fMiniAxes.logY(false);
                this.fMiniAxes.polarMode(false);
                this.showRegFields();
            }
        }
        ((TextComponent)this.fMinX).setText(utils.num2str(scale.minx));
        ((TextComponent)this.fMinY).setText(utils.num2str(scale.miny));
        ((TextComponent)this.fMaxX).setText(utils.num2str(scale.maxx));
        ((TextComponent)this.fMaxY).setText(utils.num2str(scale.maxy));
        ((TextComponent)this.fXMajTick).setText(utils.num2str(scale.majorxspacing));
        ((TextComponent)this.fYMajTick).setText(utils.num2str(scale.majoryspacing));
        if (scale.logx) {
            if (!scale.logtick) {
                ((TextComponent)this.fXMajTick).setText(utils.num2str(Math.pow(scale.basex, scale.majorxspacing)));
            }
            this.doLogX();
        }
        if (scale.logy) {
            if (!scale.logtick) {
                ((TextComponent)this.fYMajTick).setText(utils.num2str(Math.pow(scale.basey, scale.majoryspacing)));
            }
            this.doLogY();
        }
        this.setMiniAxesVals();
        this.fMiniAxes.setUpAxes();
        this.fMiniAxes.repaint();
        this.repaint();
    }

    public void deleteScale() {
        int n = this.fChoice.getSelectedIndex();
        this.fScales.delete(n);
        this.fChoice.remove(n);
        this.setScale(n);
        this.saveScales();
    }

    public void saveScale(String string) {
        this.fScales.addScale(this.fMiniAxes.minX(), this.fMiniAxes.maxX(), this.fMiniAxes.minY(), this.fMiniAxes.maxY(), this.fMiniAxes.xMajTick(), this.fMiniAxes.yMajTick(), this.fLogX.getState(), this.fLogY.getState(), this.fPolar.getState(), this.fLogTick.getState(), this.fMiniAxes.logXBase(), this.fMiniAxes.logYBase(), string);
        this.saveScales();
        this.fChoice.insert(string, this.fChoice.getItemCount() - 1);
        this.fChoice.select(this.fChoice.getItemCount() - 2);
    }

    public void saveScales() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(kScalesFilename);
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(fileOutputStream);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(gZIPOutputStream);
            objectOutputStream.writeObject(this.fScales);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            utils.showErrorDialog(this.fParent, String.valueOf(fp_resource.getString("str_error__in_io_during_save")) + ":" + iOException.getMessage());
            return;
        }
    }

    static /* synthetic */ boolean access$3(RescaleFrame rescaleFrame) {
        return rescaleFrame.fValueChanged;
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            RescaleFrame.this.handleTextField((TextField)actionEvent.getSource());
            RescaleFrame.this.setMiniAxesVals();
            RescaleFrame.this.fMiniAxes.setUpAxes();
            RescaleFrame.this.fMiniAxes.repaint();
            RescaleFrame.this.repaint();
            RescaleFrame.this.fValueChanged = false;
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            RescaleFrame.this.checkboxClicked((Checkbox)itemEvent.getSource());
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            int n = RescaleFrame.this.fChoice.getSelectedIndex();
            RescaleFrame.this.setScale(n);
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ScaleNameDialog scaleNameDialog = new ScaleNameDialog(RescaleFrame.this, RescaleFrame.this.fParent);
            ((Component)scaleNameDialog).setVisible(true);
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            RescaleFrame.this.doDeleteScale();
        }

        /* synthetic */ 5() {
        }
    }

    private final class 6
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            RescaleFrame.this.doNo();
        }

        /* synthetic */ 6() {
        }
    }

    private final class 7
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            RescaleFrame.this.handleMousePressed(mouseEvent);
        }

        /* synthetic */ 7() {
        }
    }
}

