/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPGrapher;

import com.questmsm.FPGrapher.FPAxes;
import com.questmsm.FPGrapher.FPEquation;
import com.questmsm.FPGrapher.FPPolarEquation;
import com.questmsm.FPGrapher.Grapher;
import com.questmsm.FPGrapher.Samplable;
import com.questmsm.FunctionProbe.Master;
import com.questmsm.Utilities.DialogField;
import com.questmsm.Utilities.DialogSuperClass;
import com.questmsm.Utilities.fp_resource;
import com.questmsm.Utilities.utils;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextField;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class SampleFrame
extends DialogSuperClass {
    private DialogField fStartX;
    private DialogField fStepSize;
    private DialogField fNumSteps;
    private FPAxes fAxes;
    private Grapher fFP;
    private Samplable fSampler;
    private Checkbox fXAxis;
    private Checkbox fYAxis;
    private Checkbox fSecants;
    private Checkbox fLength;
    private Checkbox fTable;
    private Checkbox fDivideEqual;
    private Checkbox fIterateFinal;
    private Checkbox fIterateFixed;
    private Checkbox fPlus;
    private Checkbox fMinus;
    private Checkbox fMult;
    private Checkbox fDiv;
    private Checkbox fOther;
    private DialogField fValue;
    private DialogField fRecRelation;
    private boolean fSamplePolar = false;
    private int fMode;
    private static final int kDivideEqual = 0;
    private static final int kIterateFinal = 1;
    private static final int kIterateFixed = 2;
    private int fKind = -1;
    private int leftx;

    public SampleFrame(Color color, FPAxes fPAxes, Grapher grapher, Samplable samplable, int n) {
        super(grapher);
        this.setTitle(fp_resource.getString("str_sequence_generator"));
        this.fAxes = fPAxes;
        this.fFP = grapher;
        this.fKind = n;
        this.fSampler = samplable;
        int n2 = Master.gSmallTop;
        this.setLayout(null);
        int n3 = 10;
        int n4 = 23 + n2;
        int n5 = this.fDialogMetrics.getHeight() + 2;
        int n6 = 4;
        int n7 = 200;
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        String string = fp_resource.getString("str_x_axis");
        this.fXAxis = new Checkbox(string, checkboxGroup, true);
        this.add(this.fXAxis);
        this.leftx = this.fDialogMetrics.stringWidth(string) + 30;
        this.fXAxis.setBounds(n3, n4, this.leftx, n5);
        string = fp_resource.getString("str_y_axis");
        this.fYAxis = new Checkbox(string, checkboxGroup, false);
        this.add(this.fYAxis);
        this.leftx = Math.max(this.leftx, this.fDialogMetrics.stringWidth(string) + 30);
        this.fYAxis.setBounds(n3, n4 += n5 + n6, this.leftx, n5);
        string = fp_resource.getString("str_length_along_fx");
        this.fLength = new Checkbox(string, checkboxGroup, false);
        this.add(this.fLength);
        this.leftx = Math.max(this.leftx, this.fDialogMetrics.stringWidth(string) + 30);
        this.fLength.setBounds(n3, n4 += n5 + n6, this.leftx, n5);
        string = fp_resource.getString("str_selected_table_column");
        this.fTable = new Checkbox(string, null, false);
        this.add(this.fTable);
        this.leftx = Math.max(this.leftx, this.fDialogMetrics.stringWidth(string) + 30);
        this.fTable.setBounds(n3, n4 += n5 + n6, this.leftx, n5);
        if (!Master.tableColumnValid()) {
            this.fTable.setEnabled(false);
        }
        n4 += n5 + 4;
        n7 = 220;
        checkboxGroup = new CheckboxGroup();
        string = fp_resource.getString("str_divide_into_equal_sections");
        this.fDivideEqual = new Checkbox(string, checkboxGroup, true);
        this.add(this.fDivideEqual);
        this.leftx = Math.max(this.leftx, this.fDialogMetrics.stringWidth(string) + 30);
        this.fDivideEqual.setBounds(n3, n4 += n5 + n6, this.leftx, n5);
        string = fp_resource.getString("str_iterate_to_a_final_value");
        this.fIterateFinal = new Checkbox(string, checkboxGroup, false);
        this.add(this.fIterateFinal);
        this.leftx = Math.max(this.leftx, this.fDialogMetrics.stringWidth(string) + 30);
        this.fIterateFinal.setBounds(n3, n4 += n5 + n6, this.leftx, n5);
        string = fp_resource.getString("str_iterate_to_a_fixed_number_of_times");
        this.fIterateFixed = new Checkbox(string, checkboxGroup, false);
        this.add(this.fIterateFixed);
        this.leftx = Math.max(this.leftx, this.fDialogMetrics.stringWidth(string) + 30);
        this.fIterateFixed.setBounds(n3, n4 += n5 + n6, this.leftx, n5);
        int n8 = n4 + n5 * 3 + 8;
        n3 = this.leftx + this.ch_advance;
        n4 = 15 + n2;
        n6 = 3;
        n7 = 60;
        int n9 = 0;
        this.fStartX = new DialogField("");
        this.fStartX.setBounds(n3, n4, n7, n5);
        this.add(this.fStartX);
        this.setTextFieldColors(this.fStartX);
        this.fStepSize = new DialogField("");
        this.fStepSize.setBounds(n3, n4 += n5 + n6, n7, n5);
        this.add(this.fStepSize);
        this.setTextFieldColors(this.fStepSize);
        this.fNumSteps = new DialogField("");
        this.fNumSteps.setBounds(n3, n4 += n5 + n6, n7, n5);
        this.add(this.fNumSteps);
        this.setTextFieldColors(this.fNumSteps);
        n4 += 3;
        n3 += 10;
        n7 = 110;
        checkboxGroup = new CheckboxGroup();
        string = fp_resource.getString("str_plus");
        this.fPlus = new Checkbox(string, checkboxGroup, true);
        this.add(this.fPlus);
        n9 = this.fDialogMetrics.stringWidth(string) + 30;
        this.fPlus.setBounds(n3, n4 += n5 + n6, n9, n5);
        this.fPlus.setVisible(false);
        string = fp_resource.getString("str_minus");
        this.fMinus = new Checkbox(string, checkboxGroup, false);
        this.add(this.fMinus);
        n9 = Math.max(n9, this.fDialogMetrics.stringWidth(string) + 30);
        this.fMinus.setBounds(n3, n4 += n5 + n6, n9, n5);
        this.fMinus.setVisible(false);
        string = fp_resource.getString("str_multiplied_by");
        this.fMult = new Checkbox(string, checkboxGroup, false);
        this.add(this.fMult);
        n9 = Math.max(n9, this.fDialogMetrics.stringWidth(string) + 30);
        this.fMult.setBounds(n3, n4 += n5 + n6, n9, n5);
        this.fMult.setVisible(false);
        string = fp_resource.getString("str_divided_by");
        this.fDiv = new Checkbox(string, checkboxGroup, false);
        this.add(this.fDiv);
        n9 = Math.max(n9, this.fDialogMetrics.stringWidth(string) + 30);
        this.fDiv.setBounds(n3, n4 += n5 + n6, n9, n5);
        this.fDiv.setVisible(false);
        n4 += 3;
        this.fValue = new DialogField("1.0");
        string = fp_resource.getString("str_the_value");
        this.fValue.setBounds(n3 + this.fDialogMetrics.stringWidth(string) + 4, n4 += n5 + n6, 50, n5 + 3);
        this.add(this.fValue);
        this.setTextFieldColors(this.fValue);
        this.fValue.setVisible(false);
        n4 += 3;
        string = fp_resource.getString("str_other_enter_below");
        this.fOther = new Checkbox(string, checkboxGroup, false);
        this.add(this.fOther);
        n9 = Math.max(n9, this.fDialogMetrics.stringWidth(string) + 30);
        this.fOther.setBounds(n3, n4 += n5 + n6, n9, n5);
        this.fOther.setVisible(false);
        n9 = Math.max(n9, this.fDialogMetrics.stringWidth(fp_resource.getString("str_number_of_segments")) + 110);
        n4 += 3;
        this.fRecRelation = new DialogField("");
        this.fRecRelation.setBounds(n3 + this.fDialogMetrics.stringWidth("x->") + 4, n4 += n5 + n6, n7 + 10, n5 + 3);
        this.add(this.fRecRelation);
        this.setTextFieldColors(this.fRecRelation);
        this.fRecRelation.setVisible(false);
        this.fRecRelation.setEnabled(false);
        this.fRecRelation.setEditable(false);
        Panel panel = new Panel(new FlowLayout(1, this.ch_advance, 0));
        panel.add(this.fOK);
        panel.add(this.fCancel);
        panel.setBounds(0, n8 - (n5 + 2 * n6), this.leftx, n5 + n5 + n6);
        this.add(panel);
        this.setBounds(130, 100, this.leftx + n9 + this.ch_advance, n8 + n5);
        this.mode(0);
        this.addWindowListener(new 1());
    }

    public void setToSamplePolar() {
        this.fSamplePolar = true;
        this.fXAxis.setLabel(fp_resource.getString("str_along_theta"));
        this.fYAxis.setVisible(false);
        this.fLength.setLabel(fp_resource.getString("str_along_length_of_rtheta"));
    }

    private static double getDouble(TextField textField) {
        double d;
        String string = textField.getText();
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            d = 0.0;
        }
        return d;
    }

    private void mode(int n) {
        if (n == this.fMode) {
            return;
        }
        this.fMode = n;
        switch (this.fMode) {
            case 0: {
                this.fPlus.setVisible(false);
                this.fMinus.setVisible(false);
                this.fMult.setVisible(false);
                this.fDiv.setVisible(false);
                this.fValue.setVisible(false);
                this.fOther.setVisible(false);
                this.fRecRelation.setVisible(false);
                this.fNumSteps.setVisible(true);
                break;
            }
            case 1: 
            case 2: {
                this.fPlus.setVisible(true);
                this.fMinus.setVisible(true);
                this.fMult.setVisible(true);
                this.fDiv.setVisible(true);
                this.fValue.setVisible(true);
                this.fOther.setVisible(true);
                this.fRecRelation.setVisible(true);
                this.fNumSteps.setVisible(false);
                break;
            }
        }
        this.repaint();
    }

    public boolean doCalculation() {
        double d;
        int n;
        FPEquation fPEquation = new FPEquation();
        int n2 = 0;
        if (this.fXAxis.getState()) {
            n2 = 1;
        } else if (this.fYAxis.getState()) {
            n2 = 2;
        } else if (this.fLength.getState()) {
            n2 = 3;
        }
        double d2 = SampleFrame.getDouble(this.fStartX);
        if (this.fTable.getState()) {
            double[] dArray = new double[500];
            int n3 = Master.tableColumnData(dArray);
            if (this.fSamplePolar) {
                return this.fAxes.samplePolarPoints(n3, dArray, (FPPolarEquation)this.fSampler, n2);
            }
            return this.fAxes.samplePoints(n3, dArray, this.fSampler, this.fKind, n2);
        }
        if (this.fMode == 0) {
            int n4 = (int)SampleFrame.getDouble(this.fNumSteps) + 1;
            double[] dArray = new double[n4];
            double d3 = SampleFrame.getDouble(this.fStepSize);
            double d4 = (d3 - d2) / (double)(n4 - 1);
            double d5 = d2;
            int n5 = 0;
            while (n5 < n4) {
                dArray[n5] = d5;
                d5 += d4;
                d5 = utils.round(d5, 6);
                ++n5;
            }
            if (this.fSamplePolar) {
                return this.fAxes.samplePolarPoints(n4, dArray, (FPPolarEquation)this.fSampler, n2);
            }
            return this.fAxes.samplePoints(n4, dArray, this.fSampler, this.fKind, n2);
        }
        if (this.fOther.getState()) {
            fPEquation = new FPEquation("y=" + this.fRecRelation.getText(), Color.black, this.fAxes);
        }
        double d6 = SampleFrame.getDouble(this.fValue);
        if (this.fMode == 2) {
            n = (int)SampleFrame.getDouble(this.fStepSize);
        } else {
            n = 1;
            d = d2;
            double d7 = SampleFrame.getDouble(this.fStepSize);
            int n6 = (int)(d7 * 10.0);
            while ((int)(d * 10.0) != n6) {
                d = utils.round(d, 6);
                if (++n >= 400) break;
                if (this.fPlus.getState()) {
                    d += d6;
                } else if (this.fMinus.getState()) {
                    d -= d6;
                } else if (this.fMult.getState()) {
                    d *= d6;
                } else if (this.fDiv.getState()) {
                    d /= d6;
                } else if (this.fOther.getState()) {
                    d = fPEquation.eval_(d);
                }
                if (d2 > d7) {
                    if (d == d7) break;
                    if (!(d < d7)) continue;
                    --n;
                    break;
                }
                if (d == d7) break;
                if (!(d > d7)) continue;
                --n;
                break;
            }
        }
        double[] dArray = new double[n];
        d = d2;
        int n7 = 0;
        while (n7 < n) {
            dArray[n7] = d = utils.round(d, 6);
            if (this.fPlus.getState()) {
                d += d6;
            } else if (this.fMinus.getState()) {
                d -= d6;
            } else if (this.fMult.getState()) {
                d *= d6;
            } else if (this.fDiv.getState()) {
                d /= d6;
            } else if (this.fOther.getState()) {
                d = fPEquation.eval_(d);
            }
            ++n7;
        }
        if (this.fSamplePolar) {
            return this.fAxes.samplePolarPoints(n, dArray, (FPPolarEquation)this.fSampler, n2);
        }
        return this.fAxes.samplePoints(n, dArray, this.fSampler, this.fKind, n2);
    }

    public void doYes() {
        if (!this.doCalculation()) {
            return;
        }
        ((Component)this).setVisible(false);
    }

    public boolean action(Event event, Object object) {
        if (event.target instanceof Checkbox) {
            Checkbox checkbox = (Checkbox)event.target;
            if (checkbox == this.fDivideEqual) {
                this.mode(0);
            } else if (checkbox == this.fIterateFinal) {
                this.mode(1);
            } else if (checkbox == this.fIterateFixed) {
                this.mode(2);
            } else if (checkbox == this.fPlus || checkbox == this.fMinus || checkbox == this.fMult || checkbox == this.fDiv) {
                this.fValue.setEnabled(true);
                this.fValue.setEditable(true);
                this.fRecRelation.setEditable(false);
                this.fRecRelation.setEnabled(false);
            } else if (checkbox == this.fOther) {
                this.fValue.setEnabled(false);
                this.fValue.setEditable(false);
                this.fRecRelation.setEnabled(true);
                this.fRecRelation.setEditable(true);
            } else if (checkbox == this.fTable) {
                if (this.fTable.getState()) {
                    this.fPlus.setVisible(false);
                    this.fMinus.setVisible(false);
                    this.fMult.setVisible(false);
                    this.fDiv.setVisible(false);
                    this.fValue.setVisible(false);
                    this.fOther.setVisible(false);
                    this.fRecRelation.setVisible(false);
                    this.fNumSteps.setVisible(false);
                    this.fStartX.setVisible(false);
                    this.fStepSize.setVisible(false);
                    this.fDivideEqual.setVisible(false);
                    this.fIterateFinal.setVisible(false);
                    this.fIterateFixed.setVisible(false);
                } else {
                    this.fStartX.setVisible(true);
                    this.fStepSize.setVisible(true);
                    this.fNumSteps.setVisible(true);
                    this.fDivideEqual.setVisible(true);
                    this.fIterateFinal.setVisible(true);
                    this.fIterateFixed.setVisible(true);
                    this.mode(this.fMode);
                }
                this.repaint();
                this.repaint();
            }
        }
        return super.action(event, object);
    }

    public void paint(Graphics graphics) {
        String string = "x";
        int n = Master.gSmallTop;
        int n2 = this.leftx + 15;
        int n3 = this.fDialogMetrics.getHeight();
        Dimension dimension = this.getSize();
        graphics.setColor(Color.black);
        graphics.drawString(String.valueOf(fp_resource.getString("str_create_sequence_using")) + ":", 4, 16 + n);
        Point point = this.fTable.getLocation();
        int n4 = point.y + this.fTable.getSize().height + 4;
        graphics.drawLine(4, n4, n2, n4);
        graphics.drawLine(n2, 4 + n, n2, dimension.height - 4 + n);
        point = this.fIterateFixed.getLocation();
        int n5 = point.y + this.fIterateFixed.getSize().height + 4;
        graphics.drawLine(4, n5, n2, n5);
        if (!this.fTable.getState()) {
            graphics.drawString(String.valueOf(fp_resource.getString("str_method")) + ":", 4, n4 + n3);
            point = this.fStartX.getLocation();
            n2 = point.x + this.fStartX.getSize().width + 4;
            graphics.drawString(fp_resource.getString("str_initial_value"), n2, point.y += n3 + 2);
            if (this.fMode == 2) {
                graphics.drawString(fp_resource.getString("str_number_of_steps"), n2, point.y + n3 + 2);
            }
            if (this.fMode == 1) {
                graphics.drawString(fp_resource.getString("str_final_value"), n2, point.y + n3 + 2);
            }
            if (this.fSamplePolar) {
                string = "T";
            }
            switch (this.fMode) {
                case 0: {
                    graphics.drawString(fp_resource.getString("str_final_value"), n2, point.y += n3 + 2);
                    graphics.drawString(fp_resource.getString("str_number_of_segments"), n2, point.y + n3 + 2);
                    break;
                }
                case 1: 
                case 2: {
                    Object[] objectArray = new String[]{string, string};
                    String string2 = utils.sprintf(fp_resource.getString("str_s_will_be_the_previous_s"), objectArray);
                    utils.drawStringWithReplaceTheta(graphics, string2, point.x + 10, point.y + n3 + n3 + 8, this.fDialogMetrics);
                    n2 = point.x;
                    point = this.fValue.getLocation();
                    graphics.drawString(fp_resource.getString("str_the_value"), n2 + 10, point.y + n3);
                    graphics.drawString(", " + fp_resource.getString("str_or"), point.x + this.fValue.getSize().width + 4, point.y + n3);
                    point = this.fRecRelation.getLocation();
                    utils.drawStringWithReplaceTheta(graphics, String.valueOf(string) + "->", n2 + 10, point.y + n3, this.fDialogMetrics);
                    break;
                }
            }
        }
        super.paint(graphics);
    }

    private final class 1
    extends WindowAdapter {
        public void windowActivated(WindowEvent windowEvent) {
            SampleFrame.this.fStartX.requestFocus();
        }

        public void windowClosing(WindowEvent windowEvent) {
            SampleFrame.this.doNo();
        }

        /* synthetic */ 1() {
        }
    }
}

