/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPTable;

import com.questmsm.FPTable.InsertBetweenDialog;
import com.questmsm.FPTable.Interval;
import com.questmsm.FPTable.IntervalsDialog;
import com.questmsm.FPTable.TableEquation;
import com.questmsm.FPTable.TablePanel;
import com.questmsm.FPTable.TableRPNConverter;
import com.questmsm.FPTable.TableRow;
import com.questmsm.FunctionProbe.Master;
import com.questmsm.Utilities.BadComputationException;
import com.questmsm.Utilities.FPNumberFormatException;
import com.questmsm.Utilities.fp_resource;
import com.questmsm.Utilities.utils;
import java.awt.Color;
import java.awt.Graphics;

public class Column {
    public Column next = null;
    public static final int kMaxRows = 300;
    public static final int kRowHeight = 15;
    private int fRows = 14;
    private TableRow[] fData = new TableRow[300];
    private TableRow fEquationRow;
    private TableRow fLabelRow;
    private String fEquationString;
    private char fDepVar;
    private int fWidth;
    private static int fDataTop = 45;
    private int fNumDecimalPlaces = 2;
    private boolean fScientific = false;
    private boolean fAddTrailingZeros = false;
    private int fX = 0;
    private boolean fLinked = false;
    private static TablePanel fContainer;
    private boolean fDraggingTag = false;
    private int fDraggingX = 0;
    private int fNudgeFactor = 0;
    private double fAccumStart = 0.0;
    private Interval[] fIntervals = new Interval[300];
    private int fNumIntervals = 0;
    private int fSpecialInterval = -1;
    public static int gIdentifier;
    private int fID;
    public static final int kNormal = 0;
    public static final int kDifference = 1;
    public static final int kAccumulate = 2;
    private int fWidgetMode = 0;
    public static final int kNormalEquation = 0;
    public static final int kDeltaEquation = 1;
    public static final int kRatioEquation = 2;
    public static final int kAccumEquation = 3;
    public static final int kGMeanEquation = 4;
    public static final int kAMeanEquation = 5;
    private int fEquationType = 0;
    private static final int kMaxDepCols = 10;
    private boolean fActive = true;
    private boolean fDependent = false;
    private int fNumColsDepOn = 0;
    private TableEquation fEq = null;
    private Column[] fDepCols = new Column[10];
    private boolean fSelected = false;
    private Color fBackgroundColor = Color.white;
    private Color fForegroundColor = Color.black;

    static {
        gIdentifier = 0;
    }

    public Column(TablePanel tablePanel, int n, int n2, int n3, int n4) {
        this.fRows = n;
        fContainer = tablePanel;
        this.fEquationRow = new TableRow(fContainer, "", this, -3);
        this.fLabelRow = new TableRow(fContainer, "", this, -4);
        this.fNumDecimalPlaces = n4;
        int n5 = 0;
        while (n5 < this.fRows) {
            this.fData[n5] = new TableRow(fContainer, "", this, n5);
            ++n5;
        }
        this.fWidth = n3;
        this.fActive = true;
        this.fX = n2;
        this.fID = gIdentifier++;
    }

    public void copyOptions(Column column) {
        this.fNumDecimalPlaces = column.fNumDecimalPlaces;
        this.fScientific = column.fScientific;
        this.fAddTrailingZeros = column.fAddTrailingZeros;
    }

    public static int dataTop() {
        return fDataTop;
    }

    public static void dataTop(int n) {
        fDataTop = n;
    }

    public void drawHighlight(Graphics graphics) {
        graphics.setColor(Color.blue);
        int n = 0;
        while (n < 2) {
            graphics.drawRect(this.fX + n, n, this.fWidth - 2 * n, this.bottom() - 2 * n);
            ++n;
        }
        graphics.setColor(Color.black);
        this.drawTag(graphics);
    }

    public void drawTag(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.fillRect(this.fX + this.fWidth - 3, 0, 3, 8);
    }

    public TableRow equationRow() {
        return this.fEquationRow;
    }

    public TableRow labelRow() {
        return this.fLabelRow;
    }

    public int numDecimalPlaces() {
        return this.fNumDecimalPlaces;
    }

    public void numDecimalPlaces(int n) {
        this.fNumDecimalPlaces = n;
        int n2 = 0;
        while (n2 < this.fRows) {
            if (this.fData[n2].isNum()) {
                this.fData[n2].setVal(this.fData[n2].num());
                this.fData[n2].recalculatePositions(this.fX, this.fWidth, this.fData[n2].top(), 15, n2);
            }
            ++n2;
        }
    }

    public boolean addTrailingZeros() {
        return this.fAddTrailingZeros;
    }

    public void addTrailingZeros(boolean bl) {
        this.fAddTrailingZeros = bl;
    }

    public boolean sciNotation() {
        return this.fScientific;
    }

    public void sciNotation(boolean bl) {
        this.fScientific = bl;
        int n = 0;
        while (n < this.fRows) {
            if (this.fData[n].isNum()) {
                this.fData[n].setVal(this.fData[n].num());
                this.fData[n].recalculatePositions(this.fX, this.fWidth, this.fData[n].top(), 15, n);
            }
            ++n;
        }
    }

    public int left() {
        return this.fX;
    }

    public int right() {
        return this.fX + this.fWidth;
    }

    public int width() {
        return this.fWidth;
    }

    public void left(int n) {
        this.fX = n;
    }

    public boolean draggingTag() {
        return this.fDraggingTag;
    }

    public void drawTagLine(Graphics graphics) {
        graphics.setColor(Color.red);
        graphics.drawLine(this.fDraggingX, 0, this.fDraggingX, 4000);
        graphics.setColor(Color.black);
    }

    public int rows() {
        return this.fRows;
    }

    public void rows(int n) {
        if (n > 300) {
            n = 300;
        }
        int n2 = this.fRows;
        while (n2 < n) {
            this.fData[n2] = new TableRow(fContainer, "", this, n2);
            ++n2;
        }
        this.fRows = n;
    }

    public void recalculatePositions(int n, int n2) {
        int n3 = fDataTop + this.fNudgeFactor * 15 / 2;
        this.fEquationRow.recalculateFlushCenter(this.fX, this.fWidth, 15, 15);
        this.fLabelRow.recalculateFlushCenter(this.fX, this.fWidth, 30, fDataTop - 30);
        int n4 = 0;
        while (n4 < this.fRows) {
            if (n3 < n) {
                n3 += 15;
            } else {
                if (this.fData[n4].top() > n2) break;
                this.fData[n4].recalculatePositions(this.fX, this.fWidth, n3, 15, n4);
                n3 += 15;
            }
            ++n4;
        }
    }

    public void recalculatePositions(int n, int n2, int n3) {
        int n4 = fDataTop + this.fNudgeFactor * 15 / 2 + n * 15;
        if (n4 >= n2 && n4 <= n3) {
            this.fData[n].recalculatePositions(this.fX, this.fWidth, n4, 15, n);
        }
    }

    public void setSpecialInterval(Interval interval) {
        this.fSpecialInterval = -1;
        if (interval == null) {
            return;
        }
        int n = 0;
        while (n < this.fNumIntervals) {
            if (interval.equals(this.fIntervals[n])) {
                this.fSpecialInterval = n;
                return;
            }
            ++n;
        }
    }

    public int bottom() {
        return fDataTop + this.fRows * 15;
    }

    public int top() {
        return fDataTop;
    }

    public boolean tryToMoveLeft(int n) {
        return this.row(n).tryToMoveLeft();
    }

    public boolean tryToMoveRight(int n) {
        return this.row(n).tryToMoveRight();
    }

    public void clearSelects(int n, int n2) {
        int n3;
        if (n > n2) {
            n3 = n;
            n = n2;
            n2 = n3;
        }
        if (n > this.fRows) {
            return;
        }
        if (n2 > this.fRows - 1) {
            n2 = this.fRows - 1;
        }
        n3 = n;
        while (n3 <= n2) {
            this.fData[n3].clearSelects();
            fContainer.reevaluate(n3 + this.fNudgeFactor / 2);
            ++n3;
        }
    }

    public void drawTopRows(Graphics graphics) {
        if (this.fLinked) {
            graphics.setColor(Color.gray);
            graphics.fillRect(this.fX, 0, this.fWidth, 15);
        } else {
            graphics.setColor(Color.white);
            graphics.fillRect(this.fX + 1, 1, this.fWidth - 2, 13);
        }
        this.fEquationRow.draw(graphics);
        this.fLabelRow.draw(graphics);
        graphics.setColor(Color.black);
        int n = 1;
        while (n <= 2) {
            graphics.drawLine(this.fX, n * 15, this.fX + this.fWidth, n * 15);
            ++n;
        }
        graphics.drawLine(this.fX, fDataTop - 1, this.fX + this.fWidth, fDataTop - 1);
        graphics.drawLine(this.fX, 0, this.fX, fDataTop);
        graphics.drawLine(this.fX + this.fWidth, 0, this.fX + this.fWidth, fDataTop);
        this.drawTag(graphics);
    }

    public void drawHighlightBorder(Graphics graphics, int n, int n2) {
        graphics.setColor(Color.magenta.darker());
        int n3 = 0;
        while (n3 < 2) {
            graphics.drawRect(this.fX + n3, n3, this.fWidth - 2 * n3, this.bottom() - 2 * n3);
            ++n3;
        }
        graphics.setColor(Color.black);
        graphics.drawRect(this.fX, n, this.fWidth, n2 - n);
    }

    public void drawRow(Graphics graphics, int n, int n2) {
        switch (n) {
            case -3: {
                this.fEquationRow.draw(graphics, 0);
                break;
            }
            case -4: {
                this.fLabelRow.draw(graphics, 0);
                break;
            }
            default: {
                this.fData[n].draw(graphics, n2);
            }
            case -1: 
        }
    }

    public void draw(Graphics graphics, int n, int n2) {
        graphics.setColor(this.fBackgroundColor);
        graphics.fillRect(this.fX, n, this.fWidth, n2 - n);
        int n3 = 0;
        while (n3 < this.fRows) {
            if (this.fData[n3].bottom() > n) {
                if (this.fData[n3].top() >= n2) break;
                this.fData[n3].draw(graphics);
                if (this.fWidgetMode == 1 && this.fData[n3].isNum()) {
                    this.drawDifference(graphics, n3);
                }
                if (this.fWidgetMode == 2 && this.fData[n3].isNum()) {
                    this.drawAccumulate(graphics, this.fData[n3].top());
                }
            }
            ++n3;
        }
        graphics.setColor(Color.gray);
        int n4 = 7 * this.fNudgeFactor;
        graphics.fillRect(this.fX, fDataTop, this.fWidth, n4);
        graphics.setColor(Color.black);
        graphics.drawLine(this.fX, 0, this.fX, this.bottom());
        graphics.drawLine(this.fX + this.fWidth, 0, this.fX + this.fWidth, this.bottom());
        this.drawIntervals(graphics, n, n2);
    }

    public void drawSelected(Graphics graphics, int n, int n2) {
        this.drawSelectedRows(graphics, n, n2, 0, this.fRows - 1);
    }

    public void drawSelectedRows(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n3;
        while (n5 <= n4) {
            this.fData[n5].drawSelected(graphics, n);
            if (this.fWidgetMode == 1 && this.fData[n5].allSelected() && this.fData[n5].isNum()) {
                this.drawDifference(graphics, n5);
            }
            if (this.fWidgetMode == 2 && this.fData[n5].allSelected() && this.fData[n5].isNum()) {
                this.drawAccumulate(graphics, this.fData[n5].top());
            }
            ++n5;
        }
        Color color = graphics.getColor();
        graphics.setColor(Color.darkGray);
        int n6 = this.fData[n3].top();
        if (n6 < n) {
            n6 = n;
        }
        int n7 = this.left();
        int n8 = this.fData[n4].bottom();
        if (n8 > n2) {
            n8 = n2;
        }
        int n9 = this.right();
        graphics.drawRect(n7, n6, n9 - n7, n8 - n6);
        graphics.setColor(color);
        this.drawIntervals(graphics, n, n2);
    }

    public boolean handleMouseUp(int n, int n2) {
        if (this.fDraggingTag) {
            this.fDraggingTag = false;
            this.fWidth = n - this.fX;
            return true;
        }
        return false;
    }

    public boolean inGrowTag(int n, int n2) {
        if (n < this.fX + this.fWidth - 3 || n > this.fX + this.fWidth) {
            return false;
        }
        return n2 >= 0 && n2 <= 8;
    }

    public int handleMouse(int n, int n2) {
        if (this.inGrowTag(n, n2)) {
            this.fDraggingTag = true;
            this.fDraggingX = n;
            return -2;
        }
        if (this.fEquationRow.handleMouse(n, n2)) {
            return -3;
        }
        if (this.fLabelRow.handleMouse(n, n2)) {
            return -4;
        }
        int n3 = 0;
        while (n3 < this.fRows) {
            if (this.fData[n3].handleMouse(n, n2)) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public int inWhatRow(int n, int n2) {
        int n3 = 0;
        while (n3 < this.fRows) {
            if (this.fData[n3].handleMouse(n, n2)) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public boolean handleDrag(int n, int n2) {
        if (this.fDraggingTag) {
            this.fDraggingX = n;
            return true;
        }
        if (this.fEquationRow.handleDrag(n, n2)) {
            return true;
        }
        if (this.fLabelRow.handleDrag(n, n2)) {
            return true;
        }
        int n3 = 0;
        while (n3 < this.fRows) {
            if (this.fData[n3].handleDrag(n, n2)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public void setRowVal(int n, String string) {
        this.fData[n].setVal(string);
    }

    public int getIndexAdjustedForNudge(double d) {
        double d2 = d - (double)this.fNudgeFactor / 2.0;
        if (d2 == (double)((int)d2)) {
            if (d2 < 0.0) {
                return -999;
            }
            return (int)d2;
        }
        if ((d2 = Math.ceil(d2)) < 0.0) {
            return -999;
        }
        return (int)d2;
    }

    public TableRow row(int n) {
        if (n == -3) {
            return this.fEquationRow;
        }
        if (n == -4) {
            return this.fLabelRow;
        }
        if (n >= this.fRows) {
            return null;
        }
        if (n < 0) {
            return null;
        }
        return this.fData[n];
    }

    public char depVar() {
        return this.fDepVar;
    }

    public void depVar(char c) {
        this.fDepVar = c;
    }

    public void updateVars() {
        this.fEquationString = null;
        this.fEq = null;
        this.fEquationType = 0;
        this.fWidgetMode = 0;
        if (this.fEquationRow.str() == null) {
            this.depVar('\u0000');
            this.updateDependencies();
            return;
        }
        String string = utils.stripSpaces(this.fEquationRow.str());
        this.depVar(this.getDepVar(string));
        Column column = fContainer.getColumn(this.fDepVar);
        if (column != null && column != this && this.fDepVar != '\u0000') {
            this.fEquationRow.clear();
            this.depVar('\u0000');
            this.updateDependencies();
            utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_error__variable_already_defined_for_another_column"));
            return;
        }
        switch (this.fDepVar) {
            case 'B': 
            case 'E': 
            case 'G': 
            case 'P': 
            case 'e': {
                this.fEquationRow.clear();
                this.depVar('\u0000');
                this.updateDependencies();
                utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_error__the_letters_eepb_and_g_are_reserved_and_may_not_be_used_as_variable_names"));
                return;
            }
        }
        if (this.fDepVar == '\u0000' && string.length() > 0) {
            switch (string.charAt(0)) {
                case 'D': {
                    this.fEquationType = 1;
                    this.fWidgetMode = 1;
                    return;
                }
                case '!': {
                    this.fEquationType = 2;
                    this.fWidgetMode = 1;
                    return;
                }
                case '$': {
                    this.fEquationType = 4;
                    this.fWidgetMode = 1;
                    return;
                }
                case '#': {
                    this.fEquationType = 5;
                    this.fWidgetMode = 1;
                    return;
                }
                case '%': {
                    this.fEquationType = 3;
                    this.fWidgetMode = 2;
                    return;
                }
            }
        }
        if (string.length() > 2) {
            switch (string.charAt(2)) {
                case 'D': {
                    if (string.length() != 5) break;
                    if (string.charAt(3) != '(' || string.charAt(4) != ')') {
                        this.fEquationString = null;
                        this.fEq = null;
                        this.updateDependencies();
                        return;
                    }
                    this.fEquationType = 1;
                    return;
                }
                case '%': {
                    if (string.length() == 4) {
                        this.fEquationType = 3;
                        return;
                    }
                    if (string.length() == 5) {
                        if (string.charAt(3) != '(' || string.charAt(4) != ')') {
                            this.fEquationString = null;
                            this.fEq = null;
                            this.updateDependencies();
                            return;
                        }
                        this.fEquationType = 3;
                        return;
                    }
                    utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_error_in_equation"));
                    this.fEquationString = null;
                    this.fEq = null;
                    this.updateDependencies();
                    return;
                }
                case '$': {
                    if (string.length() == 4) {
                        this.fEquationType = 4;
                        return;
                    }
                    if (string.length() == 5) {
                        if (string.charAt(3) != '(' || string.charAt(4) != ')') {
                            this.fEquationString = null;
                            this.fEq = null;
                            this.updateDependencies();
                            return;
                        }
                        this.fEquationType = 4;
                        return;
                    }
                }
                case '#': {
                    if (string.length() == 4) {
                        this.fEquationType = 5;
                        return;
                    }
                    if (string.length() == 5) {
                        if (string.charAt(3) != '(' || string.charAt(4) != ')') {
                            this.fEquationString = null;
                            this.fEq = null;
                            this.updateDependencies();
                            return;
                        }
                        this.fEquationType = 5;
                        return;
                    }
                }
                case '!': {
                    if (string.length() == 4) {
                        this.fEquationType = 2;
                        return;
                    }
                    if (string.length() != 5) break;
                    if (string.charAt(3) != '(' || string.charAt(4) != ')') {
                        this.fEquationString = null;
                        this.fEq = null;
                        this.updateDependencies();
                        return;
                    }
                    this.fEquationType = 2;
                    return;
                }
            }
            this.fEquationString = string.substring(1);
            this.fEq = new TableEquation(this.fEquationString, fContainer);
            try {
                double d = this.fEq.eval(fContainer, 0.0, true);
                if (d == -0.7654321 || d == -1.23456123) {
                    throw new BadComputationException();
                }
            }
            catch (BadComputationException badComputationException) {
                this.fEquationRow.clear();
                this.fEquationString = null;
                this.fEq = null;
                this.depVar('\u0000');
                this.updateDependencies();
                fContainer.redraw(true);
                utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_error__invalid_equation"));
                return;
            }
            try {
                this.updateDependencies();
            }
            catch (UnknownVariableException unknownVariableException) {
                this.fEquationRow.clear();
                this.fEquationString = null;
                this.fEq = null;
                this.depVar('\u0000');
                this.fNumColsDepOn = 0;
                this.fDependent = false;
            }
            return;
        }
    }

    public char getDepVar() {
        return this.getDepVar(utils.stripSpaces(this.fEquationRow.str()));
    }

    private char getDepVar(String string) {
        if (string.length() == 0) {
            return '\u0000';
        }
        if (string.length() == 1) {
            char c = string.charAt(0);
            if (Character.isLetter(c)) {
                return c;
            }
            return '\u0000';
        }
        if (string.length() == 2) {
            return '\u0000';
        }
        if (string.charAt(1) != '=') {
            return '\u0000';
        }
        return string.charAt(0);
    }

    public Column findDependentCol() {
        if (this.fEquationString == null) {
            String string = this.fEquationRow.str();
            if (string.length() == 4) {
                return fContainer.getColumn(string.charAt(3));
            }
            if (string.length() != 2) {
                return null;
            }
            return fContainer.getColumn(string.charAt(1));
        }
        return null;
    }

    public int getDepColIndices(int[] nArray) {
        int n = 0;
        while (n < this.fNumColsDepOn) {
            nArray[n] = fContainer.getColumnIndex(this.fDepCols[n]);
            ++n;
        }
        return this.fNumColsDepOn;
    }

    public void setDependencies(int n, int[] nArray) {
        this.fNumColsDepOn = n;
        int n2 = 0;
        while (n2 < n) {
            this.fDepCols[n2] = fContainer.getIndexedColumn(nArray[n2]);
            ++n2;
        }
    }

    public void reevaluate(int n) {
        double d;
        if (this.fEquationString == null) {
            return;
        }
        double d2 = (double)n - (double)this.fNudgeFactor / 2.0;
        if (d2 < 0.0) {
            return;
        }
        try {
            d = this.fEq.eval(fContainer, n);
        }
        catch (BadComputationException badComputationException) {
            this.fData[(int)d2].set(fp_resource.getString("str_undefined"));
            return;
        }
        if (d == -0.7654321) {
            this.fData[(int)d2].set(fp_resource.getString("str_error"));
            return;
        }
        if (d == -1.23456123) {
            this.fData[(int)d2].set("");
        } else if (fContainer.displayAsEquations()) {
            this.fData[(int)d2].set(d, this.fEquationString);
        } else {
            this.fData[(int)d2].set(d);
        }
    }

    public void reevaluate() {
        if (this.fEquationString == null) {
            switch (this.fEquationType) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    if (this.fDepCols[0] != null) break;
                    this.fDepCols[0] = this.findDependentCol();
                    if (this.fDepCols[0] == null) {
                        this.fNumColsDepOn = 0;
                        utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_error__trying_to_operate_on_null_column"));
                        return;
                    }
                    this.fNumColsDepOn = 1;
                }
            }
            this.fWidgetMode = 0;
            switch (this.fEquationType) {
                case 3: {
                    this.accum(this.fDepCols[0], this.fAccumStart);
                    return;
                }
                case 4: {
                    this.gMean(this.fDepCols[0]);
                    return;
                }
                case 5: {
                    this.aMean(this.fDepCols[0]);
                    return;
                }
                case 1: {
                    this.difference(this.fDepCols[0]);
                    return;
                }
                case 2: {
                    this.ratio(this.fDepCols[0]);
                    return;
                }
            }
            return;
        }
        int n = 0;
        while (n < this.fRows) {
            block21: {
                double d;
                try {
                    d = this.fEq.eval(fContainer, (double)n + (double)this.fNudgeFactor / 2.0);
                }
                catch (BadComputationException badComputationException) {
                    this.fData[n].set(fp_resource.getString("str_undefined"));
                    break block21;
                }
                if (d == -0.7654321) {
                    this.fData[n].set(fp_resource.getString("str_error"));
                } else if (d == -1.23456123) {
                    this.fData[n].set("");
                } else if (fContainer.displayAsEquations()) {
                    this.fData[n].set(d, this.equationString());
                } else {
                    this.fData[n].set(d);
                }
            }
            ++n;
        }
    }

    public void deleteRows(int n, int n2) {
        int n3;
        if (n2 < n) {
            n3 = n;
            n = n2;
            n2 = n3;
        }
        int n4 = n;
        while (n4 < this.fRows) {
            n3 = n4 + n2 - n + 1;
            if (n3 < this.fRows) {
                if (this.fData[n3].isNum()) {
                    this.fData[n4].setVal(this.fData[n3].num());
                } else {
                    this.fData[n4].setVal(this.fData[n3].str());
                }
            } else {
                this.fData[n4].setVal("");
            }
            ++n4;
        }
    }

    public void insertRows(int n, int n2) {
        int n3 = this.fRows;
        fContainer.setRows(this.fRows + n2);
        int n4 = n3 + n2 - 1;
        while (n4 > n + n2) {
            this.fData[n4].setVal(this.fData[n4 - n2]);
            --n4;
        }
    }

    public void nudgeUp() {
        --this.fNudgeFactor;
        if (this.fNudgeFactor < 0) {
            this.fNudgeFactor = 0;
        }
    }

    public void nudgeDown() {
        ++this.fNudgeFactor;
    }

    public void nudgeFactor(int n) {
        this.fNudgeFactor = n;
    }

    public int nudgeFactor() {
        return this.fNudgeFactor;
    }

    public boolean active() {
        return this.fActive;
    }

    public void active(boolean bl) {
        this.fActive = bl;
    }

    public boolean isEmpty() {
        int n = 0;
        while (n < this.fRows) {
            if (!this.row(n).isEmpty()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean hasNumericEntries() {
        int n = 0;
        while (n < this.fRows) {
            if (this.row(n).isNum()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public int columnData(double[] dArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.fRows) {
            if (this.row(n2).isNum()) {
                dArray[n] = this.row(n2).num();
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public void reoorder(int[] nArray) {
        double[] dArray = new double[this.fRows];
        String[] stringArray = new String[this.fRows];
        boolean[] blArray = new boolean[this.fRows];
        int n = 0;
        while (n < this.fRows) {
            dArray[n] = this.fData[n].num();
            stringArray[n] = this.fData[n].str();
            blArray[n] = this.fData[n].isNum();
            ++n;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.fRows) {
            n2 = nArray[n3];
            if (blArray[n2]) {
                if (fContainer.displayAsEquations()) {
                    this.fData[n3].set(dArray[n2], this.fEquationString);
                } else {
                    this.fData[n3].set(dArray[n2]);
                }
            } else {
                this.fData[n3].set(stringArray[n2]);
            }
            ++n3;
        }
    }

    public void eliminateBlanks() {
        int n = 0;
        while (n < this.fRows) {
            if (!this.fData[n].isNum() && this.fData[n].str().equals("")) {
                int n2 = n + 1;
                while (n2 < this.fRows) {
                    if (this.fData[n2].isNum()) {
                        this.fData[n].setVal(this.fData[n2].num());
                        this.fData[n2].setVal("");
                        break;
                    }
                    if (!this.fData[n2].isNum() && !this.fData[n2].str().equals("")) {
                        this.fData[n].setVal(this.fData[n2].str());
                        this.fData[n2].setVal("");
                        break;
                    }
                    ++n2;
                }
                if (n2 == this.fRows) break;
            }
            ++n;
        }
    }

    public void insertBetween(InsertBetweenDialog insertBetweenDialog, int n, int n2) {
        try {
            if (insertBetweenDialog.aMean()) {
                this.insertAMeans(insertBetweenDialog.getValue(), n, n2);
            }
            if (insertBetweenDialog.gMean()) {
                this.insertGMeans(insertBetweenDialog.getValue(), n, n2);
            }
            if (insertBetweenDialog.blanks()) {
                this.insertBlanks(insertBetweenDialog.getValue(), n, n2);
            }
            if (insertBetweenDialog.closeVal()) {
                this.insertCloseVals(n, n2, insertBetweenDialog.interval(), insertBetweenDialog.greater() || insertBetweenDialog.both(), insertBetweenDialog.less() || insertBetweenDialog.both(), insertBetweenDialog.gap(), insertBetweenDialog.gapText());
            }
        }
        catch (FPNumberFormatException fPNumberFormatException) {}
    }

    public void insertGMeans(int n, int n2, int n3) {
        double d = 0.0;
        double d2 = 0.0;
        int n4 = 0;
        int n5 = n2;
        while (n5 < n3) {
            if (this.fData[n5].isNum()) {
                n4 = n5 + 1;
                while (n4 <= n3) {
                    if (this.fData[n4].isNum()) {
                        d = this.fData[n5].num();
                        d2 = this.fData[n4].num();
                        this.insertRows(n5, n);
                        double d3 = d != 0.0 ? d2 / d : 0.0;
                        int n6 = 1;
                        while (n6 <= n) {
                            double d4 = (double)n6 / (double)(n + 1);
                            this.fData[n5 + n6].setVal(d * Math.pow(d3, d4));
                            ++n6;
                        }
                        n5 = n4 + n - 1;
                        n3 += n;
                        break;
                    }
                    if (!this.fData[n4].str().equals("")) {
                        n5 = n4 + 1;
                        break;
                    }
                    ++n4;
                }
                if (n4 > n3) break;
            }
            ++n5;
        }
    }

    public void insertAMeans(int n, int n2, int n3) {
        double d = 0.0;
        double d2 = 0.0;
        int n4 = 0;
        int n5 = n2;
        while (n5 < n3) {
            if (this.fData[n5].isNum()) {
                n4 = n5 + 1;
                while (n4 <= n3) {
                    if (this.fData[n4].isNum()) {
                        d = this.fData[n5].num();
                        d2 = this.fData[n4].num();
                        this.insertRows(n5, n);
                        int n6 = 1;
                        while (n6 <= n) {
                            this.fData[n5 + n6].setVal((d2 * (double)n6 + d * (double)(n - n6 + 1)) / (double)(n + 1));
                            ++n6;
                        }
                        n5 = n4 + n - 1;
                        n3 += n;
                        break;
                    }
                    if (!this.fData[n4].str().equals("")) {
                        n5 = n4 + 1;
                        break;
                    }
                    ++n4;
                }
                if (n4 > n3) break;
            }
            ++n5;
        }
    }

    public void insertBlanks(int n, int n2, int n3) {
        double d = 0.0;
        double d2 = 0.0;
        int n4 = 0;
        int n5 = n2;
        while (n5 < n3) {
            if (this.fData[n5].isNum()) {
                n4 = n5 + 1;
                while (n4 <= n3) {
                    if (this.fData[n4].isNum()) {
                        this.insertRows(n5, n);
                        int n6 = 1;
                        while (n6 <= n) {
                            this.fData[n5 + n6].set("");
                            ++n6;
                        }
                        n5 = n4 + n - 1;
                        n3 += n;
                        break;
                    }
                    if (!this.fData[n4].str().equals("")) {
                        n5 = n4 + 1;
                        break;
                    }
                    ++n4;
                }
                if (n4 > n3) break;
            }
            ++n5;
        }
    }

    public void insertAllBlanks(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = n2;
        while (n5 < n3) {
            n4 = n5 + 1;
            if (n4 <= n3) {
                this.insertRows(n5, n);
                int n6 = 1;
                while (n6 <= n) {
                    this.fData[n5 + n6].set("");
                    ++n6;
                }
                n5 = n4 + n - 1;
                n3 += n;
            }
            if (n4 > n3) break;
            ++n5;
        }
    }

    private void insertCloseVals(int n, int n2, double d, boolean bl, boolean bl2, boolean bl3, String string) {
        int n3 = n;
        while (n3 <= n2) {
            if (this.fData[n3].isNum()) {
                double d2 = this.fData[n3].num();
                if (bl2) {
                    this.insertRows(n3 - 1, 1);
                    this.fData[n3].set(d2 - d);
                    ++n3;
                    ++n2;
                }
                if (bl) {
                    this.insertRows(n3, 1);
                    this.fData[++n3].set(d2 + d);
                    ++n2;
                }
                if (bl3) {
                    this.insertRows(n3, 1);
                    this.fData[++n3].set(string);
                    ++n2;
                }
            }
            ++n3;
        }
    }

    public void updateDependencies() {
        this.fNumColsDepOn = 0;
        this.fDependent = false;
        if (this.fEquationString == null) {
            return;
        }
        char c = this.depVar();
        String[] stringArray = new String[10];
        TableRPNConverter tableRPNConverter = new TableRPNConverter();
        int n = tableRPNConverter.getIndepVars(stringArray, this.fEquationString.substring(1));
        int n2 = 0;
        while (n2 < n) {
            char c2 = stringArray[n2].charAt(0);
            if (c2 == c) {
                utils.showErrorDialog(fContainer.parent(), fp_resource.getString("str_error__circular_definition"));
                return;
            }
            Column column = fContainer.getColumn(c2);
            if (column == null) {
                utils.showErrorDialog(fContainer.parent(), fp_resource.getString("str_error__undefined_variable"));
                throw new UnknownVariableException();
            }
            this.fDepCols[this.fNumColsDepOn] = column;
            ++this.fNumColsDepOn;
            this.fDependent = true;
            ++n2;
        }
    }

    public int getDependencies(Column[] columnArray) {
        int n = 0;
        while (n < this.fNumColsDepOn) {
            columnArray[n] = this.fDepCols[n];
            ++n;
        }
        return this.fNumColsDepOn;
    }

    public void sort(boolean bl, int n, Column[] columnArray) {
        if (this.fNumIntervals < 2) {
            this.sort(bl, 0, this.fRows - 1, n, columnArray);
        } else {
            boolean bl2 = false;
            int n2 = 0;
            while (n2 < this.fNumIntervals) {
                if (this.fIntervals[n2].select()) {
                    bl2 = true;
                    this.sort(bl, this.fIntervals[n2].start() + 1, this.fIntervals[n2].stop(), n, columnArray);
                }
                ++n2;
            }
            if (!bl2) {
                this.sort(bl, 0, this.fRows - 1, n, columnArray);
            }
        }
    }

    public void sort(boolean bl, int n, int n2, int n3, Column[] columnArray) {
        int n4;
        int n5;
        int n6;
        double[] dArray = new double[this.fRows];
        int n7 = 0;
        String[] stringArray = new String[this.fRows];
        int n8 = 0;
        int[] nArray = new int[this.fRows];
        int[] nArray2 = new int[this.fRows];
        int[] nArray3 = new int[this.fRows];
        int[] nArray4 = new int[this.fRows];
        int[] nArray5 = new int[this.fRows];
        int n9 = 0;
        int[] nArray6 = new int[this.fRows];
        if (n2 == 300) {
            n2 = this.fRows - 1;
        }
        if (n == 1) {
            n = 0;
        }
        int n10 = n;
        while (n10 <= n2) {
            if (this.fData[n10].isNum()) {
                dArray[n7] = this.fData[n10].num();
                nArray[n7] = n10;
                ++n7;
            } else {
                String string = this.fData[n10].str();
                if (!string.equals("")) {
                    stringArray[n8] = string;
                    nArray2[n8] = n10;
                    ++n8;
                } else {
                    nArray6[n9] = n10;
                    ++n9;
                }
            }
            ++n10;
        }
        int n11 = 0;
        while (n11 < n8) {
            String string = stringArray[n11];
            n6 = n11;
            n5 = n11 + 1;
            while (n5 < n8) {
                if (bl) {
                    if (stringArray[n5].compareTo(string) > 0) {
                        string = stringArray[n5];
                        n6 = n5;
                    }
                } else if (stringArray[n5].compareTo(string) < 0) {
                    string = stringArray[n5];
                    n6 = n5;
                }
                ++n5;
            }
            nArray4[n11] = nArray2[n6];
            if (n6 != n11) {
                stringArray[n6] = stringArray[n11];
                stringArray[n11] = string;
                nArray2[n6] = nArray2[n11];
            }
            ++n11;
        }
        n5 = 0;
        while (n5 < n7) {
            double d = dArray[n5];
            n6 = n5;
            n4 = n5 + 1;
            while (n4 < n7) {
                if (bl) {
                    if (dArray[n4] > d) {
                        d = dArray[n4];
                        n6 = n4;
                    }
                } else if (dArray[n4] < d) {
                    d = dArray[n4];
                    n6 = n4;
                }
                ++n4;
            }
            nArray3[n5] = nArray[n6];
            if (n6 != n5) {
                dArray[n6] = dArray[n5];
                dArray[n5] = d;
                nArray[n6] = nArray[n5];
            }
            ++n5;
        }
        n4 = 0;
        while (n4 < this.fRows) {
            nArray5[n4] = n4;
            ++n4;
        }
        int n12 = 0;
        while (n12 < n8) {
            this.fData[n12 + n].setVal(stringArray[n12]);
            nArray5[n12 + n] = nArray4[n12];
            ++n12;
        }
        int n13 = n8;
        while (n13 < n8 + n7) {
            this.fData[n13 + n].setVal(dArray[n13 - n8]);
            nArray5[n13 + n] = nArray3[n13 - n8];
            ++n13;
        }
        int n14 = n8 + n7;
        while (n14 < n8 + n7 + n9) {
            this.fData[n14 + n].setVal("");
            nArray5[n14 + n] = nArray6[n14 - n8 - n7];
            ++n14;
        }
        int n15 = 0;
        while (n15 < n3) {
            if (columnArray[n15] != this) {
                columnArray[n15].reoorder(nArray5);
            }
            ++n15;
        }
    }

    public boolean hasDifference() {
        if (this.fEq == null) {
            return false;
        }
        return this.fEq.hasDifference();
    }

    public void difference(Column column) {
        char c;
        int n = (double)(this.fNudgeFactor - column.fNudgeFactor) / 2.0 == (double)((int)((double)(this.fNudgeFactor - column.fNudgeFactor) / 2.0)) ? (int)((double)(this.fNudgeFactor - column.fNudgeFactor) / 2.0) : (int)((double)(this.fNudgeFactor - column.fNudgeFactor - 1) / 2.0);
        int n2 = 0;
        while (n2 < this.fRows - 1) {
            int n3 = n2 + n;
            if (n3 >= 0 && n2 < this.fRows) {
                if (column.row(n3).isNum()) {
                    int n4 = n2 + 1;
                    while (n4 < this.fRows) {
                        int n5 = n4 + n;
                        if (n5 >= 0 && n5 < this.fRows) {
                            if (column.row(n5).isNum()) {
                                double d = column.row(n3).num();
                                double d2 = column.row(n5).num();
                                this.fData[n2].setVal(d2 - d);
                                break;
                            }
                            this.fData[n4].setVal("");
                        }
                        ++n4;
                    }
                    n2 = n4 - 1;
                } else {
                    this.fData[n2].setVal("");
                }
            }
            ++n2;
        }
        if ((double)(this.fNudgeFactor - column.fNudgeFactor) / 2.0 == (double)((int)((double)(this.fNudgeFactor - column.fNudgeFactor) / 2.0))) {
            this.widgetMode(0);
        } else {
            this.widgetMode(1);
        }
        this.fNumColsDepOn = 1;
        this.fDepCols[0] = column;
        this.fDependent = true;
        String string = "";
        if (this.fDepVar != '\u0000') {
            string = String.valueOf(this.fDepVar) + "=";
        }
        if ((c = column.depVar()) == '\u0000') {
            String string2 = column.equationRow().str();
            if (string2.equals("")) {
                this.fEquationRow.set(String.valueOf(string) + String.valueOf('D') + "()");
            } else {
                this.fEquationRow.set(String.valueOf(string) + String.valueOf('D') + string2);
            }
        } else {
            this.fEquationRow.set(String.valueOf(string) + String.valueOf('D') + String.valueOf(c));
        }
        this.fEquationRow.recalculateFlushCenter(this.fX, this.fWidth, 15, 15);
        this.fEquationType = 1;
    }

    public void accum(Column column, double d) {
        char c;
        boolean bl = false;
        int n = (double)(this.fNudgeFactor - column.fNudgeFactor) / 2.0 == (double)((int)((double)(this.fNudgeFactor - column.fNudgeFactor) / 2.0)) ? (int)((double)(this.fNudgeFactor - column.fNudgeFactor) / 2.0) : (int)((double)(this.fNudgeFactor - column.fNudgeFactor - 1) / 2.0);
        double d2 = d;
        this.fAccumStart = d;
        int n2 = 0;
        while (n2 < this.fRows - 1) {
            int n3 = n2 + n;
            if (n3 >= 0 && n2 < this.fRows) {
                if (column.row(n3).isNum()) {
                    if (!bl) {
                        bl = true;
                        if (n2 > 0) {
                            this.fData[n2 - 1].setVal(d2);
                        }
                    }
                    this.fData[n2].setVal(d2 += column.row(n3).num());
                } else {
                    this.fData[n2].set("");
                }
            }
            ++n2;
        }
        if ((double)(this.fNudgeFactor - column.fNudgeFactor) / 2.0 == (double)((int)((double)(this.fNudgeFactor - column.fNudgeFactor) / 2.0))) {
            this.widgetMode(0);
        } else {
            this.widgetMode(2);
        }
        this.fNumColsDepOn = 1;
        this.fDepCols[0] = column;
        this.fDependent = true;
        String string = "";
        if (this.fDepVar != '\u0000') {
            string = String.valueOf(this.fDepVar) + "=";
        }
        if ((c = column.depVar()) == '\u0000') {
            String string2 = column.equationRow().str();
            if (string2.equals("")) {
                this.fEquationRow.set(String.valueOf(string) + String.valueOf('%') + "()");
            } else {
                this.fEquationRow.set(String.valueOf(string) + String.valueOf('%') + string2);
            }
        } else {
            this.fEquationRow.set(String.valueOf(string) + String.valueOf('%') + String.valueOf(c));
        }
        this.fEquationRow.recalculateFlushCenter(this.fX, this.fWidth, 15, 15);
        this.fEquationType = 3;
    }

    public void aMean(Column column) {
        char c;
        int n = (double)(this.fNudgeFactor - column.fNudgeFactor) / 2.0 == (double)((int)((double)(this.fNudgeFactor - column.fNudgeFactor) / 2.0)) ? (int)((double)(this.fNudgeFactor - column.fNudgeFactor) / 2.0) : (int)((double)(this.fNudgeFactor - column.fNudgeFactor - 1) / 2.0);
        int n2 = 0;
        while (n2 < this.fRows - 1) {
            int n3 = n2 + n;
            if (n3 >= 0 && n2 < this.fRows) {
                if (column.row(n3).isNum()) {
                    int n4 = n2 + 1;
                    while (n4 < this.fRows) {
                        int n5 = n4 + n;
                        if (n5 >= 0 && n5 < this.fRows) {
                            if (column.row(n5).isNum()) {
                                double d = column.row(n3).num();
                                double d2 = column.row(n5).num();
                                this.fData[n2].setVal((d2 + d) / 2.0);
                                break;
                            }
                            this.fData[n4].setVal("");
                        }
                        ++n4;
                    }
                    n2 = n4 - 1;
                } else {
                    this.fData[n2].setVal("");
                }
            }
            ++n2;
        }
        if ((double)(this.fNudgeFactor - column.fNudgeFactor) / 2.0 == (double)((int)((double)(this.fNudgeFactor - column.fNudgeFactor) / 2.0))) {
            this.widgetMode(0);
        } else {
            this.widgetMode(1);
        }
        this.fNumColsDepOn = 1;
        this.fDepCols[0] = column;
        this.fDependent = true;
        String string = "";
        if (this.fDepVar != '\u0000') {
            string = String.valueOf(this.fDepVar) + "=";
        }
        if ((c = column.depVar()) == '\u0000') {
            this.fEquationRow.set(String.valueOf(string) + String.valueOf('#') + "()");
        } else {
            this.fEquationRow.set(String.valueOf(string) + String.valueOf('#') + String.valueOf(c));
        }
        this.fEquationRow.recalculateFlushCenter(this.fX, this.fWidth, 15, 15);
        this.fEquationType = 5;
    }

    public void gMean(Column column) {
        char c;
        int n = (double)(this.fNudgeFactor - column.fNudgeFactor) / 2.0 == (double)((int)((double)(this.fNudgeFactor - column.fNudgeFactor) / 2.0)) ? (int)((double)(this.fNudgeFactor - column.fNudgeFactor) / 2.0) : (int)((double)(this.fNudgeFactor - column.fNudgeFactor - 1) / 2.0);
        int n2 = 0;
        while (n2 < this.fRows - 1) {
            int n3 = n2 + n;
            if (n3 >= 0 && n2 < this.fRows) {
                if (column.row(n3).isNum()) {
                    int n4 = n2 + 1;
                    while (n4 < this.fRows) {
                        int n5 = n4 + n;
                        if (n5 >= 0 && n5 < this.fRows) {
                            if (column.row(n5).isNum()) {
                                double d = column.row(n3).num();
                                double d2 = column.row(n5).num();
                                try {
                                    this.fData[n2].setVal(Math.sqrt(d * d2));
                                }
                                catch (ArithmeticException arithmeticException) {
                                    this.fData[n2].setVal(fp_resource.getString("str_error"));
                                }
                                break;
                            }
                            this.fData[n4].setVal("");
                        }
                        ++n4;
                    }
                    n2 = n4 - 1;
                } else {
                    this.fData[n2].setVal("");
                }
            }
            ++n2;
        }
        if ((double)(this.fNudgeFactor - column.fNudgeFactor) / 2.0 == (double)((int)((double)(this.fNudgeFactor - column.fNudgeFactor) / 2.0))) {
            this.widgetMode(0);
        } else {
            this.widgetMode(1);
        }
        this.fNumColsDepOn = 1;
        this.fDepCols[0] = column;
        this.fDependent = true;
        String string = "";
        if (this.fDepVar != '\u0000') {
            string = String.valueOf(this.fDepVar) + "=";
        }
        if ((c = column.depVar()) == '\u0000') {
            this.fEquationRow.set(String.valueOf(string) + String.valueOf('$') + "()");
        } else {
            this.fEquationRow.set(String.valueOf(string) + String.valueOf('$') + String.valueOf(c));
        }
        this.fEquationRow.recalculateFlushCenter(this.fX, this.fWidth, 15, 15);
        this.fEquationType = 4;
    }

    public void ratio(Column column) {
        char c;
        int n = (double)(this.fNudgeFactor - column.fNudgeFactor) / 2.0 == (double)((int)((double)(this.fNudgeFactor - column.fNudgeFactor) / 2.0)) ? (int)((double)(this.fNudgeFactor - column.fNudgeFactor) / 2.0) : (int)((double)(this.fNudgeFactor - column.fNudgeFactor - 1) / 2.0);
        int n2 = 0;
        while (n2 < this.fRows - 1) {
            int n3 = n2 + n;
            if (n3 >= 0 && n2 < this.fRows) {
                if (column.row(n3).isNum()) {
                    int n4 = n2 + 1;
                    while (n4 < this.fRows) {
                        int n5 = n4 + n;
                        if (n5 >= 0 && n5 < this.fRows) {
                            if (column.row(n5).isNum()) {
                                double d = column.row(n3).num();
                                double d2 = column.row(n5).num();
                                if (d != 0.0) {
                                    this.fData[n2].setVal(d2 / d);
                                    break;
                                }
                                this.fData[n2].setVal("");
                                break;
                            }
                            this.fData[n4].setVal("");
                        }
                        ++n4;
                    }
                    n2 = n4 - 1;
                } else {
                    this.fData[n2].setVal("");
                }
            }
            ++n2;
        }
        if ((double)(this.fNudgeFactor - column.fNudgeFactor) / 2.0 == (double)((int)((double)(this.fNudgeFactor - column.fNudgeFactor) / 2.0))) {
            this.widgetMode(0);
        } else {
            this.widgetMode(1);
        }
        this.fNumColsDepOn = 1;
        this.fDepCols[0] = column;
        this.fDependent = true;
        String string = "";
        if (this.fDepVar != '\u0000') {
            string = String.valueOf(this.fDepVar) + "=";
        }
        if ((c = column.depVar()) == '\u0000') {
            String string2 = column.equationRow().str();
            if (string2.equals("")) {
                this.fEquationRow.set(String.valueOf(string) + String.valueOf('!') + "()");
            } else {
                this.fEquationRow.set(String.valueOf(string) + String.valueOf('!') + string2);
            }
        } else {
            this.fEquationRow.set(String.valueOf(string) + String.valueOf('!') + String.valueOf(c));
        }
        this.fEquationRow.recalculateFlushCenter(this.fX, this.fWidth, 15, 15);
        this.fEquationType = 2;
    }

    public int inIntervalSep(int n, int n2) {
        int n3 = 0;
        if (n < this.fX) {
            return -1;
        }
        if (n > this.fX + this.fWidth) {
            return -1;
        }
        int n4 = 0;
        while (n4 < this.fNumIntervals - 1) {
            n3 = this.fData[this.fIntervals[n4].stop()].bottom();
            if (n2 >= n3 - 2 && n2 <= n3 + 2) {
                int n5 = this.fIntervals[n4].stop();
                this.deleteInterval(n5);
                return n5;
            }
            ++n4;
        }
        return -1;
    }

    public void drawIntSep(Graphics graphics, int n) {
        graphics.drawLine(this.fX + 5, n - 1, this.fX + this.fWidth - 10, n - 1);
        graphics.drawLine(this.fX + 5, n + 1, this.fX + this.fWidth - 10, n + 1);
    }

    public void deselectIntervals() {
        int n = 0;
        while (n < this.fNumIntervals) {
            this.fIntervals[n].select(false);
            ++n;
        }
    }

    public void selectAllIntervals() {
        int n = 0;
        while (n < this.fNumIntervals) {
            this.fIntervals[n].select(true);
            ++n;
        }
    }

    public void selectInterval(int n) {
        int n2 = 0;
        while (n2 < this.fNumIntervals) {
            if (this.fIntervals[n2].inInterval(n)) {
                this.fIntervals[n2].select(this.fIntervals[n2].select() ^ true);
            }
            ++n2;
        }
    }

    public void drawSelectedIntervals(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.fNumIntervals) {
            if (this.fIntervals[n4].select()) {
                n = this.fIntervals[n4].start() > 0 ? this.fData[this.fIntervals[n4].start()].bottom() : this.fData[0].top();
                if (n4 == this.fSpecialInterval) {
                    graphics.setColor(Color.black);
                } else {
                    graphics.setColor(Color.blue);
                }
                if (n - Column.fContainer.dy < fDataTop) {
                    n = fDataTop + 1 + Column.fContainer.dy;
                }
                if ((n3 = this.fIntervals[n4].stop()) == 300) {
                    n3 = this.fRows - 1;
                }
                n2 = this.fData[n3].bottom();
                graphics.fillRect(this.fX, n + 2, 7, n2 - n - 4);
            }
            ++n4;
        }
    }

    public void handleClickInInterval(int n, int n2) {
        int n3 = this.inWhatRow(n, n2);
        if (n3 < 0) {
            return;
        }
        int n4 = 0;
        while (n4 < this.fNumIntervals) {
            if (this.fIntervals[n4].inInterval(n3)) {
                this.fIntervals[n4].select(this.fIntervals[n4].select() ^ true);
                return;
            }
            ++n4;
        }
    }

    public void drawIntervals(Graphics graphics, int n, int n2) {
        graphics.setColor(Color.black);
        int n3 = 0;
        while (n3 < this.fNumIntervals - 1) {
            int n4 = this.fData[this.fIntervals[n3].stop()].bottom();
            if (n4 - 1 >= n && n4 + 1 <= n2) {
                this.drawIntSep(graphics, n4);
            }
            ++n3;
        }
    }

    public void deleteInterval(int n) {
        int n2 = 0;
        while (n2 < this.fNumIntervals - 1) {
            if (this.fIntervals[n2].stop() == n) {
                this.fIntervals[n2].stop(this.fIntervals[n2 + 1].stop());
                int n3 = n2 + 1;
                while (n3 < this.fNumIntervals - 1) {
                    this.fIntervals[n3].set(this.fIntervals[n3 + 1]);
                    ++n3;
                }
                --this.fNumIntervals;
                return;
            }
            ++n2;
        }
    }

    public void addInterval(int n) {
        if (n < 0 || n >= this.fRows - 1) {
            return;
        }
        int n2 = 0;
        while (n2 < this.fNumIntervals - 1) {
            if (n == this.fIntervals[n2].stop()) {
                return;
            }
            ++n2;
        }
        if (this.fNumIntervals == 0) {
            this.fNumIntervals = 2;
            this.fIntervals[0] = new Interval(0, n);
            this.fIntervals[1] = new Interval(n, 300);
            return;
        }
        int n3 = 0;
        while (n3 < this.fNumIntervals) {
            if (this.fIntervals[n3].inInterval(n)) {
                this.fIntervals[this.fNumIntervals] = new Interval();
                int n4 = this.fNumIntervals;
                while (n4 >= n3 + 1) {
                    this.fIntervals[n4].set(this.fIntervals[n4 - 1]);
                    --n4;
                }
                this.fIntervals[n3 + 1].start(n);
                this.fIntervals[n3].stop(n);
                ++this.fNumIntervals;
                return;
            }
            ++n3;
        }
    }

    public void deleteIntervals() {
        this.fNumIntervals = 0;
    }

    public boolean hasIntervals() {
        return this.fNumIntervals > 0;
    }

    public boolean hasIntervalAt(int n) {
        int n2 = 0;
        while (n2 < this.fNumIntervals - 1) {
            if (n == this.fIntervals[n2].stop()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void addIntervals(IntervalsDialog intervalsDialog) {
        if (intervalsDialog.fNumCells.getState()) {
            int n;
            this.fNumIntervals = 0;
            int n2 = n = (int)utils._getDouble(intervalsDialog.fCells);
            while (n2 < this.fRows) {
                this.addInterval(n2 - 1);
                n2 += n;
            }
        } else if (intervalsDialog.fNumEntries.getState()) {
            this.fNumIntervals = 0;
            int n = (int)utils._getDouble(intervalsDialog.fEntries);
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.fRows) {
                if ((this.fData[n4].isNum() || !this.fData[n4].str().equals("")) && ++n3 == n) {
                    n3 = 0;
                    this.addInterval(n4 + 1);
                }
                ++n4;
            }
        } else if (intervalsDialog.fMultiples.getState()) {
            this.fNumIntervals = 0;
            double d = utils._getDouble(intervalsDialog.fMultiple);
            double d2 = 0.0;
            int n = 0;
            while (n < this.fRows) {
                int n5;
                int n6;
                if (this.fData[n].isNum() && (d2 = this.fData[n].num()) == (double)((int)d2) && (n6 = (int)Math.ceil(Math.abs(d2 / d))) == (n5 = (int)Math.floor(Math.abs((Math.abs(d2) + 1.0) / d) - 1.0E-4))) {
                    if (intervalsDialog.fMultBefore.getState()) {
                        this.addInterval(n - 1);
                    } else {
                        this.addInterval(n);
                    }
                }
                ++n;
            }
        }
        this.setOldIntervals();
    }

    public void setIntervals(int n, Interval[] intervalArray) {
        this.fNumIntervals = n;
        int n2 = 0;
        while (n2 < n) {
            this.fIntervals[n2] = new Interval(intervalArray[n2]);
            ++n2;
        }
    }

    public void setOldIntervals() {
        fContainer.setOldIntervals(this.fNumIntervals, this.fIntervals);
    }

    public int getNumSelectedIntervals() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.fNumIntervals) {
            if (this.fIntervals[n2].select()) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public void getSelectedIntervals(Interval[] intervalArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.fNumIntervals) {
            if (this.fIntervals[n2].select()) {
                intervalArray[n] = new Interval(this.fIntervals[n2]);
                ++n;
            }
            ++n2;
        }
    }

    public int numIntervals() {
        return this.fNumIntervals;
    }

    public int intervalLoc(int n) {
        return this.fIntervals[n].stop();
    }

    public void drawDifference(Graphics graphics, int n) {
        int n2 = this.fData[n].top();
        graphics.setColor(Color.black);
        graphics.drawLine(this.fX + 3, n2 + 5, this.fX + 6, n2 + 8);
        graphics.drawLine(this.fX + 6, n2 + 8, this.fX + 3, n2 + 11);
    }

    public void drawAccumulate(Graphics graphics, int n) {
        graphics.setColor(Color.black);
        graphics.drawLine(this.fX + 2, n + 3, this.fX + 6, n + 7);
        graphics.drawLine(this.fX + 6, n + 7, this.fX + 4, n + 7);
        graphics.drawLine(this.fX + 6, n + 7, this.fX + 6, n + 5);
    }

    public boolean dependent() {
        return this.fDependent;
    }

    public void dependent(boolean bl) {
        this.fDependent = bl;
    }

    public void selected(boolean bl) {
        this.fSelected = bl;
        if (!bl) {
            this.deselectIntervals();
        }
    }

    public boolean selected() {
        return this.fSelected;
    }

    public Color backgroundColor() {
        return this.fBackgroundColor;
    }

    public void backgroundColor(Color color) {
        this.fBackgroundColor = color;
    }

    public Color foregroundColor() {
        return this.fForegroundColor;
    }

    public void foregroundColor(Color color) {
        this.fForegroundColor = color;
    }

    public String label() {
        return this.fLabelRow.str();
    }

    public String equationString() {
        return this.fEquationString;
    }

    public void widgetMode(int n) {
        this.fWidgetMode = n;
    }

    public int widgetMode() {
        return this.fWidgetMode;
    }

    public double accumStart() {
        return this.fAccumStart;
    }

    public void accumStart(double d) {
        this.fAccumStart = d;
    }

    public boolean linked() {
        return this.fLinked;
    }

    public void linked(boolean bl) {
        this.fLinked = bl;
    }

    public void equationType(int n) {
        this.fEquationType = n;
    }

    public int equationType() {
        return this.fEquationType;
    }

    public int getID() {
        return this.fID;
    }

    public void setID(int n) {
        this.fID = n;
    }

    class UnknownVariableException
    extends RuntimeException {
        UnknownVariableException() {
        }
    }
}

