/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.Utilities;

import com.questmsm.Main;
import com.questmsm.Utilities.FPNumberFormatException;
import com.questmsm.Utilities.fp_resource;
import com.questmsm.Utilities.utils;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.Toolkit;

public class DialogSuperClass
extends Dialog {
    protected static final Color kBackgroundColor = new Color(190, 190, 190);
    protected static final Color kTextFieldColor = new Color(245, 240, 240);
    protected static final Color kTextForeColor = new Color(0, 0, 0);
    protected static final Color kButtonColor = new Color(150, 150, 150);
    protected static final int kFontSize = 12;
    protected static final int kPad = 2;
    protected static final int kDefaultItemHeight = 14;
    protected static final int kDefaultSpacing = 3;
    protected Button fOK;
    protected Button fNo;
    protected Button fCancel;
    protected int ch_advance;
    protected int ch_ht;
    protected static Font kDialogFont;
    protected FontMetrics fDialogMetrics;
    Frame parent;

    public DialogSuperClass(Frame frame) {
        super(frame, true);
        this.parent = frame;
        if (kDialogFont == null) {
            kDialogFont = Main.getDesiredFont();
        }
        this.fDialogMetrics = this.getFontMetrics(kDialogFont);
        this.setLayout(null);
        this.setResizable(false);
        ((Component)this).setBackground(kBackgroundColor);
        ((Component)this).setFont(kDialogFont);
        this.fOK = new Button(fp_resource.getString("str_ok"));
        DialogSuperClass.setButtonColors(this.fOK);
        this.fNo = new Button(fp_resource.getString("str_no"));
        DialogSuperClass.setButtonColors(this.fNo);
        this.fCancel = new Button(fp_resource.getString("str_cancel"));
        DialogSuperClass.setButtonColors(this.fCancel);
        this.ch_advance = this.fDialogMetrics.getMaxAdvance();
        this.ch_ht = (int)((double)this.fDialogMetrics.getHeight() / 4.0);
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            this.dispose();
            return false;
        }
        return super.handleEvent(event);
    }

    protected void setTextFieldColors(TextField textField) {
        ((Component)textField).setBackground(kTextFieldColor);
        textField.setForeground(kTextForeColor);
    }

    public static void setButtonColors(Button button) {
        button.setBackground(kButtonColor);
    }

    protected void paintBorder(Graphics graphics, Panel panel) {
        int n = panel.getLocation().x;
        int n2 = panel.getLocation().y;
        int n3 = panel.getSize().width;
        int n4 = panel.getSize().height;
        graphics.setColor(Color.black);
        graphics.drawRect(n, n2, n3, n4);
    }

    public void doYes() {
        ((Component)this).setVisible(false);
    }

    public void doNo() {
        ((Component)this).setVisible(false);
    }

    public void doCancel() {
        ((Component)this).setVisible(false);
    }

    public boolean action(Event event, Object object) {
        if (event.target instanceof Button) {
            Button button = (Button)event.target;
            if (button == this.fOK) {
                this.doYes();
            } else if (button == this.fCancel) {
                this.doCancel();
            } else if (button == this.fNo) {
                this.doNo();
            }
        }
        return super.action(event, object);
    }

    public boolean keyDown(Event event, int n) {
        if (n == 13 || n == 10) {
            this.doYes();
            return false;
        }
        if (n == 46 && ((event.modifiers & 2) != 0 || (event.modifiers & 4) != 0 || (event.modifiers & 8) != 0)) {
            this.doNo();
            return false;
        }
        return super.keyDown(event, n);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n5 = (dimension.width - n3) / 2;
        int n6 = (dimension.height - n4) / 2;
        super.setBounds(n5, n6, n3, n4);
    }

    public void setBoundsWithoutCentering(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
    }

    public Label label(TextField textField, String string) {
        int n = textField.getLocation().x;
        int n2 = textField.getLocation().y;
        Label label = new Label(string);
        label.setFont(kDialogFont);
        this.add(label);
        int n3 = this.fDialogMetrics.stringWidth(string);
        label.setBounds(n - n3 - 5, n2 + 1, n3, 18);
        return label;
    }

    protected boolean validateField(TextField textField) {
        try {
            utils.str2num(textField.getText());
        }
        catch (FPNumberFormatException fPNumberFormatException) {
            this.reportBadNumberError(textField);
            return false;
        }
        return true;
    }

    protected void reportBadNumberError(TextField textField) {
        String string = fp_resource.getString("str_error__cant_convert_into_a_number");
        if (textField.getText().trim().length() > 0) {
            string = String.valueOf(string) + ": " + textField.getText();
        }
        utils.showErrorDialog(this.parent, string);
        textField.requestFocus();
        textField.selectAll();
    }
}

