/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPCalculator;

import com.questmsm.FPCalculator.AugmentTypeFrame;
import com.questmsm.FPCalculator.CalcButtonCanvas;
import com.questmsm.FPCalculator.CalcFileData;
import com.questmsm.FPCalculator.CalcOptionsFrame;
import com.questmsm.FPCalculator.Calculator;
import com.questmsm.FPCalculator.CallMatrixFrame;
import com.questmsm.FPCalculator.DisplayField;
import com.questmsm.FPCalculator.EditButtons;
import com.questmsm.FPCalculator.EditDisplayField;
import com.questmsm.FPCalculator.EditMatrixFrame;
import com.questmsm.FPCalculator.Evaluator;
import com.questmsm.FPCalculator.FunctionCanvas;
import com.questmsm.FPCalculator.Matrix;
import com.questmsm.FPCalculator.MatrixFileData;
import com.questmsm.FPCalculator.MatrixView;
import com.questmsm.FPCalculator.MatrixViewPanel;
import com.questmsm.FPCalculator.NewRowReduceDialog;
import com.questmsm.FPCalculator.RenameMatrixFrame;
import com.questmsm.FPCalculator.SpecialFieldPanel;
import com.questmsm.FPCalculator.SpecialTextField;
import com.questmsm.FunctionProbe.Master;
import com.questmsm.FunctionProbe.WindowMenuHandler;
import com.questmsm.Utilities.FPMenuItem;
import com.questmsm.Utilities.fp_resource;
import com.questmsm.Utilities.utils;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Calculator
extends Frame
implements ActionListener,
ItemListener,
FilenameFilter {
    private Font fMainFont;
    private MenuBar fMenuBar;
    private static CalcButtonCanvas fCalcButtons;
    private static FunctionCanvas fFunctions;
    private boolean fEditing;
    private boolean fDefiningButton = false;
    private final Color kBackground = Color.gray;
    private int fWidth;
    private int fHeight;
    private MatrixViewPanel fMatrixPanel;
    private MatrixView fMatrixCanvas;
    private SpecialFieldPanel fFieldPanel;
    private SpecialTextField fField;
    private DisplayField fDisplayField;
    private EditDisplayField fEditDisplayField;
    private EditButtons fEditButtons;
    private boolean fEditingButton = false;
    private boolean fDefiningInverse = false;
    private boolean fAllowDeterminants = false;
    private boolean fAllowSystemSolve = false;
    private Menu fCalcMenu;
    private MenuItem fInverseMenu;
    private MenuItem fRadMenu;
    private MenuItem fAddMenu;
    private MenuItem fCreateMatrixMenu;
    private MenuItem fCallMatrixMenu;
    private MenuItem fClearMatrixViewMenu;
    private MenuItem fAugmentMatrixMenu;
    private MenuItem fSolveSystemMenu;
    private MenuItem fRowOperationsMenu;
    private MenuItem fRenameMatrixMenu;
    private MenuItem fAddInverseMenu;
    private MenuItem fSelectMenu;
    private MenuItem fEditMatrixMenu;
    private MenuItem fEditMenu;
    private MenuItem fDeleteMenu;
    private MenuItem fCalcOptionsMenu;
    private MenuItem fSendToGraph;
    private MenuItem fSaveMenu;
    private MenuItem fRevertMenu;
    private MenuItem fInvertMatrixMenu;
    public CheckboxMenuItem fMatrixViewMenu;
    private boolean fMatrixMode = false;
    private boolean fAutoInverse = false;
    private static final String fFileExtension = ".clc";
    private WindowMenuHandler fWindowMenuHandler;
    private String fFileName = null;
    private String fFilePath = null;
    ActionListener editMenuActionListener = new 1();

    public Calculator() {
        this.setTitle(fp_resource.getString("str_calculator"));
        ((Component)this).setBackground(this.kBackground);
        this.setLayout(null);
        this.addNotify();
        this.validate();
        Evaluator.setParentFrame(this);
        this.fMatrixPanel = new MatrixViewPanel(this, this.kBackground);
        this.fMatrixCanvas = this.fMatrixPanel.field();
        this.fFieldPanel = new SpecialFieldPanel(this, this.kBackground);
        this.add(this.fFieldPanel);
        this.fField = this.fFieldPanel.field();
        this.fDisplayField = new DisplayField(this, this.kBackground);
        this.add(this.fDisplayField);
        this.fEditButtons = new EditButtons(this, this.fField);
        this.add(this.fEditButtons);
        this.fEditDisplayField = new EditDisplayField(this, this.fEditButtons, this.kBackground);
        this.add(this.fEditDisplayField);
        this.fEditButtons.setEditField(this.fEditDisplayField);
        fCalcButtons = new CalcButtonCanvas(this.kBackground, this, this.fDisplayField, this.fEditDisplayField, this.fField);
        this.add(fCalcButtons);
        fFunctions = new FunctionCanvas(this.kBackground, this, this.fEditDisplayField, this.fDisplayField, this.fField, fCalcButtons);
        this.add(fFunctions);
        this.fDisplayField.setVisible(true);
        this.fEditDisplayField.setVisible(false);
        this.fEditButtons.setVisible(false);
        this.addComponentListener(new 2());
        this.addWindowListener(new 3());
        this.createMenus();
        this.updateMenus();
        this.setDefaultSize();
        this.fMainFont = new Font("Helvetica", 1, 12);
        this.setFocus();
        this.fEditing = false;
    }

    public void update(Graphics graphics) {
        ((Container)this).paint(graphics);
    }

    public void setDefaultSize() {
        int n = Master.gTop;
        int n2 = 0;
        if (Master.isWindows()) {
            n2 = 3;
        }
        this.fHeight = 360;
        FontMetrics fontMetrics = this.getGraphics().getFontMetrics(this.fMenuBar.getFont());
        this.fWidth = fontMetrics.stringWidth(fp_resource.getString("str_file")) + 20 + fontMetrics.stringWidth(fp_resource.getString("str_edit")) + 20 + fontMetrics.stringWidth(fp_resource.getString("str_send")) + 20 + fontMetrics.stringWidth(fp_resource.getString("str_windows")) + 20 + fontMetrics.stringWidth(fp_resource.getString("str_calculator"));
        this.fWidth = Math.max(240, this.fWidth);
        this.fFileName = null;
        this.fFilePath = null;
        Dimension dimension = this.getToolkit().getScreenSize();
        int n3 = dimension.width / 2 + 20;
        int n4 = dimension.height / 2 - (this.fHeight + n + n2) / 2 + 60 + (Master.isWindows() ? 0 : 30);
        ((Component)this).setLocation(n3, n4);
        this.setTitle(fp_resource.getString("str_calculator"));
        ((Component)this).setSize(this.fWidth + 2 * n2, this.fHeight + n + n2);
        this.myResize(290, 210, this.fWidth + 2 * n2, this.fHeight + n + n2);
        ((Component)this.fMatrixPanel).setBounds(n3 - (this.fWidth + 2 * n2) - 60, n4 + 50, this.fWidth * 2, this.fHeight + n + n2);
    }

    public void setDefaults() {
        this.fMatrixPanel.setVisible(false);
        this.fMatrixCanvas.clear();
        this.fMatrixCanvas.createImages(480, 360);
        this.fMatrixPanel.setHScrollVal(0);
        this.fMatrixPanel.setVScrollVal(0);
        MatrixView.dx = 0;
        MatrixView.dy = 0;
        fCalcButtons.clear();
        fFunctions.clear();
        this.fField.clear();
        this.fDisplayField.clear();
        this.fEditDisplayField.clear();
        this.fEditingButton = false;
        this.definingInverse(false);
        this.allowDeterminants(false);
        this.allowSystemSolve(false);
        this.hideInverses();
        this.setMatrixMode(false, false);
        this.setDefaultSize();
    }

    private void doNew() {
        1.SureDialog sureDialog = new 1.SureDialog(this, this, fp_resource.getString("str_are_you_sure"), fp_resource.getString("str_are_you_sure__any_changes_will_be_lost"), fp_resource.getString("str_yes"), fp_resource.getString("str_cancel"), null);
        ((Component)sureDialog).setVisible(true);
    }

    public boolean autoInverse() {
        return this.fAutoInverse;
    }

    public void autoInverse(boolean bl) {
        this.fAutoInverse = bl;
        this.fMatrixPanel.allowAutoInverse(bl);
    }

    public boolean allowDeterminants() {
        return this.fAllowDeterminants;
    }

    public boolean allowSystemSolve() {
        return this.fAllowSystemSolve;
    }

    public void allowDeterminants(boolean bl) {
        this.fAllowDeterminants = bl;
    }

    public void allowSystemSolve(boolean bl) {
        if (this.fAllowSystemSolve == bl) {
            return;
        }
        int n = this.fCalcMenu.getItemCount() - 1;
        this.fAllowSystemSolve = bl;
        if (bl) {
            int n2 = n;
            while (n2 >= n - 3) {
                this.fCalcMenu.remove(n2);
                --n2;
            }
            this.fCalcMenu.add(this.fSolveSystemMenu);
            this.fCalcMenu.addSeparator();
            this.fCalcMenu.add(this.fInverseMenu);
            this.fCalcMenu.add(this.fRadMenu);
            this.fCalcMenu.add(this.fCalcOptionsMenu);
        } else {
            int n3 = n;
            while (n3 >= n - 4) {
                this.fCalcMenu.remove(n3);
                --n3;
            }
            this.fCalcMenu.addSeparator();
            this.fCalcMenu.add(this.fInverseMenu);
            this.fCalcMenu.add(this.fRadMenu);
            this.fCalcMenu.add(this.fCalcOptionsMenu);
        }
        this.fMatrixPanel.allowSystemSolve(bl);
    }

    public boolean editing() {
        return this.fEditing;
    }

    public void editing(boolean bl) {
        this.fEditing = bl;
        if (this.fEditing) {
            this.fEditDisplayField.setVisible(true);
            this.fEditButtons.setVisible(true);
            this.fDisplayField.setVisible(false);
        } else {
            this.fEditDisplayField.setVisible(false);
            this.fEditButtons.setVisible(false);
            this.fDisplayField.setVisible(true);
        }
        fCalcButtons.setButtonEnables();
    }

    public boolean editingButton() {
        return this.fEditingButton;
    }

    public void editingButton(boolean bl) {
        this.fEditingButton = bl;
    }

    public SpecialTextField specialField() {
        return this.fField;
    }

    public DisplayField displayField() {
        return this.fDisplayField;
    }

    public CalcButtonCanvas calcCanvas() {
        return fCalcButtons;
    }

    public FunctionCanvas functionCanvas() {
        return fFunctions;
    }

    public EditDisplayField editField() {
        return this.fEditDisplayField;
    }

    public MatrixViewPanel matrixFrame() {
        return this.fMatrixPanel;
    }

    public MatrixView matrixCanvas() {
        return this.fMatrixCanvas;
    }

    public boolean matrixView() {
        return this.fMatrixMode;
    }

    public void setMatrixMode(boolean bl) {
        this.setMatrixMode(bl, true);
    }

    public void setMatrixMode(boolean bl, boolean bl2) {
        if (!bl && this.fMatrixMode) {
            this.fMatrixMode = false;
            this.fMatrixViewMenu.setState(false);
            this.fMatrixPanel.fMatrixViewMenu.setState(false);
            if (bl2) {
                fCalcButtons.clearAll();
                this.fDisplayField.redraw();
                this.updateMenus();
                this.fMatrixPanel.setVisible(false);
                fFunctions.updateButtons();
                fCalcButtons.setButtonEnables();
                this.myResize();
            } else {
                fFunctions.updateButtons();
                fCalcButtons.setButtonEnables();
            }
            return;
        }
        if (bl && !this.fMatrixMode) {
            this.fMatrixViewMenu.setState(true);
            this.fMatrixPanel.fMatrixViewMenu.setState(true);
            this.fMatrixMode = bl;
            if (bl2) {
                fCalcButtons.clearAll();
                this.fDisplayField.redraw();
                this.updateMenus();
                this.fMatrixPanel.setVisible(true);
                fFunctions.updateButtons();
                fCalcButtons.setButtonEnables();
                this.myResize();
            } else {
                fFunctions.updateButtons();
                fCalcButtons.setButtonEnables();
            }
        }
    }

    public boolean matrixMode() {
        return this.fMatrixMode;
    }

    public FunctionCanvas functions() {
        return fFunctions;
    }

    public void definingInverse(boolean bl) {
        this.fDefiningInverse = bl;
    }

    public boolean definingInverse() {
        return this.fDefiningInverse;
    }

    public void definingButton(boolean bl) {
        this.fDefiningButton = bl;
        if (!bl) {
            this.definingInverse(false);
        }
        fFunctions.defineButton(bl);
    }

    public boolean definingButton() {
        return this.fDefiningButton;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        String string = (String)itemEvent.getItem();
        if (string.equals(fp_resource.getString("str_matrix_view"))) {
            this.setMatrixMode(this.fMatrixMode ^ true);
            this.fMatrixViewMenu.setState(this.fMatrixMode);
            this.fMatrixPanel.fMatrixViewMenu.setState(this.fMatrixMode);
            return;
        }
    }

    public void toggleInverses() {
        if (fFunctions.inverses()) {
            this.hideInverses();
        } else {
            this.showInverses();
        }
    }

    public void showInverses() {
        this.functionCanvas().deselectUserButton();
        fFunctions.inverses(true);
        this.fInverseMenu.setLabel(fp_resource.getString("str_hide_inverses"));
        this.fInverseMenu.setActionCommand(fp_resource.getString("str_hide_inverses"));
        fCalcButtons.setInverseButtonState(true);
        this.updateMenus();
    }

    public void hideInverses() {
        this.hideInverses(true);
    }

    public void hideInverses(boolean bl) {
        this.functionCanvas().deselectUserButton();
        fFunctions.inverses(false);
        this.fInverseMenu.setLabel(fp_resource.getString("str_show_inverses"));
        this.fInverseMenu.setActionCommand(fp_resource.getString("str_show_inverses"));
        fCalcButtons.setInverseButtonState(false);
        if (bl) {
            this.updateMenus();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(fp_resource.getString("str_save_window"))) {
            if (this.fFileName == null) {
                return;
            }
            this.save(String.valueOf(this.fFilePath) + this.fFileName + fFileExtension);
            return;
        }
        if (string.equals(fp_resource.getString("str_new"))) {
            this.doNew();
            return;
        }
        if (string.equals(fp_resource.getString("str_revert"))) {
            if (this.fFileName == null) {
                return;
            }
            this.load(String.valueOf(this.fFilePath) + this.fFileName + fFileExtension);
            return;
        }
        if (string.equals(fp_resource.getString("str_save_window_as"))) {
            this.doSave();
            return;
        }
        if (string.equals(fp_resource.getString("str_save_workspace"))) {
            Master.saveWorkspace();
            return;
        }
        if (string.equals(fp_resource.getString("str_load_workspace"))) {
            Master.loadWorkspace();
            return;
        }
        if (string.equals(fp_resource.getString("str_new_workspace"))) {
            Master.newWorkspace();
            return;
        }
        if (string.equals(fp_resource.getString("str_open"))) {
            this.doLoad();
            return;
        }
        if (string.equals(fp_resource.getString("str_close"))) {
            this.setVisible(false);
            return;
        }
        if (string.equals(fp_resource.getString("str_print_calculator"))) {
            this.fField.doPrint();
            return;
        }
        if (string.equals(fp_resource.getString("str_print_matrix_view"))) {
            this.fMatrixCanvas.doPrint();
            return;
        }
        if (string.equals(fp_resource.getString("str_value_to_table"))) {
            Master.sendValueToTable(fCalcButtons.number());
            return;
        }
        if (string.equals(fp_resource.getString("str_button_to_grapher"))) {
            int n = fFunctions.selectedButton();
            if (n == -1) {
                return;
            }
            Master.sendButtonToGraph(n);
            return;
        }
        if (string.equals(fp_resource.getString("str_copy"))) {
            if (!this.fEditing) {
                StringSelection stringSelection = new StringSelection(this.fDisplayField.displayStr());
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
            }
            return;
        }
        if (string.equals(fp_resource.getString("str_cut")) && !this.fEditing) {
            utils.showErrorDialog(this, fp_resource.getString("str_cannot_cut_the_display_try_copy"));
            return;
        }
        if (string.equals(fp_resource.getString("str_paste")) && !this.fEditing) {
            double d;
            String string2;
            Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
            try {
                string2 = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                utils.showErrorDialog(this, fp_resource.getString("str_error__cant_paste_a_nontext_clipboard"));
                return;
            }
            catch (IOException iOException) {
                utils.showErrorDialog(this, fp_resource.getString("str_error__in_io"));
                return;
            }
            try {
                d = Double.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                utils.showErrorDialog(this, fp_resource.getString("str_error__clipboard_is_not_a_number"));
                return;
            }
            this.setCalcValueTo(d);
            return;
        }
        if (string.equals(fp_resource.getString("str_clear_matrix_view"))) {
            this.fMatrixCanvas.clear();
            return;
        }
        if (string.equals(fp_resource.getString("str_show_inverses"))) {
            this.showInverses();
            return;
        }
        if (string.equals(fp_resource.getString("str_hide_inverses"))) {
            this.functionCanvas().deselectUserButton();
            fFunctions.inverses(false);
            this.fInverseMenu.setLabel(fp_resource.getString("str_show_inverses"));
            this.fInverseMenu.setActionCommand(fp_resource.getString("str_show_inverses"));
            this.updateMenus();
            return;
        }
        if (string.equals(fp_resource.getString("str_use_radians"))) {
            this.functionCanvas().deselectUserButton();
            fFunctions.radians(true);
            this.fRadMenu.setLabel(fp_resource.getString("str_use_degrees"));
            this.fRadMenu.setActionCommand(fp_resource.getString("str_use_degrees"));
            this.updateMenus();
            return;
        }
        if (string.equals(fp_resource.getString("str_use_degrees"))) {
            this.functionCanvas().deselectUserButton();
            fFunctions.radians(false);
            this.fRadMenu.setLabel(fp_resource.getString("str_use_radians"));
            this.fRadMenu.setActionCommand(fp_resource.getString("str_use_radians"));
            this.updateMenus();
            return;
        }
        if (string.equals(fp_resource.getString("str_make_button"))) {
            this.functionCanvas().deselectUserButton();
            this.definingButton(true);
            this.fField.transferToEdit();
            this.fEditDisplayField.redraw();
            this.editing(true);
            return;
        }
        if (string.equals(fp_resource.getString("str_define_inverse"))) {
            this.editingButton(true);
            this.definingButton(true);
            this.definingInverse(true);
            this.editing(true);
            return;
        }
        if (string.equals(fp_resource.getString("str_create_matrix"))) {
            this.fMatrixCanvas.newMatrix();
            return;
        }
        if (string.equals(fp_resource.getString("str_rename_matrix"))) {
            RenameMatrixFrame renameMatrixFrame = new RenameMatrixFrame(this, this.fMatrixCanvas.currentMatrix());
            ((Component)renameMatrixFrame).setVisible(true);
            return;
        }
        if (string.equals(fp_resource.getString("str_edit_matrix"))) {
            EditMatrixFrame editMatrixFrame = new EditMatrixFrame(this, this.fMatrixCanvas.currentMatrix());
            ((Component)editMatrixFrame).setVisible(true);
            return;
        }
        if (string.equals(fp_resource.getString("str_call_matrix"))) {
            CallMatrixFrame callMatrixFrame = new CallMatrixFrame(this);
            ((Component)callMatrixFrame).setVisible(true);
            return;
        }
        if (string.equals(fp_resource.getString("str_augment_matrix"))) {
            AugmentTypeFrame augmentTypeFrame = new AugmentTypeFrame(this, this.fMatrixCanvas.currentMatrix());
            ((Component)augmentTypeFrame).setVisible(true);
            return;
        }
        if (string.equals(fp_resource.getString("str_split_matrix"))) {
            this.fMatrixCanvas.splitMatrix();
            return;
        }
        if (string.equals(fp_resource.getString("str_invert_matrix"))) {
            Matrix matrix = this.fMatrixCanvas.currentMatrix().invert();
            if (matrix != null) {
                this.fMatrixCanvas.handleNewMatrix(matrix);
                this.fMatrixCanvas.redraw();
            }
            return;
        }
        if (string.equals(fp_resource.getString("str_solve_system"))) {
            Matrix matrix = this.fMatrixCanvas.currentMatrix().solve();
            this.fMatrixCanvas.handleNewMatrix(matrix);
            this.fMatrixCanvas.redraw();
            return;
        }
        if (string.equals(fp_resource.getString("str_select_button"))) {
            fFunctions.setSelectUserButtonMode();
            this.fSelectMenu.setLabel(fp_resource.getString("str_unselect_button"));
            this.fSelectMenu.setActionCommand(fp_resource.getString("str_unselect_button"));
            this.updateMenus();
            return;
        }
        if (string.equals(fp_resource.getString("str_unselect_button"))) {
            this.functionCanvas().deselectUserButton();
            this.fSelectMenu.setLabel(fp_resource.getString("str_select_button"));
            this.fSelectMenu.setActionCommand(fp_resource.getString("str_select_button"));
            this.updateMenus();
            return;
        }
        if (string.equals(fp_resource.getString("str_edit_button"))) {
            this.editingButton(true);
            this.editing(true);
            this.definingButton(true);
            this.fEditDisplayField.clearRow();
            this.fField.editButton(fFunctions.selectedButton());
            return;
        }
        if (string.equals(fp_resource.getString("str_delete_button"))) {
            fFunctions.deleteButton();
            this.myResize();
            fFunctions.repaint();
            this.fField.redraw();
            return;
        }
        if (string.equals(fp_resource.getString("str_row_operations"))) {
            NewRowReduceDialog newRowReduceDialog = new NewRowReduceDialog(this, this.fMatrixCanvas.currentMatrix());
            ((Component)newRowReduceDialog).setVisible(true);
            return;
        }
        if (string.equals(fp_resource.getString("str_calculator_options"))) {
            CalcOptionsFrame calcOptionsFrame = new CalcOptionsFrame(this);
            ((Component)calcOptionsFrame).setVisible(true);
            return;
        }
        if (string.equals(fp_resource.getString("str_clear_history"))) {
            fCalcButtons.current(0);
            this.fField.clearHistory();
            this.fField.drawBackground();
            this.fField.repaint();
            return;
        }
        if (string.equals(fp_resource.getString("str_quit_function_probe"))) {
            Master.sureToQuit();
        }
    }

    public MenuItem makeMenuItem(String string) {
        FPMenuItem fPMenuItem = new FPMenuItem(string);
        fPMenuItem.setActionCommand(string);
        fPMenuItem.addActionListener(this);
        return fPMenuItem;
    }

    public MenuItem makeMenuItem(String string, int n) {
        MenuItem menuItem = this.makeMenuItem(string);
        menuItem.setShortcut(new MenuShortcut(n));
        return menuItem;
    }

    public MenuItem makeMenuItem(String string, int n, boolean bl) {
        MenuItem menuItem = this.makeMenuItem(string, n);
        menuItem.setEnabled(bl);
        return menuItem;
    }

    private void createMenus() {
        this.fMenuBar = new MenuBar();
        this.fMenuBar.setFont(FPMenuItem.FNT);
        Menu menu = new Menu(fp_resource.getString("str_file"));
        menu.setFont(FPMenuItem.FNT);
        menu.add(this.makeMenuItem(fp_resource.getString("str_new"), 78));
        menu.add(this.makeMenuItem(fp_resource.getString("str_open"), 79));
        menu.addSeparator();
        menu.add(this.makeMenuItem(fp_resource.getString("str_close")));
        this.fSaveMenu = this.makeMenuItem(fp_resource.getString("str_save_window"), 83);
        menu.add(this.fSaveMenu);
        menu.add(this.makeMenuItem(fp_resource.getString("str_save_window_as")));
        this.fRevertMenu = this.makeMenuItem(fp_resource.getString("str_revert"));
        menu.add(this.fRevertMenu);
        menu.addSeparator();
        menu.add(this.makeMenuItem(fp_resource.getString("str_new_workspace")));
        menu.add(this.makeMenuItem(fp_resource.getString("str_load_workspace")));
        menu.add(this.makeMenuItem(fp_resource.getString("str_save_workspace")));
        menu.addSeparator();
        menu.add(this.makeMenuItem(fp_resource.getString("str_print_calculator"), 80));
        menu.addSeparator();
        menu.add(this.makeMenuItem(fp_resource.getString("str_quit_function_probe"), 81));
        this.fMenuBar.add(menu);
        menu = new Menu(fp_resource.getString("str_edit"));
        menu.setFont(FPMenuItem.FNT);
        menu.add(this.makeMenuItem(fp_resource.getString("str_cant_undo"), 90, false));
        menu.addSeparator();
        menu.add(this.makeMenuItem(fp_resource.getString("str_cut"), 88));
        menu.add(this.makeMenuItem(fp_resource.getString("str_copy"), 67));
        menu.add(this.makeMenuItem(fp_resource.getString("str_paste"), 86));
        FPMenuItem fPMenuItem = new FPMenuItem(fp_resource.getString("str_clear"), new MenuShortcut(66));
        menu.add(fPMenuItem);
        fPMenuItem.setActionCommand("str_clear");
        fPMenuItem.addActionListener(this.editMenuActionListener);
        menu.addSeparator();
        menu.add(this.makeMenuItem(fp_resource.getString("str_clear_history")));
        this.fMenuBar.add(menu);
        menu = new Menu(fp_resource.getString("str_send"));
        menu.setFont(FPMenuItem.FNT);
        menu.add(this.makeMenuItem(fp_resource.getString("str_value_to_table")));
        menu.addSeparator();
        this.fSendToGraph = this.makeMenuItem(fp_resource.getString("str_button_to_grapher"));
        menu.add(this.fSendToGraph);
        this.fMenuBar.add(menu);
        this.fWindowMenuHandler = new WindowMenuHandler(this);
        this.fMenuBar.add(this.fWindowMenuHandler.menu());
        this.fCalcMenu = new Menu(fp_resource.getString("str_calculator"));
        this.fCalcMenu.setFont(FPMenuItem.FNT);
        this.fAddMenu = this.makeMenuItem(fp_resource.getString("str_make_button"));
        this.fCalcMenu.add(this.fAddMenu);
        this.fAddInverseMenu = this.makeMenuItem(fp_resource.getString("str_define_inverse"));
        this.fCalcMenu.add(this.fAddInverseMenu);
        this.fSelectMenu = this.makeMenuItem(fp_resource.getString("str_select_button"));
        this.fCalcMenu.add(this.fSelectMenu);
        this.fEditMenu = this.makeMenuItem(fp_resource.getString("str_edit_button"));
        this.fCalcMenu.add(this.fEditMenu);
        this.fDeleteMenu = this.makeMenuItem(fp_resource.getString("str_delete_button"));
        this.fCalcMenu.add(this.fDeleteMenu);
        this.fCalcMenu.addSeparator();
        this.fMatrixViewMenu = new CheckboxMenuItem(fp_resource.getString("str_matrix_view"));
        this.fMatrixViewMenu.setFont(FPMenuItem.FNT);
        this.fMatrixViewMenu.addItemListener(this);
        this.fCalcMenu.add(this.fMatrixViewMenu);
        this.fClearMatrixViewMenu = this.makeMenuItem(fp_resource.getString("str_clear_matrix_view"));
        this.fCalcMenu.add(this.fClearMatrixViewMenu);
        this.fCreateMatrixMenu = this.makeMenuItem(fp_resource.getString("str_create_matrix"));
        this.fCalcMenu.add(this.fCreateMatrixMenu);
        this.fCallMatrixMenu = this.makeMenuItem(fp_resource.getString("str_call_matrix"));
        this.fCalcMenu.add(this.fCallMatrixMenu);
        this.fEditMatrixMenu = this.makeMenuItem(fp_resource.getString("str_edit_matrix"));
        this.fCalcMenu.add(this.fEditMatrixMenu);
        this.fRenameMatrixMenu = this.makeMenuItem(fp_resource.getString("str_rename_matrix"));
        this.fCalcMenu.add(this.fRenameMatrixMenu);
        this.fAugmentMatrixMenu = this.makeMenuItem(fp_resource.getString("str_augment_matrix"));
        this.fCalcMenu.add(this.fAugmentMatrixMenu);
        this.fInvertMatrixMenu = this.makeMenuItem(fp_resource.getString("str_invert_matrix"));
        this.fSolveSystemMenu = this.makeMenuItem(fp_resource.getString("str_solve_system"));
        this.fRowOperationsMenu = this.makeMenuItem(fp_resource.getString("str_row_operations"));
        this.fCalcMenu.add(this.fRowOperationsMenu);
        this.fCalcMenu.addSeparator();
        this.fInverseMenu = this.makeMenuItem(fp_resource.getString("str_show_inverses"), 73);
        this.fCalcMenu.add(this.fInverseMenu);
        this.fRadMenu = this.makeMenuItem(fp_resource.getString("str_use_degrees"));
        this.fCalcMenu.add(this.fRadMenu);
        this.fCalcOptionsMenu = this.makeMenuItem(fp_resource.getString("str_calculator_options"));
        this.fCalcMenu.add(this.fCalcOptionsMenu);
        this.fMenuBar.add(this.fCalcMenu);
        this.setMenuBar(this.fMenuBar);
    }

    public void updateMenus() {
        this.updateMenus(true);
    }

    public void updateMenus(boolean bl) {
        String string;
        this.fSaveMenu.setEnabled(this.fFileName != null);
        this.fRevertMenu.setEnabled(this.fFileName != null);
        this.fAddMenu.setEnabled(this.fMatrixMode ^ true);
        this.fAddInverseMenu.setEnabled(!this.fMatrixMode && fFunctions.selectedButton() != -1);
        this.fSelectMenu.setEnabled(this.fMatrixMode ^ true);
        this.fEditMenu.setEnabled(!this.fMatrixMode && fFunctions.selectedButton() != -1);
        this.fDeleteMenu.setEnabled(!this.fMatrixMode && fFunctions.selectedButton() != -1);
        this.fClearMatrixViewMenu.setEnabled(this.fMatrixMode);
        this.fCreateMatrixMenu.setEnabled(this.fMatrixMode && this.fMatrixCanvas.allowMatrix());
        this.fRenameMatrixMenu.setEnabled(this.fMatrixMode && this.fMatrixCanvas.isCurrentAMatrix());
        this.fCallMatrixMenu.setEnabled(this.fMatrixMode && this.fMatrixCanvas.allowMatrix());
        this.fAugmentMatrixMenu.setEnabled(this.fMatrixMode && this.fMatrixCanvas.isCurrentAMatrix());
        this.fEditMatrixMenu.setEnabled(this.fMatrixMode && this.fMatrixCanvas.isCurrentAMatrix());
        this.fInvertMatrixMenu.setEnabled(this.fMatrixMode && this.fMatrixCanvas.isCurrentAMatrix() && this.fMatrixCanvas.isCurrentSquare());
        if (this.fMatrixCanvas.isCurrentMatrixAugmented()) {
            string = fp_resource.getString("str_split_matrix");
            this.fAugmentMatrixMenu.setLabel(string);
            this.fAugmentMatrixMenu.setActionCommand(string);
        } else {
            string = String.valueOf(fp_resource.getString("str_augment_matrix")) + "...";
            this.fAugmentMatrixMenu.setLabel(string);
            this.fAugmentMatrixMenu.setActionCommand(string);
        }
        this.fSolveSystemMenu.setEnabled(this.fMatrixMode && this.fMatrixCanvas.isCurrentAMatrix() && this.fMatrixCanvas.system());
        this.fRowOperationsMenu.setEnabled(this.fMatrixMode && this.fMatrixCanvas.isCurrentAMatrix());
        this.fInverseMenu.setEnabled(this.fMatrixMode ^ true);
        this.fRadMenu.setEnabled(this.fMatrixMode ^ true);
        if (this.fSendToGraph != null) {
            this.fSendToGraph.setEnabled(!this.fMatrixMode && fFunctions.selectedButton() != -1);
        }
        if (fFunctions.selectedButton() == -1) {
            string = fp_resource.getString("str_select_button");
            this.fSelectMenu.setLabel(string);
            this.fSelectMenu.setActionCommand(string);
        } else {
            string = fp_resource.getString("str_unselect_button");
            this.fSelectMenu.setLabel(string);
            this.fSelectMenu.setActionCommand(string);
        }
        if (fFunctions.radians()) {
            this.fRadMenu.setLabel(fp_resource.getString("str_use_degrees"));
        } else {
            this.fRadMenu.setLabel(fp_resource.getString("str_use_radians"));
        }
        if (!fFunctions.inverses()) {
            this.fInverseMenu.setLabel(fp_resource.getString("str_show_inverses"));
        } else {
            this.fInverseMenu.setLabel(fp_resource.getString("str_hide_inverses"));
        }
        this.fMatrixPanel.updateMenus();
        this.fWindowMenuHandler.updateMenu();
        if (bl) {
            Master.forceUpdate(this);
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        WindowMenuHandler.synchHandlers();
    }

    public void setFocus() {
        fCalcButtons.requestFocus();
    }

    public boolean buttonsKeyDown(Event event, int n) {
        return fCalcButtons.keyDown(event, n);
    }

    public synchronized void myResize(int n, int n2, int n3, int n4) {
        this.fWidth = this.getSize().width;
        this.fHeight = this.getSize().height;
        int n5 = Master.gTop;
        int n6 = 0;
        if (Master.isWindows()) {
            n6 = 3;
            this.fHeight -= n6;
        }
        this.fDisplayField.setBounds(n6, n5, this.fWidth - 2 * n6, 30);
        this.fEditButtons.setBounds(n6, n5, 40, 30);
        this.fEditDisplayField.setBounds(n6 + 40 + 1, n5, this.fWidth - 40 - 2 * n6, 30);
        int n7 = 0;
        fCalcButtons.setBounds((this.fWidth - 192) / 2, 30 + n5, 240, 128);
        Point point = fFunctions.relocate(this.fWidth);
        int n8 = point.x;
        int n9 = point.y;
        n7 = (this.fWidth - n8) / 2;
        fFunctions.setBounds(n7, 158 + n5, n8, n9);
        this.fFieldPanel.setBounds(n6, 158 + n9 + n5, this.fWidth - 2 * n6, this.fHeight - 30 - 128 - n9 - n5);
        this.updateMenus();
    }

    public void myResize() {
        this.myResize(this.getLocation().x, this.getLocation().y, this.getSize().width, this.getSize().height);
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            this.setVisible(false);
            return false;
        }
        return super.handleEvent(event);
    }

    public void setCalcValueTo(double d) {
        fCalcButtons.setValueTo(d);
    }

    public boolean save(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(fileOutputStream);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(gZIPOutputStream);
            CalcFileData calcFileData = new CalcFileData(this, fCalcButtons, fFunctions, this.fField);
            MatrixFileData matrixFileData = new MatrixFileData(this.fMatrixCanvas);
            objectOutputStream.writeObject(calcFileData);
            objectOutputStream.writeObject(matrixFileData);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            utils.showErrorDialog(this, String.valueOf(fp_resource.getString("str_error__in_io_during_save")) + ": " + iOException.getMessage());
            return false;
        }
        return true;
    }

    public void doSave() {
        FileDialog fileDialog = new FileDialog((Frame)this, fp_resource.getString("str_save_calculator"), 1);
        fileDialog.setFile(String.valueOf(fp_resource.getString("str_untitled")) + fFileExtension);
        ((Component)fileDialog).setVisible(true);
        String string = fileDialog.getFile();
        String string2 = fileDialog.getDirectory();
        if (string != null) {
            if (!string.endsWith(fFileExtension)) {
                string = String.valueOf(string) + fFileExtension;
            }
            if (!this.save(String.valueOf(string2) + string)) {
                return;
            }
            this.fFileName = string.substring(0, string.length() - 4);
            this.fFilePath = string2;
            this.setTitle(this.fFileName);
        }
    }

    public void setFromFileData(CalcFileData calcFileData, MatrixFileData matrixFileData) {
        CalcFileData.setStaticVariables(this);
        calcFileData.getUserButtons(fFunctions);
        calcFileData.getSpecialTextFieldData(this.fField);
        calcFileData.setCalcSettings(this, fCalcButtons);
        matrixFileData.setMatrixData(this.fMatrixCanvas);
        this.myResize();
        this.updateMenus(false);
    }

    public void load(String string) {
        MatrixFileData matrixFileData;
        CalcFileData calcFileData;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(fileInputStream);
            ObjectInputStream objectInputStream = new ObjectInputStream(gZIPInputStream);
            calcFileData = (CalcFileData)objectInputStream.readObject();
            matrixFileData = (MatrixFileData)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (IOException iOException) {
            File file = new File(string);
            String string2 = utils.sprintf(fp_resource.getString("str_error__wrong_or_corrupt_file"), file.getName());
            utils.showErrorDialog(this, string2);
            return;
        }
        catch (Exception exception) {
            utils.showErrorDialog(this, String.valueOf(fp_resource.getString("str_error__in_io_during_load")) + ": " + exception.getMessage());
            return;
        }
        this.setVisible(false);
        this.setFromFileData(calcFileData, matrixFileData);
        Master.scanForEvaluators();
        this.setVisible(true);
    }

    public void doLoad() {
        FileDialog fileDialog = new FileDialog((Frame)this, fp_resource.getString("str_load_calculator"), 0);
        fileDialog.setFilenameFilter(this);
        ((Component)fileDialog).setVisible(true);
        String string = fileDialog.getFile();
        if (string != null) {
            if (string.endsWith(fFileExtension)) {
                this.load(String.valueOf(fileDialog.getDirectory()) + string);
                this.fFileName = string.substring(0, string.length() - 4);
                this.fFilePath = fileDialog.getDirectory();
                this.setTitle(this.fFileName);
                this.updateMenus(false);
            } else {
                Master.loadWorkspace(String.valueOf(fileDialog.getDirectory()) + string);
            }
        }
    }

    public MenuBar menuBar() {
        return this.fMenuBar;
    }

    public String filename() {
        return this.fFileName;
    }

    public boolean accept(File file, String string) {
        return string.endsWith(fFileExtension) || string.endsWith(".prb");
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("str_clear")) {
                fCalcButtons.handleInput('\u0003', true);
            }
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends ComponentAdapter {
        public void componentResized(ComponentEvent componentEvent) {
            Calculator.this.myResize(Calculator.this.getBounds().x, Calculator.this.getBounds().y, Calculator.this.getBounds().width, Calculator.this.getBounds().height);
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    extends WindowAdapter {
        public void windowActivated(WindowEvent windowEvent) {
            switch (Master.numGraphers()) {
                case 3: {
                    Master.hideGrapherCAuxWindows();
                }
                case 2: {
                    Master.hideGrapherBAuxWindows();
                }
            }
            Master.hideGrapherAuxWindows();
        }

        public void windowClosing(WindowEvent windowEvent) {
            if (Master.graphAVisible() || Master.graphBVisible() || Master.graphCVisible() || Master.tableVisible()) {
                Calculator.this.setVisible(false);
            } else {
                Master.sureToQuit();
                Calculator.this.setVisible(true);
            }
        }

        /* synthetic */ 3() {
        }
    }
}

