/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPCalculator;

import com.questmsm.FPCalculator.CalcUtils;
import com.questmsm.FPCalculator.Calculator;
import com.questmsm.FPCalculator.RowContainer;
import com.questmsm.Utilities.utils;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;

public class DisplayField
extends Canvas
implements RowContainer {
    private static Font fMainFont;
    private static Font fSmallFont;
    private static FontMetrics fMainMetric;
    private Calculator fCalc;
    private String fDisplayString = "0";
    private String fExponentString = "";
    private final int kSpacing = 3;
    private Image fBackgroundImage = null;
    private Image fForegroundImage = null;
    private Graphics fBackgroundGraphics = null;
    private Graphics fForegroundGraphics = null;

    public DisplayField(Calculator calculator, Color color) {
        this.fCalc = calculator;
        this.setBackground(color);
        fMainFont = new Font("Times", 1, 18);
        fSmallFont = new Font("Times", 1, 10);
        fMainMetric = this.getFontMetrics(fMainFont);
    }

    public void clear() {
        this.setDisplay("0");
        this.fExponentString = "";
    }

    public void setDisplay(String string) {
        this.fDisplayString = string;
    }

    public void setDisplay(double d) {
        this.fDisplayString = CalcUtils.toString(d);
    }

    public void setExponent(String string) {
        this.fExponentString = string;
    }

    public String displayStr() {
        return this.fDisplayString;
    }

    public String exponentStr() {
        return this.fExponentString;
    }

    public void createImages(int n, int n2) {
        this.fBackgroundImage = this.createImage(n, n2);
        this.fBackgroundGraphics = this.fBackgroundImage.getGraphics();
        this.fForegroundImage = this.createImage(n, n2);
        this.fForegroundGraphics = this.fForegroundImage.getGraphics();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.createImages(n3, n4);
        this.drawBackground();
    }

    private synchronized void drawBackground(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        graphics.setFont(fMainFont);
        utils.fancyBorder(graphics, this.getSize().width, this.getSize().height);
    }

    public synchronized void drawBackground() {
        this.drawBackground(this.fBackgroundGraphics);
    }

    private synchronized void drawForeground(Graphics graphics) {
        graphics.setFont(fMainFont);
        graphics.setColor(Color.black);
        int n = 25;
        CalcUtils.drawRightJust(graphics, String.valueOf(this.fDisplayString) + "^" + this.fExponentString, this.getSize().width - n, this.getSize().height - 8, fMainFont, fSmallFont);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public synchronized void paint(Graphics graphics) {
        if (this.fBackgroundImage == null) {
            return;
        }
        if (this.fForegroundImage == null) {
            return;
        }
        this.fForegroundGraphics.drawImage(this.fBackgroundImage, 0, 0, this);
        this.drawForeground(this.fForegroundGraphics);
        graphics.drawImage(this.fForegroundImage, 0, 0, this);
    }

    public int resultLineLoc() {
        return this.getSize().width - 60;
    }

    public boolean keyDown(Event event, int n) {
        this.fCalc.setFocus();
        this.fCalc.buttonsKeyDown(event, n);
        return false;
    }

    public void repaint() {
        if (this.fCalc.editing()) {
            return;
        }
        super.repaint();
    }

    public synchronized void redraw() {
    }

    public void pushStringToCurrentRow(String string) {
    }

    public void pushFunctionToCurrent(String string, int n) {
    }

    public void pushToCurrentRow(char c) {
    }

    public void clearRow() {
    }

    public void endRow(String string) {
    }

    public void createNewRow() {
    }

    public void setResult(String string) {
    }
}

