/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPCalculator;

import com.questmsm.FPCalculator.CalcUtils;
import com.questmsm.FPCalculator.MatrixRowElement;
import com.questmsm.FunctionProbe.Master;
import com.questmsm.Utilities.FPNumberFormatException;
import com.questmsm.Utilities.fp_resource;
import com.questmsm.Utilities.utils;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.Serializable;

public class Matrix
extends MatrixRowElement
implements Serializable {
    private int fRows;
    private int fCols;
    private double[][] fData;
    private int[] fColWidth;
    private boolean fAugmented;
    private int fNumAugmentCols;
    private double[][] fAugmentData;
    private int[] fAugmentColWidth;
    private String fName;
    private static final transient int kVSpacing = 12;
    private static final transient int kHSpacing = 8;
    public static final transient int kNameSpace = 15;
    private static final transient Font fNameFont = new Font("Courier", 1, 12);
    private static final transient Font fScriptFont = new Font("Courier", 1, 9);
    private static final transient Font fLabelFont = new Font("Courier", 1, 12);
    private static final transient Font fMatrixFont = new Font("Courier", 0, 12);
    private static transient FontMetrics fMetric = null;
    public static transient int gMatrixNum = 0;

    public Matrix(int n, int n2, String string) {
        this.fRows = n;
        this.fCols = n2;
        this.fName = string;
        this.fData = new double[this.fRows][this.fCols];
        this.fColWidth = new int[this.fCols];
        this.fAugmented = false;
        this.fWidth = 0;
        this.fHeight = this.fRows * 12 + 15;
    }

    public static void setMetric(Canvas canvas) {
        fMetric = canvas.getFontMetrics(fMatrixFont);
    }

    public int numRows() {
        return this.fRows;
    }

    public int numCols() {
        return this.fCols;
    }

    public int getNumAugmentCols() {
        return this.fNumAugmentCols;
    }

    public boolean isSquare() {
        return this.fRows == this.fCols;
    }

    public String name() {
        return this.fName;
    }

    public void name(String string) {
        this.fName = string;
    }

    public void adjustColWidths() {
        int n;
        int n2;
        this.fWidth = 0;
        int n3 = 0;
        while (n3 < this.fCols) {
            n2 = 0;
            this.fColWidth[n3] = 0;
            n = 0;
            while (n < this.fRows) {
                n2 = fMetric.stringWidth(CalcUtils.toString(this.fData[n][n3]));
                if (n3 > 0) {
                    n2 += 8;
                }
                if (n2 > this.fColWidth[n3]) {
                    this.fColWidth[n3] = n2;
                }
                ++n;
            }
            this.fWidth += this.fColWidth[n3];
            ++n3;
        }
        if (this.fAugmented) {
            n = 0;
            while (n < this.fNumAugmentCols) {
                n2 = 0;
                int n4 = 0;
                while (n4 < this.fRows) {
                    n2 = fMetric.stringWidth(CalcUtils.toString(this.fAugmentData[n4][n])) + 8;
                    if (n2 > this.fAugmentColWidth[n]) {
                        this.fAugmentColWidth[n] = n2;
                    }
                    ++n4;
                }
                this.fWidth += this.fAugmentColWidth[n];
                ++n;
            }
        }
        this.fWidth += 14;
    }

    public void augment(int n) {
        this.fAugmented = true;
        this.fNumAugmentCols = n;
        this.fAugmentData = new double[this.fRows][n];
        this.fAugmentColWidth = new int[n];
    }

    public boolean augmented() {
        return this.fAugmented;
    }

    public static String newMatrixName() {
        return "M" + (++gMatrixNum - 1);
    }

    public void autoName() {
        this.fName = Matrix.newMatrixName();
    }

    public void changeSign() {
        int n = 0;
        while (n < this.fRows) {
            int n2 = 0;
            while (n2 < this.fCols) {
                double[] dArray = this.fData[n];
                int n3 = n2++;
                dArray[n3] = dArray[n3] * -1.0;
            }
            ++n;
        }
    }

    public Matrix times(Matrix matrix) {
        if (matrix == null) {
            return null;
        }
        if (this.fCols != matrix.fRows) {
            utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_error_in_dimensions_of_matrix_multiplication"));
            return null;
        }
        Matrix matrix2 = new Matrix(this.fRows, matrix.fCols, "");
        int n = 0;
        while (n < this.fRows) {
            int n2 = 0;
            while (n2 < matrix.fCols) {
                double d = 0.0;
                int n3 = 0;
                while (n3 < this.fCols) {
                    d += this.fData[n][n3] * matrix.fData[n3][n2];
                    ++n3;
                }
                matrix2.setVal(n, n2, d);
                ++n2;
            }
            ++n;
        }
        matrix2.adjustColWidths();
        return matrix2;
    }

    public Matrix plus(Matrix matrix) {
        if (matrix == null) {
            return null;
        }
        if (this.fCols != matrix.fCols || this.fRows != matrix.fRows) {
            utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_error_in_dimensions_of_matrix_addition"));
            return null;
        }
        Matrix matrix2 = new Matrix(this.fRows, this.fCols, "");
        int n = 0;
        while (n < this.fRows) {
            int n2 = 0;
            while (n2 < this.fCols) {
                matrix2.setVal(n, n2, this.fData[n][n2] + matrix.valAt(n, n2));
                ++n2;
            }
            ++n;
        }
        matrix2.adjustColWidths();
        return matrix2;
    }

    public Matrix minus(Matrix matrix) {
        if (matrix == null) {
            return null;
        }
        if (this.fCols != matrix.fCols || this.fRows != matrix.fRows) {
            utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_error_in_dimensions_of_matrix_subtraction"));
            return null;
        }
        Matrix matrix2 = new Matrix(this.fRows, this.fCols, "");
        int n = 0;
        while (n < this.fRows) {
            int n2 = 0;
            while (n2 < this.fCols) {
                matrix2.setVal(n, n2, this.fData[n][n2] - matrix.valAt(n, n2));
                ++n2;
            }
            ++n;
        }
        matrix2.adjustColWidths();
        return matrix2;
    }

    public Matrix scalarMult(double d) {
        Matrix matrix = new Matrix(this.fRows, this.fCols, "");
        int n = 0;
        while (n < this.fRows) {
            int n2 = 0;
            while (n2 < this.fCols) {
                matrix.fData[n][n2] = this.fData[n][n2] * d;
                ++n2;
            }
            ++n;
        }
        matrix.adjustColWidths();
        return matrix;
    }

    public Matrix scalarAdd(double d) {
        Matrix matrix = new Matrix(this.fRows, this.fCols, "");
        int n = 0;
        while (n < this.fRows) {
            int n2 = 0;
            while (n2 < this.fCols) {
                matrix.fData[n][n2] = this.fData[n][n2] + d;
                ++n2;
            }
            ++n;
        }
        matrix.adjustColWidths();
        return matrix;
    }

    public void setVal(int n, int n2, double d) {
        if (n < 0 || n2 < 0) {
            return;
        }
        if (n >= this.fRows || n2 >= this.fCols) {
            return;
        }
        this.fData[n][n2] = d;
    }

    public double valAt(int n, int n2) {
        return this.fData[n][n2];
    }

    public void setAugmentVal(int n, int n2, double d) {
        if (!this.fAugmented) {
            return;
        }
        if (n < 0 || n2 < 0) {
            return;
        }
        if (n >= this.fRows || n2 >= this.fNumAugmentCols) {
            return;
        }
        this.fAugmentData[n][n2] = d;
    }

    public void draw(Graphics graphics) {
        String string;
        int n;
        int n2 = 7;
        int n3 = 12;
        if (this.fSelected) {
            graphics.setColor(Color.black);
            graphics.fillRect(this.fLeft, this.fTop, this.fWidth + 6, this.fHeight + 3);
            graphics.setColor(Color.white);
        } else {
            graphics.setColor(Color.black);
        }
        int n4 = this.fLeft + this.fSpacing;
        graphics.setFont(fNameFont);
        CalcUtils.drawLeft(graphics, this.fName, this.fLeft, this.fTop + 12, fNameFont, fScriptFont);
        int n5 = this.fTop + 15;
        graphics.drawLine(n4, n5, n4 + 5, n5);
        graphics.drawLine(n4, n5 - 1, n4 + 5, n5 - 1);
        graphics.drawLine(n4, n5, n4, n5 + this.fHeight - 15);
        graphics.drawLine(n4 - 1, n5, n4 - 1, n5 + this.fHeight - 15);
        graphics.drawLine(n4, n5 + this.fHeight - 15, n4 + 5, n5 + this.fHeight - 15);
        graphics.drawLine(n4, n5 + this.fHeight - 15 + 1, n4 + 5, n5 + this.fHeight - 15 + 1);
        graphics.drawLine(n4 + this.fWidth, n5, n4 + this.fWidth - 5, n5);
        graphics.drawLine(n4 + this.fWidth, n5 - 1, n4 + this.fWidth - 5, n5 - 1);
        graphics.drawLine(n4 + this.fWidth, n5, n4 + this.fWidth, n5 + this.fHeight - 15);
        graphics.drawLine(n4 + this.fWidth + 1, n5, n4 + this.fWidth + 1, n5 + this.fHeight - 15);
        graphics.drawLine(n4 + this.fWidth, n5 + this.fHeight - 15, n4 + this.fWidth - 5, n5 + this.fHeight - 15);
        graphics.drawLine(n4 + this.fWidth, n5 + this.fHeight - 15 + 1, n4 + this.fWidth - 5, n5 + this.fHeight - 15 + 1);
        graphics.setFont(fMatrixFont);
        int n6 = n2 + n4;
        int n7 = 0;
        while (n7 < this.fCols) {
            n6 += this.fColWidth[n7];
            n = 0;
            while (n < this.fRows) {
                string = CalcUtils.toString(this.fData[n][n7]);
                graphics.drawString(string, n6 - fMetric.stringWidth(string), n3 + n5 + n * 12);
                ++n;
            }
            ++n7;
        }
        if (!this.fAugmented) {
            return;
        }
        n = n6 + 3;
        int n8 = n5;
        while (n8 < n5 + this.fHeight - 15 + 2) {
            graphics.drawLine(n, n8, n, n8 + 2);
            n8 += 4;
        }
        int n9 = 0;
        while (n9 < this.fNumAugmentCols) {
            n6 += this.fAugmentColWidth[n9];
            int n10 = 0;
            while (n10 < this.fRows) {
                string = CalcUtils.toString(this.fAugmentData[n10][n9]);
                graphics.drawString(string, n6 - fMetric.stringWidth(string), n3 + n5 + n10 * 12);
                ++n10;
            }
            ++n9;
        }
    }

    public void drawRowLabels(Graphics graphics) {
        int n = 7;
        int n2 = 12;
        int n3 = this.fLeft + this.fSpacing;
        int n4 = this.fTop + 15;
        graphics.setFont(fLabelFont);
        int n5 = n + n3;
        int n6 = 0;
        while (n6 < this.fRows) {
            graphics.drawString("R" + (n6 + 1), n5 - 30, n2 + n4 + n6 * 12);
            ++n6;
        }
    }

    public Matrix leftMatrix() {
        int n;
        Matrix matrix = new Matrix(this.fRows, this.fCols, "");
        int n2 = 0;
        while (n2 < this.fRows) {
            n = 0;
            while (n < this.fCols) {
                matrix.fData[n2][n] = this.fData[n2][n];
                ++n;
            }
            ++n2;
        }
        n = 0;
        while (n < this.fCols) {
            matrix.fColWidth[n] = this.fColWidth[n];
            ++n;
        }
        matrix.adjustColWidths();
        return matrix;
    }

    public Matrix rightMatrix() {
        if (!this.fAugmented) {
            return null;
        }
        Matrix matrix = new Matrix(this.fRows, this.fNumAugmentCols, "");
        int n = 0;
        while (n < this.fRows) {
            int n2 = 0;
            while (n2 < this.fNumAugmentCols) {
                matrix.fData[n][n2] = this.fAugmentData[n][n2];
                ++n2;
            }
            ++n;
        }
        matrix.adjustColWidths();
        return matrix;
    }

    public Matrix copy() {
        int n;
        int n2;
        Matrix matrix = new Matrix(this.fRows, this.fCols, this.fName);
        int n3 = 0;
        while (n3 < this.fRows) {
            n2 = 0;
            while (n2 < this.fCols) {
                matrix.fData[n3][n2] = this.fData[n3][n2];
                ++n2;
            }
            ++n3;
        }
        n2 = 0;
        while (n2 < this.fCols) {
            matrix.fColWidth[n2] = this.fColWidth[n2];
            ++n2;
        }
        matrix.fWidth = this.fWidth;
        if (!this.fAugmented) {
            return matrix;
        }
        matrix.augment(this.fNumAugmentCols);
        int n4 = 0;
        while (n4 < this.fRows) {
            n = 0;
            while (n < this.fNumAugmentCols) {
                matrix.fAugmentData[n4][n] = this.fAugmentData[n4][n];
                ++n;
            }
            ++n4;
        }
        n = 0;
        while (n < this.fNumAugmentCols) {
            matrix.fAugmentColWidth[n] = this.fAugmentColWidth[n];
            ++n;
        }
        matrix.fTop = this.fTop;
        matrix.fLeft = this.fLeft;
        matrix.fWidth = this.fWidth;
        matrix.fHeight = this.fHeight;
        matrix.fSpacing = this.fSpacing;
        return matrix;
    }

    public boolean system() {
        return this.fAugmented && this.fRows == this.fCols && this.fNumAugmentCols == 1;
    }

    public double det(StringBuffer stringBuffer) {
        int n;
        int n2;
        double d;
        int n3 = 0;
        if (this.fRows != this.fCols) {
            stringBuffer.append(fp_resource.getString("str_error__matrix_must_be_square_to_take_the_determinant"));
            return -1.23456123;
        }
        int n4 = this.fRows;
        double[][] dArray = new double[n4 + 1][n4 + 1];
        int n5 = 1;
        while (n5 <= n4) {
            int n6 = 1;
            while (n6 <= n4) {
                dArray[n6][n5] = this.fData[n6 - 1][n5 - 1];
                ++n6;
            }
            ++n5;
        }
        double[] dArray2 = new double[n4 + 1];
        double d2 = 1.0;
        int n7 = 1;
        while (n7 <= n4) {
            d = 0.0;
            n2 = 1;
            while (n2 <= n4) {
                double d3;
                double d4 = Math.abs(dArray[n7][n2]);
                if (d3 > d) {
                    d = d4;
                }
                ++n2;
            }
            if (d == 0.0) {
                stringBuffer.append(fp_resource.getString("str_error__this_is_a_singular_matrix"));
                return -1.23456123;
            }
            dArray2[n7] = 1.0 / d;
            ++n7;
        }
        n2 = 1;
        while (n2 <= n4) {
            double d5;
            int n8;
            double d6;
            int n9 = 1;
            while (n9 < n2) {
                d6 = dArray[n9][n2];
                n8 = 1;
                while (n8 < n9) {
                    d6 -= dArray[n9][n8] * dArray[n8][n2];
                    ++n8;
                }
                dArray[n9][n2] = d6;
                ++n9;
            }
            d = 0.0;
            n8 = n2;
            while (n8 <= n4) {
                double d7;
                d6 = dArray[n8][n2];
                n = 1;
                while (n < n2) {
                    d6 -= dArray[n8][n] * dArray[n][n2];
                    ++n;
                }
                dArray[n8][n2] = d6;
                d5 = dArray2[n8] * Math.abs(d6);
                if (d7 >= d) {
                    d = d5;
                    n3 = n8;
                }
                ++n8;
            }
            if (n2 != n3) {
                n = 1;
                while (n <= n4) {
                    d5 = dArray[n3][n];
                    dArray[n3][n] = dArray[n2][n];
                    dArray[n2][n] = d5;
                    ++n;
                }
                d2 = -d2;
                dArray2[n3] = dArray2[n2];
            }
            if (dArray[n2][n2] == 0.0) {
                dArray[n2][n2] = 1.0E-10;
            }
            if (n2 != n4) {
                d5 = 1.0 / dArray[n2][n2];
                n = n2 + 1;
                while (n <= n4) {
                    double[] dArray3 = dArray[n];
                    int n10 = n2;
                    dArray3[n10] = dArray3[n10] * d5;
                    ++n;
                }
            }
            ++n2;
        }
        double d8 = d2;
        n = 1;
        while (n <= n4) {
            d8 *= dArray[n][n];
            ++n;
        }
        return d8;
    }

    public boolean square() {
        return this.fRows == this.fCols;
    }

    public Matrix invert() {
        if (this.fRows != this.fCols) {
            utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_error__cant_take_inverse_of_nonsquare_matrix"));
            return null;
        }
        int n = this.fRows;
        Matrix matrix = new Matrix(n, n, String.valueOf(this.fName) + "^-^1");
        int n2 = 0;
        while (n2 < n) {
            Matrix matrix2 = this.leftMatrix();
            matrix2.augment(1);
            int n3 = 0;
            while (n3 < n) {
                matrix2.fAugmentData[n3][0] = 0.0;
                ++n3;
            }
            matrix2.fAugmentData[n2][0] = 1.0;
            matrix2 = matrix2.solve();
            int n4 = 0;
            while (n4 < n) {
                matrix.fData[n4][n2] = matrix2.fAugmentData[n4][0];
                ++n4;
            }
            ++n2;
        }
        matrix.adjustColWidths();
        return matrix;
    }

    public Matrix solve() {
        int n;
        int n2;
        double d;
        int n3;
        int n4;
        double d2;
        int n5 = 0;
        if (this.fRows != this.fCols) {
            utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_error__nonsquare_matrix"));
            return null;
        }
        if (!this.fAugmented || this.fNumAugmentCols != 1) {
            utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_matrix_not_augmented_a_single_col"));
            return null;
        }
        int n6 = this.fRows;
        int[] nArray = new int[n6 + 1];
        double[][] dArray = new double[n6 + 1][n6 + 1];
        int n7 = 1;
        while (n7 <= n6) {
            int n8 = 1;
            while (n8 <= n6) {
                dArray[n8][n7] = this.fData[n8 - 1][n7 - 1];
                ++n8;
            }
            ++n7;
        }
        double[] dArray2 = new double[n6 + 1];
        double d3 = 1.0;
        int n9 = 1;
        while (n9 <= n6) {
            d2 = 0.0;
            n4 = 1;
            while (n4 <= n6) {
                double d4;
                double d5 = Math.abs(dArray[n9][n4]);
                if (d4 > d2) {
                    d2 = d5;
                }
                ++n4;
            }
            if (d2 == 0.0) {
                utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_error__singular_matrix"));
                return null;
            }
            dArray2[n9] = 1.0 / d2;
            ++n9;
        }
        n4 = 1;
        while (n4 <= n6) {
            double d6;
            int n10;
            n3 = 1;
            while (n3 < n4) {
                d = dArray[n3][n4];
                n2 = 1;
                while (n2 < n3) {
                    d -= dArray[n3][n2] * dArray[n2][n4];
                    ++n2;
                }
                dArray[n3][n4] = d;
                ++n3;
            }
            d2 = 0.0;
            n2 = n4;
            while (n2 <= n6) {
                double d7;
                d = dArray[n2][n4];
                n10 = 1;
                while (n10 < n4) {
                    d -= dArray[n2][n10] * dArray[n10][n4];
                    ++n10;
                }
                dArray[n2][n4] = d;
                d6 = dArray2[n2] * Math.abs(d);
                if (d7 >= d2) {
                    d2 = d6;
                    n5 = n2;
                }
                ++n2;
            }
            if (n4 != n5) {
                n10 = 1;
                while (n10 <= n6) {
                    d6 = dArray[n5][n10];
                    dArray[n5][n10] = dArray[n4][n10];
                    dArray[n4][n10] = d6;
                    ++n10;
                }
                d3 = -d3;
                dArray2[n5] = dArray2[n4];
            }
            nArray[n4] = n5;
            if (dArray[n4][n4] == 0.0) {
                dArray[n4][n4] = 1.0E-10;
            }
            if (n4 != n6) {
                d6 = 1.0 / dArray[n4][n4];
                n10 = n4 + 1;
                while (n10 <= n6) {
                    double[] dArray3 = dArray[n10];
                    int n11 = n4;
                    dArray3[n11] = dArray3[n11] * d6;
                    ++n10;
                }
            }
            ++n4;
        }
        n3 = 0;
        double[] dArray4 = new double[n6 + 1];
        int n12 = 1;
        while (n12 <= n6) {
            dArray4[n12] = this.fAugmentData[n12 - 1][0];
            ++n12;
        }
        int n13 = 1;
        while (n13 <= n6) {
            n2 = nArray[n13];
            d = dArray4[n2];
            dArray4[n2] = dArray4[n13];
            if (n3 != 0) {
                n = n3;
                while (n <= n13 - 1) {
                    d -= dArray[n13][n] * dArray4[n];
                    ++n;
                }
            } else if (d != 0.0) {
                n3 = n13;
            }
            dArray4[n13] = d;
            ++n13;
        }
        n = n6;
        while (n >= 1) {
            d = dArray4[n];
            int n14 = n + 1;
            while (n14 <= n6) {
                d -= dArray[n][n14] * dArray4[n14];
                ++n14;
            }
            dArray4[n] = d / dArray[n][n];
            --n;
        }
        Matrix matrix = new Matrix(n6, n6, "");
        int n15 = 0;
        while (n15 < n6) {
            matrix.setVal(n15, n15, 1.0);
            ++n15;
        }
        matrix.augment(1);
        int n16 = 0;
        while (n16 < n6) {
            matrix.setAugmentVal(n16, 0, dArray4[n16 + 1]);
            ++n16;
        }
        matrix.adjustColWidths();
        return matrix;
    }

    public void doRowOperation(int n, int n2, int n3, int n4, int n5, double d, double d2) {
        --n;
        --n2;
        double d3 = d;
        double d4 = d2;
        if (n3 == 2) {
            d3 = 1.0 / d3;
        }
        if (n5 == 2) {
            d4 = 1.0 / d4;
        }
        if (n4 == 2) {
            d3 *= -1.0;
        }
        int n6 = 0;
        while (n6 < this.fCols) {
            try {
                this.fData[n][n6] = utils.str2num(CalcUtils.toString(this.fData[n][n6] * d4 + this.fData[n2][n6] * d3));
            }
            catch (FPNumberFormatException fPNumberFormatException) {}
            ++n6;
        }
        if (!this.fAugmented) {
            return;
        }
        int n7 = 0;
        while (n7 < this.fNumAugmentCols) {
            try {
                this.fAugmentData[n][n7] = utils.str2num(CalcUtils.toString(this.fAugmentData[n][n7] * d4 + this.fAugmentData[n2][n7] * d3));
            }
            catch (FPNumberFormatException fPNumberFormatException) {}
            ++n7;
        }
    }

    public void doSwap(int n, int n2) {
        double d;
        if (--n == --n2) {
            return;
        }
        int n3 = 0;
        while (n3 < this.fCols) {
            d = this.fData[n][n3];
            this.fData[n][n3] = this.fData[n2][n3];
            this.fData[n2][n3] = d;
            ++n3;
        }
        if (!this.fAugmented) {
            return;
        }
        int n4 = 0;
        while (n4 < this.fNumAugmentCols) {
            d = this.fAugmentData[n][n4];
            this.fAugmentData[n][n4] = this.fAugmentData[n2][n4];
            this.fAugmentData[n2][n4] = d;
            ++n4;
        }
    }
}

