/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPCalculator;

import com.questmsm.FPCalculator.Node;
import com.questmsm.FPCalculator.Row;
import com.questmsm.FPCalculator.RowContainer;
import com.questmsm.Utilities.FPNumberFormatException;
import com.questmsm.Utilities.utils;
import java.awt.Graphics;
import java.io.Serializable;

public class ResultRow
extends Row
implements Serializable {
    protected final int kSpacing = 0;

    public ResultRow(RowContainer rowContainer, int n, int n2) {
        super(rowContainer, n, n2);
    }

    public void recalculatePositions() {
        int n = this.fContainer.resultLineLoc() + 10;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.fNumElements) {
            if (this.fElement[n3].kind() == 0) {
                char c = this.fElement[n3].theChar();
                int n4 = 0;
                switch (c) {
                    case '.': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        n4 = 0;
                        break;
                    }
                    default: {
                        n4 = 0;
                    }
                }
                n2 = Row.fMetric.charWidth(this.fElement[n3].theChar());
                this.fElement[n3].setSpacing(n, n + 2 * n4 + n2, n4);
                n += 2 * n4 + n2;
            }
            ++n3;
        }
    }

    public void add(char c) {
        if (this.fNumElements == 100) {
            return;
        }
        this.fElement[this.fNumElements] = new Node(c);
        ++this.fNumElements;
    }

    public boolean handleMouse(int n, int n2) {
        this.fSelectedStart = -1;
        if (this.fPassive) {
            return false;
        }
        if (n2 < this.fTop - 5) {
            return false;
        }
        if (n2 > this.fTop + this.fHeight + 5) {
            return false;
        }
        if (this.fNumElements == 0) {
            return false;
        }
        if (n < this.fElement[0].left()) {
            return false;
        }
        if (n > this.fElement[this.fNumElements - 1].right()) {
            return false;
        }
        this.fSelectedStart = 0;
        this.fSelectedStop = this.fNumElements - 1;
        return false;
    }

    public double num() throws FPNumberFormatException {
        String string = "";
        int n = 0;
        while (n < this.fNumElements) {
            if (this.fElement[n].kind() != 0) {
                return 0.0;
            }
            string = String.valueOf(string) + this.fElement[n].theChar();
            ++n;
        }
        return utils.str2num(string);
    }

    public void draw(Graphics graphics) {
        super.draw(graphics);
        if (this.fNumElements <= 0) {
            return;
        }
        int n = this.fElement[this.fNumElements - 1].right() + 5;
        int n2 = this.fTop + this.fHeight / 2 + 3;
        if (this.fCancelled) {
            graphics.drawLine(n, n2 - 6, n + 8, n2 + 2);
            graphics.drawLine(n + 1, n2 - 6, n + 8 + 1, n2 + 2);
            graphics.drawLine(n, n2 + 2, n + 8, n2 - 6);
            graphics.drawLine(n + 1, n2 + 2, n + 8 + 1, n2 - 6);
        }
    }
}

