/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPCalculator;

import com.questmsm.FPCalculator.Calculator;
import com.questmsm.FPCalculator.Node;
import com.questmsm.FPCalculator.ResultRow;
import com.questmsm.FPCalculator.Row;
import com.questmsm.FPCalculator.RowContainer;
import com.questmsm.FPCalculator.SpecialFieldPanel;
import com.questmsm.Utilities.FPNumberFormatException;
import com.questmsm.Utilities.fp_resource;
import com.questmsm.Utilities.utils;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.util.Properties;

public class SpecialTextField
extends Canvas
implements RowContainer {
    private SpecialFieldPanel fPanel;
    private Calculator fCalc;
    public static final int kMaxRows = 50;
    private ResultRow[] fResults = new ResultRow[50];
    private Row[] fRows = new Row[50];
    private int fLastRow;
    private int fPageWidth = 225;
    private int fPageHeight = 0;
    private Image fBackgroundImage = null;
    private Image fForegroundImage = null;
    private Graphics fBackgroundGraphics = null;
    private Graphics fForegroundGraphics = null;
    private int dx;
    private int dy;
    private boolean fDraggingMargin = false;
    public static final int kRowHeight = 22;
    public int fRightMargin = this.fPageWidth - 70;
    static final int XINDENT = 40;
    static final int YINDENT = 40;

    public SpecialTextField(SpecialFieldPanel specialFieldPanel, Calculator calculator, Color color) {
        this.fCalc = calculator;
        this.fPanel = specialFieldPanel;
        this.setBackground(color);
        this.fLastRow = 0;
        this.dx = 0;
        this.dy = 0;
        Row.setMetric(this);
        Node.setMetric(this);
        this.fRows[this.fLastRow] = new Row(this, 0, 22);
        this.fResults[this.fLastRow] = new ResultRow(this, 0, 22);
    }

    public void clear() {
        this.dx = 0;
        this.dy = 0;
        this.fDraggingMargin = false;
        this.fPageWidth = 225;
        this.fPageHeight = 100;
        this.fRightMargin = this.fPageWidth - 70;
        this.fLastRow = 0;
        this.fRows[this.fLastRow] = new Row(this, 0, 22);
        this.fResults[this.fLastRow] = new ResultRow(this, 0, 22);
        this.createImages(this.fPageWidth, this.fPageHeight);
        this.drawBackground();
    }

    private void createImages(int n, int n2) {
        this.fBackgroundImage = this.createImage(n, n2);
        this.fBackgroundGraphics = this.fBackgroundImage.getGraphics();
        this.fForegroundImage = this.createImage(n, n2);
        this.fForegroundGraphics = this.fForegroundImage.getGraphics();
    }

    public void transferToEdit() {
        this.fRows[this.fLastRow].selectAll();
        this.fRows[this.fLastRow].transferToEdit(this.fCalc.editField());
    }

    public String lastResult() {
        String string = this.fResults[this.fLastRow].string();
        if (string == null) {
            return "";
        }
        if (string.length() == 0) {
            return "";
        }
        if (string.charAt(0) == 'B') {
            return "";
        }
        return string;
    }

    public void clearHistory() {
        this.fLastRow = 0;
        this.fRows[this.fLastRow] = new Row(this, 0, 22);
        this.fResults[this.fLastRow] = new ResultRow(this, 0, 22);
    }

    public void clearRow() {
        this.fRows[this.fLastRow].clear();
        if (this.fResults[this.fLastRow] != null) {
            this.fResults[this.fLastRow].clear();
        }
        this.fCalc.calcCanvas().clearAll();
    }

    public void createNewRow() {
        if (this.fLastRow == 50) {
            return;
        }
        if (this.fRows[this.fLastRow].isEmpty()) {
            return;
        }
        this.dy = 0;
        this.fPanel.setVScrollVal(0);
        int n = 0;
        while (n <= this.fLastRow) {
            this.fRows[n].top(this.fRows[n].top() + 22);
            this.fResults[n].top(this.fResults[n].top() + 22);
            ++n;
        }
        ++this.fLastRow;
        this.fRows[this.fLastRow] = new Row(this, 0, 22);
        this.fResults[this.fLastRow] = new ResultRow(this, 0, 22);
        if (this.fRows[0].top() + 22 > this.fPageHeight) {
            this.fPageHeight = this.fRows[0].top() + 22 + 10;
            this.createImages(this.fPageWidth, this.fPageHeight);
            this.drawBackground();
            this.fPanel.setScrollSettings();
        }
        this.fCalc.calcCanvas().current(0);
        this.repaint();
    }

    public void makePassiveRow(String string, String string2) {
        this.clearRow();
        this.fRows[this.fLastRow].passive(true);
        this.pushStringToCurrentRow(string);
        this.pushStringToResult(string2);
        this.createNewRow();
    }

    public void setResult(String string) {
        this.fResults[this.fLastRow].clear();
        this.pushStringToResult(string);
    }

    public int resultLineLoc() {
        return this.fRightMargin;
    }

    public int pageHeight() {
        return this.fPageHeight;
    }

    public int pageWidth() {
        return this.fPageWidth;
    }

    public void recalculate() {
        int n = 0;
        while (n <= this.fLastRow) {
            this.fRows[n].recalculatePositions();
            this.fResults[n].recalculatePositions();
            ++n;
        }
        if (this.fRows[this.fLastRow].top() + 22 > this.fPageHeight) {
            this.fPageHeight = this.fRows[this.fLastRow].top() + 22 + 10;
            this.createImages(this.fPageWidth, this.fPageHeight);
            this.drawBackground();
        }
        this.fPanel.setScrollSettings();
        this.fPanel.setHScrollVal(this.dx);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        int n5 = this.fPageWidth;
        int n6 = this.fPageHeight;
        if (n3 + this.dx > this.fPageWidth) {
            this.fPageWidth = n3 + this.dx;
        }
        super.setBounds(n, n2, n3, n4);
        if (n4 > this.fPageHeight) {
            this.fPageHeight = n4;
        }
        this.fRightMargin = this.fPageWidth - (n5 - this.fRightMargin);
        this.recalculate();
        if (this.fPageWidth != n5 || this.fPageHeight != n6) {
            this.createImages(this.fPageWidth, this.fPageHeight);
        }
        this.drawBackground();
    }

    private synchronized void drawBackground(Graphics graphics, boolean bl) {
        if (graphics == null) {
            return;
        }
        if (bl) {
            graphics.setColor(Color.white);
        } else {
            graphics.setColor(Color.lightGray);
        }
        graphics.fillRect(0, 0, this.fPageWidth, this.fPageHeight);
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, this.fPageWidth - 1, this.fPageHeight - 1);
        graphics.drawLine(this.fRightMargin, 0, this.fRightMargin, this.fPageHeight);
        int n = 0;
        while (n <= this.fLastRow) {
            this.fRows[n].draw(graphics);
            this.fResults[n].draw(graphics);
            ++n;
        }
    }

    private synchronized void drawBackground(Graphics graphics) {
        this.drawBackground(graphics, false);
    }

    public synchronized void drawBackground() {
        this.drawBackground(this.fBackgroundGraphics, false);
    }

    private synchronized void drawForeground(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        int n = 0;
        while (n <= this.fLastRow) {
            this.fRows[n].drawSelected(graphics);
            this.fResults[n].drawSelected(graphics);
            ++n;
        }
        if (this.fDraggingMargin) {
            graphics.setColor(Color.red);
            graphics.drawLine(this.fRightMargin, 0, this.fRightMargin, this.fPageHeight);
            graphics.setColor(Color.black);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void doPrint() {
        Properties properties = new Properties();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        PrintJob printJob = toolkit.getPrintJob(this.fCalc, fp_resource.getString("str_calculator"), properties);
        if (printJob == null) {
            return;
        }
        Dimension dimension = printJob.getPageDimension();
        dimension.width -= 80;
        dimension.height -= 80;
        int n = (int)Math.floor((double)this.fPageWidth / (double)dimension.width) + 1;
        int n2 = (int)Math.floor((double)this.fPageHeight / (double)dimension.height) + 1;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n3 * dimension.height + 40;
            int n5 = 0;
            while (n5 < n) {
                int n6 = n5 * dimension.width + 40;
                Graphics graphics = printJob.getGraphics();
                graphics.translate(n6, n4);
                graphics.setClip(0, 0, dimension.width + n6, dimension.height + n4);
                this.drawBackground(graphics, true);
                graphics.translate(-n6, -n4);
                graphics.dispose();
                ++n5;
            }
            ++n3;
        }
        printJob.end();
    }

    public synchronized void paint(Graphics graphics) {
        if (this.fBackgroundImage == null) {
            return;
        }
        if (this.fForegroundImage == null) {
            return;
        }
        if (!this.fCalc.isShowing()) {
            return;
        }
        this.fForegroundGraphics.drawImage(this.fBackgroundImage, 0, 0, this);
        this.drawForeground(this.fForegroundGraphics);
        graphics.translate(-this.dx, -this.dy);
        graphics.drawImage(this.fForegroundImage, 0, 0, this);
        graphics.translate(this.dx, this.dy);
    }

    public void doOffset(int n) {
        this.dx -= (n -= 2);
        this.fPageWidth -= n;
        this.fRightMargin -= n;
        this.createImages(this.fPageWidth, this.fPageHeight);
        this.recalculate();
    }

    public void setDefineRow(int n, String string) {
        this.fRows[this.fLastRow].defineButtonRow(true, n, string);
        this.fResults[this.fLastRow].clear();
        String string2 = "B" + (n + 1);
        int n2 = 0;
        while (n2 < string2.length()) {
            this.fResults[this.fLastRow].add(string2.charAt(n2));
            ++n2;
        }
    }

    public void setRowUserNum(int n) {
        this.fRows[this.fLastRow].userButtonNum(n);
    }

    public void pushchar(char c, int n) {
        this.fRows[n].add(c);
        this.fRows[n].recalculatePositions();
        if (this.fRows[n].left() < 0) {
            this.doOffset(this.fRows[n].left());
        }
    }

    public void pushFunctionToCurrent(String string, int n) {
        this.fRows[this.fLastRow].add(string, n);
        if (this.fRows[this.fLastRow].left() < 0) {
            this.doOffset(this.fRows[this.fLastRow].left());
        }
    }

    public void pushStringToCurrentRow(String string) {
        int n = 0;
        while (n < string.length()) {
            this.fRows[this.fLastRow].add(string.charAt(n));
            ++n;
        }
        this.fRows[this.fLastRow].recalculatePositions();
        if (this.fRows[this.fLastRow].left() < 0) {
            this.doOffset(this.fRows[this.fLastRow].left());
        }
    }

    public void endRowNoEqual(String string) {
        this.setResult(string);
        this.createNewRow();
    }

    public void endRowNoEqual() {
        this.createNewRow();
    }

    public void endRow(String string) {
        this.pushchar('=', this.fLastRow);
        this.endRowNoEqual(string);
    }

    public void cancelRow(int n) {
        int n2 = 0;
        while (n2 < this.fLastRow) {
            if (this.fRows[n2].userButtonNum() == n) {
                this.fRows[n2].userButtonCancel();
                int n3 = 0;
                while (n3 < this.fLastRow) {
                    if (n2 != n3) {
                        if (this.fRows[n3].functionUsed(n)) {
                            this.fRows[n3].inactive(true);
                        }
                        if (this.fRows[n3].defineButtonRow() && this.fRows[n3].userButtonNum() > n) {
                            this.fRows[n3].userButtonNum(this.fRows[n3].userButtonNum() - 1);
                            return;
                        }
                    }
                    ++n3;
                }
                return;
            }
            ++n2;
        }
    }

    public boolean isLastRowValid() {
        return this.fRows[this.fLastRow].isValid();
    }

    public void pushStringToResult(String string) {
        int n = 0;
        while (n < string.length()) {
            this.fResults[this.fLastRow].add(string.charAt(n));
            ++n;
        }
        this.fResults[this.fLastRow].recalculatePositions();
        if (this.fResults[this.fLastRow].right() + 15 > this.fPageWidth) {
            this.fPageWidth = this.fResults[this.fLastRow].right() + 15;
            this.createImages(this.fPageWidth, this.fPageHeight);
            this.recalculate();
            this.drawBackground();
        }
    }

    public void pushToCurrentRow(char c) {
        this.pushchar(c, this.fLastRow);
    }

    public void clearSelect() {
        int n = 0;
        while (n <= this.fLastRow) {
            this.fRows[n].clearSelect();
            ++n;
        }
    }

    public synchronized boolean mouseUp(Event event, int n, int n2) {
        if (this.fDraggingMargin) {
            this.fDraggingMargin = false;
            this.fRightMargin = n + this.dx;
            this.recalculate();
            this.drawBackground();
            this.repaint();
        } else {
            int n3 = 0;
            try {
                n3 = 0;
                while (n3 <= this.fLastRow) {
                    if (this.fResults[n3].selectedRange() > 0) {
                        this.fResults[n3].num();
                        break;
                    }
                    ++n3;
                }
            }
            catch (FPNumberFormatException fPNumberFormatException) {
                String string = fp_resource.getString("str_error__cant_convert_into_a_number");
                if (this.fResults[n3].string().trim().length() > 0) {
                    string = String.valueOf(string) + ": " + this.fResults[n3].string();
                }
                utils.showErrorDialog(this.fCalc, string);
                return true;
            }
            n3 = 0;
            while (n3 <= this.fLastRow) {
                if (this.fRows[n3].selectedRange() > 0) {
                    this.fCalc.editing(true);
                    if (this.fRows[n3].defineButtonRow()) {
                        this.fCalc.definingButton(true);
                    }
                    this.fRows[n3].transferToEdit(this.fCalc.editField());
                    this.fRows[n3].clearSelect();
                    this.repaint();
                    return true;
                }
                if (this.fResults[n3].selectedRange() > 0) {
                    try {
                        this.fCalc.setCalcValueTo(this.fResults[n3].num());
                    }
                    catch (FPNumberFormatException fPNumberFormatException) {}
                    this.fResults[n3].clearSelect();
                    return true;
                }
                ++n3;
            }
        }
        return super.mouseUp(event, n, n2);
    }

    public void editButton(int n) {
        this.fCalc.editing(true);
        int n2 = 0;
        while (n2 < this.fLastRow) {
            if (this.fRows[n2].functionUsed(n)) {
                this.fRows[n2].cancel(true);
                this.fResults[n2].cancel(true);
            }
            ++n2;
        }
        this.drawBackground();
        int n3 = 0;
        while (n3 < this.fLastRow) {
            if (this.fRows[n3].userButtonNum() == n) {
                this.fRows[n3].transferToEdit(this.fCalc.editField());
                this.repaint();
                return;
            }
            ++n3;
        }
    }

    public synchronized boolean mouseDrag(Event event, int n, int n2) {
        n += this.dx;
        n2 += this.dy;
        if (this.fDraggingMargin) {
            this.fRightMargin = n;
            this.repaint();
            return true;
        }
        int n3 = 0;
        while (n3 <= this.fLastRow) {
            if (this.fRows[n3].handleDrag(n, n2)) {
                this.repaint();
                return true;
            }
            ++n3;
        }
        return false;
    }

    public synchronized boolean mouseDown(Event event, int n, int n2) {
        n2 += this.dy;
        if (Math.abs((n += this.dx) - this.fRightMargin) < 4) {
            this.fDraggingMargin = true;
            return true;
        }
        int n3 = 0;
        while (n3 <= this.fLastRow) {
            this.fRows[n3].clearSelect();
            this.fResults[n3].clearSelect();
            ++n3;
        }
        int n4 = 0;
        while (n4 <= this.fLastRow) {
            if (this.fRows[n4].handleMouse(n, n2)) {
                this.repaint();
                return true;
            }
            if (this.fResults[n4].handleMouse(n, n2)) {
                this.repaint();
                return true;
            }
            ++n4;
        }
        this.repaint();
        return false;
    }

    public boolean keyDown(Event event, int n) {
        this.fCalc.setFocus();
        this.fCalc.buttonsKeyDown(event, n);
        return false;
    }

    public synchronized void redraw() {
        this.drawBackground();
        this.repaint();
    }

    public void translate(int n, int n2) {
        this.dx = n;
        this.dy = n2;
        this.repaint();
    }

    public int numRows() {
        return this.fLastRow;
    }

    public void numRows(int n) {
        this.fLastRow = n;
    }

    public void setRow(int n, Row row) {
        this.fRows[n] = row;
        this.fRows[n].setRowContainer(this);
        this.fRows[n].recalculatePositions();
    }

    public void setResultRow(int n, ResultRow resultRow) {
        this.fResults[n] = resultRow;
        this.fResults[n].setRowContainer(this);
        this.fResults[n].recalculatePositions();
    }

    public Row row(int n) {
        return this.fRows[n];
    }

    public ResultRow resultRow(int n) {
        return this.fResults[n];
    }
}

