/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPGrapher;

import com.questmsm.FPGrapher.GIFFileFilter;
import com.questmsm.FPGrapher.GraphVariables;
import com.questmsm.FPGrapher.Grapher;
import com.questmsm.FPGrapher.TransparentFilter;
import com.questmsm.Utilities.fp_resource;
import com.questmsm.Utilities.utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.image.FilteredImageSource;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;

public class FPAxesShell
extends Panel {
    Grapher fGrapher;
    protected Image fBackgroundImage = null;
    protected Image fForegroundImage = null;
    protected Graphics fBackgroundGraphics = null;
    protected Graphics fForegroundGraphics = null;
    protected Image fBackdropImage = null;
    public int fWidth = 0;
    public int fHeight = 0;
    protected double fMajXTick;
    protected double fMajYTick;
    protected double fLogXBase;
    protected double fLogYBase;
    protected boolean fLogTickSpacing;
    protected boolean fPiXTickSpacing;
    protected boolean fPiYTickSpacing;
    protected boolean fValid = true;
    protected Color fBackgroundColor = Color.white;
    protected Color fForegroundColor = Color.black;
    protected Color fTickLabelColor = Color.black;
    protected Color fGridColor = new Color(200, 200, 200);
    protected Font fTickFont = new Font("Helvetica", 0, 9);
    protected FontMetrics fTickMetrics = this.getFontMetrics(this.fTickFont);
    protected boolean fShowLabels = true;
    protected int fOriginX = 0;
    protected int fOriginY = 0;
    protected int fminXPxl = 0;
    protected int fmaxXPxl = 1;
    protected int fminYPxl = 0;
    protected int fmaxYPxl = 1;
    protected double fMinX = 0.0;
    protected double fMinY = 0.0;
    protected double fMaxX = 1.0;
    protected double fMaxY = 1.0;
    protected double fPixelsPerXUnit = 0.0;
    protected double fPixelsPerYUnit = 0.0;
    protected boolean fLogX;
    protected boolean fLogY;
    protected boolean fLogMode;
    protected static final Color kRegColor = Color.green;
    protected static final int kRegLeft = 3;
    protected static final int kRegTop = 3;
    protected static final int kRegWidth = 80;
    protected static final int kRegHeight = 11;
    protected static Font fRegFont = new Font("Helvetica", 0, 9);
    protected static boolean fRegOn = true;
    protected static String fRegString = "";
    public static final int kMaxY = 2000;
    protected TextField fMinXField;
    protected TextField fMaxXField;
    protected TextField fMinYField;
    protected TextField fMaxYField;
    protected boolean fQuickRescaleEnabled;
    protected boolean fShowGridLines;
    public boolean fShowAnchors;
    private boolean fAutoColor;
    public static final int kShowAll = 0;
    public static final int kHideAll = 1;
    public static final int kHideRecent = 2;
    private int fShowTransformMode = 1;
    protected boolean fPolarMode;
    private boolean fAllowPolars;
    private boolean fAllowLogs;
    protected String fXLabel = "";
    protected String fYLabel = "";
    private Image fYLabelImage = null;
    private GraphVariables fVariables;
    protected int fCurrentVar;
    public char gIndepChar = (char)120;
    public char gDepChar = (char)121;
    private static final int kBrokenSpace = 10;
    private static final int kBrokenDelta = 3;
    private static final int kBrokenTotal = 19;
    private int aXAxisLoc;
    private int aYAxisLoc;
    private boolean aYLabelsOnLeft;
    private boolean aXLabelsOnBottom;
    private boolean aXAxisBroken;
    private boolean aYAxisBroken;
    protected String fInvalidStr = "";

    public FPAxesShell(double d, double d2, double d3, double d4, double d5, double d6, Grapher grapher) {
        this.setLayout(null);
        this.fGrapher = grapher;
        this.fMinX = d;
        this.fMinY = d3;
        this.fMaxX = d2;
        this.fMaxY = d4;
        this.fMajXTick = d5;
        this.fMajYTick = d5;
        this.fMinXField = new TextField();
        this.add(this.fMinXField);
        this.fMaxXField = new TextField();
        this.add(this.fMaxXField);
        this.fMinYField = new TextField();
        this.add(this.fMinYField);
        this.fMaxYField = new TextField();
        this.add(this.fMaxYField);
        this.fMinXField.setVisible(false);
        this.fMaxXField.setVisible(false);
        this.fMinYField.setVisible(false);
        this.fMaxYField.setVisible(false);
        this.fVariables = new GraphVariables();
    }

    public void polarMode(boolean bl) {
        this.fPolarMode = bl;
        this.fGrapher.toolbar().setUpPositions();
    }

    public boolean polarMode() {
        return this.fPolarMode;
    }

    public void logMode(boolean bl) {
        this.fLogMode = bl;
    }

    public boolean logMode() {
        return this.fLogMode;
    }

    public void allowPolars(boolean bl) {
        this.fAllowPolars = bl;
    }

    public boolean allowPolars() {
        return this.fAllowPolars;
    }

    public void allowLogs(boolean bl) {
        this.fAllowLogs = bl;
    }

    public boolean allowLogs() {
        return this.fAllowLogs;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        int n5 = 80;
        int n6 = 16;
        int n7 = 15;
        if (this.fPixelsPerXUnit != 0.0 && this.fPixelsPerYUnit != 0.0) {
            double d = (this.fMaxX + this.fMinX) / 2.0;
            double d2 = (this.fMaxY + this.fMinY) / 2.0;
            this.minXNoLog(d - (double)n3 / (2.0 * this.fPixelsPerXUnit));
            this.maxXNoLog(d + (double)n3 / (2.0 * this.fPixelsPerXUnit));
            this.minYNoLog(d2 - (double)n4 / (2.0 * this.fPixelsPerYUnit));
            this.maxYNoLog(d2 + (double)n4 / (2.0 * this.fPixelsPerYUnit));
        }
        super.setBounds(n, n2, n3, n4);
        this.fWidth = n3;
        this.fHeight = n4;
        this.fMinXField.setBounds(n7, n4 / 2 - n6 / 2, n5, n6);
        this.fMaxXField.setBounds(n3 - n5 - n7, n4 / 2 - n6 / 2, n5, n6);
        this.fMaxYField.setBounds(n3 / 2 - n5 / 2, n7, n5, n6);
        this.fMinYField.setBounds(n3 / 2 - n5 / 2, n4 - n6 - n7, n5, n6);
        this.createImages(n3, n4);
        this.setUpAxes();
    }

    public void loadBackdrop() {
        FileDialog fileDialog = new FileDialog((Frame)this.fGrapher, fp_resource.getString("str_load_gif_file"), 0);
        fileDialog.setFilenameFilter(new GIFFileFilter());
        ((Component)fileDialog).setVisible(true);
        String string = fileDialog.getFile();
        if (string == null) {
            return;
        }
        this.fBackdropImage = utils.loadImageFile(String.valueOf(fileDialog.getDirectory()) + string);
        int n = 0;
        while (this.fBackdropImage.getHeight(this) < 0) {
            if (++n > 5) break;
            utils.pause(100);
        }
    }

    public void backdropImage(Image image) {
        this.fBackdropImage = image;
    }

    public Image backdropImage() {
        return this.fBackdropImage;
    }

    public void clearBackdrop() {
        this.fBackdropImage = null;
    }

    public void setUpAxes() {
        if (this.getSize().width == 0) {
            return;
        }
        this.fOriginX = -((int)((double)this.fWidth * this.fMinX / (this.fMaxX - this.fMinX)));
        this.fPixelsPerXUnit = (double)(this.fWidth - 1) / (this.fMaxX - this.fMinX);
        this.fOriginY = this.fHeight + (int)((double)this.fHeight * this.fMinY / (this.fMaxY - this.fMinY));
        this.fPixelsPerYUnit = (double)(this.fHeight - 1) / (this.fMaxY - this.fMinY);
        this.fminXPxl = 0;
        this.fmaxXPxl = this.fWidth;
        this.fminYPxl = this.fHeight;
        this.fmaxYPxl = 0;
    }

    public void createImages(int n, int n2) {
        this.fBackgroundImage = this.createImage(n, n2);
        this.fBackgroundGraphics = this.fBackgroundImage.getGraphics();
        this.fForegroundImage = this.createImage(n, n2);
        this.fForegroundGraphics = this.fForegroundImage.getGraphics();
    }

    public int x2pxlSuppressLog(double d) {
        return this.fOriginX + (int)(d * this.fPixelsPerXUnit + 0.5);
    }

    public int y2pxlSuppressLog(double d) {
        double d2 = this.fOriginY - (int)(d * this.fPixelsPerYUnit + 0.5);
        if (d2 > 2000.0) {
            return 2000;
        }
        if (d2 < -2000.0) {
            return -2000;
        }
        return (int)d2;
    }

    public int x2pxl(double d) {
        if (d == -1.23456123) {
            return 0;
        }
        if (this.fLogX) {
            if (d <= 0.0) {
                return 0;
            }
            return this.fOriginX + (int)(utils.log(d, this.fLogXBase) * this.fPixelsPerXUnit + 0.5);
        }
        return this.fOriginX + (int)(d * this.fPixelsPerXUnit + 0.5);
    }

    public int y2pxl(double d) {
        double d2;
        if (d == -1.23456123) {
            return 0;
        }
        if (this.fLogY) {
            if (d <= 0.0) {
                return this.fHeight;
            }
            d2 = this.fOriginY - (int)(utils.log(d, this.fLogYBase) * this.fPixelsPerYUnit + 0.5);
        } else {
            d2 = this.fOriginY - (int)(d * this.fPixelsPerYUnit + 0.5);
        }
        if (d2 > 2000.0) {
            return 2000;
        }
        if (d2 < -2000.0) {
            return -2000;
        }
        return (int)d2;
    }

    public double pxl2xSuppressLog(int n) {
        return (double)(n - this.fOriginX) / this.fPixelsPerXUnit;
    }

    public double pxl2ySuppressLog(int n) {
        return (double)(this.fOriginY - n) / this.fPixelsPerYUnit;
    }

    public double pxl2xDelta(int n) {
        return (double)n / this.fPixelsPerXUnit;
    }

    public double pxl2yDelta(int n) {
        return (double)n / this.fPixelsPerYUnit;
    }

    public int x2pxlDelta(double d) {
        return (int)(this.fPixelsPerXUnit * d);
    }

    public int y2pxlDelta(double d) {
        return (int)(this.fPixelsPerYUnit * d);
    }

    public double pxl2x(int n) {
        if (this.fLogX) {
            return Math.pow(this.fLogXBase, (double)(n - this.fOriginX) / this.fPixelsPerXUnit);
        }
        return (double)(n - this.fOriginX) / this.fPixelsPerXUnit;
    }

    public double pxl2y(int n) {
        if (this.fLogY) {
            return Math.pow(this.fLogYBase, (double)(this.fOriginY - n) / this.fPixelsPerYUnit);
        }
        return (double)(this.fOriginY - n) / this.fPixelsPerYUnit;
    }

    public boolean logX() {
        return this.fLogX;
    }

    public boolean logY() {
        return this.fLogY;
    }

    public void logX(boolean bl) {
        this.fLogX = bl;
    }

    public void logY(boolean bl) {
        this.fLogY = bl;
    }

    public double minYNoLog() {
        return this.fMinY;
    }

    public double minXNoLog() {
        return this.fMinX;
    }

    public double maxYNoLog() {
        return this.fMaxY;
    }

    public double maxXNoLog() {
        return this.fMaxX;
    }

    public void minXNoLog(double d) {
        this.fMinX = d;
        if (!this.fLogX) {
            this.xMajTick(utils.getTickSpacingEstimate(this.fMinX, this.fMaxX));
        }
    }

    public void maxXNoLog(double d) {
        this.fMaxX = d;
        if (!this.fLogX) {
            this.xMajTick(utils.getTickSpacingEstimate(this.fMinX, this.fMaxX));
        }
    }

    public void minYNoLog(double d) {
        this.fMinY = d;
        if (!this.fLogY) {
            this.yMajTick(utils.getTickSpacingEstimate(this.fMinY, this.fMaxY));
        }
    }

    public void maxYNoLog(double d) {
        this.fMaxY = d;
        if (!this.fLogY) {
            this.yMajTick(utils.getTickSpacingEstimate(this.fMinY, this.fMaxY));
        }
    }

    public double minY() {
        if (this.fLogY) {
            return Math.pow(this.fLogYBase, this.fMinY);
        }
        return this.fMinY;
    }

    public double minX() {
        if (this.fLogX) {
            return Math.pow(this.fLogXBase, this.fMinX);
        }
        return this.fMinX;
    }

    public double maxY() {
        if (this.fLogY) {
            return Math.pow(this.fLogYBase, this.fMaxY);
        }
        return this.fMaxY;
    }

    public double maxX() {
        if (this.fLogX) {
            return Math.pow(this.fLogXBase, this.fMaxX);
        }
        return this.fMaxX;
    }

    public double pixelsPerXUnit() {
        return this.fPixelsPerXUnit;
    }

    public double pixelsPerYUnit() {
        return this.fPixelsPerYUnit;
    }

    public double xMajTick() {
        return this.fMajXTick;
    }

    public double yMajTick() {
        return this.fMajYTick;
    }

    public void minX(double d) {
        if (this.fLogX) {
            this.fMinX = utils.log(d, this.fLogXBase);
        } else {
            this.fMinX = d;
            this.xMajTick(utils.getTickSpacingEstimate(this.fMinX, this.fMaxX));
        }
    }

    public void minY(double d) {
        if (this.fLogY) {
            this.fMinY = utils.log(d, this.fLogYBase);
        } else {
            this.fMinY = d;
            this.yMajTick(utils.getTickSpacingEstimate(this.fMinY, this.fMaxY));
        }
    }

    public void maxX(double d) {
        if (this.fLogX) {
            this.fMaxX = utils.log(d, this.fLogXBase);
        } else {
            this.fMaxX = d;
            this.xMajTick(utils.getTickSpacingEstimate(this.fMinX, this.fMaxX));
        }
    }

    public void maxY(double d) {
        if (this.fLogY) {
            this.fMaxY = utils.log(d, this.fLogYBase);
        } else {
            this.fMaxY = d;
            this.yMajTick(utils.getTickSpacingEstimate(this.fMinY, this.fMaxY));
        }
    }

    public void xMajTick(double d) {
        this.fMajXTick = d;
    }

    public void yMajTick(double d) {
        this.fMajYTick = d;
    }

    public boolean inYRange(double d) {
        return d <= this.fMaxY && d >= this.fMinY;
    }

    public boolean inXRange(double d) {
        return d <= this.fMaxX && d >= this.fMinX;
    }

    public void setColors(Color color, Color color2, Color color3) {
        this.fBackgroundColor = color;
        this.fForegroundColor = color2;
        this.fTickLabelColor = color3;
    }

    public void setColors(Color color, Color color2, Color color3, Color color4) {
        this.fBackgroundColor = color;
        this.fForegroundColor = color2;
        this.fTickLabelColor = color3;
        this.fGridColor = color4;
    }

    public void xLabel(String string, String string2) {
        this.fXLabel = string.length() > 0 ? (string2.length() > 0 ? String.valueOf(string) + " (" + string2 + ")" : string) : "";
    }

    public void yLabel(String string, String string2) {
        this.fYLabelImage = null;
        if (string.length() > 0) {
            this.fYLabel = string2.length() > 0 ? String.valueOf(string) + " (" + string2 + ")" : string;
        } else {
            this.fYLabel = "";
            return;
        }
        int n = this.fTickMetrics.stringWidth(this.fYLabel);
        int n2 = 18;
        Image image = this.createImage(n, n2);
        Graphics graphics = image.getGraphics();
        graphics.setFont(this.fTickFont);
        graphics.drawString(this.fYLabel, 0, n2 - 3);
        int[] nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return;
        }
        this.fYLabelImage = this.createImage(new FilteredImageSource(this.createImage(new MemoryImageSource(n2, n, utils.rot90Pixels(nArray, n, n2), 0, n2)).getSource(), new TransparentFilter()));
    }

    protected void drawAxisLabels(Graphics graphics) {
        int n = this.aXAxisLoc;
        int n2 = this.aYAxisLoc;
        graphics.setColor(Color.black);
        graphics.setFont(this.fTickFont);
        int n3 = this.fTickMetrics.stringWidth(this.fXLabel);
        int n4 = this.fTickMetrics.stringWidth(this.fYLabel);
        int n5 = 18;
        int n6 = 0;
        if (!this.aXLabelsOnBottom) {
            n6 = -3 * n5 / 2 - n5 - 4;
        }
        int n7 = 0;
        if (!this.aYLabelsOnLeft) {
            n7 = 3 * n5;
        }
        graphics.drawString(this.fXLabel, (this.getSize().width * 3 / 2 - n3) / 2, n + 3 * n5 / 2 + n6);
        if (this.fYLabelImage != null) {
            graphics.drawImage(this.fYLabelImage, n2 - 2 * n5 + n7, (this.getSize().height / 2 - this.fYLabelImage.getHeight(this)) / 2, this);
        }
    }

    public void drawPolarGridLines(Graphics graphics) {
        int n = this.x2pxl(0.0);
        int n2 = this.y2pxl(0.0);
        double d = this.fMaxY;
        if (this.fMaxX > d) {
            d = this.fMaxX;
        }
        if (Math.abs(this.fMinX) > d) {
            d = Math.abs(this.fMinX);
        }
        if (Math.abs(this.fMinY) > d) {
            d = Math.abs(this.fMinY);
        }
        d *= 1.5;
        graphics.setColor(this.fGridColor);
        if (this.fShowGridLines) {
            double d2 = this.fMajXTick;
            while (d2 <= d) {
                int n3 = this.x2pxl(d2) - n;
                int n4 = n2 - this.y2pxl(d2);
                graphics.drawOval(n - n3, n2 - n4, 2 * n3, 2 * n4);
                d2 += this.fMajXTick;
            }
        }
        this.drawAxisLines(graphics);
    }

    private void checkIfAxesOffscreen() {
        this.aYLabelsOnLeft = true;
        this.aXLabelsOnBottom = true;
        this.aXAxisBroken = false;
        this.aYAxisBroken = false;
        this.aYAxisLoc = this.x2pxlSuppressLog(0.0);
        if (this.aYAxisLoc < -1) {
            this.aYLabelsOnLeft = false;
            this.aXAxisBroken = true;
            this.aYAxisLoc = 1;
        } else if (this.aYAxisLoc < 15) {
            this.aYLabelsOnLeft = false;
        } else if (this.aYAxisLoc > this.getSize().width - 2) {
            if (this.aYAxisLoc > this.getSize().width) {
                this.aXAxisBroken = true;
            }
            this.aYAxisLoc = this.getSize().width - 2;
        }
        this.aXAxisLoc = this.y2pxlSuppressLog(0.0);
        if (this.aXAxisLoc < -1) {
            this.aYAxisBroken = true;
            this.aXAxisLoc = 1;
        } else if (this.aXAxisLoc > this.getSize().height - 2) {
            this.aXLabelsOnBottom = false;
            if (this.aXAxisLoc > this.getSize().height) {
                this.aYAxisBroken = true;
            }
            this.aXAxisLoc = this.getSize().height - 2;
        } else if (this.aXAxisLoc > this.getSize().height - 15) {
            this.aXLabelsOnBottom = false;
        }
    }

    private void drawAxisLines(Graphics graphics) {
        int n = 10;
        int n2 = 3;
        graphics.setColor(Color.black);
        if (!this.aYAxisBroken) {
            graphics.drawLine(this.aYAxisLoc, 0, this.aYAxisLoc, this.getSize().height);
        } else if (this.aXLabelsOnBottom) {
            graphics.drawLine(this.aYAxisLoc, 0, this.aYAxisLoc, n);
            graphics.drawLine(this.aYAxisLoc, n, this.aYAxisLoc + n, n + n2);
            graphics.drawLine(this.aYAxisLoc + n, n + n2, this.aYAxisLoc - n, n + 2 * n2);
            graphics.drawLine(this.aYAxisLoc - n, n + 2 * n2, this.aYAxisLoc, n + 3 * n2);
            graphics.drawLine(this.aYAxisLoc, n + 3 * n2, this.aYAxisLoc, this.getSize().height);
        } else {
            graphics.drawLine(this.aYAxisLoc, 0, this.aYAxisLoc, this.getSize().height - n - 3 * n2);
            graphics.drawLine(this.aYAxisLoc, this.getSize().height - n - 3 * n2, this.aYAxisLoc + n, this.getSize().height - n - 2 * n2);
            graphics.drawLine(this.aYAxisLoc + n, this.getSize().height - n - 2 * n2, this.aYAxisLoc - n, this.getSize().height - n - n2);
            graphics.drawLine(this.aYAxisLoc - n, this.getSize().height - n - n2, this.aYAxisLoc, this.getSize().height - n);
            graphics.drawLine(this.aYAxisLoc, this.getSize().height - n, this.aYAxisLoc, this.getSize().height);
        }
        if (!this.aXAxisBroken) {
            graphics.drawLine(this.fminXPxl, this.aXAxisLoc, this.fmaxXPxl, this.aXAxisLoc);
        } else if (this.aYLabelsOnLeft) {
            graphics.drawLine(0, this.aXAxisLoc, this.getSize().width - n - 3 * n2, this.aXAxisLoc);
            graphics.drawLine(this.getSize().width - n - 3 * n2, this.aXAxisLoc, this.getSize().width - n - 2 * n2, this.aXAxisLoc - n);
            graphics.drawLine(this.getSize().width - n - 2 * n2, this.aXAxisLoc - n, this.getSize().width - n - n2, this.aXAxisLoc + n);
            graphics.drawLine(this.getSize().width - n - n2, this.aXAxisLoc + n, this.getSize().width - n, this.aXAxisLoc);
            graphics.drawLine(this.getSize().width - n, this.aXAxisLoc, this.getSize().width, this.aXAxisLoc);
        } else {
            graphics.drawLine(0, this.aXAxisLoc, n, this.aXAxisLoc);
            graphics.drawLine(n, this.aXAxisLoc, n + n2, this.aXAxisLoc + n);
            graphics.drawLine(n + n2, this.aXAxisLoc + n, n + 2 * n2, this.aXAxisLoc - n);
            graphics.drawLine(n + 2 * n2, this.aXAxisLoc - n, n + 3 * n2, this.aXAxisLoc);
            graphics.drawLine(n + 3 * n2, this.aXAxisLoc, this.getSize().width, this.aXAxisLoc);
        }
        int n3 = 0;
        while (n3 <= 4) {
            graphics.drawLine(this.aYAxisLoc - n3, this.fminYPxl - n3, this.aYAxisLoc + n3, this.fminYPxl - n3);
            graphics.drawLine(this.aYAxisLoc - n3, this.fmaxYPxl + n3, this.aYAxisLoc + n3, this.fmaxYPxl + n3);
            graphics.drawLine(this.fminXPxl + n3, this.aXAxisLoc - n3, this.fminXPxl + n3, this.aXAxisLoc + n3);
            graphics.drawLine(this.fmaxXPxl - n3, this.aXAxisLoc - n3, this.fmaxXPxl - n3, this.aXAxisLoc + n3);
            ++n3;
        }
    }

    private int numTicks(double d, double d2, double d3) {
        if (d3 <= 0.0) {
            return 10000;
        }
        return (int)((d2 - d) / d3);
    }

    private void drawRegXLines(Graphics graphics) {
        int n = this.aXAxisLoc;
        if (this.piXTickSpacing()) {
            this.fMajXTick *= Math.PI;
        }
        graphics.setColor(this.fGridColor);
        double d = utils.findMin(this.fMinX, this.fMajXTick);
        int n2 = this.fminYPxl;
        int n3 = this.fmaxYPxl;
        double d2 = d;
        while (d2 <= this.fMaxX) {
            int n4 = this.x2pxlSuppressLog(d2);
            if (!(this.aXAxisBroken && !this.aYLabelsOnLeft && n4 < 19 || this.aXAxisBroken && this.aYLabelsOnLeft && n4 > this.getSize().width - 19)) {
                graphics.drawLine(n4, n2, n4, n3);
            }
            d2 += this.fMajXTick;
        }
        graphics.setColor(Color.black);
        double d3 = this.fMajXTick / 10.0;
        if (this.fLogX && this.fLogXBase == (double)((int)this.fLogXBase)) {
            d3 = this.fMajXTick / this.fLogXBase;
        }
        double d4 = d = utils.findMin(this.fMinX, d3);
        while (d4 <= this.fMaxX) {
            int n5 = this.x2pxlSuppressLog(d4);
            if (!(this.aXAxisBroken && !this.aYLabelsOnLeft && n5 < 19 || this.aXAxisBroken && this.aYLabelsOnLeft && n5 > this.getSize().width - 19)) {
                graphics.drawLine(n5, n - 1, n5, n + 1);
            }
            d4 += d3;
        }
        if (this.piXTickSpacing()) {
            this.fMajXTick /= Math.PI;
        }
    }

    private void drawRegYLines(Graphics graphics) {
        int n = this.aYAxisLoc;
        if (this.piYTickSpacing()) {
            this.fMajYTick *= Math.PI;
        }
        graphics.setColor(this.fGridColor);
        double d = utils.findMin(this.fMinY, this.fMajYTick);
        int n2 = this.fminXPxl;
        int n3 = this.fmaxXPxl;
        double d2 = d;
        while (d2 <= this.fMaxY) {
            int n4 = this.y2pxlSuppressLog(d2);
            if (!(this.aYAxisBroken && this.aXLabelsOnBottom && n4 < 19 || this.aYAxisBroken && !this.aXLabelsOnBottom && n4 > this.getSize().height - 19)) {
                graphics.drawLine(n2, n4, n3, n4);
            }
            d2 += this.fMajYTick;
        }
        graphics.setColor(Color.black);
        double d3 = this.fMajYTick / 10.0;
        if (this.fLogY && this.fLogYBase == (double)((int)this.fLogYBase)) {
            d3 = this.fMajYTick / this.fLogYBase;
        }
        double d4 = d = utils.findMin(this.fMinY, d3);
        while (d4 <= this.fMaxY) {
            int n5 = this.y2pxlSuppressLog(d4);
            if (!(this.aYAxisBroken && this.aXLabelsOnBottom && n5 < 19 || this.aYAxisBroken && !this.aXLabelsOnBottom && n5 > this.getSize().height - 19)) {
                graphics.drawLine(n - 1, n5, n + 1, n5);
            }
            d4 += d3;
        }
        if (this.piYTickSpacing()) {
            this.fMajYTick /= Math.PI;
        }
    }

    private void drawLogXLines(Graphics graphics) {
        double d;
        int n = this.aXAxisLoc;
        double d2 = 0.1;
        if (this.fLogXBase == (double)((int)this.fLogXBase)) {
            d2 = 1.0 / this.fLogXBase;
        } else if (this.fLogXBase == Math.E) {
            d2 = 1.0;
        }
        double d3 = d = utils.findMin(this.fMinX, 1.0);
        while (d3 <= this.fMaxX) {
            double d4 = d2;
            while (d4 <= 1.0) {
                int n2 = this.x2pxlSuppressLog(d3 + utils.log(d4, this.fLogXBase));
                if (!(this.aXAxisBroken && !this.aYLabelsOnLeft && n2 < 19 || this.aXAxisBroken && this.aYLabelsOnLeft && n2 > this.getSize().width - 19)) {
                    graphics.setColor(this.fGridColor);
                    graphics.drawLine(n2, 0, n2, this.fHeight);
                    graphics.setColor(this.fTickLabelColor);
                    graphics.drawLine(n2, n - 1, n2, n + 1);
                }
                d4 += d2;
            }
            d3 += 1.0;
        }
    }

    private void drawLogYLines(Graphics graphics) {
        double d;
        int n = this.aYAxisLoc;
        double d2 = 0.1;
        if (this.fLogYBase == (double)((int)this.fLogYBase)) {
            d2 = 1.0 / this.fLogYBase;
        } else if (this.fLogYBase == Math.E) {
            d2 = 1.0;
        }
        double d3 = d = utils.findMin(this.fMinY, 1.0);
        while (d3 <= this.fMaxY) {
            double d4 = d2;
            while (d4 <= 1.0) {
                int n2 = this.y2pxlSuppressLog(d3 + utils.log(d4, this.fLogYBase));
                if (!(this.aYAxisBroken && this.aXLabelsOnBottom && n2 < 19 || this.aYAxisBroken && !this.aXLabelsOnBottom && n2 > this.getSize().height - 19)) {
                    graphics.setColor(this.fGridColor);
                    graphics.drawLine(0, n2, this.fWidth, n2);
                    graphics.setColor(this.fTickLabelColor);
                    graphics.drawLine(n - 1, n2, n + 1, n2);
                }
                d4 += d2;
            }
            d3 += 1.0;
        }
    }

    public void drawGridLines(Graphics graphics) {
        this.checkIfAxesOffscreen();
        if (this.polarMode()) {
            this.drawPolarGridLines(graphics);
            return;
        }
        if (this.fLogX && this.fLogTickSpacing) {
            this.drawLogXLines(graphics);
        } else {
            this.drawRegXLines(graphics);
        }
        if (this.fLogY && this.fLogTickSpacing) {
            this.drawLogYLines(graphics);
        } else {
            this.drawRegYLines(graphics);
        }
    }

    private void drawRegXLabels(Graphics graphics) {
        int n = this.aXAxisLoc;
        if (this.piXTickSpacing()) {
            double d;
            double d2 = d = utils.findMin(this.fMinX, this.fMajXTick * Math.PI);
            while (d2 <= this.fMaxX) {
                int n2 = this.x2pxlSuppressLog(d2);
                if (!(this.aXAxisBroken && !this.aYLabelsOnLeft && n2 < 19 || this.aXAxisBroken && this.aYLabelsOnLeft && n2 > this.getSize().width - 19)) {
                    graphics.drawLine(n2, n - 1, n2, n + 1);
                    String string = utils.num2str(d2 / Math.PI);
                    String string2 = string.equals("1") ? "P" : (string.equals("-1") ? "-P" : String.valueOf(utils.num2str(d2 / Math.PI)) + "P");
                    if (Math.abs(d2) > 1.0E-6) {
                        if (this.aXLabelsOnBottom) {
                            utils.drawSpecialString(graphics, string2, n2 - (int)((double)this.fTickMetrics.stringWidth(string2) / 2.0), n + 15, this.fTickMetrics);
                        } else {
                            utils.drawSpecialString(graphics, string2, n2, n - 5, this.fTickMetrics);
                        }
                    }
                }
                d2 += this.fMajXTick * Math.PI;
            }
        } else {
            double d;
            int n3 = utils.getPower(this.fMinX);
            int n4 = utils.getPower(this.fMaxX);
            if (n4 > n3) {
                n3 = n4;
            }
            double d3 = d = utils.findMin(this.fMinX, this.fMajXTick);
            while (d3 <= this.fMaxX) {
                int n5 = this.x2pxlSuppressLog(d3);
                if (!(this.aXAxisBroken && !this.aYLabelsOnLeft && n5 < 19 || this.aXAxisBroken && this.aYLabelsOnLeft && n5 > this.getSize().width - 19)) {
                    graphics.drawLine(n5, n - 1, n5, n + 1);
                    String string = utils.getTickString(d3, n3);
                    if (Math.abs(d3) > 1.0E-6) {
                        if (this.aXLabelsOnBottom) {
                            graphics.drawString(string, n5 - (int)((double)this.fTickMetrics.stringWidth(string) / 2.0), n + 15);
                        } else {
                            graphics.drawString(string, n5, n - 5);
                        }
                    }
                }
                d3 += this.fMajXTick;
            }
            if (n3 > 2 || n3 <= -2) {
                int n6 = this.getSize().width - 25;
                int n7 = this.aXLabelsOnBottom ? n + 28 : n - 15;
                graphics.drawString("x10", n6, n7);
                graphics.drawString(String.valueOf(n3), n6 + this.fTickMetrics.stringWidth("x10"), n7 - 6);
            }
        }
    }

    private void drawRegYLabels(Graphics graphics) {
        int n = this.aYAxisLoc;
        if (this.piYTickSpacing()) {
            double d;
            double d2 = d = utils.findMin(this.fMinY, this.fMajYTick * Math.PI);
            while (d2 <= this.fMaxY) {
                int n2 = this.y2pxlSuppressLog(d2);
                if (!(this.aYAxisBroken && this.aXLabelsOnBottom && n2 < 19 || this.aYAxisBroken && !this.aXLabelsOnBottom && n2 > this.getSize().height - 19)) {
                    graphics.drawLine(n - 1, n2, n + 1, n2);
                    String string = utils.num2str(d2 / Math.PI);
                    String string2 = string.equals("1") ? "P" : (string.equals("-1") ? "-P" : String.valueOf(utils.num2str(d2 / Math.PI)) + "P");
                    if (Math.abs(d2) > 1.0E-6) {
                        if (this.aYLabelsOnLeft) {
                            utils.drawSpecialString(graphics, string2, n - 2 - this.fTickMetrics.stringWidth(string2), n2 + 4, this.fTickMetrics);
                        } else {
                            utils.drawSpecialString(graphics, string2, n + 4, n2 + 4, this.fTickMetrics);
                        }
                    }
                }
                d2 += this.fMajYTick * Math.PI;
            }
        } else {
            double d;
            int n3 = utils.getPower(this.fMinY);
            int n4 = utils.getPower(this.fMaxY);
            if (n4 > n3) {
                n3 = n4;
            }
            double d3 = d = utils.findMin(this.fMinY, this.fMajYTick);
            while (d3 <= this.fMaxY) {
                int n5 = this.y2pxlSuppressLog(d3);
                if (!(this.aYAxisBroken && this.aXLabelsOnBottom && n5 < 19 || this.aYAxisBroken && !this.aXLabelsOnBottom && n5 > this.getSize().height - 19)) {
                    graphics.drawLine(n - 1, n5, n + 1, n5);
                    String string = utils.getTickString(d3, n3);
                    if (Math.abs(d3) > 1.0E-6) {
                        if (this.aYLabelsOnLeft) {
                            graphics.drawString(string, n - 2 - this.fTickMetrics.stringWidth(string), n5 + 4);
                        } else {
                            graphics.drawString(string, n + 4, n5 + 4);
                        }
                    }
                }
                d3 += this.fMajYTick;
            }
            if (n3 > 2 || n3 <= -2) {
                int n6 = 25;
                int n7 = this.aYLabelsOnLeft ? n - 28 : n + 15;
                graphics.drawString("x10", n7, n6);
                graphics.drawString(String.valueOf(n3), n7 + this.fTickMetrics.stringWidth("x10"), n6 - 6);
            }
        }
    }

    private void drawLogXLabels(Graphics graphics) {
        double d;
        int n = this.aXAxisLoc;
        double d2 = this.fMajXTick;
        if (this.fLogTickSpacing) {
            d2 = 1.0;
        }
        double d3 = d = utils.findMin(this.fMinX, d2);
        while (d3 <= this.fMaxX) {
            int n2 = this.x2pxlSuppressLog(d3);
            if (!(this.aXAxisBroken && !this.aYLabelsOnLeft && n2 < 19 || this.aXAxisBroken && this.aYLabelsOnLeft && n2 > this.getSize().width - 19)) {
                graphics.drawLine(n2, n - 1, n2, n + 1);
                String string = d3 == (double)((int)d3) ? String.valueOf((int)d3) : utils.num2str(d3);
                int n3 = 0;
                if (!this.aXLabelsOnBottom) {
                    n3 = -24;
                }
                graphics.drawString(utils.num2str(this.fLogXBase), n2 - (int)((double)this.fTickMetrics.stringWidth(string) / 2.0) - this.fTickMetrics.stringWidth(utils.num2str(this.fLogXBase)) + 3, n + 19 + n3);
                graphics.drawString(string, n2 - (int)((double)this.fTickMetrics.stringWidth(string) / 2.0) + 3, n + 15 + n3);
            }
            d3 += d2;
        }
    }

    private void drawLogYLabels(Graphics graphics) {
        double d;
        int n = this.aYAxisLoc;
        double d2 = this.fMajYTick;
        if (this.fLogTickSpacing) {
            d2 = 1.0;
        }
        double d3 = d = utils.findMin(this.fMinY, d2);
        while (d3 <= this.fMaxY) {
            int n2 = this.y2pxlSuppressLog(d3);
            if (!(this.aYAxisBroken && this.aXLabelsOnBottom && n2 < 19 || this.aYAxisBroken && !this.aXLabelsOnBottom && n2 > this.getSize().height - 19)) {
                graphics.drawLine(n - 1, n2, n + 1, n2);
                String string = d3 == (double)((int)d3) ? String.valueOf((int)d3) : utils.num2str(d3);
                if (this.aYLabelsOnLeft) {
                    graphics.drawString(utils.num2str(this.fLogYBase), n - 2 - this.fTickMetrics.stringWidth(String.valueOf(string) + utils.num2str(this.fLogYBase)), n2 + 8);
                    graphics.drawString(string, n - 2 - this.fTickMetrics.stringWidth(string), n2 + 4);
                } else {
                    graphics.drawString(utils.num2str(this.fLogYBase), n + 4, n2 + 8);
                    graphics.drawString(string, n + 4 + this.fTickMetrics.stringWidth(utils.num2str(this.fLogYBase)), n2 + 4);
                }
            }
            d3 += d2;
        }
    }

    protected void drawTickLabels(Graphics graphics) {
        int n = this.aYAxisLoc;
        int n2 = this.aXAxisLoc;
        if (!this.fShowLabels) {
            return;
        }
        graphics.setFont(this.fTickFont);
        graphics.setColor(Color.black);
        if (this.fLogX) {
            this.drawLogXLabels(graphics);
        } else {
            this.drawRegXLabels(graphics);
        }
        if (this.fLogY) {
            this.drawLogYLabels(graphics);
        } else {
            this.drawRegYLabels(graphics);
        }
        this.drawAxisLines(graphics);
    }

    public void autoColor(boolean bl) {
        this.fAutoColor = bl;
    }

    public boolean autoColor() {
        return this.fAutoColor;
    }

    public void showTransform(int n) {
        this.fShowTransformMode = n;
    }

    public int showTransform() {
        return this.fShowTransformMode;
    }

    public void showGridLines(boolean bl) {
        this.fShowGridLines = bl;
    }

    public boolean showGridLines() {
        return this.fShowGridLines;
    }

    public void quickRescale(boolean bl) {
        this.fMinXField.setVisible(false);
        this.fMaxXField.setVisible(false);
        this.fMinYField.setVisible(false);
        this.fMaxYField.setVisible(false);
        this.fQuickRescaleEnabled = bl;
    }

    public boolean quickRescale() {
        return this.fQuickRescaleEnabled;
    }

    protected void drawRescales(Graphics graphics) {
        if (!this.fQuickRescaleEnabled) {
            return;
        }
        int n = 6;
        int n2 = 6;
        int n3 = 5;
        int n4 = this.getSize().width;
        int n5 = this.getSize().height;
        graphics.setColor(Color.lightGray);
        graphics.fillRect(n3, n5 / 2 - n2 / 2, n, n2);
        graphics.fillRect(n4 - n - n3, n5 / 2 - n2 / 2, n, n2);
        graphics.fillRect(n4 / 2 - n / 2, n3, n, n2);
        graphics.fillRect(n4 / 2 - n / 2, n5 - n2 - n3, n, n2);
        graphics.setColor(Color.black);
        graphics.drawRect(n3, n5 / 2 - n2 / 2, n, n2);
        graphics.drawRect(n4 - n - n3, n5 / 2 - n2 / 2, n, n2);
        graphics.drawRect(n4 / 2 - n / 2, n3, n, n2);
        graphics.drawRect(n4 / 2 - n / 2, n5 - n2 - n3, n, n2);
    }

    protected boolean handleRescales(int n, int n2) {
        if (!this.fQuickRescaleEnabled) {
            return false;
        }
        int n3 = 6;
        int n4 = 6;
        int n5 = 5;
        int n6 = this.getSize().width;
        int n7 = this.getSize().height;
        if (n >= n5 && n <= n5 + n3 && n2 >= n7 / 2 - n4 / 2 && n2 <= n7 / 2 + n4 / 2) {
            if (this.fMinXField.isVisible()) {
                this.fMinXField.setVisible(false);
                return true;
            }
            ((TextComponent)this.fMinXField).setText(utils.num2str(this.minX()));
            this.fMinXField.selectAll();
            this.fMinXField.setVisible(true);
            this.fMinXField.requestFocus();
            return true;
        }
        if (n >= n6 - n3 - n5 && n <= n6 - n5 && n2 >= n7 / 2 - n4 / 2 && n2 <= n7 / 2 + n4 / 2) {
            if (this.fMaxXField.isVisible()) {
                this.fMaxXField.setVisible(false);
                return true;
            }
            ((TextComponent)this.fMaxXField).setText(utils.num2str(this.maxX()));
            this.fMaxXField.selectAll();
            this.fMaxXField.setVisible(true);
            this.fMaxXField.requestFocus();
            return true;
        }
        if (n >= n6 / 2 - n3 / 2 && n <= n6 / 2 + n3 / 2 && n2 >= n5 && n2 <= n5 + n4) {
            if (this.fMaxYField.isVisible()) {
                this.fMaxYField.setVisible(false);
                return true;
            }
            ((TextComponent)this.fMaxYField).setText(utils.num2str(this.maxY()));
            this.fMaxYField.selectAll();
            this.fMaxYField.setVisible(true);
            this.fMaxYField.requestFocus();
            return true;
        }
        if (n >= n6 / 2 - n3 / 2 && n <= n6 / 2 + n3 / 2 && n2 >= n7 - n4 - n5 && n2 <= n7 - n5) {
            if (this.fMinYField.isVisible()) {
                this.fMinYField.setVisible(false);
                return true;
            }
            ((TextComponent)this.fMinYField).setText(utils.num2str(this.minY()));
            this.fMinYField.selectAll();
            this.fMinYField.setVisible(true);
            this.fMinYField.requestFocus();
            return true;
        }
        return false;
    }

    protected boolean handleAxesArrows(int n, int n2) {
        int n3 = this.aXAxisLoc;
        int n4 = this.aYAxisLoc;
        double d = this.fMinX;
        double d2 = this.fMaxX;
        double d3 = this.fMinY;
        double d4 = this.fMaxY;
        double d5 = d2 - d;
        double d6 = d4 - d3;
        if (n < this.fminXPxl + 5 && n2 > n3 - 5 && n2 < n3 + 5) {
            this.fMaxX -= 0.25 * d5;
            this.fMinX -= 0.25 * d5;
            return true;
        }
        if (n > this.fmaxXPxl - 5 && n2 > n3 - 5 && n2 < n3 + 5) {
            this.fMaxX += 0.25 * d5;
            this.fMinX += 0.25 * d5;
            return true;
        }
        if (n2 < this.fmaxYPxl + 5 && n > n4 - 5 && n < n4 + 5) {
            this.fMaxY += 0.25 * d6;
            this.fMinY += 0.25 * d6;
            return true;
        }
        if (n2 > this.fminYPxl - 5 && n > n4 - 5 && n < n4 + 5) {
            this.fMaxY -= 0.25 * d6;
            this.fMinY -= 0.25 * d6;
            return true;
        }
        return false;
    }

    public synchronized void drawAnchorLineX(Graphics graphics, double d) {
        int n = this.x2pxlSuppressLog(d);
        graphics.setColor(Color.black);
        utils.drawDashedLine(graphics, n, this.fminYPxl, n, this.fmaxYPxl);
        utils.drawDashedLine(graphics, n + 1, this.fminYPxl, n + 1, this.fmaxYPxl);
        graphics.drawImage(Grapher.kAnchorIcon, n - 8, (this.getSize().height + 16) / 2, this);
    }

    public synchronized void drawAnchorLineY(Graphics graphics, double d) {
        int n = this.y2pxlSuppressLog(d);
        graphics.setColor(Color.black);
        utils.drawDashedLine(graphics, this.fminXPxl, n, this.fmaxXPxl, n);
        utils.drawDashedLine(graphics, this.fminXPxl, n + 1, this.fmaxXPxl, n + 1);
        graphics.drawImage(Grapher.kAnchorIcon, (this.getSize().width + 16) / 2, n - 8, this);
    }

    public synchronized void drawAnchorLineXY(Graphics graphics, double d) {
        int n = this.y2pxlSuppressLog(d);
        graphics.setColor(Color.black);
        utils.drawDashedLine(graphics, this.fminXPxl, this.fminYPxl, this.fmaxXPxl, this.fmaxYPxl, 6, 6);
        utils.drawDashedLine(graphics, this.fminXPxl, this.fminYPxl + 1, this.fmaxXPxl, this.fmaxYPxl + 1, 6, 6);
        graphics.drawImage(Grapher.kAnchorIcon, this.fmaxXPxl - 32, this.fmaxYPxl + 8, this);
    }

    public void drawRegister(String string) {
        this.drawRegister(this.getGraphics(), string);
    }

    protected void drawRegister(Graphics graphics, String string) {
        if (!fRegOn) {
            return;
        }
        graphics.setColor(kRegColor);
        graphics.setFont(fRegFont);
        graphics.fillRect(3, 3, 80, 11);
        graphics.setColor(Color.black);
        graphics.drawString(string, 6, 12);
        fRegString = string;
    }

    protected void drawRegister(Graphics graphics) {
        this.drawRegister(graphics, fRegString);
    }

    public void tickLabels(boolean bl) {
        this.fShowLabels = bl;
    }

    public Grapher parent() {
        return this.fGrapher;
    }

    public GraphVariables variables() {
        return this.fVariables;
    }

    public void variables(GraphVariables graphVariables) {
        this.fVariables = graphVariables;
    }

    public void currentVarForce(int n) {
        this.fCurrentVar = n;
        this.yLabel(this.fVariables.depLabel(n), this.fVariables.depUnits(n));
        this.xLabel(this.fVariables.indepLabel(n), this.fVariables.indepUnits(n));
        this.gIndepChar = this.fVariables.indepVar(n);
        this.gDepChar = this.fVariables.depVar(n);
    }

    public void currentVar(int n) {
        if (this.fCurrentVar == n) {
            return;
        }
        this.currentVarForce(n);
    }

    public int currentVar() {
        return this.fCurrentVar;
    }

    public char indepVar(int n) {
        return this.fVariables.indepVar(n);
    }

    public char currentIndepVar() {
        return this.fVariables.indepVar(this.fCurrentVar);
    }

    public char currentDepVar() {
        return this.fVariables.depVar(this.fCurrentVar);
    }

    public boolean checkValid() {
        int n = 20;
        this.fValid = true;
        if (this.fMinX >= this.fMaxX) {
            this.fValid = false;
            this.fInvalidStr = fp_resource.getString("str_axes_min_ge_max");
        }
        if (this.fMinY >= this.fMaxY) {
            this.fValid = false;
            this.fInvalidStr = fp_resource.getString("str_axes_min_ge_max");
        }
        if (!this.fLogX && !this.fLogY) {
            if (this.fMajXTick <= 0.0) {
                this.fValid = false;
                this.fInvalidStr = fp_resource.getString("str_axes_ticks_se_zero");
            } else if ((this.fMaxX - this.fMinX) / this.fMajXTick > (double)n && !this.piXTickSpacing()) {
                this.fValid = false;
                this.fInvalidStr = fp_resource.getString("str_too_many_x_grid_lines");
            } else if ((this.fMaxX - this.fMinX) / (this.fMajXTick * Math.PI) > (double)n && this.piXTickSpacing()) {
                this.fValid = false;
                this.fInvalidStr = fp_resource.getString("str_too_many_x_grid_lines");
            }
            if (this.fMajYTick <= 0.0) {
                this.fValid = false;
                this.fInvalidStr = fp_resource.getString("str_axes_ticks_se_zero");
            } else if ((this.fMaxY - this.fMinY) / this.fMajYTick > (double)n && !this.piYTickSpacing()) {
                this.fValid = false;
                this.fInvalidStr = fp_resource.getString("str_too_many_y_grid_lines");
            } else if ((this.fMaxY - this.fMinY) / (this.fMajYTick * Math.PI) > (double)n && this.piYTickSpacing()) {
                this.fValid = false;
                this.fInvalidStr = fp_resource.getString("str_too_many_y_grid_lines");
            }
        }
        if (this.fLogX && !this.fLogTickSpacing) {
            if (this.fMajXTick <= 0.0) {
                this.fValid = false;
                this.fInvalidStr = fp_resource.getString("str_axes_ticks_se_zero");
            } else if ((this.fMaxX - this.fMinX) / this.fMajXTick > (double)n) {
                this.fValid = false;
                this.fInvalidStr = fp_resource.getString("str_too_many_x_grid_lines");
            }
        }
        if (this.fLogY && !this.fLogTickSpacing) {
            if (this.fMajYTick <= 0.0) {
                this.fValid = false;
                this.fInvalidStr = fp_resource.getString("str_axes_ticks_se_zero");
            } else if ((this.fMaxY - this.fMinY) / this.fMajYTick > (double)n) {
                this.fValid = false;
                this.fInvalidStr = fp_resource.getString("str_too_many_y_grid_lines");
            }
        }
        if (this.fMinX == -1.23456123) {
            this.fValid = false;
            this.fInvalidStr = fp_resource.getString("str_min_x_invalid");
        } else if (this.fMaxX == -1.23456123) {
            this.fValid = false;
            this.fInvalidStr = fp_resource.getString("str_min_x_invalid");
        } else if (this.fMinY == -1.23456123) {
            this.fValid = false;
            this.fInvalidStr = fp_resource.getString("str_max_y_invalid");
        } else if (this.fMaxY == -1.23456123) {
            this.fValid = false;
            this.fInvalidStr = fp_resource.getString("str_max_y_invalid");
        }
        return this.fValid;
    }

    public void logXBase(double d) {
        this.fLogXBase = d;
    }

    public void logYBase(double d) {
        this.fLogYBase = d;
    }

    public double logXBase() {
        return this.fLogXBase;
    }

    public double logYBase() {
        return this.fLogYBase;
    }

    public void logTickSpacing(boolean bl) {
        this.fLogTickSpacing = bl;
    }

    public boolean logTickSpacing() {
        return this.fLogTickSpacing;
    }

    public void piXTickSpacing(boolean bl) {
        this.fPiXTickSpacing = bl;
    }

    public boolean piXTickSpacing() {
        return this.fPiXTickSpacing;
    }

    public void piYTickSpacing(boolean bl) {
        this.fPiYTickSpacing = bl;
    }

    public boolean piYTickSpacing() {
        return this.fPiYTickSpacing;
    }
}

