/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPGrapher;

import com.questmsm.FPGrapher.FPAxes;
import java.awt.Color;
import java.awt.Graphics;

public class FPLine {
    private double fM;
    private double fB;
    private double fTagAx;
    private double fTagAy;
    private double fTagBx;
    private double fTagBy;
    private double fPivotX;
    private FPAxes fAxes;
    private int fHighlight;
    private Color fLineColor;
    private boolean fDraggingLine;
    private boolean fDraggingPivot;
    private boolean fDraggingTag;
    private final Color kHighlightColor = Color.yellow;
    public static int kNoHighlight = 0;
    public static int kHighlightTagA = 1;
    public static int kHighlightTagB = 2;
    public static int kHighlightPivot = 3;
    public static int kHighlightLine = 4;

    public FPLine(double d, double d2, Color color, FPAxes fPAxes) {
        this.fM = d;
        this.fB = d2;
        this.fPivotX = 0.0;
        this.fHighlight = kNoHighlight;
        this.fAxes = fPAxes;
        this.fLineColor = color;
        this.fDraggingLine = false;
        this.fDraggingPivot = false;
        this.fDraggingTag = false;
    }

    public Color getColor() {
        return this.fLineColor;
    }

    public boolean handleHighlights(int n, int n2) {
        int n3 = this.ptInTagA(n, n2) ? kHighlightTagA : (this.ptInTagB(n, n2) ? kHighlightTagB : (this.ptInPivot(n, n2) ? kHighlightPivot : (this.ptInLine(n, n2) ? kHighlightLine : kNoHighlight)));
        if (n3 != this.fHighlight) {
            this.fHighlight = n3;
            return true;
        }
        return false;
    }

    public void setHighlight(int n) {
        this.fHighlight = n;
    }

    public int getHighlight() {
        return this.fHighlight;
    }

    public void resetDrags() {
        this.fDraggingTag = false;
        this.fDraggingPivot = false;
        this.fDraggingLine = false;
    }

    public boolean checkDrags(int n, int n2) {
        if (this.ptInTagA(n, n2)) {
            this.fDraggingTag = true;
        } else if (this.ptInTagB(n, n2)) {
            this.fDraggingTag = true;
        } else if (this.ptInPivot(n, n2)) {
            this.fDraggingPivot = true;
        } else if (this.ptInLine(n, n2)) {
            this.fDraggingLine = true;
        } else {
            return false;
        }
        return true;
    }

    public boolean handleDrags(double d, double d2) {
        if (this.fDraggingTag) {
            this.rotateLine(d, d2);
            return true;
        }
        if (this.fDraggingPivot) {
            this.movePivot(d);
            return true;
        }
        if (this.fDraggingLine) {
            this.setB(d, d2);
            return true;
        }
        return false;
    }

    private double calcTagAx() {
        double d;
        double d2 = this.fAxes.minX();
        double d3 = this.xOfy(this.fAxes.minY());
        if (d3 < d2) {
            d3 = d2;
        }
        if ((d = this.xOfy(this.fAxes.maxY())) < d2) {
            d = d2;
        }
        if (d3 <= d) {
            return d3;
        }
        return d;
    }

    private double calcTagBx() {
        double d;
        double d2 = this.fAxes.maxX();
        double d3 = this.xOfy(this.fAxes.minY());
        if (d3 > d2) {
            d3 = d2;
        }
        if ((d = this.xOfy(this.fAxes.maxY())) > d2) {
            d = d2;
        }
        if (d3 >= d) {
            return d3;
        }
        return d;
    }

    private double calcTagAy() {
        return this.fTagAx * this.fM + this.fB;
    }

    private double calcTagBy() {
        return this.fTagBx * this.fM + this.fB;
    }

    public double getTagAx() {
        return this.fTagAx;
    }

    public double getTagAy() {
        return this.fTagAy;
    }

    public double getTagBx() {
        return this.fTagBx;
    }

    public double getTagBy() {
        return this.fTagBy;
    }

    public void setM(double d) {
        this.fM = d;
    }

    public double getM() {
        return this.fM;
    }

    public double getB() {
        return this.fB;
    }

    public double xOfy(double d) {
        return (d - this.fB) / this.fM;
    }

    public double yOfx(double d) {
        return this.fM * d + this.fB;
    }

    public boolean ptInLine(int n, int n2) {
        int n3 = this.fAxes.y2pxl(this.fM * this.fAxes.pxl2x(n) + this.fB);
        return Math.abs(n2 - n3) < 10;
    }

    public boolean ptInTagA(int n, int n2) {
        int n3 = this.fAxes.x2pxl(this.fTagAx);
        int n4 = this.fAxes.y2pxl(this.fTagAy);
        return Math.abs(n2 - n4) < 8 && Math.abs(n - n3) < 8;
    }

    public boolean ptInTagB(int n, int n2) {
        int n3 = this.fAxes.x2pxl(this.fTagBx);
        int n4 = this.fAxes.y2pxl(this.fTagBy);
        return Math.abs(n2 - n4) < 8 && Math.abs(n - n3) < 8;
    }

    public boolean ptInPivot(int n, int n2) {
        int n3 = this.fAxes.x2pxl(this.fPivotX);
        int n4 = this.fAxes.y2pxl(this.fPivotX * this.fM + this.fB);
        return Math.abs(n2 - n4) < 10 && Math.abs(n - n3) < 10;
    }

    public void rotateLine(double d, double d2) {
        double d3 = 30.0;
        if (Math.abs(d - this.fPivotX) > 0.01) {
            double d4 = (d2 - (this.fM * this.fPivotX + this.fB)) / (d - this.fPivotX);
            this.fHighlight = d > this.fPivotX ? kHighlightTagB : kHighlightTagA;
            this.fM = d4;
            this.fB = d2 - this.fM * d;
        }
    }

    public void movePivot(double d) {
        this.fPivotX = d;
    }

    public void setB(double d, double d2) {
        this.fB = d2 - this.fM * d;
    }

    public void offsetPivot(double d) {
        this.fPivotX += d;
    }

    public void drawTag(Graphics graphics, double d, double d2) {
        int n = this.fAxes.x2pxl(d);
        int n2 = this.fAxes.y2pxl(d2);
        graphics.fillRect(n - 3, n2 - 3, 7, 7);
    }

    public void drawPivot(Graphics graphics, double d, double d2) {
        int n = this.fAxes.x2pxl(d);
        int n2 = this.fAxes.y2pxl(d2);
        int n3 = 0;
        while (n3 < 8) {
            graphics.drawLine(n - n3, n2 + n3, n + n3, n2 + n3);
            ++n3;
        }
    }

    public void drawLine(Graphics graphics) {
        graphics.setColor(this.fLineColor);
        if (this.fHighlight == kHighlightLine) {
            graphics.setColor(this.kHighlightColor);
        }
        int n = this.fAxes.x2pxl(this.fAxes.minX());
        int n2 = this.fAxes.y2pxl(this.yOfx(this.fAxes.minX()));
        if (n2 == 2000) {
            n2 = this.fAxes.y2pxl(this.fAxes.minY());
            n = this.fAxes.x2pxl(this.xOfy(this.fAxes.minY()));
        } else if (n2 == -2000) {
            n2 = this.fAxes.y2pxl(this.fAxes.maxY());
            n = this.fAxes.x2pxl(this.xOfy(this.fAxes.maxY()));
        }
        int n3 = this.fAxes.x2pxl(this.fAxes.maxX());
        int n4 = this.fAxes.y2pxl(this.yOfx(this.fAxes.maxX()));
        if (n4 == 2000) {
            n4 = this.fAxes.y2pxl(this.fAxes.minY());
            n3 = this.fAxes.x2pxl(this.xOfy(this.fAxes.minY()));
        } else if (n4 == -2000) {
            n4 = this.fAxes.y2pxl(this.fAxes.maxY());
            n3 = this.fAxes.x2pxl(this.xOfy(this.fAxes.maxY()));
        }
        graphics.drawLine(n, n2, n3, n4);
    }

    public synchronized void draw(Graphics graphics) {
        this.drawLine(graphics);
        this.fTagAx = this.calcTagAx();
        this.fTagAy = this.calcTagAy();
        this.fTagBx = this.calcTagBx();
        this.fTagBy = this.calcTagBy();
        if (this.fHighlight == kHighlightTagA) {
            graphics.setColor(this.kHighlightColor);
        } else {
            graphics.setColor(Color.black);
        }
        this.drawTag(graphics, this.fTagAx, this.fTagAy);
        if (this.fHighlight == kHighlightTagB) {
            graphics.setColor(this.kHighlightColor);
        } else {
            graphics.setColor(Color.black);
        }
        this.drawTag(graphics, this.fTagBx, this.fTagBy);
        if (this.fHighlight == kHighlightPivot) {
            graphics.setColor(this.kHighlightColor);
        } else {
            graphics.setColor(Color.black);
        }
        this.drawPivot(graphics, this.fPivotX, this.fM * this.fPivotX + this.fB);
    }
}

