/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPGrapher;

import com.questmsm.FPGrapher.FPAxes;
import com.questmsm.FPGrapher.FPCondEquation;
import com.questmsm.FPGrapher.FPEquation;
import com.questmsm.FPGrapher.FPObject;
import com.questmsm.FPGrapher.FPPolarPointSet;
import com.questmsm.FPGrapher.FPRPNConverter;
import com.questmsm.Utilities.FPNumberFormatException;
import com.questmsm.Utilities.utils;
import java.awt.Color;
import java.io.Serializable;

public class FPPolarEquation
extends FPEquation
implements Serializable {
    private double fMinTheta;
    private double fMaxTheta;
    private String fRangeString;

    public FPPolarEquation(Color color, FPAxes fPAxes) {
        this.fConverter = new FPRPNConverter("r", "T");
        this.fEquationString = "";
        this.fInstructions[0] = 0.0;
        this.fLastInstruction = 0;
        this.fColor = color;
        this.fAxes = fPAxes;
        this.fKind = 1;
        this.fRangeString = "0 < T < 2P";
        this.fMinTheta = 0.0;
        this.fMaxTheta = Math.PI * 2;
    }

    public FPPolarEquation(String string, String string2, Color color, FPAxes fPAxes) {
        this.fConverter = new FPRPNConverter("r", "T");
        this.fEquationString = string;
        this.fColor = color;
        this.fKind = 1;
        if (string.length() == 0) {
            this.fInstructions[0] = 0.0;
            this.fLastInstruction = 0;
        } else {
            this.stringToEquation(string);
        }
        this.fRangeString = string2;
        this.setThetaRange();
        this.fAxes = fPAxes;
    }

    public String getRangeString() {
        return this.fRangeString;
    }

    private void setThetaRange() {
        double d;
        double d2;
        this.fMinTheta = 0.0;
        this.fMaxTheta = Math.PI * 2;
        this.fRangeString = utils.stripSpaces(this.fRangeString);
        int n = FPCondEquation.findStartOfWord(this.fRangeString, 0, "<=");
        if (n == -1) {
            this.fRangeString = "0 <= T <= 2P";
            return;
        }
        String string = this.fRangeString.substring(0, n);
        try {
            d2 = utils.str2num(string);
        }
        catch (FPNumberFormatException fPNumberFormatException) {
            this.fRangeString = "0 <= T <= 2P";
            return;
        }
        n = FPCondEquation.findStartOfWord(this.fRangeString, n + 2, "<=");
        if (n == -1) {
            this.fRangeString = "0 <= T <= 2P";
            return;
        }
        String string2 = this.fRangeString.substring(n + 2, this.fRangeString.length());
        try {
            d = utils.str2num(string2);
        }
        catch (FPNumberFormatException fPNumberFormatException) {
            this.fRangeString = "0 <= T <= 2P";
            return;
        }
        this.fMinTheta = d2;
        this.fMaxTheta = d;
        this.fRangeString = String.valueOf(string) + " <= T <= " + string2;
    }

    public void stretchLR(double d, double d2) {
    }

    public void stretchUD(double d, double d2) {
    }

    public void mirrorx(double d) {
    }

    public void mirrory(double d) {
    }

    public void mirrorxy() {
        this.mirrorXY = true;
    }

    public void translate(double d, double d2) {
    }

    public FPObject copy() {
        FPPolarEquation fPPolarEquation = new FPPolarEquation(this.fEquationString, this.fRangeString, this.fColor, this.fAxes);
        int n = 0;
        while (n < this.fNumSteps) {
            fPPolarEquation.fX[n] = this.fX[n];
            fPPolarEquation.fY[n] = this.fY[n];
            ++n;
        }
        return fPPolarEquation;
    }

    public void calculate(FPAxes fPAxes) {
        if (this.deleted()) {
            return;
        }
        double d = fPAxes.minX();
        double d2 = fPAxes.maxX();
        double d3 = fPAxes.minY();
        double d4 = fPAxes.maxY();
        this.fNumSteps = 300;
        int n = 0;
        while (n < this.fNumSteps) {
            int n2;
            int n3;
            double d5 = this.fMinTheta + (double)n * (this.fMaxTheta - this.fMinTheta) / (double)(this.fNumSteps - 1);
            double d6 = this.eval_(d5);
            if (d6 == -1.23456123) {
                n3 = -1001;
                n2 = -1001;
            } else {
                n2 = fPAxes.x2pxl(d6 * Math.cos(d5));
                n3 = fPAxes.y2pxl(d6 * Math.sin(d5));
            }
            this.fX[n] = n2;
            this.fY[n] = n3;
            ++n;
        }
    }

    public static double getTheta(double d, double d2) {
        if (d == 0.0) {
            if (d2 > 0.0) {
                return 1.5707963267948966;
            }
            if (d2 == 0.0) {
                return 0.0;
            }
            return -1.5707963267948966;
        }
        if (d2 == 0.0) {
            if (d > 0.0) {
                return 0.0;
            }
            if (d == 0.0) {
                return 0.0;
            }
            return Math.PI;
        }
        if (d > 0.0 && d2 > 0.0) {
            return Math.atan(d2 / d);
        }
        if (d < 0.0 && d2 > 0.0) {
            return 1.5707963267948966 - Math.atan(d / d2);
        }
        if (d < 0.0 && d2 < 0.0) {
            return Math.PI + Math.atan(d2 / d);
        }
        return 4.71238898038469 - Math.atan(d / d2);
    }

    public boolean mouseDown(int n, int n2, FPAxes fPAxes) {
        if (this.deleted()) {
            return false;
        }
        int n3 = 0;
        while (n3 < this.fNumSteps - 1) {
            if (utils.distance(this.fX[n3], this.fY[n3], this.fX[n3 + 1], this.fY[n3 + 1], n, n2) < 4) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public FPPolarPointSet samplePolar(int n, double[] dArray, int n2) {
        FPPolarPointSet fPPolarPointSet;
        block4: {
            block3: {
                fPPolarPointSet = new FPPolarPointSet(this.fAxes.parent().colorPalette().nextColor(), this.fAxes);
                if (n2 != 1) break block3;
                int n3 = 0;
                while (n3 < n) {
                    double d = dArray[n3];
                    double d2 = this.eval_(d);
                    fPPolarPointSet.addPoint(d, d2);
                    ++n3;
                }
                break block4;
            }
            if (n2 != 3) break block4;
            int n4 = 200;
            double[] dArray2 = new double[n4];
            double[] dArray3 = new double[n4];
            double[] dArray4 = new double[n4];
            dArray2[0] = 0.0;
            dArray4[0] = 0.0;
            dArray3[0] = this.eval_(dArray4[0]);
            double d = (this.fMaxTheta - this.fMinTheta) / (double)n4;
            int n5 = 1;
            while (n5 < n4) {
                dArray4[n5] = this.fMinTheta + (double)n5 * d;
                dArray3[n5] = this.eval_(dArray4[n5]);
                double d3 = dArray3[n5] - dArray3[n5 - 1];
                dArray2[n5] = dArray2[n5 - 1] + Math.sqrt(d3 * d3 + dArray3[n5] * d * (dArray3[n5] * d));
                ++n5;
            }
            int n6 = 0;
            while (n6 < n) {
                int n7 = utils.findClosestIndex(dArray[n6], dArray2, n4);
                fPPolarPointSet.addPoint(dArray4[n7], dArray3[n7]);
                ++n6;
            }
        }
        return fPPolarPointSet;
    }
}

