/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPTable;

import com.questmsm.FPTable.Column;
import com.questmsm.FPTable.Interval;
import com.questmsm.FPTable.TablePanel;
import com.questmsm.FunctionProbe.Master;
import com.questmsm.Utilities.DialogSuperClass;
import com.questmsm.Utilities.fp_resource;
import com.questmsm.Utilities.utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Label;

public class StatsDialog
extends DialogSuperClass {
    private TablePanel fTablePanel;
    private Column fColumn;
    private String fVar;
    private Interval[] fSelectedIntervals;
    private int fNumIntervals;
    private int fCurrentInterval;

    public StatsDialog(TablePanel tablePanel) {
        super(Master.gFrame);
        this.setModal(false);
        this.fTablePanel = tablePanel;
        this.fColumn = this.fTablePanel.selectedColumn();
        char c = this.fColumn.depVar();
        this.fVar = Character.isLetter(c) ? new Character(c).toString() : " ";
        this.setTitle(fp_resource.getString("str_column_statistics"));
        int n = Master.gSmallTop;
        int n2 = 300;
        String string = fp_resource.getString("str_use_arrow_keys_to_switch_intervals");
        Label label = new Label(string, 1);
        int n3 = this.fDialogMetrics.getHeight();
        int n4 = 160 + n;
        int n5 = 0;
        n5 = this.fDialogMetrics.stringWidth(string) + this.ch_advance;
        if (n2 < n5 + 60) {
            n2 = n5 + 60;
        }
        this.add(label);
        label.setBounds(n2 / 2 - n5 / 2, n4, n5, n3);
        n4 += n3 + this.ch_ht;
        string = fp_resource.getString("str_done");
        n5 = this.fDialogMetrics.stringWidth(string) + this.ch_advance;
        if (n2 < n5 + 60) {
            n2 = n5 + 60;
        }
        this.add(this.fOK);
        this.fOK.setBounds(n2 / 2 - n5 / 2, n4, n5, n3 + 3 * this.ch_ht);
        this.fOK.setLabel(string);
        this.fNumIntervals = this.fColumn.getNumSelectedIntervals();
        if (this.fNumIntervals > 0) {
            this.fSelectedIntervals = new Interval[this.fNumIntervals];
            this.fColumn.getSelectedIntervals(this.fSelectedIntervals);
            this.fColumn.setSpecialInterval(this.fSelectedIntervals[0]);
        } else {
            this.fSelectedIntervals = new Interval[1];
            this.fSelectedIntervals[0] = new Interval(0, this.fColumn.rows() - 1);
            this.fNumIntervals = 1;
        }
        this.fCurrentInterval = 0;
        this.setBounds(100, 100, n2, n4 + n3 + 4 * this.ch_ht + 10);
    }

    public void doYes() {
        this.fTablePanel.repaint();
        this.fColumn.setSpecialInterval(null);
        ((Component)this).setVisible(false);
    }

    private void drawSumation(Graphics graphics, int n, int n2) {
        int n3 = 4;
        graphics.drawLine(n, n2, n + 2 * n3, n2);
        graphics.drawLine(n, n2 - 1, n + 2 * n3, n2 - 1);
        graphics.drawLine(n, n2, n + n3, n2 + n3);
        graphics.drawLine(n + 1, n2, n + n3 + 1, n2 + n3);
        graphics.drawLine(n, n2 + 2 * n3, n + n3, n2 + n3);
        graphics.drawLine(n + 1, n2 + 2 * n3, n + n3 + 1, n2 + n3);
        graphics.drawLine(n, n2 + 2 * n3, n + 2 * n3, n2 + 2 * n3);
        graphics.drawLine(n, n2 + 2 * n3 + 1, n + 2 * n3, n2 + 2 * n3 + 1);
    }

    private void drawSpecial(Graphics graphics, String string, int n, int n2, int n3) {
        int n4;
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        int n5 = 0;
        int n6 = 0;
        while (n6 < string.length()) {
            n4 = string.charAt(n6);
            Character c = new Character((char)n4);
            switch (n4) {
                case 38: {
                    n5 += 9;
                    break;
                }
                default: {
                    n5 += fontMetrics.charWidth((char)n4);
                }
                case 126: 
            }
            ++n6;
        }
        n4 = n + (n3 - n5) / 2;
        int n7 = 0;
        while (n7 < string.length()) {
            char c = string.charAt(n7);
            Character c2 = new Character(c);
            switch (c) {
                case '&': {
                    this.drawSumation(graphics, n4, n2 - 8);
                    n4 += 9;
                    break;
                }
                case '~': {
                    c = string.charAt(++n7);
                    c2 = new Character(c);
                    graphics.drawString(c2.toString(), n4, n2);
                    int n8 = fontMetrics.charWidth(c);
                    graphics.drawLine(n4, n2 - 9, n4 + n8 - 2, n2 - 9);
                    n4 += fontMetrics.charWidth(c);
                    break;
                }
                default: {
                    graphics.drawString(c2.toString(), n4, n2);
                    n4 += fontMetrics.charWidth(c);
                    break;
                }
            }
            ++n7;
        }
    }

    private int count() {
        int n = 0;
        int n2 = 1 + this.fSelectedIntervals[this.fCurrentInterval].start();
        int n3 = this.fSelectedIntervals[this.fCurrentInterval].stop();
        if (n2 == 1) {
            n2 = 0;
        }
        if (n3 >= this.fColumn.rows()) {
            n3 = this.fColumn.rows() - 1;
        }
        int n4 = n2;
        while (n4 <= n3) {
            if (this.fColumn.row(n4).isNum()) {
                ++n;
            }
            ++n4;
        }
        return n;
    }

    private double sum() {
        double d = 0.0;
        int n = 1 + this.fSelectedIntervals[this.fCurrentInterval].start();
        int n2 = this.fSelectedIntervals[this.fCurrentInterval].stop();
        if (n == 1) {
            n = 0;
        }
        if (n2 >= this.fColumn.rows()) {
            n2 = this.fColumn.rows() - 1;
        }
        int n3 = n;
        while (n3 <= n2) {
            if (this.fColumn.row(n3).isNum()) {
                d += this.fColumn.row(n3).num();
            }
            ++n3;
        }
        return d;
    }

    private double max() {
        boolean bl = false;
        double d = 0.0;
        int n = 1 + this.fSelectedIntervals[this.fCurrentInterval].start();
        int n2 = this.fSelectedIntervals[this.fCurrentInterval].stop();
        if (n == 1) {
            n = 0;
        }
        if (n2 >= this.fColumn.rows()) {
            n2 = this.fColumn.rows() - 1;
        }
        int n3 = n;
        while (n3 <= n2) {
            if (this.fColumn.row(n3).isNum()) {
                if (!bl) {
                    d = this.fColumn.row(n3).num();
                    bl = true;
                } else {
                    double d2 = this.fColumn.row(n3).num();
                    if (d2 > d) {
                        d = d2;
                    }
                }
            }
            ++n3;
        }
        if (bl) {
            return d;
        }
        return 0.0;
    }

    private double median() {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 1 + this.fSelectedIntervals[this.fCurrentInterval].start();
        int n5 = this.fSelectedIntervals[this.fCurrentInterval].stop();
        if (n4 == 1) {
            n4 = 0;
        }
        if (n5 >= this.fColumn.rows()) {
            n5 = this.fColumn.rows() - 1;
        }
        double[] dArray = new double[n5 - n4 + 1];
        int n6 = n4;
        while (n6 <= n5) {
            if (this.fColumn.row(n6).isNum()) {
                dArray[n2] = this.fColumn.row(n6).num();
                ++n2;
            }
            ++n6;
        }
        int n7 = 0;
        while (n7 < n2) {
            double d = dArray[n7];
            n3 = n7;
            n = n7 + 1;
            while (n < n2) {
                if (dArray[n] > d) {
                    d = dArray[n];
                    n3 = n;
                }
                ++n;
            }
            if (n3 != n7) {
                dArray[n3] = dArray[n7];
                dArray[n7] = d;
            }
            ++n7;
        }
        if (n2 == 0) {
            return 0.0;
        }
        n = n2 / 2;
        if (n2 % 2 == 0) {
            return (dArray[n - 1] + dArray[n]) / 2.0;
        }
        return dArray[n];
    }

    private double min() {
        boolean bl = false;
        double d = 0.0;
        int n = 1 + this.fSelectedIntervals[this.fCurrentInterval].start();
        int n2 = this.fSelectedIntervals[this.fCurrentInterval].stop();
        if (n == 1) {
            n = 0;
        }
        if (n2 >= this.fColumn.rows()) {
            n2 = this.fColumn.rows() - 1;
        }
        int n3 = n;
        while (n3 <= n2) {
            if (this.fColumn.row(n3).isNum()) {
                if (!bl) {
                    d = this.fColumn.row(n3).num();
                    bl = true;
                } else {
                    double d2 = this.fColumn.row(n3).num();
                    if (d2 < d) {
                        d = d2;
                    }
                }
            }
            ++n3;
        }
        if (bl) {
            return d;
        }
        return 0.0;
    }

    private void paintStats(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = n / 2;
        int n3 = this.getSize().height;
        int n4 = 50;
        int n5 = this.count();
        double d = this.sum();
        double d2 = this.max();
        double d3 = this.min();
        double d4 = d / (double)n5;
        double d5 = this.median();
        int n6 = Master.gSmallTop;
        Font font = graphics.getFont();
        graphics.setFont(new Font("Helvetica", 0, 12));
        int n7 = 0;
        int n8 = 39 + n6;
        graphics.clearRect(n7 + 1, n8 - 10, n2 - 5, 20);
        this.drawSpecial(graphics, utils.num2str(n5), n7, n8, n2);
        graphics.clearRect((n7 += n2) + 1, n8 - 10, n2 - 5, 20);
        this.drawSpecial(graphics, utils.num2str(d), n7, n8, n2);
        graphics.clearRect(n7 + 1, (n8 += n4) - 10, n2 - 5, 20);
        this.drawSpecial(graphics, utils.num2str(d5), n7, n8, n2);
        graphics.clearRect((n7 -= n2) + 1, n8 - 10, n2 - 5, 20);
        this.drawSpecial(graphics, utils.num2str(d4), n7, n8, n2);
        graphics.clearRect(n7 + 1, (n8 += n4) - 10, n2 - 5, 20);
        this.drawSpecial(graphics, utils.num2str(d3), n7, n8, n2);
        graphics.clearRect((n7 += n2) + 1, n8 - 10, n2 - 5, 20);
        this.drawSpecial(graphics, utils.num2str(d2), n7, n8, n2);
        graphics.setFont(font);
        this.fColumn.setSpecialInterval(this.fSelectedIntervals[this.fCurrentInterval]);
        this.fTablePanel.repaint();
    }

    public boolean keyDown(Event event, int n) {
        if (n == 1004) {
            --this.fCurrentInterval;
            if (this.fCurrentInterval < 0) {
                this.fCurrentInterval = this.fNumIntervals - 1;
            }
            this.paintStats(this.getGraphics());
            return false;
        }
        if (n == 1005) {
            ++this.fCurrentInterval;
            if (this.fCurrentInterval >= this.fNumIntervals) {
                this.fCurrentInterval = 0;
            }
            this.paintStats(this.getGraphics());
            return false;
        }
        return super.keyDown(event, n);
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.black);
        int n = Master.gSmallTop;
        int n2 = this.getSize().width;
        int n3 = n2 / 2;
        int n4 = this.getSize().height;
        int n5 = 50;
        graphics.drawLine(n3, 5 + n, n3, 3 * n5 + n);
        graphics.drawLine(5, n5 + n, n2 - 5, n5 + n);
        graphics.drawLine(5, 2 * n5 + n, n2 - 5, 2 * n5 + n);
        graphics.drawLine(5, 3 * n5 + n, n2 - 5, 3 * n5 + n);
        int n6 = 0;
        int n7 = 20 + n;
        this.drawSpecial(graphics, String.valueOf(fp_resource.getString("str_count")) + " #(" + this.fVar + ")", n6, n7, n3);
        this.drawSpecial(graphics, String.valueOf(fp_resource.getString("str_sum")) + " &(" + this.fVar + ")", n6 += n3, n7, n3);
        this.drawSpecial(graphics, String.valueOf(fp_resource.getString("str_median")) + " M(" + this.fVar + ")", n6, n7 += n5, n3);
        this.drawSpecial(graphics, String.valueOf(fp_resource.getString("str_mean")) + " (~" + this.fVar + ")", n6 -= n3, n7, n3);
        this.drawSpecial(graphics, String.valueOf(fp_resource.getString("str_min")) + "(" + this.fVar + ")", n6, n7 += n5, n3);
        this.drawSpecial(graphics, String.valueOf(fp_resource.getString("str_max")) + "(" + this.fVar + ")", n6 += n3, n7, n3);
        this.paintStats(graphics);
    }
}

