/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPTable;

import com.questmsm.Utilities.utils;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class SubElement {
    private int fKind;
    private int fLeft;
    private int fRight;
    private int fTop;
    private int fHeight;
    private char fChar;
    public static final char kDelta = 'D';
    public static final char kRatio = '!';
    public static final char kAMean = '#';
    public static final char kGMean = '$';
    public static final char kAccum = '%';
    public static final char kTheta = 'T';
    public static final char kPi = 'P';

    public SubElement() {
    }

    public SubElement(char c) {
        this.fChar = c;
        this.fLeft = 0;
        this.fRight = 0;
        this.fTop = 0;
        this.fHeight = 0;
    }

    public char theChar() {
        return this.fChar;
    }

    public boolean inside(int n, int n2) {
        if (n < this.fLeft) {
            return false;
        }
        if (n > this.fRight) {
            return false;
        }
        if (n2 < this.fTop) {
            return false;
        }
        return n2 <= this.fTop + this.fHeight;
    }

    public void setSpacing(int n, int n2, int n3, int n4) {
        this.fLeft = n;
        this.fRight = n2;
        this.fTop = n3;
        this.fHeight = n4;
    }

    private void drawAccum(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(Color.black);
        int n5 = n + 8;
        int n6 = ++n3 + 3;
        int n7 = n + 1;
        int n8 = n6;
        int n9 = n5 - 3;
        int n10 = n6 + 4;
        int n11 = n7;
        int n12 = n10 + 4;
        int n13 = n5;
        int n14 = n12;
        graphics.drawLine(n5, n6, n7, n8);
        graphics.drawLine(n7, n8, n9, n10);
        graphics.drawLine(n9, n10, n11, n12);
        graphics.drawLine(n11, n12, n13, n14);
    }

    private void drawDelta(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(Color.black);
        int n5 = n + 1;
        int n6 = ++n3 + --n4 - 4;
        int n7 = (n + n2) / 2;
        int n8 = n3 + 4;
        int n9 = n2 - 1;
        int n10 = n6;
        graphics.drawLine(n5, n6, n7, n8);
        graphics.drawLine(n7, n8, n9, n10);
        graphics.drawLine(n5, n6, n9, n10);
    }

    private void drawRatio(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(Color.black);
        int n5 = n3 + (n4 + graphics.getFontMetrics(graphics.getFont()).getAscent()) / 2;
        int n6 = n + 1;
        Font font = graphics.getFont();
        graphics.setFont(new Font("Times", 0, 9));
        graphics.drawString("R", n6 + 2, n5 - 1);
        graphics.setFont(font);
        graphics.drawOval(n, n3 + 2, n2 - n, n4 - 3);
    }

    private void drawGMean(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.drawString("~", n + 1, n3 + 8);
    }

    private void drawAMean(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.drawLine(n - 1, n3 + 2, n + 7, n3 + 2);
    }

    public void draw(Graphics graphics) {
        switch (this.fChar) {
            case '\n': {
                return;
            }
            case 'D': {
                this.drawDelta(graphics, this.fLeft, this.fRight, this.fTop, this.fHeight);
                return;
            }
            case '!': {
                this.drawRatio(graphics, this.fLeft, this.fRight, this.fTop, this.fHeight);
                return;
            }
            case '#': {
                this.drawAMean(graphics, this.fLeft, this.fRight, this.fTop, this.fHeight);
                return;
            }
            case '$': {
                this.drawGMean(graphics, this.fLeft, this.fRight, this.fTop, this.fHeight);
                return;
            }
            case '%': {
                this.drawAccum(graphics, this.fLeft, this.fRight, this.fTop, this.fHeight);
                return;
            }
            case 'P': {
                utils.drawPi(graphics, this.fLeft, this.fTop + this.fHeight - 4);
                return;
            }
            case 'T': {
                utils.drawTheta(graphics, this.fLeft, this.fTop + this.fHeight - 4);
                return;
            }
        }
        char[] cArray = new char[]{this.fChar};
        int n = this.fTop + (this.fHeight + graphics.getFontMetrics(graphics.getFont()).getAscent()) / 2;
        graphics.drawChars(cArray, 0, 1, this.fLeft, n);
    }

    public void drawNoSpecialChars(Graphics graphics) {
        char[] cArray = new char[]{this.fChar};
        int n = this.fTop + (this.fHeight + graphics.getFontMetrics(graphics.getFont()).getAscent()) / 2;
        graphics.drawChars(cArray, 0, 1, this.fLeft, n);
    }

    public void drawInv(Graphics graphics) {
        if (this.fChar == '\n') {
            return;
        }
        Color color = graphics.getColor();
        graphics.setColor(Color.lightGray);
        graphics.fillRect(this.left(), this.fTop, this.right() - this.left(), this.fHeight);
        graphics.setColor(color);
        this.draw(graphics);
    }

    public void drawInvNoSpecialChars(Graphics graphics) {
        if (this.fChar == '\n') {
            return;
        }
        Color color = graphics.getColor();
        graphics.setColor(Color.lightGray);
        graphics.fillRect(this.left(), this.fTop, this.right() - this.left(), this.fHeight);
        graphics.setColor(color);
        this.drawNoSpecialChars(graphics);
    }

    public int left() {
        return this.fLeft;
    }

    public int right() {
        return this.fRight;
    }

    public int top() {
        return this.fTop;
    }

    public int bottom() {
        return this.fTop + this.fHeight;
    }

    public int width(FontMetrics fontMetrics) {
        switch (this.fChar) {
            case '\n': {
                return 0;
            }
            case '#': 
            case '$': {
                return 0;
            }
            case 'D': {
                return fontMetrics.charWidth('x') + 2;
            }
            case '!': 
            case '%': {
                return fontMetrics.charWidth('W');
            }
        }
        return fontMetrics.charWidth(this.fChar) + 1;
    }
}

