/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPCalculator;

import com.questmsm.FPCalculator.CalcUtils;
import com.questmsm.Utilities.fp_resource;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;

public class CalcButton {
    private static Image fImg;
    private static Image fImgInv;
    private static ImageObserver fObs;
    private static int fHeight;
    private static int fWidth;
    private int fx;
    private int fy;
    private boolean fSelected;
    private boolean fEnabled = true;
    private String fLabel;
    private char fid;
    private final int kXGrid = 32;
    private final int kYGrid = 32;
    private final int kXoffset = 0;
    private final int kYoffset = 0;
    private static final Font Times18B;
    private static final Font Times10B;
    private static final Font Times12B;
    private static final Font Times14B;
    private boolean toggleval = false;

    static {
        Times18B = new Font("Times", 1, 18);
        Times10B = new Font("Times", 1, 10);
        Times12B = new Font("Times", 1, 12);
        Times14B = new Font("Times", 1, 14);
    }

    public CalcButton(String string, char c, int n, int n2) {
        this.fLabel = string;
        this.fid = c;
        this.select(false);
        this.setPos(0, 0);
        int n3 = n - 1;
        int n4 = n2 - 1;
        this.setPos(32 * n3, 32 * n4);
        this.enable(true);
    }

    public static void setStaticVars(Image image, Image image2, ImageObserver imageObserver) {
        fImg = image;
        fImgInv = image2;
        fObs = imageObserver;
        fHeight = fImg.getHeight(fObs);
        fWidth = fImg.getWidth(fObs);
    }

    public void select(boolean bl) {
        this.fSelected = bl;
    }

    public boolean select() {
        return this.fSelected;
    }

    public char id() {
        return this.fid;
    }

    public boolean enable(boolean bl) {
        if (bl == this.fEnabled) {
            return false;
        }
        this.fEnabled = bl;
        return true;
    }

    public boolean enabled() {
        return this.fEnabled;
    }

    public void setPos(int n, int n2) {
        this.fx = n;
        this.fy = n2;
    }

    private void drawString(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        if (this.enabled()) {
            graphics.setColor(Color.black);
        } else {
            graphics.setColor(Color.darkGray);
        }
        graphics.setFont(Times18B);
        switch (this.fLabel.charAt(0)) {
            case 'e': {
                n2 = -2;
                n = 1;
                break;
            }
            case '(': 
            case ')': {
                n2 = -2;
                break;
            }
            case '-': {
                n = 2;
                n2 = -2;
                break;
            }
            case 'C': {
                n2 = -2;
                n = -2;
                graphics.setFont(Times12B);
                break;
            }
            case 'c': {
                n = 7;
                n2 = 4;
                graphics.setFont(Times10B);
                graphics.drawString(fp_resource.getString("str_clr"), this.fx + n + 3, this.fy + n2 + 15);
                return;
            }
            case '.': {
                n2 = -3;
                n = 1;
                break;
            }
            case '*': {
                n2 = 1;
                break;
            }
            case '/': {
                n = 1;
                break;
            }
            case '=': {
                n2 = -2;
                break;
            }
            case '+': {
                if (this.fLabel.length() == 1) {
                    n = 1;
                    n2 = -2;
                    break;
                }
                n = 9;
                n2 = 4;
                graphics.setFont(Times14B);
                graphics.drawString("+", this.fx + n + 2, this.fy + n2 + 13);
                graphics.drawString("-", this.fx + n + 3, this.fy + n2 + 19);
                return;
            }
            case 'P': {
                n = this.fx + 12;
                n2 = this.fy + 11;
                int n3 = 7;
                int n4 = 4;
                CalcUtils.drawBoldLine(graphics, n, n2, n, n2 + n3);
                CalcUtils.drawBoldLine(graphics, n + n4, n2, n + n4, n2 + n3);
                CalcUtils.drawBoldLine(graphics, n, n2, n + n4 + 2, n2);
                graphics.drawLine(n - 2, n2 + 2, n, n2);
                graphics.drawLine(n + n4 + 1, n2 + n3, n + n4 + 3, n2 + n3 - 1);
                return;
            }
            case 'I': {
                graphics.setFont(Times10B);
                n = -4;
                n2 = -2;
                break;
            }
        }
        graphics.drawString(this.fLabel, this.fx + n + 10, this.fy + n2 + 22);
    }

    public void draw(Graphics graphics) {
        graphics.drawImage(fImg, this.fx, this.fy, fObs);
        graphics.setColor(Color.black);
        this.drawString(graphics);
    }

    public void drawIfSelected(Graphics graphics) {
        if (this.fSelected) {
            graphics.drawImage(fImgInv, this.fx, this.fy, fObs);
            graphics.setColor(Color.white);
            this.drawString(graphics);
        }
    }

    public boolean handleMouseDrag(int n, int n2) {
        if (!this.enabled()) {
            return false;
        }
        boolean bl = this.fSelected;
        this.fSelected = false;
        if (n < this.fx) {
            return bl;
        }
        if (n > this.fx + fWidth) {
            return bl;
        }
        if (n2 < this.fy) {
            return bl;
        }
        if (n2 > this.fy + fHeight) {
            return bl;
        }
        this.fSelected = true;
        return !bl;
    }

    public boolean handleMouseDown(int n, int n2) {
        if (!this.enabled()) {
            return false;
        }
        this.fSelected = false;
        if (n < this.fx) {
            return false;
        }
        if (n > this.fx + fWidth) {
            return false;
        }
        if (n2 < this.fy) {
            return false;
        }
        if (n2 > this.fy + fHeight) {
            return false;
        }
        this.fSelected = true;
        return true;
    }

    public boolean handleMouseUp(int n, int n2) {
        if (!this.enabled()) {
            return false;
        }
        boolean bl = this.fSelected;
        this.fSelected = false;
        return bl;
    }

    public boolean handleToggleMouseDown(int n, int n2) {
        if (!this.enabled()) {
            return false;
        }
        boolean bl = true;
        if (n < this.fx) {
            bl = false;
        }
        if (n > this.fx + fWidth) {
            bl = false;
        }
        if (n2 < this.fy) {
            bl = false;
        }
        if (n2 > this.fy + fHeight) {
            bl = false;
        }
        this.toggleval = this.fSelected;
        if (bl) {
            this.fSelected ^= true;
        }
        return bl;
    }

    public boolean handleToggleMouseDrag(int n, int n2) {
        if (!this.enabled()) {
            return false;
        }
        boolean bl = true;
        if (n < this.fx) {
            bl = false;
        }
        if (n > this.fx + fWidth) {
            bl = false;
        }
        if (n2 < this.fy) {
            bl = false;
        }
        if (n2 > this.fy + fHeight) {
            bl = false;
        }
        if (this.fSelected == this.toggleval) {
            return false;
        }
        if (bl) {
            this.fSelected = this.toggleval;
        }
        return bl;
    }

    public boolean handleToggleMouseUp(int n, int n2) {
        if (!this.enabled()) {
            return false;
        }
        boolean bl = true;
        if (n < this.fx) {
            bl = false;
        }
        if (n > this.fx + fWidth) {
            bl = false;
        }
        if (n2 < this.fy) {
            bl = false;
        }
        if (n2 > this.fy + fHeight) {
            bl = false;
        }
        return bl;
    }
}

