/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPCalculator;

import com.questmsm.FPCalculator.ButtonNameFrame;
import com.questmsm.FPCalculator.CalcButtonCanvas;
import com.questmsm.FPCalculator.CalcUtils;
import com.questmsm.FPCalculator.Calculator;
import com.questmsm.FPCalculator.DisplayField;
import com.questmsm.FPCalculator.EditDisplayField;
import com.questmsm.FPCalculator.Evaluator;
import com.questmsm.FPCalculator.FunctionButton;
import com.questmsm.FPCalculator.SpecialTextField;
import com.questmsm.FunctionProbe.Evaluatable;
import com.questmsm.FunctionProbe.Master;
import com.questmsm.Utilities.FPNumberFormatException;
import com.questmsm.Utilities.fp_resource;
import com.questmsm.Utilities.utils;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;

public class FunctionCanvas
extends Canvas {
    private FunctionButton fsind = null;
    private FunctionButton fcosd;
    private FunctionButton ftand;
    private FunctionButton fsinr;
    private FunctionButton fcosr;
    private FunctionButton ftanr;
    private FunctionButton foox;
    private FunctionButton fatox;
    private FunctionButton fxtoa;
    private FunctionButton fabsx;
    private FunctionButton fquestion;
    private FunctionButton fsindinv;
    private FunctionButton fcosdinv;
    private FunctionButton ftandinv;
    private FunctionButton fsinrinv;
    private FunctionButton fcosrinv;
    private FunctionButton ftanrinv;
    private FunctionButton fatoxinv;
    private FunctionButton fxtoainv;
    private FunctionButton fdet;
    public static final double PI = Math.PI;
    public static final int kMaxUser = 10;
    public FunctionButton[] fuser = new FunctionButton[10];
    public Evaluator[] fUserFunctions = new Evaluator[10];
    public boolean[] fUserDefined = new boolean[10];
    public FunctionButton[] fuserInv = new FunctionButton[10];
    public Evaluator[] fUserInvFunctions = new Evaluator[10];
    public FunctionButton[] fGrapherButtons = new FunctionButton[10];
    public int fNumGrapherButtons = 0;
    private boolean fRadians = true;
    private boolean fInverses = false;
    private boolean fSelectUserButtonMode = false;
    private int fSelectedUserButton = -1;
    public static final char kPi = '\u0001';
    public static final char kE = '\u0002';
    public static final char kClear = '\u0003';
    public static final char kClearAll = '\u0004';
    public static final char kChangeSign = 'i';
    public static final int ksind = 1;
    public static final int kcosd = 2;
    public static final int ktand = 3;
    public static final int ksinr = 4;
    public static final int kcosr = 5;
    public static final int ktanr = 6;
    public static final int ketox = 7;
    public static final int katox = 208;
    public static final int kxtoa = 207;
    public static final int koox = 10;
    public static final int kabsx = 11;
    public static final int ksindinv = 12;
    public static final int kcosdinv = 13;
    public static final int ktandinv = 14;
    public static final int ksinrinv = 15;
    public static final int kcosrinv = 16;
    public static final int ktanrinv = 17;
    public static final int ketoxinv = 18;
    public static final int katoxinv = 209;
    public static final int kxtoainv = 210;
    public static final int kquestion = 21;
    private Image fBackgroundImage = null;
    private Image fForegroundImage = null;
    private Graphics fBackgroundGraphics = null;
    private Graphics fForegroundGraphics = null;
    private DisplayField fDisplayField;
    private SpecialTextField fSpecialField;
    private CalcButtonCanvas fCalcButtons;
    private Calculator fCalc;
    private EditDisplayField fEditField;
    private int fImageWidth;
    boolean initialized = false;

    public FunctionCanvas(Color color, Calculator calculator, EditDisplayField editDisplayField, DisplayField displayField, SpecialTextField specialTextField, CalcButtonCanvas calcButtonCanvas) {
        this.setBackground(color);
        this.fDisplayField = displayField;
        this.fSpecialField = specialTextField;
        this.fCalcButtons = calcButtonCanvas;
        this.fCalc = calculator;
        this.fEditField = editDisplayField;
    }

    public void clear() {
        this.fNumGrapherButtons = 0;
        this.fRadians = false;
        this.fInverses = false;
        this.fSelectedUserButton = -1;
        this.fSelectUserButtonMode = false;
        int n = 0;
        while (n < 10) {
            this.fUserDefined[n] = false;
            ++n;
        }
    }

    public void createButtons() {
        Image image = utils.getImage("calc.gif", this);
        Image image2 = this.createImage(64, 24);
        Image image3 = this.createImage(64, 24);
        image2.getGraphics().drawImage(image, 0, 0, 64, 24, 0, 96, 64, 120, this);
        image3.getGraphics().drawImage(image, 0, 0, 64, 24, 0, 120, 64, 144, this);
        FunctionButton.setStaticVars(image2, image3, this);
        this.fsind = new FunctionButton("%" + fp_resource.sin + "dx", false);
        this.fcosd = new FunctionButton("%" + fp_resource.cos + "dx", false);
        this.ftand = new FunctionButton("%" + fp_resource.tan + "dx", false);
        this.fsinr = new FunctionButton("%" + fp_resource.sin + "rx", true);
        this.fcosr = new FunctionButton("%" + fp_resource.cos + "rx", true);
        this.ftanr = new FunctionButton("%" + fp_resource.tan + "rx", true);
        this.fsindinv = new FunctionButton("%" + fp_resource.sin + "Dx", false);
        this.fcosdinv = new FunctionButton("%" + fp_resource.cos + "Dx", false);
        this.ftandinv = new FunctionButton("%" + fp_resource.tan + "Dx", false);
        this.fsinrinv = new FunctionButton("%" + fp_resource.sin + "Rx", false);
        this.fcosrinv = new FunctionButton("%" + fp_resource.cos + "Rx", false);
        this.ftanrinv = new FunctionButton("%" + fp_resource.tan + "Rx", false);
        this.fatox = new FunctionButton("%aX", true);
        this.fatoxinv = new FunctionButton("%log_ x", false);
        this.fxtoa = new FunctionButton("%xA", true);
        this.fxtoainv = new FunctionButton("%xI", false);
        this.foox = new FunctionButton("%1/x", true);
        this.fabsx = new FunctionButton("%abs x", true);
        this.fquestion = new FunctionButton("?", false);
        this.fdet = new FunctionButton(fp_resource.getString("str_det"), false);
        int n = 0;
        while (n < 10) {
            this.fuser[n] = new FunctionButton("j" + String.valueOf(n + 1), false);
            this.fuserInv[n] = new FunctionButton("j" + String.valueOf(n + 1), false);
            ++n;
        }
        this.fImageWidth = image2.getWidth(this);
    }

    public void defineButton(boolean bl) {
        if (bl) {
            this.fEditField.clearRow();
        }
        this.fquestion.visible(bl);
        this.fCalc.myResize();
        this.repaint();
    }

    public void defineGrapherButton(String string) {
        this.fGrapherButtons[this.fNumGrapherButtons] = new FunctionButton(string, true);
        ++this.fNumGrapherButtons;
        this.fCalc.myResize();
        this.repaint();
    }

    public Point relocate(int n) {
        int n2 = n / 64;
        if (n2 <= 0) {
            n2 = 1;
        }
        int n3 = 0;
        int n4 = 0;
        if (this.fsind == null) {
            return new Point(0, 0);
        }
        if (this.fCalc.matrixView()) {
            this.fdet.setLoc(n4, n3);
            if (++n4 >= n2) {
                ++n3;
                n4 = 0;
            }
        } else {
            if (this.fquestion.visible()) {
                this.fquestion.setLoc(n4, n3);
                if (++n4 > n2) {
                    ++n3;
                    n4 = 0;
                }
            }
            this.fsind.setLoc(n4, n3);
            this.fsinr.setLoc(n4, n3);
            this.fsindinv.setLoc(n4, n3);
            this.fsinrinv.setLoc(n4, n3);
            if (++n4 >= n2) {
                ++n3;
                n4 = 0;
            }
            this.fcosd.setLoc(n4, n3);
            this.fcosr.setLoc(n4, n3);
            this.fcosdinv.setLoc(n4, n3);
            this.fcosrinv.setLoc(n4, n3);
            if (++n4 >= n2) {
                ++n3;
                n4 = 0;
            }
            this.ftand.setLoc(n4, n3);
            this.ftanr.setLoc(n4, n3);
            this.ftandinv.setLoc(n4, n3);
            this.ftanrinv.setLoc(n4, n3);
            if (++n4 >= n2) {
                ++n3;
                n4 = 0;
            }
            this.fatox.setLoc(n4, n3);
            this.fatoxinv.setLoc(n4, n3);
            if (++n4 >= n2) {
                ++n3;
                n4 = 0;
            }
            this.fxtoa.setLoc(n4, n3);
            this.fxtoainv.setLoc(n4, n3);
            if (++n4 >= n2) {
                ++n3;
                n4 = 0;
            }
            this.foox.setLoc(n4, n3);
            if (++n4 >= n2) {
                ++n3;
                n4 = 0;
            }
            this.fabsx.setLoc(n4, n3);
            int n5 = 0;
            while (n5 < 10) {
                if (this.fUserDefined[n5]) {
                    if (++n4 >= n2) {
                        ++n3;
                        n4 = 0;
                    }
                    this.fuser[n5].setLoc(n4, n3);
                    this.fuserInv[n5].setLoc(n4, n3);
                }
                ++n5;
            }
            int n6 = 0;
            while (n6 < this.fNumGrapherButtons) {
                if (++n4 >= n2) {
                    ++n3;
                    n4 = 0;
                }
                this.fGrapherButtons[n6].setLoc(n4, n3);
                ++n6;
            }
        }
        return new Point(n2 * 64, (n3 + 1) * 24);
    }

    private int smallestUnusedUser() {
        int n = 0;
        while (n < 10) {
            if (!this.fUserDefined[n]) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int scanForEvaluators(Evaluatable[] evaluatableArray, String[] stringArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < 10) {
            if (this.fUserDefined[n2]) {
                evaluatableArray[n] = this.fUserFunctions[n2];
                stringArray[n] = "B" + (n2 + 1);
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public void makeNewButton(String string) {
        int n = this.smallestUnusedUser();
        if (n == -1) {
            utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_error__already_have_max__of_user_buttons"));
            return;
        }
        this.fquestion.visible(false);
        this.fUserFunctions[n] = new Evaluator();
        this.fuser[n].visible(true);
        this.fUserDefined[n] = true;
        this.fuser[n].label(string);
        this.fEditField.row().transferToEvaluator(this.fUserFunctions[n]);
        if (!this.fSpecialField.isLastRowValid()) {
            this.fSpecialField.clearRow();
        } else {
            this.fSpecialField.createNewRow();
        }
        this.fEditField.transferRow(this.fSpecialField);
        this.fSpecialField.setDefineRow(n, string);
        Master.addEvaluator(this.fUserFunctions[n], "B" + (n + 1));
        this.fSpecialField.endRowNoEqual();
        this.fCalc.definingButton(false);
        this.fCalc.myResize();
        this.repaint();
        this.fCalc.updateMenus();
    }

    public void deselectUserButton() {
        this.fSelectUserButtonMode = false;
        this.fSelectedUserButton = -1;
        this.repaint();
        this.fCalc.updateMenus();
    }

    public void editOldButton() {
        this.fquestion.visible(false);
        ButtonNameFrame buttonNameFrame = new ButtonNameFrame(this.fCalc, this.fCalc.functionCanvas().userButtonNum());
        buttonNameFrame.editingExisting(this.fuser[this.fSelectedUserButton].label());
        buttonNameFrame.setTitle("Rename Button?");
        ((Component)buttonNameFrame).setVisible(true);
    }

    public void editOldButton(String string) {
        this.fUserFunctions[this.fSelectedUserButton] = new Evaluator();
        this.fuser[this.fSelectedUserButton].visible(true);
        this.fuser[this.fSelectedUserButton].label(string);
        this.fEditField.row().transferToEvaluator(this.fUserFunctions[this.fSelectedUserButton]);
        this.fSpecialField.cancelRow(this.fSelectedUserButton);
        if (!this.fSpecialField.isLastRowValid()) {
            this.fSpecialField.clearRow();
        } else {
            this.fSpecialField.createNewRow();
        }
        this.fEditField.transferRow(this.fSpecialField);
        this.fSpecialField.setDefineRow(this.fSelectedUserButton, string);
        Master.addEvaluator(this.fUserFunctions[this.fSelectedUserButton], "B" + this.fSelectedUserButton);
        this.fSpecialField.endRowNoEqual("");
        this.fCalc.myResize();
        this.deselectUserButton();
        this.repaint();
        this.fCalc.updateMenus();
    }

    public void defineInverse() {
        this.fquestion.visible(false);
        ButtonNameFrame buttonNameFrame = new ButtonNameFrame(this.fCalc, this.fCalc.functionCanvas().userButtonNum());
        buttonNameFrame.namingInverse(String.valueOf(this.fuser[this.fSelectedUserButton].label()) + "^-^1");
        ((Component)buttonNameFrame).setVisible(true);
    }

    public void defineInverse(String string) {
        this.fUserInvFunctions[this.fSelectedUserButton] = new Evaluator();
        this.fuserInv[this.fSelectedUserButton].visible(true);
        this.fuserInv[this.fSelectedUserButton].label(string);
        this.fuser[this.fSelectedUserButton].setInverse(true);
        this.fEditField.row().transferToEvaluator(this.fUserInvFunctions[this.fSelectedUserButton]);
        if (!this.fSpecialField.isLastRowValid()) {
            this.fSpecialField.clearRow();
        } else {
            this.fSpecialField.createNewRow();
        }
        this.fEditField.transferRow(this.fSpecialField);
        this.fSpecialField.setDefineRow(this.fSelectedUserButton, this.fuserInv[this.fSelectedUserButton].label());
        this.fSpecialField.endRowNoEqual("");
        this.fCalc.myResize();
        this.fCalc.definingInverse(false);
        this.deselectUserButton();
        this.updateButtons();
        this.repaint();
        this.fCalc.updateMenus();
    }

    public void createImages(int n, int n2) {
        this.fBackgroundImage = this.createImage(n, n2);
        this.fBackgroundGraphics = this.fBackgroundImage.getGraphics();
        this.fForegroundImage = this.createImage(n, n2);
        this.fForegroundGraphics = this.fForegroundImage.getGraphics();
    }

    public int maxWidth() {
        return 4 * this.fImageWidth;
    }

    void initialize() {
        Dimension dimension = this.getSize();
        this.createImages(dimension.width, dimension.height);
        if (this.fsind == null) {
            this.createButtons();
        }
        this.drawBackground();
    }

    private synchronized void drawBackground(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        this.draw(graphics);
    }

    public synchronized void drawBackground() {
        this.drawBackground(this.fBackgroundGraphics);
    }

    public void drawForeground(Graphics graphics) {
        this.fsind.drawIfSelected(graphics);
        this.fcosd.drawIfSelected(graphics);
        this.ftand.drawIfSelected(graphics);
        this.fsinr.drawIfSelected(graphics);
        this.fcosr.drawIfSelected(graphics);
        this.ftanr.drawIfSelected(graphics);
        this.fatox.drawIfSelected(graphics);
        this.fxtoa.drawIfSelected(graphics);
        this.foox.drawIfSelected(graphics);
        this.fabsx.drawIfSelected(graphics);
        this.fsindinv.drawIfSelected(graphics);
        this.fcosdinv.drawIfSelected(graphics);
        this.ftandinv.drawIfSelected(graphics);
        this.fsinrinv.drawIfSelected(graphics);
        this.fcosrinv.drawIfSelected(graphics);
        this.ftanrinv.drawIfSelected(graphics);
        this.fatoxinv.drawIfSelected(graphics);
        this.fxtoainv.drawIfSelected(graphics);
        this.fquestion.drawIfSelected(graphics);
        this.fdet.drawIfSelected(graphics);
        int n = 0;
        while (n < 10) {
            if (this.fUserDefined[n]) {
                if (this.fSelectUserButtonMode && this.fSelectedUserButton == n) {
                    this.fuser[n].select(true);
                    this.fuser[n].drawIfSelected(graphics);
                    this.fuser[n].select(false);
                } else {
                    this.fuserInv[n].drawIfSelected(graphics);
                    this.fuser[n].drawIfSelected(graphics);
                }
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.fNumGrapherButtons) {
            this.fGrapherButtons[n2].drawIfSelected(graphics);
            ++n2;
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public synchronized void paint(Graphics graphics) {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.fBackgroundImage == null) {
            return;
        }
        if (this.fForegroundImage == null) {
            return;
        }
        this.fForegroundGraphics.drawImage(this.fBackgroundImage, 0, 0, this);
        this.drawForeground(this.fForegroundGraphics);
        graphics.drawImage(this.fForegroundImage, 0, 0, this);
    }

    public void draw(Graphics graphics) {
        this.fsind.draw(graphics);
        this.fcosd.draw(graphics);
        this.ftand.draw(graphics);
        this.fsinr.draw(graphics);
        this.fcosr.draw(graphics);
        this.ftanr.draw(graphics);
        this.fatox.draw(graphics);
        this.fxtoa.draw(graphics);
        this.foox.draw(graphics);
        this.fabsx.draw(graphics);
        this.fsindinv.draw(graphics);
        this.fcosdinv.draw(graphics);
        this.ftandinv.draw(graphics);
        this.fsinrinv.draw(graphics);
        this.fcosrinv.draw(graphics);
        this.ftanrinv.draw(graphics);
        this.fatoxinv.draw(graphics);
        this.fxtoainv.draw(graphics);
        this.fquestion.draw(graphics);
        this.fdet.draw(graphics);
        int n = 0;
        while (n < 10) {
            if (this.fUserDefined[n]) {
                this.fuser[n].draw(graphics);
                this.fuserInv[n].draw(graphics);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.fNumGrapherButtons) {
            this.fGrapherButtons[n2].draw(graphics);
            ++n2;
        }
    }

    public synchronized boolean mouseDown(Event event, int n, int n2) {
        this.fsind.handleMouseDown(n, n2);
        this.fcosd.handleMouseDown(n, n2);
        this.ftand.handleMouseDown(n, n2);
        this.fsinr.handleMouseDown(n, n2);
        this.fcosr.handleMouseDown(n, n2);
        this.ftanr.handleMouseDown(n, n2);
        this.fatox.handleMouseDown(n, n2);
        this.fxtoa.handleMouseDown(n, n2);
        this.foox.handleMouseDown(n, n2);
        this.fabsx.handleMouseDown(n, n2);
        this.fsindinv.handleMouseDown(n, n2);
        this.fcosdinv.handleMouseDown(n, n2);
        this.ftandinv.handleMouseDown(n, n2);
        this.fsinrinv.handleMouseDown(n, n2);
        this.fcosrinv.handleMouseDown(n, n2);
        this.ftanrinv.handleMouseDown(n, n2);
        this.fatoxinv.handleMouseDown(n, n2);
        this.fxtoainv.handleMouseDown(n, n2);
        this.fquestion.handleMouseDown(n, n2);
        this.fdet.handleMouseDown(n, n2);
        int n3 = 0;
        while (n3 < 10) {
            if (this.fUserDefined[n3]) {
                this.fuser[n3].handleMouseDown(n, n2);
                this.fuserInv[n3].handleMouseDown(n, n2);
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.fNumGrapherButtons) {
            this.fGrapherButtons[n4].handleMouseDown(n, n2);
            ++n4;
        }
        this.repaint();
        this.fCalc.setFocus();
        return false;
    }

    public void inverses(boolean bl) {
        this.fInverses = bl;
        this.updateButtons();
    }

    public boolean inverses() {
        return this.fInverses;
    }

    public void radians(boolean bl) {
        this.fRadians = bl;
        this.updateButtons();
    }

    public boolean radians() {
        return this.fRadians;
    }

    public void updateButtons() {
        int n;
        boolean bl = this.fCalc.matrixView();
        this.fsind.visible(!this.fRadians && !this.fInverses && !bl);
        this.fcosd.visible(!this.fRadians && !this.fInverses && !bl);
        this.ftand.visible(!this.fRadians && !this.fInverses && !bl);
        this.fsinr.visible(this.fRadians && !this.fInverses && !bl);
        this.fcosr.visible(this.fRadians && !this.fInverses && !bl);
        this.ftanr.visible(this.fRadians && !this.fInverses && !bl);
        this.fatox.visible(!this.fInverses && !bl);
        this.fxtoa.visible(!this.fInverses && !bl);
        this.fabsx.visible(bl ^ true);
        this.foox.visible(bl ^ true);
        this.fsindinv.visible(!this.fRadians && this.fInverses && !bl);
        this.fcosdinv.visible(!this.fRadians && this.fInverses && !bl);
        this.ftandinv.visible(!this.fRadians && this.fInverses && !bl);
        this.fsinrinv.visible(this.fRadians && this.fInverses && !bl);
        this.fcosrinv.visible(this.fRadians && this.fInverses && !bl);
        this.ftanrinv.visible(this.fRadians && this.fInverses && !bl);
        this.fatoxinv.visible(this.fInverses && !bl);
        this.fxtoainv.visible(this.fInverses && !bl);
        if (bl) {
            this.fquestion.visible(false);
            this.fdet.visible(this.fCalc.allowDeterminants());
        } else {
            this.fdet.visible(false);
        }
        if (bl) {
            n = 0;
            while (n < 10) {
                if (this.fUserDefined[n]) {
                    this.fuser[n].visible(false);
                    this.fuserInv[n].visible(false);
                }
                ++n;
            }
        } else {
            n = 0;
            while (n < 10) {
                if (this.fUserDefined[n]) {
                    this.fuser[n].visible(this.fInverses ^ true);
                    if (this.fuser[n].inverse()) {
                        this.fuserInv[n].visible(this.fInverses);
                    } else {
                        this.fuserInv[n].visible(false);
                    }
                }
                ++n;
            }
        }
        n = 0;
        while (n < this.fNumGrapherButtons) {
            this.fGrapherButtons[n].visible(!bl && !this.fInverses);
            ++n;
        }
        this.drawBackground();
        this.repaint();
    }

    public void process(int n, String string, boolean bl) {
        if (this.fCalc.editing()) {
            this.fEditField.pushFunctionToCurrent(string, n);
            this.fEditField.redraw();
            return;
        }
        int n2 = this.fCalcButtons.current();
        double d = this.fCalcButtons.number();
        if (n == 21) {
            this.fCalcButtons.number(0.5);
        }
        if (n2 == 0 && n != 21) {
            return;
        }
        if (n2 == 3) {
            this.fSpecialField.createNewRow();
        }
        if ((n2 == 1 || n2 == 3) && n != 21) {
            this.fSpecialField.pushStringToCurrentRow(this.fCalcButtons.displayString());
        }
        if (n < -1000) {
            int n3 = -n - 1 - 1000;
            d = Master.evaluate("G" + String.valueOf(n3), d);
            this.fCalcButtons.number(d);
        } else if (n < -100) {
            int n4 = -n - 1 - 100;
            d = this.fUserInvFunctions[n4].eval(d);
            this.fCalcButtons.number(d);
        } else if (n < 0) {
            int n5 = -n - 1;
            d = this.fUserFunctions[n5].eval(d);
            this.fCalcButtons.number(d);
        } else {
            switch (n) {
                case 12: 
                case 13: 
                case 15: 
                case 16: {
                    if (!(d < -1.0) && !(d > 1.0)) break;
                    utils.showErrorDialog(this.fCalc, fp_resource.getString("str_error__the_inverse_trig_functions_require_an_argument_between__and_"));
                    return;
                }
            }
            double d2 = d * (Math.PI / 180);
            switch (n) {
                case 1: {
                    if (d % 180.0 == 0.0) {
                        d = 0.0;
                        this.fCalcButtons.number(0.0);
                        break;
                    }
                    d = Math.sin(d2);
                    this.fCalcButtons.number(d);
                    break;
                }
                case 2: {
                    if ((d - 90.0) % 180.0 == 0.0) {
                        d = 0.0;
                        this.fCalcButtons.number(0.0);
                        break;
                    }
                    d = Math.cos(d2);
                    this.fCalcButtons.number(d);
                    break;
                }
                case 3: {
                    d = d % 180.0 == 0.0 ? 0.0 : ((d - 90.0) % 180.0 == 0.0 ? Double.NaN : Math.tan(d2));
                    this.fCalcButtons.number(d);
                    break;
                }
                case 4: {
                    d = Math.IEEEremainder(d, Math.PI) == 0.0 ? 0.0 : Math.sin(d);
                    this.fCalcButtons.number(d);
                    break;
                }
                case 5: {
                    d = Math.IEEEremainder(d - 1.5707963267948966, Math.PI) == 0.0 ? 0.0 : Math.cos(d);
                    this.fCalcButtons.number(d);
                    break;
                }
                case 6: {
                    d = Math.IEEEremainder(d, Math.PI) == 0.0 ? 0.0 : (Math.IEEEremainder(d - 1.5707963267948966, Math.PI) == 0.0 ? Double.NaN : Math.tan(d));
                    this.fCalcButtons.number(d);
                    break;
                }
                case 12: {
                    d = 57.29577951308232 * Math.asin(d);
                    this.fCalcButtons.number(d);
                    break;
                }
                case 13: {
                    d = 57.29577951308232 * Math.acos(d);
                    this.fCalcButtons.number(d);
                    break;
                }
                case 14: {
                    d = 57.29577951308232 * Math.atan(d);
                    this.fCalcButtons.number(d);
                    break;
                }
                case 15: {
                    d = Math.asin(d);
                    this.fCalcButtons.number(d);
                    break;
                }
                case 16: {
                    d = Math.acos(d);
                    this.fCalcButtons.number(d);
                    break;
                }
                case 17: {
                    d = Math.atan(d);
                    this.fCalcButtons.number(d);
                    break;
                }
                case 7: {
                    d = Math.exp(d);
                    this.fCalcButtons.number(d);
                    break;
                }
                case 18: {
                    d = Math.log(d);
                    this.fCalcButtons.number(d);
                    break;
                }
                case 209: {
                    this.fCalcButtons.handleInput('\u00d1', bl);
                    return;
                }
                case 208: {
                    this.fCalcButtons.handleInput('\u00d0', bl);
                    return;
                }
                case 10: {
                    d = d == 0.0 ? Double.NaN : 1.0 / d;
                    this.fCalcButtons.number(d);
                    break;
                }
                case 11: {
                    d = Math.abs(d);
                    this.fCalcButtons.number(d);
                    break;
                }
                case 207: {
                    this.fCalcButtons.handleInput('\u00cf', bl);
                    return;
                }
                case 210: {
                    this.fCalcButtons.handleInput('\u00d2', bl);
                    return;
                }
            }
        }
        this.fCalcButtons.current(2);
        String string2 = CalcUtils.toString(d);
        this.fCalcButtons.displayString(string2);
        this.fDisplayField.setDisplay(d);
        this.fSpecialField.setResult(this.fDisplayField.displayStr());
        this.fSpecialField.pushFunctionToCurrent(string, n);
        if (bl) {
            this.fSpecialField.redraw();
            this.fDisplayField.repaint();
        }
    }

    public int userButtonNum() {
        return this.smallestUnusedUser();
    }

    public void setSelectUserButtonMode() {
        this.fSelectUserButtonMode = true;
        this.fSelectedUserButton = -1;
    }

    public void deleteUserButton(int n) {
        this.fSpecialField.cancelRow(n);
        this.deselectUserButton();
        this.fUserDefined[n] = false;
        this.fuser[n].visible(false);
        this.fCalc.myResize();
    }

    public void deleteButton() {
        if (!this.fSelectUserButtonMode) {
            return;
        }
        if (this.fSelectedUserButton == -1) {
            return;
        }
        this.deleteUserButton(this.fSelectedUserButton);
        this.fCalc.updateMenus();
    }

    public synchronized boolean mouseUp(Event event, int n, int n2) {
        if (this.fsind.handleMouseUp(n, n2)) {
            this.process(1, this.fsind.label(), true);
        }
        if (this.fcosd.handleMouseUp(n, n2)) {
            this.process(2, this.fcosd.label(), true);
        }
        if (this.ftand.handleMouseUp(n, n2)) {
            this.process(3, this.ftand.label(), true);
        }
        if (this.fsinr.handleMouseUp(n, n2)) {
            this.process(4, this.fsinr.label(), true);
        }
        if (this.fcosr.handleMouseUp(n, n2)) {
            this.process(5, this.fcosr.label(), true);
        }
        if (this.ftanr.handleMouseUp(n, n2)) {
            this.process(6, this.ftanr.label(), true);
        }
        if (this.fatox.handleMouseUp(n, n2)) {
            this.process(208, this.fatox.label(), true);
        }
        if (this.fxtoa.handleMouseUp(n, n2)) {
            this.process(207, this.fxtoa.label(), true);
        }
        if (this.foox.handleMouseUp(n, n2)) {
            this.process(10, this.foox.label(), true);
        }
        if (this.fabsx.handleMouseUp(n, n2)) {
            this.process(11, this.fabsx.label(), true);
        }
        if (this.fsindinv.handleMouseUp(n, n2)) {
            this.process(12, this.fsindinv.label(), true);
        }
        if (this.fcosdinv.handleMouseUp(n, n2)) {
            this.process(13, this.fcosdinv.label(), true);
        }
        if (this.ftandinv.handleMouseUp(n, n2)) {
            this.process(14, this.ftandinv.label(), true);
        }
        if (this.fsinrinv.handleMouseUp(n, n2)) {
            this.process(15, this.fsinrinv.label(), true);
        }
        if (this.fcosrinv.handleMouseUp(n, n2)) {
            this.process(16, this.fcosrinv.label(), true);
        }
        if (this.ftanrinv.handleMouseUp(n, n2)) {
            this.process(17, this.ftanrinv.label(), true);
        }
        if (this.fatoxinv.handleMouseUp(n, n2)) {
            this.process(209, this.fatoxinv.label(), true);
        }
        if (this.fxtoainv.handleMouseUp(n, n2)) {
            this.process(210, this.fxtoainv.label(), true);
        }
        if (this.fquestion.handleMouseUp(n, n2)) {
            this.process(21, this.fquestion.label(), true);
        }
        if (this.fdet.handleMouseUp(n, n2)) {
            this.fCalc.matrixCanvas().determinant();
        }
        int n3 = 0;
        while (n3 < 10) {
            if (this.fUserDefined[n3]) {
                if (this.fuser[n3].handleMouseUp(n, n2)) {
                    if (this.fSelectUserButtonMode && this.fSelectedUserButton == -1) {
                        this.fSelectedUserButton = n3;
                        this.fCalc.updateMenus();
                        this.repaint();
                        return true;
                    }
                    this.process(-n3 - 1, this.fuser[n3].label(), true);
                    break;
                }
                if (this.fuserInv[n3].handleMouseUp(n, n2)) {
                    if (this.fSelectUserButtonMode && this.fSelectedUserButton == -1) {
                        return true;
                    }
                    this.process(-n3 - 1 - 100, this.fuserInv[n3].label(), true);
                    break;
                }
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.fNumGrapherButtons) {
            if (this.fGrapherButtons[n4].handleMouseUp(n, n2)) {
                String string = this.fGrapherButtons[n4].label();
                try {
                    int n5 = (int)utils.str2num(string.substring(1, string.length()));
                    this.process(-n5 - 1 - 1000, string, true);
                }
                catch (FPNumberFormatException fPNumberFormatException) {}
            }
            ++n4;
        }
        if (!this.fCalc.editingButton()) {
            this.deselectUserButton();
        }
        this.fCalc.setFocus();
        this.repaint();
        return false;
    }

    public int selectedButton() {
        return this.fSelectedUserButton;
    }

    public synchronized boolean mouseDrag(Event event, int n, int n2) {
        boolean bl = false;
        if (this.fsind.handleMouseDrag(n, n2)) {
            bl = true;
        }
        if (this.fcosd.handleMouseDrag(n, n2)) {
            bl = true;
        }
        if (this.ftand.handleMouseDrag(n, n2)) {
            bl = true;
        }
        if (this.fsinr.handleMouseDrag(n, n2)) {
            bl = true;
        }
        if (this.fcosr.handleMouseDrag(n, n2)) {
            bl = true;
        }
        if (this.ftanr.handleMouseDrag(n, n2)) {
            bl = true;
        }
        if (this.fatox.handleMouseDrag(n, n2)) {
            bl = true;
        }
        if (this.fxtoa.handleMouseDrag(n, n2)) {
            bl = true;
        }
        if (this.foox.handleMouseDrag(n, n2)) {
            bl = true;
        }
        if (this.fabsx.handleMouseDrag(n, n2)) {
            bl = true;
        }
        if (this.fsindinv.handleMouseDrag(n, n2)) {
            bl = true;
        }
        if (this.fcosdinv.handleMouseDrag(n, n2)) {
            bl = true;
        }
        if (this.ftandinv.handleMouseDrag(n, n2)) {
            bl = true;
        }
        if (this.fsinrinv.handleMouseDrag(n, n2)) {
            bl = true;
        }
        if (this.fcosrinv.handleMouseDrag(n, n2)) {
            bl = true;
        }
        if (this.ftanrinv.handleMouseDrag(n, n2)) {
            bl = true;
        }
        if (this.fatoxinv.handleMouseDrag(n, n2)) {
            bl = true;
        }
        if (this.fxtoainv.handleMouseDrag(n, n2)) {
            bl = true;
        }
        if (this.fquestion.handleMouseDrag(n, n2)) {
            bl = true;
        }
        if (this.fdet.handleMouseDrag(n, n2)) {
            bl = true;
        }
        int n3 = 0;
        while (n3 < 10) {
            if (this.fUserDefined[n3]) {
                if (this.fuser[n3].handleMouseDrag(n, n2)) {
                    bl = true;
                }
                if (this.fuserInv[n3].handleMouseDrag(n, n2)) {
                    bl = true;
                }
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.fNumGrapherButtons) {
            if (this.fGrapherButtons[n4].handleMouseDrag(n, n2)) {
                bl = true;
            }
            ++n4;
        }
        if (bl) {
            this.repaint();
        }
        return false;
    }

    public boolean keyDown(Event event, int n) {
        this.fCalcButtons.requestFocus();
        this.fCalcButtons.keyDown(event, n);
        return false;
    }

    public String userButtonLabel(int n) {
        return this.fuser[n].label();
    }

    public void userButtonLabel(int n, String string) {
        this.fuser[n].label(string);
        this.fuser[n].visible(true);
    }

    public Evaluator evaluator(int n) {
        return this.fUserFunctions[n];
    }

    public void setEvaluator(int n, int n2, int[] nArray, int[] nArray2, char[] cArray) {
        this.fUserFunctions[n] = new Evaluator();
        int n3 = 0;
        while (n3 < n2) {
            if (nArray[n3] == 0) {
                this.fUserFunctions[n].add(cArray[n3]);
            } else if (nArray[n3] == 2) {
                this.fUserFunctions[n].add("", nArray2[n3]);
            }
            ++n3;
        }
    }
}

