/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPCalculator;

import com.questmsm.FPCalculator.Matrix;
import com.questmsm.FPCalculator.MatrixRowElement;
import com.questmsm.FPCalculator.MatrixView;
import java.awt.Graphics;
import java.io.Serializable;

public class MatrixRow
implements Serializable {
    private static final int kMaxElements = 20;
    private MatrixRowElement[] fElement = new MatrixRowElement[20];
    private int fNumElements = 0;
    private int fHeight;
    private int fTop;
    private int fLeft;
    protected static transient MatrixView fContainer;
    protected final int kSpacing = 3;

    public MatrixRow(MatrixView matrixView, int n) {
        fContainer = matrixView;
        this.fTop = n;
        this.fNumElements = 0;
    }

    public static void setContainer(MatrixView matrixView) {
        fContainer = matrixView;
    }

    public void recalculatePositions() {
        int n = fContainer.right() - 5;
        int n2 = 0;
        int n3 = this.height();
        int n4 = this.fTop;
        int n5 = this.fNumElements - 1;
        while (n5 >= 0) {
            n2 = this.fElement[n5].width();
            this.fElement[n5].setSpacing(n - 6 - n2, 3);
            if (this.fElement[n5] instanceof Matrix) {
                this.fElement[n5].top(n4 + (n3 - this.fElement[n5].height()) / 2);
            } else {
                this.fElement[n5].top(n4 + 7 + (n3 - this.fElement[n5].height()) / 2);
            }
            n = n - 6 - n2;
            --n5;
        }
    }

    public Matrix getNamedMatrix(String string) {
        Matrix matrix = null;
        int n = this.fNumElements - 1;
        while (n >= 0) {
            String string2;
            if (this.fElement[n] instanceof Matrix && string.equals(string2 = (matrix = (Matrix)this.fElement[n]).name())) {
                return matrix;
            }
            --n;
        }
        return null;
    }

    public void add(MatrixRowElement matrixRowElement) {
        if (this.fNumElements == 20) {
            return;
        }
        this.fElement[this.fNumElements] = matrixRowElement;
        ++this.fNumElements;
        this.recalculatePositions();
    }

    public void draw(Graphics graphics) {
        int n = 0;
        while (n < this.fNumElements) {
            this.fElement[n].draw(graphics);
            ++n;
        }
    }

    public void drawSelected(Graphics graphics) {
        int n = 0;
        while (n < this.fNumElements) {
            if (this.fElement[n].selected()) {
                this.fElement[n].draw(graphics);
            }
            ++n;
        }
    }

    public MatrixRowElement selectedElement() {
        int n = 0;
        while (n < this.fNumElements) {
            if (this.fElement[n].selected()) {
                return this.fElement[n];
            }
            ++n;
        }
        return null;
    }

    public MatrixRowElement element(int n) {
        return this.fElement[n];
    }

    public int numElements() {
        return this.fNumElements;
    }

    public boolean handleMouse(int n, int n2) {
        int n3 = 0;
        while (n3 < this.fNumElements) {
            if (this.fElement[n3].inElement(n, n2)) {
                this.fElement[n3].select(true);
                return true;
            }
            ++n3;
        }
        return false;
    }

    public void clear() {
    }

    public void clearSelect() {
        int n = 0;
        while (n < this.fNumElements) {
            this.fElement[n].select(false);
            ++n;
        }
    }

    public int left() {
        int n = fContainer.right();
        int n2 = 0;
        while (n2 < this.fNumElements) {
            if (this.fElement[n2].left() < n) {
                n = this.fElement[n2].left();
            }
            ++n2;
        }
        return n;
    }

    public int top() {
        return this.fTop;
    }

    public int height() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.fNumElements) {
            if (this.fElement[n2].height() > n) {
                n = this.fElement[n2].height();
            }
            ++n2;
        }
        return n;
    }
}

