/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPCalculator;

import com.questmsm.FPCalculator.Matrix;
import com.questmsm.FPCalculator.MatrixNumber;
import com.questmsm.FPCalculator.MatrixOp;
import com.questmsm.FPCalculator.MatrixRow;
import com.questmsm.FPCalculator.MatrixRowElement;

public class MatrixRowEvaluator {
    private static final int kStackSize = 20;
    private static MatrixRowElement[] fElementStack = new MatrixRowElement[20];
    private static int fElementTop = 0;
    private static char[] fInstructionStack = new char[20];
    private static int fInstructionTop = 0;
    private static boolean fIsCurrentAMatrix = false;
    private static Matrix fCurrentMatrix;
    private static double fCurrentNumber;

    private static void pushElement(MatrixRowElement matrixRowElement) {
        if (fElementTop == 20) {
            return;
        }
        MatrixRowEvaluator.fElementStack[MatrixRowEvaluator.fElementTop] = matrixRowElement;
        ++fElementTop;
    }

    private static void pushInstruction(char c) {
        if (fInstructionTop == 20) {
            return;
        }
        MatrixRowEvaluator.fInstructionStack[MatrixRowEvaluator.fInstructionTop] = c;
        ++fInstructionTop;
    }

    private static char peekInstruction() {
        if (fInstructionTop == 0) {
            return '?';
        }
        return fInstructionStack[fInstructionTop - 1];
    }

    private static char popInstruction() {
        if (fInstructionTop == 0) {
            return '?';
        }
        return fInstructionStack[--fInstructionTop];
    }

    private static MatrixRowElement popElement() {
        if (fElementTop == 0) {
            return null;
        }
        return fElementStack[--fElementTop];
    }

    private static void doPush() {
        if (fIsCurrentAMatrix) {
            MatrixRowEvaluator.pushElement(fCurrentMatrix);
        } else {
            MatrixRowEvaluator.pushElement(new MatrixNumber(fCurrentNumber));
        }
    }

    private static boolean instructionStackEmpty() {
        return fInstructionTop == 0;
    }

    public static Matrix eval(MatrixRow matrixRow) {
        int n = matrixRow.numElements();
        fCurrentNumber = 0.0;
        fCurrentMatrix = null;
        fElementTop = 0;
        fInstructionTop = 0;
        int n2 = 0;
        while (n2 < n) {
            MatrixRowElement matrixRowElement = matrixRow.element(n2);
            if (matrixRowElement instanceof Matrix) {
                fCurrentMatrix = (Matrix)matrixRowElement;
                fIsCurrentAMatrix = true;
            } else if (matrixRowElement instanceof MatrixNumber) {
                fCurrentNumber = ((MatrixNumber)matrixRowElement).val();
                fIsCurrentAMatrix = false;
            } else if (matrixRowElement instanceof MatrixOp) {
                char c = ((MatrixOp)matrixRowElement).label().charAt(0);
                switch (c) {
                    case '+': 
                    case '-': {
                        if (!MatrixRowEvaluator.instructionStackEmpty() && MatrixRowEvaluator.doOperationPlus()) {
                            return null;
                        }
                        MatrixRowEvaluator.doPush();
                        MatrixRowEvaluator.pushInstruction(c);
                        break;
                    }
                    case '*': 
                    case '/': {
                        char c2;
                        if (!MatrixRowEvaluator.instructionStackEmpty() && ((c2 = MatrixRowEvaluator.peekInstruction()) == '*' || c == '/') && MatrixRowEvaluator.doOperationMult()) {
                            return null;
                        }
                        MatrixRowEvaluator.doPush();
                        MatrixRowEvaluator.pushInstruction(c);
                        break;
                    }
                    case '(': {
                        MatrixRowEvaluator.pushInstruction('(');
                        break;
                    }
                    case ')': {
                        if (MatrixRowEvaluator.doOperationPlus()) {
                            return null;
                        }
                        MatrixRowEvaluator.popInstruction();
                        break;
                    }
                }
            }
            ++n2;
        }
        if (MatrixRowEvaluator.doOperationPlus()) {
            return null;
        }
        if (fIsCurrentAMatrix && fCurrentMatrix != null) {
            return fCurrentMatrix.copy();
        }
        fCurrentMatrix = new Matrix(1, 1, "");
        fCurrentMatrix.setVal(0, 0, fCurrentNumber);
        fCurrentMatrix.adjustColWidths();
        return fCurrentMatrix;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean doOperation() {
        char c = MatrixRowEvaluator.popInstruction();
        MatrixRowElement matrixRowElement = MatrixRowEvaluator.popElement();
        if (matrixRowElement == null) {
            return true;
        }
        if (matrixRowElement instanceof MatrixNumber) {
            double d = ((MatrixNumber)matrixRowElement).val();
            if (fIsCurrentAMatrix) {
                switch (c) {
                    case '*': {
                        fCurrentMatrix = fCurrentMatrix.scalarMult(d);
                        break;
                    }
                    case '-': {
                        fCurrentMatrix = fCurrentMatrix.scalarMult(-1.0);
                    }
                    case '+': {
                        fCurrentMatrix = fCurrentMatrix.scalarAdd(d);
                        break;
                    }
                }
                if (fCurrentMatrix != null) return false;
                return true;
            }
            switch (c) {
                case '*': {
                    fCurrentNumber *= d;
                    return false;
                }
                case '/': {
                    fCurrentNumber = d / fCurrentNumber;
                    return false;
                }
                case '-': {
                    fCurrentNumber = d - fCurrentNumber;
                    return false;
                }
                case '+': {
                    fCurrentNumber += d;
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        Matrix matrix = (Matrix)matrixRowElement;
        if (fIsCurrentAMatrix) {
            switch (c) {
                case '*': {
                    fCurrentMatrix = matrix.times(fCurrentMatrix);
                    break;
                }
                case '-': {
                    fCurrentMatrix = matrix.minus(fCurrentMatrix);
                    break;
                }
                case '+': {
                    fCurrentMatrix = matrix.plus(fCurrentMatrix);
                    break;
                }
            }
            if (fCurrentMatrix != null) return false;
            return true;
        }
        fIsCurrentAMatrix = true;
        switch (c) {
            case '*': {
                fCurrentMatrix = matrix.scalarMult(fCurrentNumber);
                break;
            }
            case '/': {
                fCurrentMatrix = matrix.scalarMult(1.0 / fCurrentNumber);
                break;
            }
            case '-': {
                fCurrentMatrix = matrix.scalarAdd(-fCurrentNumber);
                break;
            }
            case '+': {
                fCurrentMatrix = matrix.scalarAdd(fCurrentNumber);
                break;
            }
        }
        if (fCurrentMatrix != null) return false;
        return true;
    }

    private static boolean doOperationPlus() {
        while (!MatrixRowEvaluator.instructionStackEmpty()) {
            char c = MatrixRowEvaluator.peekInstruction();
            if (c == '(') break;
            MatrixRowEvaluator.doOperation();
        }
        return false;
    }

    private static boolean doOperationMult() {
        if (!MatrixRowEvaluator.instructionStackEmpty()) {
            char c = MatrixRowEvaluator.peekInstruction();
            if (c != '(' && c != '+' && c != '-') {
                return MatrixRowEvaluator.doOperation();
            }
        }
        return false;
    }
}

