/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPCalculator;

import com.questmsm.FPCalculator.CalcUtils;
import com.questmsm.FPCalculator.Calculator;
import com.questmsm.FPCalculator.CreateMatrixFrame;
import com.questmsm.FPCalculator.Matrix;
import com.questmsm.FPCalculator.MatrixNumber;
import com.questmsm.FPCalculator.MatrixOp;
import com.questmsm.FPCalculator.MatrixRow;
import com.questmsm.FPCalculator.MatrixRowElement;
import com.questmsm.FPCalculator.MatrixRowEvaluator;
import com.questmsm.FPCalculator.MatrixViewPanel;
import com.questmsm.FunctionProbe.Master;
import com.questmsm.Utilities.fp_resource;
import com.questmsm.Utilities.utils;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Properties;

public class MatrixView
extends Canvas {
    private static MatrixViewPanel fPanel;
    private static Font fMainFont;
    private static FontMetrics fMainMetric;
    private static Calculator fCalc;
    public static final int kMaxMatrixRows = 100;
    private static MatrixRow[] fRows;
    private int fLastRow;
    private int fPageWidth = 100;
    private int fPageHeight = 100;
    private static Image fBackgroundImage;
    private static Image fForegroundImage;
    private static Graphics fBackgroundGraphics;
    private static Graphics fForegroundGraphics;
    public static int dx;
    public static int dy;
    private static double fNumber;
    public static final int kNothing = 0;
    public static final int kNumber = 1;
    public static final int kMatrix = 2;
    public static final int kPlus = 3;
    public static final int kMinus = 4;
    public static final int kTimes = 5;
    public static final int kDiv = 6;
    public static final int kEquals = 7;
    public static final int kNum = 8;
    public static final int kError = 9;
    private static int fCurrent;
    private static final int kPreDecimal = 0;
    private static final int kPostDecimal = 1;
    private static int fDecimal;
    private static int fDecimalPlace;
    private static int fNumOpenParens;
    private static String fDisplayString;
    private static Matrix fCurrentMatrix;
    private static int fCurrentRows;
    private static int fCurrentCols;
    static final int XINDENT = 40;
    static final int YINDENT = 40;

    static {
        fRows = new MatrixRow[100];
        fBackgroundImage = null;
        fForegroundImage = null;
        fBackgroundGraphics = null;
        fForegroundGraphics = null;
        fNumber = 0.0;
        fCurrent = 0;
        fDecimal = 0;
        fDecimalPlace = 0;
        fNumOpenParens = 0;
        fDisplayString = "0";
        fCurrentMatrix = null;
        fCurrentRows = 0;
        fCurrentCols = 0;
    }

    public MatrixView(MatrixViewPanel matrixViewPanel, Calculator calculator, Color color) {
        fCalc = calculator;
        fPanel = matrixViewPanel;
        this.setBackground(color);
        fMainFont = new Font("Helvetica", 0, 14);
        fMainMetric = this.getFontMetrics(fMainFont);
        this.fLastRow = 0;
        dx = 0;
        dy = 0;
        Matrix.setMetric(this);
        MatrixView.fRows[this.fLastRow] = new MatrixRow(this, 5);
        this.addComponentListener(new 1());
        this.addMouseListener(new 2());
    }

    public void createImages() {
        this.createImages(this.fPageWidth, this.fPageHeight);
    }

    public void createImages(int n, int n2) {
        if (this.fPageWidth == n && this.fPageHeight == n2 && fBackgroundImage != null) {
            return;
        }
        fBackgroundImage = this.createImage(n, n2);
        if (fBackgroundImage == null) {
            return;
        }
        fBackgroundGraphics = fBackgroundImage.getGraphics();
        fForegroundImage = this.createImage(n, n2);
        fForegroundGraphics = fForegroundImage.getGraphics();
        this.fPageWidth = n;
        this.fPageHeight = n2;
        this.recalculate();
        this.drawBackground();
    }

    public void clearRow() {
        fRows[this.fLastRow].clear();
    }

    public void recalculate() {
        boolean bl = false;
        int n = 0;
        while (n <= this.fLastRow) {
            fRows[n].recalculatePositions();
            ++n;
        }
    }

    public void myResize(int n, int n2) {
        if (n + dx > this.fPageWidth) {
            this.createImages(n + dx, this.fPageHeight);
        }
        if (n2 + dy > this.fPageHeight) {
            this.createImages(this.fPageWidth, n2 + dy);
        }
        super.setSize(n, n2);
    }

    public void myResize() {
        this.myResize(this.getSize().width, this.getSize().height);
    }

    public void determinant() {
        if (!this.isCurrentAMatrix() || fCurrentMatrix == null) {
            utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_error__cant_take_determinant__no_current_matrix"));
            return;
        }
        StringBuffer stringBuffer = new StringBuffer("");
        double d = fCurrentMatrix.det(stringBuffer);
        if (d == -1.23456123) {
            utils.showErrorDialog(Master.gFrame, stringBuffer.toString());
            return;
        }
        fCalc.specialField().makePassiveRow("det(" + fCurrentMatrix.name() + ") = ", CalcUtils.toString(d));
        fCalc.specialField().redraw();
    }

    private synchronized void drawBackground(Graphics graphics, boolean bl) {
        if (graphics == null) {
            return;
        }
        if (bl) {
            graphics.setColor(Color.white);
        } else {
            graphics.setColor(Color.lightGray);
        }
        graphics.fillRect(0, 0, this.fPageWidth, this.fPageHeight);
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, this.fPageWidth - 1, this.fPageHeight - 1);
        graphics.setFont(fMainFont);
        int n = 0;
        while (n <= this.fLastRow) {
            fRows[n].draw(graphics);
            ++n;
        }
    }

    private synchronized void drawBackground(Graphics graphics) {
        this.drawBackground(graphics, false);
    }

    public synchronized void drawBackground() {
        this.drawBackground(fBackgroundGraphics);
    }

    private synchronized void drawForeground(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        graphics.setFont(fMainFont);
        int n = 0;
        while (n <= this.fLastRow) {
            fRows[n].drawSelected(graphics);
            ++n;
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void doPrint() {
        Properties properties = new Properties();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        PrintJob printJob = toolkit.getPrintJob(fPanel, fp_resource.getString("str_matrix"), properties);
        if (printJob == null) {
            return;
        }
        Dimension dimension = printJob.getPageDimension();
        dimension.width -= 80;
        dimension.height -= 80;
        int n = (int)Math.floor((double)this.fPageWidth / (double)dimension.width) + 1;
        int n2 = (int)Math.floor((double)this.fPageHeight / (double)dimension.height) + 1;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n3 * dimension.height + 40;
            int n5 = 0;
            while (n5 < n) {
                int n6 = n5 * dimension.width + 40;
                Graphics graphics = printJob.getGraphics();
                graphics.translate(n6, n4);
                graphics.setClip(0, 0, dimension.width + n6, dimension.height + n4);
                this.drawBackground(graphics, true);
                graphics.translate(-n6, -n4);
                graphics.dispose();
                ++n5;
            }
            ++n3;
        }
        printJob.end();
    }

    public synchronized void paint(Graphics graphics) {
        if (fBackgroundImage == null) {
            this.createImages();
        }
        if (fForegroundImage == null) {
            return;
        }
        fForegroundGraphics.drawImage(fBackgroundImage, 0, 0, this);
        this.drawForeground(fForegroundGraphics);
        graphics.translate(-dx, -dy);
        graphics.drawImage(fForegroundImage, 0, 0, this);
        graphics.translate(dx, dy);
    }

    private void adjustHScrollbar() {
        if (fRows[this.fLastRow].left() < 10) {
            int n = this.fPageWidth - fRows[this.fLastRow].left() + 10;
            this.createImages(n, this.fPageHeight);
            fPanel.setScrollSettings();
            fPanel.setHScrollVal(dx -= fRows[this.fLastRow].left() - 10);
        }
    }

    public void pushNumToCurrentRow(double d) {
        fRows[this.fLastRow].add(new MatrixNumber(d, this));
        this.adjustHScrollbar();
    }

    public void pushToCurrentRow(MatrixRowElement matrixRowElement) {
        fRows[this.fLastRow].add(matrixRowElement);
        this.adjustHScrollbar();
    }

    public synchronized boolean mouseDrag(Event event, int n, int n2) {
        n += dx;
        n2 += dy;
        int n3 = 0;
        while (n3 <= this.fLastRow) {
            fRows[n3].clearSelect();
            ++n3;
        }
        int n4 = 0;
        while (n4 <= this.fLastRow) {
            if (fRows[n4].handleMouse(n, n2)) {
                this.repaint();
                return true;
            }
            ++n4;
        }
        this.repaint();
        return false;
    }

    public boolean keyDown(Event event, int n) {
        fCalc.setFocus();
        fCalc.buttonsKeyDown(event, n);
        return false;
    }

    private boolean newRow() {
        if (this.fLastRow == 100) {
            return true;
        }
        ++this.fLastRow;
        MatrixView.fRows[this.fLastRow] = new MatrixRow(this, fRows[this.fLastRow - 1].top() + fRows[this.fLastRow - 1].height() + 5);
        if (fRows[this.fLastRow].top() + 100 > this.fPageHeight) {
            this.createImages(this.fPageWidth, fRows[this.fLastRow].top() + 100);
            fPanel.setScrollSettings();
            fPanel.scrollToBottom();
        }
        fPanel.scrollToRight();
        return false;
    }

    public Matrix currentMatrix() {
        return fCurrentMatrix;
    }

    public boolean isCurrentAMatrix() {
        if (fCurrentMatrix == null) {
            return false;
        }
        return fCurrent == 2 || fCurrent == 7;
    }

    public boolean isCurrentMatrixAugmented() {
        if (fCurrentMatrix == null) {
            return false;
        }
        if (!this.isCurrentAMatrix()) {
            return false;
        }
        return fCurrentMatrix.augmented();
    }

    public boolean isCurrentSquare() {
        if (fCurrentMatrix == null) {
            return false;
        }
        return fCurrentMatrix.isSquare();
    }

    public boolean system() {
        if (fCurrentMatrix == null) {
            return false;
        }
        return fCurrentMatrix.system();
    }

    public void doInverse() {
        if (fCurrentMatrix == null) {
            return;
        }
        if (fCurrent != 2) {
            return;
        }
        if (!fCurrentMatrix.square()) {
            return;
        }
        this.handleNewMatrix(fCurrentMatrix.invert());
        this.drawBackground();
        this.repaint();
    }

    public void splitMatrix() {
        if (fCurrentMatrix == null) {
            return;
        }
        if (!fCurrentMatrix.augmented()) {
            return;
        }
        Matrix matrix = fCurrentMatrix;
        this.handleNewMatrix(matrix.leftMatrix());
        this.handleNewMatrix(matrix.rightMatrix());
    }

    public boolean allowMatrix() {
        return fCurrent == 2 || fCurrent == 5 || fCurrent == 3 || fCurrent == 4 || fCurrent == 7 || fCurrent == 0;
    }

    public boolean handleNewMatrix(Matrix matrix) {
        if (matrix == null) {
            utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_error__tried_to_add_null_matrix"));
            return false;
        }
        if (!this.allowMatrix()) {
            utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_error__a_matrix_may_not_be_entered_in_this_context"));
            return false;
        }
        if (fCurrent == 2) {
            this.newRow();
        }
        this.pushToCurrentRow(matrix);
        fCurrentMatrix = matrix;
        this.current(2);
        this.redraw();
        fCalc.updateMenus();
        return true;
    }

    public void newMatrix() {
        CreateMatrixFrame createMatrixFrame = new CreateMatrixFrame(fCalc, Matrix.newMatrixName());
        if (fCurrent == 5) {
            createMatrixFrame.setRows(fCurrentMatrix.numCols());
        } else if (fCurrent == 3) {
            createMatrixFrame.setRows(fCurrentMatrix.numRows());
            createMatrixFrame.setCols(fCurrentMatrix.numCols());
        } else if (fCurrent == 4) {
            createMatrixFrame.setRows(fCurrentMatrix.numRows());
            createMatrixFrame.setCols(fCurrentMatrix.numCols());
        } else if (fCurrent == 8) {
            return;
        }
        ((Component)createMatrixFrame).setVisible(true);
    }

    public void doScalarMult() {
        this.pushToCurrentRow(new MatrixOp("="));
        if (this.newRow()) {
            return;
        }
        if (fCurrentMatrix == null) {
            utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_error__null_matrix"));
            return;
        }
        Matrix matrix = fCurrentMatrix.scalarMult(fNumber);
        this.pushToCurrentRow(matrix);
        this.current(2);
        fCurrentMatrix = matrix;
    }

    public void callMatrix(String string) {
        int n = this.fLastRow;
        while (n >= 0) {
            Matrix matrix = fRows[n].getNamedMatrix(string);
            if (matrix != null) {
                this.handleNewMatrix(matrix.copy());
                return;
            }
            --n;
        }
        utils.showWarningDialog(Master.gFrame, utils.sprintf(fp_resource.getString("str_cant_find_matrix"), string));
    }

    public synchronized void redraw() {
        this.drawBackground();
        this.repaint();
    }

    public void translate(int n, int n2) {
        dx = n;
        dy = n2;
    }

    public void current(int n) {
        if (fCurrent == n) {
            return;
        }
        fCurrent = n;
        fCalc.calcCanvas().setButtonEnables();
    }

    public void endRow() {
        if (fCurrent != 2 && fCurrent != 8 || fNumOpenParens != 0) {
            return;
        }
        if (fCurrent == 8) {
            this.pushNumToCurrentRow(fNumber);
        }
        this.pushToCurrentRow(new MatrixOp("="));
        Matrix matrix = MatrixRowEvaluator.eval(fRows[this.fLastRow]);
        if (matrix == null) {
            this.pushToCurrentRow(new MatrixOp("?"));
            this.current(9);
        } else {
            this.pushToCurrentRow(matrix);
            matrix.autoName();
            this.current(7);
        }
        fCurrentMatrix = matrix;
        this.newRow();
        this.redraw();
        fDisplayString = "0";
        fCalc.displayField().setDisplay(fDisplayString);
        fCalc.displayField().repaint();
        fCalc.updateMenus();
    }

    public void matrixViewInput(char c) {
        switch (c) {
            case 'i': {
                if (fCurrent != 8) {
                    return;
                }
                fDisplayString = CalcUtils.toString(fNumber *= -1.0);
                break;
            }
            case '\u0001': {
                if (fCurrent == 8) {
                    return;
                }
                if (fCurrent == 2) {
                    this.newRow();
                }
                this.pushNumToCurrentRow(Math.PI);
                this.redraw();
                this.current(2);
                fDisplayString = "0";
                break;
            }
            case '\u0002': {
                if (fCurrent == 8) {
                    return;
                }
                if (fCurrent == 2) {
                    this.newRow();
                }
                this.pushNumToCurrentRow(Math.E);
                this.redraw();
                this.current(2);
                fDisplayString = "0";
                break;
            }
            case '\u0003': {
                fNumber = 0.0;
                fDisplayString = "0";
                this.current(0);
                break;
            }
            case '\u0004': {
                this.clearRow();
                fDisplayString = "0";
                this.current(0);
                this.redraw();
                break;
            }
            case '=': {
                this.endRow();
                return;
            }
            case '*': {
                if (fCurrent != 2 && fCurrent != 8 && fCurrent != 7) {
                    return;
                }
                if (fCurrent == 8) {
                    this.pushNumToCurrentRow(fNumber);
                }
                if (fCurrent == 7) {
                    this.pushToCurrentRow(fCurrentMatrix.copy());
                }
                this.current(5);
                this.pushToCurrentRow(new MatrixOp("*"));
                this.redraw();
                fDisplayString = "0";
                break;
            }
            case '/': {
                if (fCurrent != 2 && fCurrent != 8 && fCurrent != 7) {
                    return;
                }
                if (fCurrent == 8) {
                    this.pushNumToCurrentRow(fNumber);
                }
                if (fCurrent == 7) {
                    this.pushToCurrentRow(fCurrentMatrix.copy());
                }
                this.current(6);
                this.pushToCurrentRow(new MatrixOp("/"));
                this.redraw();
                fDisplayString = "0";
                break;
            }
            case '+': {
                if (fCurrent != 2 && fCurrent != 8 && fCurrent != 7) {
                    return;
                }
                if (fCurrent == 8) {
                    this.pushNumToCurrentRow(fNumber);
                }
                if (fCurrent == 7) {
                    this.pushToCurrentRow(fCurrentMatrix.copy());
                }
                this.current(3);
                this.pushToCurrentRow(new MatrixOp("+"));
                this.redraw();
                fDisplayString = "0";
                break;
            }
            case '-': {
                if (fCurrent != 2 && fCurrent != 8 && fCurrent != 7) {
                    return;
                }
                if (fCurrent == 8) {
                    this.pushNumToCurrentRow(fNumber);
                }
                if (fCurrent == 7) {
                    this.pushToCurrentRow(fCurrentMatrix.copy());
                }
                this.current(4);
                this.pushToCurrentRow(new MatrixOp("-"));
                this.redraw();
                fDisplayString = "0";
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                if (fCurrent == 3 || fCurrent == 4) {
                    return;
                }
                if (fCurrent == 2) {
                    this.newRow();
                }
                if (fCurrent == 8) {
                    if (fDecimal == 0) {
                        fNumber = fNumber * 10.0 + (double)c - 48.0;
                    } else {
                        fNumber += (double)(c - 48) / Math.pow(10.0, fDecimalPlace);
                        ++fDecimalPlace;
                    }
                    fDisplayString = String.valueOf(fDisplayString) + String.valueOf(c - 48);
                    break;
                }
                fDisplayString = String.valueOf(c - 48);
                fNumber = c - 48;
                fDecimal = 0;
                fDecimalPlace = 0;
                this.current(8);
                break;
            }
            case '.': {
                if (fCurrent == 2) {
                    this.newRow();
                }
                if (fCurrent == 8) {
                    if (fDecimal != 0) break;
                    fDisplayString = String.valueOf(fDisplayString) + ".";
                    fDecimalPlace = 1;
                    fDecimal = 1;
                    break;
                }
                fDisplayString = "0.";
                fDecimalPlace = 1;
                fNumber = 0.0;
                fDecimal = 1;
                this.current(8);
                break;
            }
            case '(': {
                if (fCurrent == 8) {
                    return;
                }
                if (fCurrent == 2) {
                    this.newRow();
                }
                this.pushToCurrentRow(new MatrixOp("("));
                ++fNumOpenParens;
                this.redraw();
                this.current(0);
                fNumber = 0.0;
                fDisplayString = "0";
                break;
            }
            case ')': {
                if (fCurrent != 2 && fCurrent != 8 || fNumOpenParens <= 0) {
                    return;
                }
                if (fCurrent == 8) {
                    this.pushNumToCurrentRow(fNumber);
                }
                this.pushToCurrentRow(new MatrixOp(")"));
                --fNumOpenParens;
                this.redraw();
                this.current(2);
                fNumber = 0.0;
                fDisplayString = "0";
                break;
            }
            default: {
                return;
            }
        }
        fCalc.displayField().setDisplay(fDisplayString);
        fCalc.displayField().repaint();
        fCalc.updateMenus();
    }

    public void clear() {
        int n = 0;
        while (n <= this.fLastRow) {
            MatrixView.fRows[n] = null;
            ++n;
        }
        this.fLastRow = 0;
        dx = 0;
        dy = 0;
        MatrixView.fRows[this.fLastRow] = new MatrixRow(this, 5);
        this.createImages(this.getSize().width, this.getSize().height);
        fCurrent = 0;
        fNumOpenParens = 0;
        fDecimalPlace = 0;
        fDecimal = 0;
        fCurrentMatrix = null;
        fCurrentRows = 0;
        fCurrentCols = 0;
        Matrix.gMatrixNum = 0;
        this.drawBackground();
        this.repaint();
        fPanel.setHScrollVal(dx);
        fPanel.setVScrollVal(dy);
        fPanel.setScrollSettings();
    }

    public MatrixViewPanel parent() {
        return fPanel;
    }

    public int numRows() {
        return this.fLastRow;
    }

    public void numRows(int n) {
        this.fLastRow = n;
    }

    public MatrixRow row(int n) {
        return fRows[n];
    }

    public void setRow(int n, MatrixRow matrixRow) {
        MatrixView.fRows[n] = matrixRow;
    }

    public int right() {
        return this.fPageWidth;
    }

    public int pageHeight() {
        return this.fPageHeight;
    }

    public int pageWidth() {
        return this.fPageWidth;
    }

    public void pageHeight(int n) {
        this.fPageHeight = n;
    }

    public void pageWidth(int n) {
        this.fPageWidth = n;
    }

    public void number(double d) {
        fNumber = d;
    }

    public double number() {
        return fNumber;
    }

    public int current() {
        return fCurrent;
    }

    public int decimal() {
        return fDecimal;
    }

    public void decimal(int n) {
        fDecimal = n;
    }

    public int decimalPlace() {
        return fDecimalPlace;
    }

    public void decimalPlace(int n) {
        fDecimalPlace = n;
    }

    public int numOpenParens() {
        return fNumOpenParens;
    }

    public void numOpenParens(int n) {
        fNumOpenParens = n;
    }

    public String displayString() {
        return fDisplayString;
    }

    public void displayString(String string) {
        fDisplayString = string;
    }

    private final class 1
    extends ComponentAdapter {
        public void componentResized(ComponentEvent componentEvent) {
            MatrixView.this.myResize(MatrixView.this.getBounds().width, MatrixView.this.getBounds().height);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            int n = mouseEvent.getX() + dx;
            int n2 = mouseEvent.getY() + dy;
            int n3 = 0;
            while (n3 <= MatrixView.this.fLastRow) {
                fRows[n3].clearSelect();
                ++n3;
            }
            int n4 = 0;
            while (n4 <= MatrixView.this.fLastRow) {
                if (fRows[n4].handleMouse(n, n2)) {
                    MatrixView.this.repaint();
                    return;
                }
                ++n4;
            }
            MatrixView.this.repaint();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            int n = mouseEvent.getX() + dx;
            int n2 = mouseEvent.getY() + dy;
            int n3 = 0;
            while (n3 <= MatrixView.this.fLastRow) {
                MatrixRowElement matrixRowElement;
                if (fRows[n3].handleMouse(n, n2) && (matrixRowElement = fRows[n3].selectedElement()) != null) {
                    if (matrixRowElement instanceof Matrix) {
                        matrixRowElement.select(false);
                        if (MatrixView.this.handleNewMatrix(((Matrix)matrixRowElement).copy())) {
                            MatrixView.this.repaint();
                        }
                        return;
                    }
                    fRows[n3].clearSelect();
                }
                ++n3;
            }
            int n4 = 0;
            while (n4 <= MatrixView.this.fLastRow) {
                fRows[n4].clearSelect();
                ++n4;
            }
            MatrixView.this.repaint();
        }

        /* synthetic */ 2() {
        }
    }
}

