/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPCalculator;

import com.questmsm.FPCalculator.CalcUtils;
import com.questmsm.FPCalculator.Calculator;
import com.questmsm.FPCalculator.Matrix;
import com.questmsm.FunctionProbe.Master;
import com.questmsm.Utilities.DialogField;
import com.questmsm.Utilities.DialogSuperClass;
import com.questmsm.Utilities.FPNumberFormatException;
import com.questmsm.Utilities.fp_resource;
import com.questmsm.Utilities.utils;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.TextArea;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class RowReduceDialog
extends DialogSuperClass {
    private Calculator fCalc;
    private Matrix fMatrix;
    private static final int kMaxSteps = 30;
    private Matrix[] fMatrixList = new Matrix[30];
    private String[] fStringList = new String[30];
    private int fCurrentStep;
    private int fRowA = 1;
    private int fRowB = 2;
    private int fRowC = 1;
    private int fRowD = 2;
    private int fOpA = 1;
    private int fOpB = 1;
    private int fOpC = 1;
    private DialogField fFieldA;
    private DialogField fFieldB;
    private Button fDoOp1;
    private Button fDoOp2;
    private TextArea fHistoryList;
    private static int kWindowWidth;
    private int kRowWidth = 20;
    private int kOpWidth = 10;
    private int kFieldWidth = 45;
    private int kHistoryHeight = 60;
    private int ht;
    private static int kHistoryTop;
    private static int kRowAx;
    private static int kArrowx;
    private static int kRowEx;
    private static int kOpBx;
    private static int kRowBx;
    private static int kOpAx;
    private static int kFieldAx;
    private static int kButton1x;
    private static int kRowCx;
    private static int kArrow2x;
    private static int kRowDx;
    private static int kButton2x;
    private static int kOpCx;
    private static int kFieldBx;
    private static int kOp1y;
    private static int kOp2y;
    private static int kOKy;
    private static final int kMatrixTop = 40;
    private static Button fUndo;

    public RowReduceDialog(Calculator calculator, Matrix matrix) {
        super(calculator);
        int n = Master.gSmallTop;
        this.setTitle(matrix.name());
        this.fMatrix = matrix.copy();
        this.fMatrix.name("");
        this.fMatrix.adjustColWidths();
        this.fMatrix.top(20 + n);
        this.fCurrentStep = 0;
        this.fMatrixList[this.fCurrentStep] = this.fMatrix.copy();
        this.fStringList[this.fCurrentStep] = "";
        this.ht = this.fDialogMetrics.getHeight();
        this.kRowWidth = Math.max(20, this.ch_advance);
        this.kOpWidth = 10;
        this.kFieldWidth = 45;
        this.kHistoryHeight = Math.max(60, this.ht * 3);
        kWindowWidth = Math.max(300, 100 + this.fMatrix.width() * 2);
        kRowAx = kWindowWidth / 2 - 130;
        kArrowx = kRowAx + this.kRowWidth;
        kRowEx = kArrowx + 14;
        kOpCx = kRowEx + this.kRowWidth;
        kFieldBx = kOpCx + this.kOpWidth;
        kOpBx = kFieldBx + this.kFieldWidth + 2;
        kRowBx = kOpBx + this.kOpWidth + 2;
        kOpAx = kRowBx + this.kRowWidth;
        kFieldAx = kOpAx + this.kOpWidth;
        kButton1x = kFieldAx + this.kFieldWidth + 18;
        kRowCx = kRowAx + 70;
        kArrow2x = kRowCx + this.kRowWidth;
        kRowDx = kArrow2x + 20;
        kButton2x = kRowDx + this.kRowWidth + 18;
        this.adjustMatrixLeft();
        this.fCalc = calculator;
        this.setLayout(null);
        kHistoryTop = 40 + matrix.height() + n;
        kOp1y = kHistoryTop + this.kHistoryHeight + 35;
        kOp2y = kOp1y + 27;
        kOKy = kOp2y + 55;
        this.fFieldA = new DialogField("1");
        this.fFieldB = new DialogField("1");
        this.add(this.fFieldA);
        this.add(this.fFieldB);
        this.setTextFieldColors(this.fFieldA);
        this.setTextFieldColors(this.fFieldB);
        this.fFieldA.setBounds(kFieldAx, kOp1y - 12, this.kFieldWidth, this.ht);
        this.fFieldB.setBounds(kFieldBx, kOp1y - 12, this.kFieldWidth, this.ht);
        this.fDoOp1 = new Button(fp_resource.getString("str_do_it"));
        this.fDoOp2 = new Button(fp_resource.getString("str_do_it"));
        DialogSuperClass.setButtonColors(this.fDoOp1);
        DialogSuperClass.setButtonColors(this.fDoOp2);
        this.fDoOp1.setBounds(kButton1x, kOp1y - 13, 50, this.ht);
        this.fDoOp2.setBounds(kButton2x, kOp2y - 13, 50, this.ht);
        this.add(this.fDoOp1);
        this.add(this.fDoOp2);
        this.fHistoryList = new TextArea("", 0, 0, 1);
        this.fHistoryList.setEditable(false);
        this.fHistoryList.setFont(fp_resource.getFont("font_row_ops_history_window"));
        this.add(this.fHistoryList);
        this.fHistoryList.setBounds(kWindowWidth / 2 - 80, kHistoryTop, 160, this.kHistoryHeight);
        ((Component)this.fHistoryList).setBackground(Color.white);
        this.add(this.fOK);
        this.add(this.fCancel);
        this.setBounds(100, 100, kWindowWidth, kOKy + 20 + 40);
        this.fOK.setBounds(kWindowWidth / 2 - 10 - 70, kOKy, 70, this.ht);
        this.fCancel.setBounds(kWindowWidth / 2 + 10, kOKy, 70, this.ht);
        fUndo = new Button(fp_resource.getString("str_undo"));
        fUndo.setBounds(kWindowWidth / 2 - 40, kOKy - 35, 80, this.ht);
        DialogSuperClass.setButtonColors(fUndo);
        this.add(fUndo);
        this.addWindowListener(new 1());
        this.addMouseListener(new 2());
    }

    private void adjustMatrixLeft() {
        int n = this.fMatrix.width();
        this.fMatrix.setSpacing((kWindowWidth - n) / 2, 0);
    }

    private void paintRowA(Graphics graphics) {
        graphics.clearRect(kRowAx, kOp1y - 10, this.kRowWidth - 1, 17);
        graphics.setColor(Color.blue);
        graphics.drawString("A" + this.fRowA, kRowAx, kOp1y);
    }

    private void paintRowE(Graphics graphics) {
        graphics.clearRect(kRowEx, kOp1y - 10, this.kRowWidth - 1, 17);
        graphics.setColor(Color.black);
        graphics.drawString("E" + this.fRowA, kRowEx, kOp1y);
    }

    private void paintOpA(Graphics graphics) {
        graphics.clearRect(kOpAx, kOp1y - 10, this.kOpWidth - 1, 17);
        graphics.setColor(Color.black);
        if (this.fOpA == 1) {
            graphics.drawString("a", kOpAx, kOp1y + 2);
        } else {
            graphics.drawString("/", kOpAx, kOp1y);
        }
    }

    private void paintOpB(Graphics graphics) {
        graphics.clearRect(kOpBx, kOp1y - 10, this.kOpWidth - 1, 17);
        graphics.setColor(Color.black);
        if (this.fOpB == 1) {
            graphics.drawString("b", kOpBx, kOp1y);
        } else {
            graphics.drawString("-", kOpBx + 2, kOp1y);
        }
    }

    private void paintOpC(Graphics graphics) {
        graphics.clearRect(kOpCx, kOp1y - 10, this.kOpWidth - 1, 17);
        graphics.setColor(Color.black);
        if (this.fOpC == 1) {
            graphics.drawString("c", kOpCx, kOp1y + 2);
        } else {
            graphics.drawString("/", kOpCx, kOp1y);
        }
    }

    private void paintRowB(Graphics graphics) {
        graphics.clearRect(kRowBx, kOp1y - 10, this.kRowWidth - 1, 17);
        graphics.setColor(Color.blue);
        graphics.drawString("B" + this.fRowB, kRowBx, kOp1y);
    }

    private void paintRowC(Graphics graphics) {
        graphics.clearRect(kRowCx, kOp2y - 10, this.kRowWidth - 1, 17);
        graphics.setColor(Color.blue);
        graphics.drawString("C" + this.fRowC, kRowCx, kOp2y);
    }

    private void paintRowD(Graphics graphics) {
        graphics.clearRect(kRowDx, kOp2y - 10, this.kRowWidth - 1, 17);
        graphics.setColor(Color.blue);
        graphics.drawString("D" + this.fRowD, kRowDx, kOp2y);
    }

    private void paintArrow(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.fillRect(kArrowx + 3, kOp1y - 6, 7, 3);
        int n = 0;
        while (n < 5) {
            graphics.drawLine(kArrowx + n, kOp1y - 5 + n, kArrowx + n, kOp1y - 5 - n);
            ++n;
        }
    }

    private void paintArrow2(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.fillRect(kArrow2x + 3, kOp2y - 6, 10, 3);
        int n = 0;
        while (n < 5) {
            graphics.drawLine(kArrow2x + n, kOp2y - 5 + n, kArrow2x + n, kOp2y - 5 - n);
            graphics.drawLine(kArrow2x + 16 - n, kOp2y - 5 + n, kArrow2x + 16 - n, kOp2y - 5 - n);
            ++n;
        }
    }

    public void paint(Graphics graphics) {
        this.paintRowA(graphics);
        this.paintArrow(graphics);
        this.paintOpA(graphics);
        this.paintOpB(graphics);
        this.paintOpC(graphics);
        this.paintRowB(graphics);
        this.paintRowC(graphics);
        this.paintRowD(graphics);
        this.paintRowE(graphics);
        this.paintArrow2(graphics);
        this.fMatrix.draw(graphics);
        this.fMatrix.drawRowLabels(graphics);
        super.paint(graphics);
    }

    public void doYes() {
        this.fMatrix.autoName();
        this.fCalc.matrixCanvas().handleNewMatrix(this.fMatrix);
        super.doYes();
    }

    public boolean action(Event event, Object object) {
        double d = 0.0;
        double d2 = 0.0;
        char[] cArray = new char[]{'*', '/'};
        char[] cArray2 = new char[]{'+', '-'};
        if (event.target instanceof Button) {
            Button button = (Button)event.target;
            if (button == this.fDoOp1) {
                try {
                    d = utils.getDouble(this.fFieldA);
                }
                catch (FPNumberFormatException fPNumberFormatException) {
                    String string = fp_resource.getString("str_error__cant_convert_into_a_number");
                    if (this.fFieldA.getText().trim().length() > 0) {
                        string = String.valueOf(string) + ": " + this.fFieldA.getText();
                    }
                    utils.showErrorDialog(this.fCalc, string);
                    return false;
                }
                try {
                    d2 = utils.getDouble(this.fFieldB);
                }
                catch (FPNumberFormatException fPNumberFormatException) {
                    String string = fp_resource.getString("str_error__cant_convert_into_a_number");
                    if (this.fFieldB.getText().trim().length() > 0) {
                        string = String.valueOf(string) + ": " + this.fFieldB.getText();
                    }
                    utils.showErrorDialog(this.fCalc, string);
                    return false;
                }
                if (d == 0.0 && this.fOpA == 2 || d2 == 0.0 && this.fOpC == 2) {
                    utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_error__divide_by_"));
                    return false;
                }
                if (d2 == 0.0) {
                    utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_error__first_parameter_cant_be_"));
                    return false;
                }
                this.fMatrix.doRowOperation(this.fRowA, this.fRowB, this.fOpA, this.fOpB, this.fOpC, d, d2);
                this.fMatrix.adjustColWidths();
                this.adjustMatrixLeft();
                if (d != 0.0) {
                    this.fHistoryList.append("R" + this.fRowA + " <= R" + this.fRowA + " " + String.valueOf(cArray[this.fOpC - 1]) + CalcUtils.toString(d2) + " " + String.valueOf(cArray2[this.fOpB - 1]) + " " + " R" + this.fRowB + " " + String.valueOf(cArray[this.fOpA - 1]) + " " + CalcUtils.toString(d) + "\n");
                } else {
                    this.fHistoryList.append("R" + this.fRowA + " <= R" + this.fRowA + " " + String.valueOf(cArray[this.fOpC - 1]) + CalcUtils.toString(d2) + "\n");
                }
                ++this.fCurrentStep;
                fUndo.setEnabled(true);
                this.fMatrixList[this.fCurrentStep] = this.fMatrix.copy();
                this.fStringList[this.fCurrentStep] = this.fHistoryList.getText();
                this.repaint();
            } else if (button == this.fDoOp2) {
                this.fMatrix.doSwap(this.fRowC, this.fRowD);
                this.fMatrix.adjustColWidths();
                this.adjustMatrixLeft();
                this.fHistoryList.append("R" + this.fRowC + " <=> R" + this.fRowD + "\n");
                ++this.fCurrentStep;
                fUndo.setEnabled(true);
                this.fMatrixList[this.fCurrentStep] = this.fMatrix.copy();
                this.fStringList[this.fCurrentStep] = this.fHistoryList.getText();
                this.repaint();
            } else if (button == fUndo && this.fCurrentStep > 0) {
                --this.fCurrentStep;
                this.fHistoryList.setText(this.fStringList[this.fCurrentStep]);
                this.fMatrix = this.fMatrixList[this.fCurrentStep].copy();
                this.adjustMatrixLeft();
                this.fMatrix.top(20 + Master.gSmallTop);
                this.repaint();
                if (this.fCurrentStep == 0) {
                    fUndo.setEnabled(false);
                }
            }
        }
        return super.action(event, object);
    }

    private final class 1
    extends WindowAdapter {
        public void windowActivated(WindowEvent windowEvent) {
            RowReduceDialog.this.fFieldB.requestFocus();
        }

        public void windowClosing(WindowEvent windowEvent) {
            RowReduceDialog.this.doNo();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = 0;
            if (n2 > kOp1y - 10 + n3 && n2 < kOp1y + 5 + n3) {
                if (n > kRowAx && n < kRowAx + RowReduceDialog.this.kRowWidth) {
                    RowReduceDialog rowReduceDialog = RowReduceDialog.this;
                    rowReduceDialog.fRowA = rowReduceDialog.fRowA + 1;
                    if (RowReduceDialog.this.fRowA > RowReduceDialog.this.fMatrix.numRows()) {
                        RowReduceDialog.this.fRowA = 1;
                    }
                    RowReduceDialog.this.paintRowA(RowReduceDialog.this.getGraphics());
                    RowReduceDialog.this.paintRowE(RowReduceDialog.this.getGraphics());
                } else if (n > kRowBx && n < kRowBx + RowReduceDialog.this.kRowWidth) {
                    RowReduceDialog rowReduceDialog = RowReduceDialog.this;
                    rowReduceDialog.fRowB = rowReduceDialog.fRowB + 1;
                    if (RowReduceDialog.this.fRowB > RowReduceDialog.this.fMatrix.numRows()) {
                        RowReduceDialog.this.fRowB = 1;
                    }
                    RowReduceDialog.this.paintRowB(RowReduceDialog.this.getGraphics());
                } else if (n > kOpAx && n < kOpAx + RowReduceDialog.this.kOpWidth) {
                    RowReduceDialog rowReduceDialog = RowReduceDialog.this;
                    rowReduceDialog.fOpA = rowReduceDialog.fOpA + 1;
                    if (RowReduceDialog.this.fOpA > 2) {
                        RowReduceDialog.this.fOpA = 1;
                    }
                    RowReduceDialog.this.paintOpA(RowReduceDialog.this.getGraphics());
                } else if (n > kOpBx && n < kOpBx + RowReduceDialog.this.kOpWidth) {
                    RowReduceDialog rowReduceDialog = RowReduceDialog.this;
                    rowReduceDialog.fOpB = rowReduceDialog.fOpB + 1;
                    if (RowReduceDialog.this.fOpB > 2) {
                        RowReduceDialog.this.fOpB = 1;
                    }
                    RowReduceDialog.this.paintOpB(RowReduceDialog.this.getGraphics());
                } else if (n > kOpCx && n < kOpCx + RowReduceDialog.this.kOpWidth) {
                    RowReduceDialog rowReduceDialog = RowReduceDialog.this;
                    rowReduceDialog.fOpC = rowReduceDialog.fOpC + 1;
                    if (RowReduceDialog.this.fOpC > 2) {
                        RowReduceDialog.this.fOpC = 1;
                    }
                    RowReduceDialog.this.paintOpC(RowReduceDialog.this.getGraphics());
                }
            } else if (n2 > kOp2y - 10 + n3 && n2 < kOp2y + 5 + n3) {
                if (n > kRowCx && n < kRowCx + RowReduceDialog.this.kRowWidth) {
                    RowReduceDialog rowReduceDialog = RowReduceDialog.this;
                    rowReduceDialog.fRowC = rowReduceDialog.fRowC + 1;
                    if (RowReduceDialog.this.fRowC > RowReduceDialog.this.fMatrix.numRows()) {
                        RowReduceDialog.this.fRowC = 1;
                    }
                    RowReduceDialog.this.paintRowC(RowReduceDialog.this.getGraphics());
                } else if (n > kRowDx && n < kRowDx + RowReduceDialog.this.kRowWidth) {
                    RowReduceDialog rowReduceDialog = RowReduceDialog.this;
                    rowReduceDialog.fRowD = rowReduceDialog.fRowD + 1;
                    if (RowReduceDialog.this.fRowD > RowReduceDialog.this.fMatrix.numRows()) {
                        RowReduceDialog.this.fRowD = 1;
                    }
                    RowReduceDialog.this.paintRowD(RowReduceDialog.this.getGraphics());
                }
            }
        }

        /* synthetic */ 2() {
        }
    }
}

