/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPCalculator;

import com.questmsm.FPCalculator.Calculator;
import com.questmsm.FPCalculator.SpecialTextField;
import com.questmsm.Utilities.utils;
import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Scrollbar;

public class SpecialFieldPanel
extends Panel {
    private Calculator fCalc;
    private Scrollbar fVert;
    private Scrollbar fHoriz;
    private SpecialTextField fField;
    private int fWidth;
    private int fHeight;
    private boolean fInitialized = false;

    public SpecialFieldPanel(Calculator calculator, Color color) {
        this.fCalc = calculator;
        this.setBackground(color);
        this.fField = new SpecialTextField(this, calculator, color);
        this.setLayout(null);
        this.fVert = new Scrollbar(1);
        this.add(this.fVert);
        this.fHoriz = new Scrollbar(0);
        this.add(this.fHoriz);
        this.add(this.fField);
    }

    public boolean handleEvent(Event event) {
        if (event.id == 605 || event.id == 602 || event.id == 601 || event.id == 604 || event.id == 603) {
            this.fField.translate(this.fHoriz.getValue(), this.fVert.getValue());
            return true;
        }
        return super.handleEvent(event);
    }

    public SpecialTextField field() {
        return this.fField;
    }

    public synchronized void paint(Graphics graphics) {
        utils.fancyBorder(graphics, this.getSize().width - 15, this.getSize().height - 15);
    }

    public void setHScrollVal(int n) {
        this.fHoriz.setValue(n);
    }

    public void setVScrollVal(int n) {
        this.fVert.setValue(n);
    }

    public void setScrollSettings() {
        int n = this.fVert.getSize().width;
        int n2 = this.getSize().height - n;
        int n3 = this.getSize().width - n;
        int n4 = this.fField.pageHeight();
        int n5 = this.fField.pageWidth();
        this.fVert.setMinimum(0);
        this.fVert.setMaximum(n4);
        this.fVert.setVisibleAmount(n2);
        this.fHoriz.setMinimum(0);
        this.fHoriz.setMaximum(n5);
        this.fHoriz.setVisibleAmount(n3);
        this.fVert.setUnitIncrement(22);
        this.fHoriz.setUnitIncrement(10);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.fField.setBounds(4, 4, n3 - 15 - 4 - 4, n4 - 15 - 4 - 4);
        this.fVert.setBounds(n3 - 15, 0, 15, n4 - 15);
        this.fHoriz.setBounds(0, n4 - 15, n3 - 15, 15);
        this.setScrollSettings();
        this.fField.translate(this.fHoriz.getValue(), this.fVert.getValue());
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

