/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPGrapher;

import com.questmsm.FPGrapher.FPAxes;
import com.questmsm.FPGrapher.FPFreeHand;
import com.questmsm.FPGrapher.FPObject;
import com.questmsm.FPGrapher.FPPointSet;
import com.questmsm.FPGrapher.FPRPNConverter;
import com.questmsm.FPGrapher.Samplable;
import com.questmsm.FunctionProbe.Evaluatable;
import com.questmsm.FunctionProbe.Master;
import com.questmsm.Utilities.BadComputationException;
import com.questmsm.Utilities.FPNumberFormatException;
import com.questmsm.Utilities.fp_resource;
import com.questmsm.Utilities.utils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.io.Serializable;

public class FPEquation
extends FPObject
implements Serializable,
Evaluatable,
Samplable {
    public transient double[] fStack;
    public static final transient int kEnd = 0;
    public static final transient int kPushConst = 1;
    public static final transient int kPushVar = 2;
    public static final transient int kAdd = 3;
    public static final transient int kSub = 4;
    public static final transient int kMult = 5;
    public static final transient int kDiv = 6;
    public static final transient int kPow = 7;
    public static final transient int kSqrt = 8;
    public static final transient int kSin = 9;
    public static final transient int kCos = 10;
    public static final transient int kTan = 11;
    public static final transient int kASin = 12;
    public static final transient int kACos = 13;
    public static final transient int kATan = 14;
    public static final transient int kE = 15;
    public static final transient int kLn = 16;
    public static final transient int kPushYVar = 17;
    public static final transient int kFloor = 18;
    public static final transient int kCalcButton = 19;
    public static final transient int kCeil = 20;
    public static final transient int kSec = 21;
    public static final transient int kCsc = 22;
    public static final transient int kCot = 23;
    public static final transient int kStep = 24;
    public static final transient int kRound = 25;
    public static final transient int kOtherEq = 26;
    public static final transient int kCosh = 31;
    public static final transient int kSinh = 32;
    public static final transient int kTanh = 33;
    public static final transient int kSech = 34;
    public static final transient int kCsch = 35;
    public static final transient int kCoth = 36;
    public static final transient int kASec = 37;
    public static final transient int kACsc = 38;
    public static final transient int kACot = 39;
    public static final transient int kSgn = 40;
    public static final transient int kFrac = 41;
    public static final transient int kInt = 42;
    public static final transient int kAbs = 43;
    public static final transient int kMod = 44;
    public static final transient int kIDiv = 45;
    protected static final transient double kBadResult = -1.23456123;
    protected static final transient int kMaxSteps = 1500;
    protected transient int fNumSteps;
    protected static final transient double kMaxSlope = 10.0;
    protected transient int[] fX;
    protected transient int[] fY;
    boolean[] skip;
    protected transient int[] fOldX;
    protected transient int[] fOldY;
    protected Polygon fPolygon = null;
    protected boolean fInequality = false;
    protected boolean fOrEqualTo = false;
    protected boolean fIsGreaterThan = false;
    protected transient FPAxes fAxes;
    protected double[] fInstructions = new double[50];
    protected int fLastInstruction;
    protected boolean[] fAsymptote = new boolean[1500];
    protected FPRPNConverter fConverter;
    protected boolean fBadEquation = false;
    protected boolean fWatchForDiscontinuities = false;
    double rss;
    double ads;
    boolean showrss;
    boolean showads;

    public void setShowRSS(boolean bl) {
        this.showrss = bl;
    }

    public boolean getShowRSS() {
        return this.showrss;
    }

    public void setShowADS(boolean bl) {
        this.showads = bl;
    }

    public boolean getShowADS() {
        return this.showads;
    }

    public void setRSS(double d) {
        this.rss = d;
    }

    public double getRSS() {
        return this.rss;
    }

    public void setADS(double d) {
        this.ads = d;
    }

    public double getADS() {
        return this.ads;
    }

    public String getEqString() {
        String string = super.getEqString();
        if (this.showrss) {
            string = String.valueOf(string) + "  :  " + fp_resource.getString("str_rss") + " = " + utils.num2str(this.rss);
        } else if (this.showads) {
            string = String.valueOf(string) + "  :  " + fp_resource.getString("str_asd") + " = " + utils.num2str(this.ads);
        }
        return string;
    }

    public FPEquation() {
        this.allocateTransients(null);
    }

    public FPEquation(String string, Color color, FPAxes fPAxes) {
        this.allocateTransients(fPAxes);
        char c = fPAxes.currentIndepVar();
        char c2 = fPAxes.currentDepVar();
        this.fConverter = new FPRPNConverter(String.valueOf(c2), String.valueOf(c));
        this.fEquationString = string;
        this.fColor = color;
        this.fKind = 0;
        this.fAxes = fPAxes;
        this.stringToEquation(string);
    }

    public void allocateTransients(FPAxes fPAxes) {
        this.fAxes = fPAxes;
        this.fStack = new double[50];
        this.fX = new int[1500];
        this.fY = new int[1500];
        this.fOldX = new int[1500];
        this.fOldY = new int[1500];
        this.skip = new boolean[1500];
    }

    public boolean badEquation() {
        return this.fBadEquation;
    }

    public void newEquationString(String string) {
        this.fEquationString = string;
        this.stringToEquation(string);
    }

    protected void stringToEquation(String string) {
        StringBuffer stringBuffer;
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer2 = new StringBuffer(string);
        FPRPNConverter.stripSpaces(stringBuffer2);
        String string2 = stringBuffer2.toString();
        if (string2.length() > 2) {
            if (string2.charAt(1) == '>') {
                if (string2.length() > 3 && string2.charAt(2) == '=') {
                    this.fOrEqualTo = true;
                }
                this.fInequality = true;
                this.fIsGreaterThan = true;
            } else if (string2.charAt(1) == '<') {
                if (string2.length() > 3 && string2.charAt(2) == '=') {
                    this.fOrEqualTo = true;
                }
                this.fInequality = true;
                this.fIsGreaterThan = false;
            } else {
                this.fInequality = false;
            }
        }
        if ((stringBuffer = this.fOrEqualTo ? this.fConverter.convert(new StringBuffer(string.substring(1, string.length()))) : this.fConverter.convert(new StringBuffer(string))) == null) {
            this.fBadEquation = true;
            return;
        }
        String string3 = stringBuffer.toString();
        this.fLastInstruction = 0;
        do {
            boolean bl;
            double d;
            String string4;
            if ((n2 = utils.getNextSpace(string3, n)) == -1) {
                return;
            }
            try {
                string4 = string3.substring(n, n2);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                break;
            }
            n = n2 + 1;
            if (string4.equals(this.fConverter.indepVar())) {
                this.fInstructions[this.fLastInstruction++] = 2.0;
                continue;
            }
            if (string4.equals("+")) {
                this.fInstructions[this.fLastInstruction++] = 3.0;
                continue;
            }
            if (string4.equals("-")) {
                this.fInstructions[this.fLastInstruction++] = 4.0;
                continue;
            }
            if (string4.equals("*")) {
                this.fInstructions[this.fLastInstruction++] = 5.0;
                continue;
            }
            if (string4.equals("/")) {
                this.fInstructions[this.fLastInstruction++] = 6.0;
                continue;
            }
            if (string4.equals("^")) {
                this.fInstructions[this.fLastInstruction++] = 7.0;
                continue;
            }
            if (string4.equals("sqrt")) {
                this.fInstructions[this.fLastInstruction++] = 8.0;
                continue;
            }
            if (string4.equals(fp_resource.sin) || string4.equals("sin")) {
                this.fInstructions[this.fLastInstruction++] = 9.0;
                continue;
            }
            if (string4.equals(fp_resource.cos) || string4.equals("cos")) {
                this.fInstructions[this.fLastInstruction++] = 10.0;
                continue;
            }
            if (string4.equals(fp_resource.tan) || string4.equals("tan")) {
                this.fInstructions[this.fLastInstruction++] = 11.0;
                continue;
            }
            if (string4.equals("sinh")) {
                this.fInstructions[this.fLastInstruction++] = 32.0;
                continue;
            }
            if (string4.equals("cosh")) {
                this.fInstructions[this.fLastInstruction++] = 31.0;
                continue;
            }
            if (string4.equals("tanh")) {
                this.fInstructions[this.fLastInstruction++] = 33.0;
                continue;
            }
            if (string4.equals("csch")) {
                this.fInstructions[this.fLastInstruction++] = 35.0;
                continue;
            }
            if (string4.equals("coth")) {
                this.fInstructions[this.fLastInstruction++] = 36.0;
                continue;
            }
            if (string4.equals("sech")) {
                this.fInstructions[this.fLastInstruction++] = 34.0;
                continue;
            }
            if (string4.equals("asec")) {
                this.fInstructions[this.fLastInstruction++] = 37.0;
                continue;
            }
            if (string4.equals("acsc")) {
                this.fInstructions[this.fLastInstruction++] = 38.0;
                continue;
            }
            if (string4.equals("acot")) {
                this.fInstructions[this.fLastInstruction++] = 39.0;
                continue;
            }
            if (string4.equals("sgn")) {
                this.fInstructions[this.fLastInstruction++] = 40.0;
                continue;
            }
            if (string4.equals("frac")) {
                this.fInstructions[this.fLastInstruction++] = 41.0;
                continue;
            }
            if (string4.equals("int")) {
                this.fInstructions[this.fLastInstruction++] = 42.0;
                continue;
            }
            if (string4.equals("abs")) {
                this.fInstructions[this.fLastInstruction++] = 43.0;
                continue;
            }
            if (string4.equals("mod")) {
                this.fInstructions[this.fLastInstruction++] = 44.0;
                continue;
            }
            if (string4.equals("div")) {
                this.fInstructions[this.fLastInstruction++] = 45.0;
                continue;
            }
            if (string4.equals("asin")) {
                this.fInstructions[this.fLastInstruction++] = 12.0;
                continue;
            }
            if (string4.equals("acos")) {
                this.fInstructions[this.fLastInstruction++] = 13.0;
                continue;
            }
            if (string4.equals("atan")) {
                this.fInstructions[this.fLastInstruction++] = 14.0;
                continue;
            }
            if (string4.equals("step")) {
                this.fInstructions[this.fLastInstruction++] = 24.0;
                continue;
            }
            if (string4.equals("round")) {
                this.fInstructions[this.fLastInstruction++] = 25.0;
                continue;
            }
            if (string4.equals("sec")) {
                this.fInstructions[this.fLastInstruction++] = 21.0;
                continue;
            }
            if (string4.equals("csc")) {
                this.fInstructions[this.fLastInstruction++] = 22.0;
                continue;
            }
            if (string4.equals("cot")) {
                this.fInstructions[this.fLastInstruction++] = 23.0;
                continue;
            }
            if (string4.equals("exp")) {
                this.fInstructions[this.fLastInstruction++] = 15.0;
                continue;
            }
            if (string4.equals("log")) {
                this.fInstructions[this.fLastInstruction++] = 16.0;
                continue;
            }
            if (string4.equals("floor")) {
                this.fInstructions[this.fLastInstruction++] = 18.0;
                continue;
            }
            if (string4.equals("ceil")) {
                this.fInstructions[this.fLastInstruction++] = 20.0;
                continue;
            }
            if (string4.charAt(0) == 'B') {
                this.fInstructions[this.fLastInstruction++] = 19.0;
                this.fInstructions[this.fLastInstruction++] = string4.charAt(1) - 48;
                continue;
            }
            if (string4.charAt(0) == 'G') {
                d = 0.0;
                bl = true;
                try {
                    d = utils.str2num(string4.substring(1, string4.length()));
                }
                catch (FPNumberFormatException fPNumberFormatException) {
                    bl = false;
                }
                if (!bl) continue;
                this.fInstructions[this.fLastInstruction++] = 26.0;
                this.fInstructions[this.fLastInstruction++] = d;
                continue;
            }
            bl = true;
            try {
                d = Double.valueOf(string4);
            }
            catch (NumberFormatException numberFormatException) {
                d = 0.0;
                bl = false;
            }
            if (!bl) continue;
            this.fInstructions[this.fLastInstruction++] = 1.0;
            this.fInstructions[this.fLastInstruction++] = d;
        } while (n < string3.length());
        this.fInstructions[this.fLastInstruction++] = 0.0;
    }

    protected int getNextSpace(String string, int n) {
        int n2 = n;
        while (n2 < string.length()) {
            try {
                if (string.charAt(n2) == ' ') {
                    return n2;
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
            ++n2;
        }
        return string.length();
    }

    public void addInstruction(double d) {
        this.fInstructions[this.fLastInstruction++] = d;
    }

    protected double eval(double d, double d2) throws BadComputationException {
        int n = -1;
        int n2 = 0;
        while (n2 <= this.fLastInstruction) {
            switch ((int)this.fInstructions[n2]) {
                case 0: {
                    return this.fStack[n];
                }
                case 26: {
                    int n3 = (int)this.fInstructions[++n2];
                    this.fStack[n] = Master.evaluate("G" + n3, this.fStack[n]);
                    if (this.fStack[n] != -1.23456123) break;
                    return -1.23456123;
                }
                case 19: {
                    int n3 = (int)this.fInstructions[++n2];
                    this.fStack[n] = Master.evaluate("B" + n3, this.fStack[n]);
                    if (this.fStack[n] != -1.23456123) break;
                    return -1.23456123;
                }
                case 1: {
                    this.fStack[++n] = this.fInstructions[++n2];
                    break;
                }
                case 2: {
                    this.fStack[++n] = d;
                    break;
                }
                case 17: {
                    this.fStack[++n] = d2;
                    break;
                }
                case 3: {
                    this.fStack[n - 1] = this.fStack[n - 1] + this.fStack[n];
                    --n;
                    break;
                }
                case 4: {
                    this.fStack[n - 1] = this.fStack[n - 1] - this.fStack[n];
                    --n;
                    break;
                }
                case 5: {
                    this.fStack[n - 1] = this.fStack[n - 1] * this.fStack[n];
                    --n;
                    break;
                }
                case 6: {
                    if (this.fStack[n] == 0.0) {
                        return -1.23456123;
                    }
                    this.fStack[n - 1] = this.fStack[n - 1] / this.fStack[n];
                    --n;
                    break;
                }
                case 7: {
                    try {
                        this.fStack[n - 1] = Math.pow(this.fStack[n - 1], this.fStack[n]);
                        --n;
                        break;
                    }
                    catch (ArithmeticException arithmeticException) {
                        return -1.23456123;
                    }
                }
                case 8: {
                    this.fStack[n] = Math.sqrt(this.fStack[n]);
                    if (!Double.isNaN(this.fStack[n])) break;
                    throw new BadComputationException("Negative square root.");
                }
                case 32: {
                    this.fStack[n] = (Math.exp(this.fStack[n]) - Math.exp(-this.fStack[n])) / 2.0;
                    break;
                }
                case 31: {
                    this.fStack[n] = (Math.exp(this.fStack[n]) + Math.exp(-this.fStack[n])) / 2.0;
                    break;
                }
                case 33: {
                    this.fStack[n] = (Math.exp(this.fStack[n]) - Math.exp(-this.fStack[n])) / (Math.exp(this.fStack[n]) + Math.exp(-this.fStack[n]));
                    break;
                }
                case 35: {
                    this.fStack[n] = 2.0 / (Math.exp(this.fStack[n]) - Math.exp(-this.fStack[n]));
                    break;
                }
                case 34: {
                    this.fStack[n] = 2.0 / (Math.exp(this.fStack[n]) + Math.exp(-this.fStack[n]));
                    break;
                }
                case 36: {
                    this.fStack[n] = (Math.exp(this.fStack[n]) + Math.exp(-this.fStack[n])) / (Math.exp(this.fStack[n]) - Math.exp(-this.fStack[n]));
                    break;
                }
                case 37: {
                    if (Math.abs(this.fStack[n]) < 1.0) {
                        return -1.23456123;
                    }
                    this.fStack[n] = Math.acos(1.0 / this.fStack[n]);
                    break;
                }
                case 38: {
                    if (Math.abs(this.fStack[n]) < 1.0) {
                        return -1.23456123;
                    }
                    this.fStack[n] = Math.asin(1.0 / this.fStack[n]);
                    break;
                }
                case 39: {
                    this.fStack[n] = Math.atan(1.0 / this.fStack[n]);
                    break;
                }
                case 40: {
                    this.fStack[n] = this.fStack[n] < 0.0 ? -1.0 : 1.0;
                    this.fWatchForDiscontinuities = true;
                    break;
                }
                case 41: {
                    this.fStack[n] = this.fStack[n] - (double)((int)this.fStack[n]);
                    this.fWatchForDiscontinuities = true;
                    break;
                }
                case 42: {
                    this.fStack[n] = (int)this.fStack[n];
                    this.fWatchForDiscontinuities = true;
                    break;
                }
                case 43: {
                    this.fStack[n] = Math.abs(this.fStack[n]);
                    break;
                }
                case 44: {
                    this.fStack[n - 1] = Math.IEEEremainder(this.fStack[n - 1], this.fStack[n]);
                    --n;
                    break;
                }
                case 45: {
                    this.fStack[n - 1] = (int)(this.fStack[n - 1] / this.fStack[n]);
                    --n;
                    this.fWatchForDiscontinuities = true;
                    break;
                }
                case 9: {
                    this.fStack[n] = Math.sin(this.fStack[n]);
                    break;
                }
                case 10: {
                    this.fStack[n] = Math.cos(this.fStack[n]);
                    break;
                }
                case 11: {
                    this.fStack[n] = Math.tan(this.fStack[n]);
                    break;
                }
                case 22: {
                    if (Math.sin(this.fStack[n]) == 0.0) {
                        return -1.23456123;
                    }
                    this.fStack[n] = 1.0 / Math.sin(this.fStack[n]);
                    break;
                }
                case 23: {
                    if (Math.tan(this.fStack[n]) == 0.0) {
                        return -1.23456123;
                    }
                    this.fStack[n] = 1.0 / Math.tan(this.fStack[n]);
                    break;
                }
                case 21: {
                    if (Math.cos(this.fStack[n]) == 0.0) {
                        return -1.23456123;
                    }
                    this.fStack[n] = 1.0 / Math.cos(this.fStack[n]);
                    break;
                }
                case 24: {
                    this.fStack[n] = this.fStack[n] >= 0.0 ? 1.0 : 0.0;
                    this.fWatchForDiscontinuities = true;
                    break;
                }
                case 25: {
                    this.fStack[n] = Math.round(this.fStack[n]);
                    this.fWatchForDiscontinuities = true;
                    break;
                }
                case 12: {
                    if (Math.abs(this.fStack[n]) > 1.0) {
                        return -1.23456123;
                    }
                    this.fStack[n] = Math.asin(this.fStack[n]);
                    break;
                }
                case 13: {
                    if (Math.abs(this.fStack[n]) > 1.0) {
                        return -1.23456123;
                    }
                    this.fStack[n] = Math.acos(this.fStack[n]);
                    break;
                }
                case 14: {
                    this.fStack[n] = Math.atan(this.fStack[n]);
                    break;
                }
                case 15: {
                    this.fStack[n] = Math.exp(this.fStack[n]);
                    break;
                }
                case 16: {
                    if (this.fStack[n] <= 0.0) {
                        return -1.23456123;
                    }
                    this.fStack[n] = Math.log(this.fStack[n]);
                    break;
                }
                case 18: {
                    this.fStack[n] = Math.floor(this.fStack[n]);
                    this.fWatchForDiscontinuities = true;
                    break;
                }
                case 20: {
                    this.fStack[n] = Math.ceil(this.fStack[n]);
                    this.fWatchForDiscontinuities = true;
                    break;
                }
                default: {
                    this.fStack[++n] = 0.0;
                    break;
                }
            }
            ++n2;
        }
        return this.fStack[n];
    }

    public double eval(double d) throws BadComputationException {
        return this.eval(d, 0.0);
    }

    public double eval_(double d) {
        double d2 = -1.23456123;
        try {
            d2 = this.eval(d);
        }
        catch (BadComputationException badComputationException) {
            badComputationException.printStackTrace();
        }
        return d2;
    }

    public void fastStretchLR(int n, double d) {
        int n2 = 0;
        while (n2 < this.fNumSteps) {
            this.fX[n2] = n + (int)(d * (double)(this.fOldX[n2] - n));
            ++n2;
        }
    }

    public void fastStretchUD(int n, double d) {
        int n2 = 0;
        while (n2 < this.fNumSteps) {
            this.fY[n2] = n + (int)(d * (double)(this.fOldY[n2] - n));
            ++n2;
        }
    }

    public void stretchLR(double d, double d2, boolean bl) {
        String string = this.fConverter.depVar();
        String string2 = this.fConverter.indepVar();
        this.fEquationString = bl ? (Math.abs(d) < 1.0E-8 ? FPRPNConverter.replace(this.fEquationString, string2, "(" + string2 + "^" + utils.num2str(d2, 2) + ")") : FPRPNConverter.replace(this.fEquationString, string2, "(" + string2 + "^" + utils.num2str(d2, 2) + "*" + this.fAxes.logXBase() + "^" + utils.num2str(d * (1.0 - d2), 2) + ")")) : (Math.abs(d) < 1.0E-8 ? FPRPNConverter.replace(this.fEquationString, string2, "(" + utils.num2str(d2, 2) + string2 + ")") : FPRPNConverter.replace(this.fEquationString, string2, "(" + utils.num2str(d, 2) + "-" + utils.num2str(-d2, 2) + "*(" + string2 + "-" + utils.num2str(d, 2) + "))"));
        this.stringToEquation(this.fEquationString);
        this.fEquationString = FPRPNConverter.replace(this.fEquationString, "--", "+");
        this.fEquationString = FPRPNConverter.replace(this.fEquationString, "+-", "-");
    }

    public void stretchUD(double d, double d2, boolean bl) {
        if (bl) {
            this.fEquationString = Math.abs(d) < 1.0E-8 ? String.valueOf(FPRPNConverter.replace(this.fEquationString, "=", "= (")) + ")^" + utils.num2str(d2, 2) : String.valueOf(FPRPNConverter.replace(this.fEquationString, "=", "= (")) + ")" + "^" + utils.num2str(d2) + "*" + this.fAxes.logYBase() + "^" + utils.num2str(d * (1.0 - d2), 2);
        } else if (Math.abs(d) < 1.0E-8) {
            this.fEquationString = String.valueOf(FPRPNConverter.replace(this.fEquationString, "=", "=" + utils.num2str(d2, 2) + "(")) + ")";
        } else {
            this.fEquationString = FPRPNConverter.replace(this.fEquationString, "=", "= (");
            this.fEquationString = String.valueOf(this.fEquationString) + "-" + utils.num2str(d, 2) + ")*(" + utils.num2str(d2, 2) + ")" + utils.num2strwsign(d);
        }
        this.stringToEquation(this.fEquationString);
        this.fEquationString = FPRPNConverter.replace(this.fEquationString, "--", "+");
        this.fEquationString = FPRPNConverter.replace(this.fEquationString, "+-", "-");
    }

    public void mirrorx(double d, boolean bl) {
        String string = this.fConverter.depVar();
        String string2 = this.fConverter.indepVar();
        this.fEquationString = bl ? (Math.abs(d) < 0.001 ? FPRPNConverter.replace(this.fEquationString, string2, "(" + string2 + "^-1)") : FPRPNConverter.replace(this.fEquationString, string2, "(" + string2 + "^-1*" + this.fAxes.logXBase() + "^" + utils.num2str(2.0 * d, 2) + ")")) : (Math.abs(d) < 0.001 ? FPRPNConverter.replace(this.fEquationString, string2, "(-" + string2 + ")") : FPRPNConverter.replace(this.fEquationString, string2, "(" + utils.num2str(2.0 * d, 2) + "-" + string2 + ")"));
        this.stringToEquation(this.fEquationString);
    }

    public void mirrory(double d, boolean bl) {
        if (bl) {
            this.fEquationString = FPRPNConverter.replace(this.fEquationString, "=", "=1/(");
            this.fEquationString = String.valueOf(this.fEquationString) + ")";
            if (Math.abs(d) > 0.001) {
                this.fEquationString = String.valueOf(this.fEquationString) + "*" + this.fAxes.logYBase() + "^" + utils.num2str(2.0 * d, 2);
            }
        } else {
            this.fEquationString = FPRPNConverter.replace(this.fEquationString, "=", "=-(");
            this.fEquationString = String.valueOf(this.fEquationString) + ")";
            if (Math.abs(d) > 0.001) {
                this.fEquationString = String.valueOf(this.fEquationString) + "-" + utils.num2str(-2.0 * d, 2);
            }
        }
        this.stringToEquation(this.fEquationString);
    }

    public void mirrorxy(boolean bl, boolean bl2) {
        this.mirrorXY = true;
    }

    public void translate(double d, double d2, boolean bl, boolean bl2) {
        String string = this.fConverter.depVar();
        String string2 = this.fConverter.indepVar();
        if (d != 0.0) {
            this.fEquationString = bl ? FPRPNConverter.replace(this.fEquationString, string2, "(" + string2 + "*" + this.fAxes.logXBase() + "^" + utils.num2str(-d, 2) + ")") : FPRPNConverter.replace(this.fEquationString, string2, "(" + string2 + "-" + utils.num2str(d, 2) + ")");
        }
        if (d2 != 0.0) {
            this.fEquationString = bl2 ? String.valueOf(FPRPNConverter.replace(this.fEquationString, "=", "=(")) + ")*" + this.fAxes.logYBase() + "^" + utils.num2str(d2, 2) : String.valueOf(this.fEquationString) + "-" + utils.num2str(-d2, 2);
        }
        StringBuffer stringBuffer = new StringBuffer(this.fEquationString);
        FPRPNConverter.stripSpaces(stringBuffer);
        this.fEquationString = stringBuffer.toString();
        this.fEquationString = FPRPNConverter.replace(this.fEquationString, "--", "+");
        this.fEquationString = FPRPNConverter.replace(this.fEquationString, "+-", "-");
        this.stringToEquation(this.fEquationString);
    }

    public FPFreeHand convertToFreehand() {
        FPFreeHand fPFreeHand = new FPFreeHand(this.fColor, this.fAxes);
        int n = 0;
        double d = this.fAxes.minX();
        double d2 = this.fAxes.maxX();
        double d3 = this.fAxes.minY();
        double d4 = this.fAxes.maxY();
        double d5 = d;
        if (d3 < d) {
            d5 = d3;
        }
        double d6 = d2;
        if (d4 > d2) {
            d6 = d4;
        }
        double d7 = this.fAxes.xMajTick();
        double d8 = this.fAxes.yMajTick();
        this.fAxes.minX(d5);
        this.fAxes.maxX(d6);
        this.fAxes.setUpAxesNoCalculate();
        this.calculate(this.fAxes);
        int n2 = 0;
        while (n2 < this.fNumSteps) {
            double d9 = this.fAxes.pxl2x(this.fX[n2]);
            double d10 = this.fAxes.pxl2y(this.fY[n2]);
            if (n2 > 0) {
                if (!this.fAsymptote[n2] && !this.fAsymptote[n2 - 1]) {
                    if (this.fWatchForDiscontinuities && n2 > 1 && n2 < this.fNumSteps - 1 && this.checkForDiscontinuity(this.fY[n2 - 2], this.fY[n2 - 1], this.fY[n2], this.fY[n2 + 1])) {
                        fPFreeHand.addBreak();
                    }
                } else if (this.fAsymptote[n2]) {
                    fPFreeHand.addBreak();
                }
            }
            fPFreeHand.addPoint(d9, d10);
            ++n;
            ++n2;
        }
        this.fAxes.minX(d);
        this.fAxes.maxX(d2);
        this.fAxes.xMajTick(d7);
        this.fAxes.yMajTick(d8);
        this.fAxes.setUpAxesNoCalculate();
        this.calculate(this.fAxes);
        if (n == 0) {
            return null;
        }
        return fPFreeHand;
    }

    public void copyToOld() {
        int n = 0;
        while (n < this.fNumSteps) {
            this.fOldX[n] = this.fX[n];
            this.fOldY[n] = this.fY[n];
            ++n;
        }
    }

    public void fastTranslate(int n, int n2) {
        int n3 = 0;
        while (n3 < this.fNumSteps) {
            this.fX[n3] = this.fOldX[n3] + n;
            this.fY[n3] = this.fOldY[n3] + n2;
            ++n3;
        }
    }

    public FPObject copy() {
        FPEquation fPEquation = new FPEquation(this.fEquationString, this.fColor, this.fAxes);
        int n = 0;
        while (n < this.fNumSteps) {
            fPEquation.fX[n] = this.fX[n];
            fPEquation.fY[n] = this.fY[n];
            ++n;
        }
        fPEquation.fNumSteps = this.fNumSteps;
        return fPEquation;
    }

    public void select(boolean bl) {
        this.fSelected = bl;
    }

    private void findAsymptotes(boolean bl) {
        int n = 200;
        int n2 = 0;
        while (n2 < this.fNumSteps) {
            this.fAsymptote[n2] = false;
            ++n2;
        }
        if (!bl) {
            return;
        }
        int n3 = 1;
        while (n3 < this.fNumSteps - 1) {
            int n4 = this.fY[n3 - 1];
            int n5 = this.fY[n3];
            int n6 = this.fY[n3 + 1];
            int n7 = n5 - n4;
            int n8 = n6 - n5;
            if (n7 > n && n8 < -n && n4 > 0 && n6 > 0) {
                this.fAsymptote[n3] = true;
            } else if (n7 < -n && n8 > n && n4 < 0 && n6 < 0) {
                this.fAsymptote[n3] = true;
            } else if (n4 < 0 && (n5 > n || n6 > n)) {
                this.fAsymptote[n3] = true;
                this.fAsymptote[n3 - 1] = false;
            } else if (n4 > n && (n5 < 0 || n6 < 0)) {
                this.fAsymptote[n3] = true;
                this.fAsymptote[n3 - 1] = false;
            } else {
                this.fAsymptote[n3] = false;
            }
            ++n3;
        }
    }

    private boolean checkForDiscontinuity(int n, int n2, int n3, int n4) {
        int n5 = 5;
        int n6 = Math.abs(n2 - n);
        int n7 = Math.abs(n3 - n2);
        int n8 = Math.abs(n4 - n3);
        if (Math.abs(n8 - n6) > n5) {
            return false;
        }
        return Math.abs(n7 - n6) > n5;
    }

    private double checkForEdge(double d, double d2) {
        double d3 = d;
        int n = 0;
        while (n < 10) {
            d3 = (d2 + d) / 2.0;
            double d4 = this.eval_(d3);
            if (d4 == -1.23456123) {
                if (this.eval_(d) == -1.23456123) {
                    d = d3;
                    d3 = (d3 + d2) / 2.0;
                } else if (this.eval_(d2) == -1.23456123) {
                    d2 = d3;
                    d3 = (d + d3) / 2.0;
                }
            } else if (this.eval_(d) == -1.23456123) {
                d2 = d3;
                d3 = (d3 + d) / 2.0;
            } else if (this.eval_(d2) == -1.23456123) {
                d = d3;
                d3 = (d2 + d3) / 2.0;
            }
            if (this.eval_(d3) == -1.23456123) {
                --n;
            }
            ++n;
        }
        return d3;
    }

    public void calculate(FPAxes fPAxes) {
        if (this.deleted()) {
            return;
        }
        this.fNumSteps = fPAxes.getSize().width;
        double d = 1.0;
        if (this.fInequality) {
            this.fPolygon = new Polygon();
            if (this.fIsGreaterThan) {
                this.fPolygon.addPoint(0, 0);
            } else {
                this.fPolygon.addPoint(0, fPAxes.getSize().height);
            }
        }
        double d2 = fPAxes.pxl2x(0);
        int n = 0;
        while (n < this.fNumSteps) {
            int n2;
            int n3 = (int)((double)n * d);
            double d3 = fPAxes.pxl2x(n3);
            double d4 = this.eval_(d3);
            double d5 = fPAxes.pxl2x(n3 + (int)Math.ceil(d));
            double d6 = this.eval_(d5);
            if (d4 == -1.23456123) {
                if (d6 != -1.23456123) {
                    d3 = this.checkForEdge(d3, d5);
                    d4 = this.eval_(d3);
                    n3 = fPAxes.x2pxl(d3);
                    n2 = fPAxes.y2pxl(d4);
                } else {
                    n2 = -1001;
                }
            } else {
                if (d6 == -1.23456123) {
                    d3 = this.checkForEdge(d3, d5);
                    d4 = this.eval_(d3);
                    n3 = fPAxes.x2pxl(d3);
                }
                n2 = fPAxes.y2pxl(d4);
            }
            this.fX[n] = n3;
            this.fY[n] = n2;
            this.skip[n] = false;
            if (Double.isNaN(d4)) {
                this.skip[n] = true;
            }
            if (this.fInequality) {
                this.fPolygon.addPoint(n3, n2);
            }
            ++n;
        }
        if (this.fInequality) {
            if (this.fIsGreaterThan) {
                this.fPolygon.addPoint(fPAxes.getSize().width, 0);
            } else {
                this.fPolygon.addPoint(fPAxes.getSize().width, fPAxes.getSize().height);
            }
        }
        this.findAsymptotes(true);
    }

    public void drawArrows(Graphics graphics, int n, FPAxes fPAxes) {
        int n2 = 20;
        int n3 = n;
        int n4 = fPAxes.y2pxl(0.0);
        graphics.setColor(this.fColor);
        while (n3 < fPAxes.fWidth) {
            double d = fPAxes.pxl2x(n3);
            double d2 = this.eval_(d);
            int n5 = fPAxes.y2pxl(d2);
            graphics.drawLine(n3, n5, n3, n4);
            if (n5 > n4) {
                graphics.drawLine(n3, n5, n3 - 3, n5 - 4);
                graphics.drawLine(n3, n5, n3 + 3, n5 - 4);
            } else {
                graphics.drawLine(n3, n5, n3 - 3, n5 + 4);
                graphics.drawLine(n3, n5, n3 + 3, n5 + 4);
            }
            n3 += n2;
        }
    }

    public void drawToMax(Graphics graphics, int n) {
        graphics.setColor(this.fColor);
        boolean bl = true;
        int n2 = 1;
        while (n2 < this.fNumSteps) {
            if (this.fY[n2] != -1001 && this.fY[n2 - 1] != -1001) {
                if (this.skip[n2 - 1] || this.skip[n2]) {
                    if (this.fX[n2] >= n) {
                        return;
                    }
                } else {
                    graphics.drawLine(this.fX[n2 - 1], this.fY[n2 - 1], this.fX[n2], this.fY[n2]);
                    if (bl) {
                        graphics.drawLine(this.fX[n2 - 1] + 1, this.fY[n2 - 1], this.fX[n2] + 1, this.fY[n2]);
                        graphics.drawLine(this.fX[n2 - 1], this.fY[n2 - 1] + 1, this.fX[n2], this.fY[n2] + 1);
                    }
                    if (this.fX[n2] >= n) {
                        return;
                    }
                }
            }
            ++n2;
        }
    }

    private void drawAsymptote(Graphics graphics, int n) {
        if (this.fAxes.showAsymptotes()) {
            graphics.setColor(Color.black);
            utils.drawDashedLine(graphics, n, 0, n, 1000);
        }
    }

    public void drawDashed(Graphics graphics) {
        boolean bl = this.select();
        int n = 1;
        while (n < 5) {
            if (this.fX[1] - this.fX[0] >= 3) break;
            ++n;
        }
        int n2 = 1;
        while (n2 < this.fNumSteps - (n - 1)) {
            graphics.setColor(Color.black);
            if (this.fY[n2] != -1001 && this.fY[n2 - 1] != -1001) {
                if (!(this.fAsymptote[n2] || this.fAsymptote[n2 - 1] || this.skip[n2] || this.skip[n2 - 1])) {
                    graphics.drawLine(this.fX[n2 - 1], this.fY[n2 - 1], this.fX[n2 + (n - 1)], this.fY[n2 + (n - 1)]);
                    if (bl) {
                        graphics.drawLine(this.fX[n2 - 1] + 1, this.fY[n2 - 1], this.fX[n2 + (n - 1)] + 1, this.fY[n2 + (n - 1)]);
                        graphics.drawLine(this.fX[n2 - 1], this.fY[n2 - 1] + 1, this.fX[n2 + (n - 1)], this.fY[n2 + (n - 1)] + 1);
                    }
                } else if (this.fAsymptote[n2]) {
                    this.drawAsymptote(graphics, this.fX[n2]);
                }
            }
            n2 += n;
            n2 += n;
        }
    }

    public void draw(Graphics graphics) {
        boolean bl = this.select();
        graphics.setColor(this.fColor);
        if (this.fPolygon != null) {
            graphics.fillPolygon(this.fPolygon);
            if (!this.fOrEqualTo) {
                this.drawDashed(graphics);
                return;
            }
        }
        int n = 1;
        while (n < this.fNumSteps) {
            if (this.fPolygon != null) {
                graphics.setColor(Color.black);
            } else {
                graphics.setColor(this.fColor);
            }
            if (this.fY[n] != -1001 && this.fY[n - 1] != -1001) {
                if (!this.fAsymptote[n] && !this.fAsymptote[n - 1]) {
                    if (!(this.fWatchForDiscontinuities && n > 1 && n < this.fNumSteps - 1 && this.checkForDiscontinuity(this.fY[n - 2], this.fY[n - 1], this.fY[n], this.fY[n + 1]) || this.skip[n] || this.skip[n - 1])) {
                        graphics.drawLine(this.fX[n - 1], this.fY[n - 1], this.fX[n], this.fY[n]);
                        if (bl) {
                            graphics.drawLine(this.fX[n - 1] + 1, this.fY[n - 1], this.fX[n] + 1, this.fY[n]);
                            graphics.drawLine(this.fX[n - 1], this.fY[n - 1] + 1, this.fX[n], this.fY[n] + 1);
                        }
                    }
                } else if (this.fAsymptote[n]) {
                    this.drawAsymptote(graphics, this.fX[n]);
                }
            }
            ++n;
        }
    }

    public boolean mouseDown(int n, int n2, FPAxes fPAxes) {
        int n3;
        int n4;
        int n5;
        if (this.deleted()) {
            return false;
        }
        double d = fPAxes.pxl2x(n - 2);
        double d2 = fPAxes.pxl2x(n + 2);
        double d3 = this.eval_(d);
        double d4 = this.eval_(d2);
        int n6 = fPAxes.y2pxl(d3);
        if (n6 > (n5 = fPAxes.y2pxl(d4))) {
            n4 = n6 + 5;
            n3 = n5 - 5;
        } else {
            n4 = n5 + 5;
            n3 = n6 - 5;
        }
        return n2 >= n3 && n2 <= n4;
    }

    public FPPointSet sample(int n, double[] dArray, int n2) {
        FPPointSet fPPointSet;
        block9: {
            block11: {
                double d;
                block10: {
                    d = (this.fAxes.maxX() - this.fAxes.minX()) / (double)(this.fNumSteps - 1);
                    fPPointSet = new FPPointSet(this.fAxes.parent().colorPalette().nextColor(), this.fAxes);
                    double d2 = 0.0;
                    double d3 = 0.0;
                    double d4 = 0.0;
                    double d5 = 0.0;
                    if (n2 != 1) break block10;
                    int n3 = 0;
                    while (n3 < n) {
                        double d6 = dArray[n3];
                        double d7 = this.eval_(d6);
                        fPPointSet.addPoint(d6, d7);
                        ++n3;
                    }
                    break block9;
                }
                if (n2 != 2) break block11;
                int n4 = 0;
                while (n4 < n) {
                    double d8 = dArray[n4];
                    boolean bl = false;
                    int n5 = 0;
                    while (n5 < this.fNumSteps - 1) {
                        double d9 = this.fAxes.minX() + (double)n5 * d;
                        double d10 = d9 + d;
                        double d11 = this.eval_(d9);
                        double d12 = this.eval_(d10);
                        if (d8 >= d11 && d8 <= d12 || d8 <= d11 && d8 >= d12) {
                            if (bl) {
                                utils.showErrorDialog(Master.gFrame, String.valueOf(fp_resource.getString("str_computer_detects_drawing_is_multivalued_beginning_at")) + " y =" + utils.num2str(d8));
                                return null;
                            }
                            double d13 = utils.interp(d11, d9, d12, d10, d8);
                            fPPointSet.addPoint(d13, d8);
                            bl = true;
                        }
                        ++n5;
                    }
                    ++n4;
                }
                break block9;
            }
            if (n2 != 3) break block9;
            int n6 = 1;
            while (n6 < n) {
                int n7 = n6++;
                dArray[n7] = dArray[n7] - dArray[0];
            }
            dArray[0] = 0.0;
            int n8 = 0;
            double d = 0.0;
            fPPointSet.addPoint(this.fAxes.pxl2x(this.fX[0]), this.fAxes.pxl2y(this.fY[0]));
            ++n8;
            int n9 = 0;
            while (n9 < this.fNumSteps - 1) {
                double d14;
                double d15 = this.fAxes.pxl2x(this.fX[n9 + 1]) - this.fAxes.pxl2x(this.fX[n9]);
                if ((d += Math.sqrt(d15 * d15 + (d14 = this.fAxes.pxl2y(this.fY[n9 + 1]) - this.fAxes.pxl2y(this.fY[n9])) * d14)) > dArray[n8]) {
                    fPPointSet.addPoint(this.fAxes.pxl2x(this.fX[n9]), this.fAxes.pxl2y(this.fY[n9]));
                    if (++n8 >= n) break;
                }
                ++n9;
            }
        }
        return fPPointSet;
    }

    public void drawHorizontalArrows(Graphics graphics, int n) {
        int n2 = 1;
        graphics.setColor(Color.gray);
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < this.fNumSteps - 1) {
                int n5;
                int n6 = utils.findIntercept(n3, this.fY[n4], this.fX[n4], this.fY[n4 + 1], this.fX[n4 + 1]);
                if (n6 != -1000 && Math.abs((n5 = utils.findIntercept(n3, this.fOldY[n4], this.fOldX[n4], this.fOldY[n4 + 1], this.fOldX[n4 + 1])) - n6) >= 4) {
                    graphics.drawLine(n6, n3, n5, n3);
                    if (n5 < n6) {
                        n2 = -1;
                    }
                    int n7 = 0;
                    while (n7 < 4) {
                        graphics.drawLine(n6 + n2 * n7, n3 - n7, n6 + n2 * n7, n3 + n7);
                        ++n7;
                    }
                }
                ++n4;
            }
            n3 += 40;
        }
    }

    public void drawVerticalArrows(Graphics graphics, int n) {
        int n2 = 1;
        graphics.setColor(Color.gray);
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < this.fNumSteps - 1) {
                int n5;
                int n6 = utils.findIntercept(n3, this.fX[n4], this.fY[n4], this.fX[n4 + 1], this.fY[n4 + 1]);
                if (n6 != -1000 && Math.abs((n5 = utils.findIntercept(n3, this.fOldX[n4], this.fOldY[n4], this.fOldX[n4 + 1], this.fOldY[n4 + 1])) - n6) >= 4) {
                    graphics.drawLine(n3, n6, n3, n5);
                    if (n5 < n6) {
                        n2 = -1;
                    }
                    int n7 = 0;
                    while (n7 < 4) {
                        graphics.drawLine(n3 - n7, n6 + n2 * n7, n3 + n7, n6 + n2 * n7);
                        ++n7;
                    }
                }
                ++n4;
            }
            n3 += 40;
        }
    }

    public boolean inequality() {
        return this.fInequality;
    }
}

