/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPGrapher;

import com.questmsm.FPGrapher.FPAxes;
import com.questmsm.FPGrapher.FPEquation;
import com.questmsm.FPGrapher.FPObject;
import java.awt.Graphics;

public class FPObjectList {
    public FPObject fFirst = null;
    public FPObject fLast = null;
    private int fNumObjects = 0;
    private FPAxes fAxes;

    public FPObjectList(FPAxes fPAxes) {
        this.fAxes = fPAxes;
    }

    public int numObjects() {
        return this.fNumObjects;
    }

    public FPObject last() {
        return this.fLast;
    }

    public FPObject first() {
        return this.fFirst;
    }

    public FPObject objectNum(int n) {
        FPObject fPObject = this.fLast;
        if (n >= this.fNumObjects) {
            return null;
        }
        int n2 = 0;
        while (n2 < n) {
            fPObject = fPObject.prev;
            ++n2;
        }
        return fPObject;
    }

    public void removeFromList(FPObject fPObject) {
        FPObject fPObject2 = this.fFirst;
        while (fPObject2 != null) {
            if (fPObject2 == fPObject) {
                if (fPObject2 == this.fFirst) {
                    if (this.fFirst.next != null) {
                        this.fFirst.next.prev = null;
                    }
                    this.fFirst = this.fFirst.next;
                } else if (fPObject2 == this.fLast) {
                    this.fLast = this.fLast.prev;
                    this.fLast.next = null;
                } else {
                    fPObject2.prev.next = fPObject2.next;
                    fPObject2.next.prev = fPObject2.prev;
                }
                --this.fNumObjects;
                return;
            }
            fPObject2 = fPObject2.next;
        }
    }

    public void addToList(FPObject fPObject, FPAxes fPAxes) {
        fPObject.calculate(fPAxes);
        if (this.fFirst == null) {
            this.fFirst = fPObject;
            this.fLast = fPObject;
            this.fFirst.prev = null;
            this.fFirst.next = null;
            this.fLast.prev = null;
            this.fLast.next = null;
            ++this.fNumObjects;
        } else {
            this.fLast.next = fPObject;
            fPObject.prev = this.fLast;
            fPObject.next = null;
            this.fLast = fPObject;
            ++this.fNumObjects;
        }
        fPAxes.parent().undoer().objectCreated(fPObject);
    }

    public void recalculate(FPAxes fPAxes) {
        FPObject fPObject = this.fFirst;
        while (fPObject != null) {
            fPObject.calculate(fPAxes);
            fPObject = fPObject.next;
        }
    }

    public void drawInequalities(Graphics graphics) {
        FPObject fPObject = this.fFirst;
        while (fPObject != null) {
            if (fPObject.kind() == 0 && ((FPEquation)fPObject).inequality() && !fPObject.deleted()) {
                fPObject.draw(graphics);
            }
            fPObject = fPObject.next;
        }
    }

    public void draw(Graphics graphics) {
        FPObject fPObject = this.fFirst;
        while (fPObject != null) {
            if (fPObject.kind() == 0) {
                if (!((FPEquation)fPObject).inequality() && !fPObject.deleted()) {
                    fPObject.draw(graphics);
                }
            } else if (!fPObject.deleted()) {
                fPObject.draw(graphics);
            }
            fPObject = fPObject.next;
        }
    }

    public FPObject handleMouseDown(int n, int n2, FPAxes fPAxes) {
        FPObject fPObject = this.fFirst;
        while (fPObject != null) {
            if (fPObject.mouseDown(n, n2, fPAxes)) {
                FPObject fPObject2 = fPObject;
                fPObject = fPObject.next;
                while (fPObject != null) {
                    fPObject.select(false);
                    fPObject = fPObject.next;
                }
                return fPObject2;
            }
            fPObject = fPObject.next;
        }
        return null;
    }

    public FPObject checkUnderneath(int n, int n2, FPObject fPObject) {
        FPObject fPObject2 = this.fFirst;
        while (fPObject2 != null) {
            if (fPObject2.mouseDown(n, n2, this.fAxes)) {
                FPObject fPObject3 = fPObject2;
                FPObject fPObject4 = fPObject2;
                while (fPObject4 != null) {
                    if (fPObject == fPObject4) {
                        FPObject fPObject5 = fPObject4.next;
                        while (fPObject5 != null) {
                            if (fPObject5.mouseDown(n, n2, this.fAxes)) {
                                return fPObject5;
                            }
                            fPObject5 = fPObject5.next;
                        }
                        if (fPObject != fPObject3) {
                            return fPObject3;
                        }
                        return null;
                    }
                    fPObject4 = fPObject4.next;
                }
                return null;
            }
            fPObject2 = fPObject2.next;
        }
        return null;
    }

    public void clearAll() {
        FPObject fPObject = this.fFirst;
        while (fPObject != null) {
            FPObject fPObject2 = fPObject.next;
            this.fAxes.history().unattach(fPObject);
            fPObject.prev = null;
            fPObject.next = null;
            fPObject = fPObject2;
        }
        this.fFirst = null;
        this.fLast = null;
        this.fNumObjects = 0;
    }

    public boolean isVarIndexUsed(int n) {
        FPObject fPObject = this.fFirst;
        while (fPObject != null) {
            if (fPObject.varIndex() == n) {
                return true;
            }
            fPObject = fPObject.next;
        }
        return false;
    }
}

