/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPGrapher;

import com.questmsm.FPGrapher.DefineVarPrompt;
import com.questmsm.FPGrapher.FPAxes;
import com.questmsm.FPGrapher.FPCondEquation;
import com.questmsm.FPGrapher.FPEquation;
import com.questmsm.FPGrapher.FPObject;
import com.questmsm.FPGrapher.FPParametricEquation;
import com.questmsm.FPGrapher.FPPointSet;
import com.questmsm.FPGrapher.FPPolarEquation;
import com.questmsm.FPGrapher.FPPolarParametric;
import com.questmsm.FPGrapher.FPPolarPointSet;
import com.questmsm.FPGrapher.FPRPNConverter;
import com.questmsm.FPGrapher.FPTextScroll;
import com.questmsm.FPGrapher.GenerateTFrame;
import com.questmsm.FPGrapher.GraphHistoryFrame;
import com.questmsm.FPGrapher.Grapher;
import com.questmsm.FPGrapher.HistoryItem;
import com.questmsm.FPGrapher.HistoryTextField;
import com.questmsm.FunctionProbe.Evaluatable;
import com.questmsm.FunctionProbe.Master;
import com.questmsm.Utilities.FPTextField;
import com.questmsm.Utilities.FocusRequester;
import com.questmsm.Utilities.MyInt;
import com.questmsm.Utilities.fp_resource;
import com.questmsm.Utilities.utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.PrintJob;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.IOException;

public class HistoryArea
extends Panel
implements TextListener,
ActionListener,
FocusListener {
    private GraphHistoryFrame fHistoryFrame;
    private int fWidth;
    private int fHeight;
    private TextField fText;
    FPTextField fTextA;
    FPTextField fTextB;
    Object fFieldInFocus;
    private FPAxes fAxes;
    private Grapher fGrapher;
    private FPTextScroll fTextScroll;
    private int fMode;
    public static final int kMaxItems = 200;
    public HistoryItem[] fItemList = new HistoryItem[200];
    public int fNumItems;
    private int fCurrentItem;
    public int fCount = 0;
    private static final Font kRegFont = new Font("serif", 1, 12);
    private static final Font kItalFont = new Font("serif", 3, 12);
    private static FontMetrics fRegMetrics;
    private static FontMetrics fItalMetrics;
    public static final int kShowAll = 0;
    public static final int kHideAll = 1;
    public static final int kHideLast = 2;
    private int fShowWhat = 0;
    private static final int kItemNumWidth = 35;
    private static final int kXFormWidth = 55;
    private static final int kScrollWidth = 15;
    private static final int kEquationSpacing = 6;
    private static final Color kBackgroundColor;
    private static final Color kItemNameColor;
    private static final Color kItemNumColor;
    private static final Color kItemXFormColor;
    private static final Color kEquationColor;
    private static final int kLine1Y = 18;
    private static final int kLine2Y = 35;
    private boolean fTextFieldHasFocus = false;
    private String fComment = null;
    public static final int kItemHeight = 20;

    static {
        kBackgroundColor = new Color(230, 230, 230);
        kItemNameColor = new Color(153, 0, 0);
        kItemNumColor = new Color(0, 102, 0);
        kItemXFormColor = new Color(51, 0, 102);
        kEquationColor = Color.black;
    }

    public HistoryArea(Grapher grapher, FPAxes fPAxes) {
        this.fGrapher = grapher;
        this.fAxes = fPAxes;
        this.fAxes.history(this);
        fRegMetrics = this.getFontMetrics(kRegFont);
        fItalMetrics = this.getFontMetrics(kItalFont);
        this.fHistoryFrame = new GraphHistoryFrame(this.fGrapher, this);
        ((Component)this.fHistoryFrame).setBounds(100, 100, 573, 180);
        this.setBackground(kBackgroundColor);
        1 var3_3 = new 1();
        this.fText = new HistoryTextField();
        this.fText.setFont(kRegFont);
        ((Component)this.fText).setBackground(kBackgroundColor);
        this.fText.addTextListener(this);
        this.fText.addActionListener(this);
        this.fText.addFocusListener(this);
        this.fText.setVisible(false);
        this.fText.addKeyListener(var3_3);
        this.fTextA = new TPTF("", 10);
        this.fTextA.addTextListener(new 2());
        this.fTextA.setFont(kRegFont);
        this.fTextA.setBackground(kBackgroundColor);
        this.fTextA.addTextListener(this);
        this.fTextA.addActionListener(this);
        this.fTextA.addFocusListener(this);
        this.fTextA.setVisible(false);
        this.fTextA.addKeyListener(var3_3);
        this.fTextB = new TPTF("", 10);
        this.fTextB.addTextListener(new 3());
        this.fTextB.setFont(kRegFont);
        this.fTextB.setBackground(kBackgroundColor);
        this.fTextB.addTextListener(this);
        this.fTextB.addActionListener(this);
        this.fTextB.addFocusListener(this);
        this.fTextB.setVisible(false);
        this.fTextB.addKeyListener(var3_3);
        this.fTextScroll = new FPTextScroll(this, this.fAxes);
        this.fMode = -1;
        this.setLayout(null);
        this.add(this.fText);
        this.add(this.fTextA);
        this.add(this.fTextB);
        this.add(this.fTextScroll);
        this.fNumItems = 0;
        this.fCurrentItem = -1;
        this.setTextFieldsVisible(false);
        this.enableEvents(24L);
    }

    public void setTextFieldsVisible(boolean bl) {
        if (bl) {
            if (this.fMode == 2 || this.fMode == 3 || this.fMode == 1) {
                this.fText.setVisible(false);
                this.fTextA.setVisible(true);
                this.fTextB.setVisible(true);
                this.fTextA.requestFocus();
                this.fTextA.setCaretPosition(100);
            } else {
                this.fTextA.setVisible(false);
                this.fTextB.setVisible(false);
                this.fText.setVisible(true);
                this.fText.requestFocus();
                this.fText.setCaretPosition(100);
            }
        } else {
            this.fText.setVisible(false);
            this.fTextA.setVisible(false);
            this.fTextB.setVisible(false);
        }
    }

    private void updateHistoryFrame() {
        if (this.fHistoryFrame.isShowing()) {
            this.fHistoryFrame.canvas().redraw();
        }
    }

    public void addItem(FPObject fPObject, String string, String string2, String string3) {
        if (this.fNumItems == 200) {
            utils.showErrorDialog(this.fGrapher, fp_resource.getString("str_error__reached_maximum_number_of_items_in_history"));
            return;
        }
        this.fItemList[this.fNumItems] = new HistoryItem(fPObject, string, string2, string3, this);
        if (this.fAxes.autoDefine()) {
            this.fItemList[this.fNumItems].define();
        }
        this.fCurrentItem = this.fNumItems++;
        this.updateHistoryFrame();
    }

    public synchronized void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.fWidth = this.getSize().width;
        this.fHeight = this.getSize().height;
        this.fText.setBounds(35, 2, this.fWidth - 15 - 70, n4 - 4);
        this.fTextA.setBounds(35, 2, this.fWidth - 15 - 70, n4 / 2 - 2);
        this.fTextB.setBounds(35, n4 / 2 - 1, this.fWidth - 15 - 70, n4 / 2 - 2);
        this.fTextScroll.setBounds(this.fWidth - 15, 0, 15, n4);
    }

    public boolean inLeftElipsis(int n) {
        String string = this.fItemList[this.fCurrentItem].label();
        int n2 = string.indexOf("{...");
        if (n2 < 0 || n2 > string.length()) {
            return false;
        }
        if (n < 41 + fRegMetrics.stringWidth(string.substring(0, n2 + 1))) {
            return false;
        }
        return n <= 41 + fRegMetrics.stringWidth(string.substring(0, n2 + 4));
    }

    public boolean inRightElipsis(int n) {
        String string = this.fItemList[this.fCurrentItem].label();
        int n2 = string.indexOf("...}");
        if (n2 < 0 || n2 > string.length()) {
            return false;
        }
        if (n < 41 + fRegMetrics.stringWidth(string.substring(0, n2))) {
            return false;
        }
        return n <= 41 + fRegMetrics.stringWidth(string.substring(0, n2 + 3));
    }

    public void drawInField(String string) {
        this.drawInField(this.getGraphics(), string);
    }

    public void drawInField(Graphics graphics, String string) {
        graphics.setFont(kRegFont);
        graphics.clearRect(this.fText.getLocation().x + 2, this.fText.getLocation().y, this.fText.getSize().width + 100, this.fText.getSize().height);
        utils.drawStringWithReplaceTheta(graphics, string, 41, 18, fRegMetrics);
    }

    public void drawInLowerField(Graphics graphics, String string) {
        graphics.setFont(kRegFont);
        graphics.clearRect(this.fText.getLocation().x + 2, this.fTextB.getLocation().y, this.fText.getSize().width + 100, this.fTextB.getSize().height);
        utils.drawStringWithReplaceTheta(graphics, string, 41, 35, fRegMetrics);
    }

    public void comment(String string) {
        this.fComment = string;
    }

    public void drawTransUD(String string) {
        this.drawTransUD(this.getGraphics(), string, this.getSize().width);
    }

    public void drawTransUD(Graphics graphics, String string, int n) {
        graphics.setFont(kRegFont);
        graphics.clearRect(n - 55, this.fText.getLocation().y, 55, this.fText.getSize().height);
        graphics.drawString(string, n - 55, 18);
        if (string.length() > 0) {
            if (string.charAt(0) == '-') {
                graphics.drawImage(Grapher.kDownArrowIcon, n - 55 - 16 - 4, this.fText.getLocation().y + 5, this.getBackground(), this);
            } else {
                graphics.drawImage(Grapher.kUpArrowIcon, n - 55 - 16 - 4, this.fText.getLocation().y + 5, this.getBackground(), this);
            }
        }
    }

    public void drawTransLR(String string) {
        this.drawTransLR(this.getGraphics(), string, this.getSize().width);
    }

    public void drawTransLR(Graphics graphics, String string, int n) {
        graphics.setFont(kRegFont);
        graphics.clearRect(n - 55, this.fText.getLocation().y, 55, this.fText.getSize().height);
        graphics.drawString(string, n - 55, 18);
        if (string.length() > 0) {
            if (string.charAt(0) == '-') {
                graphics.drawImage(Grapher.kLeftArrowIcon, n - 55 - 16 - 4, this.fText.getLocation().y + 5, this.getBackground(), this);
            } else {
                graphics.drawImage(Grapher.kRightArrowIcon, n - 55 - 16 - 4, this.fText.getLocation().y + 5, this.getBackground(), this);
            }
        }
    }

    public void drawAnchor(String string) {
        this.drawAnchor(this.getGraphics(), string, this.getSize().width);
    }

    public void drawAnchor(Graphics graphics, String string, int n) {
        graphics.setFont(kRegFont);
        graphics.clearRect(n - 55, this.fText.getLocation().y, 55, this.fText.getSize().height);
        graphics.drawString(string, n - 55, 18);
        graphics.drawImage(Grapher.kAnchorIcon, n - 55 - 16 - 4, this.fText.getLocation().y + 5, this.getBackground(), this);
    }

    public void drawMirrorX(String string) {
        this.drawMirrorX(this.getGraphics(), string, this.getSize().width);
    }

    public void drawMirrorX(Graphics graphics, String string, int n) {
        graphics.setFont(kRegFont);
        graphics.clearRect(n - 55, this.fText.getLocation().y, 55, this.fText.getSize().height);
        graphics.drawString(string, n - 55, 18);
        graphics.drawImage(Grapher.kMirrorXIcon, n - 55 - 16 - 4, this.fText.getLocation().y + 5, this.getBackground(), this);
    }

    public void drawMirrorY(String string) {
        this.drawMirrorY(this.getGraphics(), string, this.getSize().width);
    }

    public void drawMirrorY(Graphics graphics, String string, int n) {
        graphics.setFont(kRegFont);
        graphics.clearRect(n - 55, this.fText.getLocation().y, 55, this.fText.getSize().height);
        graphics.drawString(string, n - 55, 18);
        graphics.drawImage(Grapher.kMirrorYIcon, n - 55 - 16 - 4, this.fText.getLocation().y + 5, this.getBackground(), this);
    }

    public void drawMirrorXY() {
        this.drawMirrorXY(this.getGraphics(), this.getSize().width);
    }

    public void drawMirrorXY(Graphics graphics, int n) {
        graphics.setFont(kRegFont);
        graphics.drawImage(Grapher.kMirrorXYIcon, n - 16 - 4, this.fText.getLocation().y + 5, this.getBackground(), this);
    }

    public void drawStretchLR(String string) {
        this.drawStretchLR(this.getGraphics(), string, this.getSize().width);
    }

    public void drawStretchLR(Graphics graphics, String string, int n) {
        graphics.setFont(kRegFont);
        graphics.clearRect(n - 137, this.fText.getLocation().y, 137, this.fText.getSize().height);
        graphics.drawString("* " + string, n - 137, 18);
        graphics.drawImage(Grapher.kStretchLRIcon, n - 137 - 16 - 4, this.fText.getLocation().y + 5, this.getBackground(), this);
    }

    public void drawStretchUD(String string) {
        this.drawStretchUD(this.getGraphics(), string, this.getSize().width);
    }

    public void drawStretchUD(Graphics graphics, String string, int n) {
        graphics.setFont(kRegFont);
        graphics.clearRect(n - 137, this.fText.getLocation().y, 137, this.fText.getSize().height);
        graphics.drawString("*" + string, n - 137, 18);
        graphics.drawImage(Grapher.kStretchUDIcon, n - 137 - 16 - 4, this.fText.getLocation().y + 5, this.getBackground(), this);
    }

    public void paint(Graphics graphics) {
        this.drawCurrentItem(graphics);
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        graphics.drawLine(35, 0, 35, this.getSize().height);
        if (this.fComment != null) {
            this.drawInLowerField(graphics, this.fComment);
            this.comment(null);
        }
    }

    public String getObjectYString(FPObject fPObject) {
        String string = "";
        if (fPObject == null) {
            return string;
        }
        string = fPObject.kind() == 2 || fPObject.kind() == 3 ? ((FPParametricEquation)fPObject).getEqYString() : fPObject.getEqString();
        if (fPObject.kind() == 0 && (this.fAxes.showTransform() == 2 && fPObject.isLast() && fPObject.isXFormed() || this.fAxes.showTransform() == 1 && fPObject.isXFormed())) {
            string = "y = ...";
        }
        if ((fPObject.kind() == 2 || fPObject.kind() == 3) && (this.fAxes.showTransform() == 2 && fPObject.isLast() && fPObject.isXFormed() || this.fAxes.showTransform() == 1 && fPObject.isXFormed())) {
            string = "y = ...";
        }
        return string;
    }

    public String getObjectXString(FPObject fPObject) {
        String string = "";
        if (fPObject == null) {
            return string;
        }
        if (fPObject.kind() == 2) {
            string = ((FPParametricEquation)fPObject).getEqXString();
            if (this.fAxes.showTransform() == 2 && fPObject.isLast() && fPObject.isXFormed() || this.fAxes.showTransform() == 1 && fPObject.isXFormed()) {
                string = "y = ...";
            }
        }
        if (fPObject.kind() == 3) {
            string = ((FPPolarParametric)fPObject).getEqXString();
            if (this.fAxes.showTransform() == 2 && fPObject.isLast() && fPObject.isXFormed() || this.fAxes.showTransform() == 1 && fPObject.isXFormed()) {
                string = "y = ...";
            }
        }
        if (fPObject.kind() == 1) {
            string = ((FPPolarEquation)fPObject).getRangeString();
        }
        return string;
    }

    public void setTextFieldStrings() {
        FPObject fPObject = this.fItemList[this.fCurrentItem].object();
        if (this.fItemList[this.fCurrentItem].isDouble()) {
            this.fTextA.setText(this.getObjectYString(fPObject));
            this.fTextA.setCaretPosition(100);
            this.fTextB.setText(this.getObjectXString(fPObject));
            this.fTextB.setCaretPosition(100);
        } else {
            ((TextComponent)this.fText).setText(this.getObjectYString(fPObject));
            this.fText.setCaretPosition(1000);
        }
    }

    public void displayTransform(Graphics graphics, HistoryItem historyItem, int n) {
        int n2 = 0;
        if (n != this.getSize().width) {
            n2 = 20;
        }
        graphics.setColor(kItemNameColor);
        graphics.drawLine(29 + n2, 18, 25 + n2, 10);
        graphics.drawLine(25 + n2, 10, 21 + n2, 18);
        graphics.drawLine(29 + n2, 18, 21 + n2, 18);
        graphics.setColor(Color.darkGray);
        graphics.setFont(kItalFont);
        String string = historyItem.label();
        String string2 = historyItem.label2();
        graphics.drawString(string, 41 + n2, 18);
        if (historyItem.isDouble()) {
            graphics.drawString(string2, 41 + n2, 35);
        }
        switch (historyItem.xFormID()) {
            case 4: {
                String string3 = utils.num2str(historyItem.xFormVal());
                this.drawStretchLR(graphics, string3, n);
                string3 = utils.num2str(historyItem.anchorVal());
                this.drawAnchor(graphics, string3, n);
                break;
            }
            case 3: {
                String string4 = utils.num2str(historyItem.xFormVal());
                this.drawStretchUD(graphics, string4, n);
                string4 = utils.num2str(historyItem.anchorVal());
                this.drawAnchor(graphics, string4, n);
                break;
            }
            case 5: {
                String string5 = utils.num2str(historyItem.xFormVal());
                this.drawMirrorX(graphics, string5, n - 10);
                break;
            }
            case 6: {
                String string6 = utils.num2str(historyItem.xFormVal());
                this.drawMirrorY(graphics, string6, n - 10);
                break;
            }
            case 7: {
                this.drawMirrorXY(graphics, n - 10);
                break;
            }
            case 1: {
                String string7 = utils.num2str(historyItem.xFormVal());
                this.drawTransUD(graphics, string7, n);
                break;
            }
            case 2: {
                String string8 = utils.num2str(historyItem.xFormVal());
                this.drawTransLR(graphics, string8, n);
                break;
            }
        }
    }

    public void define() {
        if (this.fCurrentItem == -1) {
            return;
        }
        if (this.fItemList[this.fCurrentItem].object() == null) {
            return;
        }
        this.fItemList[this.fCurrentItem].define();
        this.repaint();
    }

    public void define(FPObject fPObject) {
        int n = 0;
        while (n < this.fNumItems) {
            if (this.fItemList[n].object() == fPObject) {
                this.fItemList[n].define();
                return;
            }
            ++n;
        }
    }

    public String getName(FPObject fPObject) {
        int n = 0;
        while (n < this.fNumItems) {
            if (this.fItemList[n].object() == fPObject) {
                return this.fItemList[n].name();
            }
            ++n;
        }
        return null;
    }

    public void handleDeletedPoint(Graphics graphics, FPObject fPObject) {
        FPPointSet fPPointSet = (FPPointSet)fPObject;
        int n = 41;
        graphics.setFont(kRegFont);
        String string = fPPointSet.prefix();
        graphics.drawString(string, n, 18);
        n += fRegMetrics.stringWidth(string);
        graphics.setFont(kItalFont);
        string = fPPointSet.middle();
        graphics.drawString(string, n, 18);
        n += fRegMetrics.stringWidth(string);
        graphics.setFont(kRegFont);
        string = fPPointSet.postfix();
        graphics.drawString(string, n, 18);
    }

    public void drawCurrentItem(Graphics graphics) {
        this.drawItemNumber(graphics, this.fCurrentItem);
    }

    public void drawItemNumber(Graphics graphics, int n) {
        this.drawItemNumber(graphics, n, false);
    }

    public void drawItemNumber(Graphics graphics, int n, boolean bl) {
        String string = "";
        int n2 = 0;
        if (bl) {
            n2 = 20;
        }
        graphics.setColor(kItemNumColor);
        graphics.setFont(kRegFont);
        if (n == -1) {
            string = String.valueOf(String.valueOf(this.fCount + 1)) + ".";
        } else {
            string = String.valueOf(String.valueOf(this.fItemList[n].num())) + ".";
            if (this.fItemList[n].xFormID() == 0) {
                graphics.drawString(string, 35 - fRegMetrics.stringWidth(string) - 1 + n2, 18);
            }
        }
        if (n == -1) {
            return;
        }
        HistoryItem historyItem = this.fItemList[n];
        if (historyItem.xFormID() != 0) {
            if (bl) {
                this.displayTransform(graphics, historyItem, 550);
            } else {
                this.displayTransform(graphics, historyItem, this.getSize().width);
            }
            return;
        }
        if (historyItem.name() != null) {
            graphics.setColor(kItemNameColor);
            graphics.setFont(kRegFont);
            string = String.valueOf(historyItem.name()) + " ";
            if (bl) {
                n2 = -17;
            }
            graphics.drawString(string, 35 - fRegMetrics.stringWidth(string) - 1, 35 + n2);
        }
        if (this.fText.isVisible() || this.fTextA.isVisible()) {
            return;
        }
        if (historyItem.object() == null) {
            return;
        }
        graphics.setColor(kEquationColor);
        graphics.setFont(kRegFont);
        FontMetrics fontMetrics = fRegMetrics;
        if (historyItem.object().deleted()) {
            graphics.setFont(kItalFont);
            fontMetrics = fItalMetrics;
        }
        switch (historyItem.object().kind()) {
            case 6: 
            case 7: 
            case 8: {
                if (!((FPPointSet)historyItem.object()).isDeleted()) break;
                this.handleDeletedPoint(graphics, historyItem.object());
                return;
            }
        }
        String string2 = this.getObjectYString(historyItem.object());
        String string3 = this.getObjectXString(historyItem.object());
        historyItem.label(string2);
        historyItem.label2(string3);
        if (bl) {
            n2 = 20;
        }
        utils.drawStringWithReplaceTheta(graphics, string2, 41 + n2, 18, fontMetrics);
        if (historyItem.isDouble()) {
            utils.drawStringWithReplaceTheta(graphics, string3, 41 + n2, 35, fontMetrics);
        }
    }

    public void setSelect(int n) {
        if (n >= -1 && n < this.fNumItems) {
            this.setTextFieldsVisible(false);
            this.fCurrentItem = n;
        }
        this.repaint();
    }

    public void setSelect(FPObject fPObject) {
        this.mode(fPObject.kind());
        int n = 0;
        while (n < this.fNumItems) {
            if (this.fItemList[n].object() == fPObject) {
                this.setSelect(n);
                return;
            }
            ++n;
        }
    }

    public void erradicateLast() {
        if (this.fNumItems == 0) {
            return;
        }
        --this.fNumItems;
        this.decrementCounter(this.fItemList[this.fNumItems].object());
        this.setSelect(this.fNumItems - 1);
        this.fCurrentItem = -1;
        this.repaint();
    }

    public void unattach(FPObject fPObject) {
        int n = 0;
        while (n < this.fNumItems) {
            if (this.fItemList[n].object() == fPObject) {
                this.fItemList[n].unattach();
                return;
            }
            ++n;
        }
    }

    public void decrementCounter(FPObject fPObject) {
        --this.fCount;
    }

    public int currentItemNum() {
        return this.fCurrentItem;
    }

    public void updateString(FPObject fPObject, String string) {
    }

    public void updateString(FPObject fPObject) {
    }

    public void mode(int n) {
        if (this.fMode == n) {
            return;
        }
        this.fMode = n;
        this.setTextFieldsVisible(false);
    }

    public void setText(String string) {
        ((TextComponent)this.fText).setText(string);
        this.fText.setCaretPosition(1000);
        this.repaint();
    }

    public void setText(String string, String string2) {
        this.fTextA.setText(string);
        this.fTextA.setCaretPosition(100);
        this.fTextB.setText(string2);
        this.fTextB.setCaretPosition(100);
        this.repaint();
    }

    public void doCut() {
        if (this.fFieldInFocus instanceof TextField) {
            TextField textField = (TextField)this.fFieldInFocus;
            String string = textField.getSelectedText();
            StringSelection stringSelection = new StringSelection(string);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
            int n = textField.getSelectionStart();
            int n2 = textField.getSelectionEnd();
            String string2 = textField.getText();
            String string3 = string2.substring(0, n);
            string2.length();
            string3 = String.valueOf(string3) + string2.substring(n2, string2.length());
            ((TextComponent)textField).setText(string3);
            textField.setCaretPosition(n);
        } else {
            FPTextField fPTextField = (FPTextField)this.fFieldInFocus;
            String string = fPTextField.getSelectedText();
            StringSelection stringSelection = new StringSelection(string);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
            int n = fPTextField.getSelectionStart();
            int n3 = fPTextField.getSelectionEnd();
            String string4 = fPTextField.getText();
            String string5 = string4.substring(0, n);
            string4.length();
            string5 = String.valueOf(string5) + string4.substring(n3, string4.length());
            fPTextField.setText(string5);
            fPTextField.setCaretPosition(n);
        }
    }

    public void doCopy() {
        String string = this.fFieldInFocus instanceof TextField ? ((TextField)this.fFieldInFocus).getSelectedText() : ((FPTextField)this.fFieldInFocus).getSelectedText();
        StringSelection stringSelection = new StringSelection(string);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
    }

    public void doPaste() {
        String string;
        Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
        try {
            string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            utils.showErrorDialog(this.fGrapher, fp_resource.getString("str_error__cant_paste_a_nontext_clipboard"));
            return;
        }
        catch (IOException iOException) {
            utils.showErrorDialog(this.fGrapher, fp_resource.getString("str_error__in_io"));
            return;
        }
        TextField textField = (TextField)this.fFieldInFocus;
        int n = textField.getSelectionStart();
        int n2 = textField.getSelectionEnd();
        String string2 = textField.getText();
        String string3 = string2.substring(0, n);
        string3 = String.valueOf(string3) + string;
        if (n2 < string2.length()) {
            string3 = String.valueOf(string3) + string2.substring(n2, string2.length());
        }
        ((TextComponent)textField).setText(string3);
        textField.setCaretPosition(n + string.length());
    }

    public void requestFocus() {
        if (this.fText.isVisible()) {
            new FocusRequester(this.fText);
        } else if (this.fTextA.isVisible()) {
            new FocusRequester(this.fTextA);
        }
    }

    public void clearSelect() {
        this.fCurrentItem = -1;
        this.repaint();
    }

    public void clearAll() {
        int n = 0;
        while (n < this.fNumItems) {
            this.fItemList[n] = null;
            ++n;
        }
        this.fNumItems = 0;
        this.fCurrentItem = -1;
        this.fCount = 0;
    }

    public HistoryItem currentItem() {
        if (this.fCurrentItem == -1) {
            return null;
        }
        return this.fItemList[this.fCurrentItem];
    }

    public HistoryItem item(int n) {
        if (n < 0) {
            return null;
        }
        if (n >= this.fNumItems) {
            return null;
        }
        return this.fItemList[n];
    }

    public void setItem(int n, HistoryItem historyItem) {
        this.fItemList[n] = historyItem;
    }

    private void editEquation() {
        this.setTextFieldStrings();
        this.setTextFieldsVisible(true);
        this.fCurrentItem = -1;
        switch (this.fMode) {
            case 0: {
                this.fGrapher.toolbar().mode(4);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                this.fGrapher.toolbar().mode(16);
                break;
            }
        }
        this.fGrapher.toolbar().repaint();
        this.repaint();
    }

    public void handleArrowKeys(int n) {
        HistoryItem historyItem = this.currentItem();
        switch (n) {
            case 39: {
                int n2;
                if (historyItem.object() != null && ((n2 = historyItem.object().kind()) == 6 || n2 == 7 || n2 == 8)) {
                    ((FPPointSet)historyItem.object()).incrementSelectedPoint();
                    this.fAxes.repaint();
                    this.repaint();
                    break;
                }
                return;
            }
            case 37: {
                int n3;
                if (historyItem.object() != null && ((n3 = historyItem.object().kind()) == 6 || n3 == 7 || n3 == 8)) {
                    ((FPPointSet)historyItem.object()).decrementSelectedPoint();
                    this.fAxes.repaint();
                    this.repaint();
                    break;
                }
                return;
            }
            case 38: {
                if (this.fAxes.getMode() != 0) {
                    this.fAxes.clearMode();
                    return;
                }
                this.fTextScroll.scrollUp();
                break;
            }
            case 40: {
                if (this.fAxes.getMode() != 0) {
                    this.fAxes.clearMode();
                    return;
                }
                this.fTextScroll.scrollDown();
                break;
            }
            default: {
                return;
            }
        }
        this.fGrapher.handleMenus();
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() != 402) {
            return;
        }
        if (keyEvent.getKeyCode() == 13 || keyEvent.getKeyCode() == 10) {
            this.undeleteCurrentItem();
        } else {
            this.handleArrowKeys(keyEvent.getKeyCode());
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501) {
            HistoryItem historyItem = this.currentItem();
            if (historyItem == null) {
                return;
            }
            if (historyItem.xFormID() != 0) {
                return;
            }
            if (historyItem.object() != null) {
                int n = historyItem.object().kind();
                if (n == 5 || n == 12) {
                    if (historyItem.object().deleted()) {
                        this.undeleteCurrentItem();
                        return;
                    }
                    this.setTextFieldStrings();
                    this.setTextFieldsVisible(true);
                    return;
                }
                if (n == 0 || n == 1 || n == 2 || n == 3) {
                    if (historyItem.object().deleted()) {
                        this.undeleteCurrentItem();
                        return;
                    }
                    this.fMode = n;
                    this.editEquation();
                    return;
                }
                if (n == 6 || n == 7 || n == 8) {
                    if (this.inLeftElipsis(mouseEvent.getX())) {
                        ((FPPointSet)historyItem.object()).decrementSelectedPoint();
                        this.fAxes.repaint();
                        this.repaint();
                        return;
                    }
                    if (this.inRightElipsis(mouseEvent.getX())) {
                        ((FPPointSet)historyItem.object()).incrementSelectedPoint();
                        this.fAxes.repaint();
                        this.repaint();
                        return;
                    }
                }
            }
            if (this.fMode == 0 || this.fMode == 2 || this.fMode == 1 || this.fMode == 3) {
                this.editEquation();
                return;
            }
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        if (this.fCurrentItem == -1) {
            return;
        }
        FPObject fPObject = this.fItemList[this.fCurrentItem].object();
        if (fPObject == null) {
            return;
        }
        if (fPObject.kind() == 5 || fPObject.kind() == 12) {
            fPObject.setEqString(this.fText.getText());
        }
    }

    public void newPolarEquation(String string, String string2) {
        FPRPNConverter fPRPNConverter = new FPRPNConverter("r", "T");
        char c = fPRPNConverter.getDepVar(string);
        char c2 = fPRPNConverter.getIndepVar(string);
        if (c2 != 'T') {
            utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_error__independent_variable_must_be_t_in_polar_coordinates"));
            return;
        }
        if (c != 'r') {
            utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_error__dependent_variable_must_be_r_in_polar_coordinates"));
            return;
        }
        this.setTextFieldsVisible(false);
        this.fAxes.mode(0);
        this.fGrapher.toolbar().mode(1);
        this.fGrapher.toolbar().repaint();
        FPPolarEquation fPPolarEquation = new FPPolarEquation(string, string2, this.fGrapher.colorPalette().nextColor(), this.fAxes);
        if (!fPPolarEquation.badEquation()) {
            this.fAxes.addToList(fPPolarEquation);
            this.fAxes.drawBackground();
            this.fAxes.requestFocus();
        } else {
            this.fAxes.selectLast();
        }
    }

    public void newEquation(String string) {
        if (FPCondEquation.isCondEquation(string)) {
            FPCondEquation fPCondEquation = new FPCondEquation(string, this.fGrapher.colorPalette().nextColor(), this.fAxes);
            if (fPCondEquation.badEquation()) {
                utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_syntax_error_in_conditional_expression"));
                return;
            }
            this.setTextFieldsVisible(false);
            this.fAxes.mode(0);
            this.fGrapher.toolbar().mode(1);
            this.fGrapher.toolbar().repaint();
            this.fAxes.addToList(fPCondEquation);
            this.fAxes.drawBackground();
            this.fAxes.requestFocus();
            return;
        }
        char c = this.fAxes.currentIndepVar();
        char c2 = this.fAxes.currentDepVar();
        FPRPNConverter fPRPNConverter = new FPRPNConverter(String.valueOf(c2), String.valueOf(c));
        char c3 = fPRPNConverter.getDepVar(string);
        char c4 = fPRPNConverter.getIndepVar(string);
        if (c2 != c3 || c != c4) {
            int n = this.fAxes.variables().whichIndex(c3, c4);
            if (n >= 0) {
                this.fAxes.currentVar(n);
            } else {
                DefineVarPrompt defineVarPrompt = new DefineVarPrompt(this.fAxes.parent(), string, c3, c4);
                ((Component)defineVarPrompt).setVisible(true);
                this.setTextFieldsVisible(false);
                this.fAxes.mode(0);
                this.fGrapher.toolbar().mode(1);
                this.fGrapher.toolbar().repaint();
                return;
            }
        }
        this.setTextFieldsVisible(false);
        this.fAxes.mode(0);
        this.fGrapher.toolbar().mode(1);
        this.fGrapher.toolbar().repaint();
        FPEquation fPEquation = new FPEquation(string, this.fGrapher.colorPalette().nextColor(), this.fAxes);
        if (!fPEquation.badEquation()) {
            this.fAxes.addToList(fPEquation);
            this.fAxes.drawBackground();
            this.fAxes.requestFocus();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private void undeleteCurrentItem() {
        block14: {
            block13: {
                block12: {
                    if (this.fCurrentItem < 0) {
                        return;
                    }
                    if (this.fCurrentItem >= this.fNumItems) {
                        return;
                    }
                    if (this.fItemList[this.fCurrentItem].object() == null) {
                        return;
                    }
                    if (!this.fAxes.polarMode()) break block12;
                    switch (this.fItemList[this.fCurrentItem].object().kind()) {
                        case 0: 
                        case 2: 
                        case 4: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: {
                            utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_error__this_type_of_object_may_not_be_undeleted_in_polar_coordinates"));
                            return;
                        }
                        case 6: {
                            if (!(this.fItemList[this.fCurrentItem].object() instanceof FPPolarPointSet)) {
                                utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_error__a_cartesian_point_set_may_not_be_undeleted_in_polar_coordinates"));
                                return;
                            }
                            break block13;
                        }
                        default: {
                            if (!this.fItemList[this.fCurrentItem].object().deleted()) return;
                            break;
                        }
                    }
                    break block14;
                }
                switch (this.fItemList[this.fCurrentItem].object().kind()) {
                    case 1: 
                    case 3: {
                        utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_error__polar_objects_may_not_be_undeleted_in_cartesian_coordinates"));
                        return;
                    }
                    case 6: {
                        if (!(this.fItemList[this.fCurrentItem].object() instanceof FPPolarPointSet)) break;
                        utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_error__polar_objects_may_not_be_undeleted_in_cartesian_coordinates"));
                        return;
                    }
                }
            }
            if (!this.fItemList[this.fCurrentItem].object().deleted()) return;
        }
        this.fItemList[this.fCurrentItem].object().deleted(false);
        this.fAxes.selectObject(this.fItemList[this.fCurrentItem].object());
        this.fAxes.drawBackground();
        this.fAxes.repaint();
        this.repaint();
        this.fAxes.requestFocus();
    }

    public void doParametric(String string, String string2, int n) {
        FPRPNConverter fPRPNConverter = new FPRPNConverter("x", "t");
        char c = fPRPNConverter.getIndepVar(string);
        if (c != 't') {
            utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_error__independent_variable_must_be_t_for_parametric_equations"));
            return;
        }
        c = fPRPNConverter.getIndepVar(string2);
        if (c != 't') {
            utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_error__independent_variable_must_be_t_for_parametric_equations"));
            return;
        }
        GenerateTFrame generateTFrame = new GenerateTFrame(this.fAxes, this.fGrapher, string, string2, n);
        ((Component)generateTFrame).setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        switch (this.fMode) {
            case 0: {
                this.newEquation(this.fText.getText());
                return;
            }
            case 2: {
                this.doParametric(this.fTextA.getText(), this.fTextB.getText(), 2);
                break;
            }
            case 3: {
                this.doParametric(this.fTextA.getText(), this.fTextB.getText(), 3);
                break;
            }
            case 1: {
                this.newPolarEquation(this.fTextA.getText(), this.fTextB.getText());
                break;
            }
            default: {
                this.setTextFieldsVisible(false);
                this.fAxes.mode(0);
                this.fGrapher.toolbar().mode(1);
                this.fGrapher.toolbar().repaint();
                this.fAxes.requestFocus();
                return;
            }
        }
        this.setTextFieldsVisible(false);
        this.fAxes.mode(0);
        this.fGrapher.toolbar().mode(1);
        this.fGrapher.toolbar().repaint();
        this.fAxes.drawBackground();
        this.fAxes.requestFocus();
    }

    public void setTranslateUD(double d) {
        if (this.fNumItems < 1) {
            return;
        }
        this.fItemList[this.fNumItems - 1].xFormID(1);
        this.fItemList[this.fNumItems - 1].xFormVal(d);
    }

    public void setTranslateLR(double d) {
        if (this.fNumItems < 1) {
            return;
        }
        this.fItemList[this.fNumItems - 1].xFormID(2);
        this.fItemList[this.fNumItems - 1].xFormVal(d);
    }

    public void setMirrorX(double d) {
        if (this.fNumItems < 1) {
            return;
        }
        this.fItemList[this.fNumItems - 1].xFormID(5);
        this.fItemList[this.fNumItems - 1].xFormVal(d);
    }

    public void setMirrorY(double d) {
        if (this.fNumItems < 1) {
            return;
        }
        this.fItemList[this.fNumItems - 1].xFormID(6);
        this.fItemList[this.fNumItems - 1].xFormVal(d);
    }

    public void setMirrorXY() {
        if (this.fNumItems < 1) {
            return;
        }
        this.fItemList[this.fNumItems - 1].xFormID(7);
    }

    public void setStretchLR(double d, double d2) {
        if (this.fNumItems < 1) {
            return;
        }
        this.fItemList[this.fNumItems - 1].xFormID(4);
        this.fItemList[this.fNumItems - 1].anchorVal(d);
        this.fItemList[this.fNumItems - 1].xFormVal(d2);
    }

    public void setStretchUD(double d, double d2) {
        if (this.fNumItems < 1) {
            return;
        }
        this.fItemList[this.fNumItems - 1].xFormID(3);
        this.fItemList[this.fNumItems - 1].anchorVal(d);
        this.fItemList[this.fNumItems - 1].xFormVal(d2);
    }

    public void setCurrentItemXForm() {
        this.fItemList[this.fNumItems - 1].xFormID(8);
    }

    public boolean inFocus() {
        return this.fTextFieldHasFocus;
    }

    public void focusGained(FocusEvent focusEvent) {
        this.fTextFieldHasFocus = true;
        this.fFieldInFocus = focusEvent.getComponent();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.fTextFieldHasFocus = false;
        this.fFieldInFocus = null;
    }

    public int getPrintedItemHeight(int n) {
        int n2 = 0;
        int n3 = n;
        while (n3 < this.fNumItems) {
            n2 = this.fItemList[n3].isDouble() ? (n2 += 40) : (n2 += 20);
            ++n3;
        }
        return n2;
    }

    public int printItems(Graphics graphics, MyInt myInt, int n) {
        int n2 = 0;
        int n3 = myInt.get();
        while (n2 < n) {
            if (n3 >= this.fNumItems) break;
            this.drawItemNumber(graphics, n3, true);
            if (this.fItemList[n3].isDouble()) {
                graphics.translate(0, 40);
                n2 += 40;
            } else {
                graphics.translate(0, 20);
                n2 += 20;
            }
            ++n3;
        }
        graphics.translate(0, -n2);
        myInt.set(n3);
        return n2;
    }

    public void print(PrintJob printJob) {
        Dimension dimension = printJob.getPageDimension();
        MyInt myInt = new MyInt(0);
        int n = 0;
        while (myInt.get() < this.fNumItems) {
            Graphics graphics = printJob.getGraphics();
            graphics.setClip(0, 0, dimension.width, dimension.height);
            graphics.setFont(kRegFont);
            graphics.drawString(String.valueOf(fp_resource.getString("str_graph_history_page_")) + ++n, 30, 30);
            graphics.translate(0, 50);
            this.printItems(graphics, myInt, dimension.height);
            graphics.dispose();
        }
    }

    public int numItems() {
        return this.fNumItems;
    }

    public void setNumItems(int n) {
        this.fNumItems = n;
    }

    public GraphHistoryFrame frame() {
        return this.fHistoryFrame;
    }

    public int scanForEvaluators(Evaluatable[] evaluatableArray, String[] stringArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.fNumItems) {
            FPObject fPObject = this.fItemList[n2].object();
            if (fPObject != null) {
                if (fPObject instanceof FPEquation) {
                    if (this.fItemList[n2].name() != null) {
                        FPEquation fPEquation = (FPEquation)fPObject;
                        evaluatableArray[n] = fPEquation;
                        stringArray[n] = this.fItemList[n2].name();
                        Master.equationDefined((int)utils._str2num(stringArray[n].substring(1, stringArray[n].length())));
                        ++n;
                    }
                } else if (this.fItemList[n2].name() != null) {
                    Master.otherDefined((int)utils._str2num(this.fItemList[n2].name().substring(1, this.fItemList[n2].name().length())));
                }
            }
            ++n2;
        }
        return n;
    }

    class TPTF
    extends FPTextField {
        TPTF(String string, int n) {
            super(string, n);
        }

        public String getText() {
            String string = super.getText();
            if (string.indexOf("\u0398") >= 0 || string.indexOf("\u03c0") >= 0) {
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                while (n < string.length()) {
                    if (string.charAt(n) == '\u0398') {
                        stringBuffer.append("T");
                    } else if (string.charAt(n) == '\u03c0') {
                        stringBuffer.append("P");
                    } else {
                        stringBuffer.append(string.charAt(n));
                    }
                    ++n;
                }
                string = stringBuffer.toString();
            }
            return string;
        }

        public void setText(String string) {
            if (string.indexOf("T") >= 0 || string.indexOf("P") >= 0) {
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                while (n < string.length()) {
                    if (string.charAt(n) == 'T') {
                        stringBuffer.append("\u0398");
                    } else if (string.charAt(n) == 'P') {
                        stringBuffer.append("\u03c0");
                    } else {
                        stringBuffer.append(string.charAt(n));
                    }
                    ++n;
                }
                string = stringBuffer.toString();
            }
            super.setText(string);
        }
    }

    private final class 1
    extends KeyAdapter {
        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40) {
                HistoryArea.this.handleArrowKeys(keyEvent.getKeyCode());
            }
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements TextListener {
        public void textValueChanged(TextEvent textEvent) {
            TPTF tPTF = (TPTF)textEvent.getSource();
            int n = tPTF.getCaretPosition();
            String string = tPTF.getText();
            int n2 = string.indexOf("P");
            if (n2 >= 0) {
                string = String.valueOf(string.substring(0, n2)) + "\u03c0" + string.substring(n2 + 1, string.length());
                tPTF.setText(string);
            }
            if ((n2 = string.indexOf("T")) >= 0) {
                string = String.valueOf(string.substring(0, n2)) + "\u0398" + string.substring(n2 + 1, string.length());
                tPTF.setText(string);
            }
            tPTF.setCaretPosition(n);
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements TextListener {
        public void textValueChanged(TextEvent textEvent) {
            TPTF tPTF = (TPTF)textEvent.getSource();
            String string = tPTF.getText();
            int n = tPTF.getCaretPosition();
            int n2 = string.indexOf("P");
            if (n2 >= 0) {
                string = String.valueOf(string.substring(0, n2)) + "\u03c0" + string.substring(n2 + 1, string.length());
                tPTF.setText(string);
            }
            if ((n2 = string.indexOf("T")) >= 0) {
                string = String.valueOf(string.substring(0, n2)) + "\u0398" + string.substring(n2 + 1, string.length());
                tPTF.setText(string);
            }
            tPTF.setCaretPosition(n);
        }

        /* synthetic */ 3() {
        }
    }
}

