/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPGrapher;

import com.questmsm.Utilities.fp_resource;
import com.questmsm.Utilities.utils;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Panel;

public class MiniAxes
extends Panel {
    private int fWidth;
    private int fHeight;
    private double fMajXTick;
    private double fMajYTick;
    private double fLogXBase = 10.0;
    private double fLogYBase = 10.0;
    private boolean fLogTickSpacing = true;
    private boolean fValid = true;
    protected Font fTickFont = new Font("Helvetica", 0, 5);
    protected FontMetrics fTickMetrics = this.getFontMetrics(this.fTickFont);
    private Color fBackgroundColor = Color.white;
    private Color fForegroundColor = Color.black;
    protected Color fTickLabelColor = Color.black;
    protected Color fGridColor = new Color(200, 200, 200);
    private int fOriginX = 0;
    private int fOriginY = 0;
    private int fminXPxl = 0;
    private int fmaxXPxl = 1;
    private int fminYPxl = 0;
    private int fmaxYPxl = 1;
    private double fMinX = 0.0;
    private double fMinY = 0.0;
    private double fMaxX = 1.0;
    private double fMaxY = 1.0;
    private double fPixelsPerXUnit = 1.0;
    private double fPixelsPerYUnit = 1.0;
    private boolean fLogX = false;
    private boolean fLogY = false;
    private boolean fPolarMode = false;
    private final int kMaxY = 2000;
    private String fInvalidString = "";

    public MiniAxes(double d, double d2, double d3, double d4, double d5) {
        this.setLayout(null);
        this.fMinX = d;
        this.fMinY = d3;
        this.fMaxX = d2;
        this.fMaxY = d4;
        this.fMajXTick = d5;
        this.fMajYTick = d5;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.fWidth = n3;
        this.fHeight = n4;
        this.setUpAxes();
    }

    public void setUpAxes() {
        if (this.getSize().width == 0) {
            return;
        }
        this.fOriginX = -((int)((double)this.fWidth * this.fMinX / (this.fMaxX - this.fMinX)));
        this.fPixelsPerXUnit = (double)(this.fWidth - 1) / (this.fMaxX - this.fMinX);
        this.fOriginY = this.fHeight + (int)((double)this.fHeight * this.fMinY / (this.fMaxY - this.fMinY));
        this.fPixelsPerYUnit = (double)(this.fHeight - 1) / (this.fMaxY - this.fMinY);
        this.fminXPxl = 0;
        this.fmaxXPxl = this.getSize().width;
        this.fminYPxl = this.getSize().height;
        this.fmaxYPxl = 0;
    }

    public int x2pxl(double d) {
        return this.fOriginX + (int)(d * this.fPixelsPerXUnit + 0.5);
    }

    public int y2pxl(double d) {
        double d2 = this.fOriginY - (int)(d * this.fPixelsPerYUnit + 0.5);
        if (d2 > 2000.0) {
            return 2000;
        }
        if (d2 < -2000.0) {
            return -2000;
        }
        return (int)d2;
    }

    public double pxl2x(int n) {
        return utils.truncate((double)(n - this.fOriginX) / this.fPixelsPerXUnit);
    }

    public double pxl2y(int n) {
        return utils.truncate((double)(this.fOriginY - n) / this.fPixelsPerYUnit);
    }

    public boolean logX() {
        return this.fLogX;
    }

    public boolean logY() {
        return this.fLogY;
    }

    public void logX(boolean bl) {
        this.fLogX = bl;
    }

    public void logY(boolean bl) {
        this.fLogY = bl;
    }

    public double minY() {
        if (this.fLogY) {
            return Math.pow(this.fLogYBase, this.fMinY);
        }
        return this.fMinY;
    }

    public double minX() {
        if (this.fLogX) {
            return Math.pow(this.fLogXBase, this.fMinX);
        }
        return this.fMinX;
    }

    public double maxY() {
        if (this.fLogY) {
            return Math.pow(this.fLogYBase, this.fMaxY);
        }
        return this.fMaxY;
    }

    public double maxX() {
        if (this.fLogX) {
            return Math.pow(this.fLogXBase, this.fMaxX);
        }
        return this.fMaxX;
    }

    public double xMajTick() {
        return this.fMajXTick;
    }

    public double yMajTick() {
        return this.fMajYTick;
    }

    public void minY(double d) {
        this.fMinY = this.fLogY ? utils.log(d, this.fLogYBase) : d;
    }

    public void minX(double d) {
        this.fMinX = this.fLogX ? utils.log(d, this.fLogXBase) : d;
    }

    public void maxY(double d) {
        this.fMaxY = this.fLogY ? utils.log(d, this.fLogYBase) : d;
    }

    public void maxX(double d) {
        this.fMaxX = this.fLogX ? utils.log(d, this.fLogXBase) : d;
    }

    public void xMajTick(double d) {
        this.fMajXTick = d;
    }

    public void yMajTick(double d) {
        this.fMajYTick = d;
    }

    public void polarMode(boolean bl) {
        this.fPolarMode = bl;
    }

    public boolean polarMode() {
        return this.fPolarMode;
    }

    public void drawPolarGridLines(Graphics graphics) {
        int n = this.x2pxl(0.0);
        int n2 = this.y2pxl(0.0);
        double d = this.fMaxY > this.fMaxX ? this.fMaxY * 1.5 : this.fMaxX * 1.5;
        graphics.setColor(this.fGridColor);
        double d2 = this.fMajXTick;
        while (d2 <= d) {
            int n3 = this.x2pxl(d2) - n;
            int n4 = n2 - this.y2pxl(d2);
            graphics.drawOval(n - n3, n2 - n4, 2 * n3, 2 * n4);
            d2 += this.fMajXTick;
        }
        graphics.setColor(Color.black);
        graphics.drawLine(this.x2pxl(0.0), this.fminYPxl, this.x2pxl(0.0), this.fmaxYPxl);
        graphics.drawLine(this.fminXPxl, this.y2pxl(0.0), this.fmaxXPxl, this.y2pxl(0.0));
    }

    public int numTicks(double d, double d2, double d3) {
        if (d3 <= 0.0) {
            return 10000;
        }
        return (int)((d2 - d) / d3);
    }

    private int yOrig() {
        int n = this.fOriginY;
        if (n <= 5 || n > this.getSize().height - 10) {
            n = this.getSize().height - 10;
        }
        return n;
    }

    private int xOrig() {
        int n = this.fOriginX;
        if (n < 10 || n > this.getSize().width) {
            n = 10;
        }
        return n;
    }

    private void drawLogXLines(Graphics graphics) {
        double d;
        int n = this.yOrig();
        double d2 = 0.1;
        if (this.fLogXBase == (double)((int)this.fLogXBase)) {
            d2 = 1.0 / this.fLogXBase;
        }
        double d3 = d = utils.findMin(this.fMinX, 1.0);
        while (d3 <= this.fMaxX) {
            double d4 = d2;
            while (d4 <= 0.999) {
                int n2 = this.x2pxl(d3 + utils.log(d4, this.fLogXBase));
                graphics.setColor(this.fGridColor);
                graphics.drawLine(n2, 0, n2, this.fHeight);
                graphics.setColor(this.fTickLabelColor);
                graphics.drawLine(n2, n - 1, n2, n);
                d4 += d2;
            }
            d3 += 1.0;
        }
    }

    private void drawRegXLines(Graphics graphics) {
        int n = this.yOrig();
        graphics.setColor(this.fGridColor);
        double d = utils.findMin(this.fMinX, this.fMajXTick);
        int n2 = this.fminYPxl;
        int n3 = this.fmaxYPxl;
        double d2 = d;
        while (d2 <= this.fMaxX) {
            int n4;
            int n5 = n4 = this.x2pxl(d2);
            graphics.drawLine(n5, n2, n4, n3);
            d2 += this.fMajXTick;
        }
        graphics.setColor(Color.black);
        double d3 = this.fMajXTick / 10.0;
        if (this.fLogX && this.fLogXBase == (double)((int)this.fLogXBase)) {
            d3 = this.fMajXTick / this.fLogXBase;
        }
        double d4 = d = utils.findMin(this.fMinX, d3);
        while (d4 <= this.fMaxX) {
            int n6 = this.x2pxl(d4);
            graphics.drawLine(n6, n - 2, n6, n);
            d4 += d3;
        }
    }

    private void drawLogYLines(Graphics graphics) {
        double d;
        int n = this.xOrig();
        double d2 = 0.1;
        if (this.fLogYBase == (double)((int)this.fLogYBase)) {
            d2 = 1.0 / this.fLogYBase;
        }
        double d3 = d = utils.findMin(this.fMinY, 1.0);
        while (d3 <= this.fMaxY) {
            double d4 = d2;
            while (d4 <= 0.999) {
                int n2 = this.y2pxl(d3 + utils.log(d4, this.fLogYBase));
                graphics.setColor(this.fGridColor);
                graphics.drawLine(0, n2, this.fWidth, n2);
                graphics.setColor(this.fTickLabelColor);
                graphics.drawLine(n - 1, n2, n + 1, n2);
                d4 += d2;
            }
            d3 += 1.0;
        }
    }

    private void drawRegYLines(Graphics graphics) {
        int n = this.xOrig();
        graphics.setColor(this.fGridColor);
        double d = utils.findMin(this.fMinY, this.fMajYTick);
        int n2 = this.fminXPxl;
        int n3 = this.fmaxXPxl;
        double d2 = d;
        while (d2 <= this.fMaxY) {
            int n4;
            int n5 = n4 = this.y2pxl(d2);
            graphics.drawLine(n2, n5, n3, n4);
            d2 += this.fMajYTick;
        }
        graphics.setColor(Color.black);
        double d3 = this.fMajYTick / 10.0;
        if (this.fLogY && this.fLogYBase == (double)((int)this.fLogYBase)) {
            d3 = this.fMajYTick / this.fLogYBase;
        }
        double d4 = d = utils.findMin(this.fMinY, d3);
        while (d4 <= this.fMaxY) {
            int n6 = this.y2pxl(d4);
            graphics.drawLine(n, n6, n + 2, n6);
            d4 += d3;
        }
    }

    private void drawLogXLabels(Graphics graphics) {
        double d;
        int n = this.yOrig();
        graphics.setFont(this.fTickFont);
        double d2 = d = utils.findMin(this.fMinX, 1.0);
        while (d2 <= this.fMaxX) {
            int n2 = this.x2pxl(d2);
            graphics.drawLine(n2, n - 1, n2, n + 1);
            String string = utils.num2str(d2);
            graphics.drawString(String.valueOf((int)this.fLogXBase), n2 - (int)((double)this.fTickMetrics.stringWidth(string) / 2.0) - this.fTickMetrics.stringWidth(String.valueOf((int)this.fLogXBase)), n + 11);
            graphics.drawString(string, n2 - (int)((double)this.fTickMetrics.stringWidth(string) / 2.0), n + 6);
            d2 += 1.0;
        }
    }

    private void drawRegXLabels(Graphics graphics) {
        double d;
        int n = this.yOrig();
        graphics.setFont(this.fTickFont);
        double d2 = d = utils.findMin(this.fMinX, this.fMajXTick);
        while (d2 <= this.fMaxX) {
            int n2 = this.x2pxl(d2);
            graphics.drawLine(n2, n - 1, n2, n + 1);
            String string = utils.num2str(d2);
            if (d2 != 0.0) {
                graphics.drawString(string, n2 - (int)((double)this.fTickMetrics.stringWidth(string) / 2.0), n + 6);
            }
            d2 += this.fMajXTick;
        }
    }

    private void drawLogYLabels(Graphics graphics) {
        double d;
        int n = this.xOrig();
        graphics.setFont(this.fTickFont);
        double d2 = d = utils.findMin(this.fMinY, 1.0);
        while (d2 <= this.fMaxY) {
            int n2 = this.y2pxl(d2);
            graphics.drawLine(n - 1, n2, n + 1, n2);
            String string = utils.num2str(d2);
            graphics.drawString(String.valueOf((int)this.fLogYBase), n - 2 - this.fTickMetrics.stringWidth(String.valueOf(string) + String.valueOf((int)this.fLogYBase)), n2 + 4);
            graphics.drawString(string, n - 2 - this.fTickMetrics.stringWidth(string), n2 + 2);
            d2 += 1.0;
        }
    }

    private void drawRegYLabels(Graphics graphics) {
        double d;
        int n = this.xOrig();
        graphics.setFont(this.fTickFont);
        double d2 = d = utils.findMin(this.fMinY, this.fMajYTick);
        while (d2 <= this.fMaxY) {
            int n2 = this.y2pxl(d2);
            graphics.drawLine(n - 1, n2, n + 1, n2);
            String string = utils.num2str(d2);
            if (d2 != 0.0) {
                graphics.drawString(string, n - 2 - this.fTickMetrics.stringWidth(string), n2 + 2);
            }
            d2 += this.fMajYTick;
        }
    }

    public void drawGridLines(Graphics graphics) {
        if (this.polarMode()) {
            this.drawPolarGridLines(graphics);
            return;
        }
        if (this.fLogX && this.fLogTickSpacing) {
            this.drawLogXLines(graphics);
        } else {
            this.drawRegXLines(graphics);
        }
        if (this.fLogY && this.fLogTickSpacing) {
            this.drawLogYLines(graphics);
        } else {
            this.drawRegYLines(graphics);
        }
    }

    protected void drawTickLabels(Graphics graphics) {
        int n = this.xOrig();
        int n2 = this.yOrig();
        graphics.setColor(Color.black);
        if (this.fLogX && this.fLogTickSpacing) {
            this.drawLogXLabels(graphics);
        } else {
            this.drawRegXLabels(graphics);
        }
        if (this.fLogY && this.fLogTickSpacing) {
            this.drawLogYLabels(graphics);
        } else {
            this.drawRegYLabels(graphics);
        }
        graphics.drawLine(n, this.fminYPxl, n, this.fmaxYPxl);
        graphics.drawLine(this.fminXPxl, n2, this.fmaxXPxl, n2);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public synchronized void paint(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        graphics.setColor(this.fBackgroundColor);
        graphics.fillRect(0, 0, this.fWidth, this.fHeight);
        this.checkValid();
        if (this.fValid) {
            this.drawGridLines(graphics);
            this.drawTickLabels(graphics);
        }
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        if (!this.fValid) {
            graphics.setColor(Color.red);
            int n = utils.drawCenteredString(graphics, fp_resource.getString("str_invalid_settings"), this.fWidth, 100);
            utils.drawCenteredString(graphics, this.fInvalidString, this.fWidth, n);
        }
    }

    public void logXBase(double d) {
        this.fLogXBase = d;
    }

    public void logYBase(double d) {
        this.fLogYBase = d;
    }

    public double logXBase() {
        return this.fLogXBase;
    }

    public double logYBase() {
        return this.fLogYBase;
    }

    public void logTickSpacing(boolean bl) {
        this.fLogTickSpacing = bl;
    }

    public boolean logTickSpacing() {
        return this.fLogTickSpacing;
    }

    public boolean checkValid() {
        int n = 20;
        this.fValid = true;
        if (this.fMinX >= this.fMaxX) {
            this.fValid = false;
            this.fInvalidString = fp_resource.getString("str_axes_min_ge_max");
        }
        if (this.fMinY >= this.fMaxY) {
            this.fValid = false;
            this.fInvalidString = this.polarMode() ? "r <= 0" : fp_resource.getString("str_axes_min_ge_max");
        }
        if (!this.fLogX && !this.fLogY) {
            if (this.fMajXTick <= 0.0) {
                this.fValid = false;
                this.fInvalidString = fp_resource.getString("str_axes_ticks_se_zero");
            } else if ((this.fMaxX - this.fMinX) / this.fMajXTick > (double)n) {
                this.fValid = false;
                this.fInvalidString = fp_resource.getString("str_too_many_x_grid_lines");
            }
            if (this.fMajYTick <= 0.0) {
                this.fValid = false;
                this.fInvalidString = fp_resource.getString("str_axes_ticks_se_zero");
            } else if ((this.fMaxY - this.fMinY) / this.fMajYTick > (double)n) {
                this.fValid = false;
                this.fInvalidString = fp_resource.getString("str_too_many_y_grid_lines");
            }
        }
        if (this.fLogX) {
            if (!this.fLogTickSpacing) {
                if (this.fMajXTick <= 0.0) {
                    this.fValid = false;
                    this.fInvalidString = fp_resource.getString("str_axes_ticks_se_zero");
                } else if ((this.fMaxX - this.fMinX) / this.fMajXTick > (double)n) {
                    this.fValid = false;
                    this.fInvalidString = fp_resource.getString("str_too_many_x_grid_lines");
                }
            }
        } else if (this.fMajXTick <= 0.0) {
            this.fValid = false;
            this.fInvalidString = fp_resource.getString("str_axes_ticks_se_zero");
        } else if ((this.fMaxX - this.fMinX) / this.fMajXTick > (double)n) {
            this.fValid = false;
            this.fInvalidString = fp_resource.getString("str_too_many_x_grid_lines");
        }
        if (this.fLogY) {
            if (!this.fLogTickSpacing) {
                if (this.fMajYTick <= 0.0) {
                    this.fValid = false;
                    this.fInvalidString = fp_resource.getString("str_axes_ticks_se_zero");
                } else if ((this.fMaxY - this.fMinY) / this.fMajYTick > (double)n) {
                    this.fValid = false;
                    this.fInvalidString = fp_resource.getString("str_too_many_y_grid_lines");
                }
            }
        } else if (this.fMajYTick <= 0.0) {
            this.fValid = false;
            this.fInvalidString = fp_resource.getString("str_axes_ticks_se_zero");
        } else if ((this.fMaxY - this.fMinY) / this.fMajYTick > (double)n) {
            this.fValid = false;
            this.fInvalidString = this.polarMode() ? fp_resource.getString("str_too_many_r_grid_lines") : fp_resource.getString("str_too_many_y_grid_lines");
        }
        if (this.fMinX == -1.23456123) {
            this.fValid = false;
            this.fInvalidString = fp_resource.getString("str_min_x_invalid");
        } else if (this.fMaxX == -1.23456123) {
            this.fValid = false;
            this.fInvalidString = fp_resource.getString("str_max_x_invalid");
        } else if (this.fMinY == -1.23456123) {
            this.fValid = false;
            this.fInvalidString = fp_resource.getString("str_min_y_invalid");
        } else if (this.fMaxY == -1.23456123) {
            this.fValid = false;
            this.fInvalidString = fp_resource.getString("str_max_y_invalid");
        }
        return this.fValid;
    }
}

