/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPGrapher;

import com.questmsm.FPGrapher.FPAxes;
import com.questmsm.FPGrapher.Grapher;
import com.questmsm.FunctionProbe.Master;
import com.questmsm.Utilities.DialogSuperClass;
import com.questmsm.Utilities.fp_resource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Graphics;

public class MirrorFrame
extends DialogSuperClass {
    private FPAxes fAxes;
    private Grapher fFP;
    private int fMode;
    private static final int left = 50;
    private static final int top = 40;
    private static final int width = 120;

    public MirrorFrame(FPAxes fPAxes, Grapher grapher) {
        super(grapher);
        this.setTitle(fp_resource.getString("str_mirror"));
        this.fAxes = fPAxes;
        this.fFP = grapher;
        this.setBounds(0, 0, 220, 220 + Master.gSmallTop);
        this.setLayout(null);
        this.add(this.fOK);
        this.fOK.setBounds(45, 180 + Master.gSmallTop, 60, 18);
        this.add(this.fCancel);
        this.fCancel.setBounds(115, 180 + Master.gSmallTop, 60, 18);
        this.fMode = 8;
    }

    public void doYes() {
        this.fAxes.mode(this.fMode);
        ((Component)this).setVisible(false);
    }

    public void doCancel() {
        this.fFP.setToolbarMode(1);
        this.fAxes.mode(0);
        ((Component)this).setVisible(false);
    }

    public void drawAxes(Graphics graphics) {
        int n = 40 + Master.gSmallTop;
        graphics.setColor(Color.white);
        graphics.fillRect(50, n, 120, 120);
        graphics.setColor(Color.black);
        graphics.drawLine(50, n + 60, 170, n + 60);
        graphics.drawLine(110, n, 110, n + 120);
        graphics.drawLine(50, n + 120, 170, n);
        switch (this.fMode) {
            case 8: {
                graphics.drawLine(109, n, 109, n + 120);
                graphics.drawLine(111, n, 111, n + 120);
                break;
            }
            case 9: {
                graphics.drawLine(50, n + 60 - 1, 170, n + 60 - 1);
                graphics.drawLine(50, n + 60 + 1, 170, n + 60 + 1);
                break;
            }
            case 10: {
                graphics.drawLine(49, n + 120, 169, n);
                graphics.drawLine(51, n + 120, 171, n);
                break;
            }
        }
    }

    public boolean onXAxis(int n, int n2) {
        int n3 = 40 + Master.gSmallTop;
        if (n < 50 || n > 170) {
            return false;
        }
        if (n2 < n3 + 60 - 3) {
            return false;
        }
        return n2 <= n3 + 60 + 3;
    }

    public boolean onYAxis(int n, int n2) {
        int n3 = 40 + Master.gSmallTop;
        if (n2 < n3 || n2 > n3 + 120) {
            return false;
        }
        if (n < 107) {
            return false;
        }
        return n <= 113;
    }

    public boolean onYEqualsX(int n, int n2) {
        int n3 = 40 + Master.gSmallTop;
        if (n2 < n3 || n2 > n3 + 120) {
            return false;
        }
        if (n < 50 || n > 170) {
            return false;
        }
        n2 -= n3;
        return Math.abs((n2 = 120 - n2) - (n -= 50)) < 3;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (this.onXAxis(n, n2)) {
            if (this.fMode == 9) {
                return true;
            }
            this.fMode = 9;
            this.repaint();
        } else if (this.onYAxis(n, n2)) {
            if (this.fMode == 8) {
                return true;
            }
            this.fMode = 8;
            this.repaint();
        } else if (this.onYEqualsX(n, n2)) {
            if (this.fMode == 10) {
                return true;
            }
            this.fMode = 10;
            this.repaint();
        }
        return super.mouseDown(event, n, n2);
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        return this.mouseDown(event, n, n2);
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.drawString(String.valueOf(fp_resource.getString("str_mirror_along")) + ":", 20, 20 + Master.gSmallTop);
        this.drawAxes(graphics);
        super.paint(graphics);
    }
}

