/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPGrapher;

import com.questmsm.FPGrapher.FPAxes;
import com.questmsm.FPGrapher.FPObject;
import com.questmsm.FPGrapher.Grapher;
import com.questmsm.Utilities.fp_resource;

public class UndoGrapher {
    private FPAxes fAxes;
    private Grapher fGrapher;
    private FPObject fObject;
    private static final int kMaxObjects = 20;
    private FPObject[] fDeletedObjects = new FPObject[20];
    private int fNumDeletedObjects = 0;
    private boolean fUndoable;
    private String fUndoString;

    public UndoGrapher(Grapher grapher, FPAxes fPAxes) {
        this.fAxes = fPAxes;
        this.fGrapher = grapher;
        this.fObject = null;
        this.fUndoable = false;
        this.fUndoString = "";
    }

    public String undoString() {
        return this.fUndoString;
    }

    public boolean undoable() {
        return this.fUndoable;
    }

    public void undoable(boolean bl) {
        this.fUndoable = bl;
        if (!bl) {
            this.fObject = null;
            this.fUndoString = "";
        }
    }

    public void objectsDeleted(FPObject[] fPObjectArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            this.fDeletedObjects[n2] = fPObjectArray[n2];
            ++n2;
        }
        this.fNumDeletedObjects = n;
        this.undoable(true);
        this.fUndoString = fp_resource.getString("str_undo_delete_objects");
    }

    public void objectCreated(FPObject fPObject) {
        this.undoable(true);
        this.fObject = fPObject;
        this.fUndoString = fp_resource.getString("str_undo_create_object");
    }

    public void undo() {
        if (this.fUndoString.equals(fp_resource.getString("str_undo_delete_objects"))) {
            int n = 0;
            while (n < this.fNumDeletedObjects) {
                this.fDeletedObjects[n].deleted(false);
                if (n == 0) {
                    this.fAxes.selectObject(this.fDeletedObjects[n]);
                } else {
                    this.fAxes.selectObjectWithoutClearing(this.fDeletedObjects[n]);
                }
                ++n;
            }
            this.undoable(false);
            this.fAxes.selectLast();
            this.fAxes.drawBackground();
            this.fAxes.repaint();
            return;
        }
        if (this.fUndoString.equals(fp_resource.getString("str_undo_create_object"))) {
            this.fAxes.objectList().removeFromList(this.fObject);
            this.fAxes.history().erradicateLast();
            this.fAxes.selectLast();
            this.fAxes.deleteSelection();
            this.undoable(false);
            this.fAxes.selectLast();
            this.fAxes.drawBackground();
            this.fAxes.repaint();
            return;
        }
    }
}

