/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPGrapher;

import com.questmsm.FPGrapher.GraphVariables;
import com.questmsm.FPGrapher.Grapher;
import com.questmsm.FPGrapher.VariablesDialog;
import com.questmsm.Utilities.DialogField;
import com.questmsm.Utilities.DialogSuperClass;
import com.questmsm.Utilities.fp_resource;
import com.questmsm.Utilities.utils;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.util.Enumeration;
import java.util.Vector;

public class VariablesDialog
extends DialogSuperClass
implements TextListener,
FocusListener,
ActionListener {
    private Grapher fGrapher;
    private GraphVariables fVars;
    private int fCurrentVar;
    private Button fDone;
    private Button fDelete;
    private static final Font fFont = new Font("serif", 1, 12);
    private FontMetrics fMetrics = this.getFontMetrics(fFont);
    private String oldDepVar = "";
    private String oldDepLabel = "";
    private String oldDepUnits = "";
    private String oldIndepVar = "";
    private String oldIndepLabel = "";
    private String oldIndepUnits = "";
    private String fEq = null;
    EntriesPanel xEntries;
    EntriesPanel yEntries;
    GraphPanel graphPanel;
    ArrowButtons arrows;

    public VariablesDialog(Grapher grapher) {
        super(grapher);
        this.fGrapher = grapher;
        this.doInit();
        this.addWindowListener(new 1());
    }

    public VariablesDialog(Grapher grapher, String string, char c, char c2) {
        this(grapher);
        this.fEq = string;
        this.fVars.add(c, c2, "", "", "", "", this.fGrapher);
        this.fCurrentVar = this.fVars.numVars() - 1;
    }

    void doInit() {
        this.setTitle(fp_resource.getString("str_variables"));
        this.fCurrentVar = this.fGrapher.axes().currentVar();
        this.fVars = this.fGrapher.axes().variables();
        this.arrows = new ArrowButtons();
        this.arrows.addActionListener(new 2());
        this.xEntries = new EntriesPanel();
        this.yEntries = new EntriesPanel();
        this.graphPanel = new GraphPanel();
        this.xEntries.addFocusListener(this);
        this.yEntries.addFocusListener(this);
        this.xEntries.addActionListener(this);
        this.yEntries.addActionListener(this);
        this.xEntries.var.addTextListener(this);
        this.yEntries.var.addTextListener(this);
        3 var1_1 = new 3(new BorderLayout());
        var1_1.add((Component)this.graphPanel, "Center");
        var1_1.add((Component)this.xEntries, "South");
        Panel panel = new Panel(new BorderLayout(0, 40));
        panel.add((Component)this.yEntries, "North");
        panel.add((Component)this.makeButtonsPanel(), "South");
        4 var3_3 = new 4(new FlowLayout(1, 0, 0));
        var3_3.add(panel);
        var3_3.add(var1_1);
        5 var4_4 = new 5(new BorderLayout(0, 10));
        var4_4.add((Component)var3_3, "Center");
        var4_4.add((Component)this.arrows, "South");
        this.setLayout(new FlowLayout(1, 5, 5));
        this.add(var4_4);
        this.pack();
        this.setTextFields();
    }

    void arrowClicked(ActionEvent actionEvent) {
        if (this.arrows.clicked == 1) {
            --this.fCurrentVar;
            this.setTextFields();
        } else {
            ++this.fCurrentVar;
            this.setTextFields();
        }
    }

    Panel makeButtonsPanel() {
        this.fOK.setLabel(fp_resource.getString("str_save"));
        this.fDelete = new Button(fp_resource.getString("str_delete"));
        this.fDone = new Button(fp_resource.getString("str_done"));
        Panel panel = new Panel(new GridLayout(3, 1, 0, 10));
        panel.add(this.fOK);
        panel.add(this.fDelete);
        panel.add(this.fDone);
        Panel panel2 = new Panel(new FlowLayout(1, 4, 4));
        panel2.add(panel);
        return panel2;
    }

    public void setTextFields() {
        if (this.fCurrentVar == this.fVars.numVars()) {
            this.xEntries.setName("");
            this.xEntries.setUnit("");
            this.xEntries.setVar("");
            this.yEntries.setName("");
            this.yEntries.setUnit("");
            this.yEntries.setVar("");
        } else {
            this.yEntries.setVar(String.valueOf(this.fVars.depVar(this.fCurrentVar)));
            this.yEntries.setName(this.fVars.depLabel(this.fCurrentVar));
            this.yEntries.setUnit(this.fVars.depUnits(this.fCurrentVar));
            this.xEntries.setVar(String.valueOf(this.fVars.indepVar(this.fCurrentVar)));
            this.xEntries.setName(this.fVars.indepLabel(this.fCurrentVar));
            this.xEntries.setUnit(this.fVars.indepUnits(this.fCurrentVar));
        }
        this.setLabels();
        this.handleHighlights();
    }

    public void update(Graphics graphics) {
        ((Container)this).paint(graphics);
    }

    private void delete() {
        if (this.fGrapher.axes().isVarIndexUsed(this.fCurrentVar)) {
            utils.showErrorDialog(this.fGrapher, fp_resource.getString("str_error__these_variables_are_currently_used_and_may_not_be_deleted"));
            return;
        }
        this.fVars.delete(this.fCurrentVar, this.fGrapher);
        this.setTextFields();
    }

    public void textValueChanged(TextEvent textEvent) {
        String string;
        int n;
        TextField textField = (TextField)textEvent.getSource();
        if (textField == this.yEntries.var && (n = (string = this.yEntries.getVar()).length()) > 1) {
            this.yEntries.setVar(string.substring(n - 1, n));
        }
        if (textField == this.xEntries.var && (n = (string = this.xEntries.getVar()).length()) > 1) {
            this.xEntries.setVar(string.substring(n - 1, n));
        }
        this.handleHighlights();
    }

    private void doAddNew() {
        char c;
        char c2 = this.yEntries.getVar().charAt(0);
        if (this.fVars.isDefined(c2, c = this.xEntries.getVar().charAt(0))) {
            String string = fp_resource.getString("str_error__variable_pair_dd_already_defined");
            Object[] objectArray = new Object[]{String.valueOf(c2), String.valueOf(c)};
            string = utils.sprintf(string, objectArray);
            utils.showErrorDialog(this.fGrapher, string);
            return;
        }
        this.fVars.add(c2, c, this.yEntries.getName(), this.yEntries.getUnit(), this.xEntries.getName(), this.xEntries.getUnit(), this.fGrapher);
        this.fCurrentVar = this.fVars.numVars() - 1;
        this.handleHighlights();
    }

    public void doYes() {
        if (this.yEntries.getVar().length() != 1 || this.xEntries.getVar().length() != 1) {
            utils.showErrorDialog(this.fGrapher, fp_resource.getString("str_error__must_have_variables_defined"));
            return;
        }
        if (this.fCurrentVar == this.fVars.numVars()) {
            this.doAddNew();
            return;
        }
        char c = this.yEntries.getVar().charAt(0);
        char c2 = this.xEntries.getVar().charAt(0);
        if (c != this.fVars.depVar(this.fCurrentVar) || c2 != this.fVars.indepVar(this.fCurrentVar)) {
            utils.showErrorDialog(this.fGrapher, fp_resource.getString("str_error__cant_change_the_variables_names"));
            return;
        }
        this.fVars.change(this.fCurrentVar, this.yEntries.getName(), this.yEntries.getUnit(), this.xEntries.getName(), this.xEntries.getUnit());
    }

    public void handleHighlights() {
        if (this.xEntries.getVar().length() != 1 || this.yEntries.getVar().length() != 1) {
            this.fOK.setEnabled(false);
        } else {
            this.fOK.setEnabled(true);
        }
        if (this.fCurrentVar == 0 || this.fCurrentVar == this.fVars.numVars()) {
            this.fDelete.setEnabled(false);
        } else {
            this.fDelete.setEnabled(true);
        }
        this.arrows.showLeft = this.fCurrentVar != 0;
        this.arrows.showRight = this.fCurrentVar != this.fVars.numVars();
        this.arrows.repaint();
        this.xEntries.var.setEnabled(this.arrows.showRight ^ true);
        this.yEntries.var.setEnabled(this.arrows.showRight ^ true);
    }

    public boolean action(Event event, Object object) {
        if (event.target instanceof Button) {
            if (event.target == this.fDone) {
                if (this.fCurrentVar < this.fVars.numVars()) {
                    this.fGrapher.axes().currentVarForce(this.fCurrentVar);
                    this.fGrapher.axes().repaint();
                }
                if (this.fEq != null) {
                    ((Component)this).setVisible(false);
                    this.fGrapher.history().newEquation(this.fEq);
                }
                super.doYes();
            } else if (event.target == this.fDelete) {
                this.delete();
            }
        }
        return super.action(event, object);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.doYes();
    }

    public void focusGained(FocusEvent focusEvent) {
        ((TextField)focusEvent.getSource()).selectAll();
    }

    public void setLabels() {
        this.graphPanel.xlbl = this.xEntries.getName();
        this.graphPanel.xunit = this.xEntries.getUnit();
        this.graphPanel.xvar = this.xEntries.getVar();
        this.graphPanel.ylbl = this.yEntries.getName();
        this.graphPanel.yunit = this.yEntries.getUnit();
        this.graphPanel.yvar = this.yEntries.getVar();
        this.graphPanel.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        TextField textField = (TextField)focusEvent.getSource();
        textField.select(0, 0);
        if (textField == this.yEntries.name || textField == this.yEntries.unit) {
            if (textField == this.yEntries.name && textField.getText().equals(this.oldDepLabel)) {
                return;
            }
            if (textField == this.yEntries.unit && textField.getText().equals(this.oldDepUnits)) {
                return;
            }
            this.oldDepLabel = this.xEntries.getName();
            this.oldDepUnits = this.xEntries.getUnit();
        } else if (textField == this.yEntries.var) {
            String string = this.yEntries.getVar();
            if (string.equals(this.oldDepVar)) {
                return;
            }
            int n = string.length();
            if (n > 1) {
                this.yEntries.setVar(string.substring(n - 1, n));
            }
            this.oldDepVar = string;
        } else if (textField == this.xEntries.name || textField == this.xEntries.unit) {
            if (textField == this.xEntries.name && textField.getText().equals(this.oldIndepLabel)) {
                return;
            }
            if (textField == this.xEntries.unit && textField.getText().equals(this.oldIndepUnits)) {
                return;
            }
            this.oldIndepLabel = this.xEntries.getName();
            this.oldIndepUnits = this.xEntries.getUnit();
        } else if (textField == this.xEntries.var) {
            String string = this.xEntries.getVar();
            int n = string.length();
            if (string.equals(this.oldIndepVar)) {
                return;
            }
            if (n > 1) {
                this.xEntries.setVar(string.substring(n - 1, n));
            }
            this.oldIndepVar = string;
        }
        this.setLabels();
        this.handleHighlights();
    }

    private final class 1
    extends WindowAdapter {
        public void windowActivated(WindowEvent windowEvent) {
            VariablesDialog.this.yEntries.name.requestFocus();
        }

        public void windowClosing(WindowEvent windowEvent) {
            VariablesDialog.this.doNo();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            VariablesDialog.this.arrowClicked(actionEvent);
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    extends Panel {
        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        /* synthetic */ 3(LayoutManager layoutManager) {
            super(layoutManager);
        }
    }

    private final class 4
    extends Panel {
        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        /* synthetic */ 4(LayoutManager layoutManager) {
            super(layoutManager);
        }
    }

    private final class 5
    extends Panel {
        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        /* synthetic */ 5(LayoutManager layoutManager) {
            super(layoutManager);
        }
    }

    class EntriesPanel
    extends Panel {
        DialogField name = new DialogField("", 8);
        DialogField unit = new DialogField("", 8);
        DialogField var = new DialogField("", 8);

        public EntriesPanel() {
            Panel panel = new Panel(new GridLayout(3, 2, 0, 5));
            panel.add(new Label(fp_resource.getString("str_name"), 2));
            panel.add(this.name);
            panel.add(new Label(fp_resource.getString("str_unit"), 2));
            panel.add(this.unit);
            panel.add(new Label(fp_resource.getString("str_var"), 2));
            panel.add(this.var);
            this.setLayout(new FlowLayout(1));
            this.add(panel);
        }

        public void addActionListener(ActionListener actionListener) {
            this.name.addActionListener(actionListener);
            this.unit.addActionListener(actionListener);
            this.var.addActionListener(actionListener);
        }

        public void removeActionListener(ActionListener actionListener) {
            this.name.removeActionListener(actionListener);
            this.unit.removeActionListener(actionListener);
            this.var.removeActionListener(actionListener);
        }

        public void addFocusListener(FocusListener focusListener) {
            this.name.addFocusListener(focusListener);
            this.unit.addFocusListener(focusListener);
            this.var.addFocusListener(focusListener);
        }

        public void removeFocusListener(FocusListener focusListener) {
            this.name.removeFocusListener(focusListener);
            this.unit.removeFocusListener(focusListener);
            this.var.removeFocusListener(focusListener);
        }

        public String getName() {
            return this.name.getText();
        }

        public String getUnit() {
            return this.unit.getText();
        }

        public String getVar() {
            return this.var.getText();
        }

        public void setName(String string) {
            ((TextComponent)this.name).setText(string);
        }

        public void setUnit(String string) {
            ((TextComponent)this.unit).setText(string);
        }

        public void setVar(String string) {
            ((TextComponent)this.var).setText(string);
        }
    }

    class ArrowButtons
    extends Panel {
        boolean showRight = true;
        boolean showLeft;
        boolean rightDown;
        boolean leftDown;
        Color color = Color.blue;
        final int W = 20;
        final int H = 30;
        final int NONE = 0;
        final int LEFT = 1;
        final int RIGHT = 2;
        int clicked = 0;
        Vector actionListeners = new Vector();
        final Dimension dim = new Dimension(100, 30);

        ArrowButtons() {
            this.addMouseListener(new 6(this));
        }

        void handleMousePressed(MouseEvent mouseEvent) {
            this.rightDown = false;
            this.leftDown = false;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (this.showLeft && this.insideLeft(n, n2)) {
                this.clicked = 1;
                this.leftDown = true;
            } else if (this.showRight && this.insideRight(n, n2)) {
                this.clicked = 2;
                this.rightDown = true;
            } else {
                this.clicked = 0;
            }
            this.repaint();
        }

        boolean insideLeft(int n, int n2) {
            Dimension dimension = this.getSize();
            return n >= dimension.width / 2 - (dimension.width / 4 - 10) - 23 && n <= dimension.width / 2 - (dimension.width / 4 - 10);
        }

        boolean insideRight(int n, int n2) {
            Dimension dimension = this.getSize();
            return n >= dimension.width / 2 + (dimension.width / 4 - 10) && n <= dimension.width / 2 + (dimension.width / 4 - 10) + 23;
        }

        void handleMouseClicked(MouseEvent mouseEvent) {
            this.rightDown = false;
            this.leftDown = false;
            if (this.clicked != 0) {
                ActionEvent actionEvent = new ActionEvent(this, 1001, "");
                this.fireActionPerformed(actionEvent);
            }
            this.repaint();
        }

        public void addActionListener(ActionListener actionListener) {
            this.actionListeners.addElement(actionListener);
        }

        public void removeActionListener(ActionListener actionListener) {
            this.actionListeners.removeElement(actionListener);
        }

        void fireActionPerformed(ActionEvent actionEvent) {
            Enumeration enumeration = this.actionListeners.elements();
            while (enumeration.hasMoreElements()) {
                ((ActionListener)enumeration.nextElement()).actionPerformed(actionEvent);
            }
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void drawRightArrow(Graphics graphics, Dimension dimension) {
            graphics.setColor(this.color);
            if (!this.showRight) {
                graphics.setColor(Color.gray);
            } else if (this.rightDown) {
                graphics.setColor(Color.black);
            }
            int n = dimension.width / 2 + (dimension.width / 4 - 10);
            int n2 = 15;
            graphics.fillRect(n, n2 - 5, 10, 10);
            n += 23;
            int n3 = 0;
            while (n3 < 14) {
                graphics.drawLine(n, n2 + n3, n--, n2 - n3);
                ++n3;
            }
        }

        public void drawLeftArrow(Graphics graphics, Dimension dimension) {
            graphics.setColor(this.color);
            if (!this.showLeft) {
                graphics.setColor(Color.gray);
            } else if (this.leftDown) {
                graphics.setColor(Color.black);
            }
            int n = dimension.width / 2 - (dimension.width / 4 - 10);
            int n2 = dimension.height / 2;
            graphics.fillRect(n - 10, n2 - 5, 10, 10);
            n -= 23;
            int n3 = 0;
            while (n3 < 14) {
                graphics.drawLine(n + n3, n2 + n3, n + n3, n2 - n3);
                ++n3;
            }
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            this.drawRightArrow(graphics, dimension);
            this.drawLeftArrow(graphics, dimension);
        }

        public Dimension getPreferredSize() {
            return this.dim;
        }
    }

    class GraphPanel
    extends Panel {
        String xlbl = "";
        String xvar = "";
        String xunit = "";
        String ylbl = "";
        String yvar = "";
        String yunit = "";
        final Dimension dim = new Dimension(210, 210);
        final int axis_length = 170;
        Image yimg;

        public Dimension getPreferredSize() {
            return this.dim;
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, dimension.width - 1, dimension.height - 1);
            graphics.setColor(Color.black);
            graphics.drawLine(25, 14, 25, 184);
            graphics.drawLine(25, 184, 195, 184);
            this.paintAxisLabels(graphics);
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        private void makeYLabel() {
            this.yimg = null;
            if (this.ylbl.length() == 0) {
                return;
            }
            String string = this.ylbl;
            if (this.yunit.length() > 0) {
                string = String.valueOf(string) + " (" + this.yunit + ")";
            }
            int n = VariablesDialog.this.fMetrics.stringWidth(string);
            int n2 = 18;
            Image image = this.createImage(n, n2);
            Graphics graphics = image.getGraphics();
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, n, n2);
            graphics.setColor(Color.black);
            graphics.setFont(fFont);
            graphics.drawString(string, 0, n2 - 3);
            int[] nArray = new int[n * n2];
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
            try {
                pixelGrabber.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                return;
            }
            this.yimg = this.createImage(new MemoryImageSource(n2, n, utils.rot90Pixels(nArray, n, n2), 0, n2));
        }

        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            return true;
        }

        String makeXLabel() {
            if (this.xlbl.length() > 0 && this.xunit.length() > 0) {
                return String.valueOf(this.xlbl) + " (" + this.xunit + ")";
            }
            return this.xlbl;
        }

        private void paintAxisLabels(Graphics graphics) {
            int n = 10;
            int n2 = 14;
            int n3 = 25;
            int n4 = 184;
            int n5 = 25;
            graphics.setColor(Color.black);
            graphics.setFont(fFont);
            String string = this.makeXLabel();
            int n6 = VariablesDialog.this.fMetrics.stringWidth(string);
            graphics.drawString(string, n3 + (170 - n6) / 2, n4 + 3 * n / 2);
            this.makeYLabel();
            if (this.yimg != null) {
                graphics.drawImage(this.yimg, n5 - 2 * n, n2 + (170 - this.yimg.getHeight(this)) / 2, this);
            }
            graphics.drawString(this.yvar, n3 - 2, n2 - 2);
            graphics.drawString(this.xvar, n3 + 170 + 3, n2 + 170 + 3);
        }

        GraphPanel() {
        }
    }
}

