/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPTable;

import com.questmsm.FPTable.Column;
import com.questmsm.FPTable.TablePanel;
import com.questmsm.FPTable.TableRow;
import java.awt.Color;
import java.awt.Dimension;
import java.io.Serializable;

public class TableFileData
implements Serializable {
    private int NumColumns;
    private int NumRows;
    private int[] NumIntervals;
    private int[][] IntervalLoc;
    private String[] EquationStr;
    private String[] LabelStr;
    private int[] NumDecPlaces;
    private boolean[] Scientific;
    private char[] DepVar;
    private int[] Width;
    private int[] NudgeFactor;
    private int[] WidgetMode;
    private boolean[] Active;
    private boolean[] Dependent;
    private double[] AccumStart;
    private int[] EqType;
    private boolean[] Linked;
    private Color[] Colors;
    private int[] ID;
    private int idCounter;
    private boolean[][] IsNum;
    private String[][] Str;
    private double[][] Num;
    private int[][] Dependents;
    private int[] NumColsDependsOn;
    private int windowTop;
    private int windowLeft;
    private int windowHeight;
    private int windowWidth;
    private int varmode;
    private boolean displayasequations;
    private int runawayfill;
    private boolean allowiteratefill;
    private boolean allowcomplexfill;
    private boolean showdependencies;
    private boolean actonlinks;
    private int numdecimalplaces;
    private int DX;
    private int DY;
    private int xTagColID;
    private int yTagColID;
    private int rTagColID;
    private int thTagColID;

    public TableFileData(TablePanel tablePanel) {
        Dimension dimension = tablePanel.parent().getSize();
        this.windowHeight = dimension.height;
        this.windowWidth = dimension.width;
        this.windowTop = tablePanel.parent().getLocation().y;
        this.windowLeft = tablePanel.parent().getLocation().x;
        this.NumColumns = tablePanel.numColumns();
        this.NumRows = tablePanel.numRows();
        this.xTagColID = tablePanel.getVarColID("x");
        this.yTagColID = tablePanel.getVarColID("y");
        this.rTagColID = tablePanel.getVarColID("r");
        this.thTagColID = tablePanel.getVarColID("theta");
        this.actonlinks = tablePanel.actOnLinks();
        this.numdecimalplaces = tablePanel.numDecimalPlaces();
        this.showdependencies = tablePanel.showDependencies();
        this.allowcomplexfill = tablePanel.allowComplexFill();
        this.allowiteratefill = tablePanel.allowIterateFill();
        this.runawayfill = tablePanel.runawayFill();
        this.displayasequations = tablePanel.displayAsEquations();
        this.DX = tablePanel.dx;
        this.DY = tablePanel.dy;
        this.varmode = tablePanel.varMode();
        if (this.NumColumns > 0) {
            this.NumIntervals = new int[this.NumColumns];
            this.IntervalLoc = new int[this.NumColumns][];
            this.EquationStr = new String[this.NumColumns];
            this.LabelStr = new String[this.NumColumns];
            this.NumDecPlaces = new int[this.NumColumns];
            this.Scientific = new boolean[this.NumColumns];
            this.DepVar = new char[this.NumColumns];
            this.Width = new int[this.NumColumns];
            this.NudgeFactor = new int[this.NumColumns];
            this.WidgetMode = new int[this.NumColumns];
            this.Active = new boolean[this.NumColumns];
            this.Dependent = new boolean[this.NumColumns];
            this.AccumStart = new double[this.NumColumns];
            this.EqType = new int[this.NumColumns];
            this.Linked = new boolean[this.NumColumns];
            this.IsNum = new boolean[this.NumColumns][];
            this.Str = new String[this.NumColumns][];
            this.Num = new double[this.NumColumns][];
            this.Dependents = new int[this.NumColumns][20];
            this.NumColsDependsOn = new int[this.NumColumns];
            this.ID = new int[this.NumColumns];
            this.Colors = new Color[this.NumColumns];
            this.idCounter = Column.gIdentifier;
            Column column = tablePanel.firstCol();
            int n = 0;
            while (n < this.NumColumns) {
                int n2;
                this.NumIntervals[n] = column.numIntervals();
                this.EquationStr[n] = column.equationRow().str();
                this.LabelStr[n] = column.labelRow().str();
                this.NumDecPlaces[n] = column.numDecimalPlaces();
                this.Scientific[n] = column.sciNotation();
                this.DepVar[n] = column.depVar();
                this.Width[n] = column.width();
                this.NudgeFactor[n] = column.nudgeFactor();
                this.WidgetMode[n] = column.widgetMode();
                this.Active[n] = column.active();
                this.Dependent[n] = column.dependent();
                this.NumColsDependsOn[n] = column.getDepColIndices(this.Dependents[n]);
                this.AccumStart[n] = column.accumStart();
                this.EqType[n] = column.equationType();
                this.Linked[n] = column.linked();
                this.Colors[n] = column.foregroundColor();
                this.ID[n] = column.getID();
                if (this.NumIntervals[n] > 1) {
                    this.IntervalLoc[n] = new int[this.NumIntervals[n] - 1];
                    n2 = 0;
                    while (n2 < this.NumIntervals[n] - 1) {
                        this.IntervalLoc[n][n2] = column.intervalLoc(n2);
                        ++n2;
                    }
                }
                this.IsNum[n] = new boolean[this.NumRows];
                this.Str[n] = new String[this.NumRows];
                this.Num[n] = new double[this.NumRows];
                n2 = 0;
                while (n2 < this.NumRows) {
                    TableRow tableRow = column.row(n2);
                    this.IsNum[n][n2] = tableRow.isNum();
                    this.Str[n][n2] = tableRow.str();
                    this.Num[n][n2] = tableRow.num();
                    ++n2;
                }
                column = column.next;
                ++n;
            }
        }
    }

    public void setTableData(TablePanel tablePanel) {
        int n = 0;
        tablePanel.parent().setVisible(false);
        tablePanel.parent().setBounds(this.windowLeft, this.windowTop, this.windowWidth, this.windowHeight);
        tablePanel.clearTable();
        tablePanel.numRows(this.NumRows);
        Column.gIdentifier = this.idCounter;
        int n2 = 0;
        while (n2 < this.NumColumns) {
            Column column = tablePanel.appendColumn(n, this.Width[n2], this.NumDecPlaces[n2]);
            n += this.Width[n2];
            int n3 = 0;
            while (n3 < this.NumIntervals[n2] - 1) {
                column.addInterval(this.IntervalLoc[n2][n3]);
                ++n3;
            }
            column.equationRow().set(this.EquationStr[n2]);
            column.labelRow().set(this.LabelStr[n2]);
            column.depVar(this.DepVar[n2]);
            column.nudgeFactor(this.NudgeFactor[n2]);
            column.widgetMode(this.WidgetMode[n2]);
            column.active(this.Active[n2]);
            column.dependent(this.Dependent[n2]);
            column.accumStart(this.AccumStart[n2]);
            column.equationType(this.EqType[n2]);
            column.foregroundColor(this.Colors[n2]);
            column.setDependencies(this.NumColsDependsOn[n2], this.Dependents[n2]);
            column.setID(this.ID[n2]);
            if (this.Linked[n2]) {
                tablePanel.linkColumn(column);
            }
            int n4 = 0;
            while (n4 < this.NumRows) {
                if (this.IsNum[n2][n4]) {
                    column.row(n4).set(this.Num[n2][n4]);
                } else {
                    column.row(n4).set(this.Str[n2][n4]);
                }
                ++n4;
            }
            if (this.Scientific[n2]) {
                column.sciNotation(true);
            }
            ++n2;
        }
        tablePanel.setVarColID("x", this.xTagColID);
        tablePanel.setVarColID("y", this.yTagColID);
        tablePanel.setVarColID("r", this.rTagColID);
        tablePanel.setVarColID("theta", this.thTagColID);
        tablePanel.dx = this.DX;
        tablePanel.dy = this.DY;
        tablePanel.panel().setHScrollVal(this.DX);
        tablePanel.panel().setVScrollVal(this.DY);
        tablePanel.varMode(this.varmode);
        tablePanel.displayAsEquations(this.displayasequations);
        tablePanel.runawayFill(this.runawayfill);
        tablePanel.allowIterateFill(this.allowiteratefill);
        tablePanel.allowComplexFill(this.allowcomplexfill);
        tablePanel.showDependencies(this.showdependencies);
        tablePanel.numDecimalPlaces(this.numdecimalplaces);
        tablePanel.actOnLinks(this.actonlinks);
    }
}

