/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPTable;

import com.questmsm.FPTable.Column;
import com.questmsm.FPTable.Table;
import com.questmsm.FPTable.TablePanel;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Scrollbar;

public class TableHolder
extends Panel {
    private Table fTable;
    private Scrollbar fVert;
    private Scrollbar fHoriz;
    private TablePanel fPanel;
    private int fWidth;
    private int fHeight;
    private boolean fInitialized = false;
    private boolean fGrowing = false;
    private Image fActiveChainImage;
    private Image fInactiveChainImage;

    public TableHolder(Table table, Color color) {
        this.fTable = table;
        this.setBackground(color);
        this.fPanel = new TablePanel(this, this.fTable, color);
        this.setLayout(null);
        this.fVert = new Scrollbar(1);
        this.add(this.fVert);
        this.fHoriz = new Scrollbar(0);
        this.add(this.fHoriz);
        this.add(this.fPanel);
    }

    public boolean handleEvent(Event event) {
        if (event.id == 605 || event.id == 602 || event.id == 601 || event.id == 604 || event.id == 603) {
            int n;
            int n2 = this.fHoriz.getValue();
            if (n2 > this.fHoriz.getMaximum()) {
                n2 = this.fHoriz.getMaximum();
            }
            if ((n = this.fVert.getValue()) > this.fVert.getMaximum()) {
                n = this.fVert.getMaximum();
            }
            this.fPanel.translate(n2, n);
            return true;
        }
        return super.handleEvent(event);
    }

    public TablePanel panel() {
        return this.fPanel;
    }

    private boolean inGrowTag(int n, int n2) {
        int n3 = Column.dataTop();
        if (n2 < n3 - 5) {
            return false;
        }
        if (n2 > n3) {
            return false;
        }
        return n >= this.getSize().width - 15;
    }

    public void makeChainImages() {
        this.fActiveChainImage = this.createImage(15, 35);
        this.fInactiveChainImage = this.createImage(15, 35);
        this.paintChain(this.fActiveChainImage.getGraphics(), Color.black);
        this.paintChain(this.fInactiveChainImage.getGraphics(), Color.gray);
    }

    private void paintChain(Graphics graphics, Color color) {
        graphics.setColor(color);
        int n = -1;
        int n2 = 2;
        graphics.fillRect(n + 8, 0, 2, 35);
        int n3 = 0;
        while (n3 < 3) {
            graphics.fillRoundRect(n + 5, n2 + n3 * 11, 8, 9, 6, 6);
            ++n3;
        }
        graphics.setColor(Color.white);
        int n4 = 0;
        while (n4 < 3) {
            graphics.drawLine(n + 7, n2 + n4 * 11 + 3, n + 10, n2 + n4 * 11 + 3);
            graphics.drawLine(n + 7, n2 + n4 * 11 + 4, n + 10, n2 + n4 * 11 + 4);
            graphics.drawLine(n + 7, n2 + n4 * 11 + 1, n + 7, n2 + n4 * 11 + 6);
            graphics.drawLine(n + 10, n2 + n4 * 11 + 1, n + 10, n2 + n4 * 11 + 6);
            ++n4;
        }
    }

    private boolean inChain(int n, int n2) {
        if (n < this.getSize().width - 15) {
            return false;
        }
        if (n > this.getSize().width) {
            return false;
        }
        if (n2 < 0) {
            return false;
        }
        return n2 <= this.fActiveChainImage.getHeight(this);
    }

    public void paint(Graphics graphics) {
        int n = Column.dataTop();
        graphics.setColor(Color.white);
        graphics.fillRect(this.getSize().width - 15, 0, 15, n);
        if (this.fPanel.numLinkedCols() > 0) {
            if (this.fPanel.actOnLinks()) {
                graphics.drawImage(this.fActiveChainImage, this.getSize().width - 15, 3, this);
            } else {
                graphics.drawImage(this.fInactiveChainImage, this.getSize().width - 15, 3, this);
            }
        }
        graphics.setColor(Color.black);
        graphics.drawRect(this.getSize().width - 15, 0, 15, n);
        graphics.fillRect(this.getSize().width - 15, n - 4, 15, 4);
    }

    public void setHScrollVal(int n) {
        this.fHoriz.setValue(n);
    }

    public void setVScrollVal(int n) {
        this.fVert.setValue(n);
    }

    public int maxHScrollVal() {
        return this.fHoriz.getMaximum();
    }

    public void setScrollSettings() {
        int n = this.fVert.getSize().width;
        int n2 = this.getSize().height - n;
        int n3 = this.getSize().width - n;
        int n4 = this.fPanel.maxHeight();
        int n5 = this.fPanel.maxWidth();
        this.fVert.setMinimum(0);
        this.fVert.setMaximum(n4);
        this.fVert.setVisibleAmount(n2);
        this.fHoriz.setMinimum(0);
        this.fHoriz.setMaximum(n5);
        this.fHoriz.setVisibleAmount(n3);
        this.fVert.setUnitIncrement(15);
        this.fHoriz.setUnitIncrement(64);
        this.fVert.setBlockIncrement(n2 - Column.dataTop());
        this.fHoriz.setBlockIncrement(n3);
    }

    public int scrollToBottom() {
        int n = this.fVert.getSize().width;
        int n2 = this.getSize().height - n;
        int n3 = this.fVert.getMaximum();
        this.fVert.setValue(n3 - n2);
        return n3 - n2;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.fPanel.setBounds(0, 0, n3 - 15, n4 - 15, false);
        this.fVert.setBounds(n3 - 15, Column.dataTop(), 15, n4 - 15 - Column.dataTop());
        this.fHoriz.setBounds(0, n4 - 15, n3 - 15, 15);
        this.setScrollSettings();
        this.fPanel.translate(this.fHoriz.getValue(), this.fVert.getValue());
        this.fPanel.requestFocus();
        if (!this.fInitialized) {
            this.fInitialized = true;
            this.makeChainImages();
        }
    }

    public void setBounds() {
        this.setBounds(this.getLocation().x, this.getLocation().y, this.getSize().width, this.getSize().height);
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.fGrowing) {
            this.fGrowing = false;
            if (n2 < 45) {
                n2 = 45;
            }
            Column.dataTop(n2);
            this.setBounds();
            this.repaint();
            this.fPanel.redraw(false);
            return false;
        }
        if (this.inChain(n, n2) && this.fPanel.numLinkedCols() > 0) {
            boolean bl = this.fPanel.actOnLinks();
            this.fPanel.actOnLinks(bl ^ true);
            this.fTable.updateMenus();
            this.repaint();
            this.fPanel.repaint();
        }
        return super.mouseDown(event, n, n2);
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.fGrowing) {
            if (n2 < 45) {
                n2 = 45;
            }
            this.fPanel.drawDataLine(n2);
            return false;
        }
        return super.mouseDrag(event, n, n2);
    }

    public boolean growing() {
        return this.fGrowing;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (this.inGrowTag(n, n2)) {
            if (n2 < 45) {
                n2 = 45;
            }
            this.fGrowing = true;
            return false;
        }
        return super.mouseDown(event, n, n2);
    }

    public boolean mouseMove(Event event, int n, int n2) {
        if (this.inGrowTag(n, n2)) {
            this.setCursor(Cursor.getPredefinedCursor(8));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
        return super.mouseMove(event, n, n2);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

